/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.job;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.HandleFailedJobsCmd;
import kd.bos.workflow.engine.impl.cmd.job.DeleteMovedDeadLetterJobListener;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.job.FailedJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.FailedJobEntityManager;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.engine.impl.util.ToDoJobUtil;

public class ScheduleHandleFailedJobsCmd
implements Command<Void> {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String KEY_HANDLEFAILEDJOBS = "workflow.schedule.handleFailedJobs";
    private static final String KEY_MOVETERMINALPROCESSDEADJOBTOFAILEDJOB = "workflow.schedule.moveTerminalProcessDeadJobToFailedJob";
    private static final String VALUE_RETENTIONTIME = "retentionTime";
    private static final String VALUE_STARTINGTIME = "startingTime";
    private static final String VALUE_SCOPE = "scope";
    private static final String ENDTIME = "endtime";
    private static final String WF_CONFCENTER = "wf_confcenter";
    private static final String VALUE = "value";

    public Void execute(CommandContext commandContext) {
        this.activateDeadLetterJobs(commandContext);
        this.handleFailedJobs(commandContext);
        this.moveTerminalProcessDeadJobToFailedJob(commandContext);
        return null;
    }

    private void activateDeadLetterJobs(CommandContext commandContext) {
        DeadLetterJobEntityManager deadJobManager = commandContext.getDeadLetterJobEntityManager();
        EntityQueryBuilder queryBuilder = deadJobManager.createQueryBuilder();
        String fields = String.format("%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s", "jobType", "executionId", "processInstanceId", "processDefinitionId", "businessKey", "entityNumber", "jobHandlerType", "jobHandlerConfiguration", "elementId", "operation", "retries", "exceptionStackMessage");
        queryBuilder.setSelectFields(fields).addFilter("jobHandlerType", (Object)"async-todo").addFilter("retries", "<", (Object)5).setLimit(50);
        List deadJobs = deadJobManager.findByQueryBuilder(queryBuilder);
        if (deadJobs == null || deadJobs.isEmpty()) {
            return;
        }
        for (DeadLetterJobEntity job : deadJobs) {
            try {
                ToDoJobUtil.reExecuteDeadLetterJob(commandContext, job);
                commandContext.getDeadLetterJobEntityManager().delete((Entity)job);
            }
            catch (Exception e) {
                this.log.info(String.format("\u6fc0\u6d3b\u5f02\u5e38\u6d41\u7a0b\u5931\u8d25\uff01\u539f\u56e0\uff1a%s", WfUtils.getExceptionStacktrace(e)));
            }
        }
    }

    private void handleFailedJobs(CommandContext commandContext) {
        Map<String, Object> value = this.getValue(KEY_HANDLEFAILEDJOBS, 3, 10);
        if (value == null || value.isEmpty()) {
            return;
        }
        Long startingTime = (Long)value.get(VALUE_STARTINGTIME);
        Integer scope = (Integer)value.get(VALUE_SCOPE);
        Integer retentionTime = (Integer)value.get(VALUE_RETENTIONTIME);
        Date endTime = this.getTargetTime(startingTime, scope);
        Long timeStamp = this.getMaxDeleteTime();
        if (null == timeStamp) {
            return;
        }
        Date maxDeleteTime = this.getTargetTime(timeStamp, -retentionTime.intValue());
        if (maxDeleteTime.compareTo(endTime) > 0) {
            Date startingDate = new Date(startingTime);
            QFilter filter0 = new QFilter(ENDTIME, "is not null", null);
            QFilter filter1 = new QFilter(ENDTIME, ">=", (Object)startingDate);
            QFilter filter2 = new QFilter(ENDTIME, "<=", (Object)endTime);
            QFilter[] filters = new QFilter[]{filter0, filter1, filter2};
            DynamicObjectCollection businesskeyCollection = QueryServiceHelper.query((String)"wf_historicalprocesses", (String)"businesskey", (QFilter[])filters);
            ArrayList<String> businesskeyList = new ArrayList<String>(businesskeyCollection.size());
            for (DynamicObject dynamicObject : businesskeyCollection) {
                businesskeyList.add((String)dynamicObject.get("businesskey"));
            }
            FailedJobEntityManager failedJobManager = commandContext.getFailedJobEntityManager();
            EntityQueryBuilder queryBuilder = failedJobManager.createQueryBuilder().setSelectFields("id").setSelectFields("processinstanceid,jobtype");
            queryBuilder.addFilter("retries", "<", (Object)5);
            queryBuilder.addFilter("businessKey", "in", businesskeyList).setLimit(50).orderBy("occurrencetime");
            List failedJobs = failedJobManager.findByQueryBuilder(queryBuilder);
            if (failedJobs == null || failedJobs.isEmpty()) {
                HashMap<String, Object> valuMap = new HashMap<String, Object>(3);
                valuMap.put(VALUE_STARTINGTIME, endTime);
                valuMap.put(VALUE_SCOPE, scope);
                valuMap.put(VALUE_RETENTIONTIME, retentionTime);
                this.updateValue(KEY_HANDLEFAILEDJOBS, valuMap);
                return;
            }
            ArrayList<Long> ids = new ArrayList<Long>(failedJobs.size());
            for (FailedJobEntity job : failedJobs) {
                ids.add(job.getId());
            }
            new HandleFailedJobsCmd(ids).execute(commandContext);
            FailedJobEntity failedJob = (FailedJobEntity)failedJobs.get(failedJobs.size() - 1);
            Long processInstanceId = failedJob.getProcessInstanceId();
            QFilter f1 = new QFilter("id", "=", (Object)processInstanceId);
            QFilter[] filters2 = new QFilter[]{f1};
            DynamicObjectCollection endTimeCollection = QueryServiceHelper.query((String)"wf_historicalprocesses", (String)ENDTIME, (QFilter[])filters2);
            HashMap<String, Object> valuMap = new HashMap<String, Object>(3);
            valuMap.put(VALUE_STARTINGTIME, ((DynamicObject)endTimeCollection.get(0)).get(ENDTIME));
            valuMap.put(VALUE_SCOPE, scope);
            valuMap.put(VALUE_RETENTIONTIME, retentionTime);
            this.updateValue(KEY_HANDLEFAILEDJOBS, valuMap);
        }
    }

    private void moveTerminalProcessDeadJobToFailedJob(CommandContext commandContext) {
        Map<String, Object> value = this.getValue(KEY_MOVETERMINALPROCESSDEADJOBTOFAILEDJOB, 3, 10);
        if (value == null || value.isEmpty()) {
            return;
        }
        Long startingTime = (Long)value.get(VALUE_STARTINGTIME);
        Integer scope = (Integer)value.get(VALUE_SCOPE);
        Integer retentionTime = (Integer)value.get(VALUE_RETENTIONTIME);
        Date endTime = this.getTargetTime(startingTime, scope);
        Long timeStamp = this.getMaxDeleteTime();
        if (null == timeStamp) {
            return;
        }
        Date maxDeleteTime = this.getTargetTime(timeStamp, -retentionTime.intValue());
        if (maxDeleteTime.compareTo(endTime) > 0) {
            Date startingDate = new Date(startingTime);
            String lang = String.valueOf(RequestContext.get().getLang());
            FailedJobEntityManager failedJobManager = commandContext.getFailedJobEntityManager();
            String fields = "D.FID, D.FBUSINESSKEY, D.FEXECUTIONID, D.FPROCESSINSTANCEID, D.FPROCDEFID, D.FELEMENTID, D.FOPERATION, D.FENTITYNUMBER, D.FTYPE, D.FHANDLERTYPE, D.FHANDLERCFG, D.FSOLUTION, D.FERRORCODE, D.FERRORTYPE, D.FROOTTRACENO, D.FEXCEPTIONMSG, D.FEXCEPTIONSTACKMSG, D.FCREATEDATE, D.FBIZTRACENO, DL.FNAME, DL.FENTRABILLNAME, DL.FSUBJECT, DL.FELEMENTNAME";
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ").append(fields).append(" FROM T_WF_DEADLETTERJOB D ");
            sb.append("INNER JOIN T_WF_DEADLETTERJOB_L DL ON D.FID = DL.FID AND DL.FLOCALEID = ? ");
            sb.append("INNER JOIN T_WF_HIPROCINST H ON D.FPROCESSINSTANCEID = H.FID ");
            sb.append("WHERE H.FENDTIME IS NOT NULL AND H.FENDTIME >= ? AND H.FENDTIME < ? ");
            Object[] params = new Object[]{lang, startingDate, endTime};
            ArrayList<Long> ids = new ArrayList<Long>();
            try (DataSet ds = DB.queryDataSet((String)"wf.engine.moveTerminalProcessDeadJobToFailedJob", (DBRoute)DBRoute.workflow, (String)sb.toString(), (Object[])params);){
                Iterator iter = ds.iterator();
                Long jobId = null;
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    jobId = row.getLong("FID");
                    if (!RuntimeUtil.isNeedToRemoveFailedJob((String)row.getString("FHANDLERTYPE"), (String)row.getString("FHANDLERCFG"))) continue;
                    failedJobManager.createFailedJobByDeadLetterJob(row);
                    ids.add(jobId);
                }
            }
            if (!ids.isEmpty()) {
                commandContext.addCloseListener((CommandContextCloseListener)new DeleteMovedDeadLetterJobListener(ids.toArray()));
            }
            HashMap<String, Object> valuMap = new HashMap<String, Object>(3);
            valuMap.put(VALUE_STARTINGTIME, endTime.getTime());
            valuMap.put(VALUE_SCOPE, scope);
            valuMap.put(VALUE_RETENTIONTIME, retentionTime);
            this.updateValue(KEY_MOVETERMINALPROCESSDEADJOBTOFAILEDJOB, valuMap);
        }
    }

    private void updateValue(String key, HashMap<String, Object> valueMap) {
        QFilter selectValueFilter = new QFilter("key", "=", (Object)key);
        QFilter[] selectValueFilters = new QFilter[]{selectValueFilter};
        DynamicObject value = BusinessDataServiceHelper.loadSingle((String)WF_CONFCENTER, (String)"id,value", (QFilter[])selectValueFilters);
        value.set(VALUE, (Object)JSONObject.toJSONString(valueMap));
        DynamicObject[] dynObjs = new DynamicObject[]{value};
        SaveServiceHelper.save((DynamicObject[])dynObjs);
    }

    private Long getMaxDeleteTime() {
        Date timeStamp = null;
        String maxDeleteSql = "SELECT MAX(FENDTIME) FENDTIME FROM T_WF_HIPROCINST;";
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.CalculateMaximumTime", (DBRoute)DBRoute.workflow, (String)maxDeleteSql, null);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                Row row = (Row)iter.next();
                timeStamp = row.getDate("FENDTIME");
            }
        }
        if (null == timeStamp) {
            return null;
        }
        return timeStamp.getTime();
    }

    private Date getTargetTime(Long startingTime, Integer scope) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(startingTime);
        c.add(6, scope);
        return c.getTime();
    }

    private Map<String, Object> getValue(String key, int scope, int retentionTime) {
        QFilter selectValueFilter = new QFilter("key", "=", (Object)key);
        QFilter[] selectValueFilters = new QFilter[]{selectValueFilter};
        DynamicObject value = QueryServiceHelper.queryOne((String)WF_CONFCENTER, (String)VALUE, (QFilter[])selectValueFilters);
        if (null == value || !String.valueOf(value.get(0)).contains(VALUE_STARTINGTIME)) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>(3);
            Date startingTime = null;
            String timeSql = "SELECT MIN(FENDTIME) FENDTIME FROM T_WF_HIPROCINST;";
            try (DataSet ds = DB.queryDataSet((String)"wf.engine.selectTime", (DBRoute)DBRoute.workflow, (String)timeSql, null);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    startingTime = row.getDate("FENDTIME");
                }
            }
            if (null == startingTime) {
                return null;
            }
            valueMap.put(VALUE_STARTINGTIME, startingTime.getTime());
            valueMap.put(VALUE_SCOPE, scope);
            valueMap.put(VALUE_RETENTIONTIME, retentionTime);
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)WF_CONFCENTER);
            DynamicObject dynObj = new DynamicObject((DynamicObjectType)type);
            dynObj.set("key", (Object)key);
            dynObj.set(VALUE, (Object)JSONObject.toJSONString(valueMap));
            DynamicObject[] dynObjs = new DynamicObject[]{dynObj};
            SaveServiceHelper.save((DynamicObject[])dynObjs);
            return valueMap;
        }
        return (Map)SerializationUtils.fromJsonString((String)value.get(VALUE).toString(), Map.class);
    }
}

