/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BaseElement;
import kd.bos.workflow.bpmn.model.BillSetting;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.dynamicpartial.DynamicModelPartial;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.model.AbstractProcessor;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.context.ModelProcessorContext;
import kd.bos.workflow.engine.impl.db.BatchSQLInfo;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntity;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillDynInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillDynInfoEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.BillPageAttributeConfigEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class BillSettingProcessor
extends AbstractProcessor {
    private static final String SUBJECT_PROPERTY = "subject.customSubject";
    private static final String BILLSETTING_PROPERTY = "billSetting";
    private static final String OPERATIONWHENSUBMIT = "/childShapes/[resourceId:%s]/properties/billSetting/operationWhenSubmit";
    private static final String OPERATIONWHENREJECT = "/childShapes/[resourceId:%s]/properties/billSetting/operationWhenReject";

    public void process(ModelProcessorContext context, Long modelId, DynamicModelPartial partial) {
    }

    public void process(ModelProcessorContext context, DynamicModelPartial dynPartial, Long procDefId) {
        try {
            CommandContext commandContext = Context.getCommandContext();
            UserTask flowElement = (UserTask)dynPartial.getFlowElement();
            BillSetting billSetting = flowElement.getBillSetting();
            List<BillPageAttributeConfigEntity> list = billSetting.getPageAttrConfig();
            List<BillPageAttributeConfigEntity> mobileList = billSetting.getMobilePageAttrConfig();
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
            this.savePageAttributeConfig(commandContext, flowElement, procDefId, list, userId, date, flowElement.getBillSetting().getFormKey());
            this.savePageAttributeConfig(commandContext, flowElement, procDefId, mobileList, userId, date, flowElement.getBillSetting().getMobilFormKey());
            this.saveDynInfo(commandContext, flowElement, procDefId, userId, date);
        }
        catch (Exception e) {
            throw new KDException(WFErrorCode.saveBillPageAttributeConfigError(), new Object[]{e.getMessage()});
        }
    }

    public void process(ModelProcessorContext context, DynamicModelPartial partial, Long procDefId, Long schemeId) {
        ResourceEntity rs;
        if (!BpmnModelUtil.instanceofAuditTask((String)partial.getFlowElement().getType())) {
            return;
        }
        CommandContext commandContext = Context.getCommandContext();
        DynamicConfigSchemeEntity entity = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(schemeId);
        if (entity != null && WfUtils.isNotEmpty(entity.getJsonPatchId()) && (rs = (ResourceEntity)commandContext.getResourceEntityManager().findById(entity.getJsonPatchId())) != null && rs.getData() != null) {
            AuditTask auditTask;
            BillSetting billSetting;
            String opWhenSubmit = String.format(OPERATIONWHENSUBMIT, partial.getFlowElement().getId());
            String opWhenReject = String.format(OPERATIONWHENREJECT, partial.getFlowElement().getId());
            String patch = rs.getData();
            if ((patch.indexOf(opWhenSubmit) > -1 || patch.indexOf(opWhenReject) > -1) && (billSetting = (auditTask = (AuditTask)partial.getFlowElement()).getBillSetting()) != null) {
                String operationWhenSubmit = billSetting.getOperationWhenSubmit();
                String operationWhenReject = billSetting.getOperationWhenReject();
                StringBuilder sb = new StringBuilder();
                sb.append(operationWhenSubmit).append(",").append(operationWhenReject);
                final String validateOperation = ",".equalsIgnoreCase(sb.toString()) ? " " : sb.toString();
                String sql = "UPDATE T_WF_TASK SET FVALIDATEOPERATION = ? WHERE FID=? ";
                String qSql = "SELECT a.FID FROM T_wf_task a,t_wf_execution b where b.FISSCOPE = '1' and b.FSCHEMEID = ? and b.fid=a.FPROCINSTID and a.FTASKDEFID = ?";
                List params = (List)DB.query((DBRoute)DBRoute.workflow, (String)qSql, (Object[])new Object[]{schemeId, auditTask.getId()}, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

                    public List<Object[]> handle(ResultSet rs) throws Exception {
                        ArrayList<Object[]> ids = new ArrayList<Object[]>();
                        try {
                            while (rs.next()) {
                                Object[] param = new Object[]{validateOperation, rs.getLong("FID")};
                                ids.add(param);
                            }
                        }
                        catch (SQLException e) {
                            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                        }
                        return ids;
                    }
                });
                commandContext.getTaskEntityManager().addBatchSQLInfo(new BatchSQLInfo(sql, params, Integer.valueOf(2000)));
            }
        }
    }

    private void savePageAttributeConfig(CommandContext commandContext, UserTask flowElement, Long procDefId, List<BillPageAttributeConfigEntity> list, Long userId, Date date, String pageNumber) {
        if (null != list && !list.isEmpty()) {
            for (BillPageAttributeConfigEntity entity : list) {
                entity.setNumber(flowElement.getEntityNumber());
                entity.setPagenumber(pageNumber);
                entity.setProcessdefinitionid(procDefId);
                entity.setTaskdefinitionkey(flowElement.getId());
                entity.setName(flowElement.getEntityName());
                commandContext.getBillPageAttributeConfigEntityManager().insert((Entity)entity);
            }
        }
    }

    private void saveDynInfo(CommandContext commandContext, UserTask flowElement, Long procDefId, Long userId, Date date) {
        BillDynInfoEntityImpl billDynInfoEntity = new BillDynInfoEntityImpl();
        billDynInfoEntity.setProcessDefinitionId(procDefId);
        billDynInfoEntity.setActivityId(flowElement.getId());
        if (null != flowElement.getBillSetting()) {
            billDynInfoEntity.setFormkey(flowElement.getBillSetting().getFormKey());
            billDynInfoEntity.setMobileFormkey(flowElement.getBillSetting().getMobilFormKey());
            billDynInfoEntity.setOperationWhenSave(flowElement.getBillSetting().getOperationWhenSave());
            billDynInfoEntity.setFieldModified(flowElement.getBillSetting().isFieldModified());
        }
        if (null != flowElement.getSubject() && !flowElement.getSubject().isEmpty()) {
            List subjects = flowElement.getSubject();
            String subjectsJsonString = SerializationUtils.toJsonString((Object)subjects);
            billDynInfoEntity.setSubject(subjectsJsonString);
        }
        billDynInfoEntity.setCreatorId(userId);
        billDynInfoEntity.setCreateDate(date);
        billDynInfoEntity.setModifierId(userId);
        billDynInfoEntity.setModifyDate(date);
        commandContext.getBillDynInfoEntityManager().insert((Entity)billDynInfoEntity);
    }

    public void updateBpmnModel(BpmnModel bpmnModel, List<AbstractEntity> entities) {
        BillDynInfoEntity billDynInfo = null;
        BillSetting billSetting = null;
        FlowElement flowElement = null;
        for (AbstractEntity entity : entities) {
            billDynInfo = (BillDynInfoEntity)entity;
            billSetting = this.returnBillSetting(billDynInfo);
            flowElement = bpmnModel.getFlowElement(billDynInfo.getActivityId());
            this.updateBpmnModelProperty((BaseElement)flowElement, BILLSETTING_PROPERTY, (Object)billSetting);
            this.updateBpmnModelProperty((BaseElement)flowElement, SUBJECT_PROPERTY, billDynInfo.getSubject());
        }
    }

    private List<BillPageAttributeConfigEntity> findBillPageAttrConfigsByCondition(Long processDefinitionId, String activityId, String pageNumber) {
        if (processDefinitionId == null) {
            return new ArrayList<BillPageAttributeConfigEntity>();
        }
        QFilter filter1 = new QFilter("processDefinitionId", "=", (Object)processDefinitionId);
        QFilter filter2 = new QFilter("taskdefinitionkey", "=", (Object)activityId);
        QFilter filter3 = null;
        if (null != pageNumber) {
            filter3 = new QFilter("pagenumber", "=", (Object)pageNumber);
        }
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        return this.getRepositoryService().findEntitiesByFilters("wf_billpageattrcfgmodel", filters);
    }

    private BillSetting returnBillSetting(BillDynInfoEntity billDynInfo) {
        BillSetting billSetting = new BillSetting();
        Long processDefinitionId = billDynInfo.getProcessDefinitionId();
        String activityId = billDynInfo.getActivityId();
        billSetting.setPageAttrConfig(this.findBillPageAttrConfigsByCondition(processDefinitionId, activityId, billDynInfo.getFormkey()));
        billSetting.setMobilePageAttrConfig(this.findBillPageAttrConfigsByCondition(processDefinitionId, activityId, billDynInfo.getMobileFormkey()));
        billSetting.setFieldModified(billDynInfo.isFieldModified());
        billSetting.setOperationWhenSave(billDynInfo.getOperationWhenSave());
        billSetting.setFormKey(billDynInfo.getFormkey());
        billSetting.setMobilFormKey(billDynInfo.getMobileFormkey());
        return billSetting;
    }

    private RepositoryService getRepositoryService() {
        return WfUtils.getWfService().getRepositoryService();
    }

    public String getEntityNumber() {
        return "wf_billdyninfomodel";
    }

    public String getProcessDefinitionField() {
        return "processDefinitionId";
    }
}

