/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.Task;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.component.approvalrecord.ApprovalAttachmentInfo;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfConstanst;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.cmd.task.RecordItemAttachmentInfo;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DurationDetailEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.ThirdCommentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordGroup;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.FlowRecordUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.RPAUtil;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.TaskDelegateUtil;

public class ApprovalRecordCmd
implements Command<List<IApprovalRecordGroup>> {
    private Log logger = LogFactory.getLog(this.getClass());
    public static final String COORDINATE = "coordinate";
    private static final String SSCAPPROVE = "sscapprove";
    public static final String SCENE_API = "scene_api";
    private static final String MANUALSUSPENDED = "manualSuspended";
    protected Long procDefId;
    protected Long processInstanceId;
    protected String businesskey;
    protected String endType;
    private Set<String> groups = new HashSet<String>();
    private String curTaskId = null;
    private Boolean isNewApprovalRecord = Boolean.FALSE;
    private List<IApprovalRecordItem> curNodeApprovalItems = new ArrayList<IApprovalRecordItem>();
    private Map<String, String> addSignMsgInfos = new HashMap<String, String>();
    private Map<String, Object> showCoordinates = new HashMap<String, Object>();
    private String scene;
    private boolean containCallActivity = false;
    private boolean containRPATask = false;
    private String currentUserId = RequestContext.get().getUserId();
    private Boolean isDisplaySetting = null;
    private static final String MMDDHHMM = "MM/dd HH:mm";
    private static final String FTRUENAME = "ftruename";
    private static final String FMESSAGE = "fmessage";
    private static final String FRESULTNAME = "fresultname";
    private static final String FASSIGNEE = "fassignee";
    private static final String FACTIVITYNAME = "factivityname";
    private static final String SUBACTIVITYNAME = "subactivityname";
    private static final String FUSERNAMEFORMATTER = "fusernameformatter";
    private static final String FACTIVITYID = "factivityid";
    private static final String FTASKID = "ftaskid";
    private static final String USERNAME = "username";
    private static final String ACTID = "actid";
    private static final String STATE = "state";
    private static final String TASKID = "taskid";
    private static final String ASSIGNORNAME = "assignorname";
    private static final String FTRUSTNAME = "ftrustname";
    private static final String TRUSTNAME = "trustname";
    private static final String FTRUSTNAMEFORMAT = "ftrustnameformat";
    private static final String TRUSTNAMEFORMAT = "trustnameformat";
    private static String[] varnames = new String[]{"businessModel", "passPercentage", "passFraction", "showThroughRules", "throughRulesType", "rulesContent", "passType"};
    public static final String BACKTOBAKCK = "1";

    public ApprovalRecordCmd(Long processInstanceId, String businesskey) {
        this.processInstanceId = processInstanceId;
        this.businesskey = businesskey;
    }

    public ApprovalRecordCmd(Long processInstanceId, String businesskey, Long procDefId, String endType) {
        this.processInstanceId = processInstanceId;
        this.businesskey = businesskey;
        this.procDefId = procDefId;
        this.endType = endType;
    }

    public ApprovalRecordCmd(Long processInstanceId, String businesskey, String curTaskId, String scene) {
        this.processInstanceId = processInstanceId;
        this.businesskey = businesskey;
        this.scene = scene;
        this.curTaskId = WfUtils.isEmpty(curTaskId) ? "" : curTaskId;
    }

    public ApprovalRecordCmd(Long processInstanceId, String businesskey, String curTaskId) {
        this.processInstanceId = processInstanceId;
        this.businesskey = businesskey;
        this.curTaskId = curTaskId;
    }

    public ApprovalRecordCmd(Long processInstanceId, String businesskey, String curTaskId, Boolean isNewApprovalRecord) {
        this.processInstanceId = processInstanceId;
        this.businesskey = businesskey;
        this.curTaskId = curTaskId;
        this.isNewApprovalRecord = isNewApprovalRecord;
    }

    public List<IApprovalRecordGroup> execute(CommandContext commandContext) {
        this.logger.info("\u5ba1\u6279\u8bb0\u5f55\uff0cbusinessKey\uff1a" + this.businesskey);
        if ("0".equals(this.businesskey)) {
            return Collections.emptyList();
        }
        Long processDefinitionId = 0L;
        try {
            boolean success = this.initProcessProcinstId(commandContext, processDefinitionId);
            if (!success) {
                return this.getTrdCommentByBusinessKey();
            }
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((Long)processDefinitionId, (Long)this.processInstanceId);
            Process process = bpmnModel.getMainProcess();
            this.initBpmnModelInfo(bpmnModel);
            ArrayList<ApprovalRecordItem> itemList = new ArrayList<ApprovalRecordItem>();
            List<ApprovalRecordItem> allApprovalItems = this.getApprovaledItems(process);
            itemList.addAll(allApprovalItems);
            List<ApprovalRecordItem> curTempItems = this.getCurrentApprovalItems(itemList, process);
            if (this.containCallActivity) {
                this.getCurrentCallActivityItems(commandContext, curTempItems);
            }
            if (this.containRPATask) {
                this.addRPATaskCurrentItems(commandContext, curTempItems);
            }
            itemList.addAll(curTempItems);
            if (!itemList.isEmpty() && WfUtils.isNotEmpty(this.curTaskId)) {
                for (ApprovalRecordItem item : itemList) {
                    if (!this.curTaskId.equalsIgnoreCase(item.getTaskId())) continue;
                    this.curNodeApprovalItems.add((IApprovalRecordItem)item);
                }
            } else {
                this.curNodeApprovalItems.addAll(curTempItems);
            }
            List<IApprovalRecordGroup> list = this.formatData(itemList, process);
            this.logger.debug("list size before format is:" + list.size());
            try {
                Map configCache = commandContext.getProcessEngineConfiguration().getDynModelConfigCache();
                String activityId = null;
                FlowElement element = null;
                for (IApprovalRecordGroup group : list) {
                    activityId = ((IApprovalRecordItem)group.getChildren().get(0)).getActivityId();
                    this.logger.debug("kd.bos.workflow.engine.impl.cmd.task.ApprovalRecordCmd.execute(CommandContext) activityId:" + activityId);
                    if (WfUtils.isEmpty(activityId)) continue;
                    element = process.getFlowElement(activityId);
                    if (null == element) {
                        this.logger.debug("kd.bos.workflow.engine.impl.cmd.task.ApprovalRecordCmd.execute(CommandContext) element is null.");
                        continue;
                    }
                    String type = element.getType();
                    this.logger.debug("kd.bos.workflow.engine.impl.cmd.task.ApprovalRecordCmd.execute(CommandContext) type:" + type);
                    String formatter = ModelConfigUtil.getFormatRecordsPlugin((String)type, (Map)configCache);
                    if (!WfUtils.isNotEmpty(formatter)) continue;
                    List ret = (List)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.FORMATFLOWRECORDS, formatter, group.getChildren());
                    group.setChildren(ret);
                }
            }
            catch (KDException e2) {
                this.logger.info(e2.getStackTraceMessage());
            }
            this.logger.debug("list size after format is:" + list.size());
            return list;
        }
        catch (KDException e) {
            this.logger.warn(e.getStackTraceMessage());
            return Collections.emptyList();
        }
    }

    private List<IApprovalRecordGroup> getTrdCommentByBusinessKey() {
        Boolean showTrdApprovalRecord = WfConfigurationUtil.showTrdApprovalRecord();
        if (showTrdApprovalRecord.booleanValue()) {
            ArrayList<ApprovalRecordItem> items = new ArrayList<ApprovalRecordItem>();
            HashMap<Long, ApprovalRecordItem> recordMap = new HashMap<Long, ApprovalRecordItem>();
            this.queryApprovalItems(items, recordMap, "T_WF_TRDHICOMMENT", "T_WF_TRDHICOMMENT_L", "thirdComment");
            this.logger.debug("getTrdCommentByBusinessKey1:" + items.size());
            this.setAttachmentInfo(items, recordMap);
            if (WfUtils.isNotEmptyForCollection(items)) {
                return this.formatData(items, null);
            }
        }
        return Collections.emptyList();
    }

    private boolean initProcessProcinstId(CommandContext commandContext, Long processDefinitionId) {
        String workFlowType = null;
        if (WfUtils.isNotEmpty(this.businesskey) && WfUtils.isEmpty(this.processInstanceId)) {
            QFilter q1 = new QFilter("businesskey", "=", (Object)this.businesskey);
            QFilter q2 = new QFilter("superprocessinstanceid", "=", (Object)0);
            Map hiprocinsts = BusinessDataServiceHelper.loadFromCache((String)EntityNumberConstant.getHiProcInstEntityNumber(), (String)"processdefinitionid,processinstanceid,processtype", (QFilter[])new QFilter[]{q1, q2}, (String)"createdate");
            if (hiprocinsts == null || hiprocinsts.isEmpty()) {
                return false;
            }
            for (DynamicObject hiprocinst : hiprocinsts.values()) {
                this.processInstanceId = hiprocinst.getLong("processinstanceid");
                processDefinitionId = hiprocinst.getLong("processdefinitionid");
                workFlowType = hiprocinst.getString("processtype");
            }
        }
        if (WfUtils.isEmpty(workFlowType)) {
            workFlowType = ViewFlowchartUtil.getWorkFlowType((Long)this.processInstanceId, (Long)processDefinitionId);
        }
        if (ProcessType.BizFlow.name().equals(workFlowType)) {
            QFilter pFilter = new QFilter("processtype", "=", (Object)ProcessType.AuditFlow.name());
            QFilter bFilter = new QFilter("businessKey", "=", (Object)this.businesskey);
            List hpies = commandContext.getHistoricProcessInstanceEntityManager().findByQueryFilters(new QFilter[]{pFilter, bFilter});
            if (CollectionUtil.isNotEmpty((Collection)hpies)) {
                HistoricProcessInstanceEntity historicProcessInstanceEntity = (HistoricProcessInstanceEntity)hpies.get(0);
                this.processInstanceId = historicProcessInstanceEntity.getProcessInstanceId();
                processDefinitionId = historicProcessInstanceEntity.getProcessDefinitionId();
            } else {
                return false;
            }
        }
        return true;
    }

    private void getCurrentCallActivityItems(CommandContext commandContext, List<ApprovalRecordItem> curTempItems) {
        QFilter q1 = new QFilter("activityType", "=", (Object)"CallActivity");
        QFilter q2 = new QFilter("processInstanceId", "=", (Object)this.processInstanceId);
        QFilter q3 = new QFilter("endTime", "is null", (Object)Boolean.TRUE);
        List historicActivityInstanceEntities = commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{q1, q2, q3});
        if (CollectionUtil.isNotEmpty((Collection)historicActivityInstanceEntities)) {
            for (HistoricActivityInstanceEntity historicActivityInstanceEntity : historicActivityInstanceEntities) {
                ApprovalRecordItem approvalRecordItem = new ApprovalRecordItem();
                String activityId = historicActivityInstanceEntity.getActivityId();
                approvalRecordItem.setActivityId(activityId);
                Date time = historicActivityInstanceEntity.getCreateDate();
                if (time != null) {
                    approvalRecordItem.setTime(WfUtils.parseToUserZoneDateString(time));
                    Date userZoneDate = WfUtils.getUserZoneDate(time);
                    approvalRecordItem.setFormatTime(Long.valueOf(userZoneDate.getTime()));
                    approvalRecordItem.setFormatStrTime(new SimpleDateFormat(MMDDHHMM).format(userZoneDate));
                }
                approvalRecordItem.setResult(WFMultiLangConstants.getSSCStateName1());
                Long subProcessInstanceId = historicActivityInstanceEntity.getCalledProcessInstanceId();
                if (!WfUtils.isNotEmpty(subProcessInstanceId)) continue;
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId((Long)subProcessInstanceId);
                approvalRecordItem.setMessage(bpmnModel.getMainProcess().getName());
                approvalRecordItem.setCallActivity(true);
                approvalRecordItem.setAddSignMsg(this.getAddSignMsg(activityId));
                approvalRecordItem.setHandleState("willApproval");
                approvalRecordItem.setNodeType(activityId);
                approvalRecordItem.setProcInstId(String.valueOf(subProcessInstanceId));
                approvalRecordItem.setActivityName(historicActivityInstanceEntity.getActivityName().getLocaleValue() + " ");
                ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(subProcessInstanceId);
                if (executionEntity != null) {
                    if ("2".equals(executionEntity.getSuspensionState())) {
                        approvalRecordItem.setResult(this.getState("suspended"));
                    } else {
                        approvalRecordItem.setDecisionType("wait");
                    }
                } else {
                    approvalRecordItem.setResult(this.getState("approved"));
                }
                approvalRecordItem.setGroup(String.valueOf(subProcessInstanceId));
                curTempItems.add(approvalRecordItem);
            }
        }
    }

    private void addRPATaskCurrentItems(CommandContext commandContext, List<ApprovalRecordItem> curTempItems) {
        QFilter[] filters = new QFilter[]{new QFilter("processInstanceId", "=", (Object)this.processInstanceId), new QFilter("activityType", "=", (Object)"RPATask"), new QFilter("endTime", "is null", null)};
        String sort = String.format("%s ASC", "createDate");
        List actInsts = commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(filters, null, sort);
        if (actInsts.isEmpty()) {
            return;
        }
        for (HistoricActivityInstanceEntity actInst : actInsts) {
            ApprovalRecordItem item = new ApprovalRecordItem();
            item.setGroup(String.valueOf(actInst.getId()));
            item.setActivityId(actInst.getActivityId());
            item.setActivityName(actInst.getActivityName().getLocaleValue());
            item.setTime(WfUtils.parseToUserZoneDateString(actInst.getCreateDate()));
            item.setMessage(RPAUtil.getSendStartRPAProcMsgText().getLocaleValue());
            item.setAvatar(RPAUtil.getRPAApprovalRecordAvatar());
            curTempItems.add(item);
        }
    }

    private void initBpmnModelInfo(BpmnModel bpmnModel) {
        List flowElementList = bpmnModel.getMainProcess().getFlowElementList();
        if (flowElementList != null && !flowElementList.isEmpty()) {
            for (FlowElement flowElement : flowElementList) {
                AuditTask auditTask;
                Map addSignMsg;
                if (flowElement instanceof AuditTask && (addSignMsg = (auditTask = (AuditTask)flowElement).getAddSignMsg()) != null) {
                    for (Map.Entry entry : addSignMsg.entrySet()) {
                        this.addSignMsgInfos.put(auditTask.getId() + (String)entry.getKey(), (String)entry.getValue());
                    }
                }
                if ("CallActivity".equals(flowElement.getType())) {
                    this.containCallActivity = true;
                    CallActivity callActivity = (CallActivity)flowElement;
                    addSignMsg = callActivity.getAddSignMsg();
                    if (addSignMsg != null) {
                        for (Map.Entry entry : addSignMsg.entrySet()) {
                            this.addSignMsgInfos.put(callActivity.getId() + (String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
                if (!"RPATask".equals(flowElement.getType())) continue;
                this.containRPATask = true;
            }
        }
    }

    public List<IApprovalRecordGroup> formatData(List<ApprovalRecordItem> items, Process process) {
        ArrayList<IApprovalRecordGroup> approvalRecordItems = new ArrayList<IApprovalRecordGroup>();
        if (WfUtils.isNotEmptyForCollection(items)) {
            HashSet<String> groupIds = new HashSet<String>(items.size());
            int size = items.size();
            HashMap<Long, Map<String, String>> userInfos = new HashMap<Long, Map<String, String>>();
            this.getUserInfos(items, userInfos);
            for (int i = size - 1; i >= 0; --i) {
                Task element;
                String actId;
                String groupId;
                ApprovalRecordItem item = items.get(i);
                boolean canContinue = this.getCanContinue(item, items);
                if (canContinue || !groupIds.add(groupId = item.getGroup())) continue;
                ApprovalRecordGroup approvalRecordGroup = new ApprovalRecordGroup();
                approvalRecordGroup.setGroup(item.getGroup());
                String groupDecisionType = item.getGroupDecisionType();
                if (WfUtils.isEmpty(groupDecisionType)) {
                    approvalRecordGroup.setGroupDecisionType(item.getDecisionType());
                } else {
                    approvalRecordGroup.setGroupDecisionType(groupDecisionType);
                    if (MANUALSUSPENDED.equals(groupDecisionType) && this.isNewApprovalRecord.booleanValue()) {
                        approvalRecordGroup.setActivityName(item.getActivityName());
                    }
                }
                List<Object> children = new ArrayList<ApprovalRecordItem>();
                if (item.getActivityId() != null && item.getActivityId().contains("CallActivity")) {
                    children.add(item);
                    approvalRecordGroup.setCallActivity(Boolean.TRUE);
                    FlowRecordUtil.executeFormatPlugin((Process)process, (IApprovalRecordItem)item);
                } else {
                    children = this.getChildren(groupId, items, process, userInfos);
                }
                if (CollectionUtil.isNotEmpty(children) && process != null) {
                    Map addSignMsg;
                    actId = ((IApprovalRecordItem)children.get(0)).getActivityId();
                    element = (Task)process.findFlowElementsOfTypeAndId(Task.class, actId, false);
                    if (element != null && "YunzhijiaTask".equals(element.getType())) {
                        approvalRecordGroup.setGroupType("huiqian");
                        approvalRecordGroup.setActivityName(element.getName() + " ");
                        approvalRecordGroup.setThroughRule(this.getYunzhijiaVoteRule((IApprovalRecordItem)item, (YunzhijiaTask)element));
                    } else if (element != null && "SSCApprove".equals(element.getType())) {
                        approvalRecordGroup.setActivityName(element.getName() + " ");
                    }
                    if (element instanceof AuditTask && (addSignMsg = ((AuditTask)element).getAddSignMsg()) != null) {
                        approvalRecordGroup.setAddSignMsg((String)addSignMsg.get(RequestContext.get().getLang().toString()));
                    }
                }
                if (children.size() > 1 && WfUtils.isNotEmpty(actId = ((IApprovalRecordItem)children.get(0)).getActivityId()) && process != null) {
                    element = (Task)process.findFlowElementsOfTypeAndId(Task.class, actId, false);
                    String elementType = element.getType();
                    approvalRecordGroup.setActivityName(element.getName() + " ");
                    if ("YunzhijiaTask".equals(elementType)) {
                        approvalRecordGroup.setThroughRule(this.getYunzhijiaVoteRule((IApprovalRecordItem)item, (YunzhijiaTask)element));
                        approvalRecordGroup.setGroupType("huiqian");
                    } else if (BpmnModelUtil.instanceofAuditTask((String)elementType) && !"SSCApprove".equals(elementType)) {
                        approvalRecordGroup.setThroughRule(WFMultiLangConstants.getApprovalByAnyoneName());
                    }
                }
                if ("wait".equals(approvalRecordGroup.getGroupDecisionType())) {
                    boolean showCoordinate = this.isShowCoordinate(children);
                    approvalRecordGroup.setShowCoordnate(Boolean.valueOf(showCoordinate));
                    this.excludeStandardComment(children);
                }
                approvalRecordGroup.setChildren(children);
                approvalRecordItems.add((IApprovalRecordGroup)approvalRecordGroup);
            }
            this.setAutoCoordinateValue(approvalRecordItems, groupIds);
            Collections.reverse(approvalRecordItems);
        }
        return approvalRecordItems;
    }

    private String getYunzhijiaVoteRule(IApprovalRecordItem item, YunzhijiaTask currentNode) {
        String message = null;
        CommandContext commandContext = Context.getCommandContext();
        Long taskId = Long.valueOf(item.getTaskId());
        HistoricTaskInstanceEntity hitask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId);
        if (null == hitask) {
            return null;
        }
        Map varMap = commandContext.getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByTaskIdAndVarNames(hitask.getParentTaskId(), varnames);
        if (!varMap.isEmpty()) {
            YunzhijiaTask yzjTask = new YunzhijiaTask();
            yzjTask.setBusinessModel(((HistoricVariableInstanceEntity)varMap.get("businessModel")).getTextValue());
            HistoricVariableInstanceEntity value = (HistoricVariableInstanceEntity)varMap.get("passFraction");
            HistoricVariableInstanceEntity valuePassType = (HistoricVariableInstanceEntity)varMap.get("passType");
            if (value != null) {
                yzjTask.setPasstype("passByFraction");
                yzjTask.setPassfraction(value.getTextValue());
            } else if (valuePassType != null) {
                yzjTask.setPasstype("passByAnyOne");
            } else {
                yzjTask.setPasstype("passByPercent");
                value = (HistoricVariableInstanceEntity)varMap.get("passPercentage");
                if (value != null) {
                    yzjTask.setPassPercentage(value.getDoubleValue().doubleValue());
                } else {
                    this.logger.warn("The variable passPercentage value is null!");
                }
            }
            HistoricVariableInstanceEntity showThroughRulesEntity = (HistoricVariableInstanceEntity)varMap.get("showThroughRules");
            HistoricVariableInstanceEntity throughRulesTypeEntity = (HistoricVariableInstanceEntity)varMap.get("throughRulesType");
            HistoricVariableInstanceEntity rulesContentEntity = (HistoricVariableInstanceEntity)varMap.get("rulesContent");
            boolean isShowThroughRules = showThroughRulesEntity == null ? currentNode.isShowThroughRules() : Boolean.parseBoolean(showThroughRulesEntity.getTextValue());
            String throughRulesType = throughRulesTypeEntity == null ? currentNode.getThroughRulesType() : throughRulesTypeEntity.getTextValue();
            String rulesContent = rulesContentEntity == null ? currentNode.getRulesContent() : rulesContentEntity.getTextValue();
            yzjTask.setShowThroughRules(isShowThroughRules);
            yzjTask.setThroughRulesType(throughRulesType);
            yzjTask.setRulesContent(rulesContent);
            message = BpmnModelUtil.getYunzhijiaThroughRules((YunzhijiaTask)yzjTask, (Long)hitask.getProcessInstanceId());
        } else {
            message = BpmnModelUtil.getYunzhijiaThroughRules((YunzhijiaTask)currentNode, (Long)hitask.getProcessInstanceId());
        }
        return message;
    }

    private void excludeStandardComment(List<IApprovalRecordItem> children) {
        if (CollectionUtil.isNotEmpty(children)) {
            boolean hasTrdComment = false;
            for (IApprovalRecordItem child : children) {
                if (!"thirdComment".equals(child.getSource())) continue;
                hasTrdComment = true;
                break;
            }
            if (hasTrdComment) {
                ArrayList<IApprovalRecordItem> temp = new ArrayList<IApprovalRecordItem>();
                for (IApprovalRecordItem child : children) {
                    if (!"thirdComment".equals(child.getSource())) continue;
                    temp.add(child);
                }
                children.clear();
                children.addAll(temp);
            }
        }
    }

    private void setAutoCoordinateValue(List<IApprovalRecordGroup> approvalRecordItems, Set<String> groupIds) {
        QFilter q5;
        DynamicObject[] dynamicObjects3;
        QFilter q4;
        DynamicObject[] dynamicObjects2;
        ArrayList<Long> groupIdList = new ArrayList<Long>();
        if (groupIds != null && !groupIds.isEmpty()) {
            for (String id : groupIds) {
                groupIdList.add(Long.parseLong(id));
            }
        }
        HashSet<String> hasAutoCoordinateGroupIds = new HashSet<String>(approvalRecordItems.size());
        QFilter q3 = new QFilter(TASKID, "in", groupIdList);
        QFilter q2 = new QFilter("ownerid", "=", (Object)WfConstanst.ADMIN);
        QFilter q1 = new QFilter("type", "=", (Object)COORDINATE);
        DynamicObject[] dynamicObjects1 = BusinessDataServiceHelper.load((String)"wf_participant", (String)"id,taskid", (QFilter[])new QFilter[]{q3, q2, q1});
        if (dynamicObjects1 != null && dynamicObjects1.length > 0) {
            this.getAutoCoordinateTaskIds(hasAutoCoordinateGroupIds, dynamicObjects1, TASKID);
        }
        if ((dynamicObjects2 = BusinessDataServiceHelper.load((String)"wf_participant", (String)"id,taskid", (QFilter[])new QFilter[]{q4 = new QFilter("parenttaskid", "in", groupIdList), q2, q1})) != null && dynamicObjects2.length > 0) {
            this.getAutoCoordinateTaskIds(hasAutoCoordinateGroupIds, dynamicObjects1, TASKID);
        }
        if ((dynamicObjects3 = BusinessDataServiceHelper.load((String)"wf_hicomment", (String)"id,groupid", (QFilter[])new QFilter[]{q2, q1, q5 = new QFilter("groupid", "in", groupIds)})) != null && dynamicObjects3.length > 0) {
            this.getAutoCoordinateTaskIds(hasAutoCoordinateGroupIds, dynamicObjects3, "groupid");
        }
        for (IApprovalRecordGroup approvalRecordGroup : approvalRecordItems) {
            if (hasAutoCoordinateGroupIds.contains(approvalRecordGroup.getGroup())) {
                ((ApprovalRecordGroup)approvalRecordGroup).setShowAutoCoordinate(Boolean.TRUE);
                continue;
            }
            ((ApprovalRecordGroup)approvalRecordGroup).setShowAutoCoordinate(Boolean.FALSE);
        }
    }

    private void getAutoCoordinateTaskIds(Set<String> hasAutoCoordinateGroupIds, DynamicObject[] dynamicObjects, String key) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            String groupId = dynamicObject.getString(key);
            hasAutoCoordinateGroupIds.add(groupId);
        }
    }

    private boolean isShowCoordinate(List<IApprovalRecordItem> children) {
        IApprovalRecordItem child;
        ApprovalRecordItem item;
        boolean coordinate;
        if (CollectionUtil.isEmpty(children)) {
            return false;
        }
        boolean showCoordinate = false;
        Iterator<IApprovalRecordItem> iterator = children.iterator();
        while (!(!iterator.hasNext() || (coordinate = (item = (ApprovalRecordItem)(child = iterator.next())).isCoordinate()) && "willApproval".equals(item.getHandleState()) && (showCoordinate = this.getShowCoordinate(item.getTaskId(), this.currentUserId)))) {
        }
        return showCoordinate;
    }

    @Deprecated
    public List<IApprovalRecordItem> getChildren(String group, List<ApprovalRecordItem> items, Process process) {
        return this.getChildren(group, items, process, new HashMap<Long, Map<String, String>>(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IApprovalRecordItem> getChildren(String group, List<ApprovalRecordItem> items, Process process, Map<Long, Map<String, String>> userInfos) {
        ArrayList<IApprovalRecordItem> children = new ArrayList<IApprovalRecordItem>();
        int i = 0;
        for (ApprovalRecordItem item : items) {
            Map<String, String> p;
            if (!group.equals(item.getGroup())) continue;
            Long userid = item.getUserId();
            String taskId = item.getTaskId();
            item.setUserStr(userid + "");
            item.setCoordinate(false);
            item.setScene("approvalRecord");
            String uName = "";
            if (userid != null && userid > 0L) {
                boolean showCoordinate = this.getShowCoordinate(taskId, this.currentUserId);
                item.setCoordinate(showCoordinate);
                Map<String, String> m = userInfos.get(userid);
                if (m != null) {
                    if (WfUtils.isNotEmpty(item.getActivityId()) && process != null) {
                        UserTask userTask = (UserTask)process.getFlowElement(item.getActivityId());
                        this.logger.debug("kd.bos.workflow.engine.impl.cmd.task.ApprovalRecordCmd.getChildren(String, List<ApprovalRecordItem>, Process) processid:" + this.processInstanceId + "; activityId:" + item.getActivityId());
                        boolean participantdisplaysetting = false;
                        if (null != userTask && userTask.getParticipant() != null) {
                            participantdisplaysetting = userTask.getParticipant().isDisplaySetting();
                        }
                        if (participantdisplaysetting || this.isDisplaySetting()) {
                            item.setShowUserNameFormat(true);
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)item.getAvatar())) {
                        item.setAvatar(m.get("imgsrc"));
                    }
                    uName = m.get(FTRUENAME);
                    if (userid != null && !this.currentUserId.equals(userid.toString())) {
                        item.setOpenId(m.get("fopenid"));
                    }
                }
            }
            if (WfUtils.isNotEmpty(item.getOwnerId()) && WfUtils.isNotEmpty(uName) && !TaskDelegateUtil.isDelegateTask((Long)Long.valueOf(taskId), (Long)userid) && (p = userInfos.get(item.getOwnerId())) != null) {
                if (WfUtils.isNotEmpty(item.getMessage())) {
                    String entrust = WfConfigurationUtil.getTransferName();
                    if ("en_US".equals(Lang.get().toString())) {
                        entrust = " " + entrust + " ";
                    }
                    String usernameFormat = item.getUserNameFormat();
                    ILocaleString userName = WfUtils.findUserName(userid);
                    if (WfUtils.isNotEmpty(usernameFormat)) {
                        userName = new LocaleString(usernameFormat);
                    }
                    QFilter filter1 = new QFilter(TASKID, "=", (Object)Long.valueOf(item.getTaskId()));
                    QFilter filter2 = new QFilter("type", "=", (Object)"transfer");
                    Iterator filter3 = new QFilter("ownerid", "=", (Object)item.getOwnerId());
                    QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
                    DynamicObject taskHandleLog = QueryServiceHelper.queryOne((String)"wf_taskhandlelog", (String)"ownerformat,assigneeformat", (QFilter[])filters);
                    String truename = p.get(FTRUENAME);
                    if (taskHandleLog != null && WfUtils.isNotEmpty(taskHandleLog.getString("ownerformat"))) {
                        truename = taskHandleLog.getString("ownerformat");
                        userName = new LocaleString(taskHandleLog.getString("assigneeformat"));
                    }
                    item.setMessage(item.getMessage() + " (" + truename + entrust + (WfUtils.isNotEmpty(userName) ? userName : "") + ')');
                }
                item.setShowTransferRecord(true);
            }
            if (item.isDelegate()) {
                QFilter filter3;
                QFilter filter2;
                QFilter participantFilter1 = new QFilter(TASKID, "=", (Object)Long.valueOf(taskId));
                QFilter participantFilter2 = new QFilter("ownerid", "=", (Object)userid);
                QFilter participantFilter3 = new QFilter("type", "!=", (Object)COORDINATE);
                QFilter[] participantFilters = new QFilter[]{participantFilter1, participantFilter2, participantFilter3};
                DynamicObjectCollection participants = QueryServiceHelper.query((String)"wf_hiparticipant", (String)"delegateid", (QFilter[])participantFilters);
                ArrayList<Long> delegateIds = new ArrayList<Long>();
                for (DynamicObject participant : participants) {
                    delegateIds.add(participant.getLong("delegateid"));
                }
                QFilter filter1 = new QFilter(TASKID, "=", (Object)Long.valueOf(taskId));
                QFilter[] filters = new QFilter[]{filter1, filter2 = new QFilter("delegateid", "in", delegateIds).and(new QFilter("delegateid", ">=", (Object)0L)), filter3 = new QFilter("type", "=", (Object)"transfer")};
                DynamicObjectCollection taskHandleLogs = QueryServiceHelper.query((String)"wf_taskhandlelog", (String)"ownerformat,assigneeformat", (QFilter[])filters);
                if (taskHandleLogs != null && !taskHandleLogs.isEmpty()) {
                    item.setShowTransferRecord(true);
                }
            }
            if (i > 0 && !SCENE_API.equals(this.scene)) {
                if (i == 1) {
                    ((IApprovalRecordItem)children.get(0)).setActivityName("");
                }
                item.setActivityName("");
            }
            item.setCurrentUserId(this.currentUserId);
            try {
                if (this.curNodeApprovalItems != null && !this.curNodeApprovalItems.isEmpty()) {
                    item.setCurrentApprovalRecordItem(this.curNodeApprovalItems);
                }
                if (process != null) {
                    FlowRecordUtil.executeFormatPlugin((Process)process, (IApprovalRecordItem)item);
                }
            }
            catch (Exception e) {
                this.logger.error(WfUtils.getExceptionStacktrace(e));
            }
            finally {
                item.setCurrentApprovalRecordItem(null);
            }
            LocaleString addSignMsg = new LocaleString();
            if (WfUtils.isNotEmptyForMap(this.addSignMsgInfos)) {
                String activityId = item.getActivityId();
                for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
                    String value = this.addSignMsgInfos.get(activityId + lang.name());
                    addSignMsg.put(lang.name(), (Object)(WfUtils.isNotEmpty(value) ? value : ""));
                }
            }
            item.setAddSignMsg(addSignMsg.toString());
            children.add((IApprovalRecordItem)item);
            ++i;
        }
        return children;
    }

    private void getUserInfos(List<ApprovalRecordItem> items, Map<Long, Map<String, String>> userInfos) {
        this.logger.debug("ApprovalRecordCmd.getUserInfos begin.");
        ArrayList<Long> userIds = new ArrayList<Long>();
        HashMap<Long, String> userIdsMapAssign = new HashMap<Long, String>();
        for (ApprovalRecordItem item : items) {
            String assign;
            Long userid = item.getUserId();
            if (!userIds.contains(userid)) {
                userIds.add(userid);
            }
            if (!userIds.contains(userid = item.getOwnerId())) {
                userIds.add(userid);
            }
            if (!WfUtils.isNotEmpty(assign = item.getAssignee())) continue;
            userIdsMapAssign.put(userid, assign);
        }
        QFilter filter = new QFilter("id", "in", userIds);
        QFilter[] qFilters = new QFilter[]{filter};
        String fields = "useropenid,name,picturefield,id";
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"bos_user", (String)fields, (QFilter[])qFilters);
        Map jobs = UserServiceHelper.getUserMainJob(userIds);
        for (DynamicObject obj : dynObjs) {
            HashMap<String, String> m = new HashMap<String, String>();
            Long uId = obj.getLong("id");
            String userNameForFinal = (String)userIdsMapAssign.get(uId);
            if (WfUtils.isEmpty(userNameForFinal)) {
                userNameForFinal = obj.getString("name");
            }
            if (WfUtils.isNotEmpty(userNameForFinal)) {
                m.put(FTRUENAME, userNameForFinal);
                m.put("name", userNameForFinal);
            } else {
                m.put(FTRUENAME, "");
            }
            String job = (String)jobs.get(uId);
            if (WfUtils.isNotEmpty(job)) {
                m.put("fjob", job);
            }
            m.put("imgsrc", WfUtils.getAbsAvatarPath(obj.get("picturefield")));
            if (obj.get("useropenid") != null) {
                m.put("fopenid", obj.get("useropenid").toString());
            } else {
                m.put("fopenid", "");
            }
            userInfos.put(uId, m);
        }
    }

    private boolean getCanContinue(ApprovalRecordItem item, List<ApprovalRecordItem> items) {
        boolean canContinue = false;
        if ("thirdComment".equals(item.getSource())) {
            for (ApprovalRecordItem tempItem : items) {
                if ("thirdComment".equals(tempItem.getSource()) || item.getTaskId() == null || !item.getTaskId().equals(tempItem.getTaskId())) continue;
                canContinue = true;
            }
        }
        return canContinue;
    }

    protected boolean isDisplaySetting() {
        if (this.isDisplaySetting == null) {
            this.isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        }
        return this.isDisplaySetting;
    }

    @Deprecated
    private StringBuilder getApprovalItemsSql(String tableName, String tableMultiName) {
        String hiCommentEntityNumber = EntityNumberConstant.getHiCommentEntityNumber();
        String convertedTableName = TableNameConstant.getRealTableName((String)tableName.toLowerCase());
        String convertedTableMultiName = String.format("%s_l", convertedTableName);
        StringBuilder sql = new StringBuilder();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String messageSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)FMESSAGE, (String)FMESSAGE, (String)"message");
        String resultNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)FRESULTNAME, (String)FRESULTNAME, (String)"resultname");
        String assigneeSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)FASSIGNEE, (String)FASSIGNEE, (String)"assignee");
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)FACTIVITYNAME, (String)FACTIVITYNAME, (String)"activityname");
        String subActivityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fsubactivityname", (String)SUBACTIVITYNAME, (String)SUBACTIVITYNAME);
        String userNameFormatterSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)FUSERNAMEFORMATTER, (String)FUSERNAMEFORMATTER, (String)"usernameformatter");
        String assignorNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)FTRUSTNAME, (String)ASSIGNORNAME, (String)ASSIGNORNAME);
        sql.append("select ").append(messageSQL).append(", a.frichtextmessage richTextMessage,");
        sql.append(userNameFormatterSQL).append(" ,a.fid,a.ftaskid,a.ftype,a.fuserid,").append(resultNameSQL);
        sql.append(",a.fdecisiontype,a.fownerid,a.ftime,a.fgroupid,a.fbusinesskey,a.fentitynumber,").append(assigneeSQL).append(",a.factivityid,");
        sql.append(activityNameSQL).append(',').append(subActivityNameSQL).append(", a.FRESULTNUMBER resultNumber,").append(assignorNameSQL).append(',');
        sql.append(" '' handlestate, a.fispublic,a.fbizidentifykey,a.fstep fstep,a.fterminalway fterminalway,a.fsubprocessinstanceid fsubprocessinstanceid, ");
        if ("T_WF_TRDHICOMMENT".equals(tableName)) {
            sql.append(" a.factivityid facttype ");
        } else {
            sql.append(" a.fcategory facttype ");
        }
        sql.append("from ");
        sql.append(convertedTableName);
        sql.append(" a left join ");
        sql.append(convertedTableMultiName);
        sql.append(" b on a.fid=b.fid ");
        if ("T_WF_TRDHICOMMENT".equals(tableName) && WfUtils.isEmpty(this.processInstanceId)) {
            sql.append("where a.fbusinesskey=?");
        } else {
            sql.append("where a.fprocinstid=?");
        }
        sql.append(" and b.FLOCALEID = ? and a.ftype!='forceReject' ORDER BY a.fstep ,a.ftime ASC ");
        return sql;
    }

    private void queryApprovalItems(List<ApprovalRecordItem> approvalRecordItems, Map<Long, ApprovalRecordItem> recordMap, String tableName, String tableMultiName, String source) {
        List result;
        QFilter qFilter;
        CommandContext commandContext = Context.getCommandContext();
        if ("T_WF_TRDHICOMMENT".equals(tableName)) {
            qFilter = WfUtils.isEmpty(this.processInstanceId) ? new QFilter("businessKey", "=", (Object)this.businesskey) : new QFilter("processInstanceId", "=", (Object)this.processInstanceId);
            ThirdCommentEntityManager trdCommentEntityManager = commandContext.getTrdCommentEntityManager();
            result = trdCommentEntityManager.findApprovalRecordByAuth(qFilter.toArray(), "step,time");
        } else {
            qFilter = new QFilter("processInstanceId", "=", (Object)this.processInstanceId);
            CommentEntityManager commentEntityManager = commandContext.getCommentEntityManager();
            result = commentEntityManager.findApprovalRecordByAuth(qFilter.toArray(), "step,time");
        }
        List commentEntities = Optional.ofNullable(result).orElseGet(ArrayList::new);
        ArrayList<Long> taskIds = new ArrayList<Long>(commentEntities.size());
        int index = 0;
        for (CommentEntity comment : commentEntities) {
            DynamicObject[] commentGetter = Optional.of(comment);
            taskIds.add(commentGetter.map(Comment::getTaskId).orElseGet(() -> 0L));
            Long userId = commentGetter.map(Comment::getUserId).orElseGet(() -> 0L);
            String activityId = comment.getActivityId();
            String groupId = comment.getGroupId();
            boolean isExist = false;
            if (-1L == userId && groupId != null) {
                for (int i = 0; i < approvalRecordItems.size(); ++i) {
                    ApprovalRecordItem approvalRecordItem = approvalRecordItems.get(i);
                    if (!userId.equals(approvalRecordItem.getUserId()) || !activityId.equals(approvalRecordItem.getActivityId()) || !approvalRecordItem.getGroup().equals(groupId)) continue;
                    isExist = true;
                    break;
                }
            }
            if (isExist) continue;
            if (activityId != null && activityId.contains("CallActivity")) {
                this.createCallActivityRecordItems(approvalRecordItems, comment);
                continue;
            }
            this.createApprovalRecordItems(approvalRecordItems, comment, recordMap, source, index);
            ++index;
        }
        HashMap<Long, DynamicObject> taskMapping = new HashMap<Long, DynamicObject>();
        if (!taskIds.isEmpty()) {
            DynamicObject[] taskObjects = BusinessDataServiceHelper.load((String)EntityNumberConstant.getHiTaskInstEntityNumber(), (String)"id,handlestate", (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)});
            if (taskObjects != null && taskObjects.length > 0) {
                for (DynamicObject task : taskObjects) {
                    taskMapping.put(task.getLong("id"), task);
                }
            }
            if (!taskMapping.isEmpty()) {
                String approvalRecordItemTaskId = null;
                for (ApprovalRecordItem approvalRecordItem : approvalRecordItems) {
                    Long taskId;
                    if (null == approvalRecordItem || WfUtils.isEmpty(approvalRecordItemTaskId = approvalRecordItem.getTaskId()) || !taskMapping.containsKey(taskId = Long.valueOf(approvalRecordItemTaskId))) continue;
                    approvalRecordItem.setHandleState(((DynamicObject)taskMapping.get(taskId)).getString("handlestate"));
                }
            }
        }
    }

    private void sortApprovalRecords(List<ApprovalRecordItem> approvalRecordItems) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat useSdf = WfUtils.getUserDateFormat(false);
        final SimpleDateFormat finalSdf = useSdf == null ? sdf : useSdf;
        approvalRecordItems.sort((Comparator<ApprovalRecordItem>)new Comparator<IApprovalRecordItem>(){

            @Override
            public int compare(IApprovalRecordItem iApprovalRecordItemBefore, IApprovalRecordItem iApprovalRecordItemAfter) {
                String beforeRecord = iApprovalRecordItemBefore.getTime();
                String afterRecord = iApprovalRecordItemAfter.getTime();
                try {
                    long beforeRecordTime = finalSdf.parse(beforeRecord).getTime();
                    long afterRecordTime = finalSdf.parse(afterRecord).getTime();
                    if (beforeRecordTime > afterRecordTime) {
                        return 1;
                    }
                    if (beforeRecordTime < afterRecordTime) {
                        return -1;
                    }
                }
                catch (ParseException e) {
                    ApprovalRecordCmd.this.logger.error(WfUtils.getExceptionStacktrace(e));
                }
                return 0;
            }
        });
    }

    private List<ApprovalRecordItem> getApprovaledItems(Process process) {
        ArrayList<ApprovalRecordItem> approvalRecordItems = new ArrayList<ApprovalRecordItem>();
        HashMap<Long, ApprovalRecordItem> recordMap = new HashMap<Long, ApprovalRecordItem>();
        this.queryApprovalItems(approvalRecordItems, recordMap, "T_WF_HICOMMENT", "T_WF_HICOMMENT_L", "comment");
        Boolean showTrdApprovalRecord = WfConfigurationUtil.showTrdApprovalRecord();
        if (showTrdApprovalRecord.booleanValue()) {
            this.queryApprovalItems(approvalRecordItems, recordMap, "T_WF_TRDHICOMMENT", "T_WF_TRDHICOMMENT_L", "thirdComment");
        }
        if (showTrdApprovalRecord.booleanValue() && approvalRecordItems.size() > 0) {
            this.sortApprovalRecords(approvalRecordItems);
        }
        this.setAttachmentInfo(approvalRecordItems, recordMap);
        return approvalRecordItems;
    }

    private void setAttachmentInfo(List<ApprovalRecordItem> approvalRecordItems, Map<Long, ApprovalRecordItem> recordMap) {
        if (approvalRecordItems.isEmpty() || recordMap.size() == 0) {
            return;
        }
        String inCondition = this.getInCondition(recordMap.keySet());
        StringBuilder sql = new StringBuilder();
        sql.append("select a.furlid attachmentId, a.fcontentid commentId from t_wf_hiattachment a ");
        sql.append("left join t_wf_hiattachment_l b on b.fid = a.fid and b.flocaleid = ? ");
        sql.append("where a.fuserid != 1 and a.fcontentid in ").append(inCondition).append(' ');
        if (WfUtils.isNotEmpty(this.processInstanceId)) {
            sql.append("and  a.fprocinstid = ? ");
        }
        sql.append("order by a.fcreatedate desc");
        String lang = RequestContext.get().getLang().toString();
        Object[] params = new Object[]{lang, this.processInstanceId};
        if (WfUtils.isEmpty(this.processInstanceId)) {
            params = new Object[]{lang};
        }
        HashMap<String, RecordItemAttachmentInfo> recordAttachmentMap = new HashMap<String, RecordItemAttachmentInfo>();
        HashMap<String, RecordItemAttachmentInfo> attIdRefCommentId = new HashMap<String, RecordItemAttachmentInfo>();
        ArrayList<Long> allAttachmentIds = new ArrayList<Long>();
        RecordItemAttachmentInfo recordAttachmentInfo = null;
        DataSet ds = DB.queryDataSet((String)"getProcessAttachments", (DBRoute)WfUtils.WFS, (String)sql.toString(), (Object[])params);
        Iterator<ApprovalRecordItem> iterator = null;
        try {
            for (Row r : ds) {
                String commentId = String.valueOf(r.get("commentId"));
                Long attachmentId = r.getLong("attachmentId");
                recordAttachmentInfo = (RecordItemAttachmentInfo)recordAttachmentMap.get(commentId);
                if (recordAttachmentInfo == null) {
                    recordAttachmentInfo = new RecordItemAttachmentInfo();
                    recordAttachmentMap.put(commentId, recordAttachmentInfo);
                }
                allAttachmentIds.add(attachmentId);
                attIdRefCommentId.put(String.valueOf(attachmentId), recordAttachmentInfo);
                recordAttachmentInfo.getAttachmentIds().add(attachmentId);
            }
        }
        catch (Throwable iter) {
            iterator = iter;
            throw iter;
        }
        finally {
            if (ds != null) {
                if (iterator != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter) {
                        ((Throwable)((Object)iterator)).addSuppressed(iter);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (CollectionUtil.isNotEmpty(allAttachmentIds)) {
            List<ApprovalAttachmentInfo> approvalAttachments = CoordinateRecordUtil.getApprovalAttachments(allAttachmentIds);
            for (ApprovalAttachmentInfo attachment : approvalAttachments) {
                recordAttachmentInfo = (RecordItemAttachmentInfo)attIdRefCommentId.get(attachment.getId());
                if (recordAttachmentInfo == null) continue;
                recordAttachmentInfo.getAttachments().add(attachment);
            }
            for (ApprovalRecordItem approvalRecordItem : approvalRecordItems) {
                recordAttachmentInfo = (RecordItemAttachmentInfo)recordAttachmentMap.get(approvalRecordItem.getCommentId());
                if (recordAttachmentInfo == null || recordAttachmentInfo.getAttachmentIds().isEmpty()) continue;
                approvalRecordItem.setState(recordAttachmentInfo.getStringIds());
                approvalRecordItem.setAttachments(recordAttachmentInfo.getAttachments());
            }
        }
    }

    private String getInCondition(Set<Long> keys) {
        int index = 0;
        int size = keys.size();
        StringBuilder sb = new StringBuilder("(");
        for (Long key : keys) {
            sb.append(key);
            if (index < size - 1) {
                sb.append(',');
            }
            ++index;
        }
        sb.append(')');
        return sb.toString();
    }

    private void createCallActivityRecordItems(List<ApprovalRecordItem> approvalRecordItems, CommentEntity comment) {
        Optional<CommentEntity> commentGetter = Optional.of(comment);
        ApprovalRecordItem approvalRecordItem = new ApprovalRecordItem();
        String activityId = comment.getActivityId();
        approvalRecordItem.setActivityId(activityId);
        approvalRecordItem.setUserNameFormat(commentGetter.map(CommentEntity::getUserNameFormatter).orElseGet(LocaleString::new).toString());
        Date time = comment.getTime();
        if (time != null) {
            approvalRecordItem.setTime(WfUtils.parseToUserZoneDateString(time));
            Date userZoneDate = WfUtils.getUserZoneDate(time);
            approvalRecordItem.setFormatTime(Long.valueOf(userZoneDate.getTime()));
            approvalRecordItem.setFormatStrTime(new SimpleDateFormat(MMDDHHMM).format(userZoneDate));
            approvalRecordItem.setResult(WFMultiLangConstants.getSSCStateName2());
            approvalRecordItem.setDecisionType("approve");
        } else {
            approvalRecordItem.setResult(WFMultiLangConstants.getDefaultStateName());
        }
        String subProcessInstanceId = commentGetter.map(CommentEntity::getSubProcessInstanceId).orElseGet(() -> 0L).toString();
        if (WfUtils.isNotEmpty(subProcessInstanceId) && !"0".equals(subProcessInstanceId)) {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId((Long)Long.valueOf(subProcessInstanceId));
            approvalRecordItem.setMessage(bpmnModel.getMainProcess().getName());
            approvalRecordItem.setCallActivity(true);
            approvalRecordItem.setAddSignMsg(this.getAddSignMsg(activityId));
            approvalRecordItem.setHandleState("willApproval");
            approvalRecordItem.setNodeType(activityId);
            approvalRecordItem.setProcInstId(subProcessInstanceId);
            approvalRecordItem.setActivityName(comment.getActivityName() + " ");
            approvalRecordItem.setGroup(subProcessInstanceId);
            approvalRecordItems.add(approvalRecordItem);
        }
    }

    private String getAddSignMsg(String activityId) {
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId((Long)this.processInstanceId);
        CallActivity callActivity = (CallActivity)bpmnModel.getFlowElement(activityId);
        String addSignMsg = callActivity == null || callActivity.getAddSignMsg() == null || callActivity.getAddSignMsg().isEmpty() ? "" : (String)callActivity.getAddSignMsg().get(RequestContext.get().getLang().toString());
        return addSignMsg;
    }

    private void createApprovalRecordItems(List<ApprovalRecordItem> approvalRecordItems, CommentEntity comment, Map<Long, ApprovalRecordItem> recordMap, String source, int index) {
        String parentTaskId;
        String richTextMessage;
        Optional<CommentEntity> commentGetter = Optional.of(comment);
        Long userId = null;
        String userName = null;
        String type = comment.getType();
        String taskId = commentGetter.map(Comment::getTaskId).orElseGet(() -> 0L).toString();
        if (COORDINATE.equals(type)) {
            return;
        }
        ApprovalRecordItem approvalRecordItem = new ApprovalRecordItem();
        String activityid = comment.getActivityId();
        if (WfUtils.isNotEmpty(taskId) && this.groups.contains(taskId)) {
            for (ApprovalRecordItem entity : approvalRecordItems) {
                if (!taskId.equalsIgnoreCase(entity.getGroup()) || !WfUtils.isNotEmpty(entity.getDecisionType())) continue;
                entity.setGroupDecisionType(comment.getDecisionType());
            }
            this.groups.remove(taskId);
            if (activityid.contains("YunzhijiaTask")) {
                return;
            }
        }
        approvalRecordItem.setSource(source);
        approvalRecordItem.setCommentId(String.valueOf(commentGetter.map(Comment::getId).orElseGet(() -> 0L)));
        approvalRecordItem.setBizIdentifyKey(comment.getBizIdentifyKey());
        approvalRecordItem.setTaskId(commentGetter.map(Comment::getTaskId).orElseGet(() -> 0L).toString());
        approvalRecordItem.setProcInstId(WfUtils.isNotEmpty(this.processInstanceId) ? this.processInstanceId.toString() : "");
        approvalRecordItem.setProcDefId(WfUtils.isNotEmpty(this.procDefId) ? this.procDefId.toString() : "");
        approvalRecordItem.setEndType(this.endType);
        approvalRecordItem.setHandleState(comment.getHandleState());
        if (comment instanceof CommentEntityImpl) {
            approvalRecordItem.setAvatar(((CommentEntityImpl)comment).getAvatar());
        }
        if (WfUtils.isNotEmpty(richTextMessage = comment.getRichTextMessage())) {
            approvalRecordItem.setMessage(richTextMessage);
        } else {
            approvalRecordItem.setMessage(comment.getMessage());
        }
        String signature = comment.getSignature();
        if (WfUtils.isNotEmpty(signature)) {
            approvalRecordItem.setSignature(signature);
        }
        approvalRecordItem.setBusinessKey(comment.getBusinessKey());
        approvalRecordItem.setEntityNumber(comment.getEntityNumber());
        approvalRecordItem.setResult(comment.getResultName());
        approvalRecordItem.setDecisionType(comment.getDecisionType());
        Date time = comment.getTime();
        if (time != null) {
            approvalRecordItem.setTime(WfUtils.parseToUserZoneDateString(time));
            Date userZoneDate = WfUtils.getUserZoneDate(time);
            approvalRecordItem.setFormatTime(Long.valueOf(userZoneDate.getTime()));
            approvalRecordItem.setFormatStrTime(new SimpleDateFormat(MMDDHHMM).format(userZoneDate));
        }
        approvalRecordItem.setActivityId(comment.getActivityId());
        approvalRecordItem.setActivityName(comment.getActivityName());
        approvalRecordItem.setSubactivityname(comment.getSubactivityname());
        Long ownerId = commentGetter.map(CommentEntity::getOwnerId).orElseGet(() -> 0L);
        if (WfUtils.isNotEmpty(ownerId) && ownerId > 0L) {
            approvalRecordItem.setOwnerId(ownerId);
        }
        userId = commentGetter.map(Comment::getUserId).orElseGet(() -> 0L);
        String userNameFormatter = commentGetter.map(CommentEntity::getUserNameFormatter).orElseGet(LocaleString::new).toString();
        approvalRecordItem.setUserNameFormat(userNameFormatter);
        userName = ParticipantHelper.getUserName((String)comment.getAssignee(), (String)userNameFormatter);
        ILocaleString assignorNameFormat = ParticipantHelper.getUserNameFormatByHiIdent((CommandContext)Context.getCommandContext(), (Long)ownerId, (Long)Long.valueOf(taskId));
        String assignorName = ParticipantHelper.getUserName((String)commentGetter.map(CommentEntity::getAssignorName).orElseGet(LocaleString::new).toString(), (String)assignorNameFormat.getLocaleValue());
        if (!(WfUtils.isEmpty(ownerId) || WfUtils.isEmpty(assignorName) || assignorName.equals(userName))) {
            approvalRecordItem.setDelegate(true);
            userName = TaskDelegateUtil.getDelegateAssigneeName((String)assignorName, (String)userName, (String)"replace");
        }
        if (WfUtils.isNotEmpty(userId) && userId > 0L) {
            approvalRecordItem.setUserStr(userId + "");
        }
        approvalRecordItem.setUserId(userId);
        approvalRecordItem.setAssignee(userName);
        if (0 == index || "submit".equals(comment.getResultNumber()) || "save".equals(comment.getResultNumber())) {
            approvalRecordItem.setGroupDecisionType("submit");
        }
        if (WfUtils.isNotEmpty(parentTaskId = comment.getGroupId()) && activityid.contains("YunzhijiaTask")) {
            approvalRecordItem.setGroup(parentTaskId);
            approvalRecordItem.setGroupDecisionType("wait");
            if (!taskId.equals(parentTaskId)) {
                this.groups.add(parentTaskId);
            }
        } else if (activityid.contains("RPATask")) {
            if (WfUtils.isEmpty(parentTaskId) || "0".equals(parentTaskId)) {
                approvalRecordItem.setGroup(approvalRecordItem.getCommentId());
            } else {
                approvalRecordItem.setGroup(parentTaskId);
            }
            approvalRecordItem.setLinks(RPAUtil.createViewLogLink((String)parentTaskId));
            approvalRecordItem.setAvatar(RPAUtil.getRPAApprovalRecordAvatar());
        } else {
            String groupId = comment.getGroupId();
            if (WfUtils.isEmpty(groupId)) {
                if ("0".equals(taskId)) {
                    approvalRecordItem.setGroup(String.valueOf(DBServiceHelper.genGlobalLongId()));
                } else {
                    approvalRecordItem.setGroup(taskId);
                }
            } else {
                approvalRecordItem.setGroup(groupId);
            }
        }
        approvalRecordItem.setTerminalWay(comment.getTerminalWay());
        approvalRecordItems.add(approvalRecordItem);
        if ("thirdComment".equals(source)) {
            if (WfUtils.isEmpty(approvalRecordItem.getHandleState())) {
                approvalRecordItem.setHandleState("approve");
            }
            if (WfUtils.isEmpty(approvalRecordItem.getDecisionType())) {
                approvalRecordItem.setDecisionType("approve");
            }
            approvalRecordItem.setNodeType(comment.getActivityId());
        } else {
            approvalRecordItem.setNodeType(comment.getCategory());
        }
        recordMap.put(comment.getId(), approvalRecordItem);
    }

    private List<ApprovalRecordItem> getCurrentApprovalItems(List<ApprovalRecordItem> approvalRecordList, Process process) {
        String lang = RequestContext.get().getLang().toString();
        ArrayList<ApprovalRecordItem> currentRecordItems = new ArrayList<ApprovalRecordItem>();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = "wf_task";
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fname", (String)"activityName", (String)"name");
        String subActivityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fsubactivityname", (String)SUBACTIVITYNAME, (String)SUBACTIVITYNAME);
        String usernameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)"c", (String)"d", (String)"fusername", (String)USERNAME, (String)USERNAME);
        String userNameFormatterSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)"c", (String)"d", (String)FUSERNAMEFORMATTER, (String)FUSERNAMEFORMATTER, (String)"usernameformatter");
        String trusteeNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)"c", (String)"d", (String)FTRUSTNAME, (String)TRUSTNAME, (String)TRUSTNAME);
        String trusteeNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)"c", (String)"d", (String)FTRUSTNAMEFORMAT, (String)TRUSTNAMEFORMAT, (String)TRUSTNAMEFORMAT);
        StringBuilder sql = new StringBuilder();
        sql.append("select c.fownerid owerId,c.fid participantId, c.fdelegateid delegateid, a.ftaskdefid actid,a.fid taskid,a.fparenttaskid parentTaskId,a.fbusinesskey businesskey,a.fentitynumber entitynumber,");
        sql.append(userNameFormatterSQL).append(",a.fcategory category,").append(subActivityNameSQL).append(",a.fhandlestate state,").append(activityNameSQL);
        sql.append(",c.ftype type,c.fownerid ownerid,c.fuserid userid,c.fispublic ispublic,a.fcreatedate createdate,a.fyzjgroupid backtoback,a.fstarterid starterid,");
        sql.append(usernameSQL).append(',').append(trusteeNameSQL).append(',').append(trusteeNameFormatSQL);
        sql.append(" from t_wf_task a left join t_wf_task_l b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("left join t_wf_participant c on a.fid = c.ftaskid left join t_wf_participant_l d on c.fid = d.fid and d.flocaleid = ? ");
        sql.append("where a.fprocinstid = ? ORDER BY createdate asc,participantId asc");
        Object[] params = new Object[]{lang, lang, this.processInstanceId};
        try (DataSet ds = DB.queryDataSet((String)"ApprovalRecord.t_wf_execution.queryExecutionInfo", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
            HashMap<Long, ArrayList<Long>> clientAndTrusteeMap = new HashMap<Long, ArrayList<Long>>();
            Iterator iter = ds.iterator();
            Long userId = null;
            String userName = null;
            CommandContext commandContext = Context.getCommandContext();
            while (iter.hasNext()) {
                FlowElement elem;
                Row r = (Row)iter.next();
                if (WfUtils.isNotEmpty(r.getLong("delegateid"))) {
                    ArrayList<Long> trusteeList = (ArrayList<Long>)clientAndTrusteeMap.get(r.getLong("owerId"));
                    if (trusteeList == null || trusteeList.isEmpty()) {
                        trusteeList = new ArrayList<Long>();
                        trusteeList.add(r.getLong("userId"));
                        clientAndTrusteeMap.put(r.getLong("owerId"), trusteeList);
                        continue;
                    }
                    trusteeList.add(r.getLong("userId"));
                    continue;
                }
                String taskId = r.get(TASKID).toString();
                if (COORDINATE.equals(r.getString("type"))) continue;
                String userNameFormatter = r.getString(FUSERNAMEFORMATTER);
                userName = ParticipantHelper.getUserName((String)r.getString(USERNAME), (String)userNameFormatter);
                String parentTaskId = r.get("parentTaskId").toString();
                String actid = r.getString(ACTID);
                userId = r.getLong("userId");
                if ("0".equals(parentTaskId)) {
                    this.groups.add(taskId);
                    if (actid.contains("YunzhijiaTask")) continue;
                }
                if (BACKTOBAKCK.equals(r.getString("backtoback")) && WfUtils.isNotEmpty(parentTaskId)) {
                    if (WfUtils.isNotEmpty(userId) && !this.currentUserId.equals(userId.toString())) continue;
                    this.removeApprovaledByGroupId(approvalRecordList, parentTaskId);
                }
                ApprovalRecordItem approvalRecordItem = new ApprovalRecordItem();
                String trusteeName = ParticipantHelper.getUserName((String)r.getString(TRUSTNAME), (String)r.getString(TRUSTNAMEFORMAT));
                if (!WfUtils.isEmpty(trusteeName)) {
                    approvalRecordItem.setDelegate(true);
                    userName = TaskDelegateUtil.getDelegateAssigneeName((String)userName, (String)trusteeName, (String)"entrust");
                }
                if (actid.contains("YunzhijiaTask") && !"0".equals(parentTaskId)) {
                    approvalRecordItem.setGroup(parentTaskId);
                } else {
                    approvalRecordItem.setGroup(taskId);
                }
                String category = r.getString("category");
                approvalRecordItem.setNodeType(category);
                approvalRecordItem.setSource("comment");
                approvalRecordItem.setScene("approvalRecord");
                approvalRecordItem.setArtificialNode(BpmnModelUtil.instanceofUserTaskOnly((String)category));
                approvalRecordItem.setTaskId(taskId);
                approvalRecordItem.setProcInstId(WfUtils.isNotEmpty(this.processInstanceId) ? this.processInstanceId.toString() : "");
                approvalRecordItem.setProcDefId(WfUtils.isNotEmpty(this.procDefId) ? this.procDefId.toString() : "");
                approvalRecordItem.setActivityName(r.getString("activityName"));
                approvalRecordItem.setGroupDecisionType("wait");
                approvalRecordItem.setBusinessKey(r.getString("businessKey"));
                approvalRecordItem.setEntityNumber(r.getString("entityNumber"));
                DurationDetailEntityManager durationManager = commandContext.getDurationDetailEntityManager();
                Long durations = durationManager.getManualSuspendDurationsCountByTaskId(Long.valueOf(taskId));
                if (durations > 0L) {
                    String state = this.getState(MANUALSUSPENDED);
                    approvalRecordItem.setState(state);
                    approvalRecordItem.setResult(" " + state);
                    approvalRecordItem.setHandleState(MANUALSUSPENDED);
                    approvalRecordItem.setGroupDecisionType(MANUALSUSPENDED);
                } else {
                    approvalRecordItem.setState(this.getState(r.getString(STATE)));
                    approvalRecordItem.setResult(" " + this.getState(r.getString(STATE)));
                    approvalRecordItem.setHandleState(r.getString(STATE));
                    if (WfUtils.isNotEmpty(actid) && actid.toLowerCase().contains(SSCAPPROVE)) {
                        approvalRecordItem.setResult(ResManager.loadKDString((String)" \u5f85\u5206\u914d", (String)"ApprovalRecordCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]));
                    }
                }
                approvalRecordItem.setTime(WfUtils.parseToUserZoneDateString(r.getDate("createDate")));
                approvalRecordItem.setActivityId(r.getString(ACTID));
                approvalRecordItem.setSubactivityname(" " + r.getString(SUBACTIVITYNAME));
                if (WfUtils.isNotEmpty(userId)) {
                    approvalRecordItem.setUserId(userId);
                    approvalRecordItem.setUserStr(userId + "");
                }
                approvalRecordItem.setUserNameFormat(userNameFormatter);
                approvalRecordItem.setAssignee(userName);
                Long ownerId = r.getLong("ownerId");
                if (WfUtils.isNotEmpty(ownerId)) {
                    approvalRecordItem.setOwnerId(ownerId);
                }
                if (process != null && WfUtils.isNotEmpty(approvalRecordItem.getActivityId()) && (elem = process.getFlowElement(approvalRecordItem.getActivityId())) instanceof UserTask) {
                    approvalRecordItem.setBizIdentifyKey(((UserTask)elem).getBizIdentifyKey());
                }
                currentRecordItems.add(approvalRecordItem);
            }
            ArrayList allTrusteeList = new ArrayList();
            for (ApprovalRecordItem currentRecordItem : currentRecordItems) {
                if (clientAndTrusteeMap.get(currentRecordItem.getUserId()) == null || ((List)clientAndTrusteeMap.get(currentRecordItem.getUserId())).isEmpty()) continue;
                allTrusteeList.addAll((Collection)clientAndTrusteeMap.get(currentRecordItem.getUserId()));
            }
            QFilter filter = new QFilter("id", "in", allTrusteeList);
            QFilter[] qFilters = new QFilter[]{filter};
            String fields = "useropenid,id";
            DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"bos_user", (String)fields, (QFilter[])qFilters);
            HashMap<Long, String> userIdAndUserOpenIdMap = new HashMap<Long, String>(dynObjs.length);
            for (DynamicObject dynObj : dynObjs) {
                userIdAndUserOpenIdMap.put(dynObj.getLong("id"), dynObj.getString("useropenid"));
            }
            for (ApprovalRecordItem currentRecordItem : currentRecordItems) {
                if (!currentRecordItem.isDelegate()) continue;
                List trusteeList = (List)clientAndTrusteeMap.get(currentRecordItem.getUserId());
                ArrayList trusteeOpenIds = new ArrayList(10);
                if (trusteeList != null && !trusteeList.isEmpty()) {
                    for (Long trusteeId : trusteeList) {
                        if (!WfUtils.isNotEmpty((String)userIdAndUserOpenIdMap.get(trusteeId))) continue;
                        trusteeOpenIds.add(userIdAndUserOpenIdMap.get(trusteeId));
                    }
                }
                currentRecordItem.setTrusteeOpenIds(trusteeOpenIds);
            }
        }
        return currentRecordItems;
    }

    private void removeApprovaledByGroupId(List<ApprovalRecordItem> approvalRecordList, String parentTaskId) {
        for (int i = approvalRecordList.size() - 1; i >= 0; --i) {
            if (!parentTaskId.equals(approvalRecordList.get(i).getGroup())) continue;
            approvalRecordList.remove(i);
        }
    }

    private String getState(String state) {
        if ("dismissed".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"ApprovalRecordCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("willApproval".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u5f85\u5ba1\u6838", (String)"ApprovalRecordCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("willHandled".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"ApprovalRecordCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("freeze".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3", (String)"ApprovalRecordCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("approved".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"ApprovalRecordCmd_10", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("suspended".equals(state)) {
            return ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"ApprovalRecordCmd_11", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (MANUALSUSPENDED.equals(state)) {
            return ResManager.loadKDString((String)"\u5df2\u624b\u52a8\u6302\u8d77", (String)"ApprovalRecordCmd_12", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return state;
    }

    public boolean getShowCoordinate(String taskId, String userId) {
        String key = taskId + "," + userId;
        Object object = this.showCoordinates.get(key);
        if (object == null) {
            object = CoordinateRecordUtil.isShowCoordinate(Long.parseLong(taskId), Long.parseLong(userId));
            this.showCoordinates.put(key, object);
        }
        return (Boolean)object;
    }
}

