/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.workflow.bpmn.converter.util.ModelConfigUtil;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.Task;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.component.approvalrecord.ApprovalAttachmentInfo;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.TableNameConstant;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfConstanst;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.cmd.task.RecordItemAttachmentInfo;
import kd.bos.workflow.engine.impl.cmd.task.UnusualApprovalRecord;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.SuspendType;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.ThirdCommentEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordGroup;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.FlowRecordUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.task.Comment;
import kd.bos.workflow.engine.task.TaskDelegateUtil;

public class ApprovalRecordOptimizationCmd
implements Command<List<IApprovalRecordGroup>> {
    private Log logger = LogFactory.getLog(this.getClass());
    public static final String COORDINATE = "coordinate";
    private static final String SSCAPPROVE = "sscapprove";
    public static final String SCENE_API = "scene_api";
    private static final String MANUALSUSPENDED = "manualSuspended";
    protected Long procDefId;
    protected Long processInstanceId;
    protected String businesskey;
    protected String endType;
    private Set<String> groups = new HashSet<String>();
    private String curTaskId = null;
    private Boolean isNewApprovalRecord = Boolean.FALSE;
    private List<IApprovalRecordItem> curNodeApprovalItems = new ArrayList<IApprovalRecordItem>();
    private String scene;
    private String currentUserId = RequestContext.get().getUserId();
    private Boolean isDisplaySetting = null;
    private static final String MMDDHHMM = "MM/dd HH:mm";
    private static final String FTRUENAME = "ftruename";
    private static final String FMESSAGE = "fmessage";
    private static final String FRESULTNAME = "fresultname";
    private static final String FASSIGNEE = "fassignee";
    private static final String FACTIVITYNAME = "factivityname";
    private static final String SUBACTIVITYNAME = "subactivityname";
    private static final String FUSERNAMEFORMATTER = "fusernameformatter";
    private static final String FACTIVITYID = "factivityid";
    private static final String FTASKID = "ftaskid";
    private static final String USERNAME = "username";
    private static final String ACTID = "actid";
    private static final String STATE = "state";
    private static final String TASKID = "taskid";
    private static final String ASSIGNORNAME = "assignorname";
    private static final String FTRUSTNAME = "ftrustname";
    private static final String TRUSTNAME = "trustname";
    private static final String FTRUSTNAMEFORMAT = "ftrustnameformat";
    private static final String TRUSTNAMEFORMAT = "trustnameformat";
    private static String[] varnames = new String[]{"businessModel", "passPercentage", "passFraction", "showThroughRules", "throughRulesType", "rulesContent", "passType"};
    private static final String DELEGATEKEY = "taskId=%1sownerId=%2s";
    private Map<String, HistoricIdentityLinkEntity> delegateParticipantMap = new HashMap<String, HistoricIdentityLinkEntity>(0);
    private Set<Long> userIdSet = new HashSet<Long>();
    private Set<Long> coordianteTaskSet = new HashSet<Long>();
    private Map<Long, List<TaskHandleLogEntity>> transferTaskMap = new HashMap<Long, List<TaskHandleLogEntity>>();
    public static final String BACKTOBAKCK = "1";

    public ApprovalRecordOptimizationCmd(Long processInstanceId, String businesskey) {
        this.processInstanceId = processInstanceId;
        this.businesskey = businesskey;
    }

    public ApprovalRecordOptimizationCmd(Long processInstanceId, String businesskey, Long procDefId, String endType) {
        this.processInstanceId = processInstanceId;
        this.businesskey = businesskey;
        this.procDefId = procDefId;
        this.endType = endType;
    }

    public ApprovalRecordOptimizationCmd(Long processInstanceId, String businesskey, String curTaskId, String scene) {
        this.processInstanceId = processInstanceId;
        this.businesskey = businesskey;
        this.scene = scene;
        this.curTaskId = WfUtils.isEmpty(curTaskId) ? "" : curTaskId;
    }

    public ApprovalRecordOptimizationCmd(Long processInstanceId, String businesskey, String curTaskId) {
        this.processInstanceId = processInstanceId;
        this.businesskey = businesskey;
        this.curTaskId = curTaskId;
    }

    public ApprovalRecordOptimizationCmd(Long processInstanceId, String businesskey, String curTaskId, Boolean isNewApprovalRecord) {
        this.processInstanceId = processInstanceId;
        this.businesskey = businesskey;
        this.curTaskId = curTaskId;
        this.isNewApprovalRecord = isNewApprovalRecord;
    }

    public List<IApprovalRecordGroup> execute(CommandContext commandContext) {
        long startTime = System.currentTimeMillis();
        this.logger.debug("start execute ApprovalRecordCmd at " + startTime);
        this.logger.info("\u5ba1\u6279\u8bb0\u5f55\uff0cbusinessKey\uff1a" + this.businesskey);
        if ("0".equals(this.businesskey)) {
            return Collections.emptyList();
        }
        try {
            HistoricProcessInstanceEntity entity = null;
            if (WfUtils.isNotEmpty(this.processInstanceId)) {
                entity = commandContext.getHistoricProcessInstanceEntityManager().findLatestAuditflowInstanceByProcessInstanceId(this.processInstanceId);
            }
            if (entity == null && WfUtils.isNotEmpty(this.businesskey)) {
                entity = commandContext.getHistoricProcessInstanceEntityManager().findLatestAuditflowInstanceByBusinessKey(this.businesskey);
            }
            if (entity == null) {
                return this.getTrdCommentByBusinessKey();
            }
            this.processInstanceId = entity.getProcessInstanceId();
            if (WfUtils.isEmpty(this.procDefId)) {
                this.procDefId = entity.getProcessDefinitionId();
            }
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModelByProcInstId((Long)this.processInstanceId);
            Process process = bpmnModel.getMainProcess();
            List<ApprovalRecordItem> itemList = this.getAllApprovalItems(process);
            List<IApprovalRecordGroup> list = this.formatData(itemList, process);
            this.logger.debug("list size before format is:" + list.size());
            try {
                Map configCache = commandContext.getProcessEngineConfiguration().getDynModelConfigCache();
                for (IApprovalRecordGroup group : list) {
                    String type;
                    String formatter;
                    if (!WfUtils.isNotEmpty(((IApprovalRecordItem)group.getChildren().get(0)).getActivityId()) || !WfUtils.isNotEmpty(formatter = ModelConfigUtil.getFormatRecordsPlugin((String)(type = process.getFlowElement(((IApprovalRecordItem)group.getChildren().get(0)).getActivityId()).getType()), (Map)configCache))) continue;
                    List ret = (List)ExternalInterfaceUtil.executeExtItf(ExtItfCallerType.FORMATFLOWRECORDS, formatter, group.getChildren());
                    group.setChildren(ret);
                }
            }
            catch (KDException e2) {
                this.logger.info(e2.getStackTraceMessage());
            }
            this.logger.debug("list size after format is:" + list.size());
            long endTime = System.currentTimeMillis();
            this.logger.debug("end execute ApprovalRecordCmd at " + endTime);
            this.logger.debug(String.format("cost %s", endTime - startTime));
            return list;
        }
        catch (KDException e) {
            this.logger.warn(e.getStackTraceMessage());
            return Collections.emptyList();
        }
    }

    private List<ApprovalRecordItem> getAllApprovalItems(Process process) {
        this.prepareCoordinateTransferTask();
        ArrayList<ApprovalRecordItem> itemList = new ArrayList<ApprovalRecordItem>();
        List<ApprovalRecordItem> allApprovalItems = this.getApprovaledItems(process);
        itemList.addAll(allApprovalItems);
        List<ApprovalRecordItem> curTempItems = this.getAllCurrentApprovalItems(itemList, process);
        itemList.addAll(curTempItems);
        if (!itemList.isEmpty() && WfUtils.isNotEmpty(this.curTaskId)) {
            for (ApprovalRecordItem item : itemList) {
                if (!this.curTaskId.equalsIgnoreCase(item.getTaskId())) continue;
                this.curNodeApprovalItems.add((IApprovalRecordItem)item);
            }
        } else {
            this.curNodeApprovalItems.addAll(curTempItems);
        }
        return itemList;
    }

    private void prepareCoordinateTransferTask() {
        if (WfUtils.isNotEmpty(this.processInstanceId)) {
            CommandContext commandContext = Context.getCommandContext();
            ArrayList<String> type = new ArrayList<String>(2);
            type.add("transfer");
            type.add(COORDINATE);
            QFilter qProcessInstanceId = new QFilter("processInstanceId", "=", (Object)this.processInstanceId);
            QFilter qType = new QFilter("type", "in", type);
            QFilter qOwner = new QFilter("ownerId", "!=", (Object)1);
            List handleLogs = commandContext.getTaskHandleLogEntityManager().findByQueryFilters(new QFilter[]{qProcessInstanceId, qType, qOwner}, "type,taskId,ownerId,owner,ownerformat,assignee,assigneeformat,delegateid,scenes", null);
            for (TaskHandleLogEntity hl : handleLogs) {
                if ("transfer".equals(hl.getType())) {
                    List<TaskHandleLogEntity> hlList = this.transferTaskMap.get(hl.getTaskId());
                    if (hlList == null || hlList.isEmpty()) {
                        hlList = new ArrayList<TaskHandleLogEntity>();
                        this.transferTaskMap.put(hl.getTaskId(), hlList);
                    }
                    hlList.add(hl);
                    if (hl.getDelegateId() <= 0L) continue;
                    this.userIdSet.add(hl.getOwnerId());
                    continue;
                }
                this.coordianteTaskSet.add(hl.getTaskId());
            }
            if (!this.coordianteTaskSet.isEmpty() && !WfAdminUtil.isWfAdmin((Long)Long.valueOf(this.currentUserId))) {
                QFilter qFilter = new QFilter(TASKID, "in", this.coordianteTaskSet);
                QFilter qCoordinate = new QFilter("type", "=", (Object)COORDINATE);
                List hilList = commandContext.getIdentityLinkEntityManager().findByQueryFilters(new QFilter[]{qFilter}, "taskid, userid", null);
                List commentList = commandContext.getCommentEntityManager().findByQueryFilters(new QFilter[]{qFilter, qCoordinate}, "taskid, userid, ownerid", null);
                this.coordianteTaskSet.clear();
                for (IdentityLinkEntity entity : hilList) {
                    if (!Long.valueOf(this.currentUserId).equals(entity.getUserId())) continue;
                    this.coordianteTaskSet.add(entity.getTaskId());
                }
                for (CommentEntity comment : commentList) {
                    if (!Long.valueOf(this.currentUserId).equals(comment.getUserId()) && !Long.valueOf(this.currentUserId).equals(comment.getOwnerId())) continue;
                    this.coordianteTaskSet.add(comment.getTaskId());
                }
            }
        }
    }

    private List<ApprovalRecordItem> getApprovaledItems(Process process) {
        return this.getApprovaledItems(process, Boolean.TRUE);
    }

    private List<ApprovalRecordItem> getApprovaledItems(Process process, Boolean containStandardComment) {
        this.prepareDelegateTask();
        ArrayList<ApprovalRecordItem> approvalRecordItems = new ArrayList<ApprovalRecordItem>();
        HashMap<Long, ApprovalRecordItem> recordMap = new HashMap<Long, ApprovalRecordItem>();
        ArrayList<Long> taskIds = new ArrayList<Long>();
        if (containStandardComment.booleanValue()) {
            this.queryApprovalItems(approvalRecordItems, recordMap, "T_WF_HICOMMENT", "T_WF_HICOMMENT_L", "comment", taskIds, process);
        }
        int standardCommentSize = approvalRecordItems.size();
        Boolean showTrdApprovalRecord = WfConfigurationUtil.showTrdApprovalRecord();
        if (showTrdApprovalRecord.booleanValue()) {
            this.queryApprovalItems(approvalRecordItems, recordMap, "T_WF_TRDHICOMMENT", "T_WF_TRDHICOMMENT_L", "thirdComment", taskIds, process);
        }
        this.setGeneralMsg(approvalRecordItems, recordMap, taskIds, process);
        if (showTrdApprovalRecord.booleanValue() && approvalRecordItems.size() > standardCommentSize) {
            this.sortApprovalRecords(approvalRecordItems);
        }
        return approvalRecordItems;
    }

    private void prepareDelegateTask() {
        CommandContext commandContext = Context.getCommandContext();
        if (WfUtils.isNotEmpty(this.processInstanceId)) {
            List hiParticipant = commandContext.getHistoricIdentityLinkEntityManager().findByProcInstIdAndTypeAndTrustNameNotNull(this.processInstanceId, "participant", "taskId,userId,usernameformatter");
            for (HistoricIdentityLinkEntity entity : hiParticipant) {
                Long taskId = entity.getTaskId();
                Long userId = entity.getUserId();
                this.delegateParticipantMap.put(String.format(DELEGATEKEY, taskId, userId), entity);
            }
        }
    }

    private void queryApprovalItems(List<ApprovalRecordItem> approvalRecordItems, Map<Long, ApprovalRecordItem> recordMap, String tableName, String tableMultiName, String source, List<Long> taskIds, Process process) {
        List result;
        QFilter qFilter;
        List types = UnusualApprovalRecord.getTypes();
        CommandContext commandContext = Context.getCommandContext();
        if ("T_WF_TRDHICOMMENT".equals(tableName)) {
            qFilter = WfUtils.isEmpty(this.processInstanceId) ? new QFilter("businessKey", "=", (Object)this.businesskey) : new QFilter("processInstanceId", "=", (Object)this.processInstanceId);
            ThirdCommentEntityManager trdCommentEntityManager = commandContext.getTrdCommentEntityManager();
            result = trdCommentEntityManager.findApprovalRecordByAuth(qFilter.toArray(), "step,time");
        } else {
            qFilter = new QFilter("processInstanceId", "=", (Object)this.processInstanceId);
            CommentEntityManager commentEntityManager = commandContext.getCommentEntityManager();
            result = commentEntityManager.findApprovalRecordByAuth(qFilter.toArray(), "step,time");
        }
        HashMap<Long, Map<String, String>> userInfos = new HashMap<Long, Map<String, String>>();
        int index = 0;
        List commentEntities = Optional.ofNullable(result).orElseGet(ArrayList::new);
        for (CommentEntity comment : commentEntities) {
            taskIds.add(comment.getTaskId());
            Long userId = comment.getUserId();
            String activityId = comment.getActivityId();
            String groupId = comment.getGroupId();
            boolean isExist = false;
            if (null != userId && -1L == userId && groupId != null) {
                for (int i = 0; i < approvalRecordItems.size(); ++i) {
                    ApprovalRecordItem approvalRecordItem = approvalRecordItems.get(i);
                    if (!userId.equals(approvalRecordItem.getUserId()) || !activityId.equals(approvalRecordItem.getActivityId()) || !groupId.equals(approvalRecordItem.getGroup())) continue;
                    isExist = true;
                    break;
                }
            }
            if (isExist) continue;
            if (this.isUnusualActivity(activityId, types)) {
                this.createUnusualApprovalRecord(approvalRecordItems, activityId, comment);
                continue;
            }
            this.createApprovalRecordItems(approvalRecordItems, comment, recordMap, source, userInfos, process, index);
            ++index;
        }
    }

    private void createApprovalRecordItems(List<ApprovalRecordItem> approvalRecordItems, CommentEntity comment, Map<Long, ApprovalRecordItem> recordMap, String source, Map<Long, Map<String, String>> userInfos, Process process, int index) {
        String parentTaskId;
        String richTextMessage;
        Optional<CommentEntity> commentGetter = Optional.of(comment);
        Long userId = null;
        String userName = null;
        String type = comment.getType();
        String taskId = commentGetter.map(Comment::getTaskId).orElseGet(() -> 0L).toString();
        if (COORDINATE.equals(type)) {
            return;
        }
        ApprovalRecordItem approvalRecordItem = new ApprovalRecordItem();
        String activityid = comment.getActivityId();
        if (WfUtils.isNotEmpty(taskId) && this.groups.contains(taskId)) {
            for (ApprovalRecordItem entity : approvalRecordItems) {
                if (!taskId.equalsIgnoreCase(entity.getGroup()) || !WfUtils.isNotEmpty(entity.getDecisionType())) continue;
                entity.setGroupDecisionType(comment.getDecisionType());
            }
            this.groups.remove(taskId);
            if (activityid.contains("YunzhijiaTask")) {
                return;
            }
        }
        approvalRecordItem.setSource(source);
        approvalRecordItem.setCommentId(String.valueOf(commentGetter.map(Comment::getId).orElseGet(() -> 0L)));
        approvalRecordItem.setBizIdentifyKey(comment.getBizIdentifyKey());
        approvalRecordItem.setTaskId(commentGetter.map(Comment::getTaskId).orElseGet(() -> 0L).toString());
        approvalRecordItem.setProcInstId(WfUtils.isNotEmpty(this.processInstanceId) ? this.processInstanceId.toString() : "");
        approvalRecordItem.setProcDefId(WfUtils.isNotEmpty(this.procDefId) ? this.procDefId.toString() : "");
        approvalRecordItem.setEndType(this.endType);
        if (process != null) {
            approvalRecordItem.setProcessCode(process.getNumber());
            approvalRecordItem.setProcessName(process.getName());
            approvalRecordItem.setProcessVersion(process.getVersion());
        }
        approvalRecordItem.setHandleState(comment.getHandleState());
        if (comment instanceof CommentEntityImpl) {
            approvalRecordItem.setAvatar(((CommentEntityImpl)comment).getAvatar());
        }
        if (WfUtils.isNotEmpty(richTextMessage = comment.getRichTextMessage())) {
            approvalRecordItem.setMessage(richTextMessage);
        } else {
            approvalRecordItem.setMessage(comment.getMessage());
        }
        String signature = comment.getSignature();
        if (WfUtils.isNotEmpty(signature)) {
            approvalRecordItem.setSignature(signature);
        }
        approvalRecordItem.setBusinessKey(comment.getBusinessKey());
        approvalRecordItem.setEntityNumber(comment.getEntityNumber());
        approvalRecordItem.setResult(" " + comment.getResultName());
        approvalRecordItem.setDecisionType(comment.getDecisionType());
        Date time = comment.getTime();
        if (time != null) {
            approvalRecordItem.setTime(WfUtils.parseToUserZoneDateString(time));
            Date userZoneDate = WfUtils.getUserZoneDate(time);
            approvalRecordItem.setFormatTime(Long.valueOf(userZoneDate.getTime()));
            approvalRecordItem.setFormatStrTime(new SimpleDateFormat(MMDDHHMM).format(userZoneDate));
        }
        approvalRecordItem.setActivityId(comment.getActivityId());
        approvalRecordItem.setActivityName(comment.getActivityName() + " ");
        approvalRecordItem.setSubactivityname(comment.getSubactivityname() + " ");
        Long ownerId = commentGetter.map(CommentEntity::getOwnerId).orElseGet(() -> 0L);
        if (WfUtils.isNotEmpty(ownerId) && ownerId > 0L) {
            approvalRecordItem.setOwnerId(ownerId);
            this.userIdSet.add(ownerId);
        }
        userId = commentGetter.map(Comment::getUserId).orElseGet(() -> 0L);
        String userNameFormatter = commentGetter.map(CommentEntity::getUserNameFormatter).orElseGet(LocaleString::new).toString();
        approvalRecordItem.setUserNameFormat(userNameFormatter);
        userName = ParticipantHelper.getUserName((String)comment.getAssignee(), (String)userNameFormatter);
        HistoricIdentityLinkEntity delegater = this.delegateParticipantMap.get(String.format(DELEGATEKEY, taskId, ownerId));
        if (delegater != null) {
            ILocaleString assignorNameFormat = delegater.getUserNameFormatter();
            String assignorName = ParticipantHelper.getUserName((String)commentGetter.map(CommentEntity::getAssignorName).orElseGet(LocaleString::new).toString(), (String)assignorNameFormat.toString());
            if (!WfUtils.isEmpty(ownerId) && !WfUtils.isEmpty(assignorName)) {
                approvalRecordItem.setDelegate(true);
                userName = TaskDelegateUtil.getDelegateAssigneeName((String)assignorName, (String)userName, (String)"replace");
            }
        }
        String uName = "";
        if (WfUtils.isNotEmpty(userId) && userId > 0L) {
            approvalRecordItem.setUserStr(userId + "");
            approvalRecordItem.setCoordinate(CoordinateRecordUtil.isShowCoordinate(Long.parseLong(taskId), Long.valueOf(RequestContext.get().getUserId())));
            this.userIdSet.add(userId);
        }
        approvalRecordItem.setUserId(userId);
        approvalRecordItem.setAssignee(userName);
        if (0 == index || "submit".equals(comment.getResultNumber()) || "save".equals(comment.getResultNumber())) {
            approvalRecordItem.setGroupDecisionType("submit");
        }
        if (WfUtils.isNotEmpty(parentTaskId = comment.getGroupId()) && activityid.contains("YunzhijiaTask")) {
            approvalRecordItem.setGroup(parentTaskId);
            approvalRecordItem.setGroupDecisionType("wait");
            if (!taskId.equals(parentTaskId)) {
                this.groups.add(parentTaskId);
            }
        } else {
            approvalRecordItem.setGroup(taskId);
        }
        approvalRecordItem.setTerminalWay(comment.getTerminalWay());
        approvalRecordItems.add(approvalRecordItem);
        recordMap.put(comment.getId(), approvalRecordItem);
        if ("thirdComment".equals(source)) {
            if (WfUtils.isEmpty(approvalRecordItem.getHandleState())) {
                approvalRecordItem.setHandleState("approve");
            }
            if (WfUtils.isEmpty(approvalRecordItem.getDecisionType())) {
                approvalRecordItem.setDecisionType("approve");
            }
            approvalRecordItem.setNodeType(comment.getActivityId());
        } else {
            approvalRecordItem.setNodeType(comment.getCategory());
        }
        this.setAddSignMsg(approvalRecordItem, process);
    }

    private void setAddSignMsg(ApprovalRecordItem item, Process process) {
        AuditTask auditTask;
        Map addSignMsg;
        if (process == null) {
            return;
        }
        FlowElement flowElement = process.getFlowElement(item.getActivityId());
        if (flowElement instanceof AuditTask && (addSignMsg = (auditTask = (AuditTask)flowElement).getAddSignMsg()) != null) {
            LocaleString itemAddSignMsg = new LocaleString();
            itemAddSignMsg.setLocaleValue_zh_CN((String)addSignMsg.get(Lang.zh_CN.name()));
            itemAddSignMsg.setLocaleValue_zh_TW((String)addSignMsg.get(Lang.zh_TW.name()));
            itemAddSignMsg.setLocaleValue_en((String)addSignMsg.get(Lang.en_US.name()));
            item.setAddSignMsg(itemAddSignMsg.toString());
        }
    }

    private boolean isUnusualActivity(String activityId, List<String> types) {
        if (WfUtils.isNotEmpty(activityId)) {
            for (String type : types) {
                if (!activityId.contains(type)) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private void createUnusualApprovalRecord(List<ApprovalRecordItem> approvalRecordItems, String activityId, CommentEntity comment) {
        UnusualApprovalRecord[] values = UnusualApprovalRecord.values();
        if (WfUtils.isNotEmpty(activityId)) {
            for (UnusualApprovalRecord value : values) {
                if (!activityId.contains(value.getType())) continue;
                ApprovalRecordItem item = value.createHistoryApprovalRecord(comment, this.delegateParticipantMap);
                if (item != null) {
                    approvalRecordItems.add(item);
                }
                return;
            }
        }
    }

    private void setGeneralMsg(List<ApprovalRecordItem> approvalRecordItems, Map<Long, ApprovalRecordItem> recordMap, List<Long> taskIds, Process process) {
        DynamicObject[] taskObjects;
        if (approvalRecordItems.isEmpty()) {
            return;
        }
        Map<String, RecordItemAttachmentInfo> recordAttachmentMap = this.getAttachmentMap(recordMap);
        HashMap<Long, DynamicObject> taskMapping = new HashMap<Long, DynamicObject>();
        if (!taskIds.isEmpty() && (taskObjects = BusinessDataServiceHelper.load((String)EntityNumberConstant.getHiTaskInstEntityNumber(), (String)"id,handlestate", (QFilter[])new QFilter[]{new QFilter("id", "in", taskIds)})) != null && taskObjects.length > 0) {
            for (DynamicObject task : taskObjects) {
                taskMapping.put(task.getLong("id"), task);
            }
        }
        QFilter filter = new QFilter("id", "in", this.userIdSet);
        QFilter[] qFilters = new QFilter[]{filter};
        String fields = "useropenid,name,picturefield,id";
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"bos_user", (String)fields, (QFilter[])qFilters);
        HashMap<Long, DynamicObject> userMsgMap = new HashMap<Long, DynamicObject>(dynObjs.length);
        for (DynamicObject dynObj : dynObjs) {
            userMsgMap.put(dynObj.getLong("id"), dynObj);
        }
        String entrust = WfConfigurationUtil.getTransferName();
        if ("en_US".equals(Lang.get().toString())) {
            entrust = " " + entrust + " ";
        }
        for (ApprovalRecordItem approvalRecordItem : approvalRecordItems) {
            Long taskId;
            RecordItemAttachmentInfo recordAttachmentInfo = recordAttachmentMap.get(approvalRecordItem.getCommentId());
            if (recordAttachmentInfo != null && !recordAttachmentInfo.getAttachmentIds().isEmpty()) {
                approvalRecordItem.setState(recordAttachmentInfo.getStringIds());
                approvalRecordItem.setAttachments(recordAttachmentInfo.getAttachments());
            }
            Long l = taskId = WfUtils.isNotEmpty(approvalRecordItem.getTaskId()) ? Long.valueOf(approvalRecordItem.getTaskId()) : null;
            if (!taskMapping.isEmpty() && taskMapping.containsKey(taskId)) {
                approvalRecordItem.setHandleState(((DynamicObject)taskMapping.get(taskId)).getString("handlestate"));
            }
            this.setUserMsg(process, userMsgMap, approvalRecordItem);
            this.setTransferMsg(userMsgMap, approvalRecordItem, entrust);
        }
    }

    private void setUserMsg(Process process, Map<Long, DynamicObject> userMsgMap, ApprovalRecordItem approvalRecordItem) {
        DynamicObject userMsg;
        Long userId = approvalRecordItem.getUserId();
        if (WfUtils.isNotEmpty(userId) && userId > 0L && (userMsg = userMsgMap.get(userId)) != null) {
            Object userOpenId;
            if (WfUtils.isNotEmpty(approvalRecordItem.getActivityId()) && process != null) {
                UserTask userTask = (UserTask)process.getFlowElement(approvalRecordItem.getActivityId());
                boolean participantdisplaysetting = false;
                if (userTask.getParticipant() != null) {
                    participantdisplaysetting = userTask.getParticipant().isDisplaySetting();
                }
                if (participantdisplaysetting || this.isDisplaySetting()) {
                    approvalRecordItem.setShowUserNameFormat(true);
                }
            }
            if (StringUtils.isBlank((CharSequence)approvalRecordItem.getAvatar())) {
                approvalRecordItem.setAvatar(WfUtils.getAbsAvatarPath(userMsg.get("picturefield")));
            }
            if ((userOpenId = userMsg.get("useropenid")) != null) {
                approvalRecordItem.setOpenId(userOpenId.toString());
            }
        }
    }

    private void setTransferMsg(Map<Long, DynamicObject> userMsgMap, ApprovalRecordItem approvalRecordItem, String entrust) {
        Long userId = approvalRecordItem.getUserId();
        Long taskId = WfUtils.isNotEmpty(approvalRecordItem.getTaskId()) ? Long.valueOf(approvalRecordItem.getTaskId()) : null;
        Long ownerId = approvalRecordItem.getOwnerId();
        List<TaskHandleLogEntity> transferTasks = this.transferTaskMap.get(taskId);
        if (transferTasks == null || transferTasks.isEmpty()) {
            return;
        }
        for (TaskHandleLogEntity transferTask : transferTasks) {
            DynamicObject owner;
            if (transferTask == null || "coordinateTask".equals(transferTask.getScenes())) continue;
            if (WfUtils.isNotEmpty(transferTask.getDelegateId()) && WfUtils.isEmpty(ownerId) && this.delegateParticipantMap.get(String.format(DELEGATEKEY, taskId, userId)) != null) {
                ownerId = transferTask.getOwnerId();
            }
            if (!WfUtils.isNotEmpty(ownerId) || (owner = userMsgMap.get(ownerId)) == null) continue;
            approvalRecordItem.setShowTransferRecord(true);
            if (!WfUtils.isNotEmpty(approvalRecordItem.getMessage())) continue;
            String truename = approvalRecordItem.getOwnerName();
            if (WfUtils.isEmpty(truename)) {
                truename = owner.getString("name");
            }
            approvalRecordItem.getOwnerName();
            ILocaleString userName = WfUtils.findUserName(userId);
            if (ownerId.equals(transferTask.getOwnerId())) {
                truename = transferTask.getOwnerFormat().getLocaleValue();
                userName = transferTask.getAssigneeFormat();
            }
            approvalRecordItem.setMessage(approvalRecordItem.getMessage() + " (" + truename + entrust + (WfUtils.isNotEmpty(userName) ? userName : "") + ')');
        }
    }

    private List<ApprovalRecordItem> getAllCurrentApprovalItems(List<ApprovalRecordItem> itemList, Process process) {
        CommandContext commandContext = Context.getCommandContext();
        List<ApprovalRecordItem> curTempItems = this.getCurrentApprovalItems(itemList, process);
        List types = UnusualApprovalRecord.getTypes();
        List flowElementList = process.getFlowElementList();
        if (!types.isEmpty() && flowElementList != null && !flowElementList.isEmpty()) {
            for (FlowElement flowElement : flowElementList) {
                if (!types.contains(flowElement.getType())) continue;
                QFilter qActivityType = new QFilter("activityType", "in", (Object)types);
                QFilter qProcessInstanceId = new QFilter("processInstanceId", "=", (Object)this.processInstanceId);
                QFilter qEndTime = new QFilter("endTime", "is null", (Object)Boolean.TRUE);
                List historicActivityInstanceEntities = commandContext.getHistoricActivityInstanceEntityManager().findByQueryFilters(new QFilter[]{qProcessInstanceId, qEndTime, qActivityType});
                for (HistoricActivityInstanceEntity entity : historicActivityInstanceEntities) {
                    ApprovalRecordItem curTempItem = UnusualApprovalRecord.valueOf((String)entity.getActivityType()).createCurrentApprovalRecord(entity);
                    if (curTempItem == null) continue;
                    curTempItems.add(curTempItem);
                }
            }
        }
        return curTempItems;
    }

    private List<ApprovalRecordItem> getCurrentApprovalItems(List<ApprovalRecordItem> approvalRecordList, Process process) {
        String lang = RequestContext.get().getLang().toString();
        ArrayList<ApprovalRecordItem> currentRecordItems = new ArrayList<ApprovalRecordItem>();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNumber = "wf_task";
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fname", (String)"activityName", (String)"name");
        String subActivityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fsubactivityname", (String)SUBACTIVITYNAME, (String)SUBACTIVITYNAME);
        String usernameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)"c", (String)"d", (String)"fusername", (String)USERNAME, (String)USERNAME);
        String userNameFormatterSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)"c", (String)"d", (String)FUSERNAMEFORMATTER, (String)FUSERNAMEFORMATTER, (String)"usernameformatter");
        String trusteeNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)"c", (String)"d", (String)FTRUSTNAME, (String)TRUSTNAME, (String)TRUSTNAME);
        String trusteeNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)"c", (String)"d", (String)FTRUSTNAMEFORMAT, (String)TRUSTNAMEFORMAT, (String)TRUSTNAMEFORMAT);
        StringBuilder sql = new StringBuilder();
        sql.append("select c.fownerid owerId,c.fid participantId, c.fdelegateid delegateid, a.ftaskdefid actid,a.fprocdefid procdefid, a.fid taskid,a.fparenttaskid parentTaskId,a.fbusinesskey businesskey,a.fentitynumber entitynumber,");
        sql.append(userNameFormatterSQL).append(",a.fcategory category,").append(subActivityNameSQL).append(",a.fhandlestate state,").append(activityNameSQL);
        sql.append(",c.ftype type,c.fownerid ownerid,c.fuserid userid,c.fispublic ispublic,a.fcreatedate createdate,a.fyzjgroupid backtoback,a.fstarterid starterid,a.fsuspensionstate suspensionstate,");
        sql.append(usernameSQL).append(',').append(trusteeNameSQL).append(',').append(trusteeNameFormatSQL);
        sql.append(" from t_wf_task a left join t_wf_task_l b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("left join t_wf_participant c on a.fid = c.ftaskid left join t_wf_participant_l d on c.fid = d.fid and d.flocaleid = ? ");
        sql.append("where a.fprocinstid = ? ORDER BY createdate asc,participantId asc");
        HashSet<Long> currentUserIdSet = new HashSet<Long>();
        Object[] params = new Object[]{lang, lang, this.processInstanceId};
        HashMap<Long, ArrayList<Long>> clientAndTrusteeMap = new HashMap<Long, ArrayList<Long>>();
        try (DataSet ds = DB.queryDataSet((String)"ApprovalRecord.t_wf_execution.queryExecutionInfo", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
            Iterator iter = ds.iterator();
            Long userId = null;
            String userName = null;
            while (iter.hasNext()) {
                FlowElement elem;
                DynamicObject[] r = (DynamicObject[])iter.next();
                if (WfUtils.isNotEmpty(r.getLong("delegateid"))) {
                    ArrayList<Long> trusteeList = (ArrayList<Long>)clientAndTrusteeMap.get(r.getLong("owerId"));
                    if (trusteeList == null || trusteeList.isEmpty()) {
                        trusteeList = new ArrayList<Long>();
                        trusteeList.add(r.getLong("userId"));
                        clientAndTrusteeMap.put(r.getLong("owerId"), trusteeList);
                        continue;
                    }
                    trusteeList.add(r.getLong("userId"));
                    continue;
                }
                String taskId = r.get(TASKID).toString();
                if (COORDINATE.equals(r.getString("type"))) continue;
                String userNameFormatter = r.getString(FUSERNAMEFORMATTER);
                userName = ParticipantHelper.getUserName((String)r.getString(USERNAME), (String)userNameFormatter);
                String parentTaskId = r.get("parentTaskId").toString();
                String actid = r.getString(ACTID);
                userId = r.getLong("userId");
                if ("0".equals(parentTaskId)) {
                    this.groups.add(taskId);
                    if (actid.contains("YunzhijiaTask")) continue;
                }
                if (BACKTOBAKCK.equals(r.getString("backtoback")) && WfUtils.isNotEmpty(parentTaskId)) {
                    if (WfUtils.isNotEmpty(userId) && !this.currentUserId.equals(userId.toString())) continue;
                    this.removeApprovaledByGroupId(approvalRecordList, parentTaskId);
                }
                ApprovalRecordItem approvalRecordItem = new ApprovalRecordItem();
                String trusteeName = ParticipantHelper.getUserName((String)r.getString(TRUSTNAME), (String)r.getString(TRUSTNAMEFORMAT));
                if (!WfUtils.isEmpty(trusteeName)) {
                    approvalRecordItem.setDelegate(true);
                    userName = TaskDelegateUtil.getDelegateAssigneeName((String)userName, (String)trusteeName, (String)"entrust");
                }
                if (actid.contains("YunzhijiaTask") && !"0".equals(parentTaskId)) {
                    approvalRecordItem.setGroup(parentTaskId);
                } else {
                    approvalRecordItem.setGroup(taskId);
                }
                String category = r.getString("category");
                approvalRecordItem.setNodeType(category);
                approvalRecordItem.setSource("comment");
                approvalRecordItem.setScene("approvalRecord");
                approvalRecordItem.setArtificialNode(BpmnModelUtil.instanceofUserTaskOnly((String)category));
                approvalRecordItem.setTaskId(taskId);
                approvalRecordItem.setProcInstId(WfUtils.isNotEmpty(this.processInstanceId) ? this.processInstanceId.toString() : "");
                approvalRecordItem.setProcDefId(WfUtils.isNotEmpty(this.procDefId) ? this.procDefId.toString() : "");
                approvalRecordItem.setActivityName(r.getString("activityName"));
                approvalRecordItem.setGroupDecisionType("wait");
                approvalRecordItem.setBusinessKey(r.getString("businessKey"));
                approvalRecordItem.setEntityNumber(r.getString("entityNumber"));
                approvalRecordItem.setProcDefId(r.getString("procdefid"));
                int suspensionstate = r.getInteger("suspensionstate");
                int manualSuspend = Integer.parseInt(SuspendType.MANUALSUSPEND.getCode());
                if (suspensionstate == manualSuspend) {
                    String state = this.getState(MANUALSUSPENDED);
                    approvalRecordItem.setState(state);
                    approvalRecordItem.setResult(" " + state);
                    approvalRecordItem.setHandleState(MANUALSUSPENDED);
                    approvalRecordItem.setGroupDecisionType(MANUALSUSPENDED);
                } else {
                    approvalRecordItem.setState(this.getState(r.getString(STATE)));
                    approvalRecordItem.setResult(" " + this.getState(r.getString(STATE)));
                    approvalRecordItem.setHandleState(r.getString(STATE));
                    if (WfUtils.isNotEmpty(actid) && actid.toLowerCase().contains(SSCAPPROVE)) {
                        approvalRecordItem.setResult(ResManager.loadKDString((String)" \u5f85\u5206\u914d", (String)"ApprovalRecordCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]));
                    }
                }
                approvalRecordItem.setTime(WfUtils.parseToUserZoneDateString(r.getDate("createDate")));
                approvalRecordItem.setActivityId(r.getString(ACTID));
                approvalRecordItem.setSubactivityname(" " + r.getString(SUBACTIVITYNAME));
                if (WfUtils.isNotEmpty(userId)) {
                    approvalRecordItem.setUserId(userId);
                    approvalRecordItem.setUserStr(userId + "");
                }
                if (WfUtils.isNotEmpty(userId) && userId > 0L) {
                    approvalRecordItem.setUserStr(userId + "");
                    currentUserIdSet.add(userId);
                    approvalRecordItem.setCoordinate(CoordinateRecordUtil.isShowCoordinate(Long.parseLong(taskId), Long.valueOf(RequestContext.get().getUserId())));
                }
                Long ownerId = r.getLong("ownerId");
                approvalRecordItem.setUserNameFormat(userNameFormatter);
                approvalRecordItem.setAssignee(userName);
                if (WfUtils.isNotEmpty(ownerId)) {
                    approvalRecordItem.setOwnerId(ownerId);
                    currentUserIdSet.add(ownerId);
                } else {
                    List<TaskHandleLogEntity> taskHandLogs = this.transferTaskMap.get(Long.valueOf(taskId));
                    if (taskHandLogs != null && !taskHandLogs.isEmpty()) {
                        for (TaskHandleLogEntity taskHandLog : taskHandLogs) {
                            if (taskHandLog == null || !WfUtils.isNotEmpty(taskHandLog.getDelegateId())) continue;
                            currentUserIdSet.add(taskHandLog.getOwnerId());
                        }
                    }
                }
                if (process != null && WfUtils.isNotEmpty(approvalRecordItem.getActivityId()) && (elem = process.getFlowElement(approvalRecordItem.getActivityId())) instanceof UserTask) {
                    approvalRecordItem.setBizIdentifyKey(((UserTask)elem).getBizIdentifyKey());
                }
                this.setAddSignMsg(approvalRecordItem, process);
                currentRecordItems.add(approvalRecordItem);
            }
        }
        if (!currentUserIdSet.isEmpty() && !currentRecordItems.isEmpty()) {
            QFilter filter = new QFilter("id", "in", currentUserIdSet);
            QFilter[] qFilters = new QFilter[]{filter};
            String fields = "useropenid,name,picturefield,id";
            DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"bos_user", (String)fields, (QFilter[])qFilters);
            HashMap<Long, DynamicObject> userMsgMap = new HashMap<Long, DynamicObject>(dynObjs.length);
            for (DynamicObject dynObj : dynObjs) {
                userMsgMap.put(dynObj.getLong("id"), dynObj);
            }
            String entrust = WfConfigurationUtil.getTransferName();
            if ("en_US".equals(Lang.get().toString())) {
                entrust = " " + entrust + " ";
            }
            for (ApprovalRecordItem approvalRecordItem : currentRecordItems) {
                this.setUserMsg(process, userMsgMap, approvalRecordItem);
                this.setTransferMsg(userMsgMap, approvalRecordItem, entrust);
            }
        }
        ArrayList allTrusteeList = new ArrayList();
        for (ApprovalRecordItem currentRecordItem : currentRecordItems) {
            if (clientAndTrusteeMap.get(currentRecordItem.getUserId()) == null || ((List)clientAndTrusteeMap.get(currentRecordItem.getUserId())).isEmpty()) continue;
            allTrusteeList.addAll((Collection)clientAndTrusteeMap.get(currentRecordItem.getUserId()));
        }
        QFilter filter = new QFilter("id", "in", allTrusteeList);
        QFilter[] qFilters = new QFilter[]{filter};
        String fields = "useropenid,id";
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)"bos_user", (String)fields, (QFilter[])qFilters);
        HashMap<Long, String> userIdAndUserOpenIdMap = new HashMap<Long, String>(dynObjs.length);
        for (DynamicObject dynObj : dynObjs) {
            userIdAndUserOpenIdMap.put(dynObj.getLong("id"), dynObj.getString("useropenid"));
        }
        for (ApprovalRecordItem currentRecordItem : currentRecordItems) {
            if (!currentRecordItem.isDelegate()) continue;
            ArrayList trusteeOpenIds = new ArrayList(10);
            List trusteeList = (List)clientAndTrusteeMap.get(currentRecordItem.getUserId());
            if (trusteeList != null && !trusteeList.isEmpty()) {
                for (Long trusteeId : trusteeList) {
                    if (!WfUtils.isNotEmpty((String)userIdAndUserOpenIdMap.get(trusteeId))) continue;
                    trusteeOpenIds.add(userIdAndUserOpenIdMap.get(trusteeId));
                }
            }
            currentRecordItem.setTrusteeOpenIds(trusteeOpenIds);
        }
        return currentRecordItems;
    }

    public List<IApprovalRecordGroup> formatData(List<ApprovalRecordItem> items, Process process) {
        ArrayList<IApprovalRecordGroup> approvalRecordItems = new ArrayList<IApprovalRecordGroup>();
        if (WfUtils.isNotEmptyForCollection(items)) {
            HashSet<String> groupIds = new HashSet<String>(items.size());
            int size = items.size();
            for (int i = size - 1; i >= 0; --i) {
                Task element;
                String actId;
                String groupId;
                ApprovalRecordItem item = items.get(i);
                boolean canContinue = this.getCanContinue(item, items);
                if (canContinue || !groupIds.add(groupId = item.getGroup())) continue;
                ApprovalRecordGroup approvalRecordGroup = new ApprovalRecordGroup();
                approvalRecordGroup.setGroup(item.getGroup());
                String groupDecisionType = item.getGroupDecisionType();
                if (WfUtils.isEmpty(groupDecisionType)) {
                    approvalRecordGroup.setGroupDecisionType(item.getDecisionType());
                } else {
                    approvalRecordGroup.setGroupDecisionType(groupDecisionType);
                    if (MANUALSUSPENDED.equals(groupDecisionType) && this.isNewApprovalRecord.booleanValue()) {
                        approvalRecordGroup.setActivityName(item.getActivityName());
                    }
                }
                List<Object> children = new ArrayList<ApprovalRecordItem>();
                if (item.getActivityId() != null && item.getActivityId().contains("CallActivity")) {
                    children.add(item);
                    approvalRecordGroup.setCallActivity(Boolean.TRUE);
                    if (process != null) {
                        FlowRecordUtil.executeFormatPlugin((Process)process, (IApprovalRecordItem)item);
                    }
                } else {
                    children = this.getChildren(groupId, items, process);
                }
                if (CollectionUtil.isNotEmpty(children) && process != null) {
                    Map addSignMsg;
                    actId = ((IApprovalRecordItem)children.get(0)).getActivityId();
                    element = (Task)process.findFlowElementsOfTypeAndId(Task.class, actId, false);
                    if (element != null && "YunzhijiaTask".equals(element.getType())) {
                        approvalRecordGroup.setGroupType("huiqian");
                        approvalRecordGroup.setActivityName(element.getName() + " ");
                        approvalRecordGroup.setThroughRule(this.getYunzhijiaVoteRule((IApprovalRecordItem)item, (YunzhijiaTask)element));
                    } else if (element != null && "SSCApprove".equals(element.getType())) {
                        approvalRecordGroup.setActivityName(element.getName() + " ");
                    }
                    if (element instanceof AuditTask && (addSignMsg = ((AuditTask)element).getAddSignMsg()) != null) {
                        approvalRecordGroup.setAddSignMsg((String)addSignMsg.get(RequestContext.get().getLang().toString()));
                    }
                }
                if (children.size() > 1 && WfUtils.isNotEmpty(actId = ((IApprovalRecordItem)children.get(0)).getActivityId()) && process != null) {
                    element = (Task)process.findFlowElementsOfTypeAndId(Task.class, actId, false);
                    String elementType = element.getType();
                    approvalRecordGroup.setActivityName(element.getName() + " ");
                    if ("YunzhijiaTask".equals(elementType)) {
                        approvalRecordGroup.setThroughRule(this.getYunzhijiaVoteRule((IApprovalRecordItem)item, (YunzhijiaTask)element));
                        approvalRecordGroup.setGroupType("huiqian");
                    } else if (BpmnModelUtil.instanceofAuditTask((String)elementType) && !"SSCApprove".equals(elementType)) {
                        approvalRecordGroup.setThroughRule(WFMultiLangConstants.getApprovalByAnyoneName());
                    }
                }
                if ("wait".equals(approvalRecordGroup.getGroupDecisionType())) {
                    boolean showCoordinate = this.isShowCoordinate(children);
                    approvalRecordGroup.setShowCoordnate(Boolean.valueOf(showCoordinate));
                    this.excludeStandardComment(children);
                }
                approvalRecordGroup.setChildren(children);
                approvalRecordItems.add((IApprovalRecordGroup)approvalRecordGroup);
            }
            this.setAutoCoordinateValue(approvalRecordItems, groupIds);
            Collections.reverse(approvalRecordItems);
        }
        return approvalRecordItems;
    }

    private String getYunzhijiaVoteRule(IApprovalRecordItem item, YunzhijiaTask currentNode) {
        String message = null;
        CommandContext commandContext = Context.getCommandContext();
        Long taskId = Long.valueOf(item.getTaskId());
        HistoricTaskInstanceEntity hitask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId);
        if (null == hitask) {
            return null;
        }
        Map varMap = commandContext.getHistoricVariableInstanceEntityManager().findHistoricVariableInstancesByTaskIdAndVarNames(hitask.getParentTaskId(), varnames);
        if (!varMap.isEmpty()) {
            YunzhijiaTask yzjTask = new YunzhijiaTask();
            yzjTask.setBusinessModel(((HistoricVariableInstanceEntity)varMap.get("businessModel")).getTextValue());
            HistoricVariableInstanceEntity value = (HistoricVariableInstanceEntity)varMap.get("passFraction");
            HistoricVariableInstanceEntity valuePassType = (HistoricVariableInstanceEntity)varMap.get("passType");
            if (value != null) {
                yzjTask.setPasstype("passByFraction");
                yzjTask.setPassfraction(value.getTextValue());
            } else if (valuePassType != null) {
                yzjTask.setPasstype("passByAnyOne");
            } else {
                yzjTask.setPasstype("passByPercent");
                value = (HistoricVariableInstanceEntity)varMap.get("passPercentage");
                if (value != null) {
                    yzjTask.setPassPercentage(value.getDoubleValue().doubleValue());
                } else {
                    this.logger.debug("The variable passPercentage value is null!");
                }
            }
            HistoricVariableInstanceEntity showThroughRulesEntity = (HistoricVariableInstanceEntity)varMap.get("showThroughRules");
            HistoricVariableInstanceEntity throughRulesTypeEntity = (HistoricVariableInstanceEntity)varMap.get("throughRulesType");
            HistoricVariableInstanceEntity rulesContentEntity = (HistoricVariableInstanceEntity)varMap.get("rulesContent");
            boolean isShowThroughRules = showThroughRulesEntity == null ? currentNode.isShowThroughRules() : Boolean.parseBoolean(showThroughRulesEntity.getTextValue());
            String throughRulesType = throughRulesTypeEntity == null ? currentNode.getThroughRulesType() : throughRulesTypeEntity.getTextValue();
            String rulesContent = rulesContentEntity == null ? currentNode.getRulesContent() : rulesContentEntity.getTextValue();
            yzjTask.setShowThroughRules(isShowThroughRules);
            yzjTask.setThroughRulesType(throughRulesType);
            yzjTask.setRulesContent(rulesContent);
            message = BpmnModelUtil.getYunzhijiaThroughRules((YunzhijiaTask)yzjTask, (Long)hitask.getProcessInstanceId());
        } else {
            message = BpmnModelUtil.getYunzhijiaThroughRules((YunzhijiaTask)currentNode, (Long)hitask.getProcessInstanceId());
        }
        return message;
    }

    private void excludeStandardComment(List<IApprovalRecordItem> children) {
        if (CollectionUtil.isNotEmpty(children)) {
            ArrayList<IApprovalRecordItem> temp = new ArrayList<IApprovalRecordItem>();
            for (IApprovalRecordItem child : children) {
                if (!"thirdComment".equals(child.getSource())) continue;
                temp.add(child);
            }
            if (!temp.isEmpty()) {
                children.clear();
                children.addAll(temp);
            }
        }
    }

    private void setAutoCoordinateValue(List<IApprovalRecordGroup> approvalRecordItems, Set<String> groupIds) {
        QFilter q4;
        DynamicObject[] dynamicObjects2;
        ArrayList<Long> groupIdList = new ArrayList<Long>();
        if (groupIds != null && !groupIds.isEmpty()) {
            for (String id : groupIds) {
                if (!WfUtils.isNotEmpty(id)) continue;
                groupIdList.add(Long.parseLong(id));
            }
        }
        HashSet<String> hasAutoCoordinateGroupIds = new HashSet<String>(approvalRecordItems.size());
        QFilter q3 = new QFilter(TASKID, "in", groupIdList);
        QFilter q2 = new QFilter("ownerid", "=", (Object)WfConstanst.ADMIN);
        QFilter q1 = new QFilter("type", "=", (Object)COORDINATE);
        DynamicObject[] dynamicObjects1 = BusinessDataServiceHelper.load((String)"wf_participant", (String)"id,taskid", (QFilter[])new QFilter[]{q3, q2, q1});
        if (dynamicObjects1 != null && dynamicObjects1.length > 0) {
            this.getAutoCoordinateTaskIds(hasAutoCoordinateGroupIds, dynamicObjects1, TASKID);
        }
        if ((dynamicObjects2 = BusinessDataServiceHelper.load((String)"wf_participant", (String)"id,taskid", (QFilter[])new QFilter[]{q4 = new QFilter("parenttaskid", "in", groupIdList), q2, q1})) != null && dynamicObjects2.length > 0) {
            this.getAutoCoordinateTaskIds(hasAutoCoordinateGroupIds, dynamicObjects1, TASKID);
        }
        QFilter q5 = new QFilter("groupid", "in", groupIds);
        DynamicObject[] dynamicObjects3 = BusinessDataServiceHelper.load((String)EntityNumberConstant.getHiCommentEntityNumber(), (String)"id,groupid", (QFilter[])new QFilter[]{q2, q1, q5});
        if (dynamicObjects3 != null && dynamicObjects3.length > 0) {
            this.getAutoCoordinateTaskIds(hasAutoCoordinateGroupIds, dynamicObjects3, "groupid");
        }
        for (IApprovalRecordGroup approvalRecordGroup : approvalRecordItems) {
            if (hasAutoCoordinateGroupIds.contains(approvalRecordGroup.getGroup())) {
                ((ApprovalRecordGroup)approvalRecordGroup).setShowAutoCoordinate(Boolean.TRUE);
                continue;
            }
            ((ApprovalRecordGroup)approvalRecordGroup).setShowAutoCoordinate(Boolean.FALSE);
        }
    }

    private void getAutoCoordinateTaskIds(Set<String> hasAutoCoordinateGroupIds, DynamicObject[] dynamicObjects, String key) {
        for (DynamicObject dynamicObject : dynamicObjects) {
            String groupId = dynamicObject.getString(key);
            hasAutoCoordinateGroupIds.add(groupId);
        }
    }

    private boolean isShowCoordinate(List<IApprovalRecordItem> children) {
        if (CollectionUtil.isEmpty(children)) {
            return false;
        }
        for (IApprovalRecordItem child : children) {
            ApprovalRecordItem item = (ApprovalRecordItem)child;
            boolean coordinate = item.isCoordinate();
            if (!coordinate || !"willApproval".equals(item.getHandleState()) || !coordinate) continue;
            return coordinate;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IApprovalRecordItem> getChildren(String group, List<ApprovalRecordItem> items, Process process) {
        ArrayList<IApprovalRecordItem> children = new ArrayList<IApprovalRecordItem>();
        int i = 0;
        for (ApprovalRecordItem item : items) {
            if (!group.equals(item.getGroup())) continue;
            Long userid = item.getUserId();
            String taskId = item.getTaskId();
            item.setUserStr(userid + "");
            item.setScene("approvalRecord");
            String uName = "";
            if (i > 0 && !SCENE_API.equals(this.scene)) {
                if (i == 1) {
                    ((IApprovalRecordItem)children.get(0)).setActivityName("");
                }
                item.setActivityName("");
            }
            item.setCurrentUserId(this.currentUserId);
            try {
                if (this.curNodeApprovalItems != null && !this.curNodeApprovalItems.isEmpty()) {
                    item.setCurrentApprovalRecordItem(this.curNodeApprovalItems);
                }
                if (process != null) {
                    FlowRecordUtil.executeFormatPlugin((Process)process, (IApprovalRecordItem)item);
                }
            }
            catch (Exception e) {
                this.logger.error(WfUtils.getExceptionStacktrace(e));
            }
            finally {
                item.setCurrentApprovalRecordItem(null);
            }
            children.add((IApprovalRecordItem)item);
            ++i;
        }
        return children;
    }

    private boolean getCanContinue(ApprovalRecordItem item, List<ApprovalRecordItem> items) {
        boolean canContinue = false;
        if ("thirdComment".equals(item.getSource()) && item.getTaskId() != null) {
            for (ApprovalRecordItem tempItem : items) {
                if ("thirdComment".equals(tempItem.getSource()) || !item.getTaskId().equals(tempItem.getTaskId())) continue;
                canContinue = true;
            }
        }
        return canContinue;
    }

    protected boolean isDisplaySetting() {
        if (this.isDisplaySetting == null) {
            this.isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        }
        return this.isDisplaySetting;
    }

    private StringBuilder getApprovalItemsSql(String tableName, String tableMultiName) {
        String hiCommentEntityNumber = EntityNumberConstant.getHiCommentEntityNumber();
        String convertedTableName = TableNameConstant.getRealTableName((String)tableName.toLowerCase());
        String convertedTableMultiName = String.format("%s_l", convertedTableName);
        StringBuilder sql = new StringBuilder();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String messageSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)FMESSAGE, (String)FMESSAGE, (String)"message");
        String resultNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)FRESULTNAME, (String)FRESULTNAME, (String)"resultname");
        String assigneeSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)FASSIGNEE, (String)FASSIGNEE, (String)"assignee");
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)FACTIVITYNAME, (String)FACTIVITYNAME, (String)"activityname");
        String subActivityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fsubactivityname", (String)SUBACTIVITYNAME, (String)SUBACTIVITYNAME);
        String userNameFormatterSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)FUSERNAMEFORMATTER, (String)FUSERNAMEFORMATTER, (String)"usernameformatter");
        String assignorNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)hiCommentEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)FTRUSTNAME, (String)ASSIGNORNAME, (String)ASSIGNORNAME);
        sql.append("select ").append(messageSQL).append(", a.frichtextmessage richTextMessage,a.fprocinstid fprocinstid,");
        sql.append(userNameFormatterSQL).append(" ,a.fid,a.ftaskid,a.ftype,a.fuserid,").append(resultNameSQL);
        sql.append(",a.fdecisiontype,a.fownerid,a.ftime,a.fgroupid,a.fbusinesskey,a.fentitynumber,").append(assigneeSQL).append(",a.factivityid,");
        sql.append(activityNameSQL).append(',').append(subActivityNameSQL).append(", a.FRESULTNUMBER resultNumber,").append(assignorNameSQL).append(',');
        sql.append(" '' handlestate, a.fispublic,a.fbizidentifykey,a.fstep fstep,a.fterminalway fterminalway,a.fsubprocessinstanceid fsubprocessinstanceid, ");
        if ("T_WF_TRDHICOMMENT".equals(tableName)) {
            sql.append(" a.factivityid facttype ");
        } else {
            sql.append(" a.fcategory facttype ");
        }
        sql.append("from ");
        sql.append(convertedTableName);
        sql.append(" a left join ");
        sql.append(convertedTableMultiName);
        sql.append(" b on a.fid=b.fid ");
        if ("T_WF_TRDHICOMMENT".equals(tableName) && WfUtils.isEmpty(this.processInstanceId)) {
            sql.append("where a.fbusinesskey=?");
        } else {
            sql.append("where a.fprocinstid=?");
        }
        sql.append(" and b.FLOCALEID = ? and a.ftype!='forceReject' ORDER BY a.fstep ,a.ftime ASC ");
        return sql;
    }

    private void sortApprovalRecords(List<ApprovalRecordItem> approvalRecordItems) {
        final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        approvalRecordItems.sort((Comparator<ApprovalRecordItem>)new Comparator<IApprovalRecordItem>(){

            @Override
            public int compare(IApprovalRecordItem iApprovalRecordItemBefore, IApprovalRecordItem iApprovalRecordItemAfter) {
                String beforeRecord = iApprovalRecordItemBefore.getTime();
                String afterRecord = iApprovalRecordItemAfter.getTime();
                try {
                    long beforeRecordTime = sdf.parse(beforeRecord).getTime();
                    long afterRecordTime = sdf.parse(afterRecord).getTime();
                    if (beforeRecordTime > afterRecordTime) {
                        return 1;
                    }
                    if (beforeRecordTime < afterRecordTime) {
                        return -1;
                    }
                }
                catch (ParseException e) {
                    ApprovalRecordOptimizationCmd.this.logger.error(WfUtils.getExceptionStacktrace(e));
                }
                return 0;
            }
        });
    }

    private Map<String, RecordItemAttachmentInfo> getAttachmentMap(Map<Long, ApprovalRecordItem> recordMap) {
        String inCondition = this.getInCondition(recordMap.keySet());
        StringBuilder sql = new StringBuilder();
        sql.append("select a.furlid attachmentId, a.fcontentid commentId from t_wf_hiattachment a ");
        sql.append("left join t_wf_hiattachment_l b on b.fid = a.fid and b.flocaleid = ? ");
        sql.append("where a.fuserid != 1 and a.fcontentid in ").append(inCondition).append(' ');
        if (WfUtils.isNotEmpty(this.processInstanceId)) {
            sql.append("and  a.fprocinstid = ? ");
        }
        sql.append("order by a.fcreatedate desc");
        String lang = RequestContext.get().getLang().toString();
        Object[] params = new Object[]{lang, this.processInstanceId};
        if (WfUtils.isEmpty(this.processInstanceId)) {
            params = new Object[]{lang};
        }
        HashMap<String, RecordItemAttachmentInfo> recordAttachmentMap = new HashMap<String, RecordItemAttachmentInfo>();
        HashMap<String, RecordItemAttachmentInfo> attIdRefCommentId = new HashMap<String, RecordItemAttachmentInfo>();
        ArrayList<Long> allAttachmentIds = new ArrayList<Long>();
        RecordItemAttachmentInfo recordAttachmentInfo = null;
        DataSet ds = DB.queryDataSet((String)"getProcessAttachments", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);
        Object object = null;
        try {
            for (Row r : ds) {
                String commentId = String.valueOf(r.get("commentId"));
                Long attachmentId = r.getLong("attachmentId");
                recordAttachmentInfo = (RecordItemAttachmentInfo)recordAttachmentMap.get(commentId);
                if (recordAttachmentInfo == null) {
                    recordAttachmentInfo = new RecordItemAttachmentInfo();
                    recordAttachmentMap.put(commentId, recordAttachmentInfo);
                }
                allAttachmentIds.add(attachmentId);
                attIdRefCommentId.put(String.valueOf(attachmentId), recordAttachmentInfo);
                recordAttachmentInfo.getAttachmentIds().add(attachmentId);
            }
        }
        catch (Throwable iter) {
            object = iter;
            throw iter;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable iter) {
                        ((Throwable)object).addSuppressed(iter);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (CollectionUtil.isNotEmpty(allAttachmentIds)) {
            List<ApprovalAttachmentInfo> approvalAttachments = CoordinateRecordUtil.getApprovalAttachments(allAttachmentIds);
            for (ApprovalAttachmentInfo attachment : approvalAttachments) {
                recordAttachmentInfo = (RecordItemAttachmentInfo)attIdRefCommentId.get(attachment.getId());
                if (recordAttachmentInfo == null) continue;
                recordAttachmentInfo.getAttachments().add(attachment);
            }
        }
        return recordAttachmentMap;
    }

    private String getInCondition(Set<Long> keys) {
        int index = 0;
        int size = keys.size();
        StringBuilder sb = new StringBuilder("(");
        for (Long key : keys) {
            sb.append(key);
            if (index < size - 1) {
                sb.append(',');
            }
            ++index;
        }
        sb.append(')');
        return sb.toString();
    }

    private void removeApprovaledByGroupId(List<ApprovalRecordItem> approvalRecordList, String parentTaskId) {
        for (int i = approvalRecordList.size() - 1; i >= 0; --i) {
            if (!parentTaskId.equals(approvalRecordList.get(i).getGroup())) continue;
            approvalRecordList.remove(i);
        }
    }

    private String getState(String state) {
        if ("dismissed".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"ApprovalRecordCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("willApproval".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u5f85\u5ba1\u6838", (String)"ApprovalRecordCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("willHandled".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"ApprovalRecordCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("freeze".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3", (String)"ApprovalRecordCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("approved".equalsIgnoreCase(state)) {
            return ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"ApprovalRecordCmd_10", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("suspended".equals(state)) {
            return ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"ApprovalRecordCmd_11", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (MANUALSUSPENDED.equals(state)) {
            return ResManager.loadKDString((String)"\u5df2\u624b\u52a8\u6302\u8d77", (String)"ApprovalRecordCmd_12", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return state;
    }

    private List<IApprovalRecordGroup> getTrdCommentByBusinessKey() {
        List<ApprovalRecordItem> items = this.getApprovaledItems(null, Boolean.FALSE);
        if (WfUtils.isNotEmptyForCollection(items)) {
            for (int i = 0; i < items.size(); ++i) {
                ApprovalRecordItem approvalRecordItem = items.get(i);
                approvalRecordItem.setGroup(String.valueOf(DBServiceHelper.genGlobalLongId()));
            }
            return this.formatData(items, null);
        }
        return Collections.emptyList();
    }
}

