/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.AutoTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.DecisionOption;
import kd.bos.workflow.bpmn.model.EndEvent;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Gateway;
import kd.bos.workflow.bpmn.model.NotifyTask;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SelectNodesModel;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.bpmn.model.StartEvent;
import kd.bos.workflow.bpmn.model.Task;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.AuditRuleForYzjUtil;
import kd.bos.workflow.engine.WfAfterAuditUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.bpmn.behavior.UserTaskActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.WarpGatewayActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.YunzhijiaNotifyActivityBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.YunzhijiaParallelMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.bpmn.behavior.YunzhijiaSequentialMultiInstanceBehavior;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculatorImpl;
import kd.bos.workflow.engine.impl.cmd.GetLastAuditCountCmd;
import kd.bos.workflow.engine.impl.cmd.model.GetParticipantDisplayValue;
import kd.bos.workflow.engine.impl.cmd.precomputation.PreComputorHelper;
import kd.bos.workflow.engine.impl.cmd.task.GetNextNodeWhenRejectToParentProcessCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.monitor.worktransfer.WorksTransferLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.PreComputatorExecutionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.precomputor.IPreComputorRecord;
import kd.bos.workflow.engine.precomputor.IPreComputorRecordItem;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFErrorCode;

public class GetNextUseableUserTaskNodeCmd
implements Command<List<Map<String, Object>>>,
Serializable {
    private static final long serialVersionUID = 2486837981335247483L;
    public static final String REASON_TYPE_HASNOTREJECTNODE = "hasNotRejectNode";
    public static final String REASON_TYPE_NOTFINDNODE = "notFindNode";
    public static final String REASON_TYPE_PLUGININFLOW = "pluginInFlow";
    public static final String REASON_TYPE_NOPERSION = "noPersion";
    public static final String REASON_TYPE_SKIPNODE = "skipNode";
    public static final String REASON_TYPE_AUTOAUDITNODE = "autoAuditNode";
    public static final String REASON = "reason";
    public static final String ACTID = "actId";
    public static final String AUDITNUMBER = "auditNumber";
    public static final String BOS_USER = "bos_user";
    public static final String NEXTNODEID = "nextNodeId";
    private static final String SSCAPPROVE = "SSCApprove";
    private final Log log = LogFactory.getLog(this.getClass());
    protected UserTask currentNode;
    protected String businessKey;
    protected Long taskId;
    protected Map<String, Object> variables;
    protected Process process;
    protected BpmnModel bpmnModel;
    private ExecutionEntity execution;
    protected ParticipantCalculator participantCalculator;
    protected Map<String, String> nodeIdMapAuditNumber = new HashMap<String, String>();
    private Map<String, String> nodeIdMapLastNodeAuditType = new HashMap<String, String>();
    protected Map<String, String> nodeIdMapAgreePersonId = new HashMap<String, String>();
    protected Map<String, String> nodeIdMapExecutionType = new HashMap<String, String>();
    private Map<String, TaskEntity> nextTasks = new HashMap<String, TaskEntity>();
    protected String lastNodId;
    protected String lastAssign;
    protected TaskInfo taskInfo = null;
    private CommandContext commandContextForCurrent;
    private Map<String, Object> reasonMap = new HashMap<String, Object>();
    private int cycleCount = 0;
    private IPreComputorRecord preComputorRecord = null;
    private List<Long> adjacentNodeUserIds = new ArrayList<Long>(1);
    private Map<String, List<FlowElement>> previousNodes = new HashMap<String, List<FlowElement>>();

    public GetNextUseableUserTaskNodeCmd(UserTask userTask, String businessKey, Long taskId, Map<String, Object> variables) {
        this.currentNode = userTask;
        this.businessKey = businessKey;
        this.taskId = taskId;
        this.variables = variables;
    }

    public GetNextUseableUserTaskNodeCmd(String businessKey, TaskInfo task, Map<String, Object> variables) {
        this.businessKey = businessKey;
        this.taskId = task.getId();
        this.taskInfo = task;
        this.variables = variables;
    }

    public GetNextUseableUserTaskNodeCmd(UserTask userTask, TaskInfo task, Map<String, Object> variables) {
        this.currentNode = userTask;
        this.businessKey = task.getBusinessKey();
        this.taskId = task.getId();
        this.variables = variables;
        this.taskInfo = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        this.commandContextForCurrent = commandContext;
        commandContext.setGetNextNodeCmd(true);
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        TaskEntity task = (TaskEntity)this.taskInfo;
        if (task == null) {
            task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
        }
        if (null == task) {
            throw ExceptionUtil.createWFMessageServiceException(null, null, (ErrorCode)WFErrorCode.taskNotFound(), (Object[])new Object[0]);
        }
        ExecutionEntity orandialExecution = task.getExecution();
        try {
            task.setTransientVariablesLocal(this.variables);
            String auditType = (String)this.variables.get("auditType");
            if (auditType == null) {
                if (BpmnModelUtil.instanceofAuditTask((String)task.getCategory())) {
                    ArrayList<Map<String, Object>> arrayList = list;
                    return arrayList;
                }
                if (BpmnModelUtil.instanceofUserTaskOnly((String)task.getCategory())) {
                    auditType = "";
                }
            }
            Long procdefId = task.getProcessDefinitionId();
            Long procinstid = task.getProcessInstanceId();
            this.bpmnModel = ProcessDefinitionUtil.getBpmnModel((Long)task.getProcessDefinitionId(), (Long)task.getProcessInstanceId());
            this.process = this.bpmnModel.getMainProcess();
            if (this.currentNode == null) {
                this.currentNode = (UserTask)this.process.getFlowElement(task.getTaskDefinitionKey());
            }
            this.execution = task.getExecution() instanceof ExecutionEntityImpl ? new PreComputatorExecutionEntityImpl((ExecutionEntityImpl)task.getExecution()) : new PreComputatorExecutionEntityImpl((PreComputatorExecutionEntityImpl)task.getExecution());
            this.execution.setTransientVariable("isPreComputator", (Object)true);
            Object billInfo = this.variables.get("billInfo");
            if (billInfo instanceof DynamicObject) {
                ((PreComputatorExecutionEntityImpl)this.execution).setTransientBill((DynamicObject)billInfo);
                task.setExecution(this.execution);
            }
            this.execution.setTransientVariable("scene", (Object)"getNextNode");
            this.setTaskResultVariable(this.currentNode, this.getDecisionNumber(this.currentNode, auditType, (String)this.variables.get(AUDITNUMBER)));
            task.setExecution(this.execution);
            this.participantCalculator = commandContext.getProcessEngineConfiguration().getParticipantCalculator();
            String actid = task.getTaskDefinitionKey();
            String category = task.getCategory();
            if ("approve".equals(auditType)) {
                TaskEntity parentTask = task.getParentTaskInstance();
                if (parentTask == null) {
                    this.adjacentNodeUserIds.addAll(task.getParticipants());
                } else {
                    this.adjacentNodeUserIds.addAll(parentTask.getParticipants());
                }
            }
            this.getAgreePersonId(procinstid, auditType, procdefId, actid, category);
            this.lastNodId = this.currentNode.getId();
            if (WfUtils.isEmpty(this.lastAssign)) {
                this.lastAssign = RequestContext.get().getUserId();
            }
            this.nodeIdMapExecutionType.put(this.currentNode.getId(), "byHand");
            boolean isBackRejectedActivity = false;
            List<FlowNode> finalUserTaskNodes = new ArrayList<FlowNode>();
            isBackRejectedActivity = this.getNextNodeForRejectBackToNode(commandContext, task, auditType, isBackRejectedActivity, finalUserTaskNodes);
            HashMap<String, Object> rejectReasonMap = new HashMap<String, Object>();
            String auditNumber = (String)this.variables.get(AUDITNUMBER);
            if (this.isDynamicRejectToParentProcess((FlowNode)this.currentNode, auditType, auditNumber)) {
                DecisionOption decisionOption = BpmnModelUtil.getDecisionOption((AuditTask)((AuditTask)this.currentNode), (String)auditNumber);
                List list2 = new GetNextNodeWhenRejectToParentProcessCmd(this.execution.getSuperExecution(), decisionOption.getDecisionScene(), this.variables).execute(commandContext);
                return list2;
            }
            if (this.isDynamicReject(auditType, (FlowNode)this.currentNode)) {
                if ((finalUserTaskNodes = this.getDynamicReject(finalUserTaskNodes, (FlowNode)this.currentNode, task, rejectReasonMap)).isEmpty()) {
                    list.add(rejectReasonMap);
                    List<Map<String, Object>> list3 = list;
                    return list3;
                }
            } else {
                if (!isBackRejectedActivity) {
                    finalUserTaskNodes = this.getNextUseableUserTaskNodes((FlowNode)this.currentNode, (VariableScope)task, auditType, finalUserTaskNodes);
                }
                if (finalUserTaskNodes.isEmpty()) {
                    if (this.reasonMap.isEmpty()) {
                        this.reasonMap.put(REASON, ResManager.loadKDString((String)"\u672a\u9884\u8ba1\u7b97\u5230\u8282\u70b9\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u3002", (String)"GetNextUseableUserTaskNodeCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]));
                        this.reasonMap.put("type", REASON_TYPE_NOTFINDNODE);
                    }
                    list.add(this.reasonMap);
                    List<Map<String, Object>> list4 = list;
                    return list4;
                }
            }
            list = this.getUsersAndFormatData(finalUserTaskNodes, commandContext, isBackRejectedActivity, task);
        }
        catch (Exception e) {
            Object throwExceptionObj = this.variables.get("throwException");
            if (null != throwExceptionObj && Boolean.parseBoolean(throwExceptionObj.toString())) {
                throw e;
            }
        }
        finally {
            task.setExecution(orandialExecution);
        }
        return list;
    }

    private boolean getNextNodeForRejectBackToNode(CommandContext commandContext, TaskEntity task, String auditType, boolean isBackRejectedActivity, List<FlowNode> finalUserTaskNodes) {
        if (!"reject".equals(auditType) && "dismissed".equals(task.getHandleState()) && !"forceReject".equals(auditType)) {
            TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
            String curNodeId = task.getTaskDefinitionKey();
            Long processInstanceId = task.getProcessInstanceId();
            Long currentActInstId = task.getExecution().getCurrentActInstId();
            String rejectNodeId = taskHelper.getRejectNodeId(processInstanceId, currentActInstId);
            FlowNode rejectNode = (FlowNode)this.process.getFlowElement(rejectNodeId);
            boolean isRejectBackToNode = taskHelper.isRejectBackToNode(commandContext, task);
            UserTask userTask = (UserTask)this.process.getFlowElement(curNodeId);
            if (userTask.isBackRejectedActivity()) {
                isBackRejectedActivity = true;
                finalUserTaskNodes.add(rejectNode);
            }
            if (ForkJoinUtils.isForkNode((FlowNode)userTask) && "all".equals(userTask.getPassTypeAfterInnerReject())) {
                isRejectBackToNode = false;
            }
            if (isRejectBackToNode) {
                isBackRejectedActivity = true;
                if (WfUtils.isEmpty(rejectNodeId)) {
                    rejectNodeId = taskHelper.getRejectIdForRejectBackToNode(commandContext, task);
                    rejectNode = (FlowNode)this.process.getFlowElement(rejectNodeId);
                }
                if (rejectNode instanceof YunzhijiaTask) {
                    this.getNextUseableUserTaskNodesForYZJTask(auditType, rejectNode, finalUserTaskNodes, (FlowNode)this.currentNode, isRejectBackToNode);
                } else {
                    this.getNextUseableUserTaskNodesForAuditTask(auditType, rejectNode, finalUserTaskNodes, (FlowNode)this.currentNode, isRejectBackToNode);
                }
            }
        }
        return isBackRejectedActivity;
    }

    private void getAgreePersonId(Long proinstId, String auditType, Long prodefid, String currentNodeId, String category) {
        String findActinstSql = "SELECT a.FACTID actId, a.FTASKID taskId, a.FSTEP step, a.FCYCLE cycle FROM t_wf_hiactinst a WHERE a.FPROCINSTID = ? AND a.FTASKID != 0 ORDER BY a.FSTEP DESC";
        Object[] finActinstParams = new Object[]{proinstId};
        HashMap<String, String> taskDefKeyMapTaskId = new HashMap<String, String>();
        try (DataSet ds = DB.queryDataSet((String)"wf_task.getApprovalUser", (DBRoute)DBRoute.workflow, (String)findActinstSql, (Object[])finActinstParams);){
            for (Row r : ds) {
                String taskDefKeyMapTaskIdValue = (String)taskDefKeyMapTaskId.get(r.getString(ACTID));
                if (WfUtils.isNotEmpty(taskDefKeyMapTaskIdValue)) {
                    taskDefKeyMapTaskId.put(r.getString(ACTID), taskDefKeyMapTaskIdValue + "," + r.getLong("taskId"));
                    continue;
                }
                taskDefKeyMapTaskId.put(r.getString(ACTID), r.getString("taskId"));
            }
        }
        if (taskDefKeyMapTaskId.isEmpty()) {
            if ("approve".equals(auditType)) {
                this.nodeIdMapAgreePersonId.put(this.currentNode.getId(), RequestContext.get().getUserId());
            }
            this.nodeIdMapAuditNumber.put(this.currentNode.getId(), "" + this.variables.get(AUDITNUMBER));
            return;
        }
        StringBuilder taskIds = new StringBuilder();
        taskIds.append('(');
        List<FlowElement> elements = this.getPreviousNodes(ProcessDefinitionUtil.getBpmnModel((Long)prodefid, (Long)proinstId), currentNodeId);
        elements.add((FlowElement)this.currentNode);
        for (FlowElement key : elements) {
            if (!WfUtils.isNotEmpty((String)taskDefKeyMapTaskId.get(key.getId()))) continue;
            taskIds.append((String)taskDefKeyMapTaskId.get(key.getId())).append(',');
        }
        if (taskIds.length() < 2) {
            if ("approve".equals(auditType) && !"YunzhijiaTask".equals(category)) {
                this.nodeIdMapAgreePersonId.put(this.currentNode.getId(), RequestContext.get().getUserId());
            }
            this.nodeIdMapAuditNumber.put(this.currentNode.getId(), "" + this.variables.get(AUDITNUMBER));
            return;
        }
        HashMap latestNodeInfo = new HashMap();
        String inTasks = taskIds.substring(0, taskIds.length() - 1) + ")";
        String sql = "SELECT a.FUSERID assigneeId, a.FRESULTNUMBER, a.FGROUPID groupid, a.FACTIVITYID actId, a.FTIME FROM t_wf_hicomment a WHERE a.FTASKID in " + inTasks + " AND a.FDECISIONTYPE = 'approve' ORDER BY a.FTIME DESC ";
        Object[] params = new Object[]{};
        try (DataSet ds = DB.queryDataSet((String)"wf_task.getApprovalUser", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            for (Row r : ds) {
                Long assigneeId = r.getLong("assigneeId");
                String groupId = r.getString("groupid");
                String actId = r.getString(ACTID);
                Long latestNodeActId = (Long)latestNodeInfo.get(actId);
                if (assigneeId == null) continue;
                this.nodeIdMapAuditNumber.putIfAbsent(r.getString(ACTID), r.getString("FRESULTNUMBER"));
                if (!latestNodeInfo.containsKey(actId) || WfUtils.isNotEmpty(groupId) && StringUtils.equals((CharSequence)groupId, (CharSequence)String.valueOf(latestNodeActId))) {
                    this.nodeIdMapAgreePersonId.putIfAbsent(actId, assigneeId + "");
                    continue;
                }
                String nodeIdMapAgreePersonIdValue = this.nodeIdMapAgreePersonId.get(actId);
                if (WfUtils.isNotEmpty(nodeIdMapAgreePersonIdValue)) {
                    this.nodeIdMapAgreePersonId.put(actId, nodeIdMapAgreePersonIdValue + "," + assigneeId);
                    continue;
                }
                this.nodeIdMapAgreePersonId.put(actId, assigneeId + "");
            }
        }
        if ("approve".equals(auditType)) {
            if (this.nodeIdMapAgreePersonId.containsKey(this.currentNode.getId())) {
                String currentAgreePerson = this.nodeIdMapAgreePersonId.get(this.currentNode.getId());
                this.nodeIdMapAgreePersonId.put(this.currentNode.getId(), String.format("%s,%s", currentAgreePerson, RequestContext.get().getUserId()));
                this.lastAssign = this.nodeIdMapAgreePersonId.get(this.currentNode.getId());
            } else {
                this.nodeIdMapAgreePersonId.put(this.currentNode.getId(), RequestContext.get().getUserId());
            }
        }
        this.nodeIdMapAuditNumber.put(this.currentNode.getId(), "" + this.variables.get(AUDITNUMBER));
    }

    private List<FlowElement> getPreviousNodes(BpmnModel bpmnModel, String currentNodeId) {
        String preNodeId;
        ArrayList<FlowElement> elements = this.previousNodes.get(currentNodeId);
        if (WfUtils.isNotEmptyForCollection(elements)) {
            return elements;
        }
        FlowNode flowNode = (FlowNode)this.process.findFlowElementsOfTypeAndId(FlowNode.class, currentNodeId, false);
        if (flowNode != null && flowNode.getIncomingFlows().size() == 1 && this.previousNodes.containsKey(preNodeId = ((SequenceFlow)flowNode.getIncomingFlows().get(0)).getSourceRef())) {
            elements = new ArrayList<FlowElement>((Collection)this.previousNodes.get(preNodeId));
            elements.add(bpmnModel.getFlowElement(preNodeId));
            this.previousNodes.put(currentNodeId, new ArrayList(elements));
        }
        if (WfUtils.isEmptyForCollection(elements)) {
            elements = BpmnModelUtil.getPreviousNodes((BpmnModel)bpmnModel, (String)currentNodeId);
            this.previousNodes.put(currentNodeId, new ArrayList(elements));
        }
        return elements;
    }

    private List<Map<String, Object>> getUsersAndFormatData(List<FlowNode> finalUserTaskNodes, CommandContext commandContext, boolean isBackRejectedActivity, TaskEntity task) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (FlowNode flowNode : finalUserTaskNodes) {
            if (flowNode instanceof EndEvent || flowNode instanceof AutoTask || this.isNotifyTaskGatewayCallActivity(flowNode)) {
                HashMap<String, FlowNode> map = new HashMap<String, FlowNode>();
                map.put("nextNode", flowNode);
                list.add(map);
                continue;
            }
            if (!(flowNode instanceof UserTask)) continue;
            UserTask userTask = (UserTask)flowNode;
            List<Object> userIds = new ArrayList(2);
            List<Long> userIdsForHis = new ArrayList(2);
            List<Long> userIdsForNow = this.getNodeParticipants(userTask.getId());
            String auditType = this.nodeIdMapLastNodeAuditType.get(flowNode.getId());
            if (WfUtils.isNotEmpty(auditType) && ("reject".equals(auditType) || "forceReject".equals(auditType))) {
                List historicActivityInstanceEntities = ParticipantHelper.getHisActForParticipantFromHiActivity((CommandContext)commandContext, (Long)this.execution.getProcessInstanceId(), (String)flowNode.getId());
                HistoricActivityInstanceEntity hiActivity = ParticipantHelper.getUserIdsAndTaskIdsForParticipantFromHiActivity((List)historicActivityInstanceEntities);
                if (hiActivity != null) {
                    userIdsForHis.add(hiActivity.getAssigneeId());
                    userIds = userIdsForHis;
                    if ("skip".equals(hiActivity.getExecutionType()) && WfUtils.isNotEmptyForCollection(userIdsForNow)) {
                        userIds = userIdsForNow;
                    }
                }
                if (userIdsForHis.isEmpty() || "YunzhijiaTask".equals(flowNode.getType())) {
                    userIds = userIdsForNow;
                }
                this.judgeTransferUser(commandContext, flowNode, userIds);
            } else if (this.isFirstNodeByModel(flowNode)) {
                userIdsForHis = ParticipantHelper.getUserIdsForParticipantFromHiActivity((CommandContext)commandContext, (Long)this.execution.getProcessInstanceId(), (String)flowNode.getId());
                userIds = userIdsForHis;
            } else {
                String currentNodeId;
                String assignParticipant;
                userIds = userIdsForNow;
                if (WfConfigurationUtil.rejectToBackAndRecalculationParticipant() && isBackRejectedActivity) {
                    HistoricActivityInstanceEntity historicAct = commandContext.getHistoricActivityInstanceEntityManager().findNodeLastActiveByProcInstIdAndActivityId(this.execution.getProcessInstanceId(), flowNode.getId());
                    ParticipantCalculatorImpl participantCalculator = new ParticipantCalculatorImpl(commandContext.getProcessEngineConfiguration());
                    userIds = participantCalculator.getRejectToBackUser((FlowElement)flowNode, historicAct);
                }
                if ((assignParticipant = (String)task.getVariable((currentNodeId = this.currentNode.getId()).toLowerCase() + "assignparticipant")) != null) {
                    try {
                        List assignUserIds;
                        Map userMap;
                        Map nodesAssignParticipant = (Map)SerializationUtils.fromJsonString((String)assignParticipant, Map.class);
                        if (null != nodesAssignParticipant && null != (userMap = (Map)nodesAssignParticipant.get(currentNodeId)) && WfUtils.isNotEmptyForCollection(assignUserIds = (List)userMap.get(flowNode.getId()))) {
                            userIds = new ArrayList();
                            for (String assignUserId : assignUserIds) {
                                userIds.add(Long.valueOf(assignUserId));
                            }
                        }
                    }
                    catch (Exception nodesAssignParticipant) {
                        // empty catch block
                    }
                }
            }
            DynamicObjectCollection users = this.queryUser(userIds);
            HashMap<String, Object> map = new HashMap<String, Object>(userIds.size() + 2);
            map.put("nextNode", userTask);
            if (!SSCAPPROVE.equals(flowNode.getType())) {
                map.put("users", users);
            }
            map.put("extAttrGroup", BpmnModelUtil.extendAttributeGroupConverterToWF((FlowElement)flowNode));
            String entityNumber = userTask.getEntityNumber();
            String displayInfoStr = "";
            ParticipatantModel participant = userTask.getParticipant();
            if (participant != null) {
                displayInfoStr = participant.getDisplayInfo();
            }
            DynamicObject[] userArray = BusinessDataServiceHelper.load((String)BOS_USER, (String)"id,name,entryentity.position,entryentity.dpt,simplepinyin,fullpinyin,number,usertype,phone,email", (QFilter[])new QFilter[]{new QFilter("id", "in", userIds)});
            DynamicObjectCollection userCollection = new DynamicObjectCollection();
            for (DynamicObject user : userArray) {
                userCollection.add((Object)user);
            }
            if (WfConfigurationUtil.disablePreComputeParticipantPosition()) {
                if (WfUtils.isNotEmptyForCollection((Collection)users)) {
                    for (DynamicObject user : users) {
                        map.put(String.valueOf(user.getLong("id")), user.get("name"));
                    }
                }
            } else {
                LocaleString displayInfo = new LocaleString();
                if (WfUtils.isNotEmpty(displayInfoStr)) {
                    displayInfo = BpmnModelUtil.getMultiLangFieldValue((Long)this.execution.getProcessInstanceId(), (String)String.format("%s.participant.displayInfo", flowNode.getId()), (String)displayInfoStr);
                }
                Map formatMap = new GetParticipantDisplayValue(userCollection, (VariableScope)this.execution, (ILocaleString)displayInfo, entityNumber, this.businessKey).execute(commandContext);
                for (Map.Entry format : formatMap.entrySet()) {
                    map.put(String.valueOf(format.getKey()), format.getValue());
                }
            }
            list.add(map);
        }
        return list;
    }

    private void judgeTransferUser(CommandContext commandContext, FlowNode flowNode, List<Long> userIds) {
        try {
            if (this.isFirstNodeByModel(flowNode) && "UserTask".equalsIgnoreCase(flowNode.getType())) {
                Long processInstanceId = this.execution.getRootProcessInstanceId();
                List entities = commandContext.getWorksTransferLogEntityManager().getWorksTransferLog(processInstanceId);
                if (WfUtils.isEmptyForCollection(entities)) {
                    return;
                }
                if (userIds.isEmpty()) {
                    userIds.remove(((WorksTransferLogEntity)entities.get(0)).getOrigAuditorId());
                    userIds.add(Long.parseLong(((WorksTransferLogEntity)entities.get(0)).getNewAuditorId()));
                } else {
                    ArrayList<Long> userIdsClone = new ArrayList<Long>(userIds.size());
                    userIdsClone.addAll(userIds);
                    block2: for (Long userId : userIdsClone) {
                        for (WorksTransferLogEntity entity : entities) {
                            if (!userId.equals(entity.getOrigAuditorId())) continue;
                            userIds.remove(userId);
                            userIds.add(Long.parseLong(((WorksTransferLogEntity)entities.get(0)).getNewAuditorId()));
                            continue block2;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("GetNextUseableUserTaskNodeCmd.judgeTransferUser is error,errorInfo is :" + WfUtils.getExceptionStacktrace(e));
        }
    }

    private List<Long> getNodeParticipants(String nodeId) {
        List<Long> userIdsForNow = new ArrayList<Long>(2);
        TaskEntity nextTask = this.nextTasks.get(nodeId);
        if (nextTask != null) {
            Collection<Long> col;
            String currentParticipants = (String)nextTask.getTransientVariable("currentParticipant");
            if (WfUtils.isNotEmpty(currentParticipants) && (col = WfUtils.stringToCollection(currentParticipants, "\\,")) != null && !col.isEmpty()) {
                for (Long a : col) {
                    if (!WfUtils.isNotEmpty(a)) continue;
                    userIdsForNow.add(a);
                }
            }
        } else {
            userIdsForNow = this.participantCalculator.getNextTaskUsers(this.execution.getProcessDefinitionId(), this.execution.getProcessInstanceId(), nodeId, this.businessKey, (VariableScope)this.execution, this.nodeIdMapAuditNumber, this.nodeIdMapAgreePersonId, this.lastAssign, this.nodeIdMapExecutionType);
        }
        return userIdsForNow;
    }

    private boolean isFirstNodeByModel(FlowNode flowNode) {
        boolean first = false;
        if (flowNode.getIncomingFlows() != null) {
            List tmp = flowNode.getIncomingFlows();
            for (SequenceFlow seq : tmp) {
                if (seq == null || seq.isDynamic()) continue;
                if (seq.getSourceFlowElement() instanceof StartEvent) {
                    first = true;
                    continue;
                }
                first = false;
                break;
            }
        }
        return first;
    }

    private boolean isNotifyTaskGatewayCallActivity(FlowNode flowNode) {
        return flowNode instanceof NotifyTask || flowNode instanceof Gateway || flowNode instanceof CallActivity;
    }

    private DynamicObjectCollection queryUser(List<Long> userIds) {
        ORM orm = ORM.create();
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", userIds)};
        DynamicObjectCollection resultDisorders = orm.query(BOS_USER, "id,name", qFilters);
        DynamicObjectCollection resultOrderlys = new DynamicObjectCollection();
        block0: for (Long userId : userIds) {
            for (DynamicObject resultDisorder : resultDisorders) {
                if (!userId.equals(resultDisorder.getLong("id"))) continue;
                resultOrderlys.add((Object)resultDisorder);
                continue block0;
            }
        }
        return resultOrderlys;
    }

    private List<FlowNode> getDynamicReject(List<FlowNode> finalUserTaskNodes, FlowNode flowNode, TaskEntity task, Map<String, Object> hasnotNodeReason) {
        if (flowNode instanceof AuditTask) {
            List options = ((AuditTask)flowNode).getDecisionOptions();
            String number = (String)task.getVariable(AUDITNUMBER);
            if (number != null) {
                for (DecisionOption option : options) {
                    if (option.getNumber() == null || !option.getNumber().equals(number)) continue;
                    List rejectOptions = option.getRejectOptions();
                    if (option.isRejectPreNodeScene()) {
                        rejectOptions = DynamicFlowUtil.getUpperLevel((TaskEntity)task);
                    }
                    if (rejectOptions != null && 0 != rejectOptions.size()) {
                        SelectNodesModel map = null;
                        for (int i = rejectOptions.size() - 1; i >= 0; --i) {
                            Object reason;
                            map = (SelectNodesModel)rejectOptions.get(i);
                            this.log.debug("\u6709\u9a73\u56de\u8282\u70b9" + map.getItemId());
                            FlowNode rejectOptionFlowNode = (FlowNode)this.process.findFlowElementsOfTypeAndId(FlowNode.class, map.getItemId(), false);
                            String flowNodeType = rejectOptionFlowNode.getType();
                            this.execution.setCurrentFlowElement((FlowElement)rejectOptionFlowNode);
                            if ("CallActivity".equals(flowNodeType)) {
                                CallActivity callActivity = (CallActivity)rejectOptionFlowNode;
                                if (finalUserTaskNodes.contains(callActivity)) continue;
                                this.rejectToCallActivity(finalUserTaskNodes, hasnotNodeReason, callActivity);
                                continue;
                            }
                            this.getNodeTask(rejectOptionFlowNode);
                            if (!finalUserTaskNodes.contains(rejectOptionFlowNode) && !this.hasNotParticipant(rejectOptionFlowNode)) {
                                String type;
                                if (rejectOptionFlowNode instanceof UserTask && this.isSkipTask((UserTask)rejectOptionFlowNode)) {
                                    reason = hasnotNodeReason.get(REASON);
                                    type = (String)hasnotNodeReason.get("type");
                                    if (reason == null) {
                                        reason = String.format(ResManager.loadKDString((String)"%1$s\uff08\u8df3\u8fc7\uff09", (String)"GetNextUseableUserTaskNodeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), rejectOptionFlowNode.getName());
                                        type = REASON_TYPE_SKIPNODE;
                                    } else {
                                        type = type + "," + REASON_TYPE_SKIPNODE;
                                        reason = String.format(ResManager.loadKDString((String)"%1$s%2$s\uff08\u8df3\u8fc7\uff09", (String)"GetNextUseableUserTaskNodeCmd_11", (String)"bos-wf-engine", (Object[])new Object[0]), reason, rejectOptionFlowNode.getName());
                                    }
                                    hasnotNodeReason.put(REASON, reason);
                                    hasnotNodeReason.put("type", type);
                                    hasnotNodeReason.put(NEXTNODEID, rejectOptionFlowNode.getId());
                                    this.log.debug("\u6709\u9a73\u56de\u8282\u70b9" + map.getItemId() + "\u6ee1\u8db3\u8df3\u8fc7\u6761\u4ef6\uff0c\u8df3\u8fc7\u7406\u7531" + reason);
                                    continue;
                                }
                                if (rejectOptionFlowNode instanceof AuditTask && this.isAutoAuditTask((AuditTask)rejectOptionFlowNode)) {
                                    reason = hasnotNodeReason.get(REASON);
                                    type = (String)hasnotNodeReason.get("type");
                                    if (reason == null) {
                                        type = REASON_TYPE_AUTOAUDITNODE;
                                        reason = String.format(ResManager.loadKDString((String)"%1$s\uff08\u81ea\u52a8\u5ba1\u6279\uff09", (String)"GetNextUseableUserTaskNodeCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]), rejectOptionFlowNode.getName());
                                    } else {
                                        type = type + "," + REASON_TYPE_AUTOAUDITNODE;
                                        reason = String.format(ResManager.loadKDString((String)"%1$s%2$s\uff08\u81ea\u52a8\u5ba1\u6279\uff09", (String)"GetNextUseableUserTaskNodeCmd_12", (String)"bos-wf-engine", (Object[])new Object[0]), reason, rejectOptionFlowNode.getName());
                                    }
                                    hasnotNodeReason.put("type", type);
                                    hasnotNodeReason.put(REASON, reason);
                                    hasnotNodeReason.put(NEXTNODEID, rejectOptionFlowNode.getId());
                                    this.log.debug("\u6709\u9a73\u56de\u8282\u70b9" + map.getItemId() + "\u6ee1\u8db3\u81ea\u52a8\u5ba1\u6279\uff0c\u7406\u7531" + reason);
                                    continue;
                                }
                                this.nodeIdMapLastNodeAuditType.put(rejectOptionFlowNode.getId(), "reject");
                                finalUserTaskNodes.add(0, rejectOptionFlowNode);
                                continue;
                            }
                            reason = hasnotNodeReason.get(REASON);
                            reason = reason == null ? String.format(ResManager.loadKDString((String)"%1$s\uff08\u65e0\u53c2\u4e0e\u4eba)", (String)"GetNextUseableUserTaskNodeCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]), rejectOptionFlowNode.getName()) : String.format(ResManager.loadKDString((String)"%1$s%2$s\uff08\u65e0\u53c2\u4e0e\u4eba\uff09", (String)"GetNextUseableUserTaskNodeCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]), reason, rejectOptionFlowNode.getName());
                            hasnotNodeReason.put("type", REASON_TYPE_NOPERSION);
                            hasnotNodeReason.put(REASON, reason);
                            hasnotNodeReason.put(NEXTNODEID, rejectOptionFlowNode.getId());
                            this.log.debug("\u53ef\u9a73\u56de\u8282\u70b9" + map.getItemId() + "\u65e0\u53c2\u4e0e\u4eba");
                        }
                        break;
                    }
                    hasnotNodeReason.put("type", REASON_TYPE_HASNOTREJECTNODE);
                    if (option.isRejectPreNodeScene()) {
                        hasnotNodeReason.put(REASON, ResManager.loadKDString((String)"\u6ca1\u6709\u8ba1\u7b97\u51fa\u53ef\u9a73\u56de\u8282\u70b9\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GetNextUseableUserTaskNodeCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]));
                    } else {
                        hasnotNodeReason.put(REASON, ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u53ef\u9a73\u56de\u8282\u70b9\u3002", (String)"GetNextUseableUserTaskNodeCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]));
                    }
                    this.log.debug("\u6ca1\u6709\u53ef\u9a73\u56de\u8282\u70b9");
                    break;
                }
            }
        }
        return finalUserTaskNodes;
    }

    private void rejectToCallActivity(List<FlowNode> finalUserTaskNodes, Map<String, Object> hasnotNodeReason, CallActivity callActivity) {
        if (callActivity == null) {
            return;
        }
        if (this.isSkipTask(callActivity, this.execution)) {
            Object reason = hasnotNodeReason.get(REASON);
            String type = (String)hasnotNodeReason.get("type");
            if (reason == null) {
                type = REASON_TYPE_SKIPNODE;
                reason = String.format(ResManager.loadKDString((String)"%1$s\uff08\u8df3\u8fc7\uff09", (String)"GetNextUseableUserTaskNodeCmd_1", (String)"bos-wf-engine", (Object[])new Object[0]), callActivity.getName());
            } else {
                type = type + "," + REASON_TYPE_SKIPNODE;
                reason = String.format(ResManager.loadKDString((String)"%1$s%2$s\uff08\u8df3\u8fc7\uff09", (String)"GetNextUseableUserTaskNodeCmd_11", (String)"bos-wf-engine", (Object[])new Object[0]), reason, callActivity.getName());
            }
            hasnotNodeReason.put(REASON, reason);
            hasnotNodeReason.put("type", type);
            hasnotNodeReason.put(NEXTNODEID, callActivity.getId());
            this.log.debug("\u6709\u5b50\u6d41\u7a0b\u7c7b\u578b\u7684\u9a73\u56de\u8282\u70b9" + callActivity.getId() + "\u6ee1\u8db3\u8df3\u8fc7\u6761\u4ef6\uff0c\u8df3\u8fc7\u7406\u7531" + reason);
        } else {
            this.nodeIdMapLastNodeAuditType.put(callActivity.getId(), "reject");
            finalUserTaskNodes.add(0, (FlowNode)callActivity);
        }
    }

    protected List<FlowNode> getNextUseableUserTaskNodes(FlowNode flowNode, VariableScope variableScope, String auditType, List<FlowNode> nodes) {
        List<SequenceFlow> sequenceFlows;
        if (this.cycleCount > 100) {
            throw new KDException(ResManager.loadKDString((String)"\u9884\u8ba1\u7b97\u5931\u8d25\uff0c\u6d41\u7a0b\u9884\u6d4b\u65f6\u6b7b\u5faa\u73af\uff0c\u8bf7\u68c0\u67e5\u6d41\u7a0b\u8bbe\u7f6e\u3002", (String)"GetNextUseableUserTaskNodeCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]));
        }
        ++this.cycleCount;
        if (flowNode != this.currentNode && flowNode.getIncomingFlows().size() > 1 && this.isEnterWhenAllArrive(flowNode)) {
            int dynamics = 0;
            for (SequenceFlow s : flowNode.getIncomingFlows()) {
                if (s.isDynamic()) continue;
                ++dynamics;
            }
            if (dynamics > 1) {
                nodes.add(flowNode);
                return nodes;
            }
        }
        if (!((sequenceFlows = this.getNodeOutgoingSequences(flowNode, variableScope, auditType)).size() <= 1 || flowNode.getFork() != null && flowNode.getFork().booleanValue() && "leavewhenallmeet".equals(flowNode.getOutSet()))) {
            StringBuilder sb = new StringBuilder();
            sequenceFlows.stream().forEach(sequenceFlow -> sb.append(sequenceFlow.getNumber()).append(","));
            throw new KDException(WFErrorCode.getNextNodeErrorProcessDesigenEr(), new Object[]{flowNode.getId() + " out:" + sb});
        }
        block27: for (SequenceFlow s : sequenceFlows) {
            String nextNodeId = s.getTargetRef();
            this.filterNodeIdMapAgreePersonId(nextNodeId);
            FlowNode nextFlowNode = (FlowNode)this.process.findFlowElementsOfTypeAndId(FlowNode.class, nextNodeId, false);
            this.execution.setCurrentFlowElement((FlowElement)nextFlowNode);
            this.execution.setCurrentTask(null);
            switch (nextFlowNode.getType()) {
                case "CallActivity": {
                    CallActivity callActivity = (CallActivity)nextFlowNode;
                    if (this.isSkipTask(callActivity, this.execution)) {
                        this.nodeIdMapExecutionType.put(nextFlowNode.getId(), "skip");
                        this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)this.execution, null, nodes);
                        continue block27;
                    }
                    this.addNodes(auditType, nodes, nextFlowNode);
                    continue block27;
                }
                case "WaitTask": 
                case "BroadcastTask": 
                case "AutoTask": 
                case "RPATask": 
                case "AutoMicroServiceTask": 
                case "JudgeTask": {
                    this.nodeIdMapExecutionType.put(nextFlowNode.getId(), "byAuto");
                    this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)this.execution, null, nodes);
                    continue block27;
                }
                case "NotifyTask": {
                    this.nodeIdMapExecutionType.put(nextFlowNode.getId(), "byAuto");
                    this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)this.execution, null, nodes);
                    continue block27;
                }
                case "AuditTask": {
                    this.getNextUseableUserTaskNodesForAuditTask(auditType, nextFlowNode, nodes, flowNode, false);
                    continue block27;
                }
                case "UserTask": 
                case "HRActivity": {
                    UserTask userTask = (UserTask)nextFlowNode;
                    TaskEntity nodeTask = this.getNodeTask(nextFlowNode);
                    if (this.isSkipTask(userTask)) {
                        this.nodeIdMapAgreePersonId.put(userTask.getId(), "");
                        this.nodeIdMapAuditNumber.put(userTask.getId(), "");
                        this.nodeIdMapExecutionType.put(userTask.getId(), "skip");
                        String defaultAuditType = this.getDefaultAuditType(userTask);
                        this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)nodeTask, defaultAuditType, nodes);
                        continue block27;
                    }
                    this.addNodes(auditType, nodes, nextFlowNode);
                    continue block27;
                }
                case "YunzhijiaTask": {
                    this.getNextUseableUserTaskNodesForYZJTask(auditType, nextFlowNode, nodes, flowNode, false);
                    continue block27;
                }
                case "EndNoneEvent": {
                    if (nodes.contains(nextFlowNode)) continue block27;
                    nodes.add(nextFlowNode);
                    continue block27;
                }
                case "InclusiveGateway": {
                    this.nodeIdMapExecutionType.put(nextFlowNode.getId(), "byAuto");
                    this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)this.execution, null, nodes);
                    continue block27;
                }
            }
            this.addNodes(auditType, nodes, nextFlowNode);
        }
        return nodes;
    }

    private void getNextUseableUserTaskNodesForYZJTask(String auditType, FlowNode nextFlowNode, List<FlowNode> nodes, FlowNode flowNode, boolean rejectBackToNode) {
        YunzhijiaTask yzjTask = (YunzhijiaTask)nextFlowNode;
        TaskEntity task = this.getNodeTask(nextFlowNode);
        if (WfConfigurationUtil.rejectToBackAndAutomaticProcessingFailure() && rejectBackToNode) {
            this.addNodes(auditType, nodes, nextFlowNode);
            return;
        }
        if (this.withoutParticipantSkipThisNode((AuditTask)yzjTask, nextFlowNode, nodes)) {
            return;
        }
        if (this.isSkipTask((UserTask)yzjTask)) {
            this.nodeIdMapAgreePersonId.put(yzjTask.getId(), "");
            this.nodeIdMapAuditNumber.put(yzjTask.getId(), "");
            this.nodeIdMapExecutionType.put(yzjTask.getId(), "skip");
            String defaultAuditType = this.getDefaultAuditType((UserTask)yzjTask);
            this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)task, defaultAuditType, nodes);
        } else {
            boolean isRepeaterAndApproval;
            boolean isAddNode = true;
            boolean isAutoAuditWhenSamePerson = Boolean.TRUE.equals(this.process.getAutoAuditWhenSamePerson());
            boolean isNoNeedCountersign = "approve".equals(auditType) && yzjTask.isNoNeedCountersign();
            boolean bl = isRepeaterAndApproval = yzjTask.isRepeaterbtn() && "auto".equals(yzjTask.getRepeaterModel());
            if (isAutoAuditWhenSamePerson || isNoNeedCountersign || isRepeaterAndApproval) {
                List<Long> userIds = this.getNodeParticipants(yzjTask.getId());
                if (isAutoAuditWhenSamePerson) {
                    DecisionOption defaultDecision = WfUtils.getDefaultDecision((AuditTask)yzjTask);
                    if (this.isStarterSameAsYzjAuditor(this.execution.getStartUserId(), yzjTask, defaultDecision, userIds)) {
                        if (defaultDecision == null) {
                            throw new KDException(WFErrorCode.withoutDefaultDecisionError(), new Object[]{yzjTask.getId()});
                        }
                        isAddNode = false;
                        this.setTaskResultVariable((UserTask)yzjTask, defaultDecision.getNumber());
                        this.adjacentNodeUserIds.clear();
                        this.adjacentNodeUserIds.add(this.execution.getStartUserId());
                        this.addNodesWhenAutoAudit(flowNode, nodes, nextFlowNode, (AuditTask)yzjTask, defaultDecision.getAuditType(), defaultDecision.getNumber(), auditType);
                    }
                } else if (isNoNeedCountersign && AuditRuleForYzjUtil.isAutoAuditForNoNeedCountersign((AgentExecution)this.execution, (YunzhijiaTask)yzjTask, (int)(null == userIds ? 0 : userIds.size()), (CommandContext)this.commandContextForCurrent, null)) {
                    isAddNode = false;
                    this.setTaskResultVariable((UserTask)yzjTask, "Consent");
                    this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)task, auditType, nodes);
                } else if (isRepeaterAndApproval) {
                    ArrayList<String> userIdList = new ArrayList<String>();
                    if (yzjTask.isAdjacentnodeonly()) {
                        for (Long id : this.adjacentNodeUserIds) {
                            userIdList.add(id.toString());
                        }
                        String user = this.nodeIdMapAgreePersonId.get(flowNode.getId());
                        if (WfUtils.isNotEmpty(user)) {
                            userIdList.addAll(Arrays.asList(user.split("\\,")));
                        }
                    } else {
                        for (Map.Entry<String, String> tmp : this.nodeIdMapAuditNumber.entrySet()) {
                            Object user;
                            if (!"Consent".equals(tmp.getValue()) || !WfUtils.isNotEmpty((String)(user = this.nodeIdMapAgreePersonId.get(tmp.getKey())))) continue;
                            userIdList.addAll(Arrays.asList(((String)user).split("\\,")));
                        }
                    }
                    int countForAudit = 0;
                    ArrayList<Long> particIds = new ArrayList<Long>(16);
                    for (Long userId : userIds) {
                        boolean canCount = false;
                        String partic = userId.toString();
                        for (String userIdL : userIdList) {
                            if (!userIdL.equals(partic)) continue;
                            canCount = true;
                            particIds.add(Long.valueOf(partic));
                            break;
                        }
                        if (!canCount) continue;
                        ++countForAudit;
                    }
                    boolean isPass = false;
                    if (userIds != null && !userIds.isEmpty()) {
                        isPass = AuditRuleForYzjUtil.isAutoAuditForNoNeedCountersign(particIds, (AgentExecution)this.execution, (YunzhijiaTask)yzjTask, (int)userIds.size(), (CommandContext)this.commandContextForCurrent, (int)countForAudit, (boolean)true, null);
                    }
                    if (isPass) {
                        isAddNode = false;
                        this.nodeIdMapAgreePersonId.put(yzjTask.getId(), WfUtils.listToString(particIds, ","));
                        this.lastAssign = ((Object)particIds).toString();
                        String nextFlowNodeAuditType = "approval";
                        String decisionNumber = this.getDecisionNumber((UserTask)yzjTask, nextFlowNodeAuditType, "Consent");
                        this.nodeIdMapAuditNumber.put(yzjTask.getId(), decisionNumber);
                        this.nodeIdMapExecutionType.put(yzjTask.getId(), "byAuto");
                        task.setTransientVariableLocal(AUDITNUMBER, (Object)decisionNumber);
                        this.setTaskResultVariable((UserTask)yzjTask, "Consent");
                        this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)task, nextFlowNodeAuditType, nodes);
                    }
                }
            }
            if (isAddNode) {
                this.addNodes(auditType, nodes, nextFlowNode);
            }
        }
    }

    protected boolean isEnterWhenAllArrive(FlowNode flowNode) {
        return flowNode.getJoin() != null && flowNode.getJoin() != false && "enterwhenallarrive".equals(flowNode.getInSet());
    }

    private void getNextUseableUserTaskNodesForAuditTask(String auditType, FlowNode nextFlowNode, List<FlowNode> nodes, FlowNode flowNode, boolean rejectBackToNode) {
        AuditTask auditTask = (AuditTask)nextFlowNode;
        TaskEntity nodeTask = this.getNodeTask(nextFlowNode);
        if (WfConfigurationUtil.rejectToBackAndAutomaticProcessingFailure() && rejectBackToNode) {
            this.addNodes(auditType, nodes, nextFlowNode);
            return;
        }
        if (this.withoutParticipantSkipThisNode(auditTask, nextFlowNode, nodes)) {
            return;
        }
        if (this.isSkipTask((UserTask)auditTask)) {
            this.nodeIdMapAgreePersonId.put(auditTask.getId(), "");
            this.nodeIdMapAuditNumber.put(auditTask.getId(), "");
            this.nodeIdMapExecutionType.put(auditTask.getId(), "skip");
            String defaultAuditType = this.getDefaultAuditType((UserTask)auditTask);
            nodeTask.setTransientVariableLocal(AUDITNUMBER, (Object)"Consent");
            this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)nodeTask, defaultAuditType, nodes);
        } else if ("approve".equals(auditType) && this.isStarterSameAsAuditor(nodeTask)) {
            DecisionOption defaultDecision = WfUtils.getDefaultDecision(auditTask);
            if (defaultDecision == null) {
                throw new KDException(WFErrorCode.withoutDefaultDecisionError(), new Object[]{auditTask.getId()});
            }
            this.setTaskResultVariable((UserTask)auditTask, defaultDecision.getNumber());
            this.adjacentNodeUserIds.clear();
            this.adjacentNodeUserIds.add(nodeTask.getStarterId());
            this.addNodesWhenAutoAudit(flowNode, nodes, nextFlowNode, auditTask, defaultDecision.getAuditType(), defaultDecision.getNumber(), auditType);
        } else if (this.isAutoAuditTask(auditTask)) {
            String nextFlowNodeAuditType = this.getAutoAuditAuditType(auditTask);
            String auditNumber = auditTask.getAutoAudit().getAutoDecisionWhenMatch();
            this.setTaskResultVariable((UserTask)auditTask, auditNumber);
            if (auditTask.getAutoAudit().getParticipantAsAutoAuditor().booleanValue()) {
                this.adjacentNodeUserIds = this.getNodeParticipants(auditTask.getId());
            }
            this.addNodesWhenAutoAudit(flowNode, nodes, nextFlowNode, auditTask, nextFlowNodeAuditType, auditNumber, auditType);
        } else if (this.canDoAfterAudit(auditType, nextFlowNode, nodes, auditTask, nodeTask)) {
            List<Long> userIds = this.getNodeParticipants(auditTask.getId());
            if (this.isAfterAuditTask(auditType, auditTask, nodeTask, userIds)) {
                this.doAfterAuditSkip(nextFlowNode, nodes, auditTask, nodeTask);
            } else {
                this.addNodes(auditType, nodes, nextFlowNode);
            }
        } else if ("approve".equals(auditType) && auditTask.isRepeaterbtn() && "skip".equals(auditTask.getRepeaterModel())) {
            List<Long> userIds = this.getNodeParticipants(auditTask.getId());
            boolean allowRepeaters = WfConfigurationUtil.getRepeaterApprovalConfig(userIds);
            if (CollectionUtil.isNotEmpty(userIds) && allowRepeaters) {
                boolean hasRepeater = false;
                if (auditTask.isAdjacentnodeonly()) {
                    for (Long userId : userIds) {
                        if (this.adjacentNodeUserIds.contains(userId)) {
                            hasRepeater = true;
                        } else {
                            String user = this.nodeIdMapAgreePersonId.get(flowNode.getId());
                            if (!WfUtils.isNotEmpty(user) || !Arrays.asList(user.split("\\,")).contains(userId)) continue;
                            hasRepeater = true;
                        }
                        break;
                    }
                } else {
                    hasRepeater = this.checkRepeater(userIds);
                }
                if (hasRepeater) {
                    this.nodeIdMapAgreePersonId.put(auditTask.getId(), "");
                    this.nodeIdMapAuditNumber.put(auditTask.getId(), "");
                    this.nodeIdMapExecutionType.put(auditTask.getId(), "skip");
                    String defaultAuditType = this.getDefaultAuditType((UserTask)auditTask);
                    String decisionNumber = this.getDecisionNumber((UserTask)auditTask, "approve", null);
                    nodeTask.setTransientVariableLocal(AUDITNUMBER, (Object)decisionNumber);
                    this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)nodeTask, defaultAuditType, nodes);
                    return;
                }
                this.addNodes(auditType, nodes, nextFlowNode);
            } else {
                this.addNodes(auditType, nodes, nextFlowNode);
            }
        } else if ("approve".equals(auditType) && auditTask.isRepeaterbtn() && "auto".equals(auditTask.getRepeaterModel())) {
            List<Long> userIds = this.getNodeParticipants(auditTask.getId());
            boolean allowRepeaters = WfConfigurationUtil.getRepeaterApprovalConfig(userIds);
            if (CollectionUtil.isNotEmpty(userIds) && allowRepeaters) {
                ArrayList<String> approvelNumbers = new ArrayList<String>();
                for (DecisionOption op : auditTask.getDecisionOptions()) {
                    if (!"approve".equals(op.getAuditType())) continue;
                    approvelNumbers.add(op.getNumber());
                }
                String partic = userIds.get(0).toString();
                String repeaterKey = "";
                boolean canAutoAudit = false;
                if (auditTask.isAdjacentnodeonly()) {
                    for (Long l : userIds) {
                        if (!this.adjacentNodeUserIds.contains(l)) continue;
                        this.lastNodId = auditTask.getId();
                        canAutoAudit = true;
                        repeaterKey = this.currentNode.getId();
                        this.adjacentNodeUserIds.clear();
                        this.adjacentNodeUserIds.add(l);
                        break;
                    }
                } else {
                    for (Map.Entry entry : this.nodeIdMapAgreePersonId.entrySet()) {
                        String agreePersonIdsStr = (String)entry.getValue();
                        if (WfUtils.isNotEmpty(agreePersonIdsStr)) {
                            String[] agreePersonIds = agreePersonIdsStr.split(",");
                            for (int i = 0; i < agreePersonIds.length; ++i) {
                                if (!userIds.contains(Long.valueOf(agreePersonIds[i]))) continue;
                                this.lastNodId = auditTask.getId();
                                repeaterKey = (String)entry.getKey();
                                partic = agreePersonIds[i];
                            }
                        }
                        if (!WfUtils.isNotEmpty(repeaterKey) || !approvelNumbers.contains(this.nodeIdMapAuditNumber.get(repeaterKey))) continue;
                        canAutoAudit = true;
                        break;
                    }
                }
                if (canAutoAudit) {
                    this.nodeIdMapAgreePersonId.put(auditTask.getId(), partic);
                    this.lastAssign = partic;
                    String nextFlowNodeAuditType = "approve";
                    String string = this.getDecisionNumber((UserTask)auditTask, nextFlowNodeAuditType, this.nodeIdMapAuditNumber.get(repeaterKey));
                    this.nodeIdMapAuditNumber.put(auditTask.getId(), string);
                    this.nodeIdMapExecutionType.put(auditTask.getId(), "byAuto");
                    nodeTask.setTransientVariableLocal(AUDITNUMBER, (Object)string);
                    this.setTaskResultVariable((UserTask)auditTask, string);
                    this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)nodeTask, nextFlowNodeAuditType, nodes);
                    return;
                }
                this.addNodes(auditType, nodes, nextFlowNode);
            } else {
                this.addNodes(auditType, nodes, nextFlowNode);
            }
        } else if ("skip".equals(this.process.getProcessMode())) {
            List<Long> userIds = this.getNodeParticipants(auditTask.getId());
            if (userIds != null && userIds.size() == 1 && RequestContext.get().getUserId().equals(userIds.get(0) + "")) {
                this.nodeIdMapAgreePersonId.put(auditTask.getId(), "");
                this.nodeIdMapAuditNumber.put(auditTask.getId(), "");
                this.nodeIdMapExecutionType.put(auditTask.getId(), "skip");
                String defaultAuditType = this.getDefaultAuditType((UserTask)auditTask);
                this.getNextUseableUserTaskNodes((FlowNode)auditTask, (VariableScope)nodeTask, defaultAuditType, nodes);
                return;
            }
            this.addNodes(auditType, nodes, nextFlowNode);
        } else if ("auto".equals(this.process.getProcessMode())) {
            List<Long> userIds = this.getNodeParticipants(auditTask.getId());
            if (userIds != null && userIds.size() == 1 && RequestContext.get().getUserId().equals(userIds.get(0) + "")) {
                this.nodeIdMapAgreePersonId.put(auditTask.getId(), userIds.get(0) + "");
                String defaultAuditType = "approve";
                this.nodeIdMapExecutionType.put(auditTask.getId(), "byAuto");
                this.nodeIdMapAuditNumber.put(auditTask.getId(), this.getDecisionNumber((UserTask)auditTask, defaultAuditType, null));
                this.getNextUseableUserTaskNodes((FlowNode)auditTask, (VariableScope)nodeTask, defaultAuditType, nodes);
            } else {
                this.addNodes(auditType, nodes, nextFlowNode);
            }
        } else {
            this.addNodes(auditType, nodes, nextFlowNode);
        }
    }

    protected boolean canDoAfterAudit(String auditType, FlowNode nextFlowNode, List<FlowNode> nodes, AuditTask auditTask, TaskEntity nodeTask) {
        List<Long> userIds = this.getNodeParticipants(auditTask.getId());
        HashSet<Long> participants = new HashSet<Long>(userIds);
        return !auditTask.isAddSign() && WfAfterAuditUtil.canDoAfterAudit(participants, (Process)this.process) != false;
    }

    private boolean isAfterAuditTask(String auditType, AuditTask auditTask, TaskEntity nodeTask, List<Long> userIds) {
        IPreComputorRecordItem item;
        if (this.preComputorRecord == null) {
            DecisionOption decisonOption = new DecisionOption();
            decisonOption.setAuditType(auditType);
            decisonOption.setNumber(this.getDecisionNumber(this.currentNode, auditType, (String)this.variables.get(AUDITNUMBER)));
            this.preComputorRecord = PreComputorHelper.getPreComputorRecordFromApprovalPageForAfterAudit((Long)this.execution.getProcessInstanceId(), (DecisionOption)decisonOption, (AuditTask)((AuditTask)this.currentNode), (TaskEntity)nodeTask);
        }
        if (this.preComputorRecord != null && (item = PreComputorHelper.getNextAfterAuditNode((IPreComputorRecord)this.preComputorRecord, (String)auditTask.getId(), (Long)userIds.get(0))) != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void doAfterAuditSkip(FlowNode nextFlowNode, List<FlowNode> nodes, AuditTask auditTask, TaskEntity nodeTask) {
        this.nodeIdMapAgreePersonId.put(auditTask.getId(), "");
        this.nodeIdMapAuditNumber.put(auditTask.getId(), "");
        this.nodeIdMapExecutionType.put(auditTask.getId(), "skip");
        String defaultAuditType = this.getDefaultAuditType((UserTask)auditTask);
        nodeTask.setTransientVariableLocal(AUDITNUMBER, (Object)"Consent");
        this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)nodeTask, defaultAuditType, nodes);
    }

    private boolean checkRepeater(List<Long> userIds) {
        boolean hasRepeater = false;
        Collection<String> agreePersonIds = this.nodeIdMapAgreePersonId.values();
        if (!agreePersonIds.isEmpty()) {
            for (Long userId : userIds) {
                if (!agreePersonIds.contains(userId.toString())) continue;
                hasRepeater = true;
            }
        }
        return hasRepeater;
    }

    private boolean withoutParticipantSkipThisNode(AuditTask auditTask, FlowNode nextFlowNode, List<FlowNode> nodes) {
        List<Long> uids;
        ParticipatantModel pm = auditTask.getParticipant();
        if (pm != null && pm.isSkipNodeWithoutPart() && (uids = this.getNodeParticipants(auditTask.getId())).isEmpty()) {
            this.nodeIdMapAgreePersonId.put(auditTask.getId(), "");
            this.nodeIdMapAuditNumber.put(auditTask.getId(), "");
            this.nodeIdMapExecutionType.put(auditTask.getId(), "skip");
            String defaultAuditType = this.getDefaultAuditType((UserTask)auditTask);
            this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)this.getNodeTask(nextFlowNode), defaultAuditType, nodes);
            return true;
        }
        return false;
    }

    protected void addNodesWhenAutoAudit(FlowNode flowNode, List<FlowNode> nodes, FlowNode nextFlowNode, AuditTask auditTask, String nextFlowNodeAuditType, String auditNumber, String auditType) {
        if (nextFlowNode.getJoin() != null && nextFlowNode.getJoin().booleanValue() && "enterwhenallarrive".equals(nextFlowNode.getInSet())) {
            this.addNodes(auditType, nodes, nextFlowNode);
            return;
        }
        this.nodeIdMapAgreePersonId.put(auditTask.getId(), "");
        this.nodeIdMapAuditNumber.put(auditTask.getId(), auditNumber);
        this.nodeIdMapExecutionType.put(auditTask.getId(), "byAuto");
        if ("terminate".equals(nextFlowNodeAuditType)) {
            List ends = this.process.findFlowElementsOfType(EndEvent.class);
            nodes.add((FlowNode)ends.get(0));
        } else if (this.isDynamicReject(nextFlowNodeAuditType, (FlowNode)auditTask)) {
            List options = auditTask.getDecisionOptions();
            for (DecisionOption d : options) {
                if (!auditNumber.equals(d.getNumber())) continue;
                List rejectOptions = d.getRejectOptions();
                if (WfConfigurationUtil.isIgnoreNoThroughNode()) {
                    rejectOptions = TaskHelper.filterUnFlowThrough((List)rejectOptions, (Long)this.execution.getProcessInstanceId());
                }
                if (rejectOptions != null) {
                    SelectNodesModel map = null;
                    for (int i = rejectOptions.size() - 1; i >= 0; --i) {
                        map = (SelectNodesModel)rejectOptions.get(i);
                        Task userTask = (Task)this.process.findFlowElementsOfTypeAndId(Task.class, map.getItemId(), false);
                        if (nodes.contains(userTask) || this.hasNotParticipant((FlowNode)userTask)) continue;
                        if (userTask instanceof UserTask && this.isSkipTask((UserTask)userTask)) {
                            this.nodeIdMapAgreePersonId.put(userTask.getId(), "");
                            this.nodeIdMapAuditNumber.put(userTask.getId(), "");
                            this.nodeIdMapExecutionType.put(auditTask.getId(), "skip");
                            String defaultAuditType = this.getDefaultAuditType((UserTask)userTask);
                            this.getNextUseableUserTaskNodes((FlowNode)userTask, (VariableScope)this.getNodeTask((FlowNode)userTask), defaultAuditType, nodes);
                            continue;
                        }
                        if (userTask instanceof AuditTask && this.isAutoAuditTask((AuditTask)userTask)) {
                            this.nodeIdMapAgreePersonId.put(userTask.getId(), "");
                            String autoAuditType = this.getAutoAuditAuditType((AuditTask)userTask);
                            this.nodeIdMapAuditNumber.put(userTask.getId(), this.getDecisionNumber((UserTask)userTask, autoAuditType, null));
                            this.nodeIdMapExecutionType.put(auditTask.getId(), "byAuto");
                            this.getNextUseableUserTaskNodes((FlowNode)userTask, (VariableScope)this.getNodeTask((FlowNode)userTask), autoAuditType, nodes);
                            continue;
                        }
                        if (userTask instanceof AutoTask) {
                            this.getNextUseableUserTaskNodes((FlowNode)userTask, (VariableScope)this.getNodeTask((FlowNode)userTask), null, nodes);
                            continue;
                        }
                        this.addNodes("reject", nodes, (FlowNode)userTask);
                    }
                }
                break;
            }
        } else {
            TaskEntity variableScope = this.getNodeTask(nextFlowNode);
            variableScope.setTransientVariableLocal(AUDITNUMBER, (Object)auditNumber);
            this.getNextUseableUserTaskNodes(nextFlowNode, (VariableScope)variableScope, nextFlowNodeAuditType, nodes);
        }
    }

    protected void filterNodeIdMapAgreePersonId(String actId) {
        List<FlowElement> elements = this.getPreviousNodes(this.bpmnModel, actId);
        HashMap<String, String> newNodeIdMapAgreePersonId = new HashMap<String, String>(elements.size());
        for (FlowElement f : elements) {
            if (this.nodeIdMapAgreePersonId.get(f.getId()) == null) continue;
            newNodeIdMapAgreePersonId.put(f.getId(), this.nodeIdMapAgreePersonId.get(f.getId()));
        }
        this.nodeIdMapAgreePersonId = newNodeIdMapAgreePersonId;
    }

    protected void addNodes(String auditType, List<FlowNode> nodes, FlowNode nextFlowNode) {
        this.nodeIdMapLastNodeAuditType.put(nextFlowNode.getId(), auditType);
        if (!nodes.contains(nextFlowNode)) {
            nodes.add(nextFlowNode);
        }
    }

    protected String getAutoAuditAuditType(AuditTask auditTask) {
        String autoDecision = auditTask.getAutoAudit().getAutoDecisionWhenMatch();
        String nextFlowNodeAuditType = "";
        List options = auditTask.getDecisionOptions();
        if (options == null) {
            return nextFlowNodeAuditType;
        }
        for (DecisionOption d : options) {
            if (!autoDecision.equals(d.getNumber())) continue;
            nextFlowNodeAuditType = d.getAuditType();
            break;
        }
        if (WfUtils.isEmpty(nextFlowNodeAuditType)) {
            throw new KDException(WFErrorCode.withoutDefaultDecisionError(), new Object[]{auditTask.getId()});
        }
        return nextFlowNodeAuditType;
    }

    protected String getDefaultAuditType(UserTask userTask) {
        List options = userTask.getDecisionOptions();
        for (DecisionOption d : options) {
            if (!d.isDefaultDecision()) continue;
            return d.getAuditType();
        }
        if (options != null && !options.isEmpty()) {
            return ((DecisionOption)options.get(0)).getAuditType();
        }
        throw new KDException(WFErrorCode.withoutDefaultDecisionError(), new Object[]{userTask.getId()});
    }

    protected List<SequenceFlow> getNodeOutgoingSequences(FlowNode flowNode, VariableScope variableScope, String auditType) {
        ArrayList<SequenceFlow> sequenceFlows = new ArrayList<SequenceFlow>();
        String defaultSequenceFlowId = flowNode.getDefaultFlow();
        SequenceFlow defaultSequenceFlow = null;
        try {
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                if (sequenceFlow.isDynamic()) continue;
                String expression = "";
                if (sequenceFlow.getConditionalRule() != null && WfUtils.isNotEmpty(sequenceFlow.getConditionalRule().getExpression())) {
                    expression = ConditionUtil.handleMacroForCalculateNextNode((String)sequenceFlow.getConditionalRule().getExpression(), this.nodeIdMapAuditNumber, this.nodeIdMapAgreePersonId, (String)this.lastAssign, this.nodeIdMapExecutionType, (VariableScope)variableScope);
                }
                if (WfUtils.isNotEmpty(expression) && ConditionUtil.hasTrueCondition((String)expression, (VariableScope)variableScope, null) && (defaultSequenceFlowId == null || !defaultSequenceFlowId.equals(sequenceFlow.getId()))) {
                    sequenceFlows.add(sequenceFlow);
                    continue;
                }
                if (defaultSequenceFlowId != null && sequenceFlow.getId().equals(defaultSequenceFlowId)) {
                    defaultSequenceFlow = sequenceFlow;
                    continue;
                }
                if (!WfUtils.isEmpty(expression)) continue;
                if (sequenceFlow.getConditionalRule() == null) {
                    sequenceFlows.add(sequenceFlow);
                    continue;
                }
                if (!ConditionUtil.hasTrueCondition((ConditionalRuleEntity)sequenceFlow.getConditionalRule(), (VariableScope)variableScope, (String)"")) continue;
                sequenceFlows.add(sequenceFlow);
            }
        }
        catch (Exception e) {
            this.log.warn(e.getMessage());
        }
        if (sequenceFlows.size() <= 0 && defaultSequenceFlow != null && (!(flowNode instanceof AuditTask) || WfUtils.isNotEmpty(auditType))) {
            sequenceFlows.add(defaultSequenceFlow);
        }
        if (flowNode.getFork() != null && flowNode.getFork().booleanValue() && "leavewhenallmeet".equals(flowNode.getOutSet()) && "reject".equals(flowNode.getPassTypeAfterInnerReject())) {
            String forkNodeId = flowNode.getId();
            ExecutionEntity proinst = this.execution.getProcessInstance();
            int cycle = ForkJoinUtils.getEnterForkCycle((String)forkNodeId, (ExecutionEntity)proinst);
            String joinRejectKey = ForkJoinUtils.getJoinNodeRejectKey((String)flowNode.getId(), (int)cycle, (ExecutionEntity)proinst);
            if (cycle > 0 && WfUtils.isNotEmpty(joinRejectKey)) {
                ArrayList<SequenceFlow> outgoingSequenceFlowsClone = new ArrayList<SequenceFlow>();
                Iterator iter = sequenceFlows.iterator();
                Map models = this.process.getForkJoinModels();
                FlowNode rejectNode = (FlowNode)this.process.getFlowElement(joinRejectKey);
                if (joinRejectKey.startsWith("JOIN_") || rejectNode == null) {
                    while (iter.hasNext()) {
                        SequenceFlow s = (SequenceFlow)iter.next();
                        outgoingSequenceFlowsClone.add(s);
                        String val = ForkJoinUtils.getItemForkResult((String)forkNodeId, (String)s.getTargetFlowElement().getId(), (int)cycle, (ExecutionEntity)proinst);
                        if ("reject".equals(val)) continue;
                        iter.remove();
                    }
                } else {
                    NodeForkJoinModel rejectNodeModel = (NodeForkJoinModel)models.get(joinRejectKey);
                    String targetStructure = rejectNodeModel.getForkStructure();
                    while (iter.hasNext()) {
                        SequenceFlow s = (SequenceFlow)iter.next();
                        outgoingSequenceFlowsClone.add(s);
                        String tmpId = s.getTargetFlowElement().getId();
                        if (models.get(tmpId) != null && targetStructure.equals(((NodeForkJoinModel)models.get(tmpId)).getForkStructure())) continue;
                        iter.remove();
                    }
                }
                if (sequenceFlows.isEmpty() && !outgoingSequenceFlowsClone.isEmpty()) {
                    sequenceFlows = outgoingSequenceFlowsClone;
                }
            }
        }
        this.removeTaskResultVariable();
        return sequenceFlows;
    }

    protected TaskEntity getNodeTask(FlowNode flowNode) {
        if (this.nextTasks.containsKey(flowNode.getId())) {
            return this.nextTasks.get(flowNode.getId());
        }
        Object behavior = flowNode.getBehavior();
        if (behavior instanceof WarpGatewayActivityBehavior) {
            return null;
        }
        if (behavior instanceof YunzhijiaNotifyActivityBehavior) {
            return null;
        }
        UserTask userTask = null;
        if (behavior instanceof UserTaskActivityBehavior) {
            userTask = (UserTask)flowNode;
        } else if (behavior instanceof YunzhijiaParallelMultiInstanceBehavior || behavior instanceof YunzhijiaSequentialMultiInstanceBehavior) {
            userTask = (YunzhijiaTask)flowNode;
        }
        if (null == userTask) {
            return null;
        }
        this.execution.setTransientVariable("throwException", this.variables.get("throwException"));
        TaskEntity task = TaskBehaviorUtil.buildTaskEntityWithParticipant((DelegateExecution)this.execution, userTask, this.nodeIdMapAuditNumber, this.nodeIdMapAgreePersonId, this.lastAssign, this.nodeIdMapExecutionType);
        this.nextTasks.put(flowNode.getId(), task);
        this.setCurrentApprover(task);
        return task;
    }

    protected boolean isDynamicReject(String auditType, FlowNode flowNode) {
        return flowNode instanceof AuditTask && ((AuditTask)flowNode).isDynamicReject() && ("reject".equals(auditType) || "forceReject".equals(auditType));
    }

    protected boolean isDynamicRejectToParentProcess(FlowNode flowNode, String auditType, String auditNumber) {
        AuditTask auditTask;
        if (flowNode instanceof AuditTask && (auditTask = (AuditTask)flowNode).isDynamicReject() && "reject".equals(auditType) && StringUtils.isNotEmpty((CharSequence)auditNumber)) {
            DecisionOption decisionOption = BpmnModelUtil.getDecisionOption((AuditTask)auditTask, (String)auditNumber);
            return decisionOption.isRejectToParentProcessScene();
        }
        return false;
    }

    protected boolean hasNotParticipant(FlowNode flowNode) {
        if (flowNode instanceof AutoTask) {
            return false;
        }
        List<Long> userIds = this.getNodeParticipants(flowNode.getId());
        return (userIds == null || userIds.isEmpty()) && this.isSkipNodeWithoutPart(flowNode);
    }

    private boolean isSkipNodeWithoutPart(FlowNode flowNode) {
        return ((UserTask)flowNode).getParticipant() != null && ((UserTask)flowNode).getParticipant().isSkipNodeWithoutPart();
    }

    protected boolean isSkipTask(UserTask userTask) {
        String key = String.format("%s_%s", this.currentNode.getId(), "rejectToForkInnerAndSkip");
        String rejectInnerInfo = (String)this.execution.getProcessInstance().getVariable(key);
        if (WfUtils.isNotEmpty(rejectInnerInfo)) {
            String[] nodes = rejectInnerInfo.split("\\-");
            if (!(userTask.getId().equals(nodes[1]) || this.variables != null && "reject".equals(this.variables.get("auditType")))) {
                return true;
            }
        }
        if (ConditionUtil.isConditionAvailable((ConditionalRuleEntity)userTask.getSkipCondition())) {
            TaskEntity te = this.getNodeTask((FlowNode)userTask);
            if (WfUtils.isNotEmpty(userTask.getSkipCondition().getPlugin())) {
                return ConditionUtil.hasTrueCondition((ConditionalRuleEntity)userTask.getSkipCondition(), (VariableScope)te, (String)"");
            }
            if (te == null) {
                return false;
            }
            if (ConditionUtil.hasTrueCondition((String)ConditionUtil.handleMacroForCalculateNextNode((String)userTask.getSkipCondition().getExpression(), this.nodeIdMapAuditNumber, this.nodeIdMapAgreePersonId, (String)this.lastAssign, this.nodeIdMapExecutionType, (VariableScope)te), (VariableScope)te, null)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isSkipTask(CallActivity callActivity, ExecutionEntity te) {
        String key = String.format("%s_%s", this.currentNode.getId(), "rejectToForkInnerAndSkip");
        String rejectInnerInfo = (String)this.execution.getProcessInstance().getVariable(key);
        if (WfUtils.isNotEmpty(rejectInnerInfo)) {
            String[] nodes = rejectInnerInfo.split("\\-");
            if (!callActivity.getId().equals(nodes[1])) {
                return true;
            }
        }
        if (ConditionUtil.isConditionAvailable((ConditionalRuleEntity)callActivity.getSkipCondition())) {
            if (WfUtils.isNotEmpty(callActivity.getSkipCondition().getPlugin())) {
                return ConditionUtil.hasTrueCondition((ConditionalRuleEntity)callActivity.getSkipCondition(), (VariableScope)te, (String)"");
            }
            if (ConditionUtil.hasTrueCondition((String)ConditionUtil.handleMacroForCalculateNextNode((String)callActivity.getSkipCondition().getExpression(), this.nodeIdMapAuditNumber, this.nodeIdMapAgreePersonId, (String)this.lastAssign, this.nodeIdMapExecutionType, (VariableScope)te), (VariableScope)te, null)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isAutoAuditTask(AuditTask auditTask) {
        TaskEntity te = this.getNodeTask((FlowNode)auditTask);
        if (auditTask.getAutoAudit() != null && auditTask.getAutoAudit().isAutoAuditWhenMatch() && auditTask.getAutoAudit().getAutoAuditCondition() != null && WfUtils.isNotEmpty(auditTask.getAutoAudit().getAutoAuditCondition().getExpression()) && WfUtils.isNotEmpty(auditTask.getAutoAudit().getAutoDecisionWhenMatch())) {
            if (te == null) {
                return false;
            }
            if (ConditionUtil.hasTrueCondition((String)ConditionUtil.handleMacroForCalculateNextNode((String)auditTask.getAutoAudit().getAutoAuditCondition().getExpression(), this.nodeIdMapAuditNumber, this.nodeIdMapAgreePersonId, (String)this.lastAssign, this.nodeIdMapExecutionType, (VariableScope)te), (VariableScope)te, null)) {
                return true;
            }
        }
        if (auditTask.getAutoAudit() != null && auditTask.getAutoAudit().isAutoAuditWhenMatch() && auditTask.getAutoAudit().getAutoAuditCondition() != null && WfUtils.isNotEmpty(auditTask.getAutoAudit().getAutoAuditCondition().getPlugin())) {
            return ConditionUtil.hasTrueCondition((ConditionalRuleEntity)auditTask.getAutoAudit().getAutoAuditCondition(), (VariableScope)te, (String)"");
        }
        return false;
    }

    protected String getDecisionNumber(UserTask userTask, String auditType, String auditNumber) {
        String decisionNumber = null;
        if (WfUtils.isNotEmpty(auditType) && userTask != null) {
            if (WfUtils.isNotEmpty(auditNumber)) {
                for (DecisionOption d : userTask.getDecisionOptions()) {
                    if (!auditNumber.equals(d.getNumber())) continue;
                    decisionNumber = d.getNumber();
                    break;
                }
            }
            if (WfUtils.isEmpty(decisionNumber)) {
                for (DecisionOption d : userTask.getDecisionOptions()) {
                    if (!auditType.equals(d.getAuditType())) continue;
                    decisionNumber = d.getNumber();
                    break;
                }
            }
        }
        return decisionNumber;
    }

    public boolean isStarterSameAsAuditor(TaskEntity task) {
        if (Boolean.TRUE.equals(this.process.getAutoAuditWhenSamePerson())) {
            List<Long> userIds = this.getNodeParticipants(task.getTaskDefinitionKey());
            if (userIds == null || userIds.isEmpty()) {
                return false;
            }
            if (WfUtils.isNotEmpty(task.getStarterId()) && userIds.contains(task.getStarterId())) {
                return true;
            }
        }
        return false;
    }

    public boolean isStarterSameAsYzjAuditor(Long starterId, YunzhijiaTask yzjTask, DecisionOption decision, List<Long> userIds) {
        if (WfUtils.isNotEmptyForCollection(userIds) && WfUtils.isNotEmpty(starterId) && userIds.contains(starterId)) {
            switch (yzjTask.getBusinessModel()) {
                case "passByOne": {
                    return "approve".equals(decision.getAuditType()) || userIds.size() == 1;
                }
                case "oneVoteVeto": {
                    if (userIds.size() != 1 && !"reject".equals(decision.getAuditType())) break;
                    return true;
                }
                case "voteOnProportion": {
                    int nrOfInstances = userIds.size();
                    if (nrOfInstances <= 0) {
                        return false;
                    }
                    int nrOfCompletedInstances = new GetLastAuditCountCmd(this.execution.getProcessInstanceId(), yzjTask.getId(), null).execute(this.commandContextForCurrent) + 1;
                    double vp = (double)(nrOfCompletedInstances * 100) / Double.parseDouble(String.valueOf(nrOfInstances));
                    if (!(vp >= yzjTask.getVotePercentage())) break;
                    int approveResult = new GetLastAuditCountCmd(this.execution.getProcessInstanceId(), yzjTask.getId(), "approve").execute(this.commandContextForCurrent);
                    if ("approve".equals(decision.getAuditType())) {
                        ++approveResult;
                    }
                    return AuditRuleForYzjUtil.isThroughVotePercentage((int)approveResult, (int)nrOfCompletedInstances, (YunzhijiaTask)yzjTask, (String)decision.getAuditType());
                }
                case "allVote": {
                    if (userIds.size() != 1 || !"approve".equals(decision.getAuditType())) break;
                    return true;
                }
                case "voteByPassProportion": {
                    return AuditRuleForYzjUtil.isThroughPassPercent((int)1, (int)userIds.size(), (YunzhijiaTask)yzjTask, (String)decision.getAuditType());
                }
            }
            return false;
        }
        return false;
    }

    public void setTaskResultVariable(UserTask ut, String auditNumber) {
        List options = ut.getDecisionOptions();
        for (DecisionOption option : options) {
            if (!option.getNumber().equals(auditNumber)) continue;
            this.execution.setVariable(AUDITNUMBER, (Object)auditNumber);
            this.execution.setVariable("auditName", (Object)option.getName());
            this.execution.setVariable("auditType", (Object)option.getAuditType());
            this.execution.setVariable("auditMessage", (Object)option.getName());
            break;
        }
    }

    public void removeTaskResultVariable() {
        this.execution.setVariable(AUDITNUMBER, (Object)"");
        this.execution.setVariable("auditName", (Object)"");
        this.execution.setVariable("auditType", (Object)"");
        this.execution.setVariable("auditMessage", (Object)"");
    }

    public void setCurrentApprover(TaskEntity task) {
        task.setExecution(this.execution);
        String uid = (String)task.getTransientVariable("currentParticipant");
        if (WfUtils.isNotEmpty(uid)) {
            ArrayList<Long> userIds = new ArrayList<Long>();
            for (String u : uid.split("\\,")) {
                if (!WfUtils.isNotEmpty(u)) continue;
                userIds.add(Long.valueOf(u));
            }
            this.execution.setVariable("currentApprover", userIds);
        } else {
            this.execution.setVariable("currentApprover", new ArrayList());
        }
    }
}

