/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.algo.Row;
import kd.bos.workflow.engine.impl.cmd.execution.AbstractBatchQueryCmd;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.task.TaskInfo;

public class GetTasksByIdsBatchCmd
extends AbstractBatchQueryCmd<List<TaskInfo>> {
    private static final String HITASKTYPE = "hitask";
    private List<Long> taskIds;
    private String type;

    public GetTasksByIdsBatchCmd(List<Long> taskIds, String type) {
        this.count = 500;
        this.taskIds = taskIds;
        this.type = type;
    }

    protected void handleResult(List<TaskInfo> list, Row r) {
        Long id = r.getLong("id");
        Long processInstanceId = r.getLong("processInstanceId");
        Long processDefinitionId = r.getLong("processDefinitionId");
        String taskDefinitionKey = r.getString("taskDefinitionKey");
        String category = r.getString("category");
        String source = r.getString("source");
        String control = r.getString("control");
        String processType = r.getString("processtype");
        if (HITASKTYPE.equalsIgnoreCase(this.type)) {
            HistoricTaskInstanceEntityImpl hitask = new HistoricTaskInstanceEntityImpl();
            hitask.setId(id);
            hitask.setProcessInstanceId(processInstanceId);
            hitask.setProcessDefinitionId(processDefinitionId);
            hitask.setTaskDefinitionKey(taskDefinitionKey);
            hitask.setCategory(category);
            hitask.setSource(source);
            hitask.setControl(control);
            hitask.setProcessType(processType);
            list.add((TaskInfo)hitask);
        } else {
            String batchOp = r.getString("batchOp");
            String handleState = r.getString("handleState");
            String bizTraceNo = r.getString("biztraceno");
            TaskEntityImpl task = new TaskEntityImpl();
            task.setId(id);
            task.setProcessInstanceId(processInstanceId);
            task.setProcessDefinitionId(processDefinitionId);
            task.setTaskDefinitionKey(taskDefinitionKey);
            task.setCategory(category);
            task.setSource(source);
            task.setBatchOp(batchOp);
            task.setControl(control);
            task.setHandleState(handleState);
            task.setBizTraceNo(bizTraceNo);
            task.setProcessType(processType);
            task.setBillNo(r.getString("billNo"));
            list.add((TaskInfo)task);
        }
    }

    protected Object[] createParameter(List<String> subList) {
        Object[] params = new Object[subList.size()];
        int i = 0;
        for (String t : subList) {
            params[i] = Long.parseLong(t);
            ++i;
        }
        return params;
    }

    protected String createSQL(List<String> subList) {
        String tableName = "t_wf_task";
        if (HITASKTYPE.equals(this.type)) {
            tableName = "t_wf_hitaskinst";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select ");
        sql.append((CharSequence)this.getSelectFields());
        sql.append("from ");
        sql.append(tableName);
        sql.append(" where fid in (");
        StringJoiner sj = new StringJoiner(",");
        int len = subList.size();
        for (int i = 0; i < len; ++i) {
            sj.add(" ?");
        }
        sql.append(sj);
        sql.append(")");
        return sql.toString();
    }

    protected Collection<String> getTotal() {
        ArrayList<String> list = new ArrayList<String>(this.taskIds.size());
        this.taskIds.forEach(id -> list.add(String.valueOf(id)));
        return list;
    }

    protected List<TaskInfo> createRet() {
        return new ArrayList<TaskInfo>();
    }

    private StringBuilder getSelectFields() {
        StringBuilder selectFields = new StringBuilder();
        if (HITASKTYPE.equalsIgnoreCase(this.type)) {
            selectFields.append("FID id,FPROCINSTID processInstanceId,FPROCDEFID processDefinitionId,");
            selectFields.append("FTASKDEFKEY taskDefinitionKey,FCATEGORY category,FSOURCE source,FCONTROL control,fprocesstype processtype ");
        } else {
            selectFields.append("FID id,FPROCINSTID processInstanceId,FPROCDEFID processDefinitionId,");
            selectFields.append("FTASKDEFID taskDefinitionKey,FCATEGORY category,FSOURCE source,FCONTROL control,");
            selectFields.append("FBATCHOP batchop,FHANDLESTATE handlestate,FBIZTRACENO biztraceno,fprocesstype processtype,fbillno billno ");
        }
        return selectFields;
    }
}

