/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.AgentTaskHandleContext;
import kd.bos.workflow.engine.impl.cmd.task.FindTaskByActivityInstanceIdCmd;
import kd.bos.workflow.engine.impl.cmd.task.FindTaskByIdAndTypeCmd;
import kd.bos.workflow.engine.impl.cmd.task.GetParticipantInfoByTaskIdAndUserIdCmd;
import kd.bos.workflow.engine.impl.cmd.task.TashHandleParam;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.task.TaskInfo;

public class SetUpAgentTaskHandleContext {
    private static final String QUERYSCENE = "queryScene";
    private static final String GETCAPTION = "getCaptain";
    private Log logger = LogFactory.getLog(this.getClass());

    public void getAgentTaskHandleContextData(CommandContext commandContext, TashHandleParam param, AgentTaskHandleContext agentTaskHandleContext) {
        boolean exists;
        boolean isCheckRight;
        agentTaskHandleContext.setType(param.getType());
        agentTaskHandleContext.setTaskId(param.getTaskId());
        agentTaskHandleContext.setOnlyView(param.getOnlyView());
        agentTaskHandleContext.setBillExist(param.getBillExist());
        agentTaskHandleContext.setPCShow(param.getPCShow());
        Object bizTask = param.getCustomParam("bizTask");
        if (bizTask != null) {
            if (bizTask instanceof String) {
                agentTaskHandleContext.setBizTask(Boolean.valueOf(Boolean.parseBoolean((String)bizTask)));
            } else if (bizTask instanceof Boolean) {
                agentTaskHandleContext.setBizTask((Boolean)bizTask);
            }
        }
        TaskInfo taskInfo = null;
        Object showByURLObj = param.getCustomParam("showByURL");
        this.logger.info("kd.bos.workflow.engine.impl.cmd.task.SetUpAgentTaskHandleContext.getAgentTaskHandleContextData params taskid :" + param.getTaskId() + "; type :" + param.getType() + "; showByURLObj :" + showByURLObj + "; activityId :" + param.getActivityId());
        if (WfUtils.isNotEmpty(param.getTaskId()) && WfUtils.isNotEmpty(param.getType()) || agentTaskHandleContext.isBizTask().booleanValue()) {
            taskInfo = new FindTaskByIdAndTypeCmd(param.getTaskId(), param.getType(), showByURLObj, agentTaskHandleContext.isBizTask().booleanValue()).execute(commandContext);
        } else if (WfUtils.isNotEmpty(param.getActivityId())) {
            boolean needCurrentTask = null != param.getOnlyView() && param.getOnlyView() != false;
            taskInfo = new FindTaskByActivityInstanceIdCmd(param.getActivityId(), param.getTaskId(), needCurrentTask, param.getBusinessKey()).execute(commandContext);
        }
        boolean isShowByURL = WfUtils.isEmptyString(showByURLObj) ? false : Boolean.parseBoolean(showByURLObj.toString());
        agentTaskHandleContext.setShowByURL(Boolean.valueOf(isShowByURL));
        if (taskInfo == null) {
            agentTaskHandleContext.setTaskExist(Boolean.FALSE);
            agentTaskHandleContext.setTaskNotExistReason("taskNotExistReason_notExist");
            return;
        }
        if (agentTaskHandleContext.getBillExist() == null) {
            boolean exist = WfUtils.exist(taskInfo.getEntityNumber(), (Object)taskInfo.getBusinessKey());
            if (!exist) {
                agentTaskHandleContext.setBillExist(Boolean.FALSE);
            } else {
                agentTaskHandleContext.setBillExist(Boolean.TRUE);
            }
        }
        agentTaskHandleContext.setTaskId(taskInfo.getId());
        agentTaskHandleContext.setTask(taskInfo);
        if (this.isGetCaptionScene(param)) {
            return;
        }
        String origineType = agentTaskHandleContext.getType();
        if ("dynApply".equals(origineType)) {
            agentTaskHandleContext.setOnlyView(null);
        }
        Map<String, Object> participantInfo = new GetParticipantInfoByTaskIdAndUserIdCmd(taskInfo.getId(), Long.valueOf(RequestContext.get().getUserId())).execute(commandContext);
        boolean checkRight = null == param.getCustomParam("checkRight") ? false : Boolean.parseBoolean(param.getCustomParam("checkRight").toString());
        boolean bl = isCheckRight = (checkRight || WfConfigurationUtil.isAuthTaskRelatePersion()) && WfUtils.isEmptyForMap(participantInfo);
        if (isCheckRight && !(exists = this.getCheckRightResult(taskInfo, origineType, commandContext, null == showByURLObj ? false : Boolean.parseBoolean(showByURLObj.toString())))) {
            agentTaskHandleContext.setTaskExist(Boolean.FALSE);
            agentTaskHandleContext.setTaskNotExistReason("taskNotExistReason_checkRight");
            agentTaskHandleContext.setTask(null);
            return;
        }
        if ("YunzhijiaTask".equals(taskInfo.getCategory()) && WfUtils.isEmpty(taskInfo.getParentTaskId()) && null != (participantInfo = this.getParticipantInfoForYunzhijia(commandContext, taskInfo.getId())) && !participantInfo.isEmpty()) {
            Long taskId = (Long)participantInfo.get("realTaskId");
            taskInfo = (TaskInfo)commandContext.getTaskEntityManager().findById(taskId);
            if (null == taskInfo) {
                taskInfo = (TaskInfo)commandContext.getHistoricTaskInstanceEntityManager().findById(taskId);
            }
            if (null == taskInfo) {
                agentTaskHandleContext.setTaskExist(Boolean.FALSE);
                agentTaskHandleContext.setTaskNotExistReason("taskNotExistReason_notExist");
                return;
            }
            agentTaskHandleContext.setTaskId(taskInfo.getId());
            agentTaskHandleContext.setTask(taskInfo);
        }
        boolean isCurrentTask = WfUtils.isNotEmptyForMap(participantInfo) && !taskInfo.isFromHistory();
        agentTaskHandleContext.setFromHistory(Boolean.valueOf(!isCurrentTask));
        boolean isCoordinateTask = false;
        String participantType = (String)participantInfo.get("mapKeyForIdentityLinkType");
        isCoordinateTask = "coordinate".equals(participantType);
        agentTaskHandleContext.setTaskCoordinate(Boolean.valueOf(isCoordinateTask));
        agentTaskHandleContext.setTaskParticipant(Boolean.valueOf("participant".equals(participantType)));
        agentTaskHandleContext.setDelegate(WfUtils.isNotEmptyForMap(participantInfo) ? (Boolean)participantInfo.get("isDelegte") : Boolean.FALSE);
        boolean onlyViewByURL = false;
        if (null != showByURLObj && Boolean.parseBoolean(showByURLObj.toString()) && taskInfo.isFromHistory() && (WfUtils.isEmpty(param.getActivityId()) || Boolean.TRUE.equals(param.getOnlyView()))) {
            agentTaskHandleContext.setOnlyView(Boolean.TRUE);
            onlyViewByURL = true;
        }
        if (!onlyViewByURL) {
            boolean isOnlyView = WfUtils.isEmptyForMap(participantInfo);
            agentTaskHandleContext.setOnlyView(Boolean.valueOf(isOnlyView));
            if (isOnlyView) {
                HistoricProcessInstanceEntity entity;
                if ("dynApply".equals(origineType) && null != (entity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(taskInfo.getProcessInstanceId())) && null == entity.getEndTime()) {
                    agentTaskHandleContext.setType("toApply");
                    agentTaskHandleContext.setOnlyView(Boolean.FALSE);
                }
            } else {
                Object taskId = participantInfo.get("realTaskId");
                if (WfUtils.isNotEmptyString(taskId)) {
                    agentTaskHandleContext.setTaskId(Long.valueOf(taskId.toString()));
                }
                if (isCoordinateTask) {
                    boolean isExist = CoordinateRecordUtil.isParticipant(taskInfo.getId(), RequestContext.get().getUserId(), "coordinate");
                    boolean isParentExist = false;
                    if (WfUtils.isNotEmpty(taskInfo.getParentTaskId())) {
                        isParentExist = CoordinateRecordUtil.isParticipant(taskInfo.getParentTaskId(), RequestContext.get().getUserId(), "coordinate");
                    }
                    if (!isExist && !isParentExist) {
                        agentTaskHandleContext.setOnlyView(Boolean.TRUE);
                    }
                }
            }
        }
        if (param.getPCShow().booleanValue() && agentTaskHandleContext.isFromHistory().booleanValue()) {
            agentTaskHandleContext.setOnlyView(Boolean.TRUE);
        }
        if (agentTaskHandleContext.getOnlyView().booleanValue()) {
            agentTaskHandleContext.setBillView(Boolean.TRUE);
        } else {
            boolean isPartipant = "participant".equalsIgnoreCase(participantType);
            if (isPartipant) {
                agentTaskHandleContext.setBillView(agentTaskHandleContext.getOnlyView());
            }
        }
        if (WfUtils.isEmpty(param.getTaskId()) || WfUtils.isEmpty(origineType) || "dynApply".equals(origineType) || "toHandle".equals(origineType)) {
            if (agentTaskHandleContext.isFromHistory().booleanValue()) {
                agentTaskHandleContext.setType("handled");
            } else {
                agentTaskHandleContext.setType("toHandle");
            }
        }
        if ("dynnApply".equals(agentTaskHandleContext.getType())) {
            agentTaskHandleContext.setType("toApply");
            agentTaskHandleContext.setOnlyView(param.getPCShow());
        }
        if (!agentTaskHandleContext.getTaskCoordinate().booleanValue() && agentTaskHandleContext.isFromHistory().booleanValue() && "YunzhijiaTask".equals(taskInfo.getCategory())) {
            QFilter qType = new QFilter("type", "=", (Object)"forceReject");
            QFilter qTaskId = new QFilter("taskId", "=", (Object)taskInfo.getId());
            QFilter qUserId = new QFilter("userId", "=", (Object)RequestContext.get().getCurrUserId());
            boolean exist = QueryServiceHelper.exists((String)"wf_hicomment", (QFilter[])new QFilter[]{qTaskId, qType, qUserId});
            agentTaskHandleContext.setForceRejectTask(Boolean.valueOf(exist));
        }
    }

    private Map<String, Object> getParticipantInfoForYunzhijia(CommandContext commandContext, Long parentTaskId) {
        HashMap<String, Object> participantInfo = new HashMap<String, Object>(1);
        if (WfUtils.isEmpty(parentTaskId)) {
            return participantInfo;
        }
        HistoricIdentityLinkEntityManager manager = commandContext.getHistoricIdentityLinkEntityManager();
        List infos = manager.findParticipantsByParentTaskId(parentTaskId, Long.valueOf(RequestContext.get().getUserId()));
        if (null == infos || infos.isEmpty()) {
            return participantInfo;
        }
        HistoricIdentityLinkEntity info = (HistoricIdentityLinkEntity)infos.get(0);
        if (null == info) {
            return participantInfo;
        }
        participantInfo.put("mapKeyForIdentityLinkType", info.getType());
        participantInfo.put("realTaskId", info.getTaskId());
        participantInfo.put("isDelegte", WfUtils.isNotEmpty(info.getDelegateId()) ? Boolean.TRUE : Boolean.FALSE);
        return participantInfo;
    }

    protected boolean isGetCaptionScene(TashHandleParam param) {
        return GETCAPTION.equals(param.getCustomParam(QUERYSCENE));
    }

    private boolean getCheckRightResult(TaskInfo taskInfo, String origineType, CommandContext commandContext, boolean showByURL) {
        List<OperationLogEntity> OperationLogs;
        Long taskInfoUserId = RequestContext.get().getCurrUserId();
        QFilter filterForProcInstId = null;
        QFilter filterForAssigneeId = null;
        QFilter[] filters = null;
        boolean exists = false;
        if (("toApply".equals(origineType) || "applyed".equals(origineType)) && (exists = QueryServiceHelper.exists((String)"wf_hiprocinst", (QFilter[])(filters = new QFilter[]{filterForProcInstId = new QFilter("id", "=", (Object)taskInfo.getProcessInstanceId()), filterForAssigneeId = new QFilter("creatorid", "=", (Object)taskInfoUserId)})))) {
            return true;
        }
        Long procInstId = null;
        if (taskInfo.isBizTask()) {
            filterForProcInstId = new QFilter("procinstid", "=", (Object)0L);
        } else {
            filterForProcInstId = new QFilter("procinstid", "=", (Object)taskInfo.getProcessInstanceId());
            procInstId = taskInfo.getProcessInstanceId();
        }
        filterForAssigneeId = new QFilter("assigneeid", "=", (Object)RequestContext.get().getUserId()).or("ownerid", "=", (Object)taskInfoUserId);
        filters = new QFilter[]{filterForProcInstId, filterForAssigneeId};
        if (WfUtils.isNotEmpty(procInstId) ? WfUtils.isNotEmptyForCollection(OperationLogs = commandContext.getOperationLogEntityManager().findOperationLogByOwnIdOrAssigneeId(procInstId, taskInfoUserId, String.valueOf(RequestContext.get().getCurrUserId()))) : (exists = QueryServiceHelper.exists((String)"wf_operationlog", (QFilter[])filters))) {
            return true;
        }
        if ("dynApply".equals(origineType) || "toHandle".equals(origineType) || showByURL) {
            QFilter filterForTaskId;
            QFilter filterForType = new QFilter("type", "in", (Object)new String[]{"textMessage", "circulation", "addProcessRelationPerson"});
            filterForAssigneeId = new QFilter("assigneeid", "match", (Object)RequestContext.get().getUserId());
            if (taskInfo.isBizTask()) {
                filterForTaskId = new QFilter("taskid", "=", (Object)taskInfo.getId());
                filters = new QFilter[]{filterForTaskId, filterForProcInstId, filterForType, filterForAssigneeId};
            } else {
                filters = new QFilter[]{filterForProcInstId, filterForType, filterForAssigneeId};
            }
            exists = QueryServiceHelper.exists((String)"wf_operationlog", (QFilter[])filters);
            if (exists) {
                return true;
            }
            filterForAssigneeId = new QFilter("userId", "=", (Object)taskInfoUserId).or("ownerId", "=", (Object)taskInfoUserId);
            if (taskInfo.isBizTask()) {
                filterForTaskId = new QFilter("taskid", "=", (Object)taskInfo.getId());
                filterForProcInstId = new QFilter("processInstanceId", "=", (Object)0L);
                filters = new QFilter[]{filterForTaskId, filterForProcInstId, filterForAssigneeId};
            } else {
                filterForProcInstId = new QFilter("processInstanceId", "=", (Object)taskInfo.getProcessInstanceId());
                filters = new QFilter[]{filterForProcInstId, filterForAssigneeId};
            }
            exists = QueryServiceHelper.exists((String)"wf_hiparticipant", (QFilter[])filters);
            if (exists) {
                return true;
            }
            HistoricProcessInstanceEntity historicProcessInstanceEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(taskInfo.getProcessInstanceId());
            if (null == historicProcessInstanceEntity) {
                return false;
            }
            exists = taskInfoUserId.equals(historicProcessInstanceEntity.getStartUserId()) || taskInfoUserId.equals(historicProcessInstanceEntity.getCreatorId());
        }
        return exists;
    }
}

