/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.cmd.task;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.dynprocess.freeflow.WFCallActivity;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.cmd.management.delegatesetting.ResumeDelegateTasksCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskAddSignAfterByAdminCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskAddSignAfterCmd;
import kd.bos.workflow.engine.impl.cmd.task.TaskAddSignBeforeCmd;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;

public class TaskAddSignCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Long taskId;
    private AddSignInfo addSignInfo = new AddSignInfo();
    private String activityId;
    private Long procinstId;
    public static final String ADDSIGNTASK = "addsignTask";
    public static final String ADDSIGNINFO = "addSignInfo";
    private final Boolean isAdmin;

    public TaskAddSignCmd(Long taskId, AddSignInfo addSignInfo) {
        this.taskId = taskId;
        this.addSignInfo = addSignInfo;
        this.isAdmin = Boolean.FALSE;
    }

    public TaskAddSignCmd(Long procInstId, String activityId, AddSignInfo addSignInfo) {
        this.procinstId = procInstId;
        this.addSignInfo = addSignInfo;
        this.activityId = activityId;
        this.isAdmin = Boolean.TRUE;
    }

    public String execute(CommandContext commandContext) {
        String result = this.validate(commandContext);
        if (WfUtils.isNotEmpty(result)) {
            return result;
        }
        HashMap<String, AddSignInfo> params = new HashMap<String, AddSignInfo>();
        params.put(ADDSIGNINFO, this.addSignInfo);
        new ResumeDelegateTasksCmd(this.taskId, ADDSIGNTASK, params).execute(commandContext);
        String addSignType = this.addSignInfo.getAddSignType();
        if ("addsignafter".equals(addSignType) || "addsignbefore".equals(addSignType)) {
            TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
            Long processInstanceId = task.getProcessInstanceId();
            if ("addsignafter".equals(addSignType)) {
                result = new TaskAddSignAfterCmd(processInstanceId, this.taskId, this.addSignInfo).execute(commandContext);
            } else if ("addsignbefore".equals(addSignType)) {
                result = new TaskAddSignBeforeCmd(processInstanceId, this.taskId, this.addSignInfo).execute(commandContext);
                this.gatherAsyncCompensationData(commandContext, task);
            }
            BPMNUtil.updateHitaskInstPresentAssignee((ExecutionEntity)task.getExecution(), null);
        } else if ("addsignafterbyadmin".equals(addSignType)) {
            this.addSignInfo.setAddSignType("addsignafter");
            result = new TaskAddSignAfterByAdminCmd(this.procinstId, this.activityId, this.addSignInfo).execute(commandContext);
        }
        return result;
    }

    private String validateForPerson() {
        List userIds = this.addSignInfo.getUserIds();
        if (userIds == null || userIds.isEmpty()) {
            return ResManager.loadKDString((String)"\u201c\u52a0\u7b7e\u4eba\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskAddSignCmd_4", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        String addSignDealType = this.addSignInfo.getAddSignDealType();
        if (WfUtils.isEmpty(addSignDealType) || this.validateAddSignDealType(addSignDealType)) {
            return ResManager.loadKDString((String)"\u52a0\u7b7e\u5ba1\u6279\u65b9\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"TaskAddSignCmd_5", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        String yzjType = this.addSignInfo.getYzjType();
        if ("yzj".equals(addSignDealType) && (WfUtils.isEmpty(yzjType) || !"passByOne".equals(yzjType) && !"oneVoteVeto".equals(yzjType))) {
            return ResManager.loadKDString((String)"\u8bf7\u9a8c\u8bc1\u4f1a\u5ba1\u6a21\u5f0f\u662f\u5426\u6b63\u786e\u3002", (String)"TaskAddSignCmd_6", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return null;
    }

    private String validateForNode(CommandContext commandContext) {
        WFCallActivity wfFlowNode = this.addSignInfo.getWfFlowNode();
        if (!(wfFlowNode instanceof WFCallActivity)) {
            return ResManager.loadKDString((String)"\u8282\u70b9\u7c7b\u578b\u52a0\u7b7e\u53ea\u80fd\u52a0\u7b7e\u5b50\u6d41\u7a0b\u8282\u70b9\u3002", (String)"TaskAddSignCmd_9", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        WFCallActivity wfCallActivity = wfFlowNode;
        String entityNumber = wfCallActivity.getEntityNumber();
        String calledWay = wfCallActivity.getCalledWay();
        Long callProcessId = wfCallActivity.getCallProcessId();
        if (!WfUtils.isNotEmpty(callProcessId)) {
            return ResManager.loadKDString((String)"\u5f15\u7528\u6d41\u7a0b\u4e3a\u7a7a\u3002", (String)"TaskAddSignCmd_10", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        TaskEntity task = null;
        if (WfUtils.isEmpty(this.taskId) && "addsignafterbyadmin".equals(this.addSignInfo.getAddSignType())) {
            List tasks = commandContext.getTaskEntityManager().findTasksByProcessInstanceId(this.procinstId);
            if (tasks != null && !tasks.isEmpty()) {
                task = (TaskEntity)tasks.get(0);
            }
        } else if (WfUtils.isNotEmpty(this.taskId)) {
            task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId, "entitynumber,processdefinitionid");
        }
        if (task == null) {
            return ResManager.loadKDString((String)"\u4efb\u52a1\u5df2\u88ab\u5904\u7406\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskAddSignCmd_20", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (WfUtils.isEmpty(entityNumber) || !entityNumber.equals(task.getEntityNumber())) {
            return ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u7684\u5355\u636e\u5fc5\u987b\u548c\u4e3b\u6d41\u7a0b\u4e00\u81f4\u3002", (String)"TaskAddSignCmd_12", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (!"bindByProdefId".equals(calledWay)) {
            return ResManager.loadKDString((String)"\u5b50\u6d41\u7a0b\u5f15\u7528\u65b9\u5f0f\u5e94\u8be5\u4e3a\uff1a\u5b50\u6d41\u7a0b\u7ed1\u5b9a\u3002", (String)"TaskAddSignCmd_13", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        QFilter[] callProcessIdQFilters = new QFilter[]{new QFilter("id", "=", (Object)callProcessId)};
        QFilter[] callProcessNumberQFilters = new QFilter[]{new QFilter("key", "=", (Object)wfCallActivity.getCallProcessNumber())};
        if (!commandContext.getProcessDefinitionEntityManager().exist(callProcessIdQFilters) || !commandContext.getProcessDefinitionEntityManager().exist(callProcessNumberQFilters)) {
            return ResManager.loadKDString((String)"\u5f15\u7528\u7684\u5b50\u6d41\u7a0b\u4e0d\u5b58\u5728\u3002", (String)"TaskAddSignCmd_14", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        return null;
    }

    private void gatherAsyncCompensationData(CommandContext commandContext, TaskEntity task) {
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        taskHelper.gatherAsyncCompensationData(task);
    }

    private String validate(CommandContext commandContext) {
        Map addSingMsg;
        boolean generalScope;
        String addSignType = this.addSignInfo.getAddSignType();
        boolean isTypeEmpty = WfUtils.isEmpty(addSignType);
        boolean adminScope = "addsignafterbyadmin".equals(addSignType);
        boolean bl = generalScope = "addsignafter".equals(addSignType) || "addsignbefore".equals(addSignType);
        if (isTypeEmpty || this.isAdmin.booleanValue() && !adminScope) {
            return ResManager.loadKDString((String)"addSignType\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u662f\u4e0b\u9762\u4e2d\u7684\uff08\u201caddsignafterbyadmin\u201d\uff09\u4e00\u79cd\u3002", (String)"TaskAddSignCmd_22", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if (isTypeEmpty || !this.isAdmin.booleanValue() && !generalScope) {
            return ResManager.loadKDString((String)"addSignType\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u662f\u4e0b\u9762\uff08\u201caddsignbefore\u201d\u3001\u201caddsignafter\u201d\uff09\u4e2d\u7684\u4e00\u79cd\u3002", (String)"TaskAddSignCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        if ("addsignafterbyadmin".equals(this.addSignInfo.getAddSignType())) {
            if (WfUtils.isEmpty(this.procinstId)) {
                return ResManager.loadKDString((String)"\u201c\u6d41\u7a0b\u5b9e\u4f8b\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskAddSignCmd_7", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            if (WfUtils.isEmpty(this.activityId)) {
                return ResManager.loadKDString((String)"\u8be5\u8282\u70b9ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u9a8c\u8bc1\u3002", (String)"TaskAddSignCmd_8", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        } else {
            if (WfUtils.isEmpty(this.taskId)) {
                return ResManager.loadKDString((String)"\u201c\u4efb\u52a1ID\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskAddSignCmd_0", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().findById(this.taskId);
            if (task == null) {
                return ResManager.loadKDString((String)"\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaskAddSignCmd_21", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            if (ManagementConstants.SUSPENDED.getStateCode().equals(commandContext.getExecutionEntityManager().findProcessInstanceById(task.getProcessInstanceId()).getSuspensionState())) {
                return ResManager.loadKDString((String)"\u5df2\u6302\u8d77\u7684\u4efb\u52a1\u4e0d\u5141\u8bb8\u52a0\u7b7e\u3002", (String)"TaskAddSignCmd_16", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            BpmnModel model = ProcessDefinitionUtil.getBpmnModel((Long)task.getProcessDefinitionId(), (Long)task.getProcessInstanceId());
            if (BpmnModelUtil.isBizFlow((String)model.getMainProcess().getProcessType())) {
                return ResManager.loadKDString((String)"\u4e1a\u52a1\u6d41\u4e0d\u5141\u8bb8\u52a0\u7b7e\u3002", (String)"TaskAddSignCmd_15", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            FlowElement flowElement = model.getFlowElement(task.getTaskDefinitionKey());
            if (BpmnModelUtil.instanceofUserTaskOnly((String)task.getCategory())) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u4e0d\u5141\u8bb8\u52a0\u7b7e\u3002", (String)"TaskAddSignCmd_17", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
            Map<String, String> noNeedMap = WfConfigurationUtil.noNeedCheckAddSignNodeTypes();
            if (!noNeedMap.containsKey(task.getCategory()) && BpmnModelUtil.instanceofAuditTask((String)task.getCategory()) && !((AuditTask)flowElement).isCountersigned()) {
                return ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u672a\u6253\u5f00\u52a0\u7b7e\u8bbe\u7f6e\u3002", (String)"TaskAddSignCmd_18", (String)"bos-wf-engine", (Object[])new Object[0]);
            }
        }
        if ((addSingMsg = this.addSignInfo.getAddSingMsg()) == null || addSingMsg.isEmpty() || addSingMsg.get(RequestContext.get().getLang().toString()) == null) {
            return ResManager.loadKDString((String)"\u201c\u52a0\u7b7e\u8bf4\u660e\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaskAddSignCmd_2", (String)"bos-wf-engine", (Object[])new Object[0]);
        }
        String addSignMod = this.addSignInfo.getAddSignMod();
        if ("person".equals(addSignMod)) {
            return this.validateForPerson();
        }
        if ("node".equals(addSignMod)) {
            return this.validateForNode(commandContext);
        }
        return null;
    }

    private boolean validateAddSignDealType(String addSignDealType) {
        return !"one".equals(addSignDealType) && !"anyone".equals(addSignDealType) && !"seq".equals(addSignDealType) && !"yzj".equals(addSignDealType);
    }
}

