/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.BillExceptionOp;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.ParticipatantModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.devopos.ProcessNotExistPoJo;
import kd.bos.workflow.devopos.ProcessNotExistReasonEnum;
import kd.bos.workflow.devopos.ReasonPayload;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.engine.MultiLangEnumBridge;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.ModifyWorkflowBillNoCmd;
import kd.bos.workflow.engine.impl.cmd.execution.DeleteAllRuntimeDatasByProcessInstanceIdCmd;
import kd.bos.workflow.engine.impl.cmd.history.FindActivityByExecutionIdAndActId;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.cmd.management.AbandonProcessCmd;
import kd.bos.workflow.engine.impl.cmd.management.BillBackOrProcessTerminateCmd;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.cmd.startup.EnterSensitiveFieldChangeCmd;
import kd.bos.workflow.engine.impl.cmd.startup.GetProcessStatusCmd;
import kd.bos.workflow.engine.impl.cmd.system.entity.HandlerConfig;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.jobexecutor.JobDAO;
import kd.bos.workflow.engine.impl.jobexecutor.JobFinishNotification;
import kd.bos.workflow.engine.impl.log.LogClassType;
import kd.bos.workflow.engine.impl.log.RunTimeLog;
import kd.bos.workflow.engine.impl.log.SceneType;
import kd.bos.workflow.engine.impl.log.builder.AddressLogger;
import kd.bos.workflow.engine.impl.log.builder.AddressProcedureMsgStrategy;
import kd.bos.workflow.engine.impl.log.builder.AddressProcedureMultiLang;
import kd.bos.workflow.engine.impl.log.builder.LogBridge;
import kd.bos.workflow.engine.impl.model.ProcessDefinitionStartInfo;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionInfoEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.CirculateRelationEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.EventSubscriptionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.AddressProcessUtils;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.SensitiveFieldUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.pojo.AddressProcedure;
import kd.bos.workflow.engine.pojo.LogMember;
import kd.bos.workflow.engine.pojo.ParentProcess;
import kd.bos.workflow.engine.pojo.SchemePathItem;
import kd.bos.workflow.engine.pojo.record.AlternativeProcess;
import kd.bos.workflow.engine.runtime.ExecuteJob;
import kd.bos.workflow.exception.AddressingDuplicateException;
import kd.bos.workflow.exception.AddressingProcessException;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFNotFindSubProcessException;
import kd.bos.workflow.exception.WFObjectNotFoundException;
import kd.bos.workflow.service.ProcessStatusEnum;
import kd.bos.workflow.service.WfTraceType;

public class AddressProcessJobHandler
extends AbstractJobHandler {
    public static final String TYPE = "address-process-event";
    private Log logger = LogFactory.getLog(AddressProcessJobHandler.class);
    public static final String JOB_ACTION = "jobAction";
    public static final String JOB_ACTION_CREATESUBPROCESS = "createSubProcess";
    public static final String PARENTPROCDEFID = "parentProcDefId";
    public static final String CALLACTIVITYPROCDEFKEY = "callActivityProcDefKey";
    public static final String CALLACTIVITYADDRESSKEY = "addressKey";
    public static final String CALLACTIVITYCALLEDWAY = "calledWay";

    public String getType() {
        return TYPE;
    }

    /*
     * Exception decompiling
     */
    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[CATCHBLOCK]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkBillIsUnsubmit(JobEntity job, CommandContext commandContext, String businessKey, String entityNumber, Map<String, Object> variables) {
        DynamicObject bill = WfUtils.findBusinessObject(businessKey, entityNumber);
        if (job != null && job.getDynamicObject() != null && bill != null && bill.getDataEntityType() != null && bill.getDataEntityType().getDBRouteKey() != null) {
            if (WfCacheHelper.existWithdrawDeleteBizJobs((String)entityNumber, (Long)job.getId())) {
                this.logger.warn(String.format("\u5bfb\u5740\u5931\u8d25\uff0cjob[%s]\u6b63\u5728\u88ab\u5220\u9664!", job.getId()));
                commandContext.getJobEntityManager().delete((Entity)job);
                return true;
            }
            JobDAO dao = (JobDAO)TypesContainer.getOrRegisterSingletonInstance((String)JobDAO.class.getName());
            boolean jobExist = dao.exist(job.getId(), bill.getDataEntityType().getDBRouteKey());
            if (!(jobExist || JOB_ACTION_CREATESUBPROCESS.equals(variables.get(JOB_ACTION)) || JobHandleStrategyFactory.isFromWF(job.getSource()))) {
                this.logger.warn(String.format("\u5bfb\u5740\u5931\u8d25\uff0cjob[%s]\u5df2\u7ecf\u88ab\u5220\u9664!", job.getId()));
                commandContext.getJobEntityManager().delete((Entity)job);
                return true;
            }
        }
        return false;
    }

    private AddressProcedure intiAddressLog(CommandContext commandContext, String businessKey, String operation, DynamicObject bill, String entityNumber) {
        try {
            RunTimeLog.get().init(SceneType.ADDRESS_PROCEDURE, LogClassType.ADDRESS_PROCEDURE_LOG_BLOCK);
            AddressLogger init = AddressLogger.init((CommandContext)commandContext, (String)businessKey, (String)operation, (DynamicObject)bill, (String)entityNumber);
            return init.getAddressProcedure();
        }
        catch (Throwable throwable) {
            return new AddressProcedure();
        }
    }

    private void logAddressProcedure(CommandContext commandContext, AddressProcedure addressProcedure, DynamicObject bill, Map<String, Object> variables) {
        try {
            if (addressProcedure.getUnwanted().booleanValue()) {
                return;
            }
            boolean wfassigncallbackflag = Boolean.TRUE.toString().equalsIgnoreCase(Optional.ofNullable(variables.get("wfassigncallbackflag")).orElse("").toString());
            boolean sub = JOB_ACTION_CREATESUBPROCESS.equals(variables.get(JOB_ACTION));
            boolean subBind = sub && "bindByProdefId".equals(variables.get(CALLACTIVITYCALLEDWAY));
            boolean designed = "DESIGNATED".equals(variables.get(CALLACTIVITYCALLEDWAY));
            BusinessModelVariableScope businessModelVariableScope = new BusinessModelVariableScope(bill);
            if (subBind) {
                LogMember member = this.afterBindSubProcess(commandContext, addressProcedure);
                this.writeLogMember(member, businessModelVariableScope);
                return;
            }
            if (wfassigncallbackflag) {
                LogMember member = this.afterAssign(commandContext, variables);
                this.writeLogMember(member, businessModelVariableScope);
                return;
            }
            if (designed) {
                LogMember member = this.afterDesigned(commandContext, addressProcedure, (String)variables.get("reason"));
                this.writeLogMember(member, businessModelVariableScope);
                return;
            }
            String dynType = (String)variables.get("dynType");
            if ("freeflow".equals(dynType) || "freeflowafternode".equals(dynType)) {
                LogMember member = this.afterFreeFlow(commandContext, addressProcedure);
                this.writeLogMember(member, businessModelVariableScope);
            }
            if (AddressProcedure.emptyData((AddressProcedure)addressProcedure)) {
                return;
            }
            List alternativeProcesses = addressProcedure.getAlternativeProcesses();
            if (alternativeProcesses != null) {
                Map<Long, AlternativeProcess> processMap = alternativeProcesses.stream().collect(Collectors.toMap(AlternativeProcess::getProcessDefinitionId, item -> item));
                ArrayList<Long> definitionIds = new ArrayList<Long>(processMap.keySet());
                List startUpConditionTexts = commandContext.getConditionRuleEntityManager().batchFindStartUpCondition(definitionIds);
                startUpConditionTexts.forEach(item -> {
                    AlternativeProcess alternativeProcess = (AlternativeProcess)processMap.get(item.getProcessDefinitionId());
                    alternativeProcess.setConditionShowText(item.getShowText());
                });
            }
            String content = AddressProcedureMsgStrategy.getContent((AddressProcedure)addressProcedure);
            AlternativeProcess enteredProcess = addressProcedure.getEnteredProcess();
            LogMember logMember = new LogMember();
            if (enteredProcess != null && enteredProcess.getProcessDefinitionId() != null && enteredProcess.getProcessDefinitionId() != 0L) {
                logMember.setName(enteredProcess.getProcessNameWithScheme());
                logMember.setProcessDefinitionId(enteredProcess.getProcessDefinitionId());
            }
            logMember.setSub(sub);
            businessModelVariableScope.setVariable("logMember", (Object)SerializationUtils.toJsonString((Object)logMember));
            RunTimeLog.get().end((VariableScope)businessModelVariableScope);
        }
        catch (Throwable throwable) {
            String s = Arrays.toString(throwable.getStackTrace());
            this.logger.warn("\u5bfb\u5740\u540e\u7f6e\u5904\u7406\u5931\u8d25:" + s);
        }
    }

    private LogMember afterFreeFlow(CommandContext commandContext, AddressProcedure addressProcedure) {
        AlternativeProcess process = Optional.ofNullable(addressProcedure).map(AddressProcedure::getEnteredProcess).orElseGet(AlternativeProcess::new);
        String desc = AddressProcedureMultiLang.LANG_56.getDesc();
        String name = process.getProcessNameWithScheme();
        String type = "";
        type = ModelType.AuditFlow == process.getProcessType() ? AddressProcedureMultiLang.LANG_4.getDesc() : AddressProcedureMultiLang.LANG_5.getDesc();
        String content = String.format(desc, type, name);
        LogMember logMember = new LogMember();
        logMember.setName(name);
        logMember.setProcessDefinitionId(process.getProcessDefinitionId());
        logMember.setContent(content);
        return logMember;
    }

    private void writeLogMember(LogMember member, BusinessModelVariableScope scope) {
        new LogBridge().writeToNextBlock(member.getContent());
        scope.setVariable("logMember", (Object)SerializationUtils.toJsonString((Object)member));
        RunTimeLog.get().end((VariableScope)scope);
    }

    private LogMember afterDesigned(CommandContext commandContext, AddressProcedure addressProcedure, String reason) {
        AlternativeProcess enteredProcess;
        SchemePathItem targetScheme;
        Long definitionId = Optional.ofNullable(addressProcedure).map(AddressProcedure::getEnteredProcess).map(AlternativeProcess::getProcessDefinitionId).orElseGet(() -> 0L);
        if (definitionId == 0L) {
            return new LogMember();
        }
        String content = AddressProcedureMultiLang.LANG_54.getDesc();
        ProcessNotExistReasonEnum reasonEnum = ProcessNotExistReasonEnum.getEnum((String)reason);
        String description = Optional.ofNullable(reasonEnum).map(ProcessNotExistReasonEnum::getDesc).map(MultiLangEnumBridge::toLocaleString).map(WFErrorCode::getAdminLangError).orElseGet(() -> "");
        if (reasonEnum == ProcessNotExistReasonEnum.CONFLICT) {
            String desc = AddressProcedureMultiLang.LANG_55.getDesc();
            description = String.format(description, desc);
        }
        if ((targetScheme = (enteredProcess = addressProcedure.getEnteredProcess()).getTargetScheme()) != null && targetScheme.getSchemeId() != null && targetScheme.getSchemeId() != 0L) {
            Long schemeId = targetScheme.getSchemeId();
            DynamicConfigSchemeEntity scheme = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(schemeId);
            targetScheme.setName(scheme.getName());
        }
        String processNameWithScheme = enteredProcess.getProcessNameWithScheme();
        String format = String.format(content, description, processNameWithScheme);
        LogMember logMember = new LogMember();
        logMember.setProcessDefinitionId(definitionId);
        logMember.setSub(false);
        logMember.setName(processNameWithScheme);
        logMember.setContent(format);
        return logMember;
    }

    private LogMember afterBindSubProcess(CommandContext commandContext, AddressProcedure addressProcedure) {
        String superExecutionName;
        if (addressProcedure == null || addressProcedure.getEnteredProcess() == null || addressProcedure.getEnteredProcess().getParentProcess() == null) {
            return new LogMember();
        }
        AlternativeProcess enteredProcess = addressProcedure.getEnteredProcess();
        ParentProcess parentProcess = enteredProcess.getParentProcess();
        ArrayList executionIds = Lists.newArrayList((Object[])new Long[]{parentProcess.getSuperExecutionId()});
        QFilter[] qFilters = new QFilter("id", "in", (Object)executionIds).toArray();
        List superExecutions = commandContext.getExecutionEntityManager().findByQueryFilters(qFilters);
        if (superExecutions == null || superExecutions.isEmpty()) {
            superExecutionName = "";
        } else {
            ExecutionEntity superExecution = (ExecutionEntity)superExecutions.get(0);
            List strings = Splitter.on((String)"/").splitToList((CharSequence)superExecution.getName().getLocaleValue()).stream().skip(1L).collect(Collectors.toList());
            superExecutionName = Joiner.on((String)"/").join(strings);
        }
        HistoricActivityInstanceEntity activity = new FindActivityByExecutionIdAndActId(parentProcess.getSuperExecutionId(), parentProcess.getCurrentActInstId()).execute(commandContext);
        String actName = activity.getActivityName().getLocaleValue();
        String processName = enteredProcess.getProcessName();
        String msg = AddressProcedureMultiLang.LANG_53.getDesc();
        String content = String.format(msg, superExecutionName, actName, processName);
        LogMember member = new LogMember();
        member.setContent(content);
        member.setProcessDefinitionId(enteredProcess.getProcessDefinitionId());
        member.setSub(true);
        member.setName(enteredProcess.getProcessNameWithScheme());
        return member;
    }

    private LogMember afterAssign(CommandContext commandContext, Map<String, Object> variables) {
        String procDefId = variables.get("procdefid").toString();
        String schemeid = variables.get("schemeid").toString();
        DynamicConfigSchemeEntity schemeEntity = (DynamicConfigSchemeEntity)commandContext.getDynamicConfigSchemeEntityManager().findById(Long.valueOf(schemeid));
        ProcessDefinitionEntity definitionEntity = (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(Long.valueOf(procDefId));
        String desc = AddressProcedureMultiLang.LANG_41.getDesc();
        String type = "";
        type = ModelType.AuditFlow.name().equalsIgnoreCase(definitionEntity.getType()) ? AddressProcedureMultiLang.LANG_4.getDesc() : AddressProcedureMultiLang.LANG_5.getDesc();
        LogMember member = new LogMember();
        String schemeName = Optional.ofNullable(schemeEntity).map(DynamicConfigSchemeEntity::getName).map(Object::toString).orElseGet(() -> "");
        member.setContent(String.format(desc, type, definitionEntity.getKey(), definitionEntity.getVersion(), schemeName));
        member.setSub(false);
        member.setName(definitionEntity.getKey() + "/" + definitionEntity.getVersion() + "/" + schemeName);
        member.setProcessDefinitionId(Long.valueOf(procDefId));
        return member;
    }

    private void removeSameJob(CommandContext commandContext, JobEntity job, String msg) {
        JobEntity jobEntity = Optional.ofNullable(job).orElseGet(JobEntityImpl::new);
        this.logger.info(String.format("JobId:%s-%s", job.getId(), msg));
        JobFinishNotification deleteOtherDBJob = new JobFinishNotification((ExecuteJob)job);
        commandContext.addCloseListener((CommandContextCloseListener)deleteOtherDBJob);
        if (WfConfigurationUtil.isNotDelayTriggerOperation()) {
            this.updateAsyncJob(commandContext, job);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addressProcess(CommandContext commandContext, String businessKey, String operation, String entityNumber, Map<String, Object> variables, JobEntity job) {
        AddressLogger addressLogger = AddressLogger.get((CommandContext)commandContext);
        ProcessStatusEnum status = new GetProcessStatusCmd(businessKey, job.getId(), variables).execute(commandContext);
        this.logger.info("the state of business[" + businessKey + "] in the workflow is:" + ProcessStatusEnum.getDescription((String)status.getCode()));
        if (status.canNewProcessInstance() || JOB_ACTION_CREATESUBPROCESS.equals(variables.get(JOB_ACTION))) {
            DynamicObject businessModel;
            HashMap<String, Object> target = null;
            ProcessDefinitionStartInfo processDefinition = null;
            ProcessDefinitionEntityManager defMgr = commandContext.getProcessDefinitionEntityManager();
            BusinessModelVariableScope bizScope = new BusinessModelVariableScope(businessKey, entityNumber);
            String procDefId = (String)variables.get("procdefid");
            String callProcDefId = (String)variables.get(CALLACTIVITYPROCDEFKEY);
            String calledWay = (String)variables.get(CALLACTIVITYCALLEDWAY);
            Long rootprocInstId = (Long)variables.get("rootProcessInstanceId");
            Long superExecutionId = (Long)variables.get("superExecutionId");
            try {
                Object isCrossTenant = variables.get("isCrossTenant");
                Object isCallActity = variables.get("isCallActity");
                if (isCrossTenant != null && ((Boolean)isCrossTenant).booleanValue() && isCallActity != null && ((Boolean)isCallActity).booleanValue()) {
                    variables.put(PARENTPROCDEFID, variables.get(PARENTPROCDEFID));
                } else if (WfUtils.isNotEmpty(rootprocInstId) && WfUtils.isNotEmpty(superExecutionId)) {
                    FlowElement e;
                    Process process = ProcessDefinitionUtil.getProcessByProcInstId((Long)rootprocInstId);
                    ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(superExecutionId);
                    if (process != null && execution != null && (e = process.getFlowElement(execution.getActivityId())) instanceof CallActivity) {
                        variables.put(PARENTPROCDEFID, execution.getProcessDefinitionId());
                        CallActivity c = (CallActivity)e;
                        calledWay = c.getCalledWay();
                        if ("bindByProdefId".equals(calledWay)) {
                            callProcDefId = c.getCallProcessNumber();
                        }
                    }
                }
                if (operation == null) {
                    operation = (String)variables.get("_operation_");
                }
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
            }
            if (WfUtils.isNotEmpty(procDefId) || "bindByProdefId".equals(calledWay)) {
                ProcessDefinitionEntity def = null;
                if (WfUtils.isNotEmpty(procDefId)) {
                    def = (ProcessDefinitionEntity)defMgr.findById(Long.valueOf(procDefId));
                    addressLogger.logEnteredProcess(def);
                } else {
                    if (!WfUtils.isNotEmpty(callProcDefId)) throw new WFNotFindSubProcessException(WFErrorCode.subprocessDisabled(), variables.values().toArray());
                    def = defMgr.findLatestEnableProcessDefinitionByKey(callProcDefId);
                    addressLogger.logSubProcessAddress(def, variables);
                }
                String relog = "";
                if (def != null) {
                    if (JOB_ACTION_CREATESUBPROCESS.equals(variables.get(JOB_ACTION)) && "disable".equals(def.getEnable())) {
                        throw new WFNotFindSubProcessException(WFErrorCode.subprocessDisabled(), variables.values().toArray());
                    }
                    relog = "find result :" + def.getKey();
                    target = new HashMap();
                    target.put("id", def.getId());
                    target.put("number", def.getKey());
                    target.put("version", def.getVersion());
                    target.put("processType", def.getType());
                } else {
                    relog = "unable to find target process";
                }
                this.logger.debug(relog);
            } else {
                businessModel = WfUtils.findBusinessObject(businessKey, entityNumber);
                if (businessModel == null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u53f7\uff1a%1$s\uff0c\u4e1a\u52a1\u952e\u503c\uff1a%2$s\uff0c\u5df2\u4e0d\u5b58\u5728\u3002", (String)"AddressProcessJobHandler_45", (String)"bos-wf-engine", (Object[])new Object[0]), entityNumber, businessKey);
                    WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness((String)businessKey, (String)entityNumber);
                    BizFlowUtil.deleteBizRelationData((CommandContext)commandContext, (String)businessKey);
                    throw new WFObjectNotFoundException(msg);
                }
                Set srcIds = BizFlowUtil.getDirectSourceBillIds((String)entityNumber, (String)businessKey);
                if (!srcIds.isEmpty()) {
                    this.setSrcBillBizTraceNo(commandContext, variables, srcIds);
                }
                if (processDefinition == null) {
                    processDefinition = AddressProcessUtils.address(commandContext, businessModel, operation, (Long)variables.get(PARENTPROCDEFID));
                }
                addressLogger.logEnteredProcess(processDefinition);
                if (processDefinition == null) {
                    if (JOB_ACTION_CREATESUBPROCESS.equals(variables.get(JOB_ACTION))) {
                        throw new WFNotFindSubProcessException(WFErrorCode.findNotSubProcess(), variables.values().toArray());
                    }
                    String msg = "no suitable process is found for [" + entityNumber + "] and [" + businessKey + "]";
                    job.setExceptionMessage(msg);
                    WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness((String)businessKey, (String)entityNumber);
                    return;
                }
                target = new HashMap<String, Object>();
                target.put("id", processDefinition.getId());
                target.put("number", processDefinition.getNumber());
                target.put("version", processDefinition.getVersion());
                target.put("processType", processDefinition.getProcessType());
            }
            if (target == null) {
                if (JOB_ACTION_CREATESUBPROCESS.equals(variables.get(JOB_ACTION))) {
                    throw new WFNotFindSubProcessException(WFErrorCode.findNotSubProcess(), variables.values().toArray());
                }
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u201c%1$s\u201d\u5355\u53f7\u201c%2$s\u201d\u64cd\u4f5c\u201c%3$s\u201d\u672a\u627e\u5230\u5339\u914d\u7684\u6d41\u7a0b\u3002 ", (String)"AddressProcessJobHandler_38", (String)"bos-wf-engine", (Object[])new Object[0]), entityNumber, businessKey, operation);
                job.setExceptionMessage(msg);
                WfCacheHelper.removeExecutingJobGYEntityOfCurrentBusiness((String)businessKey, (String)entityNumber);
                return;
            }
            businessModel = WfUtils.findBusinessObject(businessKey, entityNumber);
            bizScope.setModel(businessModel);
            Long schemeId = (Long)variables.get("wfSchemeId");
            if (schemeId == null) {
                schemeId = BpmnModelUtil.filterSchemeByCondition((CommandContext)commandContext, target, (VariableScope)bizScope);
            } else {
                SchemePathItem schemePathItem = new SchemePathItem();
                schemePathItem.setSchemeId(schemeId);
                addressLogger.logEnteredProcessTargetScheme(schemePathItem);
            }
            String key = (String)target.get("number");
            String version = (String)target.get("version");
            String processType = (String)target.get("processType");
            this.logger.debug("start new processInstance,key is " + key + ",version is " + version);
            if (variables == null) {
                variables = new HashMap<String, Object>(4);
            }
            Long initiatorId = null;
            if (variables.get("_initiator_") != null) {
                try {
                    initiatorId = Long.parseLong((String)variables.get("_initiator_"));
                }
                catch (Exception e) {
                    this.logger.info(e.getMessage());
                }
            }
            variables.put("_businessKey_", businessKey);
            variables.put("_entityNumber_", entityNumber);
            variables.put("_initiator_", WfUtils.isEmpty(initiatorId) ? String.valueOf(RequestContext.get().getCurrUserId()) : String.valueOf(initiatorId));
            variables.put("_operation_", operation);
            variables.put("SCHEMEID", schemeId);
            variables.put("processType", processType);
            String bizTraceNo = (String)variables.get("biztraceno");
            if (WfUtils.isEmpty(bizTraceNo) && WfUtils.isNotEmpty(job.getBizTraceNo())) {
                variables.put("biztraceno", job.getBizTraceNo());
            } else if (WfUtils.isNotEmpty(bizTraceNo)) {
                job.setBizTraceNo(bizTraceNo);
            }
            key = BizFlowUtil.getSignalEvent((String)processType, (String)key, (String)entityNumber);
            commandContext.getProcessEngineConfiguration().getRuntimeService().signalEventReceivedAsync(key, version, variables);
            this.checkJobUnsubmitFinally(commandContext, job);
            MainEntityType entity = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String entityName = entity.getDisplayName().getLocaleValue();
            String billNo = entityName + ":" + this.getBillNo();
            WfUtils.addOpLog(entityNumber, "startProcess", new kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge("\u53d1\u8d77\u6d41\u7a0b", "AddressProcessJobHandler_8", "bos-wf-engine"), null, billNo);
            variables.put("startJob", "true");
            return;
        }
        if (status.isWaiting()) {
            boolean triggerEventSubProcess = false;
            EventSubscriptionEntityManager eventSubscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
            List eventSubscription = eventSubscriptionEntityManager.findMessageEventSubscriptionsByBusinessKey(businessKey, operation);
            if (eventSubscription != null && !eventSubscription.isEmpty()) {
                String log = "";
                Iterator procDefId = eventSubscription.iterator();
                if (procDefId.hasNext()) {
                    EventSubscriptionEntity subscriptionEntity = (EventSubscriptionEntity)procDefId.next();
                    ExecutionEntity eventExecution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(subscriptionEntity.getExecutionId());
                    if (eventExecution.isActive()) {
                        triggerEventSubProcess = true;
                        log = "started subprocess";
                    } else {
                        eventSubscriptionEntityManager.eventReceived(subscriptionEntity, variables, false);
                        triggerEventSubProcess = true;
                        log = "New startup subprocess";
                    }
                }
                this.logger.debug(log);
            }
            if (triggerEventSubProcess) return;
            List<ExecutionEntity> executions = commandContext.getExecutionEntityManager().findBillExecutionByBusinesskey(businessKey);
            if (executions != null && !executions.isEmpty()) {
                ExecutionEntity billExeOrProcinst = null;
                Long procinstId = executions.get(0).getRootProcessInstanceId();
                for (ExecutionEntity entity : executions) {
                    if (procinstId.equals(entity.getId())) {
                        billExeOrProcinst = entity;
                    }
                    if (entity.isBillExecution()) {
                        billExeOrProcinst = entity;
                    }
                    if (!entity.isActive() || entity.getParent() == null || !entity.getParent().isBillExecution()) continue;
                    billExeOrProcinst = entity.getParent();
                    break;
                }
                if (billExeOrProcinst != null) {
                    this.logger.debug(String.format("billExeOrProcinst[%s]", billExeOrProcinst.getId()));
                    Long procdefId = billExeOrProcinst.getProcessDefinitionId();
                    BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((Long)procdefId, (Long)procinstId);
                    List exceptionOps = bpmnModel.getMainProcess().getBillExceptionOp();
                    if (exceptionOps != null && !exceptionOps.isEmpty()) {
                        ProcessDefinitionInfoEntity infoEntity = commandContext.getProcessDefinitionInfoEntityManager().findBillExceptionOperation(procdefId, bpmnModel.getMainProcess().getId(), operation);
                        String infoEntityOperation = null;
                        if (infoEntity != null && WfUtils.isNotEmpty(infoEntityOperation = infoEntity.getOperation())) {
                            for (BillExceptionOp op : exceptionOps) {
                                if (op.getOper().equals(infoEntityOperation) && "terminate".equalsIgnoreCase(op.getProcaction())) {
                                    Map name;
                                    Map opInfo = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)op.getOper());
                                    if (opInfo == null || opInfo.isEmpty() || (name = (Map)opInfo.get("name")) == null || name.isEmpty()) continue;
                                    ILocaleString bill = WfUtils.getPromptWordLocaleString("\u5355\u636e", "AddressProcessJobHandler_11", "bos-wf-engine");
                                    ILocaleString cause = WfMultiLangUtils.getMultiLangValue((ILocaleString[])new ILocaleString[]{new LocaleString("%s%s"), bill, LocaleString.fromMap((Map)name)});
                                    HashMap<String, Object> param = new HashMap<String, Object>();
                                    param.put("exceptionEvent", op.getOper());
                                    commandContext.getProcessEngineConfiguration().getCommandExecutor().execute((Command)new AbandonProcessCmd(procinstId, cause, "billExcepAbort", param));
                                    continue;
                                }
                                if (op.getOper().equals(infoEntityOperation) && "processdelete".equalsIgnoreCase(op.getProcaction())) {
                                    commandContext.getProcessEngineConfiguration().getCommandExecutor().execute((Command)new DeleteAllRuntimeDatasByProcessInstanceIdCmd(procinstId));
                                    continue;
                                }
                                if (billExeOrProcinst.getEntityNumber() != null && billExeOrProcinst.getEntityNumber().equals(op.getBillnumber()) && op.getOper().equals(infoEntityOperation) && "procinstiddelete".equals(op.getProcaction())) {
                                    new BillBackOrProcessTerminateCmd(billExeOrProcinst, entityNumber, WfUtils.getPromptWordLocaleString("\u5355\u636e\u4f8b\u5916", "AddressProcessJobHandler_60", "bos-wf-engine"), true, op.getOper()).execute(commandContext);
                                    continue;
                                }
                                if (billExeOrProcinst.getEntityNumber() == null || !billExeOrProcinst.getEntityNumber().equals(op.getBillnumber()) || !op.getOper().equals(infoEntityOperation) || !"billdelete".equals(op.getProcaction())) continue;
                                new BillBackOrProcessTerminateCmd(billExeOrProcinst, entityNumber, WfUtils.getPromptWordLocaleString("\u5355\u636e\u4f8b\u5916", "AddressProcessJobHandler_60", "bos-wf-engine"), false, op.getOper()).execute(commandContext);
                            }
                            return;
                        }
                    }
                }
            }
            TaskEntityManager taskMgr = commandContext.getProcessEngineConfiguration().getTaskEntityManager();
            List tasks = taskMgr.findTasksByBusinessKeyOrderBySuperExec(businessKey);
            this.completeTasks(tasks, commandContext, entityNumber, businessKey, operation, variables, job);
            if (tasks != null && !tasks.isEmpty() || WfUtils.exist(entityNumber, (Object)businessKey)) return;
            BizFlowUtil.deleteBizRelationData((CommandContext)commandContext, (String)businessKey);
            return;
        } else if (status.isFlowMsgSuspend()) {
            this.removeSameJob(commandContext, job, ResManager.loadKDString((String)"\u6d41\u7a0b\u5df2\u6302\u8d77\uff0c\u6d88\u606f\u5df2\u5e9f\u5f03\u3002", (String)"AddressProcessJobHandler_13", (String)"bos-wf-engine", (Object[])new Object[0]));
            return;
        } else {
            if (status.isFowMsgRunning()) {
                if (!TYPE.equalsIgnoreCase(job.getJobHandlerType())) throw new KDException(WFErrorCode.processIsRunningException(), new Object[]{businessKey});
                throw new AddressingDuplicateException(WFErrorCode.processIsRunningException(), new Object[]{businessKey});
            }
            if (status.isStartingMsgSuspend()) {
                this.removeSameJob(commandContext, job, ResManager.loadKDString((String)"\u6d41\u7a0b\u542f\u52a8\u51fa\u9519\u3002\u91cd\u590d\u7684\u6d88\u606f\u5df2\u4e22\u5f03\uff0c\u8bf7\u624b\u52a8\u5904\u7406\u3002", (String)"AddressProcessJobHandler_15", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            } else if (status.isStartingMsgRunning()) {
                if (!TYPE.equalsIgnoreCase(job.getJobHandlerType())) throw new KDException(WFErrorCode.processIsStartingException(), new Object[]{businessKey});
                this.removeSameJob(commandContext, job, ResManager.loadKDString((String)"\u6d41\u7a0b\u542f\u52a8\u4e2d\uff0c\u5bfb\u5740\u6d88\u606f\u5c06\u88ab\u5e9f\u5f03\u3002", (String)"AddressProcessJobHandler_16", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            } else {
                this.handleAddressMsg(commandContext, status, job, businessKey);
            }
        }
    }

    private void checkJobUnsubmitFinally(CommandContext commandContext, JobEntity job) {
        WfTraceType wfTraceType = WfTraceType.get();
        if (wfTraceType != null && WfUtils.isNotEmpty(wfTraceType.getChildJob())) {
            commandContext.addCloseListenerFirst((CommandContextCloseListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void logProcessNotExist(DynamicObject businessModel, JobEntity job, AddressProcedure addressProcedure, Map<String, Object> variables, String operate) {
        try {
            Long definitionId;
            if (addressProcedure.getUnwanted().booleanValue()) {
                return;
            }
            if (JOB_ACTION_CREATESUBPROCESS.equals(variables.get(JOB_ACTION))) {
                return;
            }
            if (AddressProcedure.emptyData((AddressProcedure)addressProcedure)) {
                return;
            }
            String entityNumber = businessModel.getDataEntityType().getName();
            WorkflowDevopsService devopsService = WorkflowDevopsService.create();
            ProcessNotExistPoJo poJo = this.buildProcessNotExistPojo(businessModel, job, addressProcedure, variables, operate);
            if (!ProcessNotExistPoJo.EMPTY.equals((Object)poJo)) {
                boolean needLogProcessNotExist = devopsService.needLogProcessNotExist(entityNumber);
                if (!needLogProcessNotExist) {
                    this.logger.debug("\u8fdb\u5165\u6d41\u7a0b\u6216\u8005\u5982\u679c\u4e0d\u9700\u8981\u5199\u5165\u6570\u636e\u5e93\u5c31\u7b97\u4e86");
                    return;
                }
                Long alarmLogId = devopsService.notifySubmitterProcessNotEntered(businessModel, poJo);
                poJo.setAlarmMsgSendLogId(alarmLogId);
                devopsService.logProcessNotExist(poJo);
            }
            if ((definitionId = Optional.ofNullable(addressProcedure.getEnteredProcess()).map(AlternativeProcess::getProcessDefinitionId).orElse(0L)) != 0L) {
                WorkflowDevopsService.create().removeLog(addressProcedure.getBusinessKey(), addressProcedure.getEntityNumber());
            }
        }
        catch (Throwable e) {
            this.logger.warn("I have been try my best to build it......", e);
        }
    }

    public ProcessNotExistPoJo buildProcessNotExistPojo(DynamicObject businessModel, JobEntity job, AddressProcedure addressProcedure, Map<String, Object> variables, String operate) {
        AlternativeProcess enteredProcess = addressProcedure.getEnteredProcess();
        if (enteredProcess != null && enteredProcess.getProcessDefinitionId() != null && enteredProcess.getProcessDefinitionId() != 0L) {
            return new ProcessNotExistPoJo();
        }
        ProcessNotExistPoJo processNotExistPoJo = this.fillFromModelAndJob(businessModel, job, variables, operate);
        Boolean only = Optional.ofNullable(addressProcedure.getFindTheOnlyProcessStatus()).orElseGet(() -> Boolean.FALSE);
        if (!only.booleanValue()) {
            return this.buildNotFind(processNotExistPoJo);
        }
        List alternativeProcesses = addressProcedure.getAlternativeProcesses();
        if (alternativeProcesses == null || alternativeProcesses.isEmpty()) {
            return this.buildNotFind(processNotExistPoJo);
        }
        return this.buildConflict(processNotExistPoJo, alternativeProcesses);
    }

    private ProcessNotExistPoJo fillFromModelAndJob(DynamicObject businessModel, JobEntity job, Map<String, Object> variables, String op) {
        ProcessNotExistPoJo poJo = new ProcessNotExistPoJo();
        try {
            poJo.setEntityNumber(businessModel.getDataEntityType().getName());
            poJo.setOperate(op);
            poJo.setBusinessKey(businessModel.getPkValue().toString());
            Long initiator = HandlerConfig.build((JobEntity)job).acquireInitiator();
            poJo.setSubmitterId(initiator);
            String billNo = TaskBehaviorUtil.getTaskBillNo(businessModel.getDataEntityType().getName(), businessModel);
            poJo.setBillno(billNo);
            poJo.setSubmitTime(WfUtils.now());
            poJo.setEntraBillName((ILocaleString)businessModel.getDataEntityType().getDisplayName());
            poJo.setVariables(SerializationUtils.toJsonString(variables));
        }
        catch (Exception e) {
            this.logger.warn("I have been try my best to build it......", (Throwable)e);
        }
        return poJo;
    }

    private ProcessNotExistPoJo buildNotFind(ProcessNotExistPoJo poJo) {
        poJo.setErrorReason(ProcessNotExistReasonEnum.NOT_FIND);
        return poJo;
    }

    private ProcessNotExistPoJo buildConflict(ProcessNotExistPoJo poJo, List<AlternativeProcess> alternativeProcesses) {
        List payload;
        ArrayList<AlternativeProcess> hasConditionProcessList = new ArrayList<AlternativeProcess>();
        ArrayList<AlternativeProcess> noConditionProcessList = new ArrayList<AlternativeProcess>();
        for (AlternativeProcess item2 : alternativeProcesses) {
            if (StringUtils.isEmpty((CharSequence)item2.getStartCondition())) {
                noConditionProcessList.add(item2);
                continue;
            }
            hasConditionProcessList.add(item2);
        }
        List enableProcessList = hasConditionProcessList.stream().filter(item -> Boolean.TRUE.equals(item.getStartConditionStatus())).collect(Collectors.toList());
        if (enableProcessList.size() > 1) {
            payload = enableProcessList.stream().map(AlternativeProcess::getProcessDefinitionId).collect(Collectors.toList());
            ReasonPayload reasonPayload = new ReasonPayload();
            reasonPayload.setReason(ProcessNotExistReasonEnum.CONFLICT);
            reasonPayload.setData(payload);
            poJo.setPayload(reasonPayload);
            poJo.setErrorReason(ProcessNotExistReasonEnum.CONFLICT);
            return poJo;
        }
        if (noConditionProcessList.size() > 1) {
            payload = noConditionProcessList.stream().map(AlternativeProcess::getProcessDefinitionId).collect(Collectors.toList());
            ReasonPayload reasonPayload = new ReasonPayload();
            reasonPayload.setReason(ProcessNotExistReasonEnum.CONFLICT);
            reasonPayload.setData(payload);
            poJo.setPayload(reasonPayload);
            poJo.setErrorReason(ProcessNotExistReasonEnum.CONFLICT);
            return poJo;
        }
        return this.buildNotFind(poJo);
    }

    private void setSrcBillBizTraceNo(CommandContext commandContext, Map<String, Object> variables, Set<String> srcBillIds) {
        for (String billId : srcBillIds) {
            String bizTraceNo;
            QFilter[] filters = new QFilter[]{new QFilter("businesskey", "=", (Object)billId)};
            List relations = commandContext.getCirculateRelationEntityManager().findByQueryFilters(filters, "biztraceno", null);
            if (relations.isEmpty() || !WfUtils.isNotEmpty(bizTraceNo = ((CirculateRelationEntity)relations.get(0)).getBizTraceNo())) continue;
            variables.put("biztraceno", bizTraceNo);
            return;
        }
    }

    private void handleAddressMsg(CommandContext commandContext, ProcessStatusEnum status, JobEntity job, String businessKey) {
        if (status.isAddressMsgSuspend()) {
            this.removeSameJob(commandContext, job, ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u6d41\u7a0b\u540c\u4e00\u4e2a\u64cd\u4f5c\u7684\u524d\u4e00\u4e2a\u6d41\u7a0b\u5bfb\u5740\u6d88\u606f\u51fa\u9519\uff0c\u91cd\u590d\u7684\u6d88\u606f\u5df2\u4e22\u5f03\uff0c\u8bf7\u624b\u52a8\u5904\u7406\u3002", (String)"AddressProcessJobHandler_17", (String)"bos-wf-engine", (Object[])new Object[0]));
        } else if (status.isAddressMsgRunning()) {
            throw new KDException(WFErrorCode.addressMsgAddJobException(), new Object[]{businessKey});
        }
    }

    private void updateAsyncJob(CommandContext commandContext, JobEntity job) {
        JobEntity findedJob = (JobEntity)commandContext.getJobEntityManager().findById(job.getId());
        if (findedJob != null) {
            findedJob.setExclusive(true);
            commandContext.getJobEntityManager().update((Entity)findedJob);
        }
    }

    private void completeTasks(List<TaskEntity> tasks, CommandContext commandContext, String entityNumber, String businessKey, String operation, Map<String, Object> variables, JobEntity job) {
        if (tasks == null || tasks.isEmpty()) {
            this.logger.info("no task is found,may be the process is in continuing!");
            if (WfConfigurationUtil.isNotDelayTriggerOperation()) {
                this.updateAsyncJob(commandContext, job);
                return;
            }
            throw new AddressingProcessException(WFErrorCode.processInContinuingFlow(), (Object[])new String[]{businessKey});
        }
        TaskEntity taskEntity = tasks.get(0);
        new ModifyWorkflowBillNoCmd(taskEntity).execute(commandContext);
        boolean hasSuitableTask = false;
        for (TaskEntity task : tasks) {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((Long)task.getProcessDefinitionId(), (Long)task.getProcessInstanceId());
            UserTask userTask = (UserTask)bpmnModel.getFlowElement(task.getTaskDefinitionKey());
            if (userTask instanceof AuditTask) continue;
            boolean continueFlow = userTask != null && entityNumber.equalsIgnoreCase(userTask.getEntityNumber()) && userTask.getOperationStr() != null && Arrays.asList(userTask.getOperationStr().split(",")).contains(operation);
            this.logger.info("continueFlow is [" + continueFlow + "],the operation of node[" + (userTask != null ? userTask.getName() : "") + "] is [" + (userTask != null ? userTask.getOperationStr() : "") + "],and operation parameter is [" + operation + "]");
            if (continueFlow) {
                if (variables == null) {
                    variables = new HashMap<String, Object>();
                }
                Map operate = EntityMetadataCache.getDataEntityOperate((String)task.getEntityNumber(), (String)operation);
                String number = null;
                LocaleString name = new LocaleString();
                if (operate != null && !operate.isEmpty() && operate.get("name") != null) {
                    Map operateName = (Map)operate.get("name");
                    for (Map.Entry entry : operateName.entrySet()) {
                        name.setItem((String)entry.getKey(), entry.getValue());
                    }
                    number = (String)operate.get("key");
                }
                boolean firstNode = BpmnModelUtil.isFirstNodeByModel((FlowNode)userTask);
                ProcessEngineConfigurationImpl procEngineCfg = commandContext.getProcessEngineConfiguration();
                TaskHelper taskHelper = procEngineCfg.getTaskHelper();
                taskHelper.wrapBackToRejectVariables(commandContext, task, variables, bpmnModel, userTask);
                boolean isSubProcess = task.getExecution().getSuperExecutionId() != null && task.getExecution().getSuperExecutionId() != 0L;
                this.logger.debug("\u662f\u5426\u6ee1\u8db3\u662f\u7b2c\u4e00\u4e2a\u4eba\u5de5\u8282\u70b9\uff0c\u5e76\u4e14\u4e0d\u662f\u5b50\u6d41\u7a0b\uff1abusinesskey:" + businessKey + "firstNode result" + firstNode + "issubprocess result" + isSubProcess);
                if (firstNode && !isSubProcess) {
                    if (this.addressAndAbandonIfNeed(commandContext, businessKey, operation, entityNumber, variables, task.getProcessDefinitionId(), task.getProcessInstanceId(), bpmnModel)) {
                        return;
                    }
                    AddressLogger.get((CommandContext)commandContext).unwanted();
                }
                String userId = RequestContext.get().getUserId();
                Object callInitiator = variables.get("_initiator_");
                if (firstNode) {
                    if (callInitiator != null && StringUtils.isNumeric((CharSequence)callInitiator.toString())) {
                        userId = callInitiator.toString();
                    }
                    if (userId != null && !userId.equalsIgnoreCase(String.valueOf(task.getStarterId()))) {
                        String userName = null;
                        Map usersNameFormat = ParticipantHelper.getParticipantDisplayInfo((TaskEntity)task, Collections.singletonList(Long.valueOf(userId)));
                        userName = RequestContext.get().getUserName();
                        String startName = null;
                        ILocaleString startNameFormat = task.getStartNameFormat();
                        String displayInfo = null;
                        ParticipatantModel participantModel = userTask.getParticipant();
                        if (participantModel != null) {
                            displayInfo = participantModel.getDisplayInfo();
                        }
                        if (WfUtils.isNotEmpty(displayInfo)) {
                            Map startNameFormatMap = ParticipantHelper.getParticipantDisplayInfo((TaskEntity)task, Collections.singletonList(task.getStarterId()));
                            startNameFormat = (ILocaleString)startNameFormatMap.get(task.getStarterId());
                        }
                        startName = task.getStartName().getLocaleValue();
                        variables.put("assignee", String.format(ResManager.loadKDString((String)"%1$s(\u4ee3%2$s)", (String)"AddressProcessJobHandler_18", (String)"bos-wf-engine", (Object[])new Object[0]), userName, startName));
                        LocaleString assigneeFormat = new LocaleString();
                        for (Lang lang : WfUtils.getSupportLangs()) {
                            ILocaleString userNameLString = (ILocaleString)usersNameFormat.get(Long.valueOf(userId));
                            String userNameLang = userNameLString == null ? "" + userId : (String)userNameLString.get((Object)lang.toString());
                            String startNameLang = startNameFormat == null ? "" + task.getStarterId() : (String)startNameFormat.get((Object)lang.toString());
                            assigneeFormat.put((Object)lang.toString(), (Object)String.format(ResManager.loadKDString((String)"%1$s(\u4ee3%2$s)", (String)"AddressProcessJobHandler_18", (String)"bos-wf-engine", (Object[])new Object[0]), userNameLang, startNameLang));
                        }
                        variables.put("assigneeFormat", assigneeFormat);
                    }
                }
                variables.put("auditName", name);
                variables.put("auditNumber", number);
                Object auditMessageObj = variables.get("auditmessage");
                if (null != auditMessageObj && WfUtils.isJSONFormat(auditMessageObj)) {
                    try {
                        Map auditMessageMap = (Map)SerializationUtils.fromJsonString((String)auditMessageObj.toString(), Map.class);
                        auditMessageObj = auditMessageMap.isEmpty() ? null : auditMessageMap;
                    }
                    catch (Exception e) {
                        this.logger.info(e.getMessage());
                    }
                }
                if (WfUtils.isEmptyString(auditMessageObj)) {
                    auditMessageObj = name;
                }
                variables.put("auditMessage", auditMessageObj);
                hasSuitableTask = true;
                String buildSensitiveFieldKey = SensitiveFieldUtil.buildSensitiveFieldKey((String)task.getBusinessKey(), (String)task.getTaskDefinitionKey());
                if (variables != null && variables.get(buildSensitiveFieldKey) == null) {
                    this.getSensitiveFieldInfos(task, variables);
                }
                procEngineCfg.getTaskService().complete(task.getId(), Long.valueOf(userId), variables);
                this.logger.info(String.format("\u6267\u884c\u73b0\u6709\u4efb\u52a1[%s]", task.getId()));
                continue;
            }
            this.logger.info(String.format("\u5df2\u7ecf\u6709\u6d41\u7a0b\u5728\u8fd0\u884c\uff0c\u73b0\u6709\u4efb\u52a1[%s]\u4e0d\u7b26\u5408\u6761\u4ef6\u64cd\u4f5c[%s]", task.getId(), operation));
        }
        if (!hasSuitableTask && WfConfigurationUtil.isNotDelayTriggerOperation()) {
            this.updateAsyncJob(commandContext, job);
            this.logger.info(String.format("cannot find suitable task for execute[%s-%s-%s]", entityNumber, businessKey, operation));
        }
    }

    private boolean addressAndAbandonIfNeed(CommandContext commandContext, String businessKey, String operation, String entityNumber, Map<String, Object> variables, Long processDefinitionId, Long processInstanceId, BpmnModel bpmnModel) {
        Object newProcDefId = variables.get("newprocessdefinitionid");
        if (newProcDefId != null && processDefinitionId.equals(Long.valueOf((String)newProcDefId)) && variables.get("newschmeid") == null) {
            variables.remove("newprocessdefinitionid");
            return false;
        }
        Object schemeId = variables.get("newschmeid");
        if (newProcDefId == null || schemeId == null) {
            if (!WfConfigurationUtil.isNeedRestart() || WfUtils.isSyncRun()) {
                this.logger.debug("AddressProcessjobHandled WfConfigurationUtil.isNeedRestart() is false");
                return false;
            }
            List processVariables = bpmnModel.getMainProcess().getVariables();
            for (Variable variable : processVariables) {
                if (!"notrestartaddress".equals(variable.getName()) || !Boolean.parseBoolean((String)variable.getDefaultValue())) continue;
                this.logger.debug("\u5f53\u524d\u6d41\u7a0b\u5b58\u5728\u53d8\u91cf\uff0c\u4e14\u4e0d\u9700\u8981\u91cd\u65b0\u5bfb\u5740");
                return false;
            }
            DynamicObject businessModel = WfUtils.findBusinessObject(businessKey, entityNumber);
            if (businessModel == null) {
                this.logger.debug("\u9a73\u56de\u91cd\u65b0\u5bfb\u5740\u6ca1\u6709\u627e\u4e1a\u52a1\u6a21\u578bbusinessModel");
                return false;
            }
            AddressProcessUtils.restartAddress(commandContext, businessKey, operation, entityNumber, variables, processDefinitionId, processInstanceId, businessModel);
            newProcDefId = variables.get("newprocessdefinitionid");
            schemeId = variables.get("newschmeid");
        }
        if (newProcDefId != null && schemeId != null) {
            variables.remove("newprocessdefinitionid");
            variables.remove("newschmeid");
            ExecutionEntity procinst = commandContext.getExecutionEntityManager().findProcessInstanceById(processInstanceId);
            procinst.setVariable("wfProcessDefineId", newProcDefId);
            procinst.setVariable("wfSchemeId", schemeId);
            variables.remove("nextNodeId");
            variables.remove("dynName");
            variables.remove("dynType");
            procinst.setVariable("restartVariables", (Object)SerializationUtils.toJsonString(variables));
            procinst.setVariable("wfOperation", (Object)operation);
            procinst.setVariable("wfSubmitType", (Object)"processrestart");
            this.logger.debug(String.format("\u9a73\u56de\u91cd\u65b0\u5bfb\u5740\u7684\u6d41\u7a0b\u5b9e\u4f8bid\u3001\u6d41\u7a0bid\u548c\u65b9\u6848id\u4e3a\uff1a%1$s\uff0c%2$s\uff0c%3$s", processInstanceId, newProcDefId, schemeId));
            ILocaleString operationDesc = WfUtils.getPromptWordLocaleString("\u91cd\u65b0\u5bfb\u5740", "AddressProcessJobHandler_47", "bos-wf-engine");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("isRestartProcess", "true");
            commandContext.getProcessEngineConfiguration().getCommandExecutor().execute((Command)new AbandonProcessCmd(processInstanceId, operationDesc, "forceAbort", param));
            return true;
        }
        return false;
    }

    private void getSensitiveFieldInfos(TaskEntity task, Map<String, Object> variables) {
        String decOptionNumber = (String)variables.get("auditNumber");
        if (WfUtils.isNotEmpty(decOptionNumber)) {
            String sensitiveFieldInfosStr;
            String entityNumber;
            String businessKey = task.getBusinessKey();
            DynamicObject dataEntity = WfUtils.findBusinessObject(businessKey, entityNumber = task.getEntityNumber());
            if (dataEntity == null) {
                return;
            }
            CommandContext commandContext = Context.getCommandContext();
            Map map = new EnterSensitiveFieldChangeCmd(task.getEntityNumber(), new DynamicObject[]{dataEntity}, decOptionNumber, null, task.getCategory(), true).execute(commandContext);
            if (!map.isEmpty() && WfUtils.isNotEmpty(sensitiveFieldInfosStr = (String)map.get("sensitiveFieldInfos"))) {
                List sensitiveFieldInfos = (List)SerializationUtils.fromJsonString((String)sensitiveFieldInfosStr, List.class);
                for (Map sensitiveFieldInfo : sensitiveFieldInfos) {
                    String changkey;
                    Map params;
                    if (!((Boolean)sensitiveFieldInfo.get("isSensitiveChange")).booleanValue() || (params = (Map)sensitiveFieldInfo.get("params")) == null || params.isEmpty() || !WfUtils.isNotEmpty(changkey = (String)params.get("changkey"))) continue;
                    variables.put(changkey, SerializationUtils.toJsonString(sensitiveFieldInfos.get(0)));
                }
            }
        }
    }

    protected Map<String, Object> restoreContext(String configuration) {
        Map payload = (Map)SerializationUtils.fromJsonString((String)configuration, Map.class);
        if (payload != null && payload.get("_requestContext_") != null) {
            try {
                Map context = (Map)payload.get("_requestContext_");
                String lang = (String)context.get("lang");
                if (WfUtils.isNotEmpty(lang)) {
                    RequestContext requestContext = RequestContext.get();
                    requestContext.setLang(Lang.from((String)lang));
                }
            }
            catch (Throwable throwable) {
                this.logger.warn("\u5bfb\u5740\u8bbe\u7f6e\u591a\u8bed\u8a00\u5931\u8d25\u3002");
            }
            payload.remove("_requestContext_");
        }
        return payload;
    }
}

