/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.jobexecutor;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.job.ILocalJobHandleStrategy;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.AbstractJobHandler;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskHandleLogEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.msg.AbstractMessageServiceHandler;
import kd.bos.workflow.engine.msg.MessageServiceImpl;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.YzjToDoProperty;
import kd.bos.workflow.engine.msg.model.yzj.YzjToDoState;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaCommonUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ToDoJobHandler
extends AbstractJobHandler {
    private static Log logger = LogFactory.getLog(ToDoJobHandler.class);
    public static final String CONTEXT = "context";
    public static final String MODEL = "model";
    public static final String SERVICE_KEY = "service";
    public static final String TYPE = "async-todo";
    public static final String SERVICETYPE = "serviceType";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, ExecutionEntity execution, CommandContext commandContext) {
        try {
            Map payload = this.restoreContext(configuration);
            String jsonContext = (String)payload.get(CONTEXT);
            String jsonModel = (String)payload.get(MODEL);
            String service = (String)payload.get(SERVICE_KEY);
            MessageContext ctx = (MessageContext)SerializationUtils.fromJsonString((String)jsonContext, MessageContext.class);
            ToDoInfo model = (ToDoInfo)SerializationUtils.fromJsonString((String)jsonModel, ToDoInfo.class);
            logger.info(String.format("async-todo-job Id[%s], rootjobId[%s], taskId[%s] start execute", job.getId(), job.getRootJobId(), model.getTaskId()));
            MessageServiceImpl impl = (MessageServiceImpl)commandContext.getMessageService();
            if (impl.getService(service) == null) {
                if ("sysnotice".equalsIgnoreCase(service)) {
                    logger.warn(String.format("\u6e20\u9053[%s]\u4e0d\u53ef\u7528", service));
                    return;
                }
                throw new WFMessageServiceException(null, WFErrorCode.emptyErrorCode(), new Object[]{String.format("%s channel is not enable", service)});
            }
            Object immeRetry = commandContext.getAttribute("immediately");
            ctx.setImmediatelyRetry(!Boolean.FALSE.equals(immeRetry));
            if (!WfConfigurationUtil.isEnabledStrandardChannel(service)) {
                logger.warn(String.format("\u6e20\u9053[%s]\u4e0d\u53ef\u7528", service));
                return;
            }
            model.getParams().put(SERVICETYPE, service);
            switch (model.getState()) {
                case NEW: {
                    this.createToDo(commandContext, service, ctx, model, impl);
                    break;
                }
                case DEAL: {
                    this.dealToDo(service, ctx, model, impl);
                    break;
                }
                case DELETE: {
                    this.deleteToDo(service, ctx, model, impl);
                    break;
                }
                case DELETEANDCREATE: {
                    this.deleteAndCreateToDo(service, ctx, model, impl);
                    break;
                }
                case ONLYCHECK: {
                    this.checkToDo(job, commandContext, service, ctx, model, impl);
                    break;
                }
                case COMPLETE: {
                    this.processCompete(service, ctx, impl);
                    break;
                }
                case TERMINATE: {
                    this.processTerminate(service, ctx, impl);
                    break;
                }
                case START: {
                    this.processStart(service, ctx, impl);
                    break;
                }
                case PROCESSRESTART: {
                    this.processRestart(service, ctx, impl);
                    break;
                }
            }
        }
        catch (WFMessageServiceException mse) {
            throw mse;
        }
        catch (KDException e) {
            throw ExceptionUtil.createWFMessageServiceException((Object)job, (KDException)e);
        }
        catch (Exception e) {
            throw ExceptionUtil.createWFMessageServiceException((Object)job, (Throwable)e, (ErrorCode)WFErrorCode.messageJobHandlerException(), (Object[])new Object[0]);
        }
    }

    private void createToDo(CommandContext commandContext, String service, MessageContext ctx, ToDoInfo model, MessageServiceImpl impl) {
        boolean exist = QueryServiceHelper.exists((String)"wf_task", (Object)model.getTaskId());
        if (!exist) {
            logger.info(String.format("\u4efb\u52a1[%s]\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u6216\u8005\u88ab\u64a4\u56de.", model.getTaskId()));
            return;
        }
        List<Long> needCheckUserIds = this.needDeleteUserList(commandContext, model);
        if (needCheckUserIds.size() > 0) {
            ArrayList orignalUserIds = new ArrayList(model.getUserIds().size());
            orignalUserIds.addAll(model.getUserIds());
            String type = model.getNotifyType().indexOf("yunzhijiaeco") > 0 ? "yunzhijiaeco" : "yunzhijia";
            ArrayList<Long> needDeleteUserIds = new ArrayList<Long>(needCheckUserIds.size());
            for (Long checkUserId : needCheckUserIds) {
                ArrayList<Long> cuIds = new ArrayList<Long>(1);
                cuIds.add(checkUserId);
                model.setUserIds(cuIds);
                if (!this.checkUserToDo(ctx, model, type)) continue;
                needDeleteUserIds.add(checkUserId);
            }
            if (needDeleteUserIds.size() > 0) {
                model.setUserIds(needDeleteUserIds);
                impl.getService(service).deleteToDo(ctx, model);
            }
            model.setUserIds(orignalUserIds);
        }
        this.checkSupportQuickaggre(service, model, commandContext);
        model.setNotifyType(service);
        impl.getService(service).createToDo(ctx, model);
    }

    private void dealToDo(String service, MessageContext ctx, ToDoInfo model, MessageServiceImpl impl) {
        impl.getService(service).dealToDo(ctx, model);
    }

    private void deleteToDo(String service, MessageContext ctx, ToDoInfo model, MessageServiceImpl impl) {
        impl.getService(service).deleteToDo(ctx, model);
    }

    private void deleteAndCreateToDo(String service, MessageContext ctx, ToDoInfo model, MessageServiceImpl impl) {
        AbstractMessageServiceHandler handler = impl.getService(service);
        handler.deleteToDo(ctx, model);
        handler.createToDo(ctx, model);
    }

    private boolean checkToDo(JobEntity job, CommandContext commandContext, String service, MessageContext ctx, ToDoInfo model, MessageServiceImpl impl) {
        String category;
        QFilter display;
        QFilter id = new QFilter("id", "=", (Object)model.getTaskId());
        QFilter[] filters = new QFilter[]{id, display = new QFilter("display", "=", (Object)Boolean.TRUE)};
        boolean exist = QueryServiceHelper.exists((String)"wf_task", (QFilter[])filters);
        if (exist) {
            logger.info(String.format("\u4efb\u52a1[%s]\u5df2\u7ecf\u88ab\u91cd\u65b0\u6062\u590d(\u64a4\u56de\u5f15\u8d77),\u539f\u6709\u7684check\u4f5c\u5e9f", model.getTaskId()));
            return true;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)model.getTaskId(), (String)"wf_hitaskinst", (String)"category");
        String string = category = obj == null ? null : obj.getString("category");
        if (WfUtils.isNotEmpty(category) && BpmnModelUtil.instanceofSSCApprover((String)category)) {
            logger.debug(String.format("\u4efb\u52a1[%s]\u4e3a\u5171\u4eab\u4efb\u52a1\u4e0d\u505aCHECK", model.getTaskId()));
            return true;
        }
        Object env = commandContext.getAttribute("scheduleEnv");
        AbstractMessageServiceHandler handler = impl.getService(service);
        if (env == null) {
            if (job.getRetries() < 2) {
                this.dealAndCheckTodo(ctx, model, handler);
            } else {
                handler.checkTodo(ctx, model);
            }
        } else if (job.getRetries() > 3) {
            this.dealAndCheckTodo(ctx, model, handler);
        } else {
            handler.checkTodo(ctx, model);
        }
        return false;
    }

    private void processCompete(String service, MessageContext ctx, MessageServiceImpl impl) {
        impl.getService(service).completeProcessInstance(ctx, ctx.getProcessInstanceId());
    }

    private void processTerminate(String service, MessageContext ctx, MessageServiceImpl impl) {
        if (service.equalsIgnoreCase("yunzhijiaup")) {
            impl.getService(service).completeProcessInstance(ctx, ctx.getProcessInstanceId());
        } else {
            impl.getService(service).deleteProcessInstance(ctx, ctx.getProcessInstanceId());
        }
    }

    private void processStart(String service, MessageContext ctx, MessageServiceImpl impl) {
        impl.getService(service).startProcessInstance(ctx, ctx.getProcessInstanceId());
    }

    private void processRestart(String service, MessageContext ctx, MessageServiceImpl impl) {
    }

    private void checkSupportQuickaggre(String service, ToDoInfo todo, CommandContext commandContext) {
        TaskEntity task;
        Object quicklyAgree;
        MsgChannelInfo channelConfig = MessageChannelUtils.getChannelConfig((String)service);
        if ("cloudHub".equals(channelConfig.getMobileapp()) && StringUtils.isNotBlank((Object)(quicklyAgree = MessageServiceUtil.getConfigCenterProperty((String)"global", (String)"yzj.quicklyAgree.precalcnextparticipant"))) && Boolean.parseBoolean((String)quicklyAgree) && (task = (TaskEntity)commandContext.getTaskEntityManager().findById(todo.getTaskId())) != null && !task.isBizTask()) {
            Boolean hasNextUser = this.hasNextUser(task.getBusinessKey());
            todo.getParams().put("isquickagree", hasNextUser);
        }
    }

    private boolean hasNextUser(String businessKey) {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List nextUserTaskNode = wfService.getTaskService().getNextUserTaskNode(businessKey);
        if (nextUserTaskNode != null) {
            int len = nextUserTaskNode.size();
            for (int i = 0; i < len; ++i) {
                Map nextNode = (Map)nextUserTaskNode.get(i);
                if (nextNode.get("nextNode") instanceof UserTask && "SSCImageUploadNew".equals(((UserTask)nextNode.get("nextNode")).getType()) || nextNode.get("users") == null || !((List)nextNode.get("users")).isEmpty()) continue;
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private List<Long> needDeleteUserList(CommandContext commandContext, ToDoInfo model) {
        ArrayList<Long> deleteUserIds = new ArrayList<Long>();
        List todoUserIds = model.getUserIds();
        String todoType = model.getTodoType();
        if (model.getNotifyType().indexOf("yunzhijia") >= 0 && (todoType.equalsIgnoreCase(MessageTypeEnum.COORDINATE.getNumber()) || todoType.equalsIgnoreCase(MessageTypeEnum.TRANSFER.getNumber()))) {
            String[] types = new String[]{MessageTypeEnum.COORDINATE.getNumber(), MessageTypeEnum.TRANSFER.getNumber()};
            List taskHandleLogList = commandContext.getTaskHandleLogEntityManager().getTaskHandleLogs(model.getTaskId(), null, types);
            if (taskHandleLogList != null && taskHandleLogList.size() > 0) {
                for (TaskHandleLogEntity taskHandleLogEntity : taskHandleLogList) {
                    Long assigneeId = taskHandleLogEntity.getAssigneeid();
                    if (deleteUserIds.contains(assigneeId) || !todoUserIds.contains(assigneeId)) continue;
                    deleteUserIds.add(assigneeId);
                }
            }
        }
        return deleteUserIds;
    }

    private void dealAndCheckTodo(MessageContext ctx, ToDoInfo model, AbstractMessageServiceHandler handler) {
        handler.dealToDo(ctx, model);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            logger.error(WfUtils.getExceptionStacktrace(e));
            Thread.currentThread().interrupt();
        }
        handler.checkTodo(ctx, model);
    }

    private boolean checkUserToDo(MessageContext ctx, ToDoInfo info, String type) {
        boolean userTodoExist = false;
        try {
            List yzjToDoProperties = YunzhijiaToDoUtil.transformToDo((MessageContext)ctx, (ToDoInfo)info, (YzjToDoState)YzjToDoState.CHECK, (String)type);
            for (YzjToDoProperty yzjToDoProperty : yzjToDoProperties) {
                boolean check;
                JSONObject bodyData = YunzhijiaToDoUtil.buildYzjBodyData((ToDoInfo)info, (YzjToDoProperty)yzjToDoProperty, null, (YzjToDoState)YzjToDoState.CHECK, (String)type);
                JSONObject result = YunzhijiaCommonUtil.sendHttpRequest((YzjToDoProperty)yzjToDoProperty, (JSONObject)bodyData, (YzjToDoState)YzjToDoState.CHECK, (String)type);
                logger.info(String.format("\u4f7f\u7528\u7cfb\u7edf\u914d\u7f6e\u7684APPID Check\uff01SourceId: %s, userId: %s", yzjToDoProperty.getAppId(), yzjToDoProperty.getUserid()));
                JSONObject data = result.getJSONObject("data");
                if (data == null || !(check = data.getBoolean("check").booleanValue())) continue;
                int dealCount = data.getIntValue("dealCount");
                int undelCount = data.getIntValue("undelCount");
                if (dealCount == 0 && undelCount == 0) {
                    userTodoExist = false;
                    continue;
                }
                userTodoExist = true;
            }
        }
        catch (Exception e) {
            logger.error("check todo is fail and the msg is " + e.getMessage());
        }
        return userTodoExist;
    }

    private void checkCreateTaskExtis(JobEntity job, ToDoInfo.State state, String channle, Long taskId) {
        boolean extisCreateTaskJob;
        block5: {
            extisCreateTaskJob = false;
            try {
                ILocalJobHandleStrategy strategy;
                DynamicObjectCollection objects;
                if (!ToDoInfo.State.DEAL.equals((Object)state) && !ToDoInfo.State.DELETE.equals((Object)state) || (objects = (strategy = JobHandleStrategyFactory.getLocalJobHandleStrategy(job.getJobType())).findChannelTasksByJobExecuteJob(job)) == null || objects.size() <= 0) break block5;
                for (DynamicObject object : objects) {
                    String config = object.getString("jobhandlerconfiguration");
                    Map pay = this.restoreContext(config);
                    String channel = (String)pay.get(SERVICE_KEY);
                    String result = object.getString("state");
                    ToDoInfo objModel = (ToDoInfo)SerializationUtils.fromJsonString((String)((String)pay.get(MODEL)), ToDoInfo.class);
                    if (!ToDoInfo.State.NEW.equals((Object)objModel.getState()) || !taskId.equals(objModel.getTaskId()) || !channle.equals(channel)) continue;
                    if ("completed".equals(result)) {
                        extisCreateTaskJob = false;
                        break;
                    }
                    extisCreateTaskJob = true;
                }
            }
            catch (Exception e) {
                this.log.debug("get job is failed and message :" + WfUtils.getExceptionStacktrace(e));
            }
        }
        if (extisCreateTaskJob) {
            throw new KDBizException("The job that created the pending task has not been executed, and the current job has stopped executing and is waiting for a retry");
        }
    }
}

