/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.history;

import com.tongtech.backport.java.util.Arrays;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.history.serialization.CollectionBinder;
import kd.bos.workflow.engine.history.serialization.CollectionSerialize;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.clean.model.EntityCompactConfigFactory;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricCompactRelaEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcCompactEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcCompactEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcCompactEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityManager;

public class HistoricProcCompactEntityManagerImpl
extends AbstractEntityManager<HistoricProcCompactEntity>
implements HistoricProcCompactEntityManager {
    public HistoricProcCompactEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    @Deprecated
    public HistoricProcCompactEntity findByProcInstId(Long procInstId) {
        return null;
    }

    @Override
    @Deprecated
    public List<HistoricProcCompactEntity> findByProcInstIds(Set<Long> procInstIds) {
        return Collections.emptyList();
    }

    @Override
    public HistoricProcCompactEntity findByProcInstId(Long procInstId, String entityNumber) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", (Object)procInstId).setSelectFields(EntityCompactConfigFactory.getCompactPropertyName((String)entityNumber));
        List list = this.findByQueryBuilder(eb);
        if (WfUtils.isEmptyForCollection(list)) {
            return null;
        }
        return (HistoricProcCompactEntity)list.get(0);
    }

    @Override
    public List<HistoricProcCompactEntity> findByProcInstIds(Set<Long> procInstIds, String entityNumber) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", "in", procInstIds).setSelectFields(EntityCompactConfigFactory.getCompactPropertyName((String)entityNumber));
        return this.findByQueryBuilder(eb);
    }

    public Class<? extends HistoricProcCompactEntity> getManagedEntityClass() {
        return HistoricProcCompactEntityImpl.class;
    }

    public String getSelectFields() {
        return "id,processinstanceid,actinfo,operationlog,hiparticipant";
    }

    public String getEntityName() {
        return "wf_historicproccompact";
    }

    @Override
    public void deleteHistoricActInstWideEntityByProcInstId(Long procInstId) {
        this.deleteByFilters(new QFilter[]{new QFilter("processInstanceId", "=", (Object)procInstId)});
        this.getHistoricCompactRelaEntityManager().deleteByProcInstId(procInstId);
    }

    @Override
    public List<HistoricActivityInstanceEntity> getEntitysFromWideByProcInstIdsAndActType(Set<Long> processInstanceIds, String activityType, Set<String> fields) {
        ArrayList<HistoricActivityInstanceEntity> result = new ArrayList<HistoricActivityInstanceEntity>(10);
        Predicate<DynamicObject> predicate = dyn -> activityType.equals(dyn.getString("activityType"));
        List<DynamicObject> dyns = this.reverseAndFilterByProcInstIds(EntityNumberConstant.getHiActInstEntityNumber(), predicate, processInstanceIds);
        if (WfUtils.isEmptyForCollection(dyns)) {
            return result;
        }
        HistoricActivityInstanceEntityManager actManager = this.getHistoricActivityInstanceEntityManager();
        for (DynamicObject dyn2 : dyns) {
            HistoricActivityInstanceEntity entity;
            if (WfUtils.isEmptyForCollection(fields)) {
                entity = (HistoricActivityInstanceEntity)actManager.create(dyn2);
                result.add(entity);
                continue;
            }
            entity = (HistoricActivityInstanceEntity)actManager.create();
            for (String queryField : fields) {
                entity.getDynamicObject().set(queryField.trim(), dyn2.get(queryField.trim()));
            }
            result.add(entity);
        }
        return result;
    }

    @Override
    public List<HistoricActivityInstanceEntity> getEntitysFromWideByBusinessKeysAndActType(Set<String> businessKeys, String actType, Set<String> fields) {
        ArrayList<HistoricActivityInstanceEntity> result = new ArrayList<HistoricActivityInstanceEntity>(10);
        Predicate<DynamicObject> predicate = dyn -> actType.equals(dyn.getString("activityType")) && businessKeys.contains(dyn.getString("businessKey"));
        List<DynamicObject> dyns = this.reverseAndFilterByBusinessKeys(EntityNumberConstant.getHiActInstEntityNumber(), predicate, businessKeys);
        if (WfUtils.isEmptyForCollection(dyns)) {
            return result;
        }
        HistoricActivityInstanceEntityManager actManager = this.getHistoricActivityInstanceEntityManager();
        for (DynamicObject dyn2 : dyns) {
            HistoricActivityInstanceEntity entity;
            if (WfUtils.isEmptyForCollection(fields)) {
                entity = (HistoricActivityInstanceEntity)actManager.create(dyn2);
                result.add(entity);
                continue;
            }
            entity = (HistoricActivityInstanceEntity)actManager.create();
            for (String queryField : fields) {
                entity.getDynamicObject().set(queryField.trim(), dyn2.get(queryField.trim()));
            }
            result.add(entity);
        }
        return result;
    }

    @Override
    public List<HistoricActivityInstanceEntity> getEntitysFromWide(Long procInstId, String orderByStr) {
        ArrayList<HistoricActivityInstanceEntity> result = new ArrayList<HistoricActivityInstanceEntity>(10);
        HistoricActivityInstanceEntityManager actManager = this.getHistoricActivityInstanceEntityManager();
        List<DynamicObject> hiActDynObjects = this.getDynamicObjectsFromWide(EntityNumberConstant.getHiActInstEntityNumber(), null, procInstId);
        this.sortDynObjects(hiActDynObjects, orderByStr, EntityNumberConstant.getHiActInstEntityNumber());
        for (DynamicObject dyObject : hiActDynObjects) {
            HistoricActivityInstanceEntity hiActEntity = (HistoricActivityInstanceEntity)actManager.create(dyObject);
            result.add(hiActEntity);
        }
        return result;
    }

    private List<DynamicObject> getDynamicObjectsFromWide(String entityNumber, Predicate<DynamicObject> predicate, Long procInstId) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        HistoricProcCompactEntity entity = this.findByProcInstId(procInstId, entityNumber);
        if (entity == null) {
            return result;
        }
        String actEntityJson = entity.getDynamicObject().getString(EntityCompactConfigFactory.getCompactPropertyName((String)entityNumber));
        if (WfUtils.isEmpty(actEntityJson)) {
            return result;
        }
        this.filterDynamicObject(actEntityJson, predicate, result);
        return result;
    }

    @Override
    public HistoricActivityInstanceEntity getEntitysFromWideByTaskId(Long taskId) {
        DynamicObject hiTaskInst = QueryServiceHelper.queryOne((String)EntityNumberConstant.getHiTaskInstEntityNumber(), (String)"processInstanceId", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        if (hiTaskInst != null) {
            Long procInstId = hiTaskInst.getLong("processInstanceId");
            List<HistoricActivityInstanceEntity> hiActList = this.getEntitysFromWide(procInstId, null);
            for (HistoricActivityInstanceEntity hiAct : hiActList) {
                if (!taskId.equals(hiAct.getTaskId())) continue;
                return hiAct;
            }
        }
        return null;
    }

    @Override
    public HistoricActivityInstanceEntity getEntitysFromWideActivityInstId(Long processInstanceId, Long activityInstId) {
        List<HistoricActivityInstanceEntity> hiActList = this.getEntitysFromWide(processInstanceId, null);
        for (HistoricActivityInstanceEntity hiAct : hiActList) {
            if (!activityInstId.equals(hiAct.getId())) continue;
            return hiAct;
        }
        return null;
    }

    @Override
    public List<HistoricActivityInstanceEntity> getEntitysFromWideByActivityId(Long processInstanceId, String activityId, String orderBy) {
        ArrayList<HistoricActivityInstanceEntity> result = new ArrayList<HistoricActivityInstanceEntity>();
        List<HistoricActivityInstanceEntity> allEntitys = this.getEntitysFromWide(processInstanceId, orderBy);
        for (HistoricActivityInstanceEntity entity : allEntitys) {
            if (!entity.getActivityId().equals(activityId)) continue;
            result.add(entity);
        }
        return result;
    }

    @Override
    public HistoricActivityInstanceEntity getActFromWideByBusinessKeyAndId(String businessKey, Long activityInstId) {
        if (WfUtils.isEmpty(businessKey) || WfUtils.isEmpty(activityInstId)) {
            return null;
        }
        HashSet<String> businessKeys = new HashSet<String>(1);
        businessKeys.add(businessKey);
        Predicate<DynamicObject> predicate = dyn -> activityInstId.equals(dyn.getLong("id"));
        List<DynamicObject> dyns = this.reverseAndFilterByBusinessKeys(EntityNumberConstant.getHiActInstEntityNumber(), predicate, businessKeys);
        if (WfUtils.isEmptyForCollection(dyns)) {
            return null;
        }
        return (HistoricActivityInstanceEntity)this.getHistoricActivityInstanceEntityManager().create(dyns.get(0));
    }

    private List<String> getZipFeildTextByEntityNumberAndBusinessKey(String compactEntityNumber, Set<String> businessKeys) {
        ArrayList<String> feildTexts = new ArrayList<String>(businessKeys.size());
        String feildName = EntityCompactConfigFactory.getCompactPropertyName((String)compactEntityNumber);
        if (WfUtils.isEmpty(feildName)) {
            return feildTexts;
        }
        List relaEntitys = this.getHistoricCompactRelaEntityManager().findByQueryFilters(new QFilter[]{new QFilter("businessKey", "in", businessKeys)});
        if (WfUtils.isEmptyForCollection(relaEntitys)) {
            return feildTexts;
        }
        HashSet<Long> procInstIds = new HashSet<Long>(16);
        for (HistoricCompactRelaEntity relaEntity : relaEntitys) {
            procInstIds.add(relaEntity.getProcessInstanceId());
        }
        List wideEntitys = this.findByQueryFilters(new QFilter[]{new QFilter("processInstanceId", "in", procInstIds)}, feildName, null);
        if (WfUtils.isEmptyForCollection(wideEntitys)) {
            return feildTexts;
        }
        for (HistoricProcCompactEntity wideEntity : wideEntitys) {
            String feildJson = wideEntity.getDynamicObject().getString(feildName);
            if (!WfUtils.isNotEmpty(feildJson)) continue;
            feildTexts.add(feildJson);
        }
        return feildTexts;
    }

    private void sortDynObjects(List<DynamicObject> dynObjects, String orderByStr, String entityNumber) {
        if (WfUtils.isEmpty(orderByStr) || WfUtils.isEmpty(entityNumber) || WfUtils.isEmptyForCollection(dynObjects)) {
            return;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (WfUtils.isNotEmpty(orderByStr = orderByStr.trim().toLowerCase(Locale.ENGLISH))) {
            String[] orderBys = orderByStr.split(",");
            dynObjects.sort((dyn1, dyn2) -> this.getOrderResult((DynamicObject)dyn1, (DynamicObject)dyn2, orderBys, entityType));
        }
    }

    private int getOrderResult(DynamicObject dyn1, DynamicObject dyn2, String[] orderBys, MainEntityType entityType) {
        int result = 0;
        for (String orderBy : orderBys) {
            orderBy = orderBy.trim();
            String field = "";
            boolean reverseOrder = false;
            if (orderBy.endsWith("desc")) {
                reverseOrder = true;
                field = orderBy.substring(0, orderBy.indexOf("desc")).trim();
            } else {
                field = orderBy.endsWith("asc") ? orderBy.substring(0, orderBy.indexOf("asc")).trim() : orderBy;
            }
            DynamicProperty property = entityType.getProperty(field.trim());
            if (dyn1.get((IDataEntityProperty)property) == null && dyn2.get((IDataEntityProperty)property) == null) continue;
            if (dyn1.get((IDataEntityProperty)property) == null || WfUtils.isEmpty(dyn1.get((IDataEntityProperty)property).toString())) {
                return 1;
            }
            if (dyn2.get((IDataEntityProperty)property) == null || WfUtils.isEmpty(dyn2.get((IDataEntityProperty)property).toString())) {
                return -1;
            }
            result = property instanceof IntegerProp ? dyn1.getInt((IDataEntityProperty)property) - dyn2.getInt((IDataEntityProperty)property) : (property instanceof LongProp ? (dyn1.getLong((IDataEntityProperty)property) == dyn2.getLong((IDataEntityProperty)property) ? 0 : (dyn1.getLong((IDataEntityProperty)property) < dyn2.getLong((IDataEntityProperty)property) ? -1 : 1)) : (property instanceof DateTimeProp || property instanceof DateProp ? (dyn1.getDate((IDataEntityProperty)property).equals(dyn2.getDate((IDataEntityProperty)property)) ? 0 : (dyn1.getDate((IDataEntityProperty)property).after(dyn2.getDate((IDataEntityProperty)property)) ? 1 : -1)) : (property instanceof MuliLangTextProp ? dyn1.getLocaleString((IDataEntityProperty)property).toString().hashCode() - dyn2.getLocaleString((IDataEntityProperty)property).toString().hashCode() : dyn1.get((IDataEntityProperty)property).hashCode() - dyn2.get((IDataEntityProperty)property).hashCode())));
            if (result == 0) continue;
            if (!reverseOrder) break;
            result = -result;
            break;
        }
        return result;
    }

    @Override
    public List<OperationLogEntity> getOperationLogsByTaskIdAndType(Long taskId, String type, String orderBy) {
        ArrayList<OperationLogEntity> result = new ArrayList<OperationLogEntity>();
        Long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject hiTaskInst = QueryServiceHelper.queryOne((String)EntityNumberConstant.getHiTaskInstEntityNumber(), (String)"processInstanceId", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        if (hiTaskInst != null) {
            Predicate<DynamicObject> predicate = dyn -> taskId.equals(dyn.getLong("taskid")) && (WfUtils.isEmpty(dyn.getLong("ownerid")) || currUserId.equals(dyn.getLong("ownerid"))) && type.equals(dyn.getString("type"));
            Long procInstId = hiTaskInst.getLong("processInstanceId");
            List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide("wf_operationlog", predicate, procInstId);
            if (WfUtils.isEmptyForCollection(dynObjects)) {
                return result;
            }
            OperationLogEntityManager operationLogManager = this.getOperationLogEntityManager();
            for (DynamicObject dyObject : dynObjects) {
                OperationLogEntity operationLogEntity = (OperationLogEntity)operationLogManager.create(dyObject);
                result.add(operationLogEntity);
            }
        }
        return result;
    }

    @Override
    public List<OperationLogEntity> getOperationLogsFromWide(Long procInstId, String orderByStr) {
        ArrayList<OperationLogEntity> result = new ArrayList<OperationLogEntity>(10);
        OperationLogEntityManager operationLogManager = this.getOperationLogEntityManager();
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide("wf_operationlog", null, procInstId);
        this.sortDynObjects(dynObjects, orderByStr, "wf_operationlog");
        for (DynamicObject dyObject : dynObjects) {
            OperationLogEntity operationLogEntity = (OperationLogEntity)operationLogManager.create(dyObject);
            result.add(operationLogEntity);
        }
        return result;
    }

    @Override
    public List<DynamicObject> getOperationLogList(Long procInstId, List<QFilter> qFilters, String orderBy) {
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide("wf_operationlog", null, procInstId);
        ArrayList<DynamicObject> filterDynObjects = new ArrayList<DynamicObject>(dynObjects.size());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"wf_operationlog");
        for (DynamicObject dynamicObject : dynObjects) {
            if (!this.filterOperationLogDyn(dynamicObject, qFilters, entityType)) continue;
            filterDynObjects.add(dynamicObject);
        }
        this.sortDynObjects(filterDynObjects, orderBy, "wf_operationlog");
        return filterDynObjects;
    }

    private boolean filterOperationLogDyn(DynamicObject dynamicObject, List<QFilter> qFilters, MainEntityType entityType) {
        boolean result = true;
        if (WfUtils.isEmptyForCollection(qFilters)) {
            return result;
        }
        for (QFilter filter : qFilters) {
            String propertyName = filter.getProperty();
            if (propertyName.equals("opinion")) {
                propertyName = "nopinion";
            }
            String cp = filter.getCP().trim();
            Object value = filter.getValue();
            DynamicProperty property = entityType.getProperty(propertyName);
            if (cp.equals(">")) {
                result = this.getResultLargeThan(property, value, dynamicObject);
            } else if (cp.equals(">=")) {
                result = this.getResultLargeEquals(property, value, dynamicObject);
            } else if (cp.equals("<")) {
                result = this.getResultLessThan(property, value, dynamicObject);
            } else if (cp.equals("<=")) {
                result = this.getResultLessEquals(property, value, dynamicObject);
            } else if (cp.equals("=")) {
                result = this.getResultEquals(property, value, dynamicObject);
            } else if (cp.equals("!=")) {
                result = !this.getResultEquals(property, value, dynamicObject);
            } else if (cp.equals("<>")) {
                result = !this.getResultEquals(property, value, dynamicObject);
            } else if (cp.equals("is null")) {
                result = this.getResultIsNull(property, dynamicObject);
            } else if (cp.equals("is not null")) {
                result = !this.getResultIsNull(property, dynamicObject);
            } else if (cp.equals("in")) {
                result = this.getResultIn(property, value, dynamicObject);
            } else if (cp.equals("not in")) {
                result = !this.getResultIn(property, value, dynamicObject);
            } else if (cp.equals("like")) {
                result = this.getResultLike(property, value, dynamicObject);
            } else if (cp.equals("not like")) {
                boolean bl = result = !this.getResultLike(property, value, dynamicObject);
            }
            if (result) continue;
            return result;
        }
        return result;
    }

    private boolean getResultIn(DynamicProperty property, Object param, DynamicObject dynamicObject) {
        if (param == null || dynamicObject.get((IDataEntityProperty)property) == null) {
            return false;
        }
        List list = (List)param;
        if (WfUtils.isEmptyForCollection(list)) {
            return false;
        }
        Object value = dynamicObject.get((IDataEntityProperty)property);
        for (Object object : list) {
            if (object == null || !object.toString().equals(value.toString())) continue;
            return true;
        }
        return false;
    }

    private boolean getResultIsNull(DynamicProperty property, DynamicObject dynamicObject) {
        if (property instanceof IntegerProp) {
            return dynamicObject.getInt((IDataEntityProperty)property) == 0;
        }
        if (property instanceof LongProp) {
            return WfUtils.isEmpty(dynamicObject.getLong((IDataEntityProperty)property));
        }
        if (property instanceof DateTimeProp || property instanceof DateProp) {
            return dynamicObject.getDate((IDataEntityProperty)property) == null;
        }
        return dynamicObject.get((IDataEntityProperty)property) == null || WfUtils.isEmpty(dynamicObject.get((IDataEntityProperty)property).toString());
    }

    private boolean getResultEquals(DynamicProperty property, Object value, DynamicObject dynamicObject) {
        if (dynamicObject.get((IDataEntityProperty)property) == null) {
            return false;
        }
        if (property instanceof IntegerProp) {
            return ((Integer)value).equals(dynamicObject.getInt((IDataEntityProperty)property));
        }
        if (property instanceof LongProp) {
            return ((Long)value).equals(dynamicObject.getLong((IDataEntityProperty)property));
        }
        if (property instanceof DateTimeProp || property instanceof DateProp) {
            return ((Date)value).equals(dynamicObject.getDate((IDataEntityProperty)property));
        }
        return ((String)value).equals(dynamicObject.get((IDataEntityProperty)property).toString());
    }

    private boolean getResultLike(DynamicProperty property, Object param, DynamicObject dynamicObject) {
        if (dynamicObject.get((IDataEntityProperty)property) == null || param == null) {
            return false;
        }
        String value = dynamicObject.get((IDataEntityProperty)property).toString();
        String likeParam = (String)param;
        if (likeParam.contains("%")) {
            if (likeParam.length() == 1) {
                return true;
            }
            int startIndex = likeParam.indexOf(37);
            int lastIndex = likeParam.lastIndexOf(37);
            if (likeParam.length() == 2 && startIndex < lastIndex) {
                return true;
            }
            if (startIndex == 0 && lastIndex == likeParam.length() - 1) {
                return value.contains(likeParam.substring(1, lastIndex));
            }
            if (likeParam.length() > 1 && startIndex == 0) {
                return value.endsWith(likeParam.substring(1));
            }
            if (likeParam.length() > 1 && lastIndex == likeParam.length() - 1) {
                return value.startsWith(likeParam.substring(0, lastIndex));
            }
        } else {
            return value.equals(likeParam);
        }
        return false;
    }

    private boolean getResultLargeThan(DynamicProperty property, Object value, DynamicObject dynamicObject) {
        if (dynamicObject.get((IDataEntityProperty)property) == null) {
            return false;
        }
        if (property instanceof IntegerProp) {
            return dynamicObject.getInt((IDataEntityProperty)property) > (Integer)value;
        }
        if (property instanceof LongProp) {
            return dynamicObject.getLong((IDataEntityProperty)property) > (Long)value;
        }
        if (property instanceof DateTimeProp || property instanceof DateProp) {
            return dynamicObject.getDate((IDataEntityProperty)property).after((Date)value);
        }
        return false;
    }

    private boolean getResultLessThan(DynamicProperty property, Object value, DynamicObject dynamicObject) {
        if (dynamicObject.get((IDataEntityProperty)property) == null) {
            return false;
        }
        if (property instanceof IntegerProp) {
            return dynamicObject.getInt((IDataEntityProperty)property) < (Integer)value;
        }
        if (property instanceof LongProp) {
            return dynamicObject.getLong((IDataEntityProperty)property) < (Long)value;
        }
        if (property instanceof DateTimeProp || property instanceof DateProp) {
            return dynamicObject.getDate((IDataEntityProperty)property).before((Date)value);
        }
        return false;
    }

    private boolean getResultLargeEquals(DynamicProperty property, Object value, DynamicObject dynamicObject) {
        if (dynamicObject.get((IDataEntityProperty)property) == null) {
            return false;
        }
        if (property instanceof IntegerProp) {
            return dynamicObject.getInt((IDataEntityProperty)property) >= (Integer)value;
        }
        if (property instanceof LongProp) {
            return dynamicObject.getLong((IDataEntityProperty)property) >= (Long)value;
        }
        if (property instanceof DateTimeProp || property instanceof DateProp) {
            return dynamicObject.getDate((IDataEntityProperty)property).compareTo((Date)value) >= 0;
        }
        return false;
    }

    private boolean getResultLessEquals(DynamicProperty property, Object value, DynamicObject dynamicObject) {
        if (dynamicObject.get((IDataEntityProperty)property) == null) {
            return false;
        }
        if (property instanceof IntegerProp) {
            return dynamicObject.getInt((IDataEntityProperty)property) <= (Integer)value;
        }
        if (property instanceof LongProp) {
            return dynamicObject.getLong((IDataEntityProperty)property) <= (Long)value;
        }
        if (property instanceof DateTimeProp || property instanceof DateProp) {
            return dynamicObject.getDate((IDataEntityProperty)property).compareTo((Date)value) <= 0;
        }
        return false;
    }

    @Override
    public List<OperationLogEntity> findOperationLogByBusinessKeyAndType(String businessKey, Long userId, String type) {
        ArrayList<OperationLogEntity> result = new ArrayList<OperationLogEntity>(10);
        OperationLogEntityManager operationLogManager = this.getOperationLogEntityManager();
        HashSet<String> businessKeys = new HashSet<String>(1);
        businessKeys.add(businessKey);
        Predicate<DynamicObject> predicate = dyObject -> businessKey.equals(dyObject.getString("businesskey")) && userId.equals(dyObject.getLong("ownerid")) && type.equals(dyObject.getString("type"));
        List<DynamicObject> hiActDynObjects = this.reverseAndFilterByBusinessKeys("wf_operationlog", predicate, businessKeys);
        for (DynamicObject dyn : hiActDynObjects) {
            OperationLogEntity hiActEntity = (OperationLogEntity)operationLogManager.create(dyn);
            result.add(hiActEntity);
        }
        return result;
    }

    @Override
    public List<OperationLogEntity> getOperationLogsFromWideByType(Long procInstId, String type, String orderBy) {
        ArrayList<OperationLogEntity> result = new ArrayList<OperationLogEntity>(10);
        if (WfUtils.isEmpty(procInstId) || WfUtils.isEmpty(type)) {
            return result;
        }
        OperationLogEntityManager operationLogManager = this.getOperationLogEntityManager();
        Predicate<DynamicObject> predicate = dyn -> type.equals(dyn.getString("type"));
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide("wf_operationlog", predicate, procInstId);
        this.sortDynObjects(dynObjects, orderBy, "wf_operationlog");
        for (DynamicObject dyObject : dynObjects) {
            OperationLogEntity operationLogEntity = (OperationLogEntity)operationLogManager.create(dyObject);
            result.add(operationLogEntity);
        }
        return result;
    }

    @Override
    public List<OperationLogEntity> findOperationLogByBusinessKey(String businessKey) {
        ArrayList<OperationLogEntity> result = new ArrayList<OperationLogEntity>(10);
        OperationLogEntityManager operationLogManager = this.getOperationLogEntityManager();
        HashSet<String> businessKeys = new HashSet<String>(1);
        businessKeys.add(businessKey);
        Predicate<DynamicObject> predicate = dyObject -> businessKey.equals(dyObject.getString("businesskey"));
        List<DynamicObject> dyns = this.reverseAndFilterByBusinessKeys("wf_operationlog", predicate, businessKeys);
        for (DynamicObject dyn : dyns) {
            OperationLogEntity hiActEntity = (OperationLogEntity)operationLogManager.create(dyn);
            result.add(hiActEntity);
        }
        return result;
    }

    @Override
    public List<OperationLogEntity> findOperationLogByTaskId(Long procInstId, Long taskId, String orderBy) {
        DynamicObject hiTaskInst;
        if (WfUtils.isEmpty(procInstId) && (hiTaskInst = QueryServiceHelper.queryOne((String)EntityNumberConstant.getHiTaskInstEntityNumber(), (String)"processInstanceId", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)})) != null) {
            procInstId = hiTaskInst.getLong("processInstanceId");
        }
        ArrayList<OperationLogEntity> result = new ArrayList<OperationLogEntity>(10);
        OperationLogEntityManager operationLogManager = this.getOperationLogEntityManager();
        Predicate<DynamicObject> predicate = dyn -> taskId.equals(dyn.getLong("taskid"));
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide("wf_operationlog", predicate, procInstId);
        this.sortDynObjects(dynObjects, orderBy, "wf_operationlog");
        for (DynamicObject dyObject : dynObjects) {
            OperationLogEntity operationLogEntity = (OperationLogEntity)operationLogManager.create(dyObject);
            result.add(operationLogEntity);
        }
        return result;
    }

    @Override
    public List<OperationLogEntity> findOperationLogByOwnIdOrAssigneeId(Long procInstId, Long ownId, String assigneeId) {
        ArrayList<OperationLogEntity> result = new ArrayList<OperationLogEntity>(10);
        OperationLogEntityManager operationLogManager = this.getOperationLogEntityManager();
        Predicate<DynamicObject> predicate = dyn -> {
            String assigneeIdStr = dyn.getString("assigneeid");
            boolean assigneeMark = false;
            boolean ownIdMark = false;
            if (null != ownId) {
                ownIdMark = ownId.equals(dyn.getLong("ownerid"));
            }
            if (StringUtils.isNotBlank((CharSequence)assigneeId) && StringUtils.isNotBlank((CharSequence)assigneeIdStr)) {
                Object[] assigneeIdArr = assigneeIdStr.split(",");
                List assigneeIdList = Arrays.asList((Object[])assigneeIdArr);
                assigneeMark = assigneeIdList.contains(assigneeId);
            }
            return assigneeMark || ownIdMark;
        };
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide("wf_operationlog", predicate, procInstId);
        for (DynamicObject dyObject : dynObjects) {
            OperationLogEntity operationLogEntity = (OperationLogEntity)operationLogManager.create(dyObject);
            result.add(operationLogEntity);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinkByTaskIdAndUserId(Long taskId, Long userId, String type) {
        ArrayList<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(taskId) || WfUtils.isEmpty(userId)) {
            return result;
        }
        Long procInstId = null;
        DynamicObject hiTaskInst = QueryServiceHelper.queryOne((String)EntityNumberConstant.getHiTaskInstEntityNumber(), (String)"processInstanceId", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        if (hiTaskInst != null) {
            procInstId = hiTaskInst.getLong("processInstanceId");
        }
        if (WfUtils.isEmpty(procInstId)) {
            return result;
        }
        HistoricIdentityLinkEntityManager manager = this.getHistoricIdentityLinkEntityManager();
        Predicate<DynamicObject> predicate = dyObject -> taskId.equals(dyObject.getLong("taskId")) && userId.equals(dyObject.getLong("userId")) && (WfUtils.isEmpty(type) || type.equals(dyObject.getString("type")));
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide(EntityNumberConstant.getHiIdentityLinkEntityNumber(), predicate, procInstId);
        for (DynamicObject dyObject2 : dynObjects) {
            HistoricIdentityLinkEntity entity = (HistoricIdentityLinkEntity)manager.create(dyObject2);
            result.add(entity);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findHistoricIdentityLinkByProcInstIds(Set<Long> procInstIds) {
        ArrayList<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        HistoricIdentityLinkEntityManager manager = this.getHistoricIdentityLinkEntityManager();
        List<DynamicObject> dyns = this.reverseAndFilterByProcInstIds(EntityNumberConstant.getHiIdentityLinkEntityNumber(), null, procInstIds);
        if (WfUtils.isEmptyForCollection(dyns)) {
            return result;
        }
        for (DynamicObject dyn : dyns) {
            HistoricIdentityLinkEntity parEntity = (HistoricIdentityLinkEntity)manager.create(dyn);
            result.add(parEntity);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findByProcInstIdAndTypeAndTrustNameNotNull(Long processInstanceId, String type) {
        ArrayList<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(processInstanceId) || WfUtils.isEmpty(type)) {
            return result;
        }
        HistoricIdentityLinkEntityManager manager = this.getHistoricIdentityLinkEntityManager();
        Predicate<DynamicObject> predicate = dyObject -> type.equals(dyObject.getString("type")) && WfUtils.isNotEmpty(dyObject.getLocaleString("trustname"));
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide(EntityNumberConstant.getHiIdentityLinkEntityNumber(), predicate, processInstanceId);
        for (DynamicObject dyObject2 : dynObjects) {
            HistoricIdentityLinkEntity entity = (HistoricIdentityLinkEntity)manager.create(dyObject2);
            result.add(entity);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findByProcInstIdAndType(Long processInstanceId, String type) {
        ArrayList<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(processInstanceId) || WfUtils.isEmpty(type)) {
            return result;
        }
        HistoricIdentityLinkEntityManager manager = this.getHistoricIdentityLinkEntityManager();
        Predicate<DynamicObject> predicate = dyObject -> type.equals(dyObject.getString("type"));
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide(EntityNumberConstant.getHiIdentityLinkEntityNumber(), predicate, processInstanceId);
        for (DynamicObject dyObject2 : dynObjects) {
            HistoricIdentityLinkEntity entity = (HistoricIdentityLinkEntity)manager.create(dyObject2);
            result.add(entity);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findParticipantsByTaskIdAndType(Long taskId, String type) {
        ArrayList<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(taskId) || WfUtils.isEmpty(type)) {
            return result;
        }
        Long procInstId = null;
        DynamicObject hiTaskInst = QueryServiceHelper.queryOne((String)EntityNumberConstant.getHiTaskInstEntityNumber(), (String)"processInstanceId", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        if (hiTaskInst != null) {
            procInstId = hiTaskInst.getLong("processInstanceId");
        }
        if (WfUtils.isEmpty(procInstId)) {
            return result;
        }
        HistoricIdentityLinkEntityManager manager = this.getHistoricIdentityLinkEntityManager();
        Predicate<DynamicObject> predicate = dyObject -> taskId.equals(dyObject.getLong("taskId")) && type.equals(dyObject.getString("type"));
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide(EntityNumberConstant.getHiIdentityLinkEntityNumber(), predicate, procInstId);
        for (DynamicObject dyObject2 : dynObjects) {
            HistoricIdentityLinkEntity entity = (HistoricIdentityLinkEntity)manager.create(dyObject2);
            result.add(entity);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findParticipantsByTaskId(Long taskId, String orderBy) {
        ArrayList<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(taskId)) {
            return result;
        }
        Long procInstId = null;
        DynamicObject hiTaskInst = QueryServiceHelper.queryOne((String)EntityNumberConstant.getHiTaskInstEntityNumber(), (String)"processInstanceId", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taskId)});
        if (hiTaskInst != null) {
            procInstId = hiTaskInst.getLong("processInstanceId");
        }
        if (WfUtils.isEmpty(procInstId)) {
            return result;
        }
        HistoricIdentityLinkEntityManager manager = this.getHistoricIdentityLinkEntityManager();
        Predicate<DynamicObject> predicate = dyObject -> taskId.equals(dyObject.getLong("taskId"));
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide(EntityNumberConstant.getHiIdentityLinkEntityNumber(), predicate, procInstId);
        this.sortDynObjects(dynObjects, orderBy, EntityNumberConstant.getHiIdentityLinkEntityNumber());
        for (DynamicObject dyObject2 : dynObjects) {
            HistoricIdentityLinkEntity entity = (HistoricIdentityLinkEntity)manager.create(dyObject2);
            result.add(entity);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findParticipantsByParentTaskId(Long parentTaskId, Long userId) {
        ArrayList<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(parentTaskId) || WfUtils.isEmpty(userId)) {
            return result;
        }
        Long procInstId = null;
        DynamicObject hiTaskInst = QueryServiceHelper.queryOne((String)EntityNumberConstant.getHiTaskInstEntityNumber(), (String)"processInstanceId", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)parentTaskId)});
        if (hiTaskInst != null) {
            procInstId = hiTaskInst.getLong("processInstanceId");
        }
        if (WfUtils.isEmpty(procInstId)) {
            return result;
        }
        HistoricIdentityLinkEntityManager manager = this.getHistoricIdentityLinkEntityManager();
        Predicate<DynamicObject> predicate = dyObject -> parentTaskId.equals(dyObject.getLong("parentTaskId")) && userId.equals(dyObject.getLong("userId"));
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide(EntityNumberConstant.getHiIdentityLinkEntityNumber(), predicate, procInstId);
        for (DynamicObject dyObject2 : dynObjects) {
            HistoricIdentityLinkEntity entity = (HistoricIdentityLinkEntity)manager.create(dyObject2);
            result.add(entity);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findParticipantsByTaskIds(Long procInstId, List<Long> taskIds) {
        ArrayList<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(procInstId) || WfUtils.isEmptyForCollection(taskIds)) {
            return result;
        }
        HistoricIdentityLinkEntityManager manager = this.getHistoricIdentityLinkEntityManager();
        Predicate<DynamicObject> predicate = dyObject -> taskIds.contains(dyObject.getLong("taskId"));
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide(EntityNumberConstant.getHiIdentityLinkEntityNumber(), predicate, procInstId);
        for (DynamicObject dyObject2 : dynObjects) {
            HistoricIdentityLinkEntity entity = (HistoricIdentityLinkEntity)manager.create(dyObject2);
            result.add(entity);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findNotDelegateParticipantsByTaskIdsAndType(Long procInstId, Set<Long> taskIds, String type) {
        ArrayList<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(procInstId) || WfUtils.isEmptyForCollection(taskIds) || WfUtils.isEmpty(type)) {
            return result;
        }
        HistoricIdentityLinkEntityManager manager = this.getHistoricIdentityLinkEntityManager();
        Predicate<DynamicObject> predicate = dyObject -> taskIds.contains(dyObject.getLong("taskId")) && type.equals(dyObject.getString("type")) && WfUtils.isEmpty(dyObject.getLong("delegateid"));
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide(EntityNumberConstant.getHiIdentityLinkEntityNumber(), predicate, procInstId);
        for (DynamicObject dyObject2 : dynObjects) {
            HistoricIdentityLinkEntity entity = (HistoricIdentityLinkEntity)manager.create(dyObject2);
            result.add(entity);
        }
        return result;
    }

    @Override
    public List<HistoricIdentityLinkEntity> findParticipantsByTaskIdAndOwnerId(Long procInstId, Long taskId, Long ownerId, String type) {
        ArrayList<HistoricIdentityLinkEntity> result = new ArrayList<HistoricIdentityLinkEntity>(10);
        if (WfUtils.isEmpty(procInstId) || WfUtils.isEmpty(taskId)) {
            return result;
        }
        HistoricIdentityLinkEntityManager manager = this.getHistoricIdentityLinkEntityManager();
        Predicate<DynamicObject> predicate = null;
        predicate = WfUtils.isNotEmpty(type) ? dyObject -> taskId.equals(dyObject.getLong("taskId")) && type.equals(dyObject.getString("type")) && ownerId.equals(dyObject.getLong("ownerId")) : dyObject -> taskId.equals(dyObject.getLong("taskId")) && ownerId.equals(dyObject.getLong("ownerId"));
        List<DynamicObject> dynObjects = this.getDynamicObjectsFromWide(EntityNumberConstant.getHiIdentityLinkEntityNumber(), predicate, procInstId);
        for (DynamicObject dyObject2 : dynObjects) {
            HistoricIdentityLinkEntity entity = (HistoricIdentityLinkEntity)manager.create(dyObject2);
            result.add(entity);
        }
        return result;
    }

    private List<DynamicObject> reverseAndFilterByBusinessKeys(String entityNumber, Predicate<DynamicObject> predicate, Set<String> businessKeys) {
        List<String> actInfos = this.getZipFeildTextByEntityNumberAndBusinessKey(entityNumber, businessKeys);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        for (String actInfoJson : actInfos) {
            this.filterDynamicObject(actInfoJson, predicate, result);
        }
        return result;
    }

    private void filterDynamicObject(String actInfoJson, Predicate<DynamicObject> predicate, List<DynamicObject> result) {
        if (WfUtils.isEmpty(actInfoJson)) {
            return;
        }
        CollectionBinder binder = new CollectionBinder();
        CollectionSerialize collectionSerialize = (CollectionSerialize)binder.getDcJsonSerializer().deserializeFromString(actInfoJson, null);
        List dynObjects = collectionSerialize.getDynamicObjects();
        if (WfUtils.isNotEmptyForCollection(dynObjects)) {
            if (predicate != null) {
                result.addAll(dynObjects.stream().filter(predicate).collect(Collectors.toList()));
            } else {
                result.addAll(dynObjects);
            }
        }
    }

    private List<DynamicObject> reverseAndFilterByProcInstIds(String entityNumber, Predicate<DynamicObject> predicate, Set<Long> procInstIds) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        List<HistoricProcCompactEntity> entitys = this.findByProcInstIds(procInstIds, entityNumber);
        for (HistoricProcCompactEntity entity : entitys) {
            String actEntityJson = entity.getDynamicObject().getString(EntityCompactConfigFactory.getCompactPropertyName((String)entityNumber));
            if (WfUtils.isEmpty(actEntityJson)) continue;
            this.filterDynamicObject(actEntityJson, predicate, result);
        }
        return result;
    }
}

