/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.management;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.model.ProcessDefinitionStartInfo;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.LatestProcDefByDeploymentIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.LatestProcDefByModelIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.ProcDefByModelIdAndVersionMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.repository.ProcessDefinition;

public class ProcessDefinitionEntityManagerImpl
extends AbstractEntityManager<ProcessDefinitionEntity>
implements ProcessDefinitionEntityManager {
    private static final String NUMBER = "number";
    private static final String VALUE = "value";
    private static final String PROCDEFID = "procdefid";
    private static final String AND = " and ";
    private static final String ALGOKEY = "wf.engine.findLatestProcessDefinition";
    private static final String ENABLE = "enable";
    public static final String SELECT_APIFIELDS = "id,businessId,key,entrabillname,resourceid,enable,entrabill,entrabillid,orgunitid,creatorid,createdate,modifierid,modifydate,name,description,operation,version,type,modelId,versiondesc,versionstate,publishname,applicationid,orgviewid,primarysubprocess";
    protected CachedEntityMatcher<ProcessDefinitionEntity> matcherByModelId = new LatestProcDefByModelIdMatcher();
    protected CachedEntityMatcher<ProcessDefinitionEntity> byMidAndVerMatcher = new ProcDefByModelIdAndVersionMatcher();
    protected CachedEntityMatcher<ProcessDefinitionEntity> matcherByDeploymentId = new LatestProcDefByDeploymentIdMatcher();

    public ProcessDefinitionEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public ProcessDefinitionEntity findLatestProcessDefinitionByKey(String processDefinitionKey) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("key", (Object)processDefinitionKey).addFilter(ENABLE, "!=", (Object)"testing").orderBy("version desc").setLimit(1);
        return (ProcessDefinitionEntity)this.findOneByCondition(eb);
    }

    @Override
    public ProcessDefinitionEntity findLatestEnableProcessDefinitionByKey(String processDefinitionKey) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("key", (Object)processDefinitionKey).addFilter(ENABLE, "=", (Object)ENABLE).orderBy("version desc").setLimit(1);
        return (ProcessDefinitionEntity)this.findOneByCondition(eb);
    }

    @Override
    public List<String> findOtherProcessEnableByEntrabillid(String entrabillId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.FID as id,b.FSTARTCONDITION as startCondition FROM t_wf_procdef a LEFT JOIN t_wf_processconfig b ON b.fprocdefid = a.fid WHERE a.fentrabillid = ? AND a.FTYPE='AuditFlow' AND a.fenable = '").append(ENABLE).append("'");
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[]{entrabillId});){
            ArrayList<String> ret = new ArrayList<String>(10);
            for (Row row : ds) {
                String startCondition = row.getString("startCondition");
                if (!WfUtils.isEmpty(startCondition)) continue;
                ret.add(row.getString("id"));
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
    }

    @Override
    public List<String> findOtherProcessEnableByEntrabillidAndOrg(String entrabillId, String orgs) {
        long rootOrgId;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.FID as id,b.FSTARTCONDITION as startCondition FROM t_wf_procdef a LEFT JOIN t_wf_processconfig b ON b.fprocdefid = a.fid WHERE a.fentrabillid = ? AND a.FTYPE='AuditFlow' AND a.fenable = '").append(ENABLE).append("'");
        if (WfUtils.isNotEmpty(orgs) && !orgs.contains((rootOrgId = OrgUnitServiceHelper.getRootOrgId()) + "")) {
            sql.append(" AND a.FORGUNITID in (").append(orgs).append(")");
        }
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[]{entrabillId});){
            ArrayList<String> ret = new ArrayList<String>(10);
            for (Row row : ds) {
                String startCondition = row.getString("startCondition");
                if (!WfUtils.isEmpty(startCondition)) continue;
                ret.add(row.getString("id"));
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
    }

    @Override
    public ProcessDefinitionEntity findLatestProcessDefinitionByModelId(Long modelId) {
        HashMap<String, Long> filters = new HashMap<String, Long>();
        filters.put("modelId", modelId);
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("modelId", (Object)modelId).orderBy("version desc");
        List entities = this.getList(qb, this.matcherByModelId, filters, true);
        if (entities != null && !entities.isEmpty()) {
            return (ProcessDefinitionEntity)entities.get(0);
        }
        return null;
    }

    @Override
    public ProcessDefinitionEntity findLatestProcessDefinitionByDeploymentId(Long deploymentId) {
        HashMap<String, Long> filters = new HashMap<String, Long>();
        filters.put("deploymentId", deploymentId);
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("deploymentId", (Object)deploymentId).orderBy("version desc");
        List entities = this.getList(qb, this.matcherByDeploymentId, filters, true);
        if (entities != null && !entities.isEmpty()) {
            return (ProcessDefinitionEntity)entities.get(0);
        }
        return null;
    }

    @Override
    public ProcessDefinitionEntity findProcDefByModelIdAndVersion(Long modelId, String version) {
        EntityQueryBuilder qb = this.createQueryBuilder().addFilter("modelid", (Object)modelId).addFilter("version", (Object)version);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("modelid", modelId);
        params.put("version", version);
        List entities = this.getList(qb, this.byMidAndVerMatcher, params, true);
        if (entities != null && !entities.isEmpty()) {
            return (ProcessDefinitionEntity)entities.get(0);
        }
        return null;
    }

    @Override
    public void deleteProcessDefinitionsByDeploymentId(Long deploymentId) {
        QFilter filter = new QFilter("deploymentid", "=", (Object)deploymentId);
        QFilter[] filters = new QFilter[]{filter};
        this.deleteByFilters(filters);
    }

    @Override
    public ProcessDefinitionEntity findProcessDefinitionByDeploymentAndKey(Long deploymentId, String processDefinitionKey) {
        QFilter deploymentIdf = new QFilter("deploymentid", "=", (Object)deploymentId);
        QFilter keyf = new QFilter("key", "=", (Object)processDefinitionKey);
        QFilter[] filters = new QFilter[]{deploymentIdf, keyf};
        return (ProcessDefinitionEntity)this.findOneByCondition(filters, this.getSelectFields(), null);
    }

    @Override
    public ProcessDefinition findProcessDefinitionByKeyAndVersion(String processDefinitionKey, String processDefinitionVersion) {
        QFilter versionf = new QFilter("version", "=", (Object)processDefinitionVersion);
        QFilter keyf = new QFilter("key", "=", (Object)processDefinitionKey);
        QFilter[] filters = new QFilter[]{keyf, versionf};
        return (ProcessDefinitionEntity)this.findOneByCondition(filters, this.getSelectFields(), null);
    }

    @Override
    public List<Map<String, Object>> findLatestProcessDefinitionByEntityType(String entityType, String operation) {
        String operationSql = "";
        String masterTableAlias = "a";
        String multiLangTableAlias = "c";
        String entityNumber = "wf_processdefinition";
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fname", (String)"name", (String)"name");
        String descriptionSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)"fdescription", (String)"description", (String)"description");
        StringBuilder sql = new StringBuilder();
        sql.append("select b.FPROCDEFID id,a.fkey number,").append(nameSQL).append(',').append(descriptionSQL);
        sql.append(",a.fversion version1,a.fenable enable1,b.fstartcondition startcondition,a.fcreatedate createdate,a.foperation operation from t_wf_processconfig b LEFT JOIN t_wf_procdef a ON a.fid = b.fprocdefid LEFT JOIN t_wf_procdef_l c ON a.fid = c.fid and FLOCALEID = ? ");
        sql.append(" where b.FENTITYNUMBER = ? and a.fenable='").append(ENABLE).append("' ").append(operationSql);
        sql.append(" order by a.fcreatedate desc,a.fversion desc");
        String lang = RequestContext.get().getLang().toString();
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[]{lang, entityType});){
            ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(10);
            ArrayList<String> tmp = new ArrayList<String>(10);
            for (Row row : ds) {
                String op;
                Map<String, Object> one = this.exportRowToMap(row, ds.getRowMeta());
                if (one == null || one.get(NUMBER) == null || tmp.contains(one.get(NUMBER)) || !this.hasOperation(op = (String)one.get("operation"), operation)) continue;
                ret.add(one);
                tmp.add((String)one.get(NUMBER));
            }
            tmp = null;
            ArrayList<Map<String, Object>> arrayList = ret;
            return arrayList;
        }
    }

    protected Map<String, Object> exportRowToMap(Row row, RowMeta rowMeta) {
        Field[] fields;
        if (WfUtils.isNullObject(rowMeta)) {
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Field field : fields = rowMeta.getFields()) {
            if ("id".equals(field.getName().toLowerCase())) {
                ret.put(field.getName().toLowerCase(), row.getLong(field.getName()));
                continue;
            }
            if ("version1".equals(field.getName().toLowerCase())) {
                ret.put("version", row.get(field.getName()));
                continue;
            }
            if ("enable1".equals(field.getName().toLowerCase())) {
                ret.put(ENABLE, row.get(field.getName()));
                continue;
            }
            ret.put(field.getName().toLowerCase(), row.get(field.getName()));
        }
        return ret;
    }

    private boolean hasOperation(String operations, String operation) {
        if (operations != null) {
            String[] arr;
            for (String str : arr = operations.split(",")) {
                if (!str.equals(operation)) continue;
                return true;
            }
        }
        return false;
    }

    public Class<? extends ProcessDefinitionEntity> getManagedEntityClass() {
        return ProcessDefinitionEntityImpl.class;
    }

    public String getSelectFields() {
        return "id,businessId,key,entrabillname,category,deploymentId,resourceid,graphname,enable,entrabill,entrabillid,orgunitid,creatorid,createdate,modifierid,template,engineversion,modifydate,name,description,categoryid,categoryname,operation,version,graphicaldefined,parentprocid,type,modelId,versiondesc,versionstate,publishname,applicationid,orgviewid,primarysubprocess";
    }

    @Override
    public Long getDifficultFilterCount(QFilter[] filters) {
        String fields = "id";
        for (QFilter filter : filters) {
            if ("entrabillname".equals(filter.getProperty())) {
                filter.setProperty("entrabillid.name");
                this.replaceNestFilter(filter);
                break;
            }
            if ("orgunitname".equals(filter.getProperty())) {
                filter.setProperty("orgunitid.name");
                break;
            }
            this.replaceNestFilter(filter);
        }
        ORM orm = ORM.create();
        ArrayList<QFilter> tQ = new ArrayList<QFilter>(Arrays.asList(filters));
        try (DataSet pdDS = orm.queryDataSet(this.createAlgoKey(), "wf_processdefinition", fields, tQ.toArray(new QFilter[0]));){
            int count = pdDS.count("id", true);
            Long l = count;
            return l;
        }
    }

    private void replaceNestFilter(QFilter filter) {
        List tmp = filter.getNests(true);
        if (tmp != null && !tmp.isEmpty()) {
            for (QFilter.QFilterNest node : tmp) {
                if (!"entrabillname".equals(node.getFilter().getProperty())) continue;
                node.getFilter().setProperty("entrabillid.name");
            }
        }
    }

    @Override
    public List<ProcessDefinitionStartInfo> findLatestEnabledProcessDefinitions(String entityNumber, String operation, Long parentProcDefId) {
        Object[] params = null;
        ArrayList<ProcessDefinitionStartInfo> startInfos = new ArrayList<ProcessDefinitionStartInfo>();
        StringBuilder sql = new StringBuilder("select ");
        sql.append("a.fid id, a.fkey number, a.fversion procversion, b.foperation operation, a.forgunitid orgId, b.fstartcondition startcondition, b.fprocesstype processtype,a.fprimarysubprocess primarysubprocess ");
        sql.append("from t_wf_processconfig b ");
        sql.append("left join t_wf_procdef a on a.fid = b.fprocdefid ");
        sql.append("where b.fentitynumber = ? and a.fenable = 'enable' and b.fallowstart = '1' ");
        if (Context.getCommandContext() != null && Context.getCommandContext().getAttribute("ADDRESSSCENSE") != null && WfConfigurationUtil.firstAddressAssignPersonProcess()) {
            sql.append(" and b.fisallownextperson='1' ");
        }
        if (WfUtils.isNotEmpty(parentProcDefId)) {
            ProcessDefinitionEntity parentProcDef = (ProcessDefinitionEntity)this.findById(parentProcDefId, "type");
            String procType = parentProcDef == null ? "AuditFlow" : parentProcDef.getType();
            sql.append("and a.fid != ? and a.ftype=? ");
            if ("AuditFlow".equals(procType)) {
                sql.append("and a.fprimarysubprocess in ( 'sub', ' ') ");
            } else if ("BizFlow".equals(procType)) {
                sql.append("and a.fprimarysubprocess in ('main' , ' ') ");
            }
            params = new Object[]{entityNumber, parentProcDefId, ModelType.AuditFlow.name()};
        } else {
            sql.append("and a.fprimarysubprocess in ('main' , ' ') ");
            params = new Object[]{entityNumber};
        }
        sql.append("order by a.fcreatedate desc, a.fversion desc;");
        try (DataSet ds = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
            for (Row row : ds) {
                Long id = row.getLong("id");
                String number = row.getString(NUMBER);
                String version = row.getString("procversion");
                String operations = row.getString("operation");
                String condition = row.getString("startcondition");
                String processType = row.getString("processtype");
                Long orgId = row.getLong("orgId");
                if (!this.hasOperation(operations, operation)) continue;
                ProcessDefinitionStartInfo startInfo = new ProcessDefinitionStartInfo(id, number, version, operations, condition, processType, orgId);
                startInfos.add(startInfo);
            }
        }
        return startInfos;
    }

    @Override
    public List<ProcessDefinitionStartInfo> findEnabledHadBatchNumberBizFlowProcDefinitions(String entityNumber, String operation) {
        ArrayList<ProcessDefinitionStartInfo> startInfos = new ArrayList<ProcessDefinitionStartInfo>();
        StringBuilder sql = new StringBuilder("select ");
        sql.append("a.fid id, a.fkey number, a.fversion procversion, b.foperation operation, a.forgunitid orgId, b.fstartcondition startcondition, b.fprocesstype processtype, b.fbatchnumber batchnumber ");
        sql.append("from t_wf_processconfig b ");
        sql.append("left join t_wf_procdef a on a.fid = b.fprocdefid ");
        sql.append("where b.fentitynumber = ? and a.fenable = 'enable' and b.fallowstart = '1' and b.fbatchnumber != ' ' and b.fprocesstype = ? ");
        sql.append("order by a.fcreatedate desc, a.fversion desc;");
        try (DataSet ds = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[]{entityNumber, ModelType.BizFlow.name()});){
            for (Row row : ds) {
                Long id = row.getLong("id");
                String number = row.getString(NUMBER);
                String version = row.getString("procversion");
                String operations = row.getString("operation");
                String condition = row.getString("startcondition");
                String processType = row.getString("processtype");
                String batchNumber = row.getString("batchnumber");
                if (!this.hasOperation(operations, operation)) continue;
                startInfos.add(new ProcessDefinitionStartInfo(id, number, version, operations, condition, processType, batchNumber));
            }
        }
        return startInfos;
    }

    /*
     * Exception decompiling
     */
    @Override
    public DynamicObjectCollection getProcessInParticipateListData(int start, int limit, List<QFilter> qFilters, String orderBy) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void wrapQFiltersAndWhere(List<QFilter> qFilters, List<QFilter> procDefFilters, List<QFilter> partModelFilters, StringBuilder whereSb) {
        ArrayList<String> partModelFields = new ArrayList<String>();
        partModelFields.add(VALUE);
        partModelFields.add("activityname");
        partModelFields.add("property");
        int len = qFilters.size();
        for (int i = 0; i < len; ++i) {
            QFilter filter = qFilters.get(i);
            if (i < 3) {
                if (partModelFields.contains(filter.getProperty())) {
                    partModelFilters.add(filter);
                    this.getWhereCondition(whereSb, filter);
                    continue;
                }
                if ("proctype".equals(filter.getProperty())) {
                    procDefFilters.add(new QFilter("type", "in", filter.getValue()));
                    continue;
                }
                procDefFilters.add(filter);
                this.getWhereCondition(whereSb, filter);
                continue;
            }
            whereSb.append(' ').append(filter.toString()).append(AND);
        }
        HashSet<Long> ids = new HashSet<Long>();
        Set<Long> idsForPerson = this.getProcdefIdsForPerson(partModelFilters);
        if (CollectionUtil.isNotEmpty(idsForPerson)) {
            HashSet<Long> enableIds = new HashSet<Long>();
            HashSet<Long> disableIds = new HashSet<Long>();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.addAll(procDefFilters);
            filters.add(new QFilter("id", "in", idsForPerson));
            this.getAllProcdefIds(filters, enableIds, disableIds);
            ids.addAll(enableIds);
            ids.retainAll(idsForPerson);
            HashSet<Long> disableIdsForPerson = new HashSet<Long>();
            disableIdsForPerson.addAll(idsForPerson);
            disableIdsForPerson.removeAll(ids);
            Set<Long> disableAndInProcessIds = this.getDisableAndInProcessIds(disableIdsForPerson);
            ids.addAll(disableAndInProcessIds);
            if (CollectionUtil.isNotEmpty(ids)) {
                whereSb.append("processdefinitionid in (").append(this.getInUseProcDefIds(ids)).append(") and ");
                procDefFilters.add(new QFilter("id", "in", ids));
            }
        }
    }

    private Set<Long> getProcdefIdsForPerson(List<QFilter> partModelFilters) {
        HashSet<Long> idsForPerson = new HashSet<Long>();
        QFilter[] f1 = partModelFilters.toArray(new QFilter[partModelFilters.size()]);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.createAlgoKey(), (String)"wf_participantmodel", (String)PROCDEFID, (QFilter[])f1, null);){
            if (!dataSet.isEmpty()) {
                for (Row row : dataSet) {
                    idsForPerson.add(row.getLong(PROCDEFID));
                }
            }
        }
        catch (Exception e) {
            this.logger.info("getProcdefIdsForPerson is error: " + WfUtils.getExceptionStacktrace(e));
        }
        return idsForPerson;
    }

    private void getAllProcdefIds(List<QFilter> procDefFilters, Set<Long> enableIds, Set<Long> disableIds) {
        QFilter[] f2 = procDefFilters.toArray(new QFilter[procDefFilters.size()]);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.createAlgoKey(), (String)"wf_processdefinition", (String)"id,enable", (QFilter[])f2, null);){
            if (!dataSet.isEmpty()) {
                for (Row row : dataSet) {
                    Long procDefId = row.getLong("id");
                    if (ENABLE.equalsIgnoreCase(row.getString(ENABLE))) {
                        enableIds.add(procDefId);
                        continue;
                    }
                    disableIds.add(procDefId);
                }
            }
        }
        catch (Exception e) {
            this.logger.info("getAllProcdefIds is error: " + WfUtils.getExceptionStacktrace(e));
        }
    }

    private Set<Long> getDisableAndInProcessIds(Set<Long> disableIdsForPerson) {
        HashSet<Long> disableAndInProcessIds = new HashSet<Long>();
        QFilter q4 = new QFilter("processdefinitionid", "in", disableIdsForPerson);
        QFilter q5 = new QFilter("scope", "=", (Object)Boolean.TRUE);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.createAlgoKey(), (String)"wf_execution", (String)"processdefinitionid", (QFilter[])new QFilter[]{q4, q5}, null);){
            if (!dataSet.isEmpty()) {
                for (Row row : dataSet) {
                    disableAndInProcessIds.add(row.getLong("processdefinitionid"));
                }
            }
        }
        catch (Exception e) {
            this.logger.info("getDisableAndInProcessIds is error: " + WfUtils.getExceptionStacktrace(e));
        }
        return disableAndInProcessIds;
    }

    @Override
    public Long getProcdefCountByEntityNumber(String entityNumber) {
        this.logger.debug(String.format("procdefIsexistsByEntityNumber: entityNumber:_%s_ in process", entityNumber));
        ORM orm = ORM.create();
        QFilter q1 = new QFilter("entrabill", "=", (Object)entityNumber);
        QFilter q2 = new QFilter(ENABLE, "=", (Object)ENABLE);
        try (DataSet ds = orm.queryDataSet(this.createAlgoKey(), "wf_processdefinition", "id", new QFilter[]{q1, q2});){
            int count = ds.count("id", true);
            Long l = count;
            return l;
        }
    }

    private void getWhereCondition(StringBuilder whereSb, QFilter filter) {
        whereSb.append(filter.getProperty()).append(" ");
        whereSb.append(filter.getCP());
        Object qFilterValue = filter.getValue();
        if (qFilterValue instanceof String) {
            if (!WfUtils.isEmptyString(qFilterValue)) {
                whereSb.append(" '").append(filter.getValue()).append("' and ");
            } else {
                whereSb.append(AND);
            }
        } else if (qFilterValue instanceof List) {
            List values = (List)filter.getValue();
            StringBuilder valueSb = new StringBuilder();
            for (Object value : values) {
                if (!WfUtils.isEmptyString(value)) {
                    valueSb.append("'").append(value).append("'").append(",");
                    continue;
                }
                whereSb.append(AND);
            }
            if (valueSb.length() > 1) {
                whereSb.append("(").append(valueSb.substring(0, valueSb.length() - 1)).append(")").append(AND);
            }
        } else if (qFilterValue instanceof Object[]) {
            Object[] values = (Object[])filter.getValue();
            StringBuilder valueSb = new StringBuilder();
            for (Object value : values) {
                if (!WfUtils.isEmptyString(value)) {
                    valueSb.append("'").append(value).append("'").append(",");
                    continue;
                }
                whereSb.append(AND);
            }
            if (valueSb.length() > 1) {
                whereSb.append("(").append(valueSb.substring(0, valueSb.length() - 1)).append(")").append(AND);
            }
        } else if (!WfUtils.isEmptyString(qFilterValue)) {
            whereSb.append(" ").append(qFilterValue).append(AND);
        } else {
            whereSb.append(AND);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Integer getProcessInParticipateListDataCount(List<QFilter> qFilters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getInUseProcDefIds(Set<Long> inUseProcDefIds) {
        StringBuilder inUseProcDefIdsSB = new StringBuilder();
        for (Long inUseProcDefId : inUseProcDefIds) {
            inUseProcDefIdsSB.append(inUseProcDefId).append(",");
        }
        if (inUseProcDefIdsSB.length() > 1) {
            return inUseProcDefIdsSB.substring(0, inUseProcDefIdsSB.length() - 1);
        }
        return inUseProcDefIdsSB.toString();
    }

    @Override
    public List<Long> getMountOperationProcdefIds(String entityNumber, String operation) {
        Object[] params = new Object[]{entityNumber};
        ArrayList<Long> procdefIds = new ArrayList<Long>();
        StringBuilder sql = new StringBuilder("select ");
        sql.append("a.fprocdefid procdefid, a.fid id, a.fentitynumber entitynumber, a.foperation operation ");
        sql.append("from t_wf_processconfig a ");
        sql.append("where a.fentitynumber = ? and a.fenable='1' and fprocesstype='BizFlow' ");
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
            for (Row row : ds) {
                String operations = row.getString("operation");
                if (!this.hasOperation(operations, operation)) continue;
                procdefIds.add(row.getLong(PROCDEFID));
            }
        }
        return procdefIds;
    }

    @Override
    public Long getEnableProcessCount() {
        QFilter filter = new QFilter(ENABLE, "=", (Object)ENABLE);
        QFilter filter2 = new QFilter("key", "!=", (Object)"freeflowtpl");
        return this.countByFilter("id", new QFilter[]{filter, filter2}, true);
    }

    @Override
    public Long getEnableProcessCountByType(String type) {
        QFilter filter = new QFilter(ENABLE, "=", (Object)ENABLE);
        QFilter filter2 = new QFilter("key", "!=", (Object)"freeflowtpl");
        QFilter filter3 = new QFilter("type", "=", (Object)type);
        return this.countByFilter("id", new QFilter[]{filter, filter2, filter3}, true);
    }

    @Override
    public ProcessDefinitionStartInfo findStartInfoByDefinitionId(Long definitionId) {
        ProcessDefinitionStartInfo ret = null;
        StringBuilder sql = new StringBuilder("select ");
        sql.append("a.fid id, a.fkey number, a.fversion procversion, b.foperation operation, a.forgunitid orgId, b.fstartcondition startcondition, b.fprocesstype processtype,a.fprimarysubprocess primarysubprocess ");
        sql.append("from t_wf_processconfig b ");
        sql.append("left join t_wf_procdef a on a.fid = b.fprocdefid ");
        sql.append("where a.fid = ? ");
        try (DataSet ds = DB.queryDataSet((String)"wf.engine.findStartInfoByDefinitionId", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])new Object[]{definitionId});){
            for (Row row : ds) {
                Long id = row.getLong("id");
                String number = row.getString(NUMBER);
                String version = row.getString("procversion");
                String operations = row.getString("operation");
                String condition = row.getString("startcondition");
                String processType = row.getString("processtype");
                Long orgId = row.getLong("orgId");
                ret = new ProcessDefinitionStartInfo(id, number, version, operations, condition, processType, orgId);
            }
        }
        return ret;
    }
}

