/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.persistence.entity.task;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.format.FormatObject;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.EntityNumberConstant;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.event.ActivitiEvent;
import kd.bos.workflow.engine.delegate.event.ActivitiEventType;
import kd.bos.workflow.engine.delegate.event.impl.ActivitiEventBuilder;
import kd.bos.workflow.engine.identity.User;
import kd.bos.workflow.engine.identity.UserInfo;
import kd.bos.workflow.engine.impl.calculator.ParticipantRangeUtil;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.processassistant.ProcessAssistantUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.CountingExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.cachematcher.TasksByExecutionIdMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.design.AuditPointInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.management.ManagementConstants;
import kd.bos.workflow.engine.impl.persistence.entity.monitor.worktransfer.WorksTransferLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskToDoGroupEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskToDoGroupEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.impl.util.TaskHelper;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.task.TaskUtils;
import kd.bos.workflow.feature.taskfield.util.TaskExtendFieldUtil;
import kd.bos.workflow.service.impl.ThreadLocalVariables;
import org.apache.commons.lang.StringUtils;

public class TaskEntityManagerImpl
extends AbstractEntityManager<TaskEntity>
implements TaskEntityManager {
    private static final String USER_ID = "userId";
    private static final String WF_TASK_CENTER_CUSTOM_QUERY_GRID_DATA = "WfTaskCenterCustom.queryGridData";
    private static final String WHERE = "WHERE ";
    private static final String T_WF_TASK_A = "t_wf_task a ";
    private static final String FROM = "FROM ";
    private static final String SELECT_TOP = "SELECT top ";
    private static final String COUNT = "count";
    private static final String CREATEDATE = "createdate";
    private static final String B_FNUMBER_NAME = "b.fnumber name ";
    private static final String WF_TASK_CENTER_WF_TASK_QUERY_GRID_DATA = "WfTaskCenter.wf_task.queryGridData";
    private static final String FROM_T_WF_TASK_A = " from t_wf_task a";
    private static final String A_FISACTIVE_ACTIVE = "a.FISACTIVE active,";
    private static final String A_FSUSPENSIONSTATE_SUSPENSIONSTATE = "a.FSUSPENSIONSTATE suspensionstate,";
    private static final String A_FHANDLESTATE_HANDLESTATE = "a.FHANDLESTATE handlestate,";
    private static final String A_FID_ID = " a.fid id,";
    private static final String BOS_WF_ENGINE = "bos-wf-engine";
    private static final String SUSPENSIONSTATE = "suspensionstate";
    private static final String FREEZE = "freeze";
    private static final String HANDLESTATE = "handlestate";
    private static final String ACTIVE = "active";
    private static final String TASKID = "taskid";
    private static final String FROM_T_WF_RTRELATION_A = "from t_wf_rtrelation a ";
    private static final String MOBILE = "mobile";
    private static final String PRIORITYSHOW = "priorityshow";
    private static final String SENDERNAME = "sendername";
    private static final String FSENDERNAME = "fsendername";
    private static final String FNAME = "fname";
    private static final String NAME = "name";
    private static final String SUBJECT = "subject";
    private static final String FSUBJECT = "fsubject";
    private static final String FSTARTNAME = "FSTARTNAME";
    private static final String STARTNAME = "startname";
    private static final String ENTITYNAME = "entityname";
    private static final String FENTITY_NAME = "fentityName";
    private static final String USERID = "userid";
    private static final String SENDERNAMEFORMAT = "sendernameformat";
    private static final String FSENDERNAMEFORMAT = "fsendernameformat";
    private static final String FSTARTNAMEFORMAT = "fstartnameformat";
    private static final String STARTNAMEFORMAT = "startnameformat";
    private static final String AND = " and ";
    private static final String DELEGATEID = "delegateid";
    private static final String FCURRENTSUBJECT = "fcurrentsubject";
    private static final String CURRENTSUBJECT = "currentsubject";
    private static final String YUNZHIJIATASK = "YunzhijiaTask";
    protected CachedEntityMatcher<TaskEntity> tasksByExecutionIdMatcher = new TasksByExecutionIdMatcher();

    public TaskEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public Class<? extends TaskEntity> getManagedEntityClass() {
        return TaskEntityImpl.class;
    }

    public String getSelectFields() {
        String extBusinessFieldBy = TaskExtendFieldUtil.getExtBusinessFieldByEntityNumber((String)this.getEntityName());
        return "id,name,parentTaskId,description,billNo,priority,owner,assignee,delegationState,executionId,processInstanceId,processDefinitionId,taskDefinitionKey,dueDate,category,suspensionState,formKey,mobileFormKey,claimTime,display,starterId,startName,senderId,senderName,entityName,subject,assigneeId,ownerId,executionType,entityNumber,businessKey,yzjgroupid,processingPage,processingMobilePage,handleState,active,createDate,modifyDate,subactivityname,endtype,source,sourcename,participantName,validateoperation,groupnumber,batchOp,billtype,orgunitid,orgviewid,biztraceno,sendernameformat,startnameformat,processtype,control,taskstate,resourceid,url,mobileurl,biz_date,biz_number,bizformat,biz_str1,biz_str2,captionpc,captionmob,biz_date2,biz_number2,biz_strmul1,biz_strmul2" + extBusinessFieldBy;
    }

    public void insert(TaskEntity taskEntity, boolean fireCreateEvent) {
        if (taskEntity.getOwnerId() != null) {
            this.addOwnerIdentityLink(taskEntity);
        }
        if (taskEntity.getAssigneeId() != null) {
            this.addAssigneeIdentityLinks(taskEntity);
        }
        this.setTaskState(taskEntity);
        super.insert((Entity)taskEntity, fireCreateEvent);
    }

    private void setTaskState(TaskEntity taskEntity) {
        String taskState = taskEntity.getHandleState();
        if (!taskEntity.isActive()) {
            taskState = FREEZE;
        }
        if (!ManagementConstants.ACTIVE.getStateCode().equals(taskEntity.getSuspensionState())) {
            taskState = "manualSuspended";
        }
        taskEntity.setTaskState(taskState);
    }

    public void insert(TaskEntity taskEntity, ExecutionEntity execution) {
        if (execution != null) {
            execution.getTasks().add(taskEntity);
            taskEntity.setExecutionId(execution.getId());
            taskEntity.setProcessInstanceId(execution.getProcessInstanceId());
            taskEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
            Long id = TaskHelper.addGroupInfo((TaskEntity)taskEntity, (ExecutionEntity)execution);
            taskEntity.setGroupNumber(id);
            taskEntity.setOrgUnitId(execution.getMainOrgId());
            taskEntity.setOrgViewId(execution.getOrgViewId());
            this.getHistoryManager().recordTaskExecutionIdChange(taskEntity.getId(), taskEntity.getExecutionId());
        }
        this.insert(taskEntity, true);
        if (execution != null && this.isExecutionRelatedEntityCountEnabled(execution)) {
            CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)execution;
            countingExecutionEntity.setTaskCount(countingExecutionEntity.getTaskCount() + 1);
        }
        this.getHistoryManager().recordTaskCreated(taskEntity, execution);
        this.setTaskProperties(taskEntity);
    }

    private void setTaskProperties(TaskEntity taskEntity) {
        if (TaskUtils.isBizTask(taskEntity.getSource())) {
            String mobileUrl;
            String url = taskEntity.getUrl();
            if (WfUtils.isEmpty(url)) {
                url = MessageServiceUtil.buildWebPageUrlForTaskEntity((TaskEntity)taskEntity);
                taskEntity.setUrl(url);
            }
            if (WfUtils.isEmpty(mobileUrl = taskEntity.getMobileUrl())) {
                taskEntity.setMobileUrl(taskEntity.getUrl());
            }
            HistoricTaskInstanceEntity historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskEntity.getId());
            historicTaskInstance.setUrl(taskEntity.getUrl());
            historicTaskInstance.setMobileUrl(taskEntity.getMobileUrl());
        }
    }

    public void changeTaskAssignee(TaskEntity taskEntity, Long assigneeId, ILocaleString assignName) {
        if (taskEntity.getAssigneeId() == null || taskEntity.getAssigneeId() != null && !taskEntity.getAssigneeId().equals(assigneeId) || (assigneeId == null || assigneeId <= 0L) && assignName != null) {
            if (assigneeId != null && assignName == null) {
                assignName = WfUtils.findUserName(assigneeId);
            }
            taskEntity.setAssigneeId(assigneeId);
            taskEntity.setAssignee(assignName);
            this.fireAssignmentEvents(taskEntity);
            if (taskEntity.getId() != null) {
                this.getHistoryManager().recordTaskAssigneeChange(taskEntity.getId(), taskEntity.getAssigneeId(), assignName);
                this.update(taskEntity);
            }
        }
    }

    public TaskEntity update(TaskEntity entity, boolean fireUpdateEvent) {
        this.setTaskState(entity);
        super.update((Entity)entity, true);
        entity.clearAttributesModifyRecords();
        return entity;
    }

    public TaskEntity update(TaskEntity entity) {
        return (TaskEntity)super.update((Entity)entity);
    }

    public void changeTaskOwner(TaskEntity taskEntity, Long ownerId, String ownerName) {
        if (taskEntity.getOwner() != null && !taskEntity.getOwner().equals(ownerName) || taskEntity.getOwner() == null && ownerName != null) {
            User obj;
            if (ownerId != null && ownerName == null && (obj = WfUtils.findUserById(ownerId)) != null && obj.getName() != null) {
                ownerName = obj.getName().toString();
            }
            taskEntity.setOwner(ownerName);
            taskEntity.setOwnerId(ownerId);
            if (taskEntity.getId() != null) {
                this.getHistoryManager().recordTaskOwnerChange(taskEntity.getId(), ownerId, taskEntity.getOwner());
                this.addOwnerIdentityLink(taskEntity);
                this.update(taskEntity);
            }
        }
    }

    protected void fireAssignmentEvents(TaskEntity taskEntity) {
        this.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(taskEntity, "assignment");
        this.getHistoryManager().recordTaskAssignment(taskEntity);
    }

    private void addAssigneeIdentityLinks(TaskEntity taskEntity) {
        if (taskEntity.getAssigneeId() != null && taskEntity.getProcessInstance() != null) {
            this.getIdentityLinkEntityManager().involveUser(taskEntity.getProcessInstance(), taskEntity.getAssigneeId(), "dynparticipant");
        }
    }

    protected void addOwnerIdentityLink(TaskEntity taskEntity) {
        if (taskEntity.getOwnerId() != null && taskEntity.getProcessInstanceId() != null) {
            this.getIdentityLinkEntityManager().involveUser(taskEntity.getProcessInstance(), taskEntity.getOwnerId(), "dynparticipant");
        }
    }

    public void deleteTasksByProcessInstanceId(Long processInstanceId, String deleteReason, boolean cascade) {
        List<TaskEntity> tasks = this.findTasksByProcessInstanceId(processInstanceId);
        for (TaskEntity task : tasks) {
            if (this.getEventDispatcher().isEnabled()) {
                this.getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createActivityCancelledEvent((String)task.getExecution().getActivityId(), (String)task.getName().getLocaleValue(), (Long)task.getExecutionId(), (Long)task.getProcessInstanceId(), (Long)task.getProcessDefinitionId(), (String)"userTask", (Object)deleteReason));
            }
            Context.getCommandContext().getTaskHelper().deleteTaskEntity(task, deleteReason, cascade, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTask(TaskEntity task, String deleteReason, boolean cascade, boolean cancel, boolean subs) {
        if (!task.isDeleted()) {
            boolean canExecuteListener;
            boolean bl = canExecuteListener = task.isBizTask() || WfUtils.isNotEmpty(deleteReason) && (deleteReason.startsWith("terminate end event") || deleteReason.startsWith("multiInstance delete") || "fork_jumpOrReject".equals(deleteReason) && YUNZHIJIATASK.equals(task.getCategory()) && WfUtils.isNotEmpty(task.getParentTaskId())) || !"task withdraw".equals(deleteReason) && !(task.getExecution().getCurrentFlowElement() instanceof YunzhijiaTask);
            if (canExecuteListener) {
                try {
                    task.setTransientVariableLocal("deleteReason", (Object)deleteReason);
                    this.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(task, "delete");
                }
                finally {
                    task.removeTransientVariableLocal("deleteReason");
                }
            }
            task.setDeleted(true);
            Long taskId = task.getId();
            if (subs) {
                List<TaskEntity> subTasks = this.findTasksByParentTaskId(taskId);
                for (TaskEntity subTask : subTasks) {
                    this.changeTaskExecutionType(subTask, task.getExecutionType());
                    Context.getCommandContext().getTaskHelper().deleteTaskEntity(subTask, deleteReason, cascade, cancel);
                }
            }
            this.getIdentityLinkEntityManager().deleteIdentityLinksByTask(task);
            this.getVariableInstanceEntityManager().deleteVariableInstanceByTask(task);
            if (cascade) {
                this.getHistoricTaskInstanceEntityManager().delete(taskId);
            } else {
                this.getHistoryManager().recordTaskEnd(taskId, deleteReason);
            }
            this.delete(task, false);
            if (WfUtils.isEmpty(task.getAssigneeId()) && "byHand".equals(task.getExecutionType())) {
                List auditPointInstances = this.getAuditPointInstanceEntityManager().findAuditPointInstancesByTaskId(taskId);
                for (AuditPointInstanceEntity auditPointInstanceEntity : auditPointInstances) {
                    this.getAuditPointInstanceEntityManager().delete((Entity)auditPointInstanceEntity);
                }
            }
            if (this.getEventDispatcher().isEnabled()) {
                if (cancel) {
                    this.getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createActivityCancelledEvent((String)(task.getExecution() != null ? task.getExecution().getActivityId() : null), (String)task.getName().getLocaleValue(), (Long)task.getExecutionId(), (Long)task.getProcessInstanceId(), (Long)task.getProcessDefinitionId(), (String)"userTask", (Object)deleteReason));
                }
                this.getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.ENTITY_DELETED, (Object)task));
            }
            if (!"task withdraw".equals(deleteReason) && WfUtils.isEmpty(task.getParentTaskId())) {
                Long taskGroupNumber = 0L;
                if (task.getDynamicObject().get("groupnumber") instanceof DynamicObject) {
                    taskGroupNumber = ((DynamicObject)task.getDynamicObject().get("groupnumber")).getLong("number");
                    task.setGroupNumber(taskGroupNumber);
                } else {
                    taskGroupNumber = task.getGroupNumber();
                }
                if (taskGroupNumber != null && taskGroupNumber != 0L) {
                    TaskToDoGroupEntityManager groupManager;
                    TaskToDoGroupEntity taskToDoGroupEntity;
                    QFilter[] filters = new QFilter[]{new QFilter("groupnumber", "=", (Object)taskGroupNumber)};
                    boolean isDelete = true;
                    List tasks = this.findByQueryFilters(filters);
                    for (int i = 0; i < tasks.size(); ++i) {
                        TaskEntity taskEntity = (TaskEntity)tasks.get(i);
                        if (taskId.equals(taskEntity.getId()) || !WfUtils.isEmpty(taskEntity.getParentTaskId()) && taskId.equals(taskEntity.getParentTaskId())) continue;
                        isDelete = false;
                    }
                    if (isDelete && !WfConfigurationUtil.isNotDeleteToHandleGroup().booleanValue() && (taskToDoGroupEntity = (TaskToDoGroupEntity)(groupManager = Context.getCommandContext().getTaskToDoGroupEntityManager()).findById(taskGroupNumber)) != null) {
                        groupManager.delete((Entity)taskToDoGroupEntity);
                    }
                }
            }
        }
    }

    public void deleteTask(TaskEntity task, String deleteReason, boolean cascade, boolean cancel) {
        this.deleteTask(task, deleteReason, cascade, cancel, true);
    }

    public void delete(TaskEntity entity, boolean fireDeleteEvent) {
        CountingExecutionEntity countingExecutionEntity;
        super.delete((Entity)entity, fireDeleteEvent);
        if (entity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(countingExecutionEntity = (CountingExecutionEntity)entity.getExecution())) {
            countingExecutionEntity.setTaskCount(countingExecutionEntity.getTaskCount() - 1);
        }
    }

    public List<TaskEntity> findTasksByExecutionId(Long executionId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("executionId", (Object)executionId);
        return this.findByQueryBuilder(eb);
    }

    public List<TaskEntity> findTasksByProcessInstanceId(Long processInstanceId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("processInstanceId", (Object)processInstanceId);
        return this.findByQueryBuilder(eb);
    }

    public List<TaskEntity> findTasksByParentTaskId(Long parentTaskId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("parentTaskId", (Object)parentTaskId);
        return this.findByQueryBuilder(eb);
    }

    public void deleteTask(Long taskId, String deleteReason, boolean cascade) {
        this.deleteTask(taskId, deleteReason, cascade, true);
    }

    public void deleteTask(Long taskId, String deleteReason, boolean cascade, boolean sub) {
        TaskEntity task = (TaskEntity)this.findById(taskId);
        if (task != null) {
            this.deleteTask(task, deleteReason, cascade, false, sub);
        } else if (cascade) {
            this.getHistoricTaskInstanceEntityManager().delete(taskId);
        }
    }

    public List<TaskEntity> findTasksByBusinessKey(String businessKey) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", (Object)businessKey).addFilter("executionType", (Object)"byHand");
        return this.findByQueryBuilder(eb);
    }

    public List<TaskEntity> findTasksByBusinessKeyOrderBySuperExec(String businessKey) {
        String fields = "a.fid,a.fname,a.fparentTaskId,a.fdescription,a.fbillNo,a.fpriority,a.fowner,a.fassignee,a.FDELEGATION,a.fexecutionId,a.FPROCINSTID,a.FPROCDEFID,a.FTASKDEFID,a.fdueDate,a.fcategory,a.fsuspensionState,a.fformKey,a.fmobileFormKey,a.fclaimTime,a.FISDISPLAY,a.fstarterId,a.fstartName,a.fsenderId,a.fsenderName,a.fentityName,a.fsubject,a.fassigneeId,a.fownerId,a.fexecutionType,a.fentityNumber,a.fbusinessKey,a.fyzjgroupid,a.fprocessingPage,a.fprocessingMobilePage,a.fhandleState,a.FISACTIVE,a.fcreateDate,a.fmodifyDate,a.fsubactivityname,a.fendtype,a.fsource,a.fparticipantName,a.fvalidateoperation,a.fgroupnumber,a.fbatchOp,a.fbilltype,a.forgunitid,a.forgviewid,a.fbiztraceno,a.fsendernameformat,a.fstartnameformat,a.fprocesstype,a.fcontrol,a.fextendnumber,a.fextendformat,a.fextendstr1,a.fextendstr2";
        String sql = "select " + fields + " from t_wf_task a left join t_wf_execution b on a.fexecutionid = b.fid where  a.fbusinesskey =? and a.fexecutionType ='byHand' order by b.fsuperexec";
        return this.findEntityBySQLFilter(sql, new Object[]{businessKey});
    }

    public void changeTaskExecutionType(TaskEntity taskEntity, String executionType) {
        taskEntity.setExecutionType(executionType);
        if (taskEntity != null && taskEntity.getId() != null) {
            this.getHistoryManager().recordTaskExecutionTypeChange(taskEntity.getId(), executionType);
            this.update(taskEntity);
        }
    }

    public TaskEntity recoverTask(HistoricTaskInstanceEntity historicTask) {
        TaskEntityImpl task = new TaskEntityImpl(historicTask);
        if (BpmnModelUtil.instanceofAuditTask((String)task.getCategory())) {
            task.setHandleState("willApproval");
            this.resetTaskHandleState(historicTask, (TaskEntity)task);
        } else if (BpmnModelUtil.instanceofBillTask((String)task.getCategory())) {
            historicTask.setHandleState("unConverted");
            this.resetTaskHandleState(historicTask, (TaskEntity)task);
        } else if (BpmnModelUtil.instanceofUserTask((String)task.getCategory())) {
            task.setHandleState("willHandled");
            this.resetTaskHandleState(historicTask, (TaskEntity)task);
        }
        Long groupNumber = TaskHelper.addGroupInfo((TaskEntity)task, (ExecutionEntity)task.getExecution());
        task.setGroupNumber(groupNumber);
        this.insert((TaskEntity)task, true);
        this.getHistoryManager().recordTaskId((TaskEntity)task);
        historicTask.setDeleteReason(null);
        QFilter qFilter1 = new QFilter(TASKID, "=", (Object)historicTask.getId());
        QFilter qFilter3 = new QFilter("type", "=", (Object)"participant");
        QFilter[] filters = new QFilter[]{qFilter1, qFilter3};
        List list = this.getHistoricIdentityLinkEntityManager().findByQueryFilters(filters);
        task.setParticipantName(null);
        Long assigneeId = historicTask.getAssigneeId();
        boolean isDelegate = false;
        if (WfUtils.isNotEmptyForCollection(list)) {
            for (HistoricIdentityLinkEntity hisParticipant : list) {
                if (assigneeId == null || !assigneeId.equals(hisParticipant.getUserId()) || !WfUtils.isNotEmpty(hisParticipant.getDelegateId())) continue;
                isDelegate = true;
                break;
            }
        }
        if (isDelegate) {
            for (HistoricIdentityLinkEntity hisParticipant : list) {
                this.getHistoricIdentityLinkEntityManager().delete((Entity)hisParticipant);
                this.addUserIdentityLink(hisParticipant, (TaskEntity)task);
            }
            task.getExecution().setTransientVariable("isDelegate", (Object)true);
        } else {
            for (HistoricIdentityLinkEntity hisParticipant : list) {
                this.getHistoricIdentityLinkEntityManager().delete((Entity)hisParticipant);
                if (hisParticipant.getDelegateId() != 0L) continue;
                if (hisParticipant.getCompositeTaskId() == 0L) {
                    hisParticipant.setDisplay(Boolean.TRUE);
                    hisParticipant.setTrustName(null);
                    hisParticipant.setTrustNameFormat(null);
                }
                this.addUserIdentityLink(hisParticipant, (TaskEntity)task);
            }
        }
        UserTask userTask = ParticipantRangeUtil.getFlowElement((Long)task.getProcessDefinitionId(), (Long)task.getProcessInstanceId(), (String)task.getTaskDefinitionKey(), null);
        TaskHelper.planSavePageParameter((UserTask)userTask, (TaskEntity)task);
        return task;
    }

    private void resetTaskHandleState(HistoricTaskInstanceEntity historicTask, TaskEntity task) {
        TaskHelper helper;
        boolean isReject;
        Long curActInst = ((HistoricTaskInstanceEntityImpl)historicTask).getCurrentActInst();
        if (WfUtils.isNotEmpty(curActInst) && (isReject = (helper = Context.getProcessEngineConfiguration().getTaskHelper()).isRejectTask(task.getProcessInstanceId(), curActInst, task.getTaskDefinitionKey()))) {
            task.setHandleState("dismissed");
        }
    }

    private void addUserIdentityLink(HistoricIdentityLinkEntity hiIdentityLink, TaskEntity task) {
        Long userId = this.judgeTransferUser(hiIdentityLink.getUserId(), task);
        IdentityLinkEntity identityLink = null;
        if (task != null) {
            identityLink = task.addUserIdentityLink(userId, "participant");
        }
        if (identityLink != null) {
            ILocaleString trustNameFormat;
            identityLink.setOwnerId(hiIdentityLink.getOwnerId());
            identityLink.setDelegateId(hiIdentityLink.getDelegateId());
            identityLink.setDisplay(hiIdentityLink.isDisplay());
            ILocaleString trustName = hiIdentityLink.getTrustName();
            if (!WfUtils.isEmpty(trustName)) {
                identityLink.setTrustName(trustName);
            }
            if (!WfUtils.isEmpty(trustNameFormat = hiIdentityLink.getTrustNameFormat())) {
                identityLink.setTrustNameFormat(trustNameFormat);
            }
            this.getIdentityLinkEntityManager().update((Entity)identityLink);
            HistoricIdentityLinkEntity hiIdentityLinkEntity = (HistoricIdentityLinkEntity)this.getHistoricIdentityLinkEntityManager().findById(identityLink.getId());
            if (hiIdentityLinkEntity != null) {
                ILocaleString hiTrustNameFormat;
                hiIdentityLinkEntity.setOwnerId(identityLink.getOwnerId());
                hiIdentityLinkEntity.setDelegateId(identityLink.getDelegateId());
                hiIdentityLinkEntity.setDisplay(identityLink.isDisplay());
                ILocaleString hiTrustName = identityLink.getTrustName();
                if (!WfUtils.isEmpty(hiTrustName)) {
                    hiIdentityLinkEntity.setTrustName(hiTrustName);
                }
                if (!WfUtils.isEmpty(hiTrustNameFormat = identityLink.getTrustNameFormat())) {
                    hiIdentityLinkEntity.setTrustNameFormat(hiTrustNameFormat);
                }
                this.getHistoricIdentityLinkEntityManager().update((Entity)hiIdentityLinkEntity);
            }
        }
    }

    private Long judgeTransferUser(Long userId, TaskEntity task) {
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext == null || task == null) {
            return userId;
        }
        ExecutionEntity execution = task.getExecution();
        if (execution == null) {
            return userId;
        }
        FlowElement flowElement = execution.getCurrentFlowElement();
        if (flowElement == null) {
            return userId;
        }
        if (BpmnModelUtil.isFirstNodeByModel((FlowNode)((FlowNode)flowElement)) && "UserTask".equalsIgnoreCase(flowElement.getType())) {
            ExecutionEntity executionEntity = task.getExecution();
            if (executionEntity == null) {
                return userId;
            }
            List entities = commandContext.getWorksTransferLogEntityManager().getWorksTransferLog(executionEntity.getRootProcessInstanceId());
            if (WfUtils.isEmptyForCollection(entities)) {
                return userId;
            }
            for (WorksTransferLogEntity entity : entities) {
                if (!userId.equals(entity.getOrigAuditorId())) continue;
                userId = Long.parseLong(((WorksTransferLogEntity)entities.get(0)).getNewAuditorId());
                break;
            }
        }
        return userId;
    }

    public DynamicObjectCollection getToHandleTasksByParticipantIdForMC(String uid, String billType, String entityNumber, int start, int limit, String fiterSql, String showType, List<Object> paramsList, String orderBy) {
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String participantTableAlias = "c";
        String spiltTableAlias = "d";
        String participantMultiLangTableAlias = "cl";
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)ENTITYNAME, (String)ENTITYNAME);
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAME, (String)STARTNAME, (String)STARTNAME);
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSUBJECT, (String)SUBJECT, (String)SUBJECT);
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FNAME, (String)NAME, (String)NAME);
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSENDERNAME, (String)SENDERNAME, (String)SENDERNAME);
        String priorityShowSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)PRIORITYSHOW, (String)ENTITYNAME);
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSENDERNAMEFORMAT, (String)SENDERNAMEFORMAT, (String)SENDERNAMEFORMAT);
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAMEFORMAT, (String)STARTNAMEFORMAT, (String)STARTNAMEFORMAT);
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)participantTableAlias, (String)participantMultiLangTableAlias, (String)FCURRENTSUBJECT, (String)CURRENTSUBJECT, (String)CURRENTSUBJECT);
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)"fsourcename", (String)"sourcename", (String)"sourcename");
        String endType = "";
        if (WfUtils.isNotEmpty(showType)) {
            endType = MOBILE.equals(showType) ? "pc" : MOBILE;
        }
        String s1 = WfUtils.isEmpty(endType) ? " " : " AND a.fendtype != '" + endType + "' ";
        String s2 = WfUtils.isEmpty(entityNumber) ? " " : "and a.fentitynumber = ? ";
        String s4 = WfUtils.isEmpty(billType) ? " " : "and a.fbilltype = ? ";
        String s3 = WfUtils.isEmpty(fiterSql) ? " " : fiterSql;
        String billEntityNumber = WfUtils.isNotEmpty(entityNumber) ? entityNumber : billType;
        JSONObject json = TaskExtendFieldUtil.getTaskBusinessSelectFields((String)this.getEntityName(), (String)billEntityNumber, (String)masterTableAlias, (String)multiLangTableAlias, (String)spiltTableAlias);
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(start + limit).append(" ").append("a.fid id").append(", ").append("a.FHANDLESTATE handlestate").append(", ").append("a.FSUSPENSIONSTATE suspensionstate").append(", ").append(nameSQL).append(", ").append(senderNameSQL).append(", ").append(senderNameFormatSQL).append(", ").append(entityNameSQL).append(", ").append(startNameSQL).append(", ").append(startNameFormatSQL).append(",").append(subjectSQL).append(", ").append(priorityShowSQL).append(", ").append(currentSubjectSQL).append(", ").append(sourceNameSQL).append(", ").append("a.FISACTIVE active").append(", ").append("a.fbillno billno").append(", ").append("a.fprocesstype processtype").append(", ").append("a.FBIZTRACENO biztraceno").append(", ").append("c.FPRIORITY priority").append(", ").append("c.ftype \"type\"").append(", ").append(json.getString("taskBusinessFieldStr")).append("a.fextendformat bizformat").append(", ").append("c.FCREATEDATE createdate").append(" ").append("from t_wf_participant c").append(" ").append("left join t_wf_participant_l cl on c.fid=cl.fid and cl.flocaleid = ?").append(" ").append("left join t_wf_task a on c.ftaskid = a.fid and c.ftaskid>0 and c.fuserid = ? and c.fcompositetaskid = 0 and c.fisdisplay = '1'").append(" ").append("left join t_wf_task_A d on a.fid = d.fid ").append("left join t_wf_task_l b on a.fid=b.fid and b.flocaleid = ?").append(" ").append("where c.ftaskid>0 and c.fuserid = ? and c.fcompositetaskid = 0 and a.FISDISPLAY = '1' and c.fisdisplay = '1' ").append(s1).append(s2).append(s4).append(s3).append(" ").append("order by ");
        if (WfUtils.isNotEmpty(orderBy)) {
            sql.append(orderBy).append(",");
            if (orderBy.contains("fcreatedate")) {
                sql.append(" c.FPRIORITY desc;");
            } else {
                sql.append(" c.FPRIORITY desc, c.FCREATEDATE desc;");
            }
        } else {
            sql.append(" c.FPRIORITY desc, c.FCREATEDATE desc;");
        }
        ArrayList<Object> sqlParams = new ArrayList<Object>();
        String lang = RequestContext.get().getLang().toString();
        if (WfUtils.isEmpty(entityNumber)) {
            sqlParams.addAll(Arrays.asList(lang, Long.valueOf(uid), lang, Long.valueOf(uid)));
        } else {
            sqlParams.addAll(Arrays.asList(lang, Long.valueOf(uid), lang, Long.valueOf(uid), entityNumber));
        }
        if (WfUtils.isNotEmpty(billType)) {
            sqlParams.add(billType);
        }
        if (paramsList != null && paramsList.size() > 0) {
            sqlParams.addAll(paramsList);
        }
        try (DataSet ds = DB.queryDataSet((String)"WfTaskCenter.wf_task.queryMCGridData", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])sqlParams.toArray());){
            DynamicObjectCollection taskDataResultCollection = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            StringBuilder markSql = new StringBuilder();
            markSql.append("select a.ftaskid taskid, b.fnumber name from t_wf_taskmark b inner join t_wf_rtrelation a on b.fid = a.fmarkid ").append("where a.fuserid = ? and a.fruletype != 'folder' order by a.fpriority desc;");
            HashMap markMap = new HashMap();
            try (DataSet markDs = DB.queryDataSet((String)"WfTaskCenter.wf_taskmark.queryGridData", (DBRoute)DBRoute.workflow, (String)markSql.toString(), (Object[])new Object[]{Long.valueOf(uid)});){
                for (Row row : markDs) {
                    Set<String> values;
                    Long taskid = row.getLong(TASKID);
                    String value = row.getString(NAME);
                    if (!WfUtils.isNotEmpty(value)) continue;
                    if (markMap.containsKey(taskid)) {
                        values = (Set)markMap.get(taskid);
                        values.add(value);
                        continue;
                    }
                    values = new LinkedHashSet();
                    values.add(value);
                    markMap.put(taskid, values);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            Map<Long, Set<String>> markValueMap = this.getMarkValueMap();
            boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
            FormatObject formatObject = null;
            for (DynamicObject taskData : taskDataResultCollection) {
                String isActive;
                Long taskid = taskData.getLong("id");
                if (isDisplaySetting && WfUtils.isNotEmpty(taskData.getString(STARTNAMEFORMAT))) {
                    taskData.set(STARTNAME, taskData.get(STARTNAMEFORMAT));
                }
                if (isDisplaySetting && WfUtils.isNotEmpty(taskData.getString(SENDERNAMEFORMAT))) {
                    taskData.set(SENDERNAME, taskData.get(SENDERNAMEFORMAT));
                }
                if (markMap.get(taskid) != null) {
                    Set set = (Set)markMap.get(taskid);
                    if (set.contains("urgency")) {
                        set.remove("important");
                    }
                    Iterator it = set.iterator();
                    StringBuilder str = new StringBuilder();
                    while (it.hasNext()) {
                        str.append(String.valueOf(it.next())).append(",");
                    }
                    String value = str.toString();
                    value = value.length() != 0 ? value.substring(0, value.length() - 1) : "";
                    taskData.set(PRIORITYSHOW, (Object)value);
                } else {
                    Long priority = taskData.getLong("priority");
                    if (null != priority && null != markValueMap && !markValueMap.isEmpty() && markValueMap.get(priority) != null) {
                        taskData.set(PRIORITYSHOW, markValueMap.get(priority));
                    } else {
                        taskData.set(PRIORITYSHOW, (Object)"");
                    }
                }
                Object active = taskData.get(ACTIVE);
                if (active != null && "0".equals(isActive = (String)active)) {
                    taskData.set(HANDLESTATE, (Object)FREEZE);
                }
                String suspensionstate = taskData.getString(SUSPENSIONSTATE);
                if (!ManagementConstants.ACTIVE.getStateCode().equals(suspensionstate)) {
                    taskData.set(HANDLESTATE, (Object)"manualSuspended");
                }
                if (StringUtils.isNotBlank((String)taskData.getString(CURRENTSUBJECT))) {
                    taskData.set(SUBJECT, (Object)taskData.getString(CURRENTSUBJECT));
                }
                if (!WfUtils.isNotEmpty(entityNumber) && !WfUtils.isNotEmpty(billType)) continue;
                if (!json.getJSONObject("fieldRelateFormatField").isEmpty()) {
                    for (Map.Entry property : json.getJSONObject("fieldRelateFormatField").entrySet()) {
                        taskData.set((String)property.getValue(), taskData.get((String)property.getKey()));
                    }
                }
                if (!StringUtils.isNotBlank((String)taskData.getString("bizformat"))) continue;
                if (formatObject == null) {
                    formatObject = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
                }
                TaskExtendFieldUtil.formatTaskBusinessFieldVlue((DynamicObject)taskData, (JSONObject)json.getJSONObject("fieldRelateFormatField"), (FormatObject)formatObject);
            }
            Iterator iterator = taskDataResultCollection;
            return iterator;
        }
    }

    private Map<Long, Set<String>> getMarkValueMap() {
        QFilter[] filters = new QFilter[]{new QFilter("categorynumber", "=", (Object)"priority")};
        Map taskMarkMap = BusinessDataServiceHelper.loadFromCache((String)"wf_taskmark", (String)"number,value", (QFilter[])filters);
        if (null == taskMarkMap || taskMarkMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, Set<String>> markValueMap = new HashMap<Long, Set<String>>(taskMarkMap.size());
        DynamicObject dynObj = null;
        Object value = null;
        Object number = null;
        HashSet<String> numbers = null;
        Set entrySet = taskMarkMap.entrySet();
        Iterator entryIte = entrySet.iterator();
        Map.Entry entry = null;
        while (entryIte.hasNext()) {
            entry = entryIte.next();
            if (null == entry || null == (dynObj = (DynamicObject)entry.getValue()) || null == (value = dynObj.get("value")) || WfUtils.isEmptyString(value) || null == (number = dynObj.get("number")) || WfUtils.isEmptyString(number)) continue;
            numbers = new HashSet<String>();
            numbers.add(number.toString());
            markValueMap.put(Long.valueOf(value.toString()), numbers);
        }
        return markValueMap;
    }

    public DynamicObjectCollection getToHandleTasksByParticipantId(String uid, String billType, String entityNumber, int start, int limit, String fiterSql, String showType, List<Object> paramsList, String orderBy) {
        HashMap<String, String> stateMap = new HashMap<String, String>();
        stateMap.put("dismissed", ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"TaskEntityManagerImpl_1", (String)BOS_WF_ENGINE, (Object[])new Object[0]));
        stateMap.put("willApproval", ResManager.loadKDString((String)"\u5f85\u5ba1\u6279", (String)"TaskEntityManagerImpl_2", (String)BOS_WF_ENGINE, (Object[])new Object[0]));
        stateMap.put(FREEZE, ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3", (String)"TaskEntityManagerImpl_3", (String)BOS_WF_ENGINE, (Object[])new Object[0]));
        stateMap.put("willHandled", ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"TaskEntityManagerImpl_4", (String)BOS_WF_ENGINE, (Object[])new Object[0]));
        String endType = "";
        String lang = RequestContext.get().getLang().toString();
        if (MOBILE.equals(showType)) {
            endType = "pc";
        } else if ("pc".equals(showType)) {
            endType = MOBILE;
        }
        String noCodeFlow = ThreadLocalVariables.get();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String participantTableAlias = "c";
        String participantMultiLangTableAlias = "cl";
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)ENTITYNAME, (String)ENTITYNAME);
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAME, (String)STARTNAME, (String)STARTNAME);
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSUBJECT, (String)SUBJECT, (String)SUBJECT);
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FNAME, (String)NAME, (String)NAME);
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSENDERNAME, (String)SENDERNAME, (String)SENDERNAME);
        String priorityShowSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)PRIORITYSHOW, (String)ENTITYNAME);
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSENDERNAMEFORMAT, (String)SENDERNAMEFORMAT, (String)SENDERNAMEFORMAT);
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAMEFORMAT, (String)STARTNAMEFORMAT, (String)STARTNAMEFORMAT);
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)participantTableAlias, (String)participantMultiLangTableAlias, (String)FCURRENTSUBJECT, (String)CURRENTSUBJECT, (String)CURRENTSUBJECT);
        String sql = "select top " + (start + limit) + A_FID_ID + entityNameSQL + "," + startNameSQL + ",a.FSTARTERID initiatorId," + subjectSQL + "," + A_FHANDLESTATE_HANDLESTATE + A_FSUSPENSIONSTATE_SUSPENSIONSTATE + nameSQL + "," + senderNameSQL + "," + senderNameFormatSQL + "," + startNameFormatSQL + ",a.FCREATEDATE createdate," + A_FISACTIVE_ACTIVE + priorityShowSQL + ",a.fbillno billno,a.FMOBILEFORMKEY mobileformkey,a.fprocessingmobilepage processingmobilepage,a.FPROCESSINGPAGE processingpage,a.FCATEGORY category,c.FPRIORITY priority,a.FBUSINESSKEY businesskey,a.FBUSINESSKEY url,a.FBUSINESSKEY billName,a.FBUSINESSKEY userImgUrl,a.FBUSINESSKEY openId,a.FGROUPNUMBER groupNumber,a.FBUSINESSKEY \"text\",c.ftype \"type\"," + currentSubjectSQL + ",c.FCREATEDATE c_createdate  from t_wf_participant c  left join t_wf_participant_l cl on c.fid=cl.fid and cl.flocaleid = ?  left join t_wf_task a on c.ftaskid = a.fid and c.fuserid = ? and c.ftaskid>0 and c.fcompositetaskid = 0  left join t_wf_task_l b on a.fid=b.fid and b.flocaleid = ?  where c.ftaskid>0 and c.fuserid = ? and c.fcompositetaskid = 0 and a.FISDISPLAY = ? " + (WfUtils.isEmpty(endType) ? "" : "AND a.fendtype != ? ") + " " + (WfUtils.isEmpty(billType) ? "" : "and a.fbilltype = ? ") + " " + (WfUtils.isEmpty(entityNumber) ? "" : "and a.fentitynumber = ?") + " " + (WfUtils.isEmpty(noCodeFlow) ? "" : "and a.fprocesstype = ?") + " " + (WfUtils.isEmpty(fiterSql) ? "" : fiterSql) + " order by " + (WfUtils.isEmpty(orderBy) ? "" : orderBy + ",") + " c.FPRIORITY DESC, c.FCREATEDATE DESC ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(Arrays.asList(lang, Long.valueOf(uid), lang, Long.valueOf(uid), "1"));
        if (WfUtils.isNotEmpty(endType)) {
            params.add(endType);
        }
        if (WfUtils.isNotEmpty(billType)) {
            params.add(billType);
        }
        if (WfUtils.isNotEmpty(entityNumber)) {
            params.add(entityNumber);
        }
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            params.add(noCodeFlow);
        }
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)WF_TASK_CENTER_WF_TASK_QUERY_GRID_DATA, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            Object object;
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            StringBuilder markSql = new StringBuilder();
            markSql.append("select a.ftaskid taskid, b.fnumber name from t_wf_taskmark b inner join t_wf_rtrelation a on b.fid = a.fmarkid ").append("where a.fuserid = ? and a.fruletype != 'folder';");
            Object[] markSqlParams = new Object[]{Long.valueOf(uid)};
            HashMap markMap = new HashMap();
            HashSet<Long> user = new HashSet<Long>();
            for (DynamicObject obc : ret) {
                if (!WfUtils.isNotEmpty(obc.getLong("initiatorId"))) continue;
                user.add(obc.getLong("initiatorId"));
            }
            try {
                DataSet markDs = DB.queryDataSet((String)"WfTaskCenter.wf_taskmark.queryGridData", (DBRoute)DBRoute.workflow, (String)markSql.toString(), (Object[])markSqlParams);
                object = null;
                try {
                    for (Row row : markDs) {
                        Set<String> values;
                        Long taskid = row.getLong(TASKID);
                        String value = row.getString(NAME);
                        if (!WfUtils.isNotEmpty(value)) continue;
                        if (markMap.containsKey(taskid)) {
                            values = (Set)markMap.get(taskid);
                            values.add(value);
                            continue;
                        }
                        values = new HashSet();
                        values.add(value);
                        markMap.put(taskid, values);
                    }
                }
                catch (Throwable iter) {
                    object = iter;
                    throw iter;
                }
                finally {
                    if (markDs != null) {
                        if (object != null) {
                            try {
                                markDs.close();
                            }
                            catch (Throwable iter) {
                                ((Throwable)object).addSuppressed(iter);
                            }
                        } else {
                            markDs.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            Map userInfoMap = ProcessAssistantUtil.queryUserInfo(user, null);
            for (DynamicObject dyObject : ret) {
                String isActive;
                Long taskid = dyObject.getLong("id");
                if (markMap.get(taskid) != null) {
                    dyObject.set(PRIORITYSHOW, markMap.get(taskid));
                } else {
                    dyObject.set(PRIORITYSHOW, (Object)"");
                }
                String category = dyObject.getString("category");
                String pCaption = MessageServiceUtil.getPCCaption((String)dyObject.getString(STARTNAME), (String)dyObject.getString(ENTITYNAME));
                String mCaption = MessageServiceUtil.getMBCaption((String)dyObject.getString(ENTITYNAME));
                String url = MessageServiceUtil.buildWebPageForTaskUrl((String)dyObject.getString("processingpage"), (String)dyObject.getString("processingmobilepage"), (Long)dyObject.getLong("id"), (String)"toHandle", (String)dyObject.getString("businesskey"), (Boolean)(WfUtils.isNotEmpty(category) && BpmnModelUtil.instanceofUserTaskOnly((String)category) ? 1 : 0), (String)pCaption, (String)mCaption);
                dyObject.set("url", (Object)url);
                Object obj = dyObject.get(ACTIVE);
                if (obj != null && "0".equals(isActive = (String)obj)) {
                    dyObject.set(HANDLESTATE, (Object)FREEZE);
                }
                String suspensionstate = dyObject.getString(SUSPENSIONSTATE);
                if (!ManagementConstants.ACTIVE.getStateCode().equals(suspensionstate)) {
                    dyObject.set(HANDLESTATE, (Object)"manualSuspended");
                }
                dyObject.set("billName", (Object)String.format(ResManager.loadKDString((String)"%1$s\u53d1\u8d77\u7684%2$s", (String)"TaskEntityManagerImpl_5", (String)BOS_WF_ENGINE, (Object[])new Object[0]), dyObject.getString(STARTNAME), dyObject.getString(ENTITYNAME)));
                Long startUserId = dyObject.getLong("initiatorId");
                if (WfUtils.isNotEmptyForMap(userInfoMap) && WfUtils.isNotEmpty(startUserId)) {
                    Map userInfo = (Map)userInfoMap.get(startUserId.toString());
                    dyObject.set("userImgUrl", userInfo != null ? userInfo.get("imgUrl") : "");
                    dyObject.set("openId", userInfo != null ? userInfo.get("openId") : "");
                } else {
                    dyObject.set("userImgUrl", (Object)"");
                    dyObject.set("openId", (Object)"");
                }
                String state = dyObject.getString(HANDLESTATE);
                if (WfUtils.isNotEmpty(state) && WfUtils.isNotEmpty((String)stateMap.get(state))) {
                    dyObject.set("text", stateMap.get(state));
                } else {
                    dyObject.set("text", (Object)"");
                }
                if ("coordinate".equals(dyObject.getString("type"))) {
                    dyObject.set(CREATEDATE, dyObject.get("c_createdate"));
                }
                if (!StringUtils.isNotBlank((String)dyObject.getString(CURRENTSUBJECT))) continue;
                dyObject.set(SUBJECT, (Object)dyObject.getString(CURRENTSUBJECT));
            }
            if (WfUtils.isEmpty(orderBy)) {
                Collections.sort(ret, new Comparator<DynamicObject>(){
                    private static final String KEY1 = "priority";
                    private static final String KEY2 = "createdate";

                    @Override
                    public int compare(DynamicObject a, DynamicObject b) {
                        int pB;
                        int pA = a.getInt(KEY1);
                        if (pA > (pB = b.getInt(KEY1))) {
                            return -1;
                        }
                        if (pA < pB) {
                            return 1;
                        }
                        Date valA = a.getDate("createdate");
                        Date valB = b.getDate("createdate");
                        if (valA != null && valB != null) {
                            return valB.compareTo(valA);
                        }
                        return 0;
                    }
                });
            }
            object = ret;
            return object;
        }
    }

    public long getToHandleTasksCountByParticipantId(String uid, String billType, String entityNumber, String filterSql, List<Object> paramsList) {
        String sql = null;
        String entityFilter = "";
        String billFilter = "";
        ArrayList<Object> params = new ArrayList<Object>();
        String noCodeFlow = ThreadLocalVariables.get();
        StringBuilder sb = new StringBuilder();
        if (WfUtils.isEmpty(filterSql)) {
            sb.append("SELECT COUNT(1) count FROM T_WF_TASK A ");
            sb.append("LEFT JOIN T_WF_PARTICIPANT c ON c.FTASKID = A.FID ");
            sb.append("WHERE c.FTASKID>0 AND c.FUSERID = ? and c.fcompositetaskid = 0 AND A.FENDTYPE != 'mobile' AND A.FISDISPLAY = '1' AND c.FISDISPLAY = '1' ");
            if (WfUtils.isNotEmpty(noCodeFlow)) {
                sb.append("and a.fprocesstype = ?");
            }
            sb.append(" %s %s ");
            params.add(Long.valueOf(uid));
            if (WfUtils.isNotEmpty(noCodeFlow)) {
                params.add(ModelType.NoCodeFlow.name());
            }
            if (WfUtils.isNotEmpty(billType)) {
                billFilter = " AND a.fbilltype = ?";
                params.add(billType);
            }
            if (WfUtils.isNotEmpty(entityNumber)) {
                entityFilter = " AND a.FENTITYNUMBER = ?";
                params.add(entityNumber);
            }
            sql = String.format(sb.toString(), entityFilter, billFilter);
        } else {
            sb.append("SELECT COUNT(1) count FROM T_WF_TASK A ");
            sb.append("LEFT JOIN T_WF_TASK_A d on A.fid = d.fid ");
            sb.append("LEFT JOIN T_WF_PARTICIPANT c ON c.FTASKID = A.FID ");
            sb.append("LEFT JOIN T_WF_TASK_L B ON B.FID = A.FID AND B.FLOCALEID = ? ");
            sb.append("WHERE c.FTASKID>0 AND c.FUSERID = ? and c.fcompositetaskid = 0 AND A.FENDTYPE != 'mobile' AND A.FISDISPLAY = '1' AND c.FISDISPLAY = '1' ");
            if (WfUtils.isNotEmpty(noCodeFlow)) {
                sb.append("and a.fprocesstype = ?");
            }
            sb.append(" %s %s %s ");
            params.add(RequestContext.get().getLang().toString());
            params.add(Long.valueOf(uid));
            if (WfUtils.isNotEmpty(noCodeFlow)) {
                params.add(ModelType.NoCodeFlow.name());
            }
            if (WfUtils.isNotEmpty(billType)) {
                billFilter = " AND a.fbilltype = ?";
                params.add(billType);
            }
            if (WfUtils.isNotEmpty(entityNumber)) {
                entityFilter = " AND a.FENTITYNUMBER = ?";
                params.add(entityNumber);
            }
            sql = String.format(sb.toString(), entityFilter, billFilter, filterSql);
        }
        if (paramsList != null && paramsList.size() > 0) {
            params.addAll(paramsList);
        }
        long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)"WFTASK.TasksCount", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getLong(COUNT);
            }
        }
        return count;
    }

    public DynamicObjectCollection getToHandleTaskByFolderId(long folderId, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        filterSql = this.handleFilterSql(filterSql, "e.fpriority");
        String lang = RequestContext.get().getLang().toString();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String participantTableAlias = "c";
        String participantMultiLangTableAlias = "cl";
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)ENTITYNAME, (String)ENTITYNAME);
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAME, (String)STARTNAME, (String)STARTNAME);
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSUBJECT, (String)"SUBJECT", (String)SUBJECT);
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FNAME, (String)"NAME", (String)NAME);
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSENDERNAME, (String)SENDERNAME, (String)SENDERNAME);
        String priorityShowSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)PRIORITYSHOW, (String)ENTITYNAME);
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSENDERNAMEFORMAT, (String)SENDERNAMEFORMAT, (String)SENDERNAMEFORMAT);
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAMEFORMAT, (String)STARTNAMEFORMAT, (String)STARTNAMEFORMAT);
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_ruletaskrelation", (String)participantTableAlias, (String)participantMultiLangTableAlias, (String)FCURRENTSUBJECT, (String)CURRENTSUBJECT, (String)CURRENTSUBJECT);
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)"fsourcename", (String)"sourcename", (String)"sourcename");
        String sql = SELECT_TOP + (start + limit) + A_FID_ID + entityNameSQL + "," + startNameSQL + "," + subjectSQL + "," + A_FHANDLESTATE_HANDLESTATE + A_FSUSPENSIONSTATE_SUSPENSIONSTATE + nameSQL + "," + senderNameSQL + "," + senderNameFormatSQL + "," + startNameFormatSQL + ",a.FcreateDate createdate," + A_FISACTIVE_ACTIVE + "e.FPRIORITY," + priorityShowSQL + ",a.fbillno billno, a.fprocesstype processtype, " + sourceNameSQL + ", " + currentSubjectSQL + " " + FROM + T_WF_TASK_A + "LEFT JOIN t_wf_task_l b ON a.fid = b.fid AND a.FISDISPLAY = '1' AND a.fendtype != 'mobile' and b.FLOCALEID = ? INNER JOIN t_wf_rtrelation c ON a.fid = c.ftaskid LEFT JOIN t_wf_rtrelation e ON a.fid = e.ftaskid And e.FRULETYPE = 'priority' AND e.FUSERID = ? LEFT JOIN t_wf_rtrelation_l cl on e.fid = cl.fid and cl.FLOCALEID = ? LEFT JOIN t_wf_participant p ON a.FID = p.FTASKID " + WHERE + "a.FISDISPLAY = '1' and a.fendtype != 'mobile' and c.FRULEID = ? AND p.ftaskid>0 AND p.fuserid= ? AND p.fcompositetaskid = 0 AND p.fisdisplay = '1' " + (WfUtils.isEmpty(filterSql) ? " " : filterSql) + "ORDER BY " + (WfUtils.isEmpty(orderBy) ? "" : orderBy + ",") + "p.FPRIORITY DESC,a.FcreateDate DESC";
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(Arrays.asList(lang, userId, lang, folderId, userId));
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)WF_TASK_CENTER_CUSTOM_QUERY_GRID_DATA, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            String markSql = "select a.ftaskid taskid,b.fnumber name from t_wf_rtrelation a INNER JOIN t_wf_taskmark b ON a.FMARKID = b.fid and a.fruletype != 'folder'where a.ftaskid in (select distinct ftaskid taskid from t_wf_rtrelation c where c.FRULEID = ?) and a.fuserid = ? order by a.fpriority desc;";
            Object[] markSqlParams = new Object[]{folderId, userId};
            HashMap<Long, Set<String>> markMap = new HashMap<Long, Set<String>>();
            try (DataSet markSqlDs = DB.queryDataSet((String)WF_TASK_CENTER_CUSTOM_QUERY_GRID_DATA, (DBRoute)DBRoute.workflow, (String)markSql, (Object[])markSqlParams);){
                for (Row row : markSqlDs) {
                    boolean participant;
                    String value;
                    Set<String> values;
                    Long taskid = row.getLong(TASKID);
                    if (markMap.containsKey(taskid)) {
                        values = (Set)markMap.get(taskid);
                        values.add(row.getString(NAME));
                    } else {
                        values = new LinkedHashSet();
                        values.add(row.getString(NAME));
                        markMap.put(taskid, values);
                    }
                    if (!WfUtils.isNotEmpty(value = row.getString(NAME)) || "coordinate".equals(value) && !(participant = CoordinateRecordUtil.isParticipant(taskid, RequestContext.get().getUserId(), "coordinate"))) continue;
                    if (CollectionUtils.isEmpty((Collection)((Collection)markMap.get(taskid)))) {
                        HashSet<String> values2 = new HashSet<String>();
                        values2.add(value);
                        markMap.put(taskid, values2);
                        continue;
                    }
                    Set values3 = (Set)markMap.get(taskid);
                    values3.add(value);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            this.specialHandleProperties(ret, markMap, "folder");
            DynamicObjectCollection dynamicObjectCollection = ret;
            return dynamicObjectCollection;
        }
    }

    public long getToHandleTaskCountByFolderId(long folderId, String filterSql, List<Object> paramsList) {
        String lang = RequestContext.get().getLang().toString();
        String userId = RequestContext.get().getUserId();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(*) count FROM t_wf_task a ");
        sql.append("LEFT JOIN t_wf_task_l b ON a.fid = b.FID and b.FLOCALEID = ? ");
        sql.append("LEFT JOIN t_wf_participant p ON a.FID = p.FTASKID ");
        sql.append("INNER JOIN t_wf_rtrelation c ON a.fid = c.FTASKID and p.fuserid = c.fuserid ");
        sql.append("WHERE c.FRULEID = ? AND a.fendtype != 'mobile' AND a.FISDISPLAY = '1' ");
        sql.append("AND p.ftaskid>0 AND p.fuserid= ? AND p.fcompositetaskid = 0 AND p.fisdisplay = '1' ");
        sql.append(WfUtils.isEmpty(filterSql) ? " " : filterSql);
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(Arrays.asList(lang, folderId, Long.valueOf(userId)));
        params.addAll(paramsList);
        long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)WF_TASK_CENTER_CUSTOM_QUERY_GRID_DATA, (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getLong(COUNT);
            }
        }
        return count;
    }

    public DynamicObjectCollection getTransferToHandleTask(String uid, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)ENTITYNAME, (String)ENTITYNAME);
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAME, (String)STARTNAME, (String)STARTNAME);
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSUBJECT, (String)"SUBJECT", (String)SUBJECT);
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FNAME, (String)"NAME", (String)NAME);
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_taskhandlelog", (String)"c", (String)"cl", (String)"fassignee", (String)SENDERNAME, (String)"assignee");
        String priorityShowSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)PRIORITYSHOW, (String)ENTITYNAME);
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_taskhandlelog", (String)"c", (String)"cl", (String)"fassigneeformat", (String)SENDERNAMEFORMAT, (String)SENDERNAMEFORMAT);
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAMEFORMAT, (String)STARTNAMEFORMAT, (String)STARTNAMEFORMAT);
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)"c", (String)"cl", (String)FCURRENTSUBJECT, (String)CURRENTSUBJECT, (String)CURRENTSUBJECT);
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)"fsourcename", (String)"sourcename", (String)"sourcename");
        String sql = SELECT_TOP + (start + limit) + A_FID_ID + entityNameSQL + "," + startNameSQL + "," + subjectSQL + "," + A_FHANDLESTATE_HANDLESTATE + A_FSUSPENSIONSTATE_SUSPENSIONSTATE + nameSQL + "," + senderNameSQL + "," + senderNameFormatSQL + "," + startNameFormatSQL + ",c.FcreateDate createdate,p.FPRIORITY," + A_FISACTIVE_ACTIVE + priorityShowSQL + ",a.fbillno billno, " + sourceNameSQL + "," + currentSubjectSQL + ",a.fcreatedate " + FROM + T_WF_TASK_A + "LEFT JOIN t_wf_task_l b ON a.fid = b.fid and b.FLOCALEID = ? LEFT JOIN t_wf_taskhandlelog c ON a.fid = c.ftaskid AND c.ftype = 'transfer' AND c.fisadminforward = '0' LEFT JOIN t_wf_taskhandlelog_l cl ON c.fid = cl.fid AND cl.FLOCALEID = ?  LEFT JOIN t_wf_rtrelation d ON a.fid = d.ftaskid And d.FRULETYPE = 'priority' AND d.FUSERID = ? LEFT JOIN t_wf_participant p on a.FID = p.FTASKID " + WHERE + "c.FOWNERID = ? and p.ftaskid>0 and p.fcompositetaskid = 0 and a.FISDISPLAY = '1' and a.fendtype != 'mobile' and a.fprocesstype != ? " + (WfUtils.isEmpty(filterSql) ? " " : filterSql) + " ORDER BY ";
        sql = WfUtils.isEmpty(orderBy) ? sql + " a.fid desc;" : (orderBy.contains("fid") ? sql + orderBy + ";" : sql + orderBy + ", a.fid desc;");
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(Arrays.asList(lang, lang, Long.parseLong(uid), Long.parseLong(uid)));
        params.add(ModelType.NoCodeFlow.name());
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)WF_TASK_CENTER_CUSTOM_QUERY_GRID_DATA, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            String markSql = "select a.ftaskid taskid,b.fnumber name from t_wf_rtrelation a INNER JOIN t_wf_taskmark b ON a.FMARKID = b.fid and a.fruletype != 'folder' and a.fruletype != 'pass' and a.fruletype != 'priority' where a.ftaskid in (select distinct ftaskid taskid from t_wf_taskhandlelog c where c.FOWNERID = ?  AND c.fisadminforward = '0') and a.FUSERID = ? order by a.fpriority desc;";
            Object[] markSqlParams = new Object[]{Long.parseLong(uid), Long.parseLong(uid)};
            HashMap<Long, Set<String>> markMap = new HashMap<Long, Set<String>>();
            try (DataSet markSqlDs = DB.queryDataSet((String)WF_TASK_CENTER_CUSTOM_QUERY_GRID_DATA, (DBRoute)DBRoute.workflow, (String)markSql, (Object[])markSqlParams);){
                for (Row row : markSqlDs) {
                    Set<String> values;
                    String value;
                    Set<String> values2;
                    Long taskid = row.getLong(TASKID);
                    if (markMap.containsKey(taskid)) {
                        values2 = (Set)markMap.get(taskid);
                        values2.add(row.getString(NAME));
                    } else {
                        values2 = new LinkedHashSet();
                        values2.add(row.getString(NAME));
                        markMap.put(taskid, values2);
                    }
                    if (!WfUtils.isNotEmpty(value = row.getString(NAME))) continue;
                    if (markMap.containsKey(taskid)) {
                        values = (Set)markMap.get(taskid);
                        values.add(value);
                        continue;
                    }
                    values = new HashSet();
                    values.add(value);
                    markMap.put(taskid, values);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            this.specialHandleProperties(ret, markMap, "transfer");
            if (ret == null || ret.size() == 0) {
                DynamicObjectCollection e = ret;
                return e;
            }
            DynamicObjectCollection col = new DynamicObjectCollection();
            HashMap<Long, Integer> p = new HashMap<Long, Integer>();
            boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
            for (int i = 0; i < ret.size(); ++i) {
                DynamicObject dyObject = (DynamicObject)ret.get(i);
                Long taskId = dyObject.getLong("id");
                String senderNameFormat = dyObject.getString(SENDERNAMEFORMAT);
                String startNameFormat = dyObject.getString(STARTNAMEFORMAT);
                if (isDisplaySetting && WfUtils.isNotEmpty(senderNameFormat)) {
                    dyObject.set(SENDERNAME, (Object)senderNameFormat);
                }
                if (isDisplaySetting && WfUtils.isNotEmpty(startNameFormat)) {
                    dyObject.set(STARTNAME, (Object)startNameFormat);
                }
                if (p.containsKey(taskId)) {
                    int index;
                    Date dateInMap;
                    Date dateOfCurrent = dyObject.getDate(CREATEDATE);
                    if (dateOfCurrent.after(dateInMap = ((DynamicObject)col.get(index = ((Integer)p.get(taskId)).intValue())).getDate(CREATEDATE))) {
                        col.remove(index);
                        col.add((Object)dyObject);
                    }
                } else {
                    col.add((Object)dyObject);
                    p.put(taskId, col.size() - 1);
                }
                if (!StringUtils.isNotBlank((String)dyObject.getString(CURRENTSUBJECT))) continue;
                dyObject.set(SUBJECT, (Object)dyObject.getString(CURRENTSUBJECT));
            }
            DynamicObjectCollection dynamicObjectCollection = col;
            return dynamicObjectCollection;
        }
    }

    public int getTransferToHandleTaskCount(String uid, String filterSql, List<Object> paramsList) {
        filterSql = this.handleFilterSql(filterSql, "p.fpriority");
        String lang = RequestContext.get().getLang().toString();
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fid id from t_wf_task a ");
        sql.append("left join t_wf_task_l b on a.fid= b.fid and b.FLOCALEID = ?");
        sql.append("left join t_wf_taskhandlelog c ON a.fid = c.ftaskid AND c.ftype = 'transfer' AND c.fisadminforward = '0' ");
        sql.append("left join t_wf_participant p on a.fid = p.ftaskid ");
        sql.append("WHERE c.FOWNERID = ? ");
        sql.append("and a.fendtype != 'mobile' AND p.ftaskid>0 and p.fcompositetaskid = 0 AND a.FISDISPLAY = '1' and a.fprocesstype != ? ");
        sql.append(WfUtils.isEmpty(filterSql) ? " " : filterSql);
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(Arrays.asList(lang, Long.valueOf(uid)));
        params.add(ModelType.NoCodeFlow.name());
        params.addAll(paramsList);
        HashSet<Long> idSet = new HashSet<Long>();
        try (DataSet ds = DB.queryDataSet((String)"wf_toHandle_transfer_count", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());){
            for (Row row : ds) {
                idSet.add(row.getLong("id"));
            }
        }
        return idSet.size();
    }

    public DynamicObjectCollection getDelegateToHandleTask(String userId, int start, int limit, String filterSql, List<Object> paramsList, String orderBy) {
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)ENTITYNAME, (String)ENTITYNAME);
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAME, (String)STARTNAME, (String)STARTNAME);
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSUBJECT, (String)SUBJECT, (String)SUBJECT);
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FNAME, (String)NAME, (String)NAME);
        String trusteeNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)"p", (String)"pl", (String)"fusername", (String)"trustee", (String)"username");
        String priorityShowSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)PRIORITYSHOW, (String)ENTITYNAME);
        String userNameFormatSql = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)"p", (String)"pl", (String)"fusernameformatter", (String)"usernameformatter", (String)"usernameformatter");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAMEFORMAT, (String)STARTNAMEFORMAT, (String)STARTNAMEFORMAT);
        String sourceNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)"fsourcename", (String)"sourcename", (String)"sourcename");
        StringBuilder sql = new StringBuilder();
        sql.append("select top ").append(start + limit).append(" a.fid id,a.fbillno billno,").append(entityNameSQL).append(",").append(startNameSQL).append(",");
        sql.append(subjectSQL).append(",").append(startNameFormatSQL).append(",").append(userNameFormatSql).append(",").append("a.fhandlestate handlestate,a.fsuspensionstate suspensionstate,").append(nameSQL).append(",");
        sql.append(trusteeNameSQL).append(",").append(sourceNameSQL).append(",").append("p.fcreatedate delegatetime,p.fcreatedate createdate,a.fisactive active,").append(priorityShowSQL);
        sql.append(" from t_wf_task a left join t_wf_task_l b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("left join t_wf_participant p on a.fid = p.ftaskid ");
        sql.append("left join t_wf_participant_l pl on pl.fid = p.fid and pl.flocaleid = ? ");
        sql.append("where a.fisdisplay = '1' and a.fendtype != 'mobile' and b.flocaleid = ? and pl.flocaleid = ? ");
        sql.append("and p.fownerid = ? and p.fcompositetaskid = 0 and p.fdelegateid != 0 and a.fprocesstype != ? ");
        if (!WfUtils.isEmpty(filterSql)) {
            sql.append(filterSql);
        }
        if (!WfUtils.isEmpty(orderBy)) {
            sql.append(" order by ").append(orderBy);
        } else {
            sql.append(" order by ").append(" p.fcreatedate desc ");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        String lang = RequestContext.get().getLang().toString();
        Long userid = Long.valueOf(userId);
        params.add(lang);
        params.add(lang);
        params.add(lang);
        params.add(lang);
        params.add(userid);
        params.add(ModelType.NoCodeFlow.name());
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            HashMap<Long, Set<String>> markMap = new HashMap<Long, Set<String>>();
            this.handleTaskMarkForDelegate(userid, markMap);
            this.specialHandleProperties(ret, markMap, "delegate");
            DynamicObjectCollection dynamicObjectCollection = ret;
            return dynamicObjectCollection;
        }
    }

    private void handleTaskMarkForDelegate(Long userid, Map<Long, Set<String>> markMap) {
        StringBuilder markSql = new StringBuilder();
        markSql.append("select a.ftaskid taskid, b.fnumber name from t_wf_rtrelation a ");
        markSql.append("inner join t_wf_taskmark b on a.fmarkid = b.fid ");
        markSql.append("where a.fuserid = ? and a.fruletype != 'folder' and a.fruletype != 'delegate' and a.fruletype != 'priority' order by a.fpriority desc;");
        try (DataSet markDs = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)markSql.toString(), (Object[])new Object[]{userid});){
            for (Row row : markDs) {
                Set<Object> values;
                Long taskid = row.getLong(TASKID);
                String value = row.getString(NAME);
                if (!WfUtils.isNotEmpty(value)) continue;
                if (markMap.containsKey(taskid)) {
                    values = markMap.get(taskid);
                    values.add(value);
                    continue;
                }
                values = new LinkedHashSet();
                values.add(value);
                markMap.put(taskid, values);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void specialHandleProperties(DynamicObjectCollection ret, Map<Long, Set<String>> markMap, String key) {
        boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        for (DynamicObject dyObject : ret) {
            String isActive;
            Long taskid = dyObject.getLong("id");
            if (CollectionUtils.isNotEmpty((Collection)markMap.get(taskid))) {
                Set<String> values = markMap.get(taskid);
                if (values.contains("urgency")) {
                    values.remove("important");
                }
                String valueStr = StringUtils.join(values, (String)",");
                dyObject.set(PRIORITYSHOW, (Object)valueStr);
            } else {
                dyObject.set(PRIORITYSHOW, (Object)"");
            }
            Object obj = dyObject.get(ACTIVE);
            if (obj != null && "0".equals(isActive = (String)obj)) {
                dyObject.set(HANDLESTATE, (Object)FREEZE);
            }
            if (dyObject != null && isDisplaySetting && WfUtils.isNotEmpty(dyObject.getString(STARTNAMEFORMAT))) {
                dyObject.set(STARTNAME, (Object)dyObject.getString(STARTNAMEFORMAT));
            }
            if ("delegate".equals(key) && isDisplaySetting && WfUtils.isNotEmpty(dyObject.getString("usernameformatter")) && !"false".equals(dyObject.getString("usernameformatter"))) {
                dyObject.set("trustee", (Object)dyObject.getString("usernameformatter"));
            }
            if (("folder".equals(key) || "transfer".equals(key)) && isDisplaySetting && WfUtils.isNotEmpty(dyObject.getString(SENDERNAMEFORMAT)) && !"false".equals(dyObject.getString(SENDERNAMEFORMAT))) {
                dyObject.set(SENDERNAME, (Object)dyObject.getString(SENDERNAMEFORMAT));
            }
            String suspensionstate = dyObject.getString(SUSPENSIONSTATE);
            if (!ManagementConstants.ACTIVE.getStateCode().equals(suspensionstate)) {
                dyObject.set(HANDLESTATE, (Object)"manualSuspended");
            }
            if (!"folder".equals(key) || !StringUtils.isNotBlank((String)dyObject.getString(CURRENTSUBJECT))) continue;
            dyObject.set(SUBJECT, (Object)dyObject.getString(CURRENTSUBJECT));
        }
    }

    public int getDelegateToHandleTaskCount(String userId, String filterSql, List<Object> paramsList) {
        filterSql = this.handleFilterSql(filterSql, "p.fpriority");
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count from t_wf_task a ");
        sql.append("left join t_wf_task_l b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append("left join t_wf_participant p on a.fid = p.ftaskid ");
        sql.append("left join t_wf_participant_l pl on pl.fid = p.fid  and pl.flocaleid = ? ");
        sql.append("where a.fisdisplay = '1' and a.fendtype != 'mobile' and b.flocaleid = ? and pl.flocaleid = ? ");
        sql.append("and p.fownerid = ? and p.fcompositetaskid = 0 and p.fdelegateid != 0 and a.fprocesstype != ? ");
        if (!WfUtils.isEmpty(filterSql)) {
            sql.append(filterSql);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        String lang = RequestContext.get().getLang().toString();
        params.add(lang);
        params.add(lang);
        params.add(lang);
        params.add(lang);
        params.add(Long.valueOf(userId));
        params.add(ModelType.NoCodeFlow.name());
        params.addAll(paramsList);
        int count = 0;
        try (DataSet ds = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getInteger(COUNT);
            }
        }
        return count;
    }

    public Long findTaskIdByBusinessKeyAndUserId(String businessKey, Long userId) {
        String taskSql = "select fid from t_wf_task where fbusinesskey = ? ";
        StringBuilder sb = new StringBuilder("(");
        Object[] taskParams = new Object[]{businessKey};
        try (DataSet ds = DB.queryDataSet((String)"WFTASK.findTaskIdByBusinessKeyAndUserId", (DBRoute)DBRoute.workflow, (String)taskSql, (Object[])taskParams);){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                sb.append(((Row)iter.next()).get("fid"));
                sb.append(",");
            }
        }
        if (sb.length() > 1) {
            sb.setCharAt(sb.length() - 1, ')');
            StringBuilder participantSql = new StringBuilder();
            participantSql.append("select ftaskid from t_wf_participant where ftaskid in ").append((CharSequence)sb).append(" and fuserid = ? ");
            Object[] participantParams = new Object[]{userId};
            try (DataSet ds = DB.queryDataSet((String)"WFTASK.findTaskIdByBusinessKeyAndUserId", (DBRoute)DBRoute.workflow, (String)participantSql.toString(), (Object[])participantParams);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    Long l = ((Row)iter.next()).getLong("ftaskid");
                    return l;
                }
            }
        }
        return 0L;
    }

    public Long findTaskIdByProcessInstanceIdAndActivityIdAndUserId(Long processInstanceId, String activityId, Long userId) {
        Long taskId = 0L;
        String sql = "select t.fid from t_wf_task t left join t_wf_participant p on t.fid = p.ftaskid where t.fprocinstid = ? and t.ftaskdefid = ? and t.fisdisplay = '1' and p.fuserid = ? ";
        Object[] params = new Object[]{processInstanceId, activityId, userId};
        try (DataSet ds = DB.queryDataSet((String)WfUtils.createAlgoKey("TaskEntityManagerImpl"), (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Iterator iterator = ds.iterator();
            if (iterator.hasNext()) {
                taskId = ((Row)iterator.next()).getLong("fid");
            }
            Long l = taskId;
            return l;
        }
    }

    public DynamicObjectCollection getTasksForMsgByUid(Long userId, Integer topCount) {
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String participantTableAlias = "c";
        String participantMultiLangTableAlias = "d";
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)ENTITYNAME, (String)ENTITYNAME);
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAME, (String)STARTNAME, (String)STARTNAME);
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)"FSUBJECT", (String)SUBJECT, (String)SUBJECT);
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)participantTableAlias, (String)participantMultiLangTableAlias, (String)FCURRENTSUBJECT, (String)CURRENTSUBJECT, (String)CURRENTSUBJECT);
        String sql = SELECT_TOP + topCount + A_FID_ID + entityNameSQL + "," + startNameSQL + "," + A_FHANDLESTATE_HANDLESTATE + "a.FcreateDate createdate," + subjectSQL + "," + currentSubjectSQL + " " + FROM + T_WF_TASK_A + "LEFT JOIN t_wf_task_l b ON a.fid = b.fid INNER JOIN t_wf_participant c ON a.fid = c.ftaskid INNER JOIN t_wf_participant_l d on c.fid=d.fid and d.FLOCALEID = ? " + WHERE + "c.fuserid = ? AND a.FISDISPLAY = '1' AND b.FLOCALEID = ? AND a.fendtype != 'mobile' ORDER BY a.FCREATEDATE DESC";
        try (DataSet ds = DB.queryDataSet((String)WF_TASK_CENTER_WF_TASK_QUERY_GRID_DATA, (DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{RequestContext.get().getLang().toString(), userId, RequestContext.get().getLang().toString()});){
            DynamicObjectCollection taskResultCollection = null;
            if (ds == null) {
                DynamicObjectCollection dynamicObjectCollection = taskResultCollection;
                return dynamicObjectCollection;
            }
            taskResultCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            for (DynamicObject dyObject : taskResultCollection) {
                if (!StringUtils.isNotBlank((String)dyObject.getString(CURRENTSUBJECT))) continue;
                dyObject.set(SUBJECT, (Object)dyObject.getString(CURRENTSUBJECT));
            }
            Iterator iterator = taskResultCollection;
            return iterator;
        }
    }

    public DynamicObjectCollection getToHandleTasks(int start, int limit, String filterSql, List<Object> paramsList, String orderBy, boolean isAuditFlow) {
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)ENTITYNAME, (String)ENTITYNAME);
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)"fstartname", (String)STARTNAME, (String)STARTNAME);
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSUBJECT, (String)SUBJECT, (String)SUBJECT);
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FNAME, (String)NAME, (String)NAME);
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSENDERNAME, (String)SENDERNAME, (String)SENDERNAME);
        String priorityShowSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)PRIORITYSHOW, (String)ENTITYNAME);
        String participantNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)"fparticipantname", (String)"participantname", (String)"participantname");
        String startNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAMEFORMAT, (String)STARTNAMEFORMAT, (String)STARTNAMEFORMAT);
        String senderNameFormatSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSENDERNAMEFORMAT, (String)SENDERNAMEFORMAT, (String)SENDERNAMEFORMAT);
        StringBuilder sql = new StringBuilder("select distinct top ").append(start + limit);
        sql.append(A_FID_ID).append(entityNameSQL).append(',').append(startNameSQL).append(',').append(startNameFormatSQL).append(',').append(senderNameFormatSQL).append(',').append(subjectSQL).append(',');
        sql.append("a.fhandlestate handlestate,").append("a.fsuspensionstate suspensionstate,").append(nameSQL).append(',').append(senderNameSQL);
        sql.append(",a.fcreatedate createdate,a.fisactive active,");
        sql.append(priorityShowSQL).append(",a.fbillno billno,a.fmobileformkey mobileformkey,a.fprocessingmobilepage processingmobilepage,");
        sql.append("a.fprocessingpage processingpage,a.ftaskdefid taskdefinitionkey,a.fbusinesskey businesskey,a.fbusinesskey url,");
        if (WfUtils.isNotEmpty(orderBy) && orderBy.contains("c.fcreatedate")) {
            sql = new StringBuilder(sql.toString().replace("a.fcreatedate", "c.fcreatedate"));
        }
        sql.append(participantNameSQL);
        sql.append(FROM_T_WF_TASK_A);
        sql.append(" left join t_wf_task_l b on a.fid=b.fid and b.flocaleid = ?");
        sql.append(" left join t_wf_participant c on a.fid=c.ftaskid");
        sql.append(" where  c.ftype = 'participant' ");
        if (!filterSql.contains("a.fprocesstype")) {
            if (isAuditFlow) {
                sql.append(String.format("and a.fprocessType = '%s' ", ModelType.AuditFlow.name()));
            } else {
                sql.append(String.format("and a.fprocessType != '%s' and a.fprocessType != ' ' ", ModelType.NoCodeFlow.name()));
            }
        }
        sql.append(WfUtils.isEmpty(filterSql) ? " " : filterSql);
        if (orderBy == null || orderBy.equals("")) {
            sql.append(" order by a.fcreatedate desc ");
        } else {
            sql.append(" order by ").append(orderBy);
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(lang);
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)WF_TASK_CENTER_WF_TASK_QUERY_GRID_DATA, (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            boolean isDisplaySetting = WfConfigurationUtil.isDisplaySetting();
            for (DynamicObject object : ret) {
                String isActive;
                Object obj = object.get(ACTIVE);
                if (obj != null && "0".equals(isActive = (String)obj)) {
                    object.set(HANDLESTATE, (Object)FREEZE);
                }
                String suspensionstate = object.getString(SUSPENSIONSTATE);
                if (!ManagementConstants.ACTIVE.getStateCode().equals(suspensionstate)) {
                    object.set(HANDLESTATE, (Object)"manualSuspended");
                }
                if (object != null && isDisplaySetting && WfUtils.isNotEmpty(object.getString(SENDERNAMEFORMAT))) {
                    object.set(SENDERNAME, (Object)object.getString(SENDERNAMEFORMAT));
                }
                if (object == null || !isDisplaySetting || !WfUtils.isNotEmpty(object.getString(STARTNAMEFORMAT))) continue;
                object.set(STARTNAME, (Object)object.getString(STARTNAMEFORMAT));
            }
            Iterator iterator = ret;
            return iterator;
        }
    }

    public long getToHandleTasksCount(String filterSql, List<Object> paramsList, boolean isAuditFlow) {
        long count = 0L;
        String lang = RequestContext.get().getLang().toString();
        StringBuilder sql = new StringBuilder("select count(DISTINCT a.fid)  as num ");
        sql.append(FROM_T_WF_TASK_A);
        sql.append(" left join t_wf_task_l b on a.fid=b.fid and b.flocaleid = ?");
        sql.append(" left join t_wf_participant c on a.fid=c.ftaskid");
        sql.append(" where  a.fendtype != 'mobile' and c.ftype = 'participant' ");
        if (!filterSql.contains("a.fprocesstype")) {
            if (isAuditFlow) {
                sql.append(String.format("and a.fprocessType = '%s' ", ModelType.AuditFlow.name()));
            } else {
                sql.append(String.format("and a.fprocessType != '%s' and a.fprocessType != ' ' ", ModelType.NoCodeFlow.name()));
            }
        }
        sql.append(WfUtils.isEmpty(filterSql) ? " " : filterSql);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(lang);
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)WF_TASK_CENTER_WF_TASK_QUERY_GRID_DATA, (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            while (iter.hasNext()) {
                count = ((Row)iter.next()).getLong("num");
            }
        }
        return count;
    }

    public DynamicObjectCollection findTaskCategorysByTaskIds(Long[] taskIds) {
        return QueryServiceHelper.query((String)"wf_task", (String)"id, category, executionType, taskdefinitionkey, processinstanceid, processingpage", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)taskIds)});
    }

    public List<Map<String, Object>> getEntityByUser(Long uid) {
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)"a", (String)"b", (String)FENTITY_NAME, (String)ENTITYNAME, (String)ENTITYNAME);
        String sql = "select distinct " + entityNameSQL + ",a.fbilltype billtype, a.FENTITYNUMBER entitynumber, a.fbusinesskey businesskey from t_wf_task a  INNER JOIN t_wf_task_l b on a.fid=b.fid  INNER JOIN t_wf_participant on a.fid=t_wf_participant.ftaskid where t_wf_participant.fuserid = ? and a.FISDISPLAY = ? AND a.fendtype != 'pc' AND b.FLOCALEID =? ";
        Object[] params = new Object[]{uid, "1", RequestContext.get().getLang().toString()};
        List<Map<String, Object>> entityMap = WfUtils.getEntityProperties(sql, params);
        return entityMap;
    }

    public Map<String, Map<String, Object>> findTasksByProInstIdAndUserId(Long procInstId, String userIds) {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        if (WfUtils.isEmpty(userIds)) {
            return result;
        }
        String sql = "select t.FID taskId, t.FTASKDEFID actId, p.FID partId, p.FUSERID userId from t_wf_task t LEFT JOIN t_wf_participant p ON t.fid = p.FTASKID where t.FPROCINSTID = ? and t.FISDISPLAY = '1' AND p.FUSERID in " + userIds + " AND p.fcompositetaskid = 0 AND t.fcategory = 'AuditTask' AND p.fdelegateid = 0";
        Object[] params = new Object[]{procInstId};
        try (DataSet ds = DB.queryDataSet((String)"wf_task.XXX", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params);){
            Iterator iter = ds.iterator();
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            while (iter.hasNext()) {
                Row r = (Row)iter.next();
                tmp.put("taskId", r.get("taskId"));
                tmp.put("actId", r.get("actId"));
                tmp.put("partId", r.get("partId"));
                tmp.put(USER_ID, r.get(USER_ID));
                result.put(String.valueOf(r.get(USER_ID)), tmp);
            }
            HashMap<String, Map<String, Object>> hashMap = result;
            return hashMap;
        }
    }

    public void updateYzjTaskMemberInfoVariables(CommandContext commandContext, TaskEntity task, Object ownerId, Object transferId) {
        if (!YUNZHIJIATASK.equals(task.getCategory())) {
            return;
        }
        ArrayList<Object> parentTaskParticipantName = new ArrayList<Object>(10);
        ArrayList<Object> parentTaskParticipantNameFormat = new ArrayList<Object>(10);
        IdentityLinkEntityManager identityLinkEntityManager = commandContext.getIdentityLinkEntityManager();
        List parentTaskAllParticipants = identityLinkEntityManager.findIdentityLinksByParentTaskId(task.getParentTaskId(), task.getProcessInstanceId(), " ");
        HashMap<Long, IdentityLinkEntity> participantMap = new HashMap<Long, IdentityLinkEntity>(16);
        ArrayList<IdentityLinkEntity> participantList = new ArrayList<IdentityLinkEntity>(10);
        ArrayList<IdentityLinkEntity> trusteeList = new ArrayList<IdentityLinkEntity>(10);
        for (IdentityLinkEntity parentTaskAllParticipant : parentTaskAllParticipants) {
            Iterator type = parentTaskAllParticipant.getType();
            Long delegateId = parentTaskAllParticipant.getDelegateId();
            if (!"participant".equals(type)) continue;
            if (WfUtils.isEmpty(delegateId)) {
                participantMap.put(parentTaskAllParticipant.getUserId(), parentTaskAllParticipant);
                participantList.add(parentTaskAllParticipant);
                continue;
            }
            trusteeList.add(parentTaskAllParticipant);
        }
        ArrayList<Long> ownerIds = new ArrayList<Long>(10);
        ILocaleString delegate = WFMultiLangConstants.getDelegateLocaleString();
        for (IdentityLinkEntity trustee : trusteeList) {
            Long trusteeOwnerId = trustee.getOwnerId();
            ownerIds.add(trusteeOwnerId);
            IdentityLinkEntity participant = (IdentityLinkEntity)participantMap.get(trusteeOwnerId);
            ILocaleString trusteeName = trustee.getUserName();
            ILocaleString trusteeNameFormatter = trustee.getUserNameFormatter();
            ILocaleString participantName = participant.getUserName();
            ILocaleString participantNameFormatter = participant.getUserNameFormatter();
            LocaleString wholeUerName = new LocaleString();
            LocaleString wholeUerNameFormat = new LocaleString();
            for (Lang supportLang : WfMultiLangUtils.getSupportLangs()) {
                String supportLangStr = supportLang.toString();
                wholeUerName.put((Object)supportLangStr, (Object)String.format((String)delegate.get((Object)supportLangStr), participantName.get((Object)supportLangStr), trusteeName.get((Object)supportLangStr)));
                wholeUerNameFormat.put((Object)supportLangStr, (Object)String.format((String)delegate.get((Object)supportLangStr), participantNameFormatter.get((Object)supportLangStr), trusteeNameFormatter.get((Object)supportLangStr)));
            }
            parentTaskParticipantName.add(wholeUerName);
            parentTaskParticipantNameFormat.add(wholeUerNameFormat);
        }
        for (IdentityLinkEntity participant : participantList) {
            if (ownerIds.contains(participant.getUserId())) continue;
            parentTaskParticipantName.add(participant.getUserName());
            parentTaskParticipantNameFormat.add(participant.getUserNameFormatter());
        }
        TaskEntity parentTask = task.getParentTaskInstance();
        parentTask.setVariableLocal("teamMemberNames", (Object)SerializationUtils.toJsonString((Object)WfMultiLangUtils.getFormatMergeValue(parentTaskParticipantName)));
        parentTask.setVariableLocal("teamMemberNamesFormat", (Object)SerializationUtils.toJsonString((Object)WfMultiLangUtils.getFormatMergeValue(parentTaskParticipantNameFormat)));
    }

    public void updateYzjTaskMemberInfoVariablesForAuto(CommandContext commandContext, TaskEntity task, Object ownerId, Object transferId) {
        if (YUNZHIJIATASK.equals(task.getCategory())) {
            Long fromId = null;
            Long toId = null;
            fromId = ownerId instanceof String ? Long.valueOf(ownerId.toString()) : (Long)ownerId;
            toId = transferId instanceof String ? Long.valueOf(transferId.toString().replaceFirst("(\\d+),?.*", "$1")) : (Long)transferId;
            TaskEntity parentTask = task.getParentTaskInstance();
            if (parentTask == null) {
                this.logger.debug("parentTask is null!" + task.getId());
                return;
            }
            int index = -1;
            String separator = ",";
            String merberIds = (String)parentTask.getVariableLocal("teamMembers");
            String merberNames = (String)parentTask.getVariableLocal("teamMemberNames");
            String merberNamesFormat = (String)parentTask.getVariableLocal("teamMemberNamesFormat");
            if (WfUtils.isNotEmpty(merberIds)) {
                String fid = String.valueOf(fromId);
                parentTask.setVariableLocal("teamMembers", (Object)merberIds.replace(fid, String.valueOf(toId)));
                index = Arrays.asList(merberIds.split(separator)).indexOf(fid);
            }
            this.logger.info(String.format("transferTestLog merberIds[%s], merberNames[%s], merberNamesFormat[%s], index[%s]", merberIds, merberNames, merberNamesFormat, index));
            if (WfUtils.isNotEmpty(merberNames)) {
                User fromUser = WfUtils.findUserById(fromId);
                User toUser = WfUtils.findUserById(toId);
                ILocaleString teamMerberNames = (ILocaleString)SerializationUtils.fromJsonString((String)merberNames, LocaleString.class);
                if (fromUser != null && toUser != null) {
                    ILocaleString fromName = WfUtils.findUserName(fromId);
                    ILocaleString toName = WfUtils.findUserName(toId);
                    for (Map.Entry entry : teamMerberNames.entrySet()) {
                        Object[] names;
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        String fromValue = (String)fromName.get((Object)key);
                        String toValue = (String)toName.get((Object)key);
                        if (value == null || fromValue == null) continue;
                        String ret = this.getTeamMerberNames(value, fromValue, toValue);
                        if (index > -1 && index < (names = value.split(separator)).length) {
                            names[index] = toValue;
                            ret = StringUtils.join((Object[])names, (String)separator);
                        }
                        teamMerberNames.put((Object)key, (Object)ret);
                    }
                    parentTask.setVariableLocal("teamMemberNames", (Object)SerializationUtils.toJsonString((Object)teamMerberNames));
                }
            }
            if (WfUtils.isNotEmpty(merberNamesFormat)) {
                DynamicObject hiparticipant = ParticipantHelper.getUserNameFormatByDynamicObject((Long)fromId, (Long)task.getId(), (String)EntityNumberConstant.getHiIdentityLinkEntityNumber(), (String)"usernameformatter", null);
                LocaleString fromNameFormat = new LocaleString();
                if (hiparticipant != null) {
                    fromNameFormat = hiparticipant.getLocaleString("usernameformatter");
                }
                ILocaleString toUserFormat = (ILocaleString)ParticipantHelper.getParticipantDisplayInfo((TaskEntity)task, Collections.singletonList(toId)).get(toId);
                ILocaleString teamMerberNamesFormat = (ILocaleString)SerializationUtils.fromJsonString((String)merberNamesFormat, LocaleString.class);
                if (WfUtils.isNotEmpty((ILocaleString)fromNameFormat) && WfUtils.isNotEmpty(toUserFormat)) {
                    for (Map.Entry entry : teamMerberNamesFormat.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        String fromValue = (String)fromNameFormat.get((Object)key);
                        String toValue = (String)toUserFormat.get((Object)key);
                        if (value == null || fromValue == null) continue;
                        teamMerberNamesFormat.put((Object)key, (Object)this.getTeamMerberNames(value, fromValue, toValue));
                    }
                    parentTask.setVariableLocal("teamMemberNamesFormat", (Object)SerializationUtils.toJsonString((Object)teamMerberNamesFormat));
                }
            }
        }
    }

    private String getTeamMerberNames(String originalNameContent, String fromUserName, String toUserName) {
        String[] userValue = originalNameContent.split(",");
        ArrayList<String> newUserValue = new ArrayList<String>(userValue.length);
        for (String uv : userValue) {
            if (uv.contains(fromUserName)) {
                String[] itemStr = uv.split(" ");
                List newStr = Arrays.stream(itemStr).map(item -> item.equals(fromUserName) ? toUserName : item).collect(Collectors.toList());
                newUserValue.add(itemStr.length == 1 ? (String)newStr.get(0) : StringUtils.join(newStr, (String)" "));
                continue;
            }
            newUserValue.add(uv);
        }
        return userValue.length == 1 ? (String)newUserValue.get(0) : StringUtils.join(newUserValue, (String)",");
    }

    public void updateTaskParticipantName(Long taskId, Long src, Long dest) {
        ILocaleString srcUserName = WfUtils.findUserName(src);
        ILocaleString destUserName = WfUtils.findUserName(dest);
        TaskEntity info = (TaskEntity)this.findById(taskId);
        ILocaleString participantName = info.getParticipantName();
        if (WfUtils.isEmpty(participantName)) {
            info.setParticipantName(destUserName);
        } else {
            WfUtils.replaceFirstLocaleString(participantName, srcUserName, destUserName);
            info.setParticipantName(participantName);
        }
        Context.getCommandContext().getTaskEntityManager().update((Entity)info);
        HistoricTaskInstanceEntity his = (HistoricTaskInstanceEntity)Context.getCommandContext().getHistoricTaskInstanceEntityManager().findById(taskId);
        his.setParticipantName(info.getParticipantName());
        Context.getCommandContext().getHistoricTaskInstanceEntityManager().update((Entity)his);
    }

    public List<TaskEntity> findByTaskIds(Long[] taskids, boolean display) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("id", "in", (Object)taskids).addFilter("display", (Object)display);
        return this.findByQueryBuilder(eb);
    }

    public List<TaskEntity> findByTaskIds(List<Long> taskIds) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("id", "in", taskIds);
        return this.findByQueryBuilder(eb);
    }

    public List<TaskEntity> findCompositeTasksByTaskId(Long taskId, Long processInstanceId, Long userId) {
        CommandContext commandContext = Context.getCommandContext();
        QFilter procinstFilter = new QFilter("processinstanceid", "=", (Object)processInstanceId);
        QFilter userFilter = new QFilter(USERID, "=", (Object)userId);
        QFilter taskFilter = new QFilter(TASKID, ">", (Object)0);
        QFilter comFilter = new QFilter("compositetaskid", "=", (Object)taskId);
        List identityLinkEntities = commandContext.getIdentityLinkEntityManager().findByQueryFilters(new QFilter[]{procinstFilter, userFilter, taskFilter, comFilter});
        if (CollectionUtils.isNotEmpty((Collection)identityLinkEntities)) {
            ArrayList<Long> taskIds = new ArrayList<Long>(identityLinkEntities.size());
            for (IdentityLinkEntity dentityLinkEntity : identityLinkEntities) {
                taskIds.add(dentityLinkEntity.getTaskId());
            }
            return commandContext.getTaskEntityManager().findByTaskIds(taskIds);
        }
        return new ArrayList<TaskEntity>();
    }

    public List<Long> findComposedTaskIdsByCompositeTaskIdAndUserId(Long compositeTaskId, Long userId) {
        CommandContext commandContext = Context.getCommandContext();
        QFilter userFilter = new QFilter(USERID, "=", (Object)userId);
        QFilter taskFilter = new QFilter(TASKID, ">", (Object)0);
        QFilter comFilter = new QFilter("compositetaskid", "=", (Object)compositeTaskId);
        List identityLinkEntities = commandContext.getIdentityLinkEntityManager().findByQueryFilters(new QFilter[]{userFilter, taskFilter, comFilter});
        if (CollectionUtils.isNotEmpty((Collection)identityLinkEntities)) {
            ArrayList<Long> taskIds = new ArrayList<Long>(identityLinkEntities.size());
            for (IdentityLinkEntity dentityLinkEntity : identityLinkEntities) {
                Long iTaskId = dentityLinkEntity.getTaskId();
                if (taskIds.contains(iTaskId)) continue;
                taskIds.add(iTaskId);
            }
            return taskIds;
        }
        return new ArrayList<Long>();
    }

    public List<TaskEntity> findTaskIdByBusinessKeyAndNodeId(String businesskey, String nodeId) {
        EntityQueryBuilder eb = this.createQueryBuilder().addFilter("businessKey", "=", (Object)businesskey).addFilter("taskDefinitionKey", (Object)nodeId).addFilter("parentTaskId", "=", (Object)0L);
        return this.findByQueryBuilder(eb);
    }

    public DynamicObjectCollection getTaskInTransitsListData(int start, int limit, String filterSql, List<Object> params, String orderBy) {
        String lang = RequestContext.get().getLang().toString();
        String masterTableAlias = "b";
        String multiLangTableAlias = "bl";
        String participantTableAlias = "a";
        String participantMultiLangTableAlias = "al";
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)ENTITYNAME, (String)ENTITYNAME);
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAME, (String)STARTNAME, (String)STARTNAME);
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSUBJECT, (String)SUBJECT, (String)SUBJECT);
        String NameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FNAME, (String)NAME, (String)NAME);
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSENDERNAME, (String)SENDERNAME, (String)SENDERNAME);
        String currentSubjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)participantTableAlias, (String)participantMultiLangTableAlias, (String)FCURRENTSUBJECT, (String)CURRENTSUBJECT, (String)CURRENTSUBJECT);
        String userNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_participant", (String)participantTableAlias, (String)participantMultiLangTableAlias, (String)"fusername", (String)"participantname", (String)"username");
        StringBuilder sb = new StringBuilder();
        sb.append("select b.fid id,b.fbillno billno,b.fhandlestate handlestate,b.fcreatedate createdate,");
        sb.append(entityNameSQL).append(",");
        sb.append(startNameSQL).append(",");
        sb.append(subjectSQL).append(",");
        sb.append(NameSQL).append(",");
        sb.append(senderNameSQL).append(",");
        sb.append(currentSubjectSQL).append(",");
        sb.append(userNameSQL);
        sb.append(" from t_wf_participant a ");
        sb.append("left join t_wf_participant_l al on a.fid=al.fid and al.flocaleid = ? ");
        sb.append("left join t_wf_task b on a.ftaskid=b.fid ");
        sb.append("left join t_wf_task_l bl on b.fid=bl.fid and bl.flocaleid = ? ");
        sb.append("where a.fuserid > 0 ");
        sb.append(filterSql);
        if (WfUtils.isNotEmpty(orderBy)) {
            sb.append(" order by ").append(orderBy);
        }
        params.add(0, lang);
        params.add(1, lang);
        try (DataSet ds = DB.queryDataSet((String)"TaskEntityManagerImpl.getTaskInTransitsListData", (DBRoute)DBRoute.workflow, (String)sb.toString(), (Object[])params.toArray());){
            DynamicObjectCollection results;
            DynamicObjectCollection dynamicObjectCollection = results = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            return dynamicObjectCollection;
        }
    }

    public Integer getTaskInTransitsListDataCount(String filterSql, List<Object> params) {
        StringBuilder sb = new StringBuilder();
        sb.append("select count(1) count from t_wf_participant a left join t_wf_task b on a.ftaskid=b.fid ");
        sb.append("where a.fuserid > 0 ");
        sb.append(filterSql);
        long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)"WFTASK.TaskEntityManagerImpl", (DBRoute)DBRoute.workflow, (String)sb.toString(), (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getLong(COUNT);
            }
        }
        return Integer.parseInt(count + "");
    }

    public List<TaskEntity> findTasksByEntityNumber(String entityNumber, Date createDate, String orderby, int limit) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        queryBuilder.addFilter("entitynumber", "=", (Object)entityNumber);
        queryBuilder.addFilter(CREATEDATE, "<=", (Object)createDate);
        queryBuilder.setLimit(limit).orderBy(orderby);
        return this.findByQueryBuilder(queryBuilder);
    }

    private String handleFilterSql(String filterSql, String replaceStr) {
        if (WfUtils.isNotEmpty(filterSql) && filterSql.contains("c.fpriority")) {
            filterSql = filterSql.replace("c.fpriority", replaceStr);
        }
        return filterSql;
    }

    public DynamicObjectCollection getNoCodeFlowToHandleTasksByParticipantId(String uid, String billType, String entityNumber, int start, int limit, String fiterSql, String showType, List<Object> paramsList, String orderBy) {
        String endType = "";
        String lang = RequestContext.get().getLang().toString();
        if (MOBILE.equals(showType)) {
            endType = "pc";
        } else if ("pc".equals(showType)) {
            endType = MOBILE;
        }
        String masterTableAlias = "a";
        String multiLangTableAlias = "b";
        String entityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FENTITY_NAME, (String)ENTITYNAME, (String)ENTITYNAME);
        String startNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSTARTNAME, (String)"startName", (String)STARTNAME);
        String subjectSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSUBJECT, (String)SUBJECT, (String)SUBJECT);
        String activityNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FNAME, (String)"activityName", (String)NAME);
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"wf_task", (String)masterTableAlias, (String)multiLangTableAlias, (String)FSENDERNAME, (String)SENDERNAME, (String)SENDERNAME);
        String sql = "select top " + (start + limit) + "a.fid id,a.fbusinesskey businessKey,a.fstarterid startUserId," + startNameSQL + "," + subjectSQL + ",a.fbusinesskey startUserImgUrl,a.fhandlestate handleState," + entityNameSQL + ",a.fentitynumber entityNumber,a.fprocinstid procInstId,a.fprocdefid procDefId,a.fbusinesskey procDefName,a.fcreatedate createDate,a.ftaskdefid activityId," + activityNameSQL + ",a.fsenderid senderid," + senderNameSQL + ",a.fcategory category," + A_FSUSPENSIONSTATE_SUSPENSIONSTATE + A_FISACTIVE_ACTIVE + "c.ftype \"type\",c.FPRIORITY priority,c.fcreatedate c_createdate,a.fexecutionid executionId,'' nodeBusinessKey,'' nodeEntityNumber  from t_wf_participant c  left join t_wf_participant_l cl on c.fid=cl.fid and cl.flocaleid = ?  left join t_wf_task a on c.ftaskid = a.fid and c.fuserid = ? and c.ftaskid>0 and c.fcompositetaskid = 0  left join t_wf_task_l b on a.fid=b.fid and b.flocaleid = ?  where c.ftaskid>0 and c.fuserid = ? and c.fcompositetaskid = 0 and a.FISDISPLAY = ? " + (WfUtils.isEmpty(endType) ? "" : "AND a.fendtype != ? ") + " " + (WfUtils.isEmpty(billType) ? "" : "and a.fbilltype = ? ") + " " + (WfUtils.isEmpty(entityNumber) ? "" : "and a.fentitynumber = ?") + " and a.fprocesstype = ? " + (WfUtils.isEmpty(fiterSql) ? "" : fiterSql) + " order by " + (WfUtils.isEmpty(orderBy) ? "" : orderBy + ",") + " c.FPRIORITY DESC, c.FCREATEDATE DESC ";
        ArrayList<Object> params = new ArrayList<Object>();
        params.addAll(Arrays.asList(lang, Long.valueOf(uid), lang, Long.valueOf(uid), "1"));
        if (WfUtils.isNotEmpty(endType)) {
            params.add(endType);
        }
        if (WfUtils.isNotEmpty(billType)) {
            params.add(billType);
        }
        if (WfUtils.isNotEmpty(entityNumber)) {
            params.add(entityNumber);
        }
        params.add(ModelType.NoCodeFlow.name());
        params.addAll(paramsList);
        try (DataSet ds = DB.queryDataSet((String)WF_TASK_CENTER_WF_TASK_QUERY_GRID_DATA, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            DynamicObjectCollection ret = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
            HashSet<Long> procDefIds = new HashSet<Long>(ret.size());
            HashSet<Long> startUserIds = new HashSet<Long>(ret.size());
            for (DynamicObject dyObject : ret) {
                procDefIds.add(dyObject.getLong("procDefId"));
                startUserIds.add(dyObject.getLong("startUserId"));
            }
            Map procdefMap = ProcessAssistantUtil.getProcdefNameByProcdefId(procDefIds);
            Map userInfoMap = ProcessAssistantUtil.queryUserInfos(startUserIds);
            for (DynamicObject dyObject : ret) {
                String isActive;
                Object obj = dyObject.get(ACTIVE);
                if (obj != null && "0".equals(isActive = (String)obj)) {
                    dyObject.set(HANDLESTATE, (Object)FREEZE);
                }
                String suspensionstate = dyObject.getString(SUSPENSIONSTATE);
                if (!ManagementConstants.ACTIVE.getStateCode().equals(suspensionstate)) {
                    dyObject.set(HANDLESTATE, (Object)"manualSuspended");
                }
                if ("coordinate".equals(dyObject.getString("type"))) {
                    dyObject.set(CREATEDATE, dyObject.get("c_createdate"));
                }
                if (WfUtils.isNotEmptyForMap(procdefMap)) {
                    dyObject.set("procDefName", procdefMap.get(dyObject.getLong("procDefId")));
                }
                Long startUserId = dyObject.getLong("startUserId");
                if (WfUtils.isNotEmptyForMap(userInfoMap) && WfUtils.isNotEmpty(startUserId)) {
                    UserInfo userInfo = (UserInfo)userInfoMap.get(startUserId.toString());
                    dyObject.set("startUserImgUrl", (Object)(userInfo != null ? userInfo.getImgUrl() : ""));
                }
                if (!"UserTask".equalsIgnoreCase(dyObject.getString("category"))) continue;
                dyObject.set("nodeBusinessKey", dyObject.get("businessKey"));
                dyObject.set("nodeEntityNumber", dyObject.get("entityNumber"));
                HistoricProcessInstanceEntity hisProcInstEntity = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(Long.valueOf(dyObject.getLong("procInstId")));
                if (hisProcInstEntity == null) continue;
                dyObject.set("businessKey", (Object)hisProcInstEntity.getBusinessKey());
                dyObject.set("entityNumber", (Object)hisProcInstEntity.getEntitynumber());
            }
            if (WfUtils.isEmpty(orderBy)) {
                Collections.sort(ret, new Comparator<DynamicObject>(){
                    private static final String KEY1 = "priority";
                    private static final String KEY2 = "createdate";

                    @Override
                    public int compare(DynamicObject a, DynamicObject b) {
                        int pB;
                        int pA = a.getInt(KEY1);
                        if (pA > (pB = b.getInt(KEY1))) {
                            return -1;
                        }
                        if (pA < pB) {
                            return 1;
                        }
                        Date valA = a.getDate("createdate");
                        Date valB = b.getDate("createdate");
                        if (valA != null && valB != null) {
                            return valB.compareTo(valA);
                        }
                        return 0;
                    }
                });
            }
            Iterator iterator = ret;
            return iterator;
        }
    }

    public DynamicObjectCollection getToHandleTasks(EntityQueryParams entityQueryParams) {
        String queryFields = entityQueryParams.getMainEntityQueryParams().getQueryALLFields();
        QFilter[] qFilters = this.buildToHandleQfilter(entityQueryParams);
        StringBuilder order = new StringBuilder();
        String orderby = entityQueryParams.getMainEntityQueryParams().getOrderBySql();
        if (WfUtils.isNotEmpty(orderby)) {
            order.append(orderby).append(",");
            if (orderby.contains(CREATEDATE)) {
                order.append("priority desc");
            } else {
                order.append("priority desc,createdate desc");
            }
        } else {
            order.append("priority desc,createdate desc");
        }
        try (DataSet ds = ORM.create().queryDataSet("algoKey", "wf_participant", queryFields, qFilters, order.toString(), entityQueryParams.getStart(), entityQueryParams.getLimit());){
            DynamicObjectCollection resultDynamicObjectCollection;
            DynamicObjectCollection dynamicObjectCollection = resultDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }

    public Long getToHandleTaskCount(EntityQueryParams entityQueryParams) {
        QFilter[] qFilters = this.buildToHandleQfilter(entityQueryParams);
        return ORM.create().count("algoKey-getToHandleTaskCount", "wf_participant", qFilters);
    }

    private QFilter[] buildToHandleQfilter(EntityQueryParams entityQueryParams) {
        List params;
        String endType = "";
        String showType = entityQueryParams.getEndType();
        if (MOBILE.equals(showType)) {
            endType = "pc";
        } else if ("pc".equals(showType)) {
            endType = MOBILE;
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        String noCodeFlow = ThreadLocalVariables.get();
        QFilter qFilter = new QFilter(TASKID, ">", (Object)0).and(new QFilter(USERID, "=", (Object)entityQueryParams.getUserId())).and(new QFilter("compositetaskid", "=", (Object)0)).and(new QFilter("display", "=", (Object)"1")).and(new QFilter("taskdisplay", "=", (Object)"1"));
        if (WfUtils.isNotEmpty(endType)) {
            qFilter.and(new QFilter("endtype", "!=", (Object)endType));
        }
        qFilterList.add(qFilter);
        if (WfUtils.isNotEmpty(noCodeFlow)) {
            qFilterList.add(new QFilter("processtype", "=", (Object)noCodeFlow));
        }
        if ((params = entityQueryParams.getMainEntityQueryParams().getQFilter()) != null && params.size() > 0) {
            qFilterList.addAll(params);
        }
        return (QFilter[])qFilterList.stream().toArray(QFilter[]::new);
    }

    public DynamicObjectCollection getTransferTasks(EntityQueryParams entityQueryParams) {
        String queryFields = entityQueryParams.getMainEntityQueryParams().getQueryALLFields();
        QFilter[] qFilters = this.buildTransferQfilter(entityQueryParams);
        StringBuilder order = new StringBuilder();
        String orderby = entityQueryParams.getMainEntityQueryParams().getOrderBySql();
        if (WfUtils.isNotEmpty(orderby)) {
            if (orderby.contains("id")) {
                order.append(orderby);
            } else {
                order.append(orderby).append(",id desc");
            }
        } else {
            order.append("id desc");
        }
        try (DataSet ds = ORM.create().queryDataSet("algoKey", "wf_taskhandlelog", queryFields, qFilters, order.toString(), entityQueryParams.getStart(), entityQueryParams.getLimit());){
            DynamicObjectCollection resultDynamicObjectCollection;
            DynamicObjectCollection dynamicObjectCollection = resultDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }

    public Long getTransferTaskCount(EntityQueryParams entityQueryParams) {
        QFilter[] qFilters = this.buildTransferQfilter(entityQueryParams);
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet ds = ORM.create().queryDataSet("getTransferTaskCount", "wf_taskhandlelog", TASKID, qFilters);){
            for (Row row : ds) {
                ids.add(row.getLong(TASKID));
            }
        }
        return ids.size();
    }

    private QFilter[] buildTransferQfilter(EntityQueryParams entityQueryParams) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("ownerid", "=", (Object)entityQueryParams.getUserId()).and(new QFilter("type ", "=", (Object)"transfer")).and(new QFilter("compositetaskid", "=", (Object)0)).and(new QFilter("display", "=", (Object)"1")).and(new QFilter("endtype", "!=", (Object)MOBILE)).and(new QFilter("processtype ", "!=", (Object)ModelType.NoCodeFlow.name())).and(new QFilter("isadminforward ", "=", (Object)"0")).and(new QFilter("endtime ", "is null", null));
        qFilterList.add(qFilter);
        List params = entityQueryParams.getMainEntityQueryParams().getQFilter();
        if (params != null && params.size() > 0) {
            qFilterList.addAll(params);
        }
        return (QFilter[])qFilterList.stream().toArray(QFilter[]::new);
    }

    public DynamicObjectCollection getDelegateTasks(EntityQueryParams entityQueryParams) {
        String queryFields = entityQueryParams.getMainEntityQueryParams().getQueryALLFields();
        QFilter[] qFilters = this.buildDelegateQfilter(entityQueryParams);
        StringBuilder order = new StringBuilder();
        String orderby = entityQueryParams.getMainEntityQueryParams().getOrderBySql();
        if (WfUtils.isNotEmpty(orderby)) {
            order.append(orderby);
        } else {
            order.append(" createdate desc ");
        }
        try (DataSet ds = ORM.create().queryDataSet("algoKey-getDelegateTasks", "wf_participant", queryFields, qFilters, order.toString(), entityQueryParams.getStart(), entityQueryParams.getLimit());){
            DynamicObjectCollection resultDynamicObjectCollection;
            DynamicObjectCollection dynamicObjectCollection = resultDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }

    public Long getDelegateTaskCount(EntityQueryParams entityQueryParams) {
        QFilter[] qFilters = this.buildDelegateQfilter(entityQueryParams);
        return ORM.create().count("algoKey-getDelegateTaskCount", "wf_participant", qFilters);
    }

    private QFilter[] buildDelegateQfilter(EntityQueryParams entityQueryParams) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("ownerid", "=", (Object)entityQueryParams.getUserId()).and(new QFilter("compositetaskid", "=", (Object)0)).and(new QFilter(DELEGATEID, "!=", (Object)0)).and(new QFilter("display", "=", (Object)"1")).and(new QFilter("taskdisplay", "=", (Object)"1")).and(new QFilter("endtype", "!=", (Object)MOBILE)).and(new QFilter("processtype ", "!=", (Object)ModelType.NoCodeFlow.name()));
        qFilterList.add(qFilter);
        List params = entityQueryParams.getMainEntityQueryParams().getQFilter();
        if (params != null && params.size() > 0) {
            qFilterList.addAll(params);
        }
        return (QFilter[])qFilterList.stream().toArray(QFilter[]::new);
    }
}

