/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl.util.workCalendar;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.workCalendar.WorkDateModel;

public class WorkCalendarUtil {
    private static Log logger = LogFactory.getLog(WorkCalendarUtil.class);
    private static final String WORK_DATE_STR = "08:30-12:00,13:30-18:00";
    private static final int WORK_TIME_PRE_DAY = 480;
    private static final String DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String TIME_PATTERN = "HH:mm";
    private static final Long TIME_OF_DAY = 86400000L;
    private static final int EXPIREMAXDAY = 365;
    private static final String WORKTIMESTR = "workTimeStr";
    private static final String WORKTIMEPREDAY = "workTimePreDay";
    private static final String DATETYPE_WORKDAY = "1";
    private static final String DATETYPE_HALFRESTDAY = "2";
    private static final String DATETYPE_HOLIDAY = "3";
    private static final String DATETYPE_RESTDAY = "4";
    private static final String LAWHOLIDAYS = "lawHolidays";
    private static final String HALFWORKDAYS = "halfWorkDays";
    private static final String MILLTIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String HALFWORKTIMESTR = "halfWorkDayStr";
    private static final String WORKDAYMILLS = "workDayMills";
    private static final String MORNINGMILLS = "morningMills";
    private static final String AFTERNOONTOMORNINGMILLS = "afternoonToMorningMills";
    private static final String RESTMILLS = "restMills";
    private static final String AFTERNOONMILLS = "afternoonMills";
    private static final String MILLSSTR = ":00.000";
    private static final String WORKDATE = "workdate";
    private static final String DATETYPE = "datetype";
    private static final String DATEENTRY = "dateentry";
    private static final Long FLAG_DATA_ERROR = -1L;

    private WorkCalendarUtil() {
    }

    public static Long getRealDuration(Date recordStartDate, Date recordEndDate) {
        try {
            SimpleDateFormat simpleDateTime = new SimpleDateFormat(MILLTIME_PATTERN);
            SimpleDateFormat holiday = new SimpleDateFormat(DATE_PATTERN);
            SimpleDateFormat simpleTime = new SimpleDateFormat(TIME_PATTERN);
            String startTime = simpleDateTime.format(recordStartDate);
            String endTime = simpleDateTime.format(recordEndDate);
            List<WorkDateModel> workDateModels = WorkCalendarUtil.getBetweenDate(recordStartDate, recordEndDate);
            ArrayList<String> lawHolidayList = new ArrayList<String>(workDateModels.size());
            ArrayList<String> halfWorkDayList = new ArrayList<String>(workDateModels.size());
            Map<String, String> map = WorkCalendarUtil.getWorkDayStr(workDateModels, simpleTime);
            String workTimeStr = map.get(WORKTIMESTR);
            String halfWorkDayStr = map.get(HALFWORKTIMESTR);
            if (WfUtils.isNotEmptyForCollection(workDateModels)) {
                for (WorkDateModel workDate : workDateModels) {
                    if (null != workDate.isHalfWorkDay() && workDate.isHalfWorkDay().booleanValue()) {
                        halfWorkDayList.add(holiday.format(workDate.getCurrentDate()));
                        continue;
                    }
                    if (null == workDate.getWorkDay() || workDate.getWorkDay().booleanValue()) continue;
                    lawHolidayList.add(holiday.format(workDate.getCurrentDate()));
                }
                Optional<WorkDateModel> min = workDateModels.stream().min(Comparator.comparing(WorkDateModel::getCurrentDate));
                if (min.isPresent() && min.get().getCurrentDate() != null && holiday.format(min.get().getCurrentDate()).compareTo(startTime.substring(0, 10)) > 0) {
                    return recordEndDate.getTime() - recordStartDate.getTime();
                }
            } else {
                return recordEndDate.getTime() - recordStartDate.getTime();
            }
            return WorkCalendarUtil.calWorkTimeDuration(startTime, endTime, lawHolidayList, halfWorkDayList, workTimeStr, halfWorkDayStr);
        }
        catch (Exception e) {
            logger.warn(String.format("calculate workTime duration occurred exception:[%s]", e.getMessage()));
            return recordEndDate.getTime() - recordStartDate.getTime();
        }
    }

    private static Map<String, String> getWorkDayStr(List<WorkDateModel> workDateModels, SimpleDateFormat simpleTime) {
        HashMap<String, String> ret = new HashMap<String, String>(2);
        ret.put(WORKTIMESTR, WORK_DATE_STR);
        ret.put(HALFWORKTIMESTR, "08:30-13:30");
        if (null != workDateModels && workDateModels.size() > 0) {
            WorkDateModel workDateModel = workDateModels.get(0);
            String amBegin = WfUtils.isEmpty(simpleTime.format(workDateModel.getBeginAm())) ? "08:30" : simpleTime.format(workDateModel.getBeginAm());
            String amEnd = WfUtils.isEmpty(simpleTime.format(workDateModel.getEndAm())) ? "12:00" : simpleTime.format(workDateModel.getEndAm());
            String pmBegin = WfUtils.isEmpty(simpleTime.format(workDateModel.getBeginPm())) ? "13:30" : simpleTime.format(workDateModel.getBeginPm());
            String pmEnd = WfUtils.isEmpty(simpleTime.format(workDateModel.getEndPm())) ? "18:00" : simpleTime.format(workDateModel.getEndPm());
            String workTimeStr = amBegin + "-" + amEnd + "," + pmBegin + "-" + pmEnd;
            ret.put(WORKTIMESTR, workTimeStr);
            long morning = workDateModel.getEndAm().getTime() - workDateModel.getBeginAm().getTime();
            long afternoon = workDateModel.getEndPm().getTime() - workDateModel.getBeginPm().getTime();
            int halfWorkMin = Integer.parseInt(String.valueOf((morning + afternoon) / 120000L));
            Date begin = workDateModel.getBeginAm();
            Calendar c = Calendar.getInstance();
            c.setTime(begin);
            c.add(12, halfWorkMin);
            Date halfDayEnd = c.getTime();
            String halfWorkDayStr = amBegin + "-" + simpleTime.format(halfDayEnd);
            ret.put(HALFWORKTIMESTR, halfWorkDayStr);
        }
        return ret;
    }

    private static List<WorkDateModel> getBetweenDate(Date beginDate, Date endDate) {
        ArrayList<WorkDateModel> resultList = new ArrayList<WorkDateModel>(8);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIME_PATTERN);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERN);
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        BaseDataServiceHelper baseDataServiceHelper = new BaseDataServiceHelper();
        try {
            beginDate = simpleDateFormat.parse(simpleDateFormat.format(beginDate));
            endDate = simpleDateFormat.parse(simpleDateFormat.format(endDate));
            DynamicObject personalWorkCalendar = baseDataServiceHelper.getWorkCalendar(Long.valueOf(rootOrgId), beginDate, endDate);
            if (null != personalWorkCalendar) {
                String hbam = personalWorkCalendar.getString("hourofbegintimeam");
                String mbam = personalWorkCalendar.getString("minofbegintimeam");
                String heam = personalWorkCalendar.getString("hourofendtimeam");
                String meam = personalWorkCalendar.getString("minofendtimeam");
                String hbpm = personalWorkCalendar.getString("hourofbegintimepm");
                String mbpm = personalWorkCalendar.getString("minofbegintimepm");
                String hepm = personalWorkCalendar.getString("hourofendtimepm");
                String mepm = personalWorkCalendar.getString("minofendtimepm");
                String expiringyearfrom = WfUtils.isEmpty(personalWorkCalendar.getString("expiringyearfrom")) ? WorkCalendarUtil.getCurrentYear() : personalWorkCalendar.getString("expiringyearfrom");
                String expiringmonthfrom = WfUtils.isEmpty(personalWorkCalendar.getString("expiringmonthfrom")) ? WorkCalendarUtil.getCurrentMonth() : personalWorkCalendar.getString("expiringmonthfrom");
                String expiringyearto = WfUtils.isEmpty(personalWorkCalendar.getString("expiringyearto")) ? WorkCalendarUtil.getCurrentYear() : personalWorkCalendar.getString("expiringyearto");
                String expiringmonthto = WfUtils.isEmpty(personalWorkCalendar.getString("expiringmonthto")) ? WorkCalendarUtil.getCurrentMonth() : personalWorkCalendar.getString("expiringmonthto");
                DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)personalWorkCalendar.get(DATEENTRY);
                if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
                    for (DynamicObject dynamicDate : dynamicObjectCollection) {
                        Date currentDate = (Date)dynamicDate.get(WORKDATE);
                        String dateType = dynamicDate.getString(DATETYPE);
                        Date formatBeginDate = dateFormat.parse(dateFormat.format(beginDate));
                        Date formatEndDate = dateFormat.parse(dateFormat.format(endDate));
                        if (currentDate.getTime() - formatBeginDate.getTime() < 0L || currentDate.getTime() - formatEndDate.getTime() > 0L) continue;
                        WorkDateModel workDateModel = new WorkDateModel();
                        workDateModel.setCurrentDate(currentDate);
                        if (DATETYPE_WORKDAY.equals(dateType)) {
                            workDateModel.setWorkDay(Boolean.valueOf(true));
                        } else if (DATETYPE_HALFRESTDAY.equals(dateType)) {
                            workDateModel.setWorkDay(Boolean.valueOf(true));
                            workDateModel.setHalfWorkDay(Boolean.valueOf(true));
                        } else {
                            workDateModel.setWorkDay(Boolean.valueOf(false));
                        }
                        WorkCalendarUtil.rebuildWorkDateModel(currentDate, hbam, mbam, heam, meam, hbpm, mbpm, hepm, mepm, workDateModel, simpleDateFormat);
                        resultList.add(workDateModel);
                    }
                } else {
                    logger.debug(String.format("workCalendar data is empty-\u3010%s\u3011,request param\uff1a\u3010%s\u3011-\u3010%s\u3011-\u3010%s\u3011", dynamicObjectCollection, beginDate, endDate, rootOrgId));
                }
            }
        }
        catch (Exception e) {
            logger.error(String.format("get workCalendar occurred exception:[%s]-[%s]", e.getStackTrace(), e.getMessage()));
        }
        return resultList;
    }

    private static WorkDateModel rebuildWorkDateModel(Date currentDate, String hbam, String mbam, String heam, String meam, String hbpm, String mbpm, String hepm, String mepm, WorkDateModel workDateModel, SimpleDateFormat simpleDateFormat) throws ParseException {
        String beginAm = WorkCalendarUtil.rebuildDateStr(currentDate, hbam, mbam);
        String endAm = WorkCalendarUtil.rebuildDateStr(currentDate, heam, meam);
        String beginPm = WorkCalendarUtil.rebuildDateStr(currentDate, hbpm, mbpm);
        String endPm = WorkCalendarUtil.rebuildDateStr(currentDate, hepm, mepm);
        workDateModel.setBeginAm(simpleDateFormat.parse(beginAm));
        workDateModel.setEndAm(simpleDateFormat.parse(endAm));
        workDateModel.setBeginPm(simpleDateFormat.parse(beginPm));
        workDateModel.setEndPm(simpleDateFormat.parse(endPm));
        return workDateModel;
    }

    private static Long calWorkTimeDuration(String startTime, String endTime, List<String> lawHolidayList, List<String> halfWorkDayList, String workTimeStr, String halfWorkTimeStr) throws Exception {
        logger.debug(String.format("calculate workDuration:[%s]-[%s]-[%s]-[%s]-[%s]-[%s]", startTime, endTime, lawHolidayList, halfWorkDayList, workTimeStr, halfWorkTimeStr));
        try {
            if (endTime.compareTo(startTime) <= 0) {
                return FLAG_DATA_ERROR;
            }
            SimpleDateFormat sdf = new SimpleDateFormat(MILLTIME_PATTERN);
            SimpleDateFormat formatter = new SimpleDateFormat(TIME_PATTERN);
            String startTimeH = formatter.format(sdf.parse(startTime));
            String endTimeH = formatter.format(sdf.parse(endTime));
            String[] workingTimes = workTimeStr.split(",");
            String morning = workingTimes[0];
            String afternoon = workingTimes[1];
            String[] mornings = morning.split("-");
            String[] afternoons = afternoon.split("-");
            String[] halfWorkDay = halfWorkTimeStr.split("-");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(MILLTIME_PATTERN);
            LocalDateTime startTimeLocal = LocalDateTime.parse(startTime, dateTimeFormatter);
            Map<String, Long> betweenMills = WorkCalendarUtil.getWorkDayBetweenMills(startTime, mornings, afternoons, sdf, startTimeLocal, dateTimeFormatter);
            long endMills = sdf.parse(endTime).getTime();
            long startMills = sdf.parse(startTime).getTime();
            long betweenDuration = endMills - startMills;
            long days = betweenDuration / TIME_OF_DAY;
            long halfWorkMills = WorkCalendarUtil.getHalfWorkDayBetweenMills(startTime, sdf, halfWorkDay);
            long workDayMills = betweenMills.get(WORKDAYMILLS);
            long workTotalDurations = 0L;
            if (days > 0L) {
                long durationBegin = WorkCalendarUtil.getDuration(startTime, startTimeH, halfWorkDay, sdf, mornings, afternoons, betweenMills, lawHolidayList, halfWorkDayList, false);
                long durationEnd = WorkCalendarUtil.getDuration(endTime, endTimeH, halfWorkDay, sdf, mornings, afternoons, betweenMills, lawHolidayList, halfWorkDayList, true);
                workTotalDurations = durationBegin + durationEnd;
                int i = 0;
                while ((long)i < days) {
                    startTimeLocal = startTimeLocal.plusDays(1L);
                    startTime = startTimeLocal.format(dateTimeFormatter);
                    long workDuration = 0L;
                    if (!startTime.substring(0, 10).equals(endTime.substring(0, 10))) {
                        workDuration = halfWorkDayList.contains(startTime.substring(0, 10)) ? halfWorkMills : (lawHolidayList.contains(startTime.substring(0, 10)) ? 0L : workDayMills);
                    }
                    workTotalDurations += workDuration;
                    ++i;
                }
            } else {
                boolean isSameDay = startTime.substring(0, 10).equals(endTime.substring(0, 10));
                if (halfWorkDayList.contains(startTime.substring(0, 10))) {
                    if (isSameDay) {
                        workTotalDurations = WorkCalendarUtil.getCalHalfWorkDuration(startTime, startTimeH, endTime, endTimeH, sdf, halfWorkDay);
                    } else {
                        long halfToday = WorkCalendarUtil.getHalfWorkDayDuration(startTime, startTimeH, halfWorkDay, sdf, false);
                        long endDayDuration = WorkCalendarUtil.getDuration(endTime, endTimeH, halfWorkDay, sdf, mornings, afternoons, betweenMills, lawHolidayList, halfWorkDayList, true);
                        workTotalDurations = halfToday + endDayDuration;
                    }
                } else if (lawHolidayList.contains(startTime.substring(0, 10))) {
                    workTotalDurations = isSameDay ? 0L : WorkCalendarUtil.getDuration(endTime, endTimeH, halfWorkDay, sdf, mornings, afternoons, betweenMills, lawHolidayList, halfWorkDayList, true);
                } else {
                    if (isSameDay) {
                        workTotalDurations = WorkCalendarUtil.getCalWorkDayDuration(startTime, startTimeH, endTime, endTimeH, mornings, afternoons, sdf, betweenMills);
                    } else if (lawHolidayList.contains(endTime.substring(0, 10))) {
                        workTotalDurations = WorkCalendarUtil.getWorkDayDuration(startTime, startTimeH, mornings, afternoons, sdf, betweenMills, false);
                    } else if (halfWorkDayList.contains(endTime.substring(0, 10))) {
                        long workDayDuration = WorkCalendarUtil.getWorkDayDuration(startTime, startTimeH, mornings, afternoons, sdf, betweenMills, false);
                        long halfWorkDayDuration = WorkCalendarUtil.getHalfWorkDayDuration(endTime, endTimeH, halfWorkDay, sdf, true);
                        workTotalDurations = workDayDuration + halfWorkDayDuration;
                    } else {
                        long workDayStart = WorkCalendarUtil.getWorkDayDuration(startTime, startTimeH, mornings, afternoons, sdf, betweenMills, false);
                        long workDatEnd = WorkCalendarUtil.getWorkDayDuration(endTime, endTimeH, mornings, afternoons, sdf, betweenMills, true);
                        workTotalDurations = workDayStart + workDatEnd;
                    }
                    return workTotalDurations;
                }
            }
            logger.debug(String.format("calculate workDuration result:[%s]", workTotalDurations));
            return workTotalDurations;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private static long getCalWorkDayDuration(String startTime, String startTimeH, String endTime, String endTimeH, String[] mornings, String[] afternoons, SimpleDateFormat sdf, Map<String, Long> betweenMills) throws ParseException {
        long workDuration = 0L;
        if (startTimeH.compareTo(mornings[0]) < 0) {
            if (endTimeH.compareTo(mornings[0]) < 0) {
                workDuration = 0L;
            } else if (endTimeH.compareTo(mornings[0]) >= 0 && endTimeH.compareTo(mornings[1]) < 0) {
                workDuration = sdf.parse(endTime).getTime() - sdf.parse(endTime.substring(0, 11).concat(mornings[0]).concat(MILLSSTR)).getTime();
            } else if (endTimeH.compareTo(mornings[1]) >= 0 && endTimeH.compareTo(afternoons[0]) < 0) {
                workDuration = betweenMills.get(MORNINGMILLS);
            } else if (endTimeH.compareTo(afternoons[0]) >= 0 && endTimeH.compareTo(afternoons[1]) < 0) {
                workDuration = betweenMills.get(MORNINGMILLS) + (sdf.parse(endTime).getTime() - sdf.parse(endTime.substring(0, 11).concat(afternoons[0]).concat(MILLSSTR)).getTime());
            } else if (endTimeH.compareTo(afternoons[1]) > 0) {
                workDuration = betweenMills.get(WORKDAYMILLS);
            }
        } else if (startTimeH.compareTo(mornings[0]) >= 0 && startTimeH.compareTo(mornings[1]) < 0) {
            if (endTimeH.compareTo(mornings[0]) >= 0 && endTimeH.compareTo(mornings[1]) < 0) {
                workDuration = sdf.parse(endTime).getTime() - sdf.parse(startTime).getTime();
            } else if (endTimeH.compareTo(mornings[1]) >= 0 && endTimeH.compareTo(afternoons[0]) < 0) {
                workDuration = sdf.parse(endTime.substring(0, 11).concat(mornings[1]).concat(MILLSSTR)).getTime() - sdf.parse(startTime).getTime();
            } else if (endTimeH.compareTo(afternoons[0]) >= 0 && endTimeH.compareTo(afternoons[1]) < 0) {
                workDuration = sdf.parse(endTime).getTime() - sdf.parse(startTime).getTime() - betweenMills.get(RESTMILLS);
            } else if (endTimeH.compareTo(afternoons[1]) >= 0) {
                workDuration = sdf.parse(endTime.substring(0, 11).concat(mornings[1]).concat(MILLSSTR)).getTime() - sdf.parse(startTime).getTime() + betweenMills.get(AFTERNOONMILLS);
            }
        } else if (startTimeH.compareTo(mornings[1]) >= 0 && startTimeH.compareTo(afternoons[0]) < 0) {
            if (endTimeH.compareTo(mornings[1]) >= 0 && endTimeH.compareTo(afternoons[0]) < 0) {
                workDuration = 0L;
            } else if (endTimeH.compareTo(afternoons[0]) >= 0 && endTimeH.compareTo(afternoons[1]) < 0) {
                workDuration = sdf.parse(endTime).getTime() - sdf.parse(endTime.substring(0, 11).concat(afternoons[0]).concat(MILLSSTR)).getTime();
            } else if (endTimeH.compareTo(afternoons[1]) >= 0) {
                workDuration = betweenMills.get(AFTERNOONMILLS);
            }
        } else if (startTimeH.compareTo(afternoons[0]) >= 0 && startTimeH.compareTo(afternoons[1]) < 0) {
            if (endTimeH.compareTo(afternoons[0]) >= 0 && endTimeH.compareTo(afternoons[1]) < 0) {
                workDuration = sdf.parse(endTime).getTime() - sdf.parse(startTime).getTime();
            } else if (endTimeH.compareTo(afternoons[1]) >= 0) {
                workDuration = sdf.parse(endTime.substring(0, 11).concat(afternoons[1]).concat(MILLSSTR)).getTime() - sdf.parse(startTime).getTime();
            }
        } else if (startTimeH.compareTo(afternoons[1]) > 0 && endTimeH.compareTo(afternoons[1]) > 0) {
            workDuration = 0L;
        }
        return workDuration;
    }

    private static long getCalHalfWorkDuration(String startTime, String startTimeH, String endTime, String endTimeH, SimpleDateFormat sdf, String[] halfWorkDayStr) throws ParseException {
        long workDurations = 0L;
        if (endTimeH.compareTo(halfWorkDayStr[0]) < 0) {
            workDurations = 0L;
        } else if (endTimeH.compareTo(halfWorkDayStr[0]) >= 0 && endTimeH.compareTo(halfWorkDayStr[1]) < 0) {
            if (startTimeH.compareTo(halfWorkDayStr[0]) < 0) {
                workDurations = sdf.parse(endTime).getTime() - sdf.parse(endTime.substring(0, 11).concat(halfWorkDayStr[0]).concat(MILLSSTR)).getTime();
            } else if (startTimeH.compareTo(halfWorkDayStr[0]) >= 0 && startTimeH.compareTo(halfWorkDayStr[1]) < 0) {
                workDurations = sdf.parse(endTime).getTime() - sdf.parse(startTime).getTime();
            } else if (startTimeH.compareTo(halfWorkDayStr[1]) >= 0) {
                workDurations = 0L;
            }
        } else if (endTimeH.compareTo(halfWorkDayStr[1]) >= 0) {
            if (startTimeH.compareTo(halfWorkDayStr[0]) < 0) {
                long begin = sdf.parse(endTime.substring(0, 11).concat(halfWorkDayStr[0]).concat(MILLSSTR)).getTime();
                long end = sdf.parse(endTime.substring(0, 11).concat(halfWorkDayStr[1]).concat(MILLSSTR)).getTime();
                workDurations = end - begin;
            } else if (startTimeH.compareTo(halfWorkDayStr[0]) >= 0 && startTimeH.compareTo(halfWorkDayStr[1]) < 0) {
                workDurations = sdf.parse(endTime.substring(0, 11).concat(halfWorkDayStr[1]).concat(MILLSSTR)).getTime() - sdf.parse(startTime).getTime();
            } else if (startTimeH.compareTo(halfWorkDayStr[1]) >= 0) {
                workDurations = 0L;
            }
        }
        return workDurations;
    }

    private static long getDuration(String time, String timeH, String[] halfWorkDay, SimpleDateFormat sdf, String[] mornings, String[] afternoons, Map<String, Long> betweenMills, List<String> lawHolidayList, List<String> halfWorkDayList, boolean anotherDay) throws ParseException {
        long duration = 0L;
        duration = halfWorkDayList.contains(time.substring(0, 10)) ? WorkCalendarUtil.getHalfWorkDayDuration(time, timeH, halfWorkDay, sdf, anotherDay) : (lawHolidayList.contains(time.substring(0, 10)) ? 0L : WorkCalendarUtil.getWorkDayDuration(time, timeH, mornings, afternoons, sdf, betweenMills, anotherDay));
        return duration;
    }

    private static long getHalfWorkDayDuration(String time, String timeH, String[] halfWorkDay, SimpleDateFormat sdf, boolean anotherDay) throws ParseException {
        long workDuration = 0L;
        long begin = sdf.parse(time.substring(0, 11).concat(halfWorkDay[0]).concat(MILLSSTR)).getTime();
        long end = sdf.parse(time.substring(0, 11).concat(halfWorkDay[1]).concat(MILLSSTR)).getTime();
        long halfDayDuration = end - begin;
        if (timeH.compareTo(halfWorkDay[0]) < 0) {
            workDuration = anotherDay ? 0L : halfDayDuration;
        } else if (timeH.compareTo(halfWorkDay[0]) > 0 && timeH.compareTo(halfWorkDay[1]) <= 0) {
            workDuration = anotherDay ? sdf.parse(time).getTime() - sdf.parse(time.substring(0, 11).concat(halfWorkDay[0]).concat(MILLSSTR)).getTime() : halfDayDuration - (sdf.parse(time).getTime() - sdf.parse(time.substring(0, 11).concat(halfWorkDay[0]).concat(MILLSSTR)).getTime());
        } else if (timeH.compareTo(halfWorkDay[1]) > 0) {
            workDuration = anotherDay ? halfDayDuration : 0L;
        }
        return workDuration;
    }

    private static long getWorkDayDuration(String time, String timeH, String[] mornings, String[] afternoons, SimpleDateFormat sdf, Map<String, Long> betweenMills, boolean anotherDay) throws ParseException {
        long workDuration = 0L;
        long allDayDuration = betweenMills.get(WORKDAYMILLS);
        if (timeH.compareTo(mornings[0]) <= 0) {
            workDuration = anotherDay ? 0L : allDayDuration;
        } else if (timeH.compareTo(mornings[0]) > 0 && timeH.compareTo(mornings[1]) <= 0) {
            workDuration = anotherDay ? sdf.parse(time).getTime() - sdf.parse(time.substring(0, 11).concat(mornings[0]).concat(MILLSSTR)).getTime() : allDayDuration - (sdf.parse(time).getTime() - sdf.parse(time.substring(0, 11).concat(mornings[0]).concat(MILLSSTR)).getTime());
        } else if (timeH.compareTo(mornings[1]) > 0 && timeH.compareTo(afternoons[0]) <= 0) {
            workDuration = anotherDay ? betweenMills.get(MORNINGMILLS).longValue() : betweenMills.get(AFTERNOONMILLS).longValue();
        } else if (timeH.compareTo(afternoons[0]) > 0 && timeH.compareTo(afternoons[1]) <= 0) {
            workDuration = anotherDay ? betweenMills.get(MORNINGMILLS) + sdf.parse(time).getTime() - sdf.parse(time.substring(0, 11).concat(afternoons[0]).concat(MILLSSTR)).getTime() : betweenMills.get(AFTERNOONMILLS) - (sdf.parse(time).getTime() - sdf.parse(time.substring(0, 11).concat(afternoons[0]).concat(MILLSSTR)).getTime());
        } else if (timeH.compareTo(afternoons[1]) > 0) {
            workDuration = anotherDay ? allDayDuration : 0L;
        }
        return workDuration;
    }

    private static long getHalfWorkDayBetweenMills(String startTime, SimpleDateFormat sdf, String[] halfWorkDayStr) throws ParseException {
        long startMills = sdf.parse(startTime.substring(0, 11).concat(halfWorkDayStr[0]).concat(MILLSSTR)).getTime();
        long endMills = sdf.parse(startTime.substring(0, 11).concat(halfWorkDayStr[1]).concat(MILLSSTR)).getTime();
        return endMills - startMills;
    }

    private static Map<String, Long> getWorkDayBetweenMills(String startTime, String[] mornings, String[] afternoons, SimpleDateFormat sdf, LocalDateTime startTimeLocal, DateTimeFormatter dateTimeFormatter) throws ParseException {
        HashMap<String, Long> ret = new HashMap<String, Long>(8);
        long amStart = sdf.parse(startTime.substring(0, 11).concat(mornings[0]).concat(MILLSSTR)).getTime();
        long amEnd = sdf.parse(startTime.substring(0, 11).concat(mornings[1]).concat(MILLSSTR)).getTime();
        long morningMills = amEnd - amStart;
        long startMin = sdf.parse(startTime.substring(0, 11).concat(afternoons[1]).concat(MILLSSTR)).getTime();
        LocalDateTime newStartTimeLocal = startTimeLocal.plusDays(1L);
        long endTMin = sdf.parse(newStartTimeLocal.format(dateTimeFormatter).substring(0, 11).concat(mornings[0]).concat(MILLSSTR)).getTime();
        long afternoonToMorningMills = endTMin - startMin;
        long restStart = sdf.parse(startTime.substring(0, 11).concat(mornings[1]).concat(MILLSSTR)).getTime();
        long restEnd = sdf.parse(startTime.substring(0, 11).concat(afternoons[0]).concat(MILLSSTR)).getTime();
        long restMills = restEnd - restStart;
        long pmStart = sdf.parse(startTime.substring(0, 11).concat(afternoons[0]).concat(MILLSSTR)).getTime();
        long pmEnd = sdf.parse(startTime.substring(0, 11).concat(afternoons[1]).concat(MILLSSTR)).getTime();
        long afternoonMills = pmEnd - pmStart;
        ret.put(WORKDAYMILLS, morningMills + afternoonMills);
        ret.put(MORNINGMILLS, morningMills);
        ret.put(AFTERNOONTOMORNINGMILLS, afternoonToMorningMills);
        ret.put(RESTMILLS, restMills);
        ret.put(AFTERNOONMILLS, afternoonMills);
        return ret;
    }

    public static boolean getIsHavingWorkCalendarForGroup() {
        BaseDataServiceHelper baseDataServiceHelper = new BaseDataServiceHelper();
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        DynamicObject dynamicObject = baseDataServiceHelper.getWorkCalendar(Long.valueOf(rootOrgId));
        if (null == dynamicObject) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static String getCurrentYear() {
        Date currentDate = new Date();
        return String.valueOf(currentDate.getYear());
    }

    private static String getCurrentMonth() {
        Date currentDate = new Date();
        return String.valueOf(currentDate.getMonth());
    }

    public static Date getCalculationWorkCalendar(String timeUnit, String timeValue) throws ParseException {
        int tempValue;
        logger.info(String.format("begin execute getCalculationWorkCalendar:[%s]-[%s]", timeUnit, timeValue));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATETIME_PATTERN);
        String currentDate = simpleDateFormat.format(new Date());
        String resultDate = null;
        Map<String, Object> temp = WorkCalendarUtil.getCurrentWorkCalendarDate();
        String workingTimeStr = WORK_DATE_STR;
        int workTimePreDay = 480;
        if (WfUtils.isNotEmptyForMap(temp)) {
            workingTimeStr = (String)temp.get(WORKTIMESTR);
            workTimePreDay = Integer.parseInt(String.valueOf(temp.get(WORKTIMEPREDAY)));
        }
        Map<String, List<String>> lawHolidaysAndHalfWorkDays = WorkCalendarUtil.getLawHolidaysAndHalfWorkDays();
        int n = tempValue = WfUtils.isEmpty(timeValue) ? 0 : Integer.parseInt(timeValue);
        if (timeUnit.equalsIgnoreCase("min")) {
            resultDate = WorkCalendarUtil.getWorkExpireTime(currentDate, tempValue, workingTimeStr, workTimePreDay, lawHolidaysAndHalfWorkDays);
        } else if (timeUnit.equalsIgnoreCase("hour")) {
            resultDate = WorkCalendarUtil.getWorkExpireTime(currentDate, tempValue * 60, workingTimeStr, workTimePreDay, lawHolidaysAndHalfWorkDays);
        } else if (timeUnit.equalsIgnoreCase("day")) {
            resultDate = WorkCalendarUtil.getWorkExpireTime(currentDate, tempValue * workTimePreDay, workingTimeStr, workTimePreDay, lawHolidaysAndHalfWorkDays);
        } else {
            logger.info(String.format("the timeunit is error-[%s] ", timeUnit));
        }
        if (WfUtils.isNotEmpty(resultDate)) {
            return simpleDateFormat.parse(resultDate);
        }
        return null;
    }

    private static Map<String, Object> getCurrentWorkCalendarDate() {
        Map<String, Object> result = new HashMap<String, Object>(2);
        Date today = new Date();
        List<WorkDateModel> dateModels = WorkCalendarUtil.getBetweenDate(today, today);
        if (WfUtils.isNotEmptyForCollection(dateModels)) {
            result = WorkCalendarUtil.getCurrentDateWorkCalendar(dateModels.get(0));
        }
        return result;
    }

    private static Map<String, Object> getCurrentDateWorkCalendar(WorkDateModel workDateModel) {
        SimpleDateFormat hourFormat = new SimpleDateFormat(TIME_PATTERN);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        Date beginAm = workDateModel.getBeginAm();
        Date endAm = workDateModel.getEndAm();
        Date beginPm = workDateModel.getBeginPm();
        Date endPm = workDateModel.getEndPm();
        String beginAmStr = hourFormat.format(beginAm);
        String endAmStr = hourFormat.format(endAm);
        String beginPmStr = hourFormat.format(beginPm);
        String endPmStr = hourFormat.format(endPm);
        result.put(WORKTIMESTR, beginAmStr + "-" + endAmStr + "," + beginPmStr + "-" + endPmStr);
        Long amMin = (endAm.getTime() - beginAm.getTime()) / 60000L;
        Long pmMin = (endPm.getTime() - beginPm.getTime()) / 60000L;
        result.put(WORKTIMEPREDAY, amMin + pmMin);
        return result;
    }

    private static Map<String, List<String>> getLawHolidaysAndHalfWorkDays() throws ParseException {
        DynamicObjectCollection dateentry;
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>(2);
        ArrayList<String> holidays = new ArrayList<String>(16);
        ArrayList<String> halfWorkDays = new ArrayList<String>(16);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_PATTERN);
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_PATTERN);
        Date currentDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(currentDate);
        c.add(6, 365);
        Date endDate = dateFormat.parse(dateFormat.format(c.getTime()));
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        BaseDataServiceHelper baseDataServiceHelper = new BaseDataServiceHelper();
        DynamicObject workCalendar = baseDataServiceHelper.getWorkCalendar(Long.valueOf(rootOrgId), dateFormat.parse(dateFormat.format(currentDate)), endDate);
        if (null != workCalendar && null != (dateentry = workCalendar.getDynamicObjectCollection(DATEENTRY)) && dateentry.size() > 0) {
            for (DynamicObject date : dateentry) {
                Date temp = date.getDate(WORKDATE);
                String dateType = date.getString(DATETYPE);
                if (DATETYPE_HOLIDAY.equals(dateType) || DATETYPE_RESTDAY.equals(dateType)) {
                    holidays.add(simpleDateFormat.format(temp));
                    continue;
                }
                if (!DATETYPE_HALFRESTDAY.equals(dateType)) continue;
                halfWorkDays.add(simpleDateFormat.format(temp));
            }
        }
        ret.put(LAWHOLIDAYS, holidays);
        ret.put(HALFWORKDAYS, halfWorkDays);
        return ret;
    }

    private static String rebuildDateStr(Date currentDate, String hour, String min) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_PATTERN);
        String dateStr = simpleDateFormat.format(currentDate);
        if (Integer.parseInt(hour) < 10) {
            hour = "0" + hour;
        }
        if (Integer.parseInt(min) < 10) {
            min = "0" + min;
        }
        return dateStr + " " + hour + ":" + min + ":00";
    }

    private static String getWorkExpireTime(String startTime, int timeout, String workingTimeStr, int workTimePreDay, Map<String, List<String>> lawHolidaysAndHalfWorkDays) {
        String expireTime = "";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATETIME_PATTERN);
            String[] workingTimes = workingTimeStr.split(",");
            String morning = workingTimes[0];
            String afternoon = workingTimes[1];
            String[] mornings = morning.split("-");
            String[] afternoons = afternoon.split("-");
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATETIME_PATTERN);
            LocalDateTime startTimeLocal = LocalDateTime.parse(startTime, dateTimeFormatter);
            List<String> lawHolidayList = lawHolidaysAndHalfWorkDays.get(LAWHOLIDAYS);
            List<String> halfWorkDayList = lawHolidaysAndHalfWorkDays.get(HALFWORKDAYS);
            while (lawHolidayList.contains(startTimeLocal.format(dateTimeFormatter).substring(0, 10))) {
                startTimeLocal = startTimeLocal.plusDays(1L);
                startTime = startTimeLocal.format(dateTimeFormatter).substring(0, 11).concat(mornings[0]).concat(":00");
                startTimeLocal = LocalDateTime.parse(startTime, dateTimeFormatter);
            }
            String oriStartTime = startTime;
            expireTime = WorkCalendarUtil.getCalculateExpireTime(oriStartTime, startTime, sdf, mornings, afternoons, timeout, workTimePreDay / 2, startTimeLocal, dateTimeFormatter, lawHolidayList, halfWorkDayList);
        }
        catch (ParseException e) {
            logger.warn(String.format("ParseException-[%s] ", e.getMessage()));
        }
        return expireTime;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getCalculateExpireTime(String oriStartTime, String startTime, SimpleDateFormat sdf, String[] mornings, String[] afternoons, int timeout, int workDayUnit, LocalDateTime startTimeLocal, DateTimeFormatter dateTimeFormatter, List<String> lawHolidayList, List<String> halfWorkDayList) throws ParseException {
        int afterWorkTime;
        if (halfWorkDayList.contains(startTimeLocal.format(dateTimeFormatter).substring(0, 10))) {
            String halfWorkEnd = WorkCalendarUtil.getHalfWorkDayEndTime(startTimeLocal, dateTimeFormatter, workDayUnit, mornings);
            int days = timeout / workDayUnit;
            int minus = timeout % workDayUnit;
            if (days > 0) {
                int newTimeout = timeout - workDayUnit;
                if (startTime.substring(11, 16).compareTo(mornings[0]) >= 0 && startTime.substring(11, 16).compareTo(halfWorkEnd.substring(11, 16)) < 0) {
                    int unWorkTime = Integer.parseInt(String.valueOf((sdf.parse(startTime).getTime() - sdf.parse(startTime.substring(0, 11).concat(mornings[0].concat(":00"))).getTime()) / 60000L));
                    newTimeout += unWorkTime;
                } else if (startTime.substring(11, 16).compareTo(halfWorkEnd.substring(11, 16)) >= 0) {
                    newTimeout = timeout;
                }
                startTime = WorkCalendarUtil.getNextWorkDay(startTimeLocal, lawHolidayList, dateTimeFormatter);
                startTimeLocal = LocalDateTime.parse(startTime.substring(0, 11).concat(mornings[0].concat(":00")), dateTimeFormatter);
                startTime = startTimeLocal.format(dateTimeFormatter);
                return WorkCalendarUtil.getCalculateExpireTime(oriStartTime, startTime, sdf, mornings, afternoons, newTimeout, workDayUnit, startTimeLocal, dateTimeFormatter, lawHolidayList, halfWorkDayList);
            }
            if (startTime.substring(11, 16).compareTo(mornings[0]) < 0) {
                String newStartTime = startTimeLocal.format(dateTimeFormatter).substring(0, 11).concat(mornings[0]).concat(":00");
                startTimeLocal = LocalDateTime.parse(newStartTime, dateTimeFormatter);
                startTimeLocal = startTimeLocal.plusMinutes(minus);
                return startTimeLocal.format(dateTimeFormatter);
            }
            if (startTime.substring(11, 16).compareTo(mornings[0]) >= 0 && startTime.substring(11, 16).compareTo(halfWorkEnd.substring(11, 16)) < 0) {
                startTimeLocal = LocalDateTime.parse(startTime, dateTimeFormatter);
                startTime = (startTimeLocal = startTimeLocal.plusMinutes(minus)).format(dateTimeFormatter);
                if (startTime.substring(11, 16).compareTo(halfWorkEnd.substring(11, 16)) <= 0) return startTime;
                startTime = WorkCalendarUtil.getNextWorkDay(startTimeLocal, lawHolidayList, dateTimeFormatter);
                startTimeLocal = LocalDateTime.parse(startTime.substring(0, 11).concat(mornings[0].concat(":00")), dateTimeFormatter);
                startTime = startTimeLocal.format(dateTimeFormatter);
                return WorkCalendarUtil.getCalculateExpireTime(oriStartTime, startTime, sdf, mornings, afternoons, timeout - workDayUnit <= 0 ? timeout : timeout - workDayUnit, workDayUnit, startTimeLocal, dateTimeFormatter, lawHolidayList, halfWorkDayList);
            }
            if (startTime.substring(11, 16).compareTo(halfWorkEnd.substring(11, 16)) <= 0) return startTime;
            startTime = WorkCalendarUtil.getNextWorkDay(startTimeLocal, lawHolidayList, dateTimeFormatter);
            startTimeLocal = LocalDateTime.parse(startTime.substring(0, 11).concat(mornings[0].concat(":00")), dateTimeFormatter);
            startTime = startTimeLocal.format(dateTimeFormatter);
            return WorkCalendarUtil.getCalculateExpireTime(oriStartTime, startTime, sdf, mornings, afternoons, timeout - workDayUnit <= 0 ? timeout : timeout - workDayUnit, workDayUnit, startTimeLocal, dateTimeFormatter, lawHolidayList, halfWorkDayList);
        }
        Map<String, Integer> betweenTimeMap = WorkCalendarUtil.getBetweenTime(startTime, mornings, afternoons, sdf, startTimeLocal, dateTimeFormatter);
        int morningMin = betweenTimeMap.get("morningMin");
        int betweenAfternoonToMorning = betweenTimeMap.get("betweenAfternoonToMorning");
        int restMin = betweenTimeMap.get("restMin");
        int days = timeout / (2 * workDayUnit);
        int minus = timeout % (2 * workDayUnit);
        if (days > 0) {
            int unWorkTime = WorkCalendarUtil.getUnWorkTimeOneDay(startTime, mornings, afternoons, sdf, morningMin);
            int newTimeout = timeout - 2 * workDayUnit + unWorkTime;
            startTime = WorkCalendarUtil.getNextWorkDay(startTimeLocal, lawHolidayList, dateTimeFormatter);
            startTimeLocal = LocalDateTime.parse(startTime.substring(0, 11).concat(mornings[0].concat(":00")), dateTimeFormatter);
            startTime = startTimeLocal.format(dateTimeFormatter);
            return WorkCalendarUtil.getCalculateExpireTime(oriStartTime, startTime, sdf, mornings, afternoons, newTimeout, workDayUnit, startTimeLocal, dateTimeFormatter, lawHolidayList, halfWorkDayList);
        }
        if (days == 0 && (afterWorkTime = oriStartTime.substring(11, 16).compareTo(afternoons[1])) >= 0) {
            startTime = WorkCalendarUtil.getNextWorkDay(startTimeLocal, lawHolidayList, dateTimeFormatter);
            startTimeLocal = LocalDateTime.parse(startTime.substring(0, 11).concat(mornings[0].concat(":00")), dateTimeFormatter);
            return startTimeLocal.format(dateTimeFormatter);
        }
        int morningCompare = startTime.substring(11, 16).compareTo(mornings[0]);
        if (morningCompare < 0) {
            if (minus < morningMin) {
                startTimeLocal = LocalDateTime.parse(startTime.substring(0, 11).concat(mornings[0]).concat(":00"), dateTimeFormatter);
                startTimeLocal = startTimeLocal.plusMinutes(minus);
                return startTimeLocal.format(dateTimeFormatter);
            } else {
                if (minus <= morningMin) return startTimeLocal.format(dateTimeFormatter);
                startTimeLocal = LocalDateTime.parse(startTime.substring(0, 11).concat(afternoons[0]).concat(":00"), dateTimeFormatter);
                startTimeLocal = startTimeLocal.plusMinutes(minus - morningMin);
            }
            return startTimeLocal.format(dateTimeFormatter);
        }
        if (morningCompare >= 0 && startTime.substring(11, 16).compareTo(mornings[1]) < 0) {
            startTime = (startTimeLocal = startTimeLocal.plusMinutes(minus)).format(dateTimeFormatter);
            if (startTime.substring(11, 16).compareTo(mornings[1]) <= 0) {
                return startTime;
            }
            if (startTime.substring(11, 16).compareTo(mornings[1]) > 0 && startTime.substring(11, 16).compareTo(afternoons[0]) < 0) {
                startTime = (startTimeLocal = startTimeLocal.plusMinutes(restMin)).format(dateTimeFormatter);
                if (startTime.substring(11, 16).compareTo(afternoons[1]) <= 0) return startTime;
                return WorkCalendarUtil.getNextDay(startTime, startTimeLocal, dateTimeFormatter, lawHolidayList, betweenAfternoonToMorning);
            }
            if (startTime.substring(11, 16).compareTo(afternoons[0]) <= 0) return WorkCalendarUtil.getNextDay(startTime, startTimeLocal, dateTimeFormatter, lawHolidayList, betweenAfternoonToMorning);
            if (startTime.substring(11, 16).compareTo(afternoons[1]) >= 0) return WorkCalendarUtil.getNextDay(startTime, startTimeLocal, dateTimeFormatter, lawHolidayList, betweenAfternoonToMorning);
            return startTime;
        }
        if (startTime.substring(11, 16).compareTo(mornings[1]) >= 0 && startTime.substring(11, 16).compareTo(afternoons[0]) < 0) {
            startTimeLocal = LocalDateTime.parse(startTime.substring(0, 11).concat(afternoons[0]).concat(":00"), dateTimeFormatter);
            startTime = (startTimeLocal = startTimeLocal.plusMinutes(minus)).format(dateTimeFormatter);
            if (startTime.substring(11, 16).compareTo(afternoons[0]) <= 0) return WorkCalendarUtil.getNextDay(startTime, startTimeLocal, dateTimeFormatter, lawHolidayList, betweenAfternoonToMorning);
            if (startTime.substring(11, 16).compareTo(afternoons[1]) >= 0) return WorkCalendarUtil.getNextDay(startTime, startTimeLocal, dateTimeFormatter, lawHolidayList, betweenAfternoonToMorning);
            return startTime;
        }
        if (startTime.substring(11, 16).compareTo(afternoons[0]) >= 0 && startTime.substring(11, 16).compareTo(afternoons[1]) < 0) {
            startTime = (startTimeLocal = startTimeLocal.plusMinutes(minus)).format(dateTimeFormatter);
            if (startTime.substring(11, 16).compareTo(afternoons[0]) <= 0) return WorkCalendarUtil.getNextDay(startTime, startTimeLocal, dateTimeFormatter, lawHolidayList, betweenAfternoonToMorning);
            if (startTime.substring(11, 16).compareTo(afternoons[1]) >= 0) return WorkCalendarUtil.getNextDay(startTime, startTimeLocal, dateTimeFormatter, lawHolidayList, betweenAfternoonToMorning);
            return startTime;
        }
        if (startTime.substring(11, 16).compareTo(afternoons[1]) < 0) return startTime;
        startTime = WorkCalendarUtil.getNextWorkDay(startTimeLocal, lawHolidayList, dateTimeFormatter);
        startTimeLocal = LocalDateTime.parse(startTime.substring(0, 11).concat(mornings[0]).concat(":00"), dateTimeFormatter);
        startTime = startTimeLocal.format(dateTimeFormatter);
        return WorkCalendarUtil.getCalculateExpireTime(oriStartTime, startTime, sdf, mornings, afternoons, timeout, workDayUnit, startTimeLocal, dateTimeFormatter, lawHolidayList, halfWorkDayList);
    }

    private static Map<String, Integer> getBetweenTime(String startTime, String[] mornings, String[] afternoons, SimpleDateFormat sdf, LocalDateTime startTimeLocal, DateTimeFormatter dateTimeFormatter) throws ParseException {
        HashMap<String, Integer> ret = new HashMap<String, Integer>(8);
        long amStart = sdf.parse(startTime.substring(0, 11).concat(mornings[0]).concat(":00")).getTime();
        long amEnd = sdf.parse(startTime.substring(0, 11).concat(mornings[1]).concat(":00")).getTime();
        int morningMin = Integer.parseInt(String.valueOf((amEnd - amStart) / 60000L));
        long startMin = sdf.parse(startTime.substring(0, 11).concat(afternoons[1]).concat(":00")).getTime();
        LocalDateTime newStartTimeLocal = startTimeLocal.plusDays(1L);
        long endTMin = sdf.parse(newStartTimeLocal.format(dateTimeFormatter).substring(0, 11).concat(mornings[0]).concat(":00")).getTime();
        int betweenAfternoonToMorning = Integer.parseInt(String.valueOf((endTMin - startMin) / 60000L));
        long restStart = sdf.parse(startTime.substring(0, 11).concat(mornings[1]).concat(":00")).getTime();
        long restEnd = sdf.parse(startTime.substring(0, 11).concat(afternoons[0]).concat(":00")).getTime();
        int restMin = Integer.parseInt(String.valueOf((restEnd - restStart) / 60000L));
        ret.put("morningMin", morningMin);
        ret.put("betweenAfternoonToMorning", betweenAfternoonToMorning);
        ret.put("restMin", restMin);
        return ret;
    }

    private static int getUnWorkTimeOneDay(String startTime, String[] mornings, String[] afternoons, SimpleDateFormat sdf, int morningMin) throws ParseException {
        int result = 0;
        String startTimeH = startTime.substring(11, 16);
        if (startTimeH.compareTo(mornings[0]) >= 0 && startTimeH.compareTo(mornings[1]) < 0) {
            result = Integer.parseInt(String.valueOf((sdf.parse(startTime).getTime() - sdf.parse(startTime.substring(0, 11).concat(mornings[0].concat(":00"))).getTime()) / 60000L));
        } else if (startTimeH.compareTo(mornings[1]) >= 0 && startTimeH.compareTo(afternoons[0]) < 0) {
            result = morningMin;
        } else if (startTimeH.compareTo(afternoons[0]) >= 0 && startTimeH.compareTo(afternoons[1]) < 0) {
            int pmUnWorkTime = Integer.parseInt(String.valueOf((sdf.parse(startTime).getTime() - sdf.parse(startTime.substring(0, 11).concat(afternoons[0].concat(":00"))).getTime()) / 60000L));
            result = morningMin + pmUnWorkTime;
        }
        return result;
    }

    private static String getHalfWorkDayEndTime(LocalDateTime startTimeLocal, DateTimeFormatter dateTimeFormatter, int wortTimeUnit, String[] mornings) {
        String halfWorkBegin = startTimeLocal.format(dateTimeFormatter).substring(0, 11).concat(mornings[0]).concat(":00");
        LocalDateTime halfWorkDay = LocalDateTime.parse(halfWorkBegin, dateTimeFormatter);
        halfWorkDay = halfWorkDay.plusMinutes(wortTimeUnit);
        return halfWorkDay.format(dateTimeFormatter);
    }

    private static String getNextDay(String startTime, LocalDateTime startTimeLocal, DateTimeFormatter dateTimeFormatter, List<String> lawHolidayList, int betweenAfternoonToMorning) {
        startTime = WorkCalendarUtil.getNextWorkDay(startTimeLocal, lawHolidayList, dateTimeFormatter);
        LocalDateTime newStart = LocalDateTime.parse(startTime, dateTimeFormatter);
        startTimeLocal = newStart.plusDays(-1L);
        startTimeLocal = startTimeLocal.plusMinutes(betweenAfternoonToMorning);
        startTime = startTimeLocal.format(dateTimeFormatter);
        return startTime;
    }

    private static String getNextWorkDay(LocalDateTime startTimeLocal, List<String> lawHolidayList, DateTimeFormatter dateTimeFormatter) {
        startTimeLocal = startTimeLocal.plusDays(1L);
        String nextWorkDay = startTimeLocal.format(dateTimeFormatter);
        while (lawHolidayList.contains(startTimeLocal.format(dateTimeFormatter).substring(0, 10))) {
            startTimeLocal = startTimeLocal.plusDays(1L);
            nextWorkDay = startTimeLocal.format(dateTimeFormatter);
        }
        return nextWorkDay;
    }
}

