/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.cmd;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ServiceFactory;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.MessageSendModel;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.impl.calculator.ParticipantCalculator;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.WfOperationLogUtil;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.cmd.MessageScheduleHelper;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.exception.ExceptionUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFIllegalArgumentException;
import kd.bos.workflow.message.api.IMessageCenterService;
import kd.bos.workflow.service.WorkflowService;

public class SendTextMessageForNodeCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient DelegateExecution execution;
    private boolean async = true;
    protected String activityId;
    private String timingEvent = null;
    private List<MessageSendModel> messageModel;
    private TaskEntity taskEntity;
    private transient Log log = LogFactory.getLog(this.getClass());

    @Deprecated
    public SendTextMessageForNodeCmd(DelegateExecution execution, String timingEvent, boolean async) {
        this.execution = execution;
        this.async = async;
        this.timingEvent = timingEvent;
    }

    public SendTextMessageForNodeCmd(DelegateExecution execution, String activityId, List<MessageSendModel> messageModel, String sendEvt, boolean async) {
        this.execution = execution;
        this.activityId = activityId;
        this.async = async;
        this.timingEvent = sendEvt;
        this.messageModel = messageModel;
    }

    public SendTextMessageForNodeCmd(TaskEntity taskEntity, String activityId, List<MessageSendModel> messageModel, String sendEvt, boolean async) {
        this.taskEntity = taskEntity;
        this.activityId = activityId;
        this.async = async;
        this.timingEvent = sendEvt;
        this.messageModel = messageModel;
    }

    public Void execute(CommandContext commandContext) {
        this.argumentsCheck();
        MessageContext ctx = null;
        List<Object> models = new ArrayList();
        if (this.execution != null) {
            ctx = MessageServiceUtil.buildMessageContext((AgentExecution)this.execution);
            models = this.buildSendModelInfo(commandContext, this.messageModel);
        } else if (this.taskEntity != null) {
            ctx = MessageServiceUtil.buildMessageContext((TaskEntity)this.taskEntity);
            models = this.buildSendModelInfo(commandContext);
        }
        if (ctx != null) {
            ctx.setTimingEvent(this.timingEvent);
        }
        if (this.async) {
            MessageScheduleHelper.sendMessageAsync((MessageContext)ctx, models);
        }
        return null;
    }

    private void argumentsCheck() {
        if (this.execution == null && this.taskEntity == null) {
            throw new WFIllegalArgumentException("execution is null");
        }
    }

    private List<MessageInfo> buildSendModelInfo(CommandContext commandContext) {
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        try {
            String businessKey = this.taskEntity.getBusinessKey();
            String entityNumber = this.taskEntity.getEntityNumber();
            ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
            ParticipantCalculator participantCalculator = processEngineConfiguration.getParticipantCalculator();
            if (CollectionUtil.isNotEmpty(this.messageModel)) {
                WorkflowService service = (WorkflowService)ServiceFactory.getService((String)"IWorkflowService");
                RepositoryService repositoryService = service.getRepositoryService();
                DynamicObject dynamicObject = WfUtils.findBusinessObject(businessKey, entityNumber);
                ArrayList userIdsForOperationLog = new ArrayList();
                String sendEvt = null;
                for (MessageSendModel model : this.messageModel) {
                    String url;
                    ILocaleString title;
                    if (!model.isNotify()) continue;
                    List userIds = participantCalculator.getUserIds(businessKey, (VariableScope)this.taskEntity, model.getReceiver());
                    if (CollectionUtil.isEmpty((Collection)userIds)) {
                        this.log.info(String.format("userIdIsNull! %s %s %s", model.getContent(), this.taskEntity.getId(), this.activityId));
                        continue;
                    }
                    userIdsForOperationLog.addAll(userIds);
                    MessageInfo info = new MessageInfo();
                    info.setUserIds(userIds);
                    ILocaleString content = this.getMessageContent(model.getContent(), repositoryService, dynamicObject);
                    if (WfUtils.isNotEmpty(content)) {
                        info.setMessageContent(content);
                    }
                    if (WfUtils.isNotEmpty(title = this.getMessageContent(model.getNotifysubject(), repositoryService, dynamicObject))) {
                        info.setMessageContent(title);
                    }
                    if (null == sendEvt) {
                        sendEvt = model.getSendevt();
                    }
                    info.setSendEvt(model.getSendevt());
                    info.setMessageType(model.getMessagetype());
                    info.setNotifyType(model.getNotifytype());
                    info.setNotify(model.isNotify());
                    info.setTemplateNumber(model.getTemplateid());
                    info.setSource("wfNode");
                    info.setNestEntityNumber(entityNumber);
                    if (WfUtils.isNotEmpty(businessKey)) {
                        info.setNestBillId(this.formatLong(businessKey));
                    }
                    if (WfUtils.isNotEmpty(url = this.buildMessageUrl(model))) {
                        info.setMobContentUrl(url);
                        info.setContentUrl(url);
                    }
                    messageInfos.add(info);
                }
                if (!userIdsForOperationLog.isEmpty()) {
                    ILocaleString opinion = null;
                    opinion = "start".equals(sendEvt) || "reject".equals(sendEvt) || "taskReceived".equals(sendEvt) ? WfUtils.getPromptWordLocaleString("\u8fdb\u5165\u8282\u70b9\u65f6\u53d1\u9001\u6d88\u606f\u94fe\u63a5", "SendTextMessageForNodeCmd_1", "bos-wf-engine") : WfUtils.getPromptWordLocaleString("\u79bb\u5f00\u8282\u70b9\u65f6\u53d1\u9001\u6d88\u606f\u94fe\u63a5", "SendTextMessageForNodeCmd_2", "bos-wf-engine");
                    Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
                    OperationLogEntity operationLog = WfOperationLogUtil.recordOperationLogForSendLinkMsg(userIdsForOperationLog, (ILocaleString)opinion, (Date)date, (DelegateExecution)this.execution);
                    WfOperationLogUtil.recordOperationLog((CommandContext)commandContext, (OperationLogEntity)operationLog);
                }
            }
        }
        catch (Exception e) {
            this.log.info("SendTextMessageForNode error :" + WfUtils.getExceptionStacktrace(e));
            ExceptionUtil.createWFMessageServiceException((Object)this.execution, (Throwable)e, (ErrorCode)WFErrorCode.buildMessageModelError(), (Object[])new Object[0]);
        }
        return messageInfos;
    }

    private ILocaleString getMessageContent(String modelContent, RepositoryService repositoryService, DynamicObject bizObj) {
        LocaleString content = new LocaleString();
        if (WfUtils.isJSONObject(modelContent)) {
            content = this.handleData(modelContent);
        }
        if (WfUtils.isNotEmpty((ILocaleString)content)) {
            LocaleString result = new LocaleString();
            for (Map.Entry entry : content.entrySet()) {
                String lang = (String)entry.getKey();
                String value = (String)entry.getValue();
                HashMap param = Maps.newHashMapWithExpectedSize((int)1);
                param.put("lang", lang);
                result.put((Object)lang, (Object)repositoryService.getMsgTemplateParseValuesCmd(value, bizObj, (VariableScope)this.taskEntity, (Map)param).getParsedContent());
            }
            return result;
        }
        this.log.info(String.format("content is null! %s %s %s", this.taskEntity.getId(), this.activityId, this.timingEvent));
        return null;
    }

    private String buildMessageUrl(MessageSendModel model) {
        return model.isMsgurl() ? this.getSendTextMessageUrl() : null;
    }

    protected List<MessageInfo> buildSendModelInfo(CommandContext commandContext, List<MessageSendModel> models) {
        ArrayList<MessageInfo> ret = new ArrayList<MessageInfo>();
        try {
            String businessKey = this.execution.getBusinessKey();
            String entityNumber = this.execution.getEntityNumber();
            boolean isOutMsg = "end".equals(this.timingEvent);
            ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
            ParticipantCalculator participantCalculator = processEngineConfiguration.getParticipantCalculator();
            if (CollectionUtil.isNotEmpty(models)) {
                JSONObject multiLangDatas = BpmnModelUtil.getMultiLangDatas((Long)this.execution.getProcessInstanceId());
                ArrayList userIdsForOperationLog = new ArrayList();
                String sendEvt = null;
                for (MessageSendModel model : models) {
                    if (!model.isNotify()) continue;
                    List userIds = participantCalculator.getUserIds(businessKey, (VariableScope)this.execution, model.getReceiver());
                    if (CollectionUtil.isNotEmpty((Collection)userIds)) {
                        MessageInfo info = new MessageInfo();
                        LocaleString content = new LocaleString();
                        if (WfUtils.isJSONObject(model.getContent())) {
                            content = this.handleData(model.getContent());
                        } else {
                            String multiKey = BpmnModelUtil.getMessageContextMultiKey((String)this.activityId, (String)model.getId(), (boolean)isOutMsg);
                            content = BpmnModelUtil.getMultiLangFieldValue((JSONObject)multiLangDatas, (String)multiKey, (String)model.getContent());
                        }
                        WorkflowService service = (WorkflowService)ServiceFactory.getService((String)"IWorkflowService");
                        RepositoryService repositoryService = service.getRepositoryService();
                        DynamicObject dynamicObject = WfUtils.findBusinessObject(businessKey, entityNumber);
                        if (WfUtils.isNotEmpty((ILocaleString)content)) {
                            LocaleString result = new LocaleString();
                            for (Map.Entry entry : content.entrySet()) {
                                String lang = (String)entry.getKey();
                                String value = (String)entry.getValue();
                                HashMap param = Maps.newHashMapWithExpectedSize((int)1);
                                param.put("lang", lang);
                                result.put((Object)lang, (Object)repositoryService.getMsgTemplateParseValuesCmd(value, dynamicObject, (VariableScope)this.execution, (Map)param).getParsedContent());
                            }
                            info.setMessageContent((ILocaleString)result);
                            info.setUserIds(userIds);
                            LocaleString title = new LocaleString();
                            if (WfUtils.isJSONObject(model.getNotifysubject())) {
                                title = this.handleData(model.getNotifysubject());
                            } else {
                                String multiTitleKey = BpmnModelUtil.getMessageTitleMultiKey((String)this.activityId, (String)model.getId(), (boolean)isOutMsg);
                                title = BpmnModelUtil.getMultiLangFieldValue((JSONObject)multiLangDatas, (String)multiTitleKey, (String)model.getNotifysubject());
                            }
                            if (WfUtils.isNotEmpty((ILocaleString)title)) {
                                LocaleString messageTitle = new LocaleString();
                                for (Map.Entry entry : title.entrySet()) {
                                    String lang = (String)entry.getKey();
                                    String value = (String)entry.getValue();
                                    HashMap param = Maps.newHashMapWithExpectedSize((int)1);
                                    param.put("lang", lang);
                                    messageTitle.put((Object)lang, (Object)repositoryService.getMsgTemplateParseValuesCmd(value, dynamicObject, (VariableScope)this.execution, (Map)param).getParsedContent());
                                }
                                info.setMessageTitle((ILocaleString)messageTitle);
                            }
                            if (null == sendEvt) {
                                sendEvt = model.getSendevt();
                            }
                            info.setSendEvt(model.getSendevt());
                            info.setMessageType(model.getMessagetype());
                            info.setNotifyType(model.getNotifytype());
                            info.setNotify(model.isNotify());
                            info.setTemplateNumber(model.getTemplateid());
                            info.setSource("wfNode");
                            info.setNestEntityNumber(entityNumber);
                            if (WfUtils.isNotEmpty(businessKey)) {
                                info.setNestBillId(this.formatLong(businessKey));
                            }
                            if (model.isMsgurl()) {
                                String url = this.getSendTextMessageUrl();
                                if (WfUtils.isEmpty(url)) {
                                    return ret;
                                }
                                info.setMobContentUrl(url);
                                info.setContentUrl(url);
                                userIdsForOperationLog.addAll(userIds);
                            }
                            ret.add(info);
                            continue;
                        }
                        this.log.debug(String.format("content is null! %s %s %s", this.execution.getProcessInstanceId(), this.activityId, this.timingEvent));
                        continue;
                    }
                    this.log.debug(String.format("userIdIsNull! %s %s %s", model.getContent(), this.execution.getProcessInstanceId(), this.activityId));
                }
                if (!userIdsForOperationLog.isEmpty()) {
                    ILocaleString opinion = null;
                    opinion = "start".equals(sendEvt) || "reject".equals(sendEvt) || "taskReceived".equals(sendEvt) ? WfUtils.getPromptWordLocaleString("\u8fdb\u5165\u8282\u70b9\u65f6\u53d1\u9001\u6d88\u606f\u94fe\u63a5", "SendTextMessageForNodeCmd_1", "bos-wf-engine") : WfUtils.getPromptWordLocaleString("\u79bb\u5f00\u8282\u70b9\u65f6\u53d1\u9001\u6d88\u606f\u94fe\u63a5", "SendTextMessageForNodeCmd_2", "bos-wf-engine");
                    Date date = commandContext.getProcessEngineConfiguration().getClock().getCurrentTime();
                    OperationLogEntity operationLog = WfOperationLogUtil.recordOperationLogForSendLinkMsg(userIdsForOperationLog, (ILocaleString)opinion, (Date)date, (DelegateExecution)this.execution);
                    WfOperationLogUtil.recordOperationLog((CommandContext)commandContext, (OperationLogEntity)operationLog);
                }
            }
        }
        catch (Exception e) {
            this.log.warn("SendTextMessageForNode error :" + WfUtils.getExceptionStacktrace(e));
            ExceptionUtil.createWFMessageServiceException((Object)this.execution, (Throwable)e, (ErrorCode)WFErrorCode.buildMessageModelError(), (Object[])new Object[0]);
        }
        return ret;
    }

    private Long formatLong(String str) {
        if (WfUtils.isEmpty(str)) {
            return null;
        }
        try {
            return Long.valueOf(str);
        }
        catch (Exception e) {
            return str.hashCode();
        }
    }

    protected ILocaleString handleData(String param) {
        LocaleString value = new LocaleString();
        JSONObject obj = JSONObject.parseObject((String)param);
        if (null != obj) {
            for (Map.Entry entry : obj.entrySet()) {
                value.setItem((String)entry.getKey(), (Object)((String)entry.getValue()));
            }
        }
        return value;
    }

    private String getSendTextMessageUrl() {
        if (this.execution == null) {
            return MessageServiceUtil.buildWebPageUrlForTaskEntity((TaskEntity)this.taskEntity) + "&type=toHandle";
        }
        FlowElement element = this.execution.getCurrentFlowElement();
        if (null == element) {
            return null;
        }
        String elementType = element.getType();
        if (WfUtils.isEmpty(elementType)) {
            return null;
        }
        if ("UserTask".equals(elementType) || "AuditTask".equals(elementType) || "YunzhijiaTask".equals(elementType)) {
            TaskEntity taskEntity = (TaskEntity)this.execution.getCurrentTask();
            if (null == taskEntity) {
                return null;
            }
            if ("YunzhijiaTask".equals(elementType) && WfUtils.isNotEmpty(taskEntity.getParentTaskId()) && null != this.execution.getParent()) {
                taskEntity = (TaskEntity)this.execution.getParent().getCurrentTask();
            }
            if (null == taskEntity) {
                return MessageServiceUtil.buildWebPageUrlForMyApplyed((Long)this.execution.getProcessInstanceId());
            }
            return MessageServiceUtil.buildWebPageUrlForTaskEntity((TaskEntity)taskEntity) + "&type=toHandle";
        }
        if ("BillTask".equals(elementType)) {
            IMessageCenterService messageService = (IMessageCenterService)ServiceFactory.getService(IMessageCenterService.class);
            Map ret = messageService.builMessageUrl(this.execution.getEntityNumber(), this.execution.getEntityNumber() + "_mob", Long.valueOf(this.execution.getBusinessKey()), null);
            return (String)ret.get("data");
        }
        if (BizFlowUtil.isBizFlowExecution((ExecutionEntity)((ExecutionEntity)this.execution))) {
            IMessageCenterService messageService = (IMessageCenterService)ServiceFactory.getService(IMessageCenterService.class);
            Map ret = messageService.builMessageUrl(this.execution.getEntityNumber(), this.execution.getEntityNumber() + "_mob", Long.valueOf(this.execution.getBusinessKey()), null);
            return (String)ret.get("data");
        }
        return MessageServiceUtil.buildWebPageUrlForMyApplyed((Long)this.execution.getProcessInstanceId());
    }
}

