/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg.handler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.handler.MessageHandler;
import kd.bos.message.utils.SMSProvider;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.util.MessageUtils;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;
import org.apache.commons.lang.math.NumberUtils;

public class SMSServiceHandler
extends AbstractServiceHandler {
    private static Log logger = LogFactory.getLog(SMSServiceHandler.class);
    public static final String LICENSE_GROUP_SMS = "CP_SMS";
    public static final String TYPE = "sms";
    private static final int CONTENTMAXLENGTH = 450;

    public String getServiceType() {
        return TYPE;
    }

    public void createToDo(MessageContext ctx, ToDoInfo info) {
        this.checkSmsLicense();
        super.createToDo(ctx, info);
        try {
            info.setUrl(info.getUrl() + "&ado=view");
            List toDoInfos = YunzhijiaToDoUtil.rebuildToDoInfo((ToDoInfo)info);
            for (ToDoInfo toDoInfo : toDoInfos) {
                toDoInfo.setUrl(toDoInfo.getUrl() + "&ado=view");
                String infoContent = this.getMessageUrlForFixed(toDoInfo.getContent());
                toDoInfo.setContent(infoContent);
                Map map = MessageUtils.getPhonesByParamsForSms((ToDoInfo)toDoInfo, null);
                Object phonesObj = null;
                Object useridAndPhone = null;
                if (WfUtils.isNotEmptyForMap(map)) {
                    phonesObj = map.get("phones");
                    useridAndPhone = map.get("useridAndPhone");
                }
                List phones = phonesObj != null ? (List)phonesObj : null;
                Map useridAndPhoneMap = useridAndPhone != null ? (Map)useridAndPhone : null;
                ShortMessageInfo shortMessageInfo = new ShortMessageInfo();
                shortMessageInfo.setUseridAndPhone(useridAndPhoneMap);
                shortMessageInfo.setMessage(toDoInfo.getContent());
                shortMessageInfo.setPhone(phones);
                shortMessageInfo.setSignature(MessageUtils.getSingture((String)((String)toDoInfo.getParams().get("lang"))));
                shortMessageInfo.setBizDataId(ctx.getBusinessKey());
                shortMessageInfo.setType("todo");
                shortMessageInfo.setEntityNumber(ctx.getEntityNumber());
                shortMessageInfo.setMessageId(toDoInfo.getTaskId());
                Map res = MessageHandler.sendShortMessage((ShortMessageInfo)shortMessageInfo);
                if (!((Boolean)res.get("result")).booleanValue()) {
                    throw new WFMessageServiceException(null, WFErrorCode.smsSendMsgError(), new Object[]{"take MessageHandler has exception " + res.get("description")});
                }
                logger.info(String.format("[%s]\u53d1\u9001\u77ed\u4fe1\u5f85\u529e\u6d88\u606f\u6210\u529f", RequestContext.get().getTraceId()));
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw new WFMessageServiceException((Throwable)e, WFErrorCode.smsSendTodoError(), new Object[]{e.getMessage()});
        }
    }

    protected void clearMessageUserCollection(ToDoInfo todoInfo, MessageInfo messageInfo) {
        List userIds;
        super.clearMessageUserCollection(todoInfo, messageInfo);
        if (WfUtils.isNullObject(messageInfo)) {
            return;
        }
        MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)TYPE);
        String smsProvider = msgChannelInfo.getSmsProvider();
        if (!SMSProvider.isWeiGouTong((String)smsProvider)) {
            return;
        }
        List list = userIds = WfUtils.isNullObject(todoInfo) ? messageInfo.getUserIds() : todoInfo.getUserIds();
        if (WfUtils.isEmptyForCollection(userIds)) {
            this.handlePhoneSingleBackUp(todoInfo, messageInfo);
            return;
        }
        this.handleUserIdBackUp(todoInfo, messageInfo);
    }

    private void handlePhoneSingleBackUp(ToDoInfo todoInfo, MessageInfo messageInfo) {
        Map params;
        boolean isMsg = WfUtils.isNullObject(todoInfo);
        Map map = params = isMsg ? messageInfo.getParams() : todoInfo.getParams();
        if (WfUtils.isEmptyForMap(params) || !params.containsKey("phone")) {
            return;
        }
        Object phoneObj = params.get("phone");
        if (!(phoneObj instanceof List)) {
            return;
        }
        List phone = (List)phoneObj;
        Map<Boolean, List<String>> collect = phone.stream().collect(Collectors.groupingBy(this::isUserPhoneInternational));
        List<String> afterClearPhones = collect.get(Boolean.FALSE);
        params.put("phone", afterClearPhones);
        List<String> backupUserPhones = collect.get(Boolean.TRUE);
        this.handleBackUpParam(messageInfo, "internationalPhoneNumbers", backupUserPhones);
    }

    private void handleUserIdBackUp(ToDoInfo todoInfo, MessageInfo messageInfo) {
        Map map = MessageUtils.getPhonesByParamsForSms((ToDoInfo)todoInfo, (MessageInfo)messageInfo);
        if (WfUtils.isEmptyForMap(map) || !map.containsKey("useridAndPhone")) {
            return;
        }
        Object uIdAndPhoneObj = map.get("useridAndPhone");
        if (!(uIdAndPhoneObj instanceof Map)) {
            return;
        }
        Map uIdAndPhone = (Map)uIdAndPhoneObj;
        Map collect = uIdAndPhone.entrySet().stream().collect(Collectors.groupingBy(t -> this.isUserPhoneInternational((String)t.getKey()), Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        List afterClearUserIds = collect.get(Boolean.FALSE);
        List backupUserIds = collect.get(Boolean.TRUE);
        if (WfUtils.isNotNullObject(todoInfo)) {
            todoInfo.setUserIds(afterClearUserIds);
            return;
        }
        messageInfo.setUserIds(afterClearUserIds);
        this.handleBackUpParam(messageInfo, "internationalPhoneNumbersUsers", backupUserIds);
    }

    private <T> void handleBackUpParam(MessageInfo messageInfo, String key, List<T> backup) {
        if (WfUtils.isEmptyForCollection(backup)) {
            return;
        }
        Map params = messageInfo.getParams();
        if (WfUtils.isNullObject(params)) {
            params = Maps.newHashMapWithExpectedSize((int)NumberUtils.INTEGER_ONE);
            messageInfo.setParams(params);
        }
        Map userFilter = params.getOrDefault("userFilter", Maps.newHashMapWithExpectedSize((int)NumberUtils.INTEGER_ONE));
        List internationalPhone = userFilter.getOrDefault("internationalPhoneNumbers", Lists.newArrayListWithExpectedSize((int)backup.size()));
        internationalPhone.addAll(backup);
        userFilter.put(key, internationalPhone);
        params.put("userFilter", userFilter);
    }

    private boolean isUserPhoneInternational(String phone) {
        if (WfUtils.isEmpty(phone) || !phone.contains("-")) {
            return Boolean.FALSE;
        }
        String[] num = phone.split("-");
        if (num.length < NumberUtils.INTEGER_ONE || Objects.equals(num[NumberUtils.INTEGER_ZERO], "86") || Objects.equals(num[NumberUtils.INTEGER_ZERO], "+86")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void dealToDo(MessageContext ctx, ToDoInfo info) {
        logger.info(String.format("nothing to do for[%s] when dealing sms todo", info.getTaskId()));
    }

    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
        logger.info(String.format("nothing to do for[%s] when deleting sms todo", info.getTaskId()));
    }

    public void sendMessage(MessageContext ctx, MessageInfo message) {
        this.checkShortMessageLicense(message);
        try {
            super.sendMessage(ctx, message);
            MessageUtils.wrapMessageContent((MessageInfo)message, (String)TYPE);
            List messageUsers = this.getMessageUser(message);
            if (messageUsers.isEmpty()) {
                throw new WFMessageServiceException(null, WFErrorCode.smsSendMsgError(), new Object[]{"message userIds has no openIds all"});
            }
            List messages = this.rebuildMessageInfos(message);
            if (MessageUtils.isBlankMessage((List)messages)) {
                logger.info("SMSServiceHandler-- messagecontent is blank");
                throw new WFMessageServiceException(null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
            }
            this.sendServiceMessage(messages, messageUsers, true);
        }
        catch (Exception e) {
            throw new WFMessageServiceException((Throwable)e, WFErrorCode.smsSendMsgError(), new Object[]{WfUtils.getExceptionStacktrace(e)});
        }
    }

    public boolean inspectChannelInfo(MsgChannelInfo msgChannelInfo) {
        String smsProvider = msgChannelInfo.getSmsProvider();
        if (SMSProvider.isWeiGouTong((String)smsProvider)) {
            String weiGouTongSMSApiUrl = msgChannelInfo.getWeiGouTongSmsApiUrl();
            String weiGouTongClientId = msgChannelInfo.getWeiGouTongClientId();
            String weiGouTongClientSecret = msgChannelInfo.getWeiGouTongClientSecret();
            String weiGouTongExtNo = msgChannelInfo.getWeiGouTongExtNo();
            return WfUtils.isNotEmpty(weiGouTongSMSApiUrl) && WfUtils.isNotEmpty(weiGouTongClientId) && WfUtils.isNotEmpty(weiGouTongClientSecret) && WfUtils.isNotEmpty(weiGouTongExtNo);
        }
        if (SMSProvider.isCloudPlat((String)smsProvider)) {
            String smsCode = msgChannelInfo.getSmscode();
            String apiUrl = msgChannelInfo.getSmsapiurl();
            String clientId = msgChannelInfo.getClientid();
            String clientSecret = msgChannelInfo.getClientsecret();
            return !WfUtils.isEmpty(smsCode) && !WfUtils.isEmpty(apiUrl) && !WfUtils.isEmpty(clientId) && !WfUtils.isEmpty(clientSecret);
        }
        return Boolean.FALSE;
    }

    public void beforePostMessage(MessageInfo message) {
        String msgContent = this.getMessageUrlForFixed(message.getContent());
        message.setContent(msgContent);
    }

    public Map<String, Object> postMessage(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        ShortMessageInfo shortMessageInfo = this.buildShortMessageInfo(messageInfo, messageUsers);
        logger.info("\u77ed\u4fe1\u670d\u52a1\uff1a\u7ec4\u88c5\u77ed\u4fe1\u5bf9\u8c61\u5b8c\u6bd5");
        return MessageHandler.sendShortMessage((ShortMessageInfo)shortMessageInfo, (Map)messageInfo.getParams());
    }

    private ShortMessageInfo buildShortMessageInfo(MessageInfo message, List<MessageUser> messageUsers) {
        HashMap<String, Long> phoneUserIdImapping = new HashMap<String, Long>(messageUsers.size());
        ArrayList<String> phones = new ArrayList<String>(messageUsers.size());
        for (MessageUser messageUser : messageUsers) {
            String phone = messageUser.getOpenId();
            Long userId = messageUser.getUserId();
            phones.add(phone);
            if (userId.equals(0L)) continue;
            phoneUserIdImapping.put(phone, userId);
        }
        ShortMessageInfo shortMessageInfo = new ShortMessageInfo();
        shortMessageInfo.setMessage(message.getContent());
        shortMessageInfo.setPhone(phones);
        shortMessageInfo.setBizDataId(String.valueOf(message.getBizDataId()));
        shortMessageInfo.setEntityNumber(message.getEntityNumber());
        shortMessageInfo.setTag(message.getTag());
        shortMessageInfo.setMessageId(message.getId());
        shortMessageInfo.setType("msg");
        shortMessageInfo.setUseridAndPhone(phoneUserIdImapping);
        shortMessageInfo.setSignature(MessageUtils.getSingture((String)((String)message.getParams().get("lang"))));
        return shortMessageInfo;
    }

    private void checkShortMessageLicense(MessageInfo messageInfo) {
        Object isCheckLicense;
        Map param = messageInfo.getParams();
        if (param != null && !param.isEmpty() && (isCheckLicense = param.get("iscl")) != null && !((Boolean)isCheckLicense).booleanValue()) {
            return;
        }
        this.checkSmsLicense();
    }

    private void checkSmsLicense() {
        MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)TYPE);
        if (WfUtils.isNullObject(msgChannelInfo)) {
            throw new WFMessageServiceException(null, WFErrorCode.smsSendMsgError(), new Object[]{"If you have not configured the messaging service, you cannot send SMS, please go to \u201cPublic Settings>Messaging Settings\u201d to configure it."});
        }
        if (!SMSProvider.isCloudPlat((String)msgChannelInfo.getSmsProvider())) {
            return;
        }
        Boolean isUserInGroup = LicenseServiceHelper.checkPerformGroup((String)LICENSE_GROUP_SMS).getHasLicense();
        if (!isUserInGroup.booleanValue()) {
            throw new WFMessageServiceException(null, WFErrorCode.smsSendMsgError(), new Object[]{"SMS sending failed. The enterprise has not purchased the SMS service product license. Please contact the administrator."});
        }
    }

    private String getMessageUrlForFixed(String content) {
        String contentNew;
        String[] contentParams = content.split("http");
        StringBuilder msgNewContent = new StringBuilder(contentParams[0]);
        if (contentParams.length > 1) {
            for (int i = 1; i < contentParams.length; ++i) {
                String data = "http" + contentParams[i];
                String u = SMSServiceHandler.findUrlByStr(data);
                String uNew = SMSServiceHandler.wrapUrl(u);
                int startIndex = data.indexOf(u);
                String s1 = data.substring(0, startIndex);
                String s2 = data.substring(startIndex + u.length(), data.length());
                String pNew = s1 + uNew + s2;
                msgNewContent.append(pNew);
            }
        }
        if ((contentNew = msgNewContent.toString()).length() > 435) {
            throw new WFMessageServiceException(null, WFErrorCode.smsSendMsgError(), new Object[]{"the size of sms content beyond 450"});
        }
        return contentNew;
    }

    private static String wrapUrl(String url) {
        StringBuilder sb = new StringBuilder();
        String[] params = url.split("&");
        for (int i = 0; i < params.length; ++i) {
            String p = params[i];
            if (p.contains("pCaption") || p.contains("mCaption")) continue;
            if (i != params.length - 1) {
                sb.append(p).append('&');
                continue;
            }
            sb.append(p);
        }
        String urlNew = sb.toString();
        urlNew = urlNew.endsWith("&") ? urlNew.substring(0, urlNew.length() - 1) : urlNew;
        return urlNew;
    }

    private static String findUrlByStr(String data) {
        Pattern pattern = Pattern.compile("https?://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]");
        Matcher matcher = pattern.matcher(data);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }
}

