/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.util.concurrent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.BoundaryEvent;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.IdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.util.concurrent.AbstractConcurrentInfoHandler;
import kd.bos.workflow.util.concurrent.ConcurrentDataUpdateUtil;

public class HiTaskPresentAssigneeUpdater
extends AbstractConcurrentInfoHandler {
    private static final Integer BATCHCOUNT = 500;
    private static Log logger = LogFactory.getLog(HiTaskPresentAssigneeUpdater.class);

    public HiTaskPresentAssigneeUpdater(String cacheInfo, ExecutionEntity execution, Map<String, Object> params) {
        super(cacheInfo, execution, params);
    }

    public String calculateValue(CommandContext commandContext) {
        Boolean isWithdraw;
        ILocaleString presentAssigen = null;
        Boolean bl = isWithdraw = this.params.get("iswithdraw") != null ? (Boolean)this.params.get("iswithdraw") : Boolean.FALSE;
        if (!isWithdraw.booleanValue() && ("end".equals(this.execution.getEventName()) || "terminate".equalsIgnoreCase(this.execution.getEventName()))) {
            presentAssigen = this.execution.getActivityName();
        } else {
            Long rootProInstId = this.execution.getProcessInstanceId();
            ExecutionEntityManager executionMgr = commandContext.getExecutionEntityManager();
            List<ExecutionEntity> execEntityList = commandContext.getWithdrawExes();
            if (execEntityList == null || execEntityList.isEmpty()) {
                execEntityList = executionMgr.findChildExecutionsByProcessInstanceId(rootProInstId);
            }
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((Long)this.execution.getProcessInstance().getProcessDefinitionId(), (Long)rootProInstId);
            Process process = bpmnModel.getMainProcess();
            ArrayList<ILocaleString> currentAssigenList = new ArrayList<ILocaleString>();
            HashMap<Long, Integer> yunzhijiaTasks = new HashMap<Long, Integer>();
            HashMap<String, String> flowElementIds = new HashMap<String, String>(execEntityList.size());
            for (ExecutionEntity exec : execEntityList) {
                if (exec.isScope() || exec.isBillExecution()) continue;
                if (!exec.isActive()) {
                    FlowNode flowNode;
                    FlowElement curFlowElement = process.getFlowElement(exec.getActivityId(), true);
                    if (!isWithdraw.booleanValue() || !(curFlowElement instanceof FlowNode) || (flowNode = (FlowNode)curFlowElement).getJoin() == null || !flowNode.getJoin().booleanValue() || !"enterwhenallarrive".equals(flowNode.getInSet())) continue;
                }
                FlowElement flowElement = null;
                if (this.execution.getCurrentFlowElement() instanceof FlowNode && !(this.execution.getCurrentFlowElement() instanceof BoundaryEvent) && this.execution.getId().equals(exec.getId())) {
                    flowElement = this.execution.getCurrentFlowElement();
                } else {
                    FlowElement elem = process.getFlowElement(exec.getActivityId(), true);
                    if (elem instanceof BoundaryEvent) continue;
                    if (elem == null && exec.getCurrentFlowElement() != null) {
                        elem = exec.getCurrentFlowElement();
                    }
                    if (elem != null && WfUtils.isNotEmpty(elem.getName())) {
                        flowElement = elem;
                    }
                }
                if (flowElement == null || !BpmnModelUtil.instanceofYunzhijiaTask((String)flowElement.getType()) && flowElementIds.containsKey(flowElement.getId())) continue;
                flowElementIds.put(flowElement.getId(), flowElement.getId());
                if (flowElement instanceof UserTask) {
                    ILocaleString currentAssigen = HiTaskPresentAssigneeUpdater.getCurrentAssigenByTask(commandContext, flowElement, exec, yunzhijiaTasks, currentAssigenList, this.params, isWithdraw);
                    if (!StringUtils.isNotBlank((Object)currentAssigen)) continue;
                    currentAssigenList.add(currentAssigen);
                    continue;
                }
                if (flowElement instanceof CallActivity) {
                    ILocaleString callActivityName = WfMultiLangUtils.jointILocaleString((ILocaleString)(WfUtils.isEmpty(exec.getActivityName()) ? exec.getParent().getActivityName() : exec.getActivityName()), (ILocaleString)exec.getPresentAssignee(), (String)"(", null, (String)")");
                    currentAssigenList.add(callActivityName);
                    continue;
                }
                currentAssigenList.add(exec.getActivityName());
            }
            presentAssigen = WfMultiLangUtils.jointCollectionLocaleString(currentAssigenList, (String)"\uff1b");
        }
        return SerializationUtils.toJsonString((Object)presentAssigen);
    }

    public void insertToDB(String value, CommandContext commandContext) {
        Long processInstanceId = this.execution.getProcessInstanceId();
        if (StringUtils.isNotBlank((Object)processInstanceId)) {
            ILocaleString presentAssignee = (ILocaleString)SerializationUtils.fromJsonString((String)value, LocaleString.class);
            if (WfUtils.isEmpty(presentAssignee)) {
                return;
            }
            logger.debug("insertToDB_presentAssigen:" + value);
            HistoricTaskInstanceEntityManager hitaskMgr = commandContext.getHistoricTaskInstanceEntityManager();
            QFilter filter = new QFilter("processinstanceid", "=", (Object)processInstanceId);
            List hiTasks = hitaskMgr.findByQueryFilters(new QFilter[]{filter});
            LocaleString presentAssigneeForComment = new LocaleString();
            for (Map.Entry entry : presentAssignee.entrySet()) {
                presentAssignee.setItem((String)entry.getKey(), (Object)StringUtils.substring((String)((String)entry.getValue()), (int)0, (int)2000));
                presentAssigneeForComment.setItem((String)entry.getKey(), (Object)StringUtils.substring((String)((String)entry.getValue()), (int)0, (int)1000));
            }
            int len = hiTasks.size();
            for (int i = 0; i < len; ++i) {
                HistoricTaskInstanceEntity hitaskInst = (HistoricTaskInstanceEntity)hiTasks.get(i);
                hitaskInst.setPresentAssignee(presentAssignee);
                hitaskMgr.update((Entity)hitaskInst);
            }
            ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
            ExecutionEntity procInst = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
            if (procInst != null) {
                procInst.setPresentAssignee(presentAssignee);
                executionEntityManager.update((Entity)procInst);
                if (procInst.getSuperExecution() != null) {
                    procInst.getSuperExecution().setPresentAssignee(presentAssignee);
                    executionEntityManager.update((Entity)procInst.getSuperExecution());
                    ConcurrentDataUpdateUtil.updatePresentAssignee((ExecutionEntity)procInst.getSuperExecution(), (CommandContext)commandContext, null);
                }
            }
            CommentEntityManager commentEntityManager = commandContext.getCommentEntityManager();
            QFilter f = new QFilter("taskid", "in", hiTasks.stream().map(e -> e.getId()).collect(Collectors.toList()));
            List hiComments = commentEntityManager.findByQueryFilters(new QFilter[]{f});
            hiComments.forEach(arg_0 -> HiTaskPresentAssigneeUpdater.lambda$insertToDB$1((ILocaleString)presentAssigneeForComment, commentEntityManager, arg_0));
        }
    }

    private static ILocaleString getCurrentAssigenByTask(CommandContext commandContext, FlowElement flowElement, ExecutionEntity exec, Map<Long, Integer> yunzhijiaTasks, List<ILocaleString> currentAssigenList, Map<String, Object> param, Boolean isWithdraw) {
        LocaleString assigen = new LocaleString();
        ILocaleString activityName = exec.getActivityName();
        boolean userDisplaySetting = WfConfigurationUtil.isDisplaySetting();
        if (exec.getCurrentTask() != null) {
            if (BpmnModelUtil.isFirstNodeByModel((FlowNode)((UserTask)flowElement)) && exec.getCurrentTask().getIdentityLinks().isEmpty()) {
                assigen = userDisplaySetting ? exec.getCurrentTask().getStartNameFormat() : exec.getCurrentTask().getStartName();
                return WfMultiLangUtils.jointILocaleString((ILocaleString)activityName, (ILocaleString)assigen, (String)"\uff0f");
            }
            if (isWithdraw.booleanValue()) {
                List hiIdentityLinks = commandContext.getHistoricIdentityLinkEntityManager().findHistoricIdentityLinksByTaskId(exec.getCurrentTaskId());
                for (int i = 0; i < hiIdentityLinks.size(); ++i) {
                    HistoricIdentityLinkEntity identityLinkEntity = (HistoricIdentityLinkEntity)hiIdentityLinks.get(i);
                    if (!WfUtils.isEmpty(identityLinkEntity.getTrustName())) continue;
                    assigen = userDisplaySetting ? WfMultiLangUtils.jointILocaleString((ILocaleString)assigen, (ILocaleString)identityLinkEntity.getUserNameFormatter(), (String)"\uff0c") : WfMultiLangUtils.jointILocaleString((ILocaleString)assigen, (ILocaleString)identityLinkEntity.getUserName(), (String)"\uff0c");
                }
            } else {
                List identityLinks = exec.getCurrentTaskId() != null && exec.getCurrentTaskId().equals(param.get(String.valueOf(exec.getCurrentTaskId()))) ? commandContext.getIdentityLinkEntityManager().findIdentityLinksByTaskId(exec.getCurrentTaskId()) : exec.getCurrentTask().getIdentityLinks();
                for (int i = 0; i < identityLinks.size(); ++i) {
                    IdentityLinkEntity identityLinkEntity = (IdentityLinkEntity)identityLinks.get(i);
                    if (!WfUtils.isEmpty(identityLinkEntity.getTrustName()) || "coordinate".equals(identityLinkEntity.getType())) continue;
                    ILocaleString taskAssigen = HiTaskPresentAssigneeUpdater.getAssigen(identityLinkEntity, userDisplaySetting);
                    assigen = WfUtils.isEmpty((ILocaleString)assigen) ? taskAssigen : WfMultiLangUtils.jointILocaleString((ILocaleString)assigen, (ILocaleString)taskAssigen, (String)"\uff0c");
                }
            }
        }
        if (BpmnModelUtil.instanceofYunzhijiaTask((String)flowElement.getType()) && exec.getParent().getCurrentTask() != null) {
            if (StringUtils.isNotBlank((Object)yunzhijiaTasks.get(exec.getParent().getCurrentTaskId()))) {
                currentAssigenList.set(yunzhijiaTasks.get(exec.getParent().getCurrentTaskId()), HiTaskPresentAssigneeUpdater.joinYunzhijiaTaskPresentAssigne(currentAssigenList.get(yunzhijiaTasks.get(exec.getParent().getCurrentTaskId())), (ILocaleString)assigen));
                return null;
            }
            activityName = exec.getParent().getActivityName();
            yunzhijiaTasks.put(exec.getParent().getCurrentTaskId(), currentAssigenList.size());
        }
        return WfMultiLangUtils.jointILocaleString((ILocaleString)activityName, (ILocaleString)assigen, (String)"\uff0f");
    }

    private static ILocaleString joinYunzhijiaTaskPresentAssigne(ILocaleString taskPresentAssigen, ILocaleString assigen) {
        if (WfUtils.isEmpty(assigen)) {
            return taskPresentAssigen;
        }
        LocaleString newStr = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            String newAssigne;
            String lan = lang.toString();
            String oldAssigne = WfUtils.isEmpty((String)taskPresentAssigen.get((Object)lan)) ? taskPresentAssigen.toString() : (String)taskPresentAssigen.get((Object)lan);
            String string = newAssigne = WfUtils.isEmpty((String)assigen.get((Object)lan)) ? assigen.toString() : (String)assigen.get((Object)lan);
            if (!oldAssigne.contains("\uff0f")) {
                oldAssigne = oldAssigne + "\uff0f";
                newStr.setItem(lan, (Object)String.format("%s%s", oldAssigne, newAssigne));
                continue;
            }
            newStr.setItem(lan, (Object)String.format("%s%s%s", oldAssigne, "\uff0c", newAssigne));
        }
        return newStr;
    }

    private static ILocaleString getAssigen(IdentityLinkEntity identityLinkEntity, boolean isDisplaySetting) {
        if (isDisplaySetting) {
            return identityLinkEntity.getUserNameFormatter();
        }
        return identityLinkEntity.getUserName();
    }

    private static /* synthetic */ void lambda$insertToDB$1(ILocaleString presentAssigneeForComment, CommentEntityManager commentEntityManager, CommentEntity hiComment) {
        hiComment.setPresentAssignee(presentAssigneeForComment);
        commentEntityManager.update((Entity)hiComment);
    }
}

