/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.formplugin;

import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.filter.SchemeFilterView;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.ListExpandEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.SetCellFieldValueArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.msg.quantitysum.LocalVariables;
import kd.bos.workflow.message.formplugin.MessageContentPlugin;
import kd.bos.workflow.message.service.MessageCenterService;
import kd.bos.workflow.service.impl.ServiceFactory;
import org.jsoup.Jsoup;

public class MessageListPlugin
extends AbstractListPlugin
implements IConfirmCallBack {
    public static final String READ = "read";
    public static final String UNREAD = "unread";
    public static final String NOREADSTATE = "noreadstate";
    public static final String SENDERNAME = "sendername";
    public static final String SENDER = "sender";
    public static final String BOSWFMESSAGE = "bos-wf-message";
    public static final String READSTATE = "readstate";
    private static final String CREATEDATE = "createdate";
    public static final String LIKE = "like";
    public static final String AND = "AND";
    public static final String OR = "OR";
    private static Log logger = LogFactory.getLog(MessageListPlugin.class);
    private static final Map<String, String> mapping = new HashMap<String, String>();

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (!WfConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue() || !WfConfigurationUtil.isRepaireMsgContentSummaryFinish().booleanValue()) {
            BillList list = (BillList)this.getControl("billlistap");
            list.getView().setVisible(Boolean.FALSE, new String[]{"content_summary"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long pk = (Long)event.getCurrentRow().getPrimaryKeyValue();
        try {
            DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"wf_msg_message", (String)"type, contenturl,config");
            if (dynObj != null) {
                String contentUrl = dynObj.getString("contenturl");
                if (WfUtils.isNotEmpty((String)contentUrl)) {
                    StringBuilder newContentUrl = new StringBuilder(contentUrl);
                    contentUrl = newContentUrl.append("&apptype=").append("mcenter").append("&msgId=").append(pk).toString();
                    new MessageContentPlugin().showContent(this.getView(), pk.longValue(), contentUrl, 2);
                    ArrayList<Long> msgIds = new ArrayList<Long>(1);
                    msgIds.add(pk);
                    ((MessageCenterService)ServiceFactory.getService(MessageCenterService.class)).setReadState(msgIds, READ, (Object)RequestContext.get().getUserId());
                    ((IListView)this.getView()).refresh();
                } else {
                    String config;
                    Long type = dynObj.getLong("type");
                    String url = this.getActivityMsgUrl(type, config = dynObj.getString("config"));
                    if (WfUtils.isNotEmpty((String)url)) {
                        this.getView().openUrl(url);
                    }
                }
            }
        }
        catch (Exception e) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"MessageContentPlugin_1", (String)BOSWFMESSAGE, (Object[])new Object[0]));
        }
        finally {
            args.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        this.initCommonFilter(args.getCommonFilterColumns());
        this.removeCobPassDate(args.getFilterContainerInitEvent());
        super.filterContainerInit(args);
    }

    private void initCommonFilter(List<FilterColumn> commonFilterColumns) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.size() > 0) {
            Object readState = customParams.get(READSTATE);
            Object eventSource = customParams.get("eventSource");
            for (FilterColumn filterColumn : commonFilterColumns) {
                List defaultValues;
                CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
                String fieldName = commonFilterColumn.getFieldName();
                if (READSTATE.equalsIgnoreCase(fieldName) && !WfUtils.isNullObject(readState)) {
                    commonFilterColumn.setDefaultValue((String)readState);
                }
                if (!CREATEDATE.equalsIgnoreCase(fieldName) || WfUtils.isNullObject(eventSource)) continue;
                String es = (String)eventSource;
                if ("card".equalsIgnoreCase(es) || "psMore".equalsIgnoreCase(es) || "api".equalsIgnoreCase(es)) {
                    commonFilterColumn.setDefaultValue("");
                    continue;
                }
                if (!"psOne".equalsIgnoreCase(es) || !(defaultValues = commonFilterColumn.getDefaultValues()).isEmpty()) continue;
                commonFilterColumn.setDefaultValue("63");
                commonFilterColumn.setDefValue("63");
            }
        }
    }

    private void removeCobPassDate(FilterContainerInitEvent event) {
        try {
            Set<String> ids = mapping.keySet();
            Field field = event.getClass().getDeclaredField("schemeFilterView");
            ReflectionUtils.makeAccessible((Field)field);
            SchemeFilterView schemeFilterView = (SchemeFilterView)field.get(event);
            List filterColumns = schemeFilterView.getFilterColumns();
            for (FilterColumn column : filterColumns) {
                if (!CREATEDATE.equals(column.getFieldName()) && !READSTATE.equals(column.getFieldName())) continue;
                SchemeFilterColumn schemeFilterColumn = (SchemeFilterColumn)column;
                Field field1 = schemeFilterColumn.getClass().getDeclaredField("compareTypes");
                ReflectionUtils.makeAccessible((Field)field1);
                List compareTypes = (List)field1.get(schemeFilterColumn);
                compareTypes.removeIf(temp -> !ids.contains(temp.getId()));
            }
        }
        catch (Exception e) {
            logger.info("MessageListPlugin_removeCobPassDate:\u79fb\u9664\u65e5\u671f\u5f02\u5e38");
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        String fieldKey = args.getListFieldKey();
        if (CREATEDATE.equalsIgnoreCase(fieldKey)) {
            List listColumnCompareTypes = args.getListColumnCompareTypes();
            listColumnCompareTypes.removeIf(item -> item.getId().equals("24") || item.getId().equals("92"));
        }
        super.listColumnCompareTypesSet(args);
    }

    public void packageData(PackageDataEvent e) {
        String contentUrl;
        Map param;
        DynamicObject rowData = e.getRowData();
        if (StringUtils.isBlank((CharSequence)rowData.getString(SENDERNAME))) {
            String uId = rowData.getString(SENDER);
            Long senderUserId = 0L;
            if (StringUtils.isNotBlank((CharSequence)uId)) {
                senderUserId = uId.contains("&&") ? Long.valueOf(uId.split("&&")[0]) : Long.valueOf(uId);
            }
            if (senderUserId == 0L) {
                ILocaleString messageSenderName = WfUtils.getPromptWordLocaleString((String)"\u7cfb\u7edf\u53d1\u9001", (String)"MessageListPlugin_1", (String)BOSWFMESSAGE);
                rowData.set(SENDERNAME, (Object)messageSenderName.getLocaleValue());
            } else {
                DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)senderUserId, (String)"bos_user");
                rowData.set(SENDERNAME, (Object)user.getLocaleString("name").getLocaleValue());
            }
        }
        String config = rowData.getString("config");
        String title = rowData.getString("title");
        if (WfUtils.isNotEmpty((String)title) && title.contains("<") && title.contains(">") && WfUtils.isNotEmpty((String)config) && !"{}".equals(config) && (param = (Map)SerializationUtils.fromJsonString((String)config, Map.class)).get("isTitleHtml") != null) {
            rowData.set("title", (Object)Jsoup.parse((String)title).text());
        }
        if (StringUtils.isNotEmpty((CharSequence)(contentUrl = rowData.getString("contenturl")))) {
            Long deadletterJobId;
            boolean deadLetterJobIsExist;
            Map paramMap = WfUtils.parseUrlParams((String)contentUrl);
            String formId = (String)paramMap.get("formId");
            if (formId != null && "wf_deadletterjob".equalsIgnoreCase(formId) && !(deadLetterJobIsExist = QueryServiceHelper.exists((String)"wf_deadletterjob", (Object)(deadletterJobId = Long.valueOf(Long.parseLong((String)paramMap.get("pkId"))))))) {
                e.getNoLinkKey().add("content_summary");
            }
        } else {
            String actMsgUrl = this.getActivityMsgUrl(rowData.getLong("type"), config);
            if (WfUtils.isEmpty((String)actMsgUrl)) {
                e.getNoLinkKey().add("content_summary");
            }
        }
    }

    private String getActivityMsgUrl(Long typeId, String config) {
        Map systemNotice;
        String result = "";
        if (1223746113903789056L != typeId || WfUtils.isEmpty((String)config) || "{}".equals(config)) {
            return result;
        }
        Map c = (Map)SerializationUtils.fromJsonString((String)config, Map.class);
        if (!c.isEmpty() && StringUtils.isNotBlank(c.get("systemNotice")) && StringUtils.isNotBlank((systemNotice = (Map)c.get("systemNotice")).get("url"))) {
            result = (String)systemNotice.get("url");
        }
        return result;
    }

    public void expandClick(ListExpandEvent e) {
        ArrayList<String> msgIds = new ArrayList<String>();
        msgIds.add(e.getPkId().toString());
        Long messageId = Long.valueOf(e.getPkId().toString());
        boolean isMessageExist = QueryServiceHelper.exists((String)"wf_msg_message", (Object)messageId);
        if (!isMessageExist) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"MessageContentPlugin_1", (String)BOSWFMESSAGE, (Object[])new Object[0]));
            return;
        }
        ArrayList<Long> msgIdList = new ArrayList<Long>(1);
        msgIdList.add(messageId);
        if (!WfPermUtils.checkUserIsReceiver(msgIdList, (Long)RequestContext.get().getCurrUserId())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u8be5\u6d88\u606f\u5904\u7406\u4eba\u3002", (String)"MessageListPlugin_7", (String)BOSWFMESSAGE, (Object[])new Object[0]));
            return;
        }
        ((MessageCenterService)ServiceFactory.getService(MessageCenterService.class)).setReadState(msgIds, READ, (Object)RequestContext.get().getUserId());
        this.refreshData();
    }

    public void setCellFieldValue(SetCellFieldValueArgs args) {
        super.setCellFieldValue(args);
        args.addCellFieldValueEvent(READSTATE, args.getRowIndex(), (Object)READ);
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
    }

    public void itemClick(ItemClickEvent evt) {
        ListSelectedRowCollection rows = ((ListView)this.getView()).getSelectedRows();
        switch (evt.getItemKey()) {
            case "btnrefresh": {
                ListView listView = (ListView)this.getView();
                listView.clearSelection();
                listView.refresh();
                this.refreshData();
                break;
            }
            case "btnread": {
                this.setMsgReadState(rows, READ);
                break;
            }
            case "btnunread": {
                this.setMsgReadState(rows, UNREAD);
                break;
            }
            case "btnallread": {
                this.setMsgReadStateByOneKeyWithTag();
                break;
            }
        }
    }

    private void setMsgReadStateByOneKeyWithTag() {
        String oneKeyReadAllTag = MsgServiceCacheHelper.getOneKeyReadAllTag();
        if (oneKeyReadAllTag == null) {
            try {
                MsgServiceCacheHelper.putOneKeyReadAllTag((String)"TAG");
                this.setMsgReadStateByOneKey();
            }
            catch (Exception e) {
                logger.error("MessageListPlugin.setMsgReadStateByOneKeyWithTag", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540e\u53f0\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MessageListPlugin_11", (String)BOSWFMESSAGE, (Object[])new Object[0]));
            }
            finally {
                MsgServiceCacheHelper.removeOneKeyReadAllTag();
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\u4e00\u952e\u5df2\u8bfb\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c\u3002", (String)"MessageListPlugin_10", (String)BOSWFMESSAGE, (Object[])new Object[0]));
        }
    }

    private void setMsgReadState(ListSelectedRowCollection rows, String readState) {
        ArrayList<Object> msgIds = new ArrayList<Object>();
        if (rows != null && !rows.isEmpty()) {
            for (ListSelectedRow row : rows) {
                msgIds.add(row.getPrimaryKeyValue());
            }
            LocalVariables.putLocalVariables((boolean)true, (String[])new String[]{"msg"});
            this.setMsgReadState(msgIds, readState);
        } else {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        }
    }

    private void setMsgReadState(List<Object> messageIds, String readState) {
        if (messageIds == null || messageIds.isEmpty() || WfUtils.isEmpty((String)readState)) {
            return;
        }
        ((MessageCenterService)ServiceFactory.getService(MessageCenterService.class)).setReadState(messageIds, readState, (Object)RequestContext.get().getUserId());
        ListView listView = (ListView)this.getView();
        listView.clearSelection();
        listView.refresh();
        this.refreshData();
    }

    private void setMsgReadStateByOneKey() {
        StringBuilder sql = new StringBuilder();
        ArrayList<Long> params = new ArrayList<Long>();
        params.add(Long.parseLong(RequestContext.get().getUserId()));
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long msgType = (Long)formShowParameter.getCustomParam("msgType");
        if (WfUtils.isNotEmpty((Long)msgType)) {
            if (WfConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue()) {
                sql.append("select a.fmessageid messageid from t_wf_msgreceiver a ");
                sql.append("where a.freceiverid = ? and a.freadstate = 'unread' and a.ftype = ?;");
            } else {
                sql.append("select a.fmessageid messageid from t_wf_msgreceiver a ");
                sql.append("inner join t_wf_message b on a.fmessageid = b.fid ");
                sql.append("where a.freceiverid = ? and a.freadstate = 'unread' and b.ftype = ?;");
            }
            params.add(msgType);
        } else {
            sql.append("select a.fmessageid messageid from t_wf_msgreceiver a ");
            sql.append("where a.freceiverid = ? and a.freadstate = 'unread';");
        }
        ArrayList<Object> messageIds = new ArrayList<Object>();
        try (DataSet dataSet = DB.queryDataSet((String)"messageListPlugin.queryMessage", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params.toArray());){
            if (dataSet != null) {
                Iterator iterator = dataSet.iterator();
                while (iterator.hasNext()) {
                    messageIds.add(((Row)iterator.next()).getLong("messageid"));
                }
            }
        }
        catch (Exception e) {
            logger.info(String.format("query unread message is error[%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        String caption = formShowParameter.getCaption();
        if (messageIds.isEmpty()) {
            String notification = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6ca1\u6709\u672a\u8bfb\u6d88\u606f\u3002", (String)"MessageListPlugin_6", (String)BOSWFMESSAGE, (Object[])new Object[0]), caption);
            this.getView().showTipNotification(notification, Integer.valueOf(3000));
            return;
        }
        this.setMsgReadState(messageIds, READ);
        String notificationSuccess = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e00\u952e\u5df2\u8bfb\u6210\u529f\u3002", (String)"MessageListPlugin_5", (String)BOSWFMESSAGE, (Object[])new Object[0]), caption);
        this.getView().showSuccessNotification(notificationSuccess, Integer.valueOf(3000));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if (key.equals("deletemessage")) {
            ListSelectedRowCollection rows = ((ListView)this.getView()).getSelectedRows();
            ArrayList<Long> msgIds = new ArrayList<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                msgIds.add((Long)row.getPrimaryKeyValue());
            }
            if (!WfPermUtils.checkUserIsReceiver(msgIds, (Long)RequestContext.get().getCurrUserId())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u4e0d\u662f\u6240\u9009\u6d88\u606f\u5904\u7406\u4eba\u3002", (String)"MessageListPlugin_8", (String)BOSWFMESSAGE, (Object[])new Object[0]));
                afterDoOperationEventArgs.getOperationResult().setShowMessage(Boolean.FALSE.booleanValue());
                return;
            }
            LocalVariables.putLocalVariables((boolean)true, (String[])new String[]{"msg"});
            MessageCenterService messageService = (MessageCenterService)ServiceFactory.getService(MessageCenterService.class);
            messageService.deleteMessage(msgIds, Long.valueOf(RequestContext.get().getUserId()));
            afterDoOperationEventArgs.getOperationResult().setShowMessage(Boolean.FALSE.booleanValue());
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"MessageListPlugin_9", (String)BOSWFMESSAGE, (Object[])new Object[0]));
            ListView listView = (ListView)this.getView();
            listView.clearSelection();
            listView.refresh();
            this.refreshData();
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        String userId = RequestContext.get().getUserId();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long msgType = (Long)formShowParameter.getCustomParam("msgType");
        String readstate = (String)formShowParameter.getCustomParam(READSTATE);
        logger.debug(String.format("beforeCreateListDataProvider-defaultFilter[%s][%s]", readstate, msgType));
        args.setListDataProvider((IListDataProvider)new MessageListDataProvider(userId, msgType, readstate));
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
    }

    public void refreshData() {
        IFormView parentView = this.getView().getParentView();
        if (null != parentView) {
            ClientViewProxy clientViewProxy = (ClientViewProxy)parentView.getService(IClientViewProxy.class);
            if (clientViewProxy != null) {
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("key", "wfnavigationbarap");
                clientViewProxy.addAction("refreshWfNavigation", param);
                this.getView().sendFormAction(parentView);
            }
        } else {
            ((IListView)this.getView()).refresh();
        }
    }

    public void clearSelectData() {
        if (this.getView() instanceof IListView) {
            IListView view = (IListView)this.getView();
            view.clearSelection();
        }
    }

    public String getOrderByStr(String orderBy) {
        String[] os;
        if (WfUtils.isEmpty((String)orderBy)) {
            return orderBy;
        }
        HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>();
        formFieldMapSQLFiled.put("id", "a.fid");
        formFieldMapSQLFiled.put(CREATEDATE, "a.fcreatedate");
        formFieldMapSQLFiled.put(SENDER, "a.fsender");
        formFieldMapSQLFiled.put(SENDERNAME, "b.fsendername");
        formFieldMapSQLFiled.put("title", "b.ftitle");
        formFieldMapSQLFiled.put("content_summary", "b.fcontent_summary");
        formFieldMapSQLFiled.put("tag", "b.ftag");
        formFieldMapSQLFiled.put(READSTATE, "c.freadstate");
        logger.debug("getOrderByStrLogger:  orderBy:[" + orderBy + "]");
        if (orderBy.indexOf("id ") >= 0) {
            String[] obs;
            for (String o : obs = orderBy.split(",")) {
                if (o == null || o.indexOf("id ") >= 0) continue;
                orderBy = o;
                break;
            }
        }
        if ((os = orderBy.split(" ")).length == 2) {
            return (String)formFieldMapSQLFiled.get(os[0]) + " " + os[1];
        }
        return "";
    }

    public Map<String, Map<String, List<Object>>> buildFilter(List<QFilter> filters) {
        HashMap<String, Map<String, List<Object>>> sqlFilters = new HashMap<String, Map<String, List<Object>>>();
        if (!filters.isEmpty()) {
            HashMap<String, String> formFieldMapSQLFiled = new HashMap<String, String>();
            formFieldMapSQLFiled.put("id", "a.fid");
            formFieldMapSQLFiled.put(CREATEDATE, "c.fcreatedate");
            formFieldMapSQLFiled.put(SENDER, "a.fsender");
            formFieldMapSQLFiled.put(SENDERNAME, "b.fsendername");
            formFieldMapSQLFiled.put("title", "b.ftitle");
            formFieldMapSQLFiled.put("tag", "b.ftag");
            formFieldMapSQLFiled.put("content_summary", "b.fcontent_summary");
            formFieldMapSQLFiled.put(READSTATE, "c.freadstate");
            formFieldMapSQLFiled.put("operation", "a.foperation");
            formFieldMapSQLFiled.put("type", "a.ftype");
            sqlFilters.put("sqlFilters", this.getFilterSql(filters, formFieldMapSQLFiled));
        }
        return sqlFilters;
    }

    public List<QFilter> wrapParallelQFilter(List<QFilter> filters) {
        ArrayList<QFilter> splitFilter = new ArrayList<QFilter>();
        for (QFilter f : filters) {
            this.wrapNestQFilter(splitFilter, f);
        }
        return splitFilter;
    }

    public void wrapNestQFilter(List<QFilter> hasSplitFilter, QFilter filter) {
        boolean hasOtherNests = false;
        if (filter.getNests(false) != null && !filter.getNests(false).isEmpty()) {
            QFilter qf = new QFilter(filter.getProperty(), filter.getCP(), filter.getValue());
            List nests = filter.getNests(false);
            for (int i = 0; i < nests.size(); ++i) {
                QFilter nestFilter = ((QFilter.QFilterNest)nests.get(i)).getFilter();
                if (filter.getProperty().equals(nestFilter.getProperty())) {
                    if (((QFilter.QFilterNest)nests.get(i)).isAnd()) {
                        qf.and(nestFilter);
                        continue;
                    }
                    qf.or(nestFilter);
                    continue;
                }
                hasOtherNests = true;
                hasSplitFilter.add(qf);
                this.wrapNestQFilter(hasSplitFilter, nestFilter);
            }
        }
        if (!hasOtherNests) {
            hasSplitFilter.add(filter);
        }
    }

    protected Map<String, List<Object>> getFilterSql(List<QFilter> filters, Map<String, String> formFieldMapSQLFiled) {
        HashMap<String, List<Object>> filterSql = new HashMap<String, List<Object>>();
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> params = new ArrayList<Object>();
        for (QFilter f : filters) {
            ArrayList<String> replacedProperty = new ArrayList<String>();
            ArrayList<Object> values = new ArrayList<Object>();
            if (f != null && f.getCP().equals("ftlike") && WfUtils.isNotEmptyString((Object)f.getValue())) {
                String value = f.getValue().toString();
                if (value.contains("#")) {
                    String like = value.split("#")[1];
                    String fields = value.split("#")[0];
                    String[] fieldArr = fields.split(",");
                    if (fieldArr.length != 1) {
                        ArrayList<String> afterFilterFields = new ArrayList<String>();
                        for (int i = 0; i < fieldArr.length; ++i) {
                            String field = formFieldMapSQLFiled.get(fieldArr[i]);
                            if (!WfUtils.isNotEmpty((String)field)) continue;
                            afterFilterFields.add(field);
                        }
                        for (int k = 0; k < afterFilterFields.size(); ++k) {
                            String afterFilterField = (String)afterFilterFields.get(k);
                            if (sb.length() > 0 && sb.toString().endsWith("OR ")) {
                                if (k == afterFilterFields.size() - 1) {
                                    sb.append("( ").append(afterFilterField).append(" ").append(LIKE).append(" ? ").append(")").append(")");
                                } else {
                                    sb.append("( ").append(afterFilterField).append(" ").append(LIKE).append(" ? ").append(") OR ");
                                }
                            } else {
                                sb.append(" ").append(AND).append(" (( ").append(afterFilterField).append(" ").append(LIKE).append(" ? ").append(") OR ");
                            }
                            if (like.endsWith("%")) {
                                params.add(like);
                                continue;
                            }
                            params.add("%" + like + "%");
                        }
                        continue;
                    }
                    if (!WfUtils.isNotEmpty((String)formFieldMapSQLFiled.get(fieldArr[0]))) continue;
                    sb.append(" ").append(AND).append(" ( ").append(formFieldMapSQLFiled.get(fieldArr[0])).append(" ").append(LIKE).append(" ? ").append(") ");
                    if (like.endsWith("%")) {
                        params.add(like);
                        continue;
                    }
                    params.add("%" + like + "%");
                    continue;
                }
                sb.append(" ").append(AND).append(" ( ").append(formFieldMapSQLFiled.get(f.getProperty())).append(" ").append(LIKE).append(" ? ").append(") ");
                params.add(value);
                continue;
            }
            if (f == null || f.toString() == null || f.getProperty() == null || formFieldMapSQLFiled.get(f.getProperty()) == null) continue;
            HashMap<String, String> nestQfilterMap = new HashMap<String, String>();
            List nests = f.getNests(false);
            boolean hasNestQFilter = nests != null && !nests.isEmpty();
            sb.append(" ").append(AND);
            if (hasNestQFilter) {
                sb.append(" ( ");
            }
            this.wrapFilter(f, formFieldMapSQLFiled, values, sb, params, replacedProperty, nestQfilterMap);
            if (!hasNestQFilter) continue;
            sb.append(" ) ");
        }
        filterSql.put(sb.toString(), params);
        return filterSql;
    }

    private void wrapFilter(QFilter f, Map<String, String> formFieldMapSQLFiled, List<Object> values, StringBuilder sb, List<Object> params, List<String> replacedProperty, Map<String, String> nestQfilterMap) {
        if (f.getValue() instanceof QEmptyValue) {
            sb.append(" ( ").append(formFieldMapSQLFiled.get(f.getProperty())).append(" ").append("is null");
            sb.append(" ").append(OR).append(" ");
            sb.append(formFieldMapSQLFiled.get(f.getProperty())).append(" ").append("=").append(" ").append("''");
            sb.append(" ").append(OR).append(" ");
            sb.append(formFieldMapSQLFiled.get(f.getProperty())).append(" ").append("=").append(" ").append("' '");
            sb.append(" ) ");
        } else if (f.getValue() instanceof Date) {
            sb.append(" (( ").append(formFieldMapSQLFiled.get(f.getProperty())).append(" ").append(f.getCP()).append(" ? ").append(")");
            params.add(f.getValue());
            sb.append(") ");
        } else if (f.getCP().contains("is null") || f.getCP().contains("is not null")) {
            f.__setValue(null);
            sb.append(" ").append(formFieldMapSQLFiled.get(f.getProperty())).append(" ").append(f.getCP()).append(" ");
        } else if (f.getCP().equals("<>") || f.getCP().equals("not like")) {
            sb.append(" (").append(formFieldMapSQLFiled.get(f.getProperty())).append(" ").append(f.getCP()).append(" ? ");
            sb.append(OR);
            sb.append(" ").append(formFieldMapSQLFiled.get(f.getProperty())).append(" ").append("is null").append(") ");
            params.add(f.getValue());
        } else if (f.getCP().equals("in") || f.getCP().equals("IN") || f.getCP().equalsIgnoreCase("not in")) {
            if (!READSTATE.equals(f.getProperty())) {
                values.clear();
                String sqlFiter = f.toString();
                sqlFiter = sqlFiter.replaceAll("'", "");
                sqlFiter = this.wrapFilterValue(sqlFiter, f.getValue(), f, formFieldMapSQLFiled, values, replacedProperty);
                sb.append(" ( ").append(formFieldMapSQLFiled.get(f.getProperty())).append(" ").append(f.getCP()).append(" ( ");
                for (Object o : values) {
                    sb.append("?").append(',');
                    params.add(o);
                }
                sb.replace(sb.length() - 1, sb.length(), "").append(" ) ");
                if (f.getCP().equalsIgnoreCase("not in")) {
                    sb.append(OR).append(" ").append(formFieldMapSQLFiled.get(f.getProperty())).append(" ").append("is null");
                }
                sb.append(") ");
            } else {
                sb.append(" ( ").append("1=1").append(" ) ");
            }
        } else {
            Object value = f.getValue();
            if (StringUtils.isBlank((Object)value)) {
                sb.append(" ").append(formFieldMapSQLFiled.get(f.getProperty())).append(" ").append(f.getCP()).append(" ? ").append(" ");
                params.add(value);
            } else {
                values.clear();
                String sqlFiter = f.toString();
                if (sqlFiter.contains("'")) {
                    sqlFiter = sqlFiter.replaceFirst("'", "");
                    sqlFiter = sqlFiter.substring(0, sqlFiter.length() - 1);
                }
                sqlFiter = this.wrapFilterValue(sqlFiter, value, f, formFieldMapSQLFiled, values, replacedProperty);
                String sqlFilterPrefix = sqlFiter.substring(sqlFiter.indexOf(formFieldMapSQLFiled.get(f.getProperty())), sqlFiter.indexOf(f.getCP()));
                String sqlFilterSuffix = sqlFiter.substring(sqlFiter.indexOf(f.getCP()), sqlFiter.indexOf(f.getValue().toString(), sqlFiter.indexOf(f.getCP())) + f.getValue().toString().length());
                for (Object o : values) {
                    sqlFilterSuffix = sqlFilterSuffix.replace(String.valueOf(o), " ? ");
                    params.add(o);
                }
                sb.append(" ( ").append(sqlFilterPrefix).append(sqlFilterSuffix).append(" ) ");
            }
        }
        if (f.getNests(false) != null && !f.getNests(false).isEmpty()) {
            for (int i = 0; i < f.getNests(false).size(); ++i) {
                QFilter.QFilterNest qFilterNest = (QFilter.QFilterNest)f.getNests(false).get(i);
                QFilter nestFilter = qFilterNest.getFilter();
                if (nestQfilterMap.containsKey(nestFilter.toString()) || "<>".equals(f.getCP()) && "is null".equals(nestFilter.getCP()) || "not like".equals(f.getCP()) && "is null".equals(nestFilter.getCP()) || "not in".equalsIgnoreCase(f.getCP()) && "is null".equals(nestFilter.getCP())) continue;
                nestQfilterMap.put(nestFilter.toString(), nestFilter.toString());
                String nestconnector = qFilterNest.isAnd() ? AND : OR;
                sb.append(" ").append(nestconnector);
                this.wrapFilter(nestFilter, formFieldMapSQLFiled, values, sb, params, replacedProperty, nestQfilterMap);
            }
        }
    }

    private String wrapFilterValue(String sqlFiter, Object value, QFilter f, Map<String, String> formFieldMapSQLFiled, List<?> values, List<String> replacedProperty) {
        String fProperty = f.getProperty();
        if (!replacedProperty.contains(fProperty)) {
            sqlFiter = sqlFiter.replaceFirst(fProperty, formFieldMapSQLFiled.get(fProperty));
            replacedProperty.add(fProperty);
        }
        if (value instanceof List) {
            values.addAll((List)f.getValue());
        } else if (value instanceof Object[]) {
            values.addAll(Arrays.asList((Object[])f.getValue()));
        } else if (value != null) {
            ArrayList<String> fValue = new ArrayList<String>();
            String v = "";
            v = value instanceof String ? (String)value : String.valueOf(value);
            fValue.add(v);
            values.addAll(fValue);
        }
        return sqlFiter;
    }

    public static boolean check(List<QFilter> qfilters, String ... property) {
        boolean checkResult = true;
        if (qfilters == null || qfilters.isEmpty()) {
            return true;
        }
        if (StringUtils.isNotBlank((Object)property)) {
            for (QFilter filter : qfilters) {
                List<String> propertyList = Arrays.asList(property);
                if (propertyList.isEmpty() || !propertyList.contains(filter.getProperty())) continue;
                String filterStr = filter.toString();
                List qfilterNests = filter.getNests(true);
                if (qfilterNests == null || qfilterNests.isEmpty()) continue;
                String startTime = null;
                String endTime = null;
                filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
                startTime = filterStr.substring(0, filterStr.indexOf(39));
                filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
                filterStr = filterStr.substring(filterStr.indexOf(39) + 1);
                endTime = filterStr.substring(0, filterStr.indexOf(39));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date endDate = simpleDateFormat.parse(endTime);
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(endDate);
                    cal.add(2, -3);
                    cal.add(7, -3);
                    endDate = cal.getTime();
                    Date startDate = simpleDateFormat.parse(startTime);
                    if (endDate.compareTo(startDate) > 0) {
                        return false;
                    }
                    checkResult = true;
                }
                catch (ParseException px) {
                    logger.error((Throwable)px);
                    return checkResult;
                }
            }
        }
        return checkResult;
    }

    static {
        mapping.put("1", "range");
        mapping.put("13", "today");
        mapping.put("10", "thisWeek");
        mapping.put("63", "thisMonth");
        mapping.put("66", "thisYear");
        mapping.put("67", "dateEquals");
        mapping.put("105", "stringEquals");
        mapping.put("106", "stringNotEquals");
    }

    class MessageListDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;
        private String userId;
        private Long msgType;
        private String readstate;

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public MessageListDataProvider(String userId, Long msgType, String readstate) {
            this.userId = userId;
            this.msgType = msgType;
            this.readstate = readstate;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            logger.info("MessageListPlugin_getData_getFilters" + this.getQFilters().toString());
            List filters = this.getQFilters();
            this.analyzeQFilter(filters);
            DynamicObjectCollection data = null;
            MessageCenterService messageService = (MessageCenterService)ServiceFactory.getService(MessageCenterService.class);
            logger.info("MessageListPlugin_getData_filter" + filters.toString());
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue()) {
                HashMap<String, String> filterMap = new HashMap<String, String>();
                if (!MessageListPlugin.NOREADSTATE.equals(this.readstate)) {
                    filterMap.put(MessageListPlugin.READSTATE, this.readstate);
                }
                filterMap.put("typeId", String.valueOf(this.msgType));
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(this.userId), start, limit, "", this.getOrderByExpr()).setSqlFilterMap(filterMap).setqFilters(filters);
                data = messageService.getMessageDataList(processDataEntityQueryParams);
            } else {
                String orderBy = MessageListPlugin.this.getOrderByStr(this.getOrderByExpr());
                Map<String, Map<String, List<Object>>> fiterSqlMap = MessageListPlugin.this.buildFilter(filters);
                String rs = !MessageListPlugin.NOREADSTATE.equals(this.readstate) ? this.readstate : "";
                data = messageService.getMessageDataByType(start, limit, this.userId, this.msgType, rs, fiterSqlMap, orderBy);
            }
            this.queryResult = new QueryResult();
            this.queryResult.setCollection(data);
            return data;
        }

        public int getRealCount() {
            List countFilters = this.getQFilters();
            this.analyzeQFilter(countFilters);
            MessageCenterService messageService = (MessageCenterService)ServiceFactory.getService(MessageCenterService.class);
            logger.info("MessageListPlugin_getCount_filter" + countFilters.toString());
            if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue()) {
                HashMap<String, String> filterMap = new HashMap<String, String>();
                if (!MessageListPlugin.NOREADSTATE.equals(this.readstate)) {
                    filterMap.put(MessageListPlugin.READSTATE, this.readstate);
                }
                filterMap.put("typeId", String.valueOf(this.msgType));
                ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams("", Long.valueOf(this.userId)).setSqlFilterMap(filterMap).setqFilters(countFilters);
                return messageService.getMessageDataCount(processDataEntityQueryParams).intValue();
            }
            Map<String, Map<String, List<Object>>> fiterSqlMap = MessageListPlugin.this.buildFilter(countFilters);
            String rs = !MessageListPlugin.NOREADSTATE.equals(this.readstate) ? this.readstate : "";
            return (int)messageService.getMessageDataCountByType(this.userId, this.msgType, rs, fiterSqlMap);
        }

        private void analyzeQFilter(List<QFilter> filters) {
            ArrayList<QFilter> readstateQFilters = new ArrayList<QFilter>();
            for (QFilter f : filters) {
                if (!MessageListPlugin.READSTATE.equals(f.getProperty())) continue;
                readstateQFilters.add(f);
            }
            if (!readstateQFilters.isEmpty()) {
                ArrayList<String> values = new ArrayList<String>(readstateQFilters.size());
                for (QFilter qFilter : readstateQFilters) {
                    String rs = "";
                    if (qFilter.getCP().equals("=")) {
                        rs = (String)qFilter.getValue();
                        values.add(rs);
                        continue;
                    }
                    if (qFilter.getCP().equals("!=") || qFilter.getCP().equals("<>")) {
                        rs = ((String)qFilter.getValue()).equals(MessageListPlugin.UNREAD) ? MessageListPlugin.READ : MessageListPlugin.UNREAD;
                        values.add(rs);
                        continue;
                    }
                    if (!qFilter.getCP().equals("in")) continue;
                    List qfValues = (List)qFilter.getValue();
                    for (String qfValue : qfValues) {
                        values.add(qfValue);
                    }
                }
                String tempValue = "";
                for (String v : values) {
                    if (WfUtils.isNotEmpty((String)tempValue)) {
                        if (tempValue.equalsIgnoreCase(v)) continue;
                        tempValue = MessageListPlugin.NOREADSTATE;
                        continue;
                    }
                    tempValue = v;
                }
                this.readstate = tempValue;
            } else {
                this.readstate = null;
            }
        }

        private void convertOriginalQFilters(List<QFilter> filters) {
            List qfs = this.getQFilters();
            if (qfs.size() == 1 && ((QFilter)qfs.get(0)).getProperty().equals("id")) {
                QFilter filter = (QFilter)qfs.get(0);
                filters.add(new QFilter(filter.getProperty(), filter.getCP(), filter.getValue()));
            } else {
                for (QFilter qFilter : qfs) {
                    List nests = qFilter.getNests(true);
                    if (nests != null && !nests.isEmpty()) {
                        String property = qFilter.getProperty();
                        QFilter newFilter = new QFilter(property, qFilter.getCP(), qFilter.getValue());
                        for (QFilter.QFilterNest qFilterNest : nests) {
                            QFilter nestFilter = qFilterNest.getFilter();
                            if (!nestFilter.getProperty().equals(property) && qFilterNest.isAnd()) {
                                filters.add(nestFilter);
                                continue;
                            }
                            if (qFilterNest.isAnd()) {
                                newFilter.and(nestFilter);
                                continue;
                            }
                            newFilter.or(nestFilter);
                        }
                        filters.add(newFilter);
                        continue;
                    }
                    filters.add(qFilter);
                }
            }
        }
    }
}

