/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bec.log;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bec.util.PluginUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.operate.Donothing;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class EventLogListPlugin
extends AbstractListPlugin
implements ClickListener,
IConfirmCallBack {
    public static final String BTNBILL = "btnbill";
    public static final String TABKEY = "_submaintab_";
    private static Log logger = LogFactory.getLog(EventLogListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        ListShowParameter showParameter = (ListShowParameter)e.getSource();
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e8b\u4ef6\u65e5\u5fd7", (String)"EventLogListPlugin_0", (String)"bos-bec-formplugin", (Object[])new Object[0]));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        Map map = (Map)showParameter.getCustomParam("data");
        if (map != null && !map.isEmpty()) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                if (EntityMetadataCache.getDataEntityType((String)"evt_job").getProperty((String)entry.getKey()) == null) continue;
                QFilter qfilter = new QFilter((String)entry.getKey(), "=", entry.getValue());
                qFilters.add(qfilter);
            }
            listFilterParameter.setQFilters(qFilters);
            showParameter.setListFilterParameter(listFilterParameter);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String lang = RequestContext.get().getLang().toString();
        if (!"zh_CN".equalsIgnoreCase(lang) && !WfConfigurationUtil.isEnableShowMutiLangLog()) {
            List list = args.getListColumns();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                String colName = ((IListColumn)it.next()).getListFieldKey();
                if (!"exceptionmessage".equals(colName)) continue;
                it.remove();
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qfilters = e.getQFilters();
        if (!PluginUtil.check((List)qfilters, (String)"createdate")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u64cd\u4f5c\u65f6\u95f4\u201d\u67e5\u8be2\u8303\u56f4\u4e0d\u80fd\u8d85\u8fc7\u4e09\u4e2a\u6708\u3002", (String)"EventLogListPlugin_1", (String)"bos-bec-formplugin", (Object[])new Object[0]));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FilterContainerInitEvent filterContainerInitEvent = args.getFilterContainerInitEvent();
        PluginUtil.removeCobPassDate((FilterContainerInitEvent)filterContainerInitEvent);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"businesskey", BTNBILL});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String entityNumber = this.getPageCache().get("entityNumber");
        if (PluginUtil.isEmpty((String)entityNumber)) {
            entityNumber = "evt_hijob";
        }
        args.setCancel(true);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setShowTitle(false);
        parameter.setCaption(ResManager.loadKDString((String)"\u4e8b\u4ef6\u65e5\u5fd7", (String)"EventLogListPlugin_0", (String)"bos-bec-formplugin", (Object[])new Object[0]));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey(TABKEY);
        parameter.setFormId(entityNumber);
        parameter.setPkId((Object)((Long)((ListView)this.getView()).getFocusRowPkId()));
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setCustomParam("FID", (Object)((Long)((ListView)this.getView()).getFocusRowPkId()));
        IFormView parentView = PluginUtil.getTabControlView((IFormView)this.getView());
        if (parentView != null) {
            parentView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(parentView);
        } else {
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        ListSelectedRowCollection rows;
        String key = evt.getItemKey();
        if (BTNBILL.equals(key) && (rows = this.getSelectedRow()) != null) {
            Long jobrecordid = (Long)rows.get(0).getPrimaryKeyValue();
            PluginUtil.existBill((AbstractListPlugin)this, (ListSelectedRowCollection)rows, (Long)jobrecordid);
        }
    }

    public ListSelectedRowCollection getSelectedRow() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            rows = null;
        } else if (1 < rows.size()) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(rows.size());
            rows = null;
        }
        return rows;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            try {
                String entityNumber = this.getPageCache().get("entityNumber");
                String operationKey = "delete";
                Object[] ids = PluginUtil.collectionToList((ListSelectedRowCollection)args.getListSelectedData()).toArray(new Object[0]);
                int idsLength = ids.length;
                if (ids != null && idsLength > 0) {
                    List<Long> deleteAnotherIds;
                    List<Long> deleteIds = this.queryJobIds(entityNumber, ids);
                    if (deleteIds.size() > 0) {
                        OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])deleteIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
                    }
                    if (deleteIds.size() < idsLength && (deleteAnotherIds = this.queryJobIds(entityNumber = "evt_hijob".equalsIgnoreCase(entityNumber) ? "evt_job" : "evt_hijob", ids)).size() > 0) {
                        OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])deleteAnotherIds.toArray(new Long[0]), (OperateOption)OperateOption.create());
                    }
                }
                args.setCancel(Boolean.TRUE.booleanValue());
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"EventLogListPlugin_4", (String)"bos-bec-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                IListView view = (IListView)this.getView();
                view.clearSelection();
                view.refresh();
            }
            catch (Exception e) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"EventLogListPlugin_5", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
    }

    private List<Long> queryJobIds(String entityNumber, Object[] ids) {
        ArrayList<Long> deleteIds = new ArrayList<Long>();
        QFilter filter = new QFilter("id", "in", (Object)ids);
        String properties = "id";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"EventLogListPlugin", (String)entityNumber, (String)properties, (QFilter[])new QFilter[]{filter}, null);){
            while (ds != null && ds.hasNext()) {
                deleteIds.add(ds.next().getLong("id"));
            }
        }
        return deleteIds;
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new LogDataProvider());
    }

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        args.setEnableCustomSum(false);
        super.setEnableCustomSum(args);
    }

    class LogDataProvider
    extends ListDataProvider {
        private QueryResult queryResult = null;

        LogDataProvider() {
        }

        public QueryResult getQueryResult() {
            return this.queryResult;
        }

        public void setQueryResult(QueryResult queryResult) {
            this.queryResult = queryResult;
        }

        public DynamicObjectCollection getData(int start, int limit) {
            String entityNumber;
            String orderBy = this.getOrderByExpr();
            if (PluginUtil.isEmpty((String)orderBy)) {
                orderBy = "createdate desc";
            } else if (!orderBy.contains("createdate")) {
                orderBy = orderBy + ",createdate desc";
            }
            String properties = "id, lockownerid, exclusive, executionid, processinstanceid, retries, duedate, repeat, jobhandlertype, businesskey, operation, entitynumber, elementid,createdate, modifydate, srcjobid, executor, success, endtime, duration, state, source, rootjobid, bizkey, srctraceid, rooteventinstid,exceptionmessage, roottraceno";
            this.queryResult = new QueryResult();
            QFilter[] qFilters = this.getFilters(this.getQFilters());
            if (qFilters == null) {
                EventLogListPlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4e8b\u4ef6\u8fd0\u884c\u72b6\u6001\u201d\u3002", (String)"EventLogListPlugin_6", (String)"bos-bec-formplugin", (Object[])new Object[0]));
                qFilters = new QFilter[]{new QFilter("1", "=", (Object)0)};
            }
            if (PluginUtil.isEmpty((String)(entityNumber = EventLogListPlugin.this.getPageCache().get("entityNumber")))) {
                entityNumber = "evt_hijob";
            }
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"GetEvtJobDataCmd", (String)entityNumber, (String)properties, (QFilter[])qFilters, (String)orderBy, (int)(start + limit));){
                DynamicObjectCollection taskDataResultCollection = ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
                if (taskDataResultCollection != null && taskDataResultCollection.size() > 0) {
                    for (DynamicObject dyn : taskDataResultCollection) {
                        dyn.set("executor", (Object)PluginUtil.desensitizeIP((String)dyn.getString("executor")));
                    }
                }
                this.queryResult.setCollection(taskDataResultCollection);
                Iterator iterator = taskDataResultCollection;
                return iterator;
            }
        }

        public int getRealCount() {
            QFilter[] qFilters = this.getFilters(this.getQFilters());
            String entityNumber = EventLogListPlugin.this.getPageCache().get("entityNumber");
            if (PluginUtil.isEmpty((String)entityNumber)) {
                entityNumber = "evt_hijob";
            }
            if (qFilters == null) {
                return 0;
            }
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getBecLogRealCount", (String)entityNumber, (String)"count(1) count", (QFilter[])qFilters, null);){
                if (ds != null && ds.hasNext()) {
                    int n = ds.next().getInteger("count");
                    return n;
                }
            }
            return 0;
        }

        private QFilter[] getFilters(List<QFilter> filterList) {
            if (filterList == null || filterList.size() < 1) {
                return null;
            }
            QFilter[] filters = filterList.toArray(new QFilter[0]);
            for (int i = 0; i < filters.length; ++i) {
                List nests = filters[i].getNests(true);
                if (nests != null && !nests.isEmpty()) {
                    for (int j = 0; j < nests.size(); ++j) {
                        QFilter nestFilter = ((QFilter.QFilterNest)nests.get(j)).getFilter();
                        if (!"jobstate".equalsIgnoreCase(nestFilter.getProperty())) continue;
                        if ("=".equalsIgnoreCase(nestFilter.getCP()) && this.validateJobState(nestFilter.getValue())) {
                            EventLogListPlugin.this.getPageCache().put("entityNumber", (String)nestFilter.getValue());
                            nestFilter.__setProperty("1");
                            nestFilter.__setValue((Object)1);
                            continue;
                        }
                        return null;
                    }
                }
                if (!"jobstate".equalsIgnoreCase(filters[i].getProperty())) continue;
                if ("=".equalsIgnoreCase(filters[i].getCP()) && this.validateJobState(filters[i].getValue())) {
                    EventLogListPlugin.this.getPageCache().put("entityNumber", (String)filters[i].getValue());
                    filters[i].__setProperty("1");
                    filters[i].__setValue((Object)1);
                    continue;
                }
                return null;
            }
            return filters;
        }

        private boolean validateJobState(Object value) {
            if (value == null) {
                return false;
            }
            if (!(value instanceof String)) {
                return false;
            }
            return "evt_hijob".equalsIgnoreCase((String)value) || "evt_job".equalsIgnoreCase((String)value);
        }
    }
}

