/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bpm.monitor.plugin.billrelation;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.workflow.api.model.BillCard;
import kd.bos.workflow.bizflow.graph.model.BillRelation;
import kd.bos.workflow.bizflow.graph.model.BillRelationGraphData;
import kd.bos.workflow.bizflow.graph.model.StackedBillRelation;
import kd.bos.workflow.bizflow.graph.util.BizFlowGraphUtil;
import kd.bos.workflow.bpm.monitor.plugin.billrelation.AbstractBillRelationGraphInitPlugin;
import kd.bos.workflow.engine.WfUtils;

public class CustomBillRelationGraphInitPlugin
extends AbstractBillRelationGraphInitPlugin {
    private int stackSize = BizFlowGraphUtil.getBillRelationGraphStackSize();

    public BillRelationGraphData getInitGraphData(IFormView view, Map<String, Object> params) {
        String datas = view.getPageCache().get("billCards");
        if (WfUtils.isNotEmpty((String)datas)) {
            List billCards;
            String appId = null;
            IFormView parentView = view.getParentView();
            if (parentView != null) {
                appId = parentView.getFormShowParameter().getAppId();
            }
            if (this.hasCycle(billCards = JSON.parseArray((String)datas, BillCard.class))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5173\u7cfb\u56fe\u6570\u636e\u4e2d\u5b58\u5728\u73af\u8def\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u662f\u5426\u6b63\u786e\u3002", (String)"CustomBillRelationGraphInitPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            List<BillRelation> billRelations = this.getBillRelations(billCards);
            String businessKey = (String)params.get("billId");
            String entityNumber = (String)params.get("entityNumber");
            return BizFlowGraphUtil.createCustomBillRelationModel(billRelations, (String)entityNumber, (String)businessKey, (String)appId);
        }
        return null;
    }

    private boolean hasCycle(List<BillCard> cards) {
        HashMap<String, Boolean> visitStatus = new HashMap<String, Boolean>(cards.size());
        for (BillCard card : cards) {
            String uniqueKey = BizFlowGraphUtil.getUniqueKey((String)card.getEntityNumber(), (String)card.getBusinessKey());
            Boolean status = (Boolean)visitStatus.get(uniqueKey);
            if (status != null || !this.depthFirstSearch(card, visitStatus)) continue;
            return true;
        }
        return false;
    }

    private boolean depthFirstSearch(BillCard card, Map<String, Boolean> visitStatus) {
        String uniqueKey = BizFlowGraphUtil.getUniqueKey((String)card.getEntityNumber(), (String)card.getBusinessKey());
        visitStatus.put(uniqueKey, Boolean.TRUE);
        List targets = card.getTargets();
        if (targets != null && !targets.isEmpty()) {
            for (BillCard target : targets) {
                String key = BizFlowGraphUtil.getUniqueKey((String)target.getEntityNumber(), (String)target.getBusinessKey());
                Boolean status = visitStatus.get(key);
                if (!(status == null ? this.depthFirstSearch(target, visitStatus) : Boolean.TRUE.equals(status))) continue;
                return true;
            }
        }
        visitStatus.put(uniqueKey, Boolean.FALSE);
        return false;
    }

    private List<BillRelation> getBillRelations(List<BillCard> billCards) {
        ArrayList<BillRelation> billRelations = new ArrayList<BillRelation>(billCards.size());
        HashMap<String, BillRelation> relationMap = new HashMap<String, BillRelation>(billCards.size());
        for (BillCard billCard : billCards) {
            String uniqueKey = this.getUniqueKey(billCard);
            BillRelation relation = (BillRelation)relationMap.get(uniqueKey);
            if (relation != null) {
                this.log.debug(String.format("%s %s is repeated.", billCard.getEntityNumber(), billCard.getBusinessKey()));
                continue;
            }
            relation = this.getBillRelation(billCard, relationMap);
            relationMap.put(uniqueKey, relation);
            billRelations.add(relation);
        }
        return billRelations;
    }

    private BillRelation getBillRelation(BillCard billCard, Map<String, BillRelation> relationMap) {
        BillRelation relation = new BillRelation();
        relation.setBillNo(billCard.getBillNo());
        relation.setEntityName(billCard.getEntityName());
        relation.setEntityNumber(billCard.getEntityNumber());
        relation.setBusinessKey(billCard.getBusinessKey());
        relation.setUniqueKey(billCard.getEntityNumber(), billCard.getBusinessKey());
        relation.setStatus("complete");
        List cards = billCard.getTargets();
        if (cards == null || cards.isEmpty()) {
            return relation;
        }
        HashMap<String, ArrayList<BillCard>> entityRelationMap = new HashMap<String, ArrayList<BillCard>>(16);
        for (BillCard billCard2 : cards) {
            String entityNumber = billCard2.getEntityNumber();
            ArrayList<BillCard> relations = (ArrayList<BillCard>)entityRelationMap.get(entityNumber);
            if (relations == null) {
                relations = new ArrayList<BillCard>();
                entityRelationMap.put(entityNumber, relations);
            }
            relations.add(billCard2);
        }
        for (Map.Entry entry : entityRelationMap.entrySet()) {
            List children = (List)entry.getValue();
            int size = children.size();
            if (size >= this.stackSize) {
                StackedBillRelation stackedBillRelation = this.createStackedBillRelation(relationMap, children);
                for (BillCard card : children) {
                    List targets = card.getTargets();
                    if (targets == null || targets.isEmpty()) continue;
                    for (BillCard target : targets) {
                        this.addBillRelationTargets(relationMap, (BillRelation)stackedBillRelation, target);
                    }
                }
                relation.getTargets().add(stackedBillRelation);
                continue;
            }
            for (BillCard child : children) {
                this.addBillRelationTargets(relationMap, relation, child);
            }
        }
        return relation;
    }

    private void addBillRelationTargets(Map<String, BillRelation> relationMap, BillRelation relation, BillCard child) {
        String uniqueKey = this.getUniqueKey(child);
        BillRelation target = relationMap.get(uniqueKey);
        if (target != null) {
            this.log.debug(String.format("%s %s already handled.", relation.getEntityNumber(), relation.getBusinessKey()));
        } else {
            target = this.getBillRelation(child, relationMap);
            relationMap.put(uniqueKey, target);
        }
        relation.getTargets().add(target);
    }

    private StackedBillRelation createStackedBillRelation(Map<String, BillRelation> relationMap, List<BillCard> children) {
        BillCard tplCard = children.get(0);
        BillRelation relation = relationMap.get(this.getUniqueKey(tplCard));
        if (relation instanceof StackedBillRelation) {
            return (StackedBillRelation)relation;
        }
        StackedBillRelation stackedBillRelation = new StackedBillRelation();
        stackedBillRelation.setBillNo(tplCard.getBillNo());
        stackedBillRelation.setBusinessKey(tplCard.getBusinessKey());
        stackedBillRelation.setEntityName(tplCard.getEntityName());
        stackedBillRelation.setEntityNumber(tplCard.getEntityNumber());
        for (BillCard card : children) {
            stackedBillRelation.addStackedBusKey(card.getBusinessKey());
            String uniqueKey = this.getUniqueKey(card);
            relationMap.put(uniqueKey, (BillRelation)stackedBillRelation);
        }
        return stackedBillRelation;
    }

    private String getUniqueKey(BillCard card) {
        return BizFlowGraphUtil.getUniqueKey((String)card.getEntityNumber(), (String)card.getBusinessKey());
    }
}

