/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.component;

import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.attachment.util.ParamUtil;
import kd.bos.form.control.events.BeforeShowTipsEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.bill.MobileBillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.url.UrlService;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.component.IApprovalRecord;
import kd.bos.workflow.component.YzjChat;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.component.yzj.YZJGroupUtil;
import kd.bos.workflow.design.plugin.event.OpenCustomChatEvent;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.extitf.ExtItfCallerType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.calculator.ExpressionCalculatorUtil;
import kd.bos.workflow.engine.impl.cmd.startup.BusinessModelVariableScope;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordGroup;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.ApprovalRecordHtmlAdapter;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.SignatureUtils;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.engine.msg.ArchiveRouteIndexCondition;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

@DataEntityTypeAttribute(name="kd.bos.workflow.component.ApprovalRecord")
public class ApprovalRecord
extends YzjChat
implements IApprovalRecord {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String PAGEID = "pageId";
    public static final String ISPC = "isPC";
    public static final String HIDEMORECHAT = "hideMoreChat";
    public static final String HIDECHAT = "hideChat";
    public static final String NOTIMELINE = "noTimeLine";
    public static final String HASVALUE = "hasValue";
    public static final String APPROVALISNEW = "approvalIsNew";
    public static final String NOAUTOFILLDATA = "noAutoFillData";
    public static final String ISDDORQYWX = "isDDOrQYWX";
    public static final String TRANSFERRECORDPAGEID = "transferRecordPageId";
    public static final String PROCINSTID = "procInstId";
    public static final String ISCUSTOMCHAT = "isCustomChat";
    public static final String FALSEFLAG = "false";
    public static final String TRUEEFLAG = "true";
    public static final String APPROVALRECORDITEMS = "approvalRecordItems";
    public static final String SHOW_APPROVALRECORD = "SHOW_APPROVALRECORD";
    public static final String HIDEAPPROVALRECORD = "hideApprovalRecord";
    public static final String SHOWALLAPPROVALRECORD = "showAllApprovalRecord";
    private String businessKey;
    private List<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
    private List<IApprovalRecordGroup> arData = new ArrayList<IApprovalRecordGroup>();

    public void setCustomChat(Boolean isCustomChat) {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        pageCache.put(ISCUSTOMCHAT, isCustomChat.toString());
    }

    public Boolean getIsCustomChat() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        Boolean isCustomChat = pageCache.get(ISCUSTOMCHAT) == null;
        Boolean isTrue = TRUEEFLAG.equalsIgnoreCase(pageCache.get(ISCUSTOMCHAT));
        return isCustomChat != false ? Boolean.FALSE : isTrue;
    }

    public List<Map<String, Object>> getData() {
        return this.data;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(String businessKey) {
        this.logger.debug("\u5ba1\u6279\u8bb0\u5f55\u7ec4\u4ef6\u8bbe\u7f6ebusinessKey\uff1a" + businessKey);
        this.businessKey = businessKey;
        try {
            String customApprovalRecordClass = WfConfigurationUtil.getCustomApprovalRecordClass();
            if (WfUtils.isNotEmpty((String)customApprovalRecordClass)) {
                this.setArData(ExternalInterfaceUtil.invokeCustomApprovalRecordExtItf((String)customApprovalRecordClass, (String)businessKey));
            } else {
                TaskService taskService = ((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getTaskService();
                if (CollectionUtil.isEmpty(this.arData)) {
                    WorkflowService workflowService;
                    Long processInstanceId = null;
                    if (WfUtils.isNotEmpty((String)businessKey) && WfUtils.isNotEmpty((Long)(processInstanceId = (workflowService = (WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRuntimeService().getProcInstIdByBusKey(businessKey)))) {
                        if (this.getParameters() == null) {
                            this.setParameters(new HashMap<String, Object>(20));
                        }
                        this.getParameters().put(PROCINSTID, processInstanceId);
                    }
                    this.setArData(taskService.queryApprovalRecord(processInstanceId, businessKey));
                }
            }
        }
        catch (KDException e) {
            this.setArData(Collections.emptyList());
        }
    }

    public List<IApprovalRecordGroup> getArData() {
        return this.arData;
    }

    public void bindData(BindingContext object) {
        if (this.getParameters() != null && WfUtils.isNotEmptyString((Object)this.getParameters().get(NOAUTOFILLDATA)) || TRUEEFLAG.equals(this.getView().getFormShowParameter().getCustomParam(HIDEAPPROVALRECORD))) {
            super.bindData(object);
            return;
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        if (WfUtils.isEmpty((String)pageCache.get(this.getKey() + HASVALUE)) && this.getView() instanceof BillView) {
            IBillModel billModel = (IBillModel)this.view.getModel();
            Object pkValue = billModel.getPKValue();
            ArchiveRouteIndexCondition condition = new ArchiveRouteIndexCondition("businessKey", (Object)String.valueOf(pkValue));
            ArchiveFormService.create().injectArchiveRouteInfo(this.view, "wf_hiprocinst", condition);
            if (pkValue != null && WfUtils.isNotEmpty((String)String.valueOf(pkValue)) && !"0".equals(String.valueOf(pkValue))) {
                this.logger.debug("\u5ba1\u6279\u8bb0\u5f55\u7ec4\u4ef6bindData\u8bbe\u7f6epkValue\uff1a" + pkValue);
                if (pkValue instanceof Long && WfUtils.isNotEmpty((Long)((Long)pkValue))) {
                    if (WfUtils.isEmpty((String)this.businessKey)) {
                        HashMap<String, Object> parameters = new HashMap<String, Object>();
                        if (this.getView() instanceof MobileBillView) {
                            parameters.put(ISPC, FALSEFLAG);
                        } else {
                            parameters.put(ISPC, TRUEEFLAG);
                        }
                        this.setParameters(parameters);
                        this.setBusinessKey(String.valueOf(pkValue));
                    }
                } else if (pkValue instanceof String && WfUtils.isNotEmptyString((Object)pkValue) && WfUtils.isEmpty((String)this.businessKey)) {
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    if (this.getView() instanceof MobileBillView) {
                        parameters.put(ISPC, FALSEFLAG);
                    } else {
                        parameters.put(ISPC, TRUEEFLAG);
                    }
                    this.setParameters(parameters);
                    this.setBusinessKey(String.valueOf(pkValue));
                }
            } else {
                this.setArData(Collections.emptyList());
            }
        }
        super.bindData(object);
        pageCache.remove(this.getKey() + HASVALUE);
    }

    public void setArData(List<IApprovalRecordGroup> arData) {
        Object superProcInstId;
        if (arData == null || arData.isEmpty()) {
            arData = new ArrayList<IApprovalRecordGroup>();
        }
        this.arData = arData;
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (this.getParameters() != null && this.getParameters().get(PAGEID) != null) {
            param.put(PAGEID, this.getParameters().get(PAGEID));
        } else {
            param.put(PAGEID, this.getView().getPageId());
        }
        if (this.getParameters() != null && this.getParameters().get(ISPC) != null) {
            Long procInstId;
            DynamicObject dynamicObject;
            String isPC = (String)this.getParameters().get(ISPC);
            param.put(ISPC, isPC);
            this.sortItems(arData, isPC);
            if (this.getParameters().get(HIDEMORECHAT) != null) {
                param.put(HIDEMORECHAT, this.getParameters().get(HIDEMORECHAT));
            }
            if (!WfConfigurationUtil.isYunzhijiaEnable()) {
                param.put(HIDEMORECHAT, Boolean.TRUE);
            }
            if (this.getParameters().get(HIDECHAT) != null) {
                param.put(HIDECHAT, this.getParameters().get(HIDECHAT));
            }
            if (!WfConfigurationUtil.isYunzhijiaEnable()) {
                param.put(HIDECHAT, Boolean.TRUE);
            }
            if (this.getParameters().get(NOTIMELINE) != null) {
                param.put(NOTIMELINE, this.getParameters().get(NOTIMELINE));
            }
            if (this.getParameters().get(ISDDORQYWX) != null) {
                param.put(ISDDORQYWX, this.getParameters().get(ISDDORQYWX));
            }
            if (this.getParameters().get(PROCINSTID) != null && this.getParameters().get(SHOWALLAPPROVALRECORD) == null && WfUtils.isNotEmpty((String)(superProcInstId = (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)(procInstId = (Long)this.getParameters().get(PROCINSTID)), (String)"wf_historicalprocesses")).getString("superProcessInstanceId"))) && !"0".equals(superProcInstId) && ProcessType.AuditFlow.name().equals(ViewFlowchartUtil.getWorkFlowType((Long)Long.valueOf((String)superProcInstId)))) {
                param.put("superProcInstId", superProcInstId);
            }
        }
        for (IApprovalRecordGroup arDatum : arData) {
            List children = arDatum.getChildren();
            if (children == null || children.size() == 0) continue;
            superProcInstId = children.iterator();
            while (superProcInstId.hasNext()) {
                IApprovalRecordItem approvalRecordItem;
                String message = (approvalRecordItem = (IApprovalRecordItem)superProcInstId.next()).getMessage();
                approvalRecordItem.setMessage(StringUtils.isEmpty((CharSequence)message) ? message : ApprovalRecordHtmlAdapter.adaptHtml((String)approvalRecordItem.getMessage()));
            }
        }
        param.put(APPROVALRECORDITEMS, arData);
        param.put("key", this.getKey());
        this.initPersonalLabelName(param);
        if (this.getParameters() != null && this.getParameters().get(APPROVALISNEW) != null) {
            param.put(APPROVALISNEW, this.getParameters().get(APPROVALISNEW));
        }
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction(SHOW_APPROVALRECORD, param);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        Map<String, Object> parameter = this.getParameters();
        Object procInstId = null;
        if (null != parameter) {
            procInstId = parameter.get(PROCINSTID);
        }
        HashMap<String, String> cacheMap = new HashMap<String, String>(2);
        cacheMap.put(PROCINSTID, null == procInstId ? "" : procInstId.toString());
        cacheMap.put(this.getKey() + HASVALUE, HASVALUE);
        pageCache.put(cacheMap);
    }

    public void initPersonalLabelName(Map<String, Object> param) {
        String coordinateName = "coordinateName";
        String transferName = "transferName";
        Map config = WfConfigurationUtil.getConfigCenterVals((String[])new String[]{coordinateName, transferName});
        String coordinate = WfConfigurationUtil.getCoordinateName((String)((String)config.get(coordinateName)));
        String transfer = WfConfigurationUtil.getTransferName((String)((String)config.get(transferName)));
        param.put(coordinateName, coordinate);
        param.put(transferName, transfer);
    }

    private void sortItems(List<IApprovalRecordGroup> arData, String isPC) {
        if (FALSEFLAG.equalsIgnoreCase(isPC) || WfConfigurationUtil.getRecordSortDesc()) {
            Collections.reverse(arData);
            for (IApprovalRecordGroup item : arData) {
                List children = item.getChildren();
                if (children == null || children.size() <= 1) continue;
                Collections.reverse(children);
            }
        }
    }

    public void setData(List<Map<String, Object>> data) {
        if (data == null) {
            return;
        }
        this.data = data;
        this.arData = this.dataConversion(data);
        this.setArData(this.arData);
    }

    private List<IApprovalRecordGroup> dataConversion(List<Map<String, Object>> data) {
        ArrayList<IApprovalRecordGroup> list = new ArrayList<IApprovalRecordGroup>(data.size());
        for (Map<String, Object> map : data) {
            ApprovalRecordGroup item = new ApprovalRecordGroup();
            item.setGroup(map.get("group").toString());
            item.setGroupDecisionType(map.get("groupDecisionType").toString());
            List children = (List)map.get("children");
            item.setChildren(this.getChildren(children));
            list.add((IApprovalRecordGroup)item);
            item = null;
        }
        return list;
    }

    private List<IApprovalRecordItem> getChildren(List<Map<String, Object>> children) {
        ArrayList<IApprovalRecordItem> list = new ArrayList<IApprovalRecordItem>(children.size());
        for (Map<String, Object> map : children) {
            ApprovalRecordItem item = new ApprovalRecordItem();
            item.setAssignee(this.getStringVal(map.get("userName")));
            item.setAvatar(this.getStringVal(map.get("avatar")));
            item.setDecisionType(this.getStringVal(map.get("decisionType")));
            item.setMessage(this.getStringVal(map.get("message")));
            item.setOpenId(this.getStringVal(map.get("openId")));
            item.setTime(this.getStringVal(map.get("time")));
            item.setResult(this.getStringVal(map.get("resultName")));
            list.add((IApprovalRecordItem)item);
            item = null;
        }
        return list;
    }

    private String getStringVal(Object obj) {
        return WfUtils.isNullObject((Object)obj) ? "" : obj.toString();
    }

    public void itemClick(LinkedHashMap<?, ?> param) {
        this.logger.debug("approvalRecord.itemClick:" + SerializationUtils.toJsonString(param));
        String currentOpenId = RequestContext.get().getUserOpenId();
        List ids = (List)param.get("openIds");
        if (ids == null || ids.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8ba8\u8bba\u4eba\u5458", (String)"ApprovalRecord_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        if (ids.contains(currentOpenId)) {
            ids.remove(currentOpenId);
        }
        if (ids.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u4eba\u53ea\u6709\u672c\u4eba\uff0c\u4e0d\u80fd\u521b\u5efa\u8ba8\u8bba\u7ec4\u3002", (String)"ApprovalPagePluginNew_12", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        Set<String> openIdSet = ids.stream().collect(Collectors.toSet());
        String[] openIds = openIdSet.toArray(new String[0]);
        Object businessKey = param.get("businessKey");
        if (ObjectUtils.isEmpty(businessKey) && "moreChat".equals(param.get("clickScene"))) {
            StringBuilder businessKeyForGroup = new StringBuilder();
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long processInstanceId = (Long)formShowParameter.getCustomParam("processInstanceId");
            businessKeyForGroup = businessKeyForGroup.append(processInstanceId);
            ArrayList openIdList = new ArrayList(openIdSet);
            if (StringUtils.isNotBlank((CharSequence)currentOpenId) && openIdList.size() > 0) {
                Collections.sort(openIdList);
                String hexString = Integer.toHexString(Objects.hash(openIdList.toArray()));
                businessKeyForGroup.append(currentOpenId).append(hexString);
            }
            param.put("businessKey", businessKeyForGroup);
        }
        if (this.getIsCustomChat().booleanValue()) {
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            OpenCustomChatEvent args = new OpenCustomChatEvent((Object)this.getView(), "approvalrecord", "openCustomChat", null, openIds, param);
            proxy.fireCustomEvent((CustomEventArgs)args);
        } else if (WfConfigurationUtil.isYunzhijiaEnable()) {
            HashMap<String, Object> buildParam;
            Map invokeRet;
            Object openChatForMob = param.get("openChatForMob");
            String groupName = (String)param.get("groupName");
            String copyGroupName = (String)param.get("groupName");
            String reviewDiscussName = ResManager.loadKDString((String)"\u4f1a\u5ba1\u8ba8\u8bba", (String)"ApprovalPluginNew_46", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            if (WfUtils.isEmpty((String)groupName) && !reviewDiscussName.equalsIgnoreCase(groupName) && YZJGroupUtil.isResetGroupName() && (invokeRet = this.resetYZJGroupProperties(param, buildParam = new HashMap<String, Object>(2))) != null && invokeRet.get("groupName") != null) {
                groupName = (String)invokeRet.get("groupName");
                param.putAll(invokeRet);
            }
            if (WfUtils.isNotEmpty((String)copyGroupName)) {
                HashMap<String, String> temp = new HashMap<String, String>(param.size());
                temp.put("groupName", "");
                param.putAll(temp);
            }
            if (WfUtils.isNotEmptyString(openChatForMob) && Boolean.parseBoolean(openChatForMob.toString())) {
                try {
                    this.openPhoneChat(openIds, param);
                }
                catch (KDException e) {
                    this.getView().showTipNotification(e.getMessage(), Integer.valueOf(3000));
                }
                catch (Exception e) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u529f\u80fd\u5f02\u5e38\uff0c\u65e0\u6cd5\u8fdb\u884c\u6c9f\u901a\u3002", (String)"ApprovalRecord_13", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                }
            } else {
                this.openChat(openIds, groupName, param);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u901a\u4e91\u4e4b\u5bb6\u518d\u5efa\u7acb\u6c9f\u901a\u3002", (String)"ApprovalRecord_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    public void showFormByTips(String params, String elementId, String triggerType) {
        if (WfUtils.isEmpty((String)params)) {
            String tips = ResManager.loadKDString((String)"\u663e\u793atips\u914d\u7f6e\u9519\u8bef\uff0c\u539f\u56e0\uff1a\u63a7\u4ef6\u201c%s\u201d\u663e\u793atips\u5c5e\u6027formId\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApprovalRecord_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            String format = String.format(tips, this.getKey());
            String title = ResManager.loadKDString((String)"\u663e\u793atips\u914d\u7f6e\u9519\u8bef", (String)"ApprovalRecord_6", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getView().showErrMessage(format, title);
        } else {
            String taskId = params.split("_")[0];
            String userId = params.split("_")[1];
            String hideChat = params.split("_")[2];
            BeforeShowTipsEvent event = new BeforeShowTipsEvent((Object)this);
            FormShowParameter param = event.getFormshowParameter();
            if (param == null) {
                param = new FormShowParameter();
            }
            HashMap<String, String> formParam = new HashMap<String, String>();
            param.getOpenStyle().setShowType(ShowType.ToolTips);
            HashMap<String, String> custParam = new HashMap<String, String>();
            custParam.put("elementId", elementId);
            formParam.put("taskId", taskId);
            formParam.put("userId", userId);
            formParam.put(HIDECHAT, hideChat);
            param.setCustomParams(formParam);
            param.getOpenStyle().setCustParam(custParam);
            param.getOpenStyle().setTargetKey(this.getKey());
            param.setFormId("wf_teamwork_task");
            this.getView().showForm(param);
        }
    }

    public void showApprovalsPage(List<Map<String, Object>> approvers, String signType, String groupDecisionType, String throughRule, Boolean isDDOrQYWX) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setCustomParam("approvers", approvers);
        parameter.setCustomParam("signtype", (Object)signType);
        parameter.setCustomParam("groupdecisiontype", (Object)groupDecisionType);
        parameter.setCustomParam("throughrule", (Object)throughRule);
        parameter.setCustomParam("isddorqywx", (Object)isDDOrQYWX);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_approverinfos");
        this.getView().showForm(parameter);
    }

    public void showPersonInfo(String userId) {
        if (StringUtils.isEmpty((CharSequence)userId.trim()) || !WfConfigurationUtil.isYunzhijiaEnable()) {
            return;
        }
        DynamicObject loadSingle = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user", (String)"useropenid");
        String openId = loadSingle.getString("useropenid");
        if (StringUtils.isEmpty((CharSequence)openId.trim())) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("method", "personInfo");
        HashMap<String, String> person = new HashMap<String, String>();
        person.put("openId", openId);
        map.put("args", person);
        this.getView().executeClientCommand("callYZJApi", new Object[]{map});
    }

    public void showCoordinateInfo(String taskId, String userId, boolean containAutoCoordinate) {
        if (StringUtils.isBlank((CharSequence)taskId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"taskID\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApprovalRecord_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtils.isBlank((CharSequence)userId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"userID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApprovalRecord_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.injectArchiveRouteInfo();
        List records = CoordinateRecordUtil.getCoordinateRecordsTagTransfer((String)taskId, (boolean)containAutoCoordinate);
        SignatureUtils.handleApprovalRecordSignatureUrl((List)records);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("key", this.getKey());
        ret.put("coordinate_key", taskId + "_" + userId);
        ret.put("coordinate_value", records);
        IClientViewProxy iClientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        iClientViewProxy.addAction("SHOW_COORDINATE", ret);
    }

    public void showAutoCoordinateInfo(String groupId) {
        this.injectArchiveRouteInfo();
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        List records = wfService.getTaskService().getAutoCoordinateRecordCmd(Long.valueOf(groupId));
        SignatureUtils.handleApprovalRecordSignatureUrl((List)records);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("key", this.getKey());
        ret.put("coordinate_key", groupId);
        ret.put("coordinate_value", records);
        IClientViewProxy iClientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        iClientViewProxy.addAction("SHOW_AUTOCOORDINATE", ret);
    }

    public void showAttachmentInfo(String attacheId, String downloadUrl, String attachmentIds) {
        if (WfUtils.isEmpty((String)attachmentIds)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9644\u4ef6ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ApprovalRecord_11", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        if (WfUtils.isEmpty((String)attacheId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9644\u4ef6ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"ApprovalRecord_12", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String[] ids = attachmentIds.split(",");
        Object[] attacheIds = new Object[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            attacheIds[i] = Long.valueOf(ids[i]);
        }
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])attacheIds, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_attachment"));
        HashMap<String, Object> attachementInfo = new HashMap<String, Object>();
        ArrayList<String> urlList = new ArrayList<String>();
        IPageCache pageCache = this.getView().getPageCache();
        for (DynamicObject dynamicObject : dynamicObjects) {
            String fileExt = dynamicObject.getString("type");
            if (attacheId.equals(dynamicObject.getString("id"))) {
                attachementInfo.put("fileId", dynamicObject.getString("id"));
                attachementInfo.put("uid", dynamicObject.getString("id"));
                attachementInfo.put("fileName", dynamicObject.getLocaleString("name") == null ? "" : dynamicObject.getLocaleString("name").getLocaleValue());
                attachementInfo.put("name", dynamicObject.getLocaleString("name") == null ? "" : dynamicObject.getLocaleString("name").getLocaleValue());
                attachementInfo.put("fileSize", Integer.valueOf(dynamicObject.getString("size")));
                attachementInfo.put("size", Integer.valueOf(dynamicObject.getString("size")));
                attachementInfo.put("fileExt", fileExt);
                attachementInfo.put("type", fileExt);
                attachementInfo.put("downloadUrl", downloadUrl);
                attachementInfo.put("url", downloadUrl);
                Object previewUrl = CoordinateRecordUtil.getPreviewUrl((String)downloadUrl, (String)dynamicObject.getString("type"));
                if (previewUrl != null) {
                    String entitynumber;
                    if (pageCache != null && StringUtils.isNotBlank((CharSequence)(entitynumber = pageCache.get("entitynumber")))) {
                        previewUrl = previewUrl + "&fId=" + entitynumber;
                    }
                    attachementInfo.put("previewUrl", previewUrl);
                    attachementInfo.put("previewurl", previewUrl);
                }
                if (CoordinateRecordUtil.isImage((String)fileExt).booleanValue()) {
                    urlList.add((String)previewUrl);
                }
                attachementInfo.put("fileTime", ((Timestamp)dynamicObject.get("createtime")).getTime());
                attachementInfo.put("filesource", dynamicObject.getInt("filesource"));
                attachementInfo.put("status", "success");
                attachementInfo.put("fileShowByInstructions", Boolean.TRUE);
                attachementInfo.put("previewType", ParamUtil.getPreviewType());
                continue;
            }
            if (!CoordinateRecordUtil.isImage((String)fileExt).booleanValue()) continue;
            String url = dynamicObject.getString("url");
            try {
                url = URLEncoder.encode(CoordinateRecordUtil.removeUrlVersion((String)url), StandardCharsets.UTF_8.name());
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
            }
            String imgDownloadUrl = EncreptSessionUtils.encryptSession((String)UrlService.getAttachmentFullUrl((String)url));
            Object previewUrl = CoordinateRecordUtil.getPreviewUrl((String)imgDownloadUrl, (String)dynamicObject.getString("type"));
            urlList.add(previewUrl.toString());
        }
        if (!urlList.isEmpty()) {
            attachementInfo.put("urlList", urlList);
        }
        IClientViewProxy iClientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        this.logger.info("ApprovalRecord.showAttachmentInfo attachementInfo:" + attachementInfo);
        iClientViewProxy.addAction("previewAttachment", attachementInfo);
    }

    public void clickCustomizeLink(Map<String, String> params) {
        DesignerPluginUtil.showCustomizedForm((IFormView)this.getView(), params);
    }

    public void showTransferRecord(String taskId, String userId, boolean coordinate) {
        boolean result = this.isAlreadyOpened();
        if (!result) {
            ApprovalPluginUtil.showTransferRecord(this.getView(), taskId, userId, coordinate);
        }
    }

    public void showTransferRecordYZJ(Map<String, String> value, boolean coordinate) {
        boolean result = this.isAlreadyOpened();
        if (!result) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("wf_mobiletransferrecord");
            parameter.setCustomParam("value", (Object)SerializationUtils.toJsonString(value));
            parameter.setCustomParam("coordinate", (Object)coordinate);
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.put(TRANSFERRECORDPAGEID, parameter.getPageId());
            this.getView().showForm(parameter);
        }
    }

    private boolean isAlreadyOpened() {
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String pageId = pageCache.get(TRANSFERRECORDPAGEID);
        return !WfUtils.isEmpty((String)pageId) && this.getView().getView(pageId) != null;
    }

    public void showChildProcessInfo(Map<String, Object> params, String procInstId) {
        this.injectArchiveRouteInfo();
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        HashMap<String, String> recordParams = new HashMap<String, String>();
        recordParams.put("operationTag", "showChildProcessInfo");
        List approvalRecordItems = wfService.getTaskService().queryApprovalRecord(null, Long.valueOf(procInstId), recordParams);
        approvalRecordItems.forEach(t -> SignatureUtils.handleApprovalRecordSignatureUrl((List)t.getChildren()));
        this.sortItems(approvalRecordItems, (String)params.get(ISPC));
        params.put(APPROVALRECORDITEMS, approvalRecordItems);
        params.put("key", this.getKey());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)"wf_historicalprocesses");
        String superProcInstId = dynamicObject.getString("superProcessInstanceId");
        params.put("superProcInstId", superProcInstId);
        this.initPersonalLabelName(params);
        IClientViewProxy iClientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        iClientViewProxy.addAction(SHOW_APPROVALRECORD, params);
    }

    public void backToParentProcess(Map<String, Object> params, String procInstId) {
        this.injectArchiveRouteInfo();
        HashMap<String, Object> recordParams = new HashMap<String, Object>();
        recordParams.put("operationTag", "backToParentProcess");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)procInstId, (String)"wf_historicalprocesses");
        List<IApprovalRecordGroup> approvalRecordItems = this.getApprovalRecordItems(dynamicObject, procInstId, recordParams);
        approvalRecordItems.forEach(t -> SignatureUtils.handleApprovalRecordSignatureUrl((List)t.getChildren()));
        this.sortItems(approvalRecordItems, (String)params.get(ISPC));
        params.put(APPROVALRECORDITEMS, approvalRecordItems);
        params.put("key", this.getKey());
        String superProcInstId = dynamicObject.getString("superProcessInstanceId");
        if (WfUtils.isEmpty((String)superProcInstId) || "0".equals(superProcInstId)) {
            superProcInstId = null;
        }
        params.put("superProcInstId", superProcInstId);
        this.initPersonalLabelName(params);
        IClientViewProxy iClientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        iClientViewProxy.addAction(SHOW_APPROVALRECORD, params);
    }

    private List<IApprovalRecordGroup> getApprovalRecordItems(DynamicObject procInstObject, String procInstId, Map<String, Object> recordParams) {
        String businesskey = procInstObject.getString("businessKey");
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        Long times = wfService.getRuntimeService().findBillEnterProcessTimes(businesskey);
        if ((times = Optional.ofNullable(times).orElseGet(() -> 0L)) > 1L) {
            return wfService.getTaskService().queryApprovalRecord(businesskey, procInstObject.getString("entityNumber"), true);
        }
        return wfService.getTaskService().queryApprovalRecord(null, Long.valueOf(procInstId), recordParams);
    }

    private void injectArchiveRouteInfo() {
        ArchiveFormService.create().injectArchiveRouteInfo(this.view);
    }

    private Map resetYZJGroupProperties(LinkedHashMap param, Map<String, Object> buildParam) {
        Object configCenterVal = WfConfigurationUtil.getConfigCenterVal((String)"workflow.groupNameForApprovalRecord");
        if (WfUtils.isNotNullObject((Object)configCenterVal)) {
            JSONObject jsonObject;
            this.buildParamIfNeed(buildParam);
            String jsonValue = configCenterVal.toString();
            if (jsonValue.length() > 0 && this.isMatchEntityNumber(jsonObject = (JSONObject)SerializationUtils.fromJsonString((String)jsonValue, JSONObject.class), buildParam)) {
                String expression = jsonObject.getString("expression");
                String pluginClass = jsonObject.getString("class");
                String defaultGroupName = param.get("groupName") == null ? "" : (String)param.get("groupName");
                String groupName = "";
                if (WfUtils.isNotEmpty((String)pluginClass)) {
                    Map invokeRet = YZJGroupUtil.invokeBizPlugin((ExtItfCallerType)ExtItfCallerType.GROUPNAMEFORAPPROVALRECORD, (String)pluginClass, buildParam);
                    if (invokeRet != null) {
                        param.putAll(invokeRet);
                    } else {
                        param.put(groupName, defaultGroupName);
                    }
                }
                if (WfUtils.isNotEmpty((String)expression) && WfUtils.isEmpty((String)pluginClass) && WfUtils.isNotEmpty((String)(groupName = this.getGroupNameByExpression(expression, buildParam)))) {
                    param.put("groupName", groupName);
                }
                if (WfUtils.isEmpty((String)expression) && WfUtils.isEmpty((String)pluginClass)) {
                    return null;
                }
            }
        }
        return param;
    }

    private String getGroupNameByExpression(String expression, Map<String, Object> buildParam) {
        String entityNumber = buildParam.get("entityNumber") == null ? "" : buildParam.get("entityNumber").toString();
        String pkValue = buildParam.get("businessKey") == null ? "" : buildParam.get("businessKey").toString();
        Long taskId = buildParam.get("taskId") == null ? 0L : Long.parseLong(buildParam.get("taskId").toString());
        Long processInstanceId = buildParam.get("processInstanceId") == null ? 0L : Long.parseLong(buildParam.get("processInstanceId").toString());
        return this.getGroupName(expression, entityNumber, pkValue, processInstanceId);
    }

    private String getGroupName(String expression, String entityNumber, String businessKey, Long processInstanceId) {
        String groupName = "";
        if (expression.contains("{billname}")) {
            String billName = EntityMetadataCache.getDataEntityType((String)entityNumber).getDisplayName().getLocaleValue();
            expression = expression.replace("{billname}", billName);
        }
        if (WfUtils.isEmpty((String)businessKey)) {
            businessKey = this.getPkValue(processInstanceId);
        }
        DynamicObject dynObj = WfUtils.findBusinessObject((String)businessKey, (String)entityNumber);
        BusinessModelVariableScope scope = new BusinessModelVariableScope(dynObj);
        groupName = ExpressionCalculatorUtil.contentParser((String)expression, (DynamicObject)dynObj, (VariableScope)scope, new HashMap(), (boolean)false);
        this.logger.info("ExpressionCalculator result groupName:" + groupName);
        return groupName;
    }

    private String getPkValue(Long processInstanceId) {
        Object key;
        String businessKey = "";
        DynamicObject query = QueryServiceHelper.queryOne((String)"wf_hiprocinst", (String)"businesskey", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)processInstanceId)});
        if (query != null && (key = query.get("businesskey")) != null) {
            businessKey = key.toString();
        }
        return businessKey;
    }

    private void buildParamIfNeed(Map<String, Object> param) {
        Object taskIdObj;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNumber = "";
        entityNumber = formShowParameter.getCustomParam("entityNumber") != null && WfUtils.isNotEmpty((String)formShowParameter.getCustomParam("entityNumber").toString()) ? (String)formShowParameter.getCustomParam("entityNumber") : (String)formShowParameter.getCustomParam("entitynumber");
        if (WfUtils.isEmpty((String)entityNumber)) {
            entityNumber = (String)formShowParameter.getCustomParam("formkey");
        }
        Long processInstanceId = (Long)formShowParameter.getCustomParam("processInstanceId");
        String pkValue = "";
        pkValue = formShowParameter.getCustomParam("businessKey") != null && WfUtils.isNotEmpty((String)formShowParameter.getCustomParam("businessKey").toString()) ? (String)formShowParameter.getCustomParam("businessKey") : (String)formShowParameter.getCustomParam("businesskey");
        Long taskId = 0L;
        Object object = taskIdObj = formShowParameter.getCustomParam("taskId") == null ? formShowParameter.getCustomParam("taskid") : formShowParameter.getCustomParam("taskId");
        if (taskIdObj != null) {
            taskId = Long.parseLong(taskIdObj.toString());
        }
        if (WfUtils.isEmpty((String)entityNumber) && WfUtils.isEmpty((String)pkValue)) {
            entityNumber = formShowParameter.getFormConfig().getEntityTypeId();
            if (formShowParameter instanceof BillShowParameter) {
                pkValue = ((BillShowParameter)formShowParameter).getPkId().toString();
            }
            if (formShowParameter instanceof BaseShowParameter) {
                pkValue = ((BaseShowParameter)formShowParameter).getPkId().toString();
            }
        }
        param.put("taskId", taskId);
        param.put("entityNumber", entityNumber);
        param.put("processInstanceId", processInstanceId);
        param.put("businessKey", pkValue);
        this.logger.info(String.format("buildParamIfNeed.param-[%s]", param));
    }

    private boolean isMatchEntityNumber(JSONObject jsonObject, Map<String, Object> buildParam) {
        boolean find = false;
        String entityNumber = jsonObject.getString("entitynumber");
        if (WfUtils.isNotEmpty((String)entityNumber)) {
            List entityNumberConfig = Arrays.stream(entityNumber.split(",")).collect(Collectors.toList());
            if (entityNumberConfig.contains(buildParam.get("entityNumber"))) {
                find = true;
            }
        } else {
            find = true;
        }
        return find;
    }
}

