/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.batchsetting.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.design.batchsetting.plugin.ProcessInfoInitializeTaskClick;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessInfoEntity;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingJobInfo;
import kd.bos.workflow.engine.management.batchsetting.BatchSettingUtil;
import kd.bos.workflow.engine.management.batchsetting.task.ProcessInfoInitializeTask;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkflowProcessBatchSettingPlugin
extends AbstractListPlugin
implements IConfirmCallBack {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String BTN_ADVSET = "btnadvset";
    private static final String BTN_SHOWLOG = "btnshowlog";
    private static final String KEY_INITIALIZATION = "initialization";
    private static final String KEY_INITIAL_SELECT = "initial_select";
    private static final String KEY_OPENED_IDS = "openedIds";
    private static final String SHARECONFIGTOPERMISSION = "1CWJCD1V3PLN";

    public void afterCreateNewData(EventObject e) {
        this.initProcessInfoDatas();
        if (!Lang.zh_CN.equals((Object)RequestContext.get().getLang()) && !WfConfigurationUtil.isEnableShowMutiLangLog()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SHOWLOG});
        }
    }

    protected QFilter getSameEntityFilter() {
        QFilter filter = null;
        IFormView parentView = this.getView().getParentView();
        IPageCache pageCache = parentView.getPageCache();
        String isSameEntity = pageCache.get("isSameEntity");
        if ("true".equals(isSameEntity)) {
            String entityId = pageCache.get("entityId");
            String filterField = pageCache.get("filterField");
            filter = new QFilter(filterField, "=", (Object)entityId);
        }
        return filter;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("processtype", "=", (Object)ModelType.AuditFlow.name()));
        QFilter sameEntityFilter = this.getSameEntityFilter();
        if (sameEntityFilter != null) {
            e.getQFilters().add(sameEntityFilter);
        }
        WfAdminUtil.addWfOrgFilter((SetFilterEvent)e, (String)"wf_processinfo");
    }

    protected void initProcessInfoDatas() {
        WorkflowService wfService = this.getWorkflowService();
        Object initialized = WfConfigurationUtil.getConfigCenterVal((String)"workflow.initialize.batchSetting");
        if ("true".equals(initialized)) {
            this.log.debug("processInfo initialized.");
            return;
        }
        List procDefIds = wfService.getManagementService().findToBeInitializedProcDefIds(false);
        if (!procDefIds.isEmpty()) {
            this.log.debug("processInfo Not initialized.");
            this.getView().setEnable(Boolean.FALSE, new String[]{BTN_ADVSET, BTN_SHOWLOG, "btnset"});
            this.getView().showConfirm(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230\u6709\u672a\u521d\u59cb\u5316\u7684\u6570\u636e\uff0c\u662f\u5426\u5f00\u59cb\u521d\u59cb\u5316\uff1f", (String)"WorkflowProcessBatchSettingPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_INITIALIZATION));
        } else {
            this.log.debug("no procDefIds need to be initialized.");
            this.cacheInitResult();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        if (!DesignerPluginUtil.checkWorkflowInService((IFormView)this.getView())) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "btnadvset": {
                this.advancedSetting();
                break;
            }
            case "btnshowlog": {
                this.showBatchSettingLog();
                break;
            }
            default: {
                super.itemClick(evt);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (evt.getSource() instanceof Refresh) {
            this.doRefresh();
        }
    }

    private void doRefresh() {
        IDataModel model = this.getView().getModel();
        int count = model.getEntryRowCount("entryentity");
        for (int i = 0; i < count; ++i) {
            model.setValue("propertyvalue", (Object)"donothing", i);
        }
    }

    private void advancedSetting() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_processinfo", (String)SHARECONFIGTOPERMISSION)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u6279\u91cf\u8bbe\u7f6e\u201d\u7684\u201c\u5c5e\u6027\u6279\u91cf\u8bbe\u7f6e\u201d\u6743\u9650\u3002", (String)"WorkflowAdvancedPropSettingPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.size() != 1) {
            Integer integer = Optional.ofNullable(rows).map(ArrayList::size).orElseGet(() -> 0);
            StandardTips.view((IFormView)this.getView()).selectMultiRow(integer.intValue());
            return;
        }
        this.openAdvancedPropSetting((Long)rows.get(0).getPrimaryKeyValue());
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        switch (callBackId = e.getCallBackId()) {
            case "initialization": {
                this.initConfirmCallBack(e);
                break;
            }
            default: {
                super.confirmCallBack(e);
            }
        }
    }

    private void showBatchSettingLog() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)"a479ec06000000ac", (String)"wf_processinfo", (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Long> ids = new ArrayList<Long>();
        if (rows != null && !rows.isEmpty()) {
            for (ListSelectedRow row : rows) {
                ids.add((Long)row.getPrimaryKeyValue());
            }
        }
        if (ids.size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u91cf\u8d85\u51fa100\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"WorkflowProcessBatchSettingPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("wf_batchsetting_logs");
        parameter.setCustomParam("paramIds", ids);
        IFormView parentView = DesignerModelUtil.getTabControlView((IFormView)this.getView());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (parentView != null) {
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parentView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(parentView);
        } else {
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void initConfirmCallBack(MessageBoxClosedEvent e) {
        if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("wf_batchsetting_init");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, KEY_INITIAL_SELECT));
            this.getView().showForm(showParameter);
        } else if (this.viewCanClosed()) {
            this.getView().close();
        } else {
            this.setButtonsEnabled();
        }
    }

    private boolean viewCanClosed() {
        QFilter[] filters = new QFilter[]{new QFilter("id", "is not null", null)};
        Long count = this.getWorkflowService().getRepositoryService().getEntityCountByFilter("wf_processinfo", filters);
        return count == null || count == 0L;
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (KEY_INITIAL_SELECT.equals(actionId)) {
            this.initialSelectCallBack(e);
        } else if ("taskcloseback".equals(actionId)) {
            this.taskCloseCallBack(e);
        } else {
            super.closedCallBack(e);
        }
    }

    private void initialSelectCallBack(ClosedCallBackEvent e) {
        Object data = e.getReturnData();
        if (data instanceof Map) {
            this.initializeData((Map)data);
            WfUtils.addOpLog((String)"wf_processinfo", (String)"batchInitializeProcess", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u6279\u91cf\u8bbe\u7f6e\u521d\u59cb\u5316", "WorkflowProcessBatchSettingPlugin_4", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u6279\u91cf\u8bbe\u7f6e\u6570\u636e\u521d\u59cb\u5316", "WorkflowProcessBatchSettingPlugin_5", "bos-wf-formplugin"), (Object[])new Object[0]);
        } else if (this.viewCanClosed()) {
            this.getView().close();
        } else {
            this.setButtonsEnabled();
        }
    }

    private void setButtonsEnabled() {
        this.getView().setEnable(Boolean.TRUE, new String[]{BTN_ADVSET, BTN_SHOWLOG, "btnset"});
    }

    private void initializeData(Map<String, Object> data) {
        BatchSettingJobInfo info = new BatchSettingJobInfo();
        String title = ResManager.loadKDString((String)"\u6d41\u7a0b\u6279\u91cf\u8bbe\u7f6e\u6570\u636e\u521d\u59cb\u5316", (String)"WorkflowProcessBatchSettingPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        info.setName(title);
        info.setCaption(title);
        info.setTaskClassname(ProcessInfoInitializeTask.class.getCanonicalName());
        info.setClickClassName(ProcessInfoInitializeTaskClick.class.getCanonicalName());
        info.putParam("ongoing", data.get("ongoing"));
        info.putParam("language", data.get("language"));
        BatchSettingUtil.dispatchJobFormInfo((IFormView)this.getView(), (AbstractFormPlugin)this, (BatchSettingJobInfo)info);
    }

    private void taskCloseCallBack(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (returnData instanceof Map) {
            Map data = (Map)returnData;
            String taskInfoStr = (String)data.get("taskinfo");
            if (WfUtils.isEmpty((String)taskInfoStr)) {
                this.log.debug("taskinfo is empty!");
                return;
            }
            TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
            if (taskInfo.isTaskEnd()) {
                JSONObject result = JSON.parseObject((String)taskInfo.getData());
                this.setButtonsEnabled();
                Integer successed = result.getInteger("successed");
                Integer failed = result.getInteger("failed");
                String tip = null;
                if (failed == null || failed == 0) {
                    tip = ResManager.loadKDString((String)"\u6570\u636e\u521d\u59cb\u5316\u5b8c\u6210\u3002", (String)"WorkflowProcessBatchSettingPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                    this.getView().showSuccessNotification(tip, Integer.valueOf(3000));
                    this.cacheInitResult();
                } else {
                    String failedMsg = result.getString("failedMessage");
                    tip = String.format(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u521d\u59cb\u5316\u5b8c\u6210\u3002\u6210\u529f\uff1a%1$s\uff0c\u5931\u8d25\uff1a%2$s\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a%3$s", (String)"WorkflowProcessBatchSettingPlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]), successed, failed, failedMsg);
                    this.getView().showMessage(tip);
                }
                this.getView().updateView("billlistap");
            }
        } else {
            this.log.debug("returnData is null!");
        }
    }

    private void cacheInitResult() {
        QFilter[] filters = new QFilter[]{new QFilter("key", "=", (Object)"workflow.initialize.batchSetting")};
        DynamicObject value = BusinessDataServiceHelper.loadSingle((String)"wf_confcenter", (String)"id,type,key,value", (QFilter[])filters);
        if (value == null) {
            value = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_confcenter"));
        }
        value.set("type", (Object)"dynamic");
        value.set("key", (Object)"workflow.initialize.batchSetting");
        value.set("value", (Object)"true");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{value});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!DesignerPluginUtil.checkWorkflowInService((IFormView)this.getView())) {
            return;
        }
        HyperLinkClickEvent evt = args.getHyperLinkClickEvent();
        if ("procdefid_key".equals(evt.getFieldName())) {
            this.openAdvancedPropSetting((Long)((IListView)this.getView()).getFocusRowPkId());
            args.setCancel(true);
        } else {
            super.billListHyperLinkClick(args);
        }
    }

    private void openAdvancedPropSetting(Long procInfoId) {
        WorkflowService wfService = this.getWorkflowService();
        String fields = String.format("%s,%s,%s", "procdefid", "schemeid", "processtype");
        ProcessInfoEntity processInfo = (ProcessInfoEntity)wfService.getRepositoryService().findEntityById(procInfoId, "wf_processinfo", fields);
        if (processInfo == null) {
            this.log.debug(String.format("ProcessInfo %s not exist.", procInfoId));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u3002", (String)"WorkflowProcessBatchSettingPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String ids = this.getPageCache().get(KEY_OPENED_IDS);
        Map<String, String> idsMap = ids != null ? (Map)SerializationUtils.fromJsonString((String)ids, Map.class) : new HashMap();
        String idStr = String.valueOf(processInfo.getProcdefId());
        String pageId = null;
        IFormView openedView = null;
        pageId = (String)idsMap.get(idStr);
        if (pageId != null && (openedView = this.getView().getView(pageId)) != null) {
            openedView.activate();
            this.getView().sendFormAction(openedView);
            return;
        }
        try {
            pageId = this.openAdvancedPropSettingPage(processInfo);
            idsMap.put(idStr, pageId);
            this.getPageCache().put(KEY_OPENED_IDS, SerializationUtils.toJsonString(idsMap));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u9ad8\u7ea7\u5c5e\u6027\u8bbe\u7f6e\u9875\u9762\u6253\u5f00\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowProcessBatchSettingPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage()));
            this.log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private String openAdvancedPropSettingPage(ProcessInfoEntity processInfo) {
        String modelType = GraphCodecUtils.getModelTypeByProcessType((String)processInfo.getProcessType());
        String schemeId = String.valueOf(processInfo.getSchemeId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setShowTitle(false);
        showParameter.setCaption(ResManager.loadKDString((String)"\u6d41\u7a0b\u6279\u91cf\u8bbe\u7f6e", (String)"WorkflowProcessBatchSettingPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        showParameter.setFormId("wf_advancedprop_setting");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getOpenStyle().setTargetKey("_submaintab_");
        showParameter.setCustomParam("model_type", (Object)modelType);
        showParameter.setCustomParam("config_scheme_id", (Object)schemeId);
        showParameter.setClientParam("config_scheme_id", (Object)schemeId);
        showParameter.setCustomParam("procDefId", (Object)processInfo.getProcdefId());
        IFormView parentView = DesignerModelUtil.getTabControlView((IFormView)this.getView());
        if (parentView != null) {
            parentView.showForm(showParameter);
            this.getView().sendFormAction(parentView);
        } else {
            this.getView().showForm(showParameter);
        }
        return showParameter.getPageId();
    }

    private WorkflowService getWorkflowService() {
        return (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(KEY_OPENED_IDS);
    }
}

