/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.workflow.bizflow.graph.handler.CardLinkManager;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.component.WorkflowDesigner;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.identity.User;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.util.BillSummaryType;
import kd.bos.workflow.engine.impl.util.ViewBizFlowChartUtil;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;

public class NodeBillInfoPlugin
extends AbstractWorkflowPlugin {
    private static final String USERICON = "usericon";
    private static final String VIEWBILLSUMMARY = "viewbillsummary";
    private static final String VIEWBILL = "viewbill";
    private static final String VIEWFLOWCHART = "viewflowchart";
    private static final String PANEL_VIEWFLOWCHART = "flexpanelap7";
    public static final String PROCINSTID = "procInstId";
    public static final String HISTORICACITIVITYID = "historicActivityInstanceId";
    public static final String ENTITYNUMBER = "entityNumber";
    public static final String BUSINESSKEY = "businessKey";
    public static final String OPENBYBILLCARD = "openByBillCard";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{VIEWBILLSUMMARY, VIEWFLOWCHART, VIEWBILL});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String procInstId = (String)showParameter.getCustomParam(PROCINSTID);
        String historicActivityInstanceId = (String)showParameter.getCustomParam(HISTORICACITIVITYID);
        String entityNumber = (String)showParameter.getCustomParam(ENTITYNUMBER);
        String businessKey = (String)showParameter.getCustomParam(BUSINESSKEY);
        boolean openByBillCard = Boolean.TRUE.equals(showParameter.getCustomParam(OPENBYBILLCARD));
        String billState = "";
        String billNo = "";
        Long creator = 0L;
        Long processInstanceId = 0L;
        if (WfUtils.isNotEmpty((String)procInstId)) {
            processInstanceId = Long.valueOf(procInstId);
        }
        if (WfUtils.isNotEmpty((String)historicActivityInstanceId)) {
            HistoricActivityInstanceEntity hiActInst = null;
            if (WfUtils.isNotEmpty((Long)processInstanceId)) {
                hiActInst = this.getHistoryService().getHistoricActivityByProcessInstanceIdAndActivityInstId(processInstanceId, Long.valueOf(historicActivityInstanceId));
            } else {
                hiActInst = this.getHistoryService().getHistoricActivityByBusinessKeyAndActivityInstId(businessKey, Long.valueOf(historicActivityInstanceId));
                if (hiActInst != null) {
                    processInstanceId = hiActInst.getProcessInstanceId();
                }
            }
            if (hiActInst != null) {
                String cellId;
                FlowElement flowElement;
                BpmnModel bpmnModel;
                String bizFlowBillSumary;
                billState = hiActInst.getEndTime() != null ? WFMultiLangConstants.getSSCStateName2() : WFMultiLangConstants.getSSCStateName1();
                if (WfUtils.isNotEmpty((String)hiActInst.getBusinessKey())) {
                    businessKey = hiActInst.getBusinessKey();
                }
                if (WfUtils.isNotEmpty((String)hiActInst.getEntityNumber())) {
                    entityNumber = hiActInst.getEntityNumber();
                }
                billNo = hiActInst.getBillNo();
                Long callProcInstanceId = this.getCallProcInstId(hiActInst);
                if (!openByBillCard && processInstanceId.equals(callProcInstanceId)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_VIEWFLOWCHART});
                }
                if (WfUtils.isEmpty((String)(bizFlowBillSumary = ViewFlowchartUtil.getBizFlowBillSummary((BpmnModel)(bpmnModel = this.getRepositoryService().getBpmnModel(null, processInstanceId)), (FlowElement)(flowElement = bpmnModel.getFlowElement(cellId = hiActInst.getActivityId())), (String)entityNumber))) || !this.notExistBizFlowBillSumamry(bizFlowBillSumary, entityNumber)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"billsummarypanel"});
                }
            }
        }
        if (businessKey != null && entityNumber != null) {
            String fields = "creator";
            String billNoField = null;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (entityType instanceof BillEntityType && WfUtils.isNotEmpty((String)(billNoField = ((BillEntityType)entityType).getBillNo()))) {
                fields = String.format("%s, %s", fields, billNoField);
            }
            DynamicObject billInfo = WfUtils.findBusinessObject((String)businessKey, (String)entityNumber, (String)fields);
            try {
                creator = billInfo.getLong("creator_id");
            }
            catch (Exception exception) {
                this.logger.debug("bill has no creator field..." + WfUtils.getExceptionStacktrace((Throwable)exception));
            }
            if (WfUtils.isNotEmpty((String)billNoField)) {
                try {
                    billNo = billInfo.getString(billNoField);
                }
                catch (Exception exception) {
                    this.logger.debug("bill has no billno field..." + WfUtils.getExceptionStacktrace((Throwable)exception));
                }
            }
            QFilter[] filters = new QFilter[]{new QFilter(BUSINESSKEY, "=", (Object)businessKey)};
            if (this.getRepositoryService().getEntityCountByFilter("wf_hiprocinst", filters) < 1L) {
                this.getView().setVisible(Boolean.FALSE, new String[]{PANEL_VIEWFLOWCHART});
            }
        }
        if (WfUtils.isEmpty((Long)creator) && WfUtils.isNotEmpty((Long)processInstanceId)) {
            HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)this.getRepositoryService().findEntityById(processInstanceId, "wf_hiprocinst", "startUserId");
            creator = historicProcessInstance.getStartUserId();
        }
        this.setUserInfo(entityNumber, creator);
        this.getModel().setValue("billState", (Object)billState);
        this.getModel().setValue("billno", (Object)billNo);
        if (openByBillCard) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billsummarypanel"});
        }
    }

    private boolean notExistBizFlowBillSumamry(String bizFlowBillSumary, String entityNumber) {
        QFilter qNumber = new QFilter("number", "=", (Object)bizFlowBillSumary);
        QFilter qEntityNumber = new QFilter("billtype", "=", (Object)entityNumber);
        QFilter qScene = new QFilter("scene", "=", (Object)BillSummaryType.flowchartSummary);
        QFilter[] qFilters = new QFilter[]{qNumber, qEntityNumber, qScene};
        return QueryServiceHelper.exists((String)"wf_mbillsummary_cfg", (QFilter[])qFilters);
    }

    private void setUserInfo(String entityNumber, long creator) {
        User userInfo = WfUtils.findUserById((long)creator);
        this.getView().setVisible(Boolean.TRUE, new String[]{USERICON});
        if (WfUtils.isNotEmpty((String)userInfo.getImgUrl())) {
            this.getModel().setValue(USERICON, (Object)userInfo.getImgUrl());
        } else {
            String contxtPath = UrlService.getDomainContextUrl();
            this.getModel().setValue(USERICON, (Object)(contxtPath + "/images/pc/emotion/default_person_82_82.png"));
        }
        String billName = this.getBillName(entityNumber, userInfo);
        this.getModel().setValue("billname", (Object)billName);
    }

    private String getBillName(String entityNumber, User userInfo) {
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String localeId = RequestContext.get().getLang().toString();
            String billName = WfMultiLangUtils.getValueFromLocalString((ILocaleString)entityType.getDisplayName(), (String)localeId);
            String creator = WfMultiLangUtils.getValueFromLocalString((ILocaleString)userInfo.getName(), (String)localeId);
            if (creator == null) {
                return billName;
            }
            String de = ResManager.loadKDString((String)"\u7684", (String)"WorkflowFloatLayerPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            return creator + de + billName;
        }
        catch (Exception e) {
            return "bill is not exist";
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (VIEWBILLSUMMARY.equals(key)) {
            this.viewBillSummary();
        } else if (VIEWFLOWCHART.equals(key)) {
            this.viewFloatChart();
        } else if (VIEWBILL.equals(key)) {
            this.viewBill();
        }
    }

    private void viewBill() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)showParameter.getCustomParam(ENTITYNUMBER);
        String businessKey = (String)showParameter.getCustomParam(BUSINESSKEY);
        String historicActivityInstanceId = (String)showParameter.getCustomParam(HISTORICACITIVITYID);
        String procInstId = (String)showParameter.getCustomParam(PROCINSTID);
        if (historicActivityInstanceId != null) {
            HistoricActivityInstanceEntity hiActInst = null;
            hiActInst = WfUtils.isNotEmpty((String)procInstId) ? this.getHistoryService().getHistoricActivityByProcessInstanceIdAndActivityInstId(Long.valueOf(procInstId), Long.valueOf(historicActivityInstanceId)) : this.getHistoryService().getHistoricActivityByBusinessKeyAndActivityInstId(businessKey, Long.valueOf(historicActivityInstanceId));
            entityNumber = hiActInst.getEntityNumber();
            businessKey = hiActInst.getBusinessKey();
        }
        if (this.billIsNotExist(businessKey, entityNumber)) {
            this.getView().showTipNotification(WFMultiLangConstants.getBillNotExistTip());
            return;
        }
        boolean hasParent = false;
        IFormView view = this.getView();
        if (view.getParentView() != null) {
            hasParent = true;
            view = view.getParentView();
        }
        new CardLinkManager().clickShowSingleBillLink(view, entityNumber, businessKey);
        if (hasParent) {
            this.getView().sendFormAction(view);
        }
    }

    private boolean billIsNotExist(String businessKey, String entityNumber) {
        try {
            BusinessDataServiceHelper.loadSingle((Object)businessKey, (String)entityNumber);
        }
        catch (Exception e) {
            return true;
        }
        return false;
    }

    private void viewFloatChart() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String procInstId = (String)showParameter.getCustomParam(PROCINSTID);
        String historicActivityInstanceId = (String)showParameter.getCustomParam(HISTORICACITIVITYID);
        boolean openByBillCard = Boolean.TRUE.equals(showParameter.getCustomParam(OPENBYBILLCARD));
        if (historicActivityInstanceId == null) {
            this.logger.debug("viewFloatChart: historicActivityInstanceId is null.");
            return;
        }
        Long processInstId = 0L;
        if (WfUtils.isNotEmpty((String)procInstId)) {
            processInstId = Long.valueOf(procInstId);
        } else {
            String businessKey = (String)showParameter.getCustomParam(BUSINESSKEY);
            HistoricActivityInstanceEntity hiActInst = this.getHistoryService().getHistoricActivityByBusinessKeyAndActivityInstId(businessKey, Long.valueOf(historicActivityInstanceId));
            processInstId = hiActInst.getProcessInstanceId();
            procInstId = String.valueOf(processInstId);
        }
        Long callProcInstanceId = ViewBizFlowChartUtil.getCallProcInstIdByHiActInstId((String)procInstId, (String)historicActivityInstanceId);
        if (!openByBillCard && processInstId != null && processInstId.equals(callProcInstanceId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6d41\u7a0b\u56fe\u5373\u4e3a\u9700\u8981\u67e5\u770b\u7684\u6d41\u7a0b\u56fe\u3002", (String)"NodeBillInfoPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String formId = "wf_viewflowchart";
        WorkflowDesigner designer = (WorkflowDesigner)this.getView().getParentView().getControl("workflowdesigner");
        designer.showChildProcessInfo(String.valueOf(callProcInstanceId), formId);
        this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"summaryandapproval"});
        this.getView().sendFormAction(this.getView().getParentView());
    }

    private Long getCallProcInstId(HistoricActivityInstanceEntity hiActInst) {
        Long callProcInstanceId = hiActInst.getProcessInstanceId();
        if (WfUtils.isNotEmpty((Long)hiActInst.getCalledProcessInstanceId())) {
            callProcInstanceId = hiActInst.getCalledProcessInstanceId();
        } else {
            String entityNumber = hiActInst.getEntityNumber();
            String businessKey = hiActInst.getBusinessKey();
            if (WfUtils.isEmpty((String)entityNumber) || WfUtils.isEmpty((String)businessKey)) {
                this.logger.debug(String.format("entityNumber or businessKey is empty! hisActInstId: %s, entityNumber: %s, businessKey: %s", hiActInst.getId(), entityNumber, businessKey));
                return callProcInstanceId;
            }
            List historicActivityInstanceEntities = this.getHistoryService().getHistoricActivityByBusinessKeyAndEntityNubmer(businessKey, entityNumber);
            for (HistoricActivityInstanceEntity historicActivityInstanceEntity : historicActivityInstanceEntities) {
                if (!WfUtils.isNotEmpty((Long)historicActivityInstanceEntity.getCalledProcessInstanceId())) continue;
                callProcInstanceId = historicActivityInstanceEntity.getCalledProcessInstanceId();
                break;
            }
        }
        return callProcInstanceId;
    }

    private void viewBillSummary() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String procInstId = (String)showParameter.getCustomParam(PROCINSTID);
        String historicActivityInstanceId = (String)showParameter.getCustomParam(HISTORICACITIVITYID);
        HistoricActivityInstanceEntity hiActInst = this.getHistoryService().getHistoricActivityByProcessInstanceIdAndActivityInstId(Long.valueOf(procInstId), Long.valueOf(historicActivityInstanceId));
        String entityNumber = hiActInst.getEntityNumber();
        String businessKey = hiActInst.getBusinessKey();
        if (this.billIsNotExist(businessKey, entityNumber)) {
            this.getView().showTipNotification(WFMultiLangConstants.getBillNotExistTip());
            return;
        }
        WorkflowDesigner designer = (WorkflowDesigner)this.getView().getParentView().getControl("workflowdesigner");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", "billSummary");
        data.put("time", System.currentTimeMillis());
        data.put(HISTORICACITIVITYID, historicActivityInstanceId);
        data.put(PROCINSTID, procInstId);
        designer.showBillSummaryInfo(data);
        this.getView().sendFormAction(this.getView().getParentView());
    }
}

