/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceType;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;

public class WorkflowExternalInterfacePlugin
extends AbstractWorkflowPlugin {
    private static final String DEFAULT_TYPE = "defaultType";
    private static final String FIELD_TYPE = "typefield";
    private static final String FIELD_PLUGIN = "pluginfield";
    private static final String FIELD_SCRIPT = "scriptfield";
    private static final String FIELD_OPERATION = "operationfield";
    private static final String FIELD_PLUGIN_PARAMS = "pluginparamsfield";
    private static final String SV_FIELD_PARAMETER = "sv_parameterfield";
    private static final String FIELD_MICROSERVICE = "microservice";
    private static final String PANEL_SUFFIX = "panel";
    private static final String PANEL_BUTTON = "btn_panel";
    private static final String BUTTON_CONFIRM = "confirmbtn";
    private static final String PARAMETERPANEL = "parameterpanel";
    private static final String ACTIONID_SCRIPT = "script";
    private static final String ACTIONID_KINGSCRIPT = "kingscript";
    private static final String ACTIONID_OPERATION = "operation";
    private static final String ACTIONID_PARAMETER = "parameter";
    private static final String GLANG_NAME = "glangname";
    public static final String ENTRY_BIZAPPID_NAME = "bizappid";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{BUTTON_CONFIRM});
        TextEdit script = (TextEdit)this.getControl(FIELD_SCRIPT);
        script.addButtonClickListener((ClickListener)this);
        TextEdit operation = (TextEdit)this.getControl(FIELD_OPERATION);
        operation.addButtonClickListener((ClickListener)this);
        TextEdit parameter = (TextEdit)this.getControl(SV_FIELD_PARAMETER);
        parameter.addButtonClickListener((ClickListener)this);
        this.assimilateParams();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        this.initPage(parameter);
        this.initData(parameter);
    }

    private void assimilateParams() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object context = parameter.getCustomParam("context");
        if (context instanceof Map) {
            Map extendData = (Map)context;
            if (extendData.get("nodeProperties") != null) {
                Map nodeProperties = (Map)extendData.get("nodeProperties");
                String entityId = (String)nodeProperties.get("service.entityId");
                if (WfUtils.isEmpty((String)entityId)) {
                    entityId = (String)nodeProperties.get("entityId");
                }
                if (WfUtils.isEmpty((String)entityId)) {
                    entityId = (String)nodeProperties.get("entraBillId");
                }
                parameter.setCustomParam("entityId", (Object)entityId);
            }
            parameter.setCustomParam("types", extendData.get("types"));
            parameter.setCustomParam("showButtonPanel", extendData.get("showButtonPanel"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("value", parameter.getCustomParam("value"));
            parameter.setCustomParam("data", map);
        }
    }

    private void initPage(FormShowParameter parameter) {
        String typesStr;
        Object showBtnPanel = parameter.getCustomParam("showButtonPanel");
        Object itfTypes = parameter.getCustomParam("types");
        if (showBtnPanel instanceof Boolean && ((Boolean)showBtnPanel).booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{PANEL_BUTTON});
        }
        if (WfUtils.isNotEmpty((String)(typesStr = itfTypes.toString()))) {
            String type;
            String[] types = typesStr.split(",");
            LinkedList<String> res = new LinkedList<String>();
            for (int i = 0; i < types.length; ++i) {
                type = types[i];
                if (ACTIONID_OPERATION.equals(type)) {
                    res.add(0, type);
                    continue;
                }
                res.add(type);
            }
            ComboEdit typeSelect = (ComboEdit)this.getControl(FIELD_TYPE);
            typeSelect.setComboItems(this.getTypeComboItems(res.toArray(new String[0])));
            type = typesStr.contains(ACTIONID_OPERATION) ? ACTIONID_OPERATION : types[0];
            this.getPageCache().put(DEFAULT_TYPE, type);
        }
    }

    private List<ComboItem> getTypeComboItems(String[] types) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(types.length);
        for (String type : types) {
            type = type.trim();
            items.add(new ComboItem(new LocaleString(ExternalInterfaceType.getTypeName((String)type)), type));
        }
        return items;
    }

    private void initData(FormShowParameter parameter) {
        Object data;
        block13: {
            String defType;
            block12: {
                data = null;
                defType = this.getPageCache().get(DEFAULT_TYPE);
                Map map = (Map)parameter.getCustomParam("data");
                if (map == null || map.isEmpty()) break block12;
                Object v = map.get("value");
                data = v;
                if (!WfUtils.isEmptyString(v)) break block13;
            }
            this.getModel().setValue(FIELD_TYPE, (Object)defType);
            this.switchType(defType, null);
            this.initMicroService();
            return;
        }
        IDataModel model = this.getModel();
        HashMap valMap = ExternalInterfaceUtil.castJSONToMap((Object)data);
        String type = (String)valMap.get("type");
        model.setValue(FIELD_TYPE, (Object)type);
        Object value = valMap.get("value");
        Object params = valMap.get("params");
        switch (type) {
            case "class": {
                this.setFieldValue(FIELD_PLUGIN, value);
                this.setFieldValue(FIELD_PLUGIN_PARAMS, params);
                this.setFieldValue(SV_FIELD_PARAMETER, this.getParameterShowText(params));
                break;
            }
            case "script": {
                this.setFieldValue(FIELD_SCRIPT, value);
                break;
            }
            case "operation": {
                this.setFieldValue(FIELD_OPERATION, value);
                break;
            }
        }
        this.switchType(type, null);
        this.initMicroService();
    }

    private void setFieldValue(String field, Object value) {
        String json = null;
        if (value instanceof String) {
            json = value.toString();
        } else if (value != null) {
            json = ExternalInterfaceUtil.castObjectToJSON((Object)value);
        }
        this.getModel().setValue(field, (Object)json);
    }

    public void click(EventObject evt) {
        String key;
        Control ctl = (Control)evt.getSource();
        switch (key = ctl.getKey().toLowerCase()) {
            case "confirmbtn": {
                this.confirm(this.getView());
                break;
            }
            case "scriptfield": {
                this.openScript();
                break;
            }
            case "operationfield": {
                this.openOperation();
                break;
            }
            case "sv_parameterfield": {
                this.openParameter();
                break;
            }
        }
    }

    private void openParameter() {
        FormShowParameter parameter = this.getShowParameter(ACTIONID_PARAMETER, "wf_extitf_parameter");
        String caption = null;
        if ("class".equals((String)this.getModel().getValue(FIELD_TYPE))) {
            parameter.setCustomParam("value", this.getModel().getValue(FIELD_PLUGIN_PARAMS));
            caption = ResManager.loadKDString((String)"\u63d2\u4ef6\u53c2\u6570", (String)"WorkflowExternalInterfacePlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        parameter.setCaption(caption);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        parameter.setCustomParam("entityId", (Object)entityId);
        this.getView().showForm(parameter);
    }

    private void openOperation() {
        FormShowParameter parameter = this.getShowParameter(ACTIONID_OPERATION, "wf_extitf_operation");
        parameter.setCustomParam("value", this.getModel().getValue(FIELD_OPERATION));
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        parameter.setCustomParam("entityId", (Object)entityId);
        Object operationSingle = this.getView().getFormShowParameter().getCustomParam("operationSingle");
        parameter.setCustomParam("operationSingle", operationSingle);
        parameter.setCustomParam("optionalActions", this.getView().getFormShowParameter().getCustomParam("optionalActions"));
        this.getView().showForm(parameter);
    }

    private void openScript() {
        this.openKingScript();
    }

    private void openJavaScript() {
        FormShowParameter parameter = this.getShowParameter(ACTIONID_SCRIPT, "wf_ext_interface_script");
        parameter.setCustomParam("value", this.getModel().getValue(FIELD_SCRIPT));
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        parameter.setCustomParam("entityId", (Object)entityId);
        this.getView().showForm(parameter);
    }

    public void openKingScript() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_script_manager");
        parameter.setCaption(ResManager.getLocaleString((String)"\u811a\u672c\u7f16\u8f91\u5668", (String)"WorkflowExternalInterfacePlugin_01", (String)"bos-wf-formplugin").getLocaleValue());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ACTIONID_KINGSCRIPT));
        parameter.setCustomParam("bizpagenumber", (Object)"wms_urchase_order_inh");
        parameter.setCustomParam("engineType", (Object)"1");
        parameter.setCustomParam("modelType", (Object)"WORKFLOW_PLUGIN_MODEL");
        parameter.setCustomParam("scripttypefilter", (Object)"workflow_plugin");
        parameter.setCustomParam("value", this.getModel().getValue(FIELD_SCRIPT));
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        parameter.setCustomParam("entityId", (Object)entityId);
        String appId = this.getBizAppIdByEntityId(entityId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            this.getView().showErrMessage(ResManager.getLocaleString((String)"\u5f53\u524d\u6d41\u7a0b\u7ed1\u5b9a\u5355\u636eappId\u67e5\u8be2\u4e3a\u7a7a", (String)"WorkflowExternalInterfacePlugin_10", (String)"bos-wf-formplugin").getLocaleValue(), "Error");
            return;
        }
        parameter.setCustomParam(ENTRY_BIZAPPID_NAME, (Object)appId);
        this.getView().showForm(parameter);
    }

    private String getBizAppIdByEntityId(String entityId) {
        if (WfUtils.isEmpty((String)entityId)) {
            return null;
        }
        DynamicObject dynObj = QueryServiceHelper.queryOne((String)"bos_devportal_unitrelform", (String)"bizapp", (QFilter[])new QFilter[]{new QFilter("form", "=", (Object)entityId)});
        if (null == dynObj) {
            return null;
        }
        return dynObj.getString("bizapp");
    }

    public String confirm(IFormView formView) {
        if (formView == null) {
            formView = this.getView();
        }
        String msg = this.validate();
        if (this.isEmbed()) {
            if (msg != null) {
                formView.showTipNotification(msg, Integer.valueOf(3000));
                return "";
            }
            return this.getValue();
        }
        if (msg != null) {
            formView.showTipNotification(msg, Integer.valueOf(3000));
        } else {
            formView.returnDataToParent((Object)this.getValue());
            formView.close();
        }
        return null;
    }

    private boolean isEmbed() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object showBtnPanel = parameter.getCustomParam("showButtonPanel");
        return !(showBtnPanel instanceof Boolean) || (Boolean)showBtnPanel == false;
    }

    private String validate() {
        IDataModel model = this.getModel();
        String type = (String)model.getValue(FIELD_TYPE);
        String msg = null;
        if (WfUtils.isEmpty((String)type)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5916\u90e8\u63a5\u53e3\u7c7b\u578b\u3002", (String)"WorkflowExternalInterfacePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        }
        switch (type) {
            case "class": {
                Object plugin = model.getValue(FIELD_PLUGIN);
                if (WfUtils.isEmptyString((Object)plugin)) {
                    msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u63d2\u4ef6\u7c7b\u201d\u3002", (String)"WorkflowExternalInterfacePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                    break;
                }
                if (this.pathMatch(plugin.toString())) break;
                msg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u63d2\u4ef6\u7c7b\u201d\u3002", (String)"WorkflowExternalInterfacePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                break;
            }
            case "script": {
                if (!WfUtils.isEmptyString((Object)model.getValue(FIELD_SCRIPT))) break;
                msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u811a\u672c\u201d\u3002", (String)"WorkflowExternalInterfacePlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                break;
            }
            case "operation": {
                if (!WfUtils.isEmptyString((Object)model.getValue(FIELD_OPERATION))) break;
                msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u64cd\u4f5c\u201d\u3002", (String)"WorkflowExternalInterfacePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        return msg;
    }

    private boolean pathMatch(String input) {
        String[] strs;
        if (input.matches("[\\w\\.]+\\.+$")) {
            return false;
        }
        String regex = "^[a-zA-Z_][a-zA-Z0-9_]*$";
        for (String str : strs = input.split("\\.")) {
            if (str.matches(regex)) continue;
            return false;
        }
        return true;
    }

    private String getValue() {
        IDataModel model = this.getModel();
        String type = (String)model.getValue(FIELD_TYPE);
        String value = null;
        switch (type) {
            case "class": {
                String pluginValue = (String)model.getValue(FIELD_PLUGIN);
                String paramsValue = (String)model.getValue(FIELD_PLUGIN_PARAMS);
                if (WfUtils.isEmpty((String)paramsValue)) {
                    value = ExternalInterfaceUtil.getFormattedPluginValue((String)type, (Boolean)((Boolean)model.getValue(FIELD_MICROSERVICE)), (String)pluginValue);
                    break;
                }
                value = ExternalInterfaceUtil.getFormattedPluginValueWithParams((String)type, (Boolean)((Boolean)model.getValue(FIELD_MICROSERVICE)), (String)pluginValue, (String)paramsValue);
                break;
            }
            case "script": {
                value = ExternalInterfaceUtil.getFormattedValue((String)type, (String)((String)model.getValue(FIELD_SCRIPT)));
                break;
            }
            case "operation": {
                value = ExternalInterfaceUtil.getFormattedValue((String)type, (String)((String)model.getValue(FIELD_OPERATION)));
                break;
            }
        }
        return value;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeSet = e.getChangeSet();
        ChangeData changeData = changeSet[0];
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (FIELD_TYPE.equals(propName)) {
            this.switchType((String)newValue, (String)oldValue);
        } else if (SV_FIELD_PARAMETER.equals(propName) && "".equals(newValue)) {
            this.getModel().setValue(FIELD_PLUGIN_PARAMS, null);
        }
    }

    private void switchType(String newType, String oldType) {
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{this.getTypePanel(oldType)});
        view.setVisible(Boolean.TRUE, new String[]{this.getTypePanel(newType)});
        if ("class".equals(newType) && !this.hideParameterConfig(view)) {
            TextEdit parameterfield = (TextEdit)this.getControl(SV_FIELD_PARAMETER);
            parameterfield.setCaption(this.getLocaleCaption(newType));
            view.setVisible(Boolean.TRUE, new String[]{PARAMETERPANEL});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{PARAMETERPANEL});
        }
    }

    private boolean hideParameterConfig(IFormView view) {
        Object isHideParameterConfig = view.getFormShowParameter().getCustomParam("hideParameterConfig");
        return isHideParameterConfig instanceof Boolean && (Boolean)isHideParameterConfig != false;
    }

    private LocaleString getLocaleCaption(String newType) {
        LocaleString caption = null;
        if ("class".equals(newType)) {
            caption = new LocaleString(ResManager.loadKDString((String)"\u63d2\u4ef6\u53c2\u6570\uff1a", (String)"WorkflowExternalInterfacePlugin_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        return caption;
    }

    private void initMicroService() {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && "wf_validationplugin".equals(parentView.getFormShowParameter().getFormId())) {
            this.getModel().setValue(FIELD_MICROSERVICE, (Object)true);
        }
    }

    private String getTypePanel(String type) {
        if (WfUtils.isEmpty((String)type)) {
            type = "class";
        }
        return String.format("%s%s", type, PANEL_SUFFIX);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (ACTIONID_SCRIPT.equals(actionId)) {
            this.getModel().setValue(FIELD_SCRIPT, returnData);
        } else if (ACTIONID_OPERATION.equals(actionId)) {
            this.getModel().setValue(FIELD_OPERATION, returnData);
        } else if (ACTIONID_PARAMETER.equals(actionId)) {
            String params = returnData instanceof JSONArray ? ((JSONArray)returnData).toJSONString() : "";
            this.getModel().setValue(FIELD_PLUGIN_PARAMS, (Object)params);
            this.getModel().setValue(SV_FIELD_PARAMETER, (Object)this.getParameterShowText(returnData));
        } else if (ACTIONID_KINGSCRIPT.equals(actionId)) {
            String jsonStr = JSONObject.toJSONString((Object)returnData);
            if (JSONObject.parseObject((String)jsonStr).isEmpty()) {
                this.getModel().setValue(FIELD_SCRIPT, null);
            } else {
                this.getModel().setValue(FIELD_SCRIPT, (Object)JSONObject.parseObject((String)jsonStr));
            }
        }
    }

    private String getParameterShowText(Object returnData) {
        List paramsList;
        String lang = RequestContext.get().getLang().toString();
        StringBuilder showTextStr = new StringBuilder();
        if (returnData instanceof JSONArray) {
            JSONArray params = (JSONArray)returnData;
            if (params == null || params.isEmpty()) {
                return "";
            }
            int size = params.size();
            for (int i = 0; i < size; ++i) {
                JSONObject param = params.getJSONObject(i);
                ILocaleString localeName = (ILocaleString)param.get((Object)"name");
                showTextStr.append(localeName.get((Object)lang) != null ? localeName.get((Object)lang) : param.get((Object)GLANG_NAME));
                if (i >= size - 1) continue;
                showTextStr.append(",");
            }
            return "".equals(showTextStr.toString()) ? null : showTextStr.toString();
        }
        if (returnData instanceof List && WfUtils.isNotEmptyForCollection((Collection)(paramsList = (List)returnData))) {
            int size = paramsList.size();
            for (int i = 0; i < size; ++i) {
                Object object = paramsList.get(i);
                if (!(object instanceof Map)) continue;
                Map localeName = (Map)((Map)object).get("name");
                showTextStr.append(localeName.get(lang) != null ? localeName.get(lang) : ((Map)object).get(GLANG_NAME));
                if (i >= size - 1) continue;
                showTextStr.append(",");
            }
            return showTextStr.toString();
        }
        return null;
    }

    public void reset() {
        IDataModel model = this.getModel();
        model.setValue(FIELD_PLUGIN, null);
        model.setValue(FIELD_SCRIPT, null);
        model.setValue(FIELD_OPERATION, null);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(DEFAULT_TYPE);
    }
}

