/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.design.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BOSRuntime;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.plugin.Plugin;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.bos.workflow.engine.WfUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class WorkflowExternalKingScriptPlugin
extends AbstractBillPlugIn {
    private static Logger log = Logger.getLogger(WorkflowExternalKingScriptPlugin.class);
    private static final String SCRIPT_SOURCE = "scriptSource";
    private static final String ENTRY_KEY = "entry_script";
    private static final String REGISTER_KINGSCRIPT = "register_kingscript";
    private static final String BTN_REGISTER_KDE = "btn_register_kde";
    private static final String BTN_REGISTER_KINGSCRIPT = "btn_register_kingscript";
    private static final String BTN_SELECT_KINGSCRIPT = "btn_select_kingscript";
    private static final String BTN_EDIT = "btn_edit_script";
    private static final String BTN_DELETE = "btn_delete_script";
    private static final String CALLBACK_EDIT_KDE = "CALLBACK_EDIT_KDE";
    private static final String CALLBACK_EDIT_kINGSCRIPT = "CALLBACK_EDIT_kINGSCRIPT";
    public static final String PLUGIN_CLASS_NAME = "ClassName";
    public static final String PLUGIN_ENABLE_NAME = "Enabled";
    public static final String PLUGIN_DESCRIPTION_NAME = "Description";
    public static final String PLUGIN_DISPLAYNAME_NAME = "DisplayName";
    public static final String PLUGIN_TYPE_NAME = "Type";
    public static final String PLUGIN_FPK_NAME = "FPK";
    public static final String PLUGIN_BIZAPPID_NAME = "BizAppId";
    public static final String PLUGIN_ISINHERIT = "Inherit";
    private static final String KDE_NUMBER = "number";
    private static final String KDE_ID = "id";
    private static final String KDE_DESC = "desc";
    private static final String ENTRY_SCRIPT_ID = "id";
    private static final String ENTRY_SCRIPT_TYPE = "script_type";
    private static final String ENTRY_SCRIPT_PATH = "number";
    private static final String ENTRY_SCRIPT_NAME = "script_name";
    private static final String ENTRY_SCRIPT_DESC = "desc";
    private static final String ENTRY_SCRIPT_ENABLED = "script_enabled";
    private static final String ENTRY_SCRIPT_DETAIL = "script_detail";
    private static final String SCRIPT_TYPE_KDE = "KDE";
    private static final String SCRIPT_TYPE_KINGSCRIPT = "KingScript";
    private static final String BOS_WF_FORMPLUGIN = "bos-wf-formplugin";
    private static final String FORM_SHOW_PARAMETER_VALUE = "value";
    private static final String ENTRY_BIZAPPID_NAME = "bizappid";
    private static Set<String> bampMoveAppList = new HashSet<String>(7);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        int rowCount = this.getModel().getEntryRowCount(ENTRY_KEY);
        for (int row = 0; row < rowCount; ++row) {
            this.getModel().deleteEntryRow(ENTRY_KEY, 0);
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String oldScriptData = (String)formShowParameter.getCustomParam(FORM_SHOW_PARAMETER_VALUE);
        JSONObject selectScriptJson = new JSONObject();
        String scriptSource = null;
        String selectScriptType = null;
        if (StringUtils.isNotBlank((String)oldScriptData)) {
            selectScriptJson = JSONObject.parseObject((String)oldScriptData);
            scriptSource = selectScriptJson.getString(SCRIPT_SOURCE);
            selectScriptType = selectScriptJson.getString(ENTRY_SCRIPT_TYPE);
        }
        if (StringUtils.isBlank(scriptSource)) {
            if (selectScriptJson.isEmpty()) {
                return;
            }
            if (StringUtils.isBlank(selectScriptType)) {
                selectScriptJson.put(ENTRY_SCRIPT_ENABLED, (Object)true);
                selectScriptJson.put(ENTRY_SCRIPT_TYPE, (Object)SCRIPT_TYPE_KDE);
                selectScriptJson.put(ENTRY_SCRIPT_DETAIL, (Object)selectScriptJson.toJSONString());
            }
            int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
            this.buildRowData(selectScriptJson, rowIndex);
        } else {
            JSONArray scriptJsonArr = JSONObject.parseArray(scriptSource);
            for (Object scriptData : scriptJsonArr) {
                JSONObject dataJson = JSONObject.parseObject((String)scriptData.toString());
                dataJson.put(ENTRY_SCRIPT_DETAIL, (Object)dataJson.toJSONString());
                int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
                this.buildRowData(dataJson, rowIndex);
            }
        }
        if (!selectScriptJson.isEmpty()) {
            this.scriptEnable(selectScriptJson);
        } else {
            this.scriptEnable(new JSONObject());
        }
    }

    private void scriptEnable(JSONObject data) {
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
        if (null == doc || doc.size() <= 0) {
            this.getView().returnDataToParent(null);
            this.getView().close();
            return;
        }
        for (int i = 0; i < doc.size(); ++i) {
            DynamicObject plugin = (DynamicObject)doc.get(i);
            String currentRowPath = data.getString("number");
            String scriptPathRow = plugin.getString("number");
            if (StringUtils.isNotBlank((String)currentRowPath) && StringUtils.isNotBlank((String)scriptPathRow) && scriptPathRow.equals(currentRowPath)) {
                this.changeDataWithEabled(plugin, i, true);
                continue;
            }
            String scriptEabled = plugin.getString(ENTRY_SCRIPT_ENABLED);
            if (!StringUtils.isNotBlank((String)scriptEabled) || !"true".equals(scriptEabled)) continue;
            this.changeDataWithEabled(plugin, i, false);
        }
    }

    private void changeDataWithEabled(DynamicObject plugin, int index, boolean enabled) {
        this.getModel().setValue(ENTRY_SCRIPT_ENABLED, (Object)enabled, index);
        String scriptDetail = plugin.getString(ENTRY_SCRIPT_DETAIL);
        JSONObject scriptDetailJson = JSONObject.parseObject((String)scriptDetail);
        scriptDetailJson.put(ENTRY_SCRIPT_ENABLED, (Object)enabled);
        this.getModel().setValue(ENTRY_SCRIPT_DETAIL, (Object)JSONObject.toJSONString((Object)scriptDetailJson), index);
    }

    private void buildRowData(JSONObject data, String scritpType) {
        JSONObject wfScriptJson = new JSONObject();
        if (SCRIPT_TYPE_KDE.equals(scritpType)) {
            wfScriptJson = this.convertWFScriptWithKDE(data);
        } else if (SCRIPT_TYPE_KINGSCRIPT.equals(scritpType)) {
            wfScriptJson = this.convertWFScriptWithKingScript(data);
        }
        int rowIndex = this.getModel().createNewEntryRow(ENTRY_KEY);
        this.buildRowData(wfScriptJson, rowIndex);
    }

    private JSONObject convertWFScriptWithKDE(JSONObject kdeJson) {
        JSONObject wfScriptJson = new JSONObject();
        wfScriptJson.put("id", (Object)(kdeJson.getString("id") == null ? "" : kdeJson.getString("id")));
        wfScriptJson.put("number", (Object)(kdeJson.getString("number") == null ? "" : kdeJson.getString("number")));
        wfScriptJson.put("desc", (Object)(kdeJson.getString("desc") == null ? "" : kdeJson.getString("desc")));
        wfScriptJson.put(ENTRY_SCRIPT_TYPE, (Object)SCRIPT_TYPE_KDE);
        wfScriptJson.put(ENTRY_SCRIPT_NAME, (Object)"");
        wfScriptJson.put(ENTRY_SCRIPT_ENABLED, (Object)false);
        wfScriptJson.put(ENTRY_SCRIPT_DETAIL, (Object)wfScriptJson.toJSONString());
        return wfScriptJson;
    }

    private JSONObject convertWFScriptWithKingScript(JSONObject kingScriptJson) {
        JSONObject wfScriptJson = new JSONObject();
        wfScriptJson.put("id", (Object)(kingScriptJson.getString(PLUGIN_FPK_NAME) == null ? "" : kingScriptJson.getString(PLUGIN_FPK_NAME)));
        wfScriptJson.put("number", (Object)(kingScriptJson.getString(PLUGIN_CLASS_NAME) == null ? "" : kingScriptJson.getString(PLUGIN_CLASS_NAME)));
        wfScriptJson.put("desc", (Object)(kingScriptJson.getString(PLUGIN_DESCRIPTION_NAME) == null ? "" : kingScriptJson.getString(PLUGIN_DESCRIPTION_NAME)));
        wfScriptJson.put(ENTRY_SCRIPT_TYPE, (Object)SCRIPT_TYPE_KINGSCRIPT);
        wfScriptJson.put(ENTRY_SCRIPT_NAME, (Object)(kingScriptJson.getString(PLUGIN_DISPLAYNAME_NAME) == null ? "" : kingScriptJson.getString(PLUGIN_DISPLAYNAME_NAME)));
        wfScriptJson.put(ENTRY_SCRIPT_ENABLED, (Object)false);
        wfScriptJson.put(ENTRY_SCRIPT_DETAIL, (Object)wfScriptJson.toJSONString());
        return wfScriptJson;
    }

    private void buildRowData(JSONObject data, int rowIndex) {
        this.getModel().setValue("id", (Object)data.getString("id"), rowIndex);
        this.getModel().setValue(ENTRY_SCRIPT_TYPE, (Object)data.getString(ENTRY_SCRIPT_TYPE), rowIndex);
        this.getModel().setValue("number", (Object)data.getString("number"), rowIndex);
        this.getModel().setValue(ENTRY_SCRIPT_NAME, (Object)data.getString(ENTRY_SCRIPT_NAME), rowIndex);
        this.getModel().setValue("desc", (Object)data.getString("desc"), rowIndex);
        this.getModel().setValue(ENTRY_SCRIPT_ENABLED, (Object)data.getString(ENTRY_SCRIPT_ENABLED), rowIndex);
        this.getModel().setValue(ENTRY_SCRIPT_DETAIL, (Object)data.getString(ENTRY_SCRIPT_DETAIL), rowIndex);
    }

    private Map<String, Object> convertEditObject(JSONObject dataJson) {
        HashMap<String, Object> plugin = new HashMap<String, Object>();
        plugin.put(PLUGIN_FPK_NAME, dataJson.getString("id"));
        plugin.put(PLUGIN_CLASS_NAME, dataJson.getString("number"));
        plugin.put(PLUGIN_DESCRIPTION_NAME, dataJson.getString("desc"));
        plugin.put(PLUGIN_DISPLAYNAME_NAME, dataJson.getString(ENTRY_SCRIPT_NAME));
        plugin.put(PLUGIN_ENABLE_NAME, dataJson.getString(ENTRY_SCRIPT_ENABLED));
        return plugin;
    }

    private Map<String, Object> convertEditObject(DynamicObject kde) {
        HashMap<String, Object> plugin = new HashMap<String, Object>();
        plugin.put(PLUGIN_CLASS_NAME, kde.getString("number"));
        plugin.put(PLUGIN_DESCRIPTION_NAME, kde.getString("desc"));
        plugin.put(PLUGIN_FPK_NAME, kde.getString("id"));
        plugin.put(PLUGIN_ENABLE_NAME, kde.getString(ENTRY_SCRIPT_ENABLED));
        return plugin;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Plugin.enableRegisterKingScript((String)"WORKFLOW_PLUGIN_MODEL")) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{REGISTER_KINGSCRIPT});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_REGISTER_KDE});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{REGISTER_KINGSCRIPT});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BTN_REGISTER_KDE});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btncancel", "btnok"});
        this.addItemClickListeners(new String[]{"btn_container_script"});
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "btncancel": {
                break;
            }
            case "btnok": {
                this.clickBtnOk();
                break;
            }
        }
    }

    private void clickBtnOk() {
        JSONObject returnDataJson = new JSONObject();
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
        if (null == doc || doc.size() <= 0) {
            this.getView().returnDataToParent((Object)returnDataJson);
            this.getView().close();
            return;
        }
        JSONObject selectScript = null;
        ArrayList<String> allPlugin = new ArrayList<String>();
        for (DynamicObject plugin : doc) {
            allPlugin.add(plugin.getString(ENTRY_SCRIPT_DETAIL));
            String scriptEnabled = plugin.getString(ENTRY_SCRIPT_ENABLED);
            if (!StringUtils.isNotBlank((String)scriptEnabled) || !"true".equals(scriptEnabled)) continue;
            selectScript = JSONObject.parseObject((String)plugin.getString(ENTRY_SCRIPT_DETAIL));
        }
        if (null == selectScript) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u542f\u7528\u7684\u811a\u672c\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u811a\u672c\u542f\u7528\u3002", (String)"WFScriptManagerPlugin_04", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        returnDataJson.put(SCRIPT_SOURCE, allPlugin);
        returnDataJson.putAll(selectScript);
        this.getView().returnDataToParent((Object)returnDataJson);
        this.getView().close();
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (BTN_REGISTER_KDE.equalsIgnoreCase(key)) {
            this.openRegisterKDEPage();
        } else if (BTN_REGISTER_KINGSCRIPT.equalsIgnoreCase(key)) {
            this.openRegisterKingScriptPage();
        } else if (BTN_SELECT_KINGSCRIPT.equalsIgnoreCase(key)) {
            this.openSelectKingScriptPage();
        } else if (BTN_EDIT.equalsIgnoreCase(key)) {
            this.editScript();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String propName = property.getName();
        ChangeData[] changeData = e.getChangeSet();
        if (null == changeData || changeData.length <= 0) {
            return;
        }
        Object newValue = changeData[0].getNewValue();
        if (ENTRY_SCRIPT_ENABLED.equals(propName)) {
            if (null != newValue && "true".equals(newValue.toString())) {
                DynamicObject dataEntity = changeData[0].getDataEntity();
                String scriptDetail = dataEntity.getString(ENTRY_SCRIPT_DETAIL);
                JSONObject scriptDetailJson = JSONObject.parseObject((String)scriptDetail);
                this.scriptEnable(scriptDetailJson);
            } else {
                DynamicObject dataEntity = changeData[0].getDataEntity();
                this.changeDataWithEabled(dataEntity, changeData[0].getRowIndex(), false);
            }
        }
    }

    private void editScript() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int[] selectedRows = grid.getEntryState().getSelectedRows();
        if (null == selectedRows || selectedRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"WFScriptManagerPlugin_00", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        if (selectedRows.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6570\u636e\u8d85\u8fc71\u6761\u3002", (String)"WFScriptManagerPlugin_01", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
        DynamicObject selectData = (DynamicObject)doc.get(selectedRows[0]);
        String scriptType = selectData.getString(ENTRY_SCRIPT_TYPE);
        if (SCRIPT_TYPE_KINGSCRIPT.equals(scriptType)) {
            this.openEditKingScript(selectData);
        } else if (SCRIPT_TYPE_KDE.equals(scriptType)) {
            this.openEditKDE(selectData);
        }
    }

    private void openEditKDE(DynamicObject plugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_edit_ks_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("isEdit", (Object)"isEdit");
        Map<String, Object> pluginMap = this.convertEditObject(plugin);
        parameter.setCustomParam("plugin", pluginMap);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        String formnumber = EntityMetadataCache.getDataEntityTypeById((String)entityId).getName();
        parameter.setCustomParam("formnumber", (Object)formnumber);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_EDIT_KDE));
        this.getView().showForm(parameter);
    }

    private void openEditKingScript(DynamicObject plugin) {
        if (!Plugin.enableRunKingScript()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u5f00\u53d1\u5e73\u53f0\u672a\u542f\u7528\uff0c\u6682\u4e0d\u652f\u6301\u7f16\u8f91\u3002", (String)"WFScriptManagerPlugin_02", (String)BOS_WF_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_register_ts_plugin");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("isEdit", (Object)"isEdit");
        Map<String, Object> pluginMap = this.convertEditObject(JSONObject.parseObject((String)plugin.getString(ENTRY_SCRIPT_DETAIL)));
        parameter.setCustomParam("plugin", pluginMap);
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        String formnumber = EntityMetadataCache.getDataEntityTypeById((String)entityId).getName();
        parameter.setCustomParam("formnumber", (Object)formnumber);
        FormShowParameter localParameter = this.getView().getFormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.NewWindow);
        parameter.setCustomParam("id", (Object)plugin.getString("id"));
        parameter.setCustomParam("bizpagenumber", (Object)formnumber);
        parameter.setCustomParam("bizPageId", (Object)this.getView().getFormShowParameter().getParentPageId());
        parameter.setCustomParam("scripttypefilter", localParameter.getCustomParam("scripttypefilter"));
        String serviceAppid = WorkflowExternalKingScriptPlugin.getTSEditerServiceAppid((String)parameter.getCustomParam(ENTRY_BIZAPPID_NAME), (String)parameter.getCustomParam("bizpagenumber"));
        parameter.setCustomParam("ServiceAppId", (Object)serviceAppid);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_EDIT_kINGSCRIPT));
        this.getView().showForm(parameter);
    }

    public void openSelectKingScriptPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("ide_register_ks_plugin");
        parameter.setCaption(ResManager.getLocaleString((String)"\u9009\u62e9\u811a\u672c", (String)"WFScriptManagerPlugin_03", (String)BOS_WF_FORMPLUGIN).getLocaleValue());
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_SELECT_KINGSCRIPT));
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        String formnumber = EntityMetadataCache.getDataEntityTypeById((String)entityId).getName();
        parameter.setCustomParam("bizpagenumber", (Object)formnumber);
        parameter.setCustomParam("engineType", (Object)"1");
        parameter.setCustomParam("modelType", (Object)"WORKFLOW_PLUGIN_MODEL");
        parameter.setCustomParam("scripttypefilter", (Object)"workflow_plugin");
        parameter.setCustomParam("loadExtendAppIds", (Object)"true");
        parameter.setCustomParam(ENTRY_BIZAPPID_NAME, this.getView().getFormShowParameter().getCustomParam(ENTRY_BIZAPPID_NAME));
        ArrayList value = new ArrayList(1);
        parameter.setCustomParam(FORM_SHOW_PARAMETER_VALUE, (Object)SerializationUtils.toJsonString(value));
        this.getView().showForm(parameter);
    }

    public void openRegisterKingScriptPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setShowTitle(false);
        parameter.setShowClose(false);
        parameter.setFormId("ide_register_kingscript");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_REGISTER_KINGSCRIPT));
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        String formnumber = EntityMetadataCache.getDataEntityTypeById((String)entityId).getName();
        parameter.setCustomParam("bizpagenumber", (Object)formnumber);
        parameter.setCustomParam("modelType", (Object)"WORKFLOW_PLUGIN_MODEL");
        parameter.setCustomParam("scripttypefilter", (Object)"workflow_plugin");
        parameter.setCustomParam(ENTRY_BIZAPPID_NAME, this.getView().getFormShowParameter().getCustomParam(ENTRY_BIZAPPID_NAME));
        this.getView().showForm(parameter);
    }

    private void openRegisterKDEPage() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_ext_interface_script");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_REGISTER_KDE));
        ArrayList value = new ArrayList();
        parameter.setCustomParam(FORM_SHOW_PARAMETER_VALUE, (Object)SerializationUtils.toJsonString(value));
        String entityId = (String)this.getView().getFormShowParameter().getCustomParam("entityId");
        parameter.setCustomParam("entityId", (Object)entityId);
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if (BTN_REGISTER_KDE.equals(actionId)) {
            this.callBackWithBtnRegisterKDE(evt);
        } else if (BTN_REGISTER_KINGSCRIPT.equals(actionId)) {
            this.callBackWithBtnRegisterKingScript(evt);
        } else if (BTN_SELECT_KINGSCRIPT.equals(actionId)) {
            this.callBackWithBtnSeclectKingScript(evt);
        } else if (CALLBACK_EDIT_KDE.equals(actionId)) {
            this.callBackWithBtnEditKDE(evt);
        }
    }

    private void callBackWithBtnEditKDE(ClosedCallBackEvent evt) {
        JSONObject dataJson = JSONObject.parseObject((String)evt.getReturnData().toString());
        String scriptEabled = dataJson.getString(PLUGIN_ENABLE_NAME);
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_KEY);
        int[] selectedRows = grid.getEntryState().getSelectedRows();
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
        DynamicObject selectData = (DynamicObject)doc.get(selectedRows[0]);
        String scriptDetail = selectData.getString(ENTRY_SCRIPT_DETAIL);
        JSONObject scriptDetailJson = JSONObject.parseObject((String)scriptDetail);
        scriptDetailJson.put("desc", (Object)dataJson.getString(PLUGIN_DESCRIPTION_NAME));
        scriptDetailJson.put(ENTRY_SCRIPT_ENABLED, (Object)scriptEabled);
        this.getModel().setValue("desc", (Object)dataJson.getString(PLUGIN_DESCRIPTION_NAME));
        this.getModel().setValue(ENTRY_SCRIPT_ENABLED, (Object)scriptEabled);
        this.getModel().setValue(ENTRY_SCRIPT_DETAIL, (Object)scriptDetailJson);
        if (StringUtils.isNotBlank((String)scriptEabled) && "true".equals(scriptEabled)) {
            this.scriptEnable(scriptDetailJson);
        }
    }

    private void callBackWithBtnRegisterKDE(ClosedCallBackEvent evt) {
        if (null == evt.getReturnData() || StringUtils.isBlank((String)evt.getReturnData().toString())) {
            return;
        }
        JSONObject dataJson = JSONObject.parseObject((String)evt.getReturnData().toString());
        String kdeNumber = dataJson.getString("number");
        List<String> scriptSourceList = this.getScriptSourceData();
        if (StringUtils.isNotBlank((String)kdeNumber) && scriptSourceList.contains(kdeNumber)) {
            return;
        }
        this.buildRowData(dataJson, SCRIPT_TYPE_KDE);
    }

    private void callBackWithBtnRegisterKingScript(ClosedCallBackEvent evt) {
        JSONObject dataJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)evt.getReturnData()));
        this.buildRowData(dataJson, SCRIPT_TYPE_KINGSCRIPT);
    }

    private void callBackWithBtnSeclectKingScript(ClosedCallBackEvent evt) {
        List pluginList = (List)evt.getReturnData();
        if (CollectionUtils.isEmpty((Collection)pluginList)) {
            return;
        }
        List<String> scriptSourceList = this.getScriptSourceData();
        int i = 0;
        for (Map plugin : pluginList) {
            JSONObject dataJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)plugin));
            String className = dataJson.getString(PLUGIN_CLASS_NAME);
            if (StringUtils.isNotBlank((String)className) && scriptSourceList.contains(className)) continue;
            this.buildRowData(dataJson, SCRIPT_TYPE_KINGSCRIPT);
            ++i;
        }
    }

    private List<String> getScriptSourceData() {
        ArrayList<String> scriptPathList = new ArrayList<String>();
        DynamicObjectCollection doc = this.getModel().getEntryEntity(ENTRY_KEY);
        for (DynamicObject plugin : doc) {
            scriptPathList.add(plugin.getString("number"));
        }
        return scriptPathList;
    }

    public static String getTSEditerServiceAppid(String bizappid, String bizpagenumber) {
        DynamicObject bizapp;
        String originBizapp;
        if (WfUtils.isEmpty((String)bizappid)) {
            if (WfUtils.isEmpty((String)bizpagenumber)) {
                return null;
            }
            QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)bizpagenumber)};
            DynamicObject form = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"id,number,isv,bizappid,modeltype", (QFilter[])qFilters);
            if (form == null) {
                return null;
            }
            bizappid = form.getString(ENTRY_BIZAPPID_NAME);
        }
        if (WfUtils.isEmpty((String)(originBizapp = (bizapp = BusinessDataServiceHelper.loadSingleFromCache((Object)bizappid, (String)"bos_devportal_bizapp", (String)"masterid")).getString("masterid")))) {
            originBizapp = bizappid;
        }
        String appNumber = null;
        try {
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)originBizapp);
            if (null == appInfo) {
                return appNumber;
            }
            if (BOSRuntime.isBOSCloud((String)appInfo.getCloudId()) || WorkflowExternalKingScriptPlugin.isBAMPMoveApp(appInfo.getNumber())) {
                return "bos";
            }
            appNumber = appInfo.getNumber();
        }
        catch (Exception e) {
            log.warn((Object)"exception:", (Throwable)e);
        }
        return appNumber;
    }

    private static boolean isBAMPMoveApp(String bizappId) {
        return bampMoveAppList.contains(bizappId);
    }

    static {
        bampMoveAppList.add("base");
        bampMoveAppList.add("cts");
        bampMoveAppList.add("secm");
        bampMoveAppList.add("customize");
        bampMoveAppList.add("open");
        bampMoveAppList.add("sbd");
        bampMoveAppList.add("mpdm");
        bampMoveAppList.add("gmc");
    }
}

