/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.BillTypeField;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.businessfield.RefBillField;
import kd.bos.metadata.entity.businessfield.UserAvatarField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.GeoPointField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.workflow.design.util.BillSummaryUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.BillSummaryType;
import kd.bos.workflow.management.plugin.WFBillSummaryUtil;

public class WFBillSummaryConfigFieldPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener {
    private static final String REF_PARENT_PROP_FIELD_ID = "refparentpropfieldid";
    private static final String FIELDTREE = "fieldtree";
    private static final String FTID = "ftid";
    private static final String CONFIG_FIELDS = "configFields";
    private static final String FTARGETPROPS = "ftargetprops";
    private static final String BTNOK = "btnok";
    private static final String BTNREMOVE = "btnremove";
    private static final String TREEROOTNODE = "treerootnode";
    private static final String FIELDID = "fieldid";
    private static final String FTNAME = "ftname";
    private static final String FIELDNAME = "fieldname";
    private static final String FIELDFULLNAME = "fieldfullname";
    private static final String FIELDKEY = "fieldkey";
    private static final String FIELDTYPE = "fieldtype";
    private static final String ISHEADFIELD = "isheadfield";
    private static final String ISDEFAULTSHOW = "isdefaultshow";
    private static final String ENTRYLOCATION = "entrylocation";
    private static final String ENTRYLOCATIONID = "entrylocationid";
    private static final String ENTRYLOCATIONNAME = "entrylocationname";

    public void initialize() {
        this.addClickListeners(new String[]{BTNOK, BTNREMOVE});
        EntryGrid grid = (EntryGrid)this.getControl(FTARGETPROPS);
        grid.addRowClickListener((RowClickEventListener)this);
        TreeView fieldtree = (TreeView)this.getView().getControl(FIELDTREE);
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        JSONObject billInfo = (JSONObject)this.getView().getFormShowParameter().getCustomParam("billtype");
        String number = billInfo.getString("number");
        if (StringUtils.isBlank((CharSequence)number)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u201c\u5355\u636e\u7f16\u7801\u201d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6240\u9009\u5355\u636e\u3002", (String)"WFBillSummaryConfigFieldPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
        MetadataReader reader = new MetadataReader();
        String fid = reader.loadIdByNumber(number, MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        List entities = entityMetadata.getRootEntity().getItems();
        ArrayList<Object> listHead = new ArrayList<Object>();
        ArrayList<Object> listEntry = new ArrayList<Object>();
        String scene = (String)this.getView().getFormShowParameter().getCustomParam("scene");
        boolean isStackedCard = BillSummaryUtil.isBillRelationStackedCardSummary((String)scene);
        for (EntityItem field : entities) {
            if (field instanceof EntryEntity) {
                if (((EntryEntity)field).getItems().isEmpty() || BillSummaryType.floatlayerSummary.name().equals(scene) || isStackedCard) continue;
                listEntry.add(field);
                continue;
            }
            if (field instanceof AttachmentField && !BillSummaryType.mobileSummary.name().equals(scene)) continue;
            listHead.add(field);
        }
        TreeView tree = (TreeView)this.getView().getControl(FIELDTREE);
        TreeNode root = new TreeNode();
        root.setId(entityMetadata.getId());
        root.setLongNumber(entityMetadata.getKey());
        root.setText(entityMetadata.getName().toString());
        root.setIsOpened(true);
        this.setHeadTreeNode(root, listHead, scene);
        this.setEntryTreeNode(root, listEntry, scene);
        tree.addNode(root);
        this.getPageCache().put(TREEROOTNODE, SerializationUtils.toJsonString((Object)root));
        Object configFields = this.getView().getFormShowParameter().getCustomParams().get("configfields");
        if (configFields == null || StringUtils.isBlank(configFields)) {
            return;
        }
        List fields = (List)configFields;
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(fields.size());
        this.getModel().deleteEntryData(FTARGETPROPS);
        String fieldCompatible = null;
        Object fieldType = null;
        for (Map field : fields) {
            TreeNode node;
            fieldType = field.get(FIELDTYPE);
            if (StringUtils.equals((CharSequence)BillSummaryType.mobileSummary.name(), (CharSequence)scene) ? "UserAvatarField".equals(fieldType) || "BillTypeField".equals(fieldType) || "GeoPointField".equals(fieldType) || "RefBillField".equals(fieldType) || "FlexField".equals(fieldType) : "DateRangeField".equals(fieldType) || "TimeRangeField".equals(fieldType) || "GeoPointField".equals(fieldType) || "UserAvatarField".equals(fieldType) || "BillTypeField".equals(fieldType)) continue;
            String fieldId = (String)field.get(FIELDID);
            if ("LargeTextField".equals(fieldType) && (node = root.getTreeNode(fieldId, 16)).isDisabled()) continue;
            this.setCheckedField(fieldId, root, checkNodes, field.get(FIELDNAME));
            fieldCompatible = this.getPageCache().get(fieldId + "compatible");
            if (isStackedCard || null == fieldCompatible || field.containsKey(fieldCompatible)) continue;
            this.setCheckedField(fieldCompatible, root, checkNodes, null);
        }
        if (checkNodes.isEmpty()) {
            return;
        }
        tree.checkNodes(checkNodes);
    }

    private void setEntryTreeNode(TreeNode root, List<Object> listEntry, String scene) {
        if (listEntry.isEmpty()) {
            return;
        }
        int listEntrySize = listEntry.size();
        HashMap<String, String> cacheMap = new HashMap<String, String>(listEntrySize);
        for (int i = 0; i < listEntrySize; ++i) {
            EntryEntity field = (EntryEntity)listEntry.get(i);
            TreeNode node = new TreeNode();
            node.setParentid(root.getId());
            node.setId(field.getId());
            node.setLongNumber(field.getName().getLocaleValue());
            node.setText(field.getName().getLocaleValue());
            List entryItems = field.getItems();
            for (EntityItem entryField : entryItems) {
                if (entryField instanceof EntryEntity) continue;
                this.setTreeNodeInfo(node, entryField, field, cacheMap, scene);
            }
            root.addChild(node);
        }
        if (cacheMap.isEmpty()) {
            return;
        }
        this.getPageCache().put(cacheMap);
    }

    private void setHeadTreeNode(TreeNode root, List<Object> listHead, String scene) {
        if (listHead.isEmpty()) {
            return;
        }
        int listHeadSize = listHead.size();
        HashMap<String, String> cacheMap = new HashMap<String, String>(listHeadSize);
        for (int i = 0; i < listHeadSize; ++i) {
            EntityItem field = (EntityItem)listHead.get(i);
            this.setTreeNodeInfo(root, field, null, cacheMap, scene);
        }
        if (cacheMap.isEmpty()) {
            return;
        }
        this.getPageCache().put(cacheMap);
    }

    private String changeLocaleStringToString(LocaleString localeString) {
        HashMap<String, Object> map = new HashMap<String, Object>(WfUtils.getSupportLangs().length);
        for (Lang lang : WfUtils.getSupportLangs()) {
            map.put(lang.name(), localeString.get((Object)lang.name()));
        }
        return SerializationUtils.toJsonString(map);
    }

    private LocaleString changeMapToLocaleString(String mapString) {
        LocaleString localeString = new LocaleString();
        if (WfUtils.isNotEmpty((String)mapString)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)mapString, Map.class);
            for (Lang lang : WfUtils.getSupportLangs()) {
                localeString.put(lang.name(), map.get(lang.name()));
            }
        }
        return localeString;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTNREMOVE.equals(key)) {
            this.delete();
        } else if (BTNOK.equals(key)) {
            this.confirm();
        }
    }

    private void confirm() {
        ArrayList listFields = new ArrayList();
        DynamicObjectCollection fields = this.getModel().getEntryEntity(FTARGETPROPS);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOTNODE), TreeNode.class);
        Map<String, Map<String, Object>> oldConfigFields = this.getOldConfigFields();
        int headField = 0;
        HashMap<String, Integer> entryColumn = new HashMap<String, Integer>();
        for (DynamicObject field : fields) {
            String fieldId = field.getString(FTID);
            TreeNode node = root.getTreeNode(fieldId, 16);
            if (node == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(30);
            Map nodeData = (Map)node.getData();
            map.put(FIELDNAME, this.changeMapToLocaleString((String)nodeData.get(FIELDFULLNAME)));
            map.put(FIELDID, fieldId);
            map.put(FIELDKEY, nodeData.get(FIELDKEY));
            map.put(FIELDTYPE, nodeData.get(FIELDTYPE));
            map.put(ISHEADFIELD, nodeData.get(ISHEADFIELD));
            map.put(ENTRYLOCATION, nodeData.get(ENTRYLOCATION));
            map.put(ENTRYLOCATIONID, nodeData.get(ENTRYLOCATIONID));
            map.put(ENTRYLOCATIONNAME, this.changeMapToLocaleString((String)nodeData.get(ENTRYLOCATIONNAME)));
            map.put(ISDEFAULTSHOW, nodeData.get(ISDEFAULTSHOW));
            map.put(REF_PARENT_PROP_FIELD_ID, nodeData.get(REF_PARENT_PROP_FIELD_ID));
            Map<String, Object> oldConfigField = oldConfigFields.get(fieldId);
            if (oldConfigField != null) {
                if (oldConfigField.get(FIELDNAME) != null) {
                    map.put(FIELDNAME, oldConfigField.get(FIELDNAME));
                }
                map.put(ISDEFAULTSHOW, oldConfigField.get(ISDEFAULTSHOW));
                map.put("fieldpercent", oldConfigField.get("fieldpercent"));
                map.put("fontcolor", oldConfigField.get("fontcolor"));
                map.put("fontsize", oldConfigField.get("fontsize"));
                map.put("editable", oldConfigField.get("editable"));
                map.put("showcontent", oldConfigField.get("showcontent"));
                map.put("showcontent_mul", oldConfigField.get("showcontent_mul"));
                map.put("aggregatefunction", oldConfigField.get("aggregatefunction"));
            }
            if (((Boolean)map.get(ISHEADFIELD)).booleanValue()) {
                ++headField;
            } else {
                String entryKey = (String)map.get(ENTRYLOCATION);
                Integer integer = (Integer)entryColumn.get(entryKey);
                if (integer != null) {
                    Integer n = integer;
                    Integer n2 = integer = Integer.valueOf(integer + 1);
                    entryColumn.put(entryKey, integer);
                } else {
                    entryColumn.put(entryKey, 1);
                }
            }
            listFields.add(map);
        }
        String scene = (String)this.getView().getFormShowParameter().getCustomParam("scene");
        if (BillSummaryType.flowchartSummary.name().equals(scene)) {
            if (headField >= 40) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5934\u5b57\u6bb5\u4e0d\u80fd\u8d85\u8fc740\u4e2a\u3002", (String)"WfBillSummaryMobCfg_13", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            for (Map.Entry entry : entryColumn.entrySet()) {
                if ((Integer)entry.getValue() <= 30) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5206\u5f55(%s)\u5b57\u6bb5\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u3002", (String)"WfBillSummaryMobCfg_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), entry.getKey()));
                return;
            }
        }
        this.getView().returnDataToParent(listFields);
        this.getView().close();
    }

    private Map<String, Map<String, Object>> getOldConfigFields() {
        Object configFields = this.getView().getFormShowParameter().getCustomParams().get("configfields");
        List fields = (List)configFields;
        HashMap<String, Map<String, Object>> oldconfigFields = new HashMap<String, Map<String, Object>>(fields.size());
        for (Map field : fields) {
            oldconfigFields.put((String)field.get(FIELDID), field);
        }
        return oldconfigFields;
    }

    private void delete() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(FTARGETPROPS);
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows == null || rows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u79fb\u9664\u7684\u884c\u3002", (String)"WFBillSummaryConfigFieldPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (int row : rows) {
            if (row < 0) continue;
            nodeIds.add((String)this.getModel().getValue(FTID, row));
        }
        this.getModel().deleteEntryRows(FTARGETPROPS, rows);
        TreeView tree = (TreeView)this.getView().getControl("FieldTree");
        tree.uncheckNodes(nodeIds);
        DynamicObjectCollection fields = this.getModel().getEntryEntity(FTARGETPROPS);
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOTNODE), TreeNode.class);
        for (String fieldId : nodeIds) {
            this.setUnCheckRefPropField(fieldId, fields, root.getId());
        }
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        String fieldId = evt.getNodeId().toString();
        if (evt.getChecked().booleanValue()) {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOTNODE), TreeNode.class);
            TreeNode node = root.getTreeNode(fieldId, 16);
            if (node.getChildren() == null) {
                if (fieldId.equals(root.getId())) {
                    return;
                }
                int index = this.getModel().createNewEntryRow(FTARGETPROPS);
                this.getModel().setValue(FTID, (Object)node.getId(), index);
                this.getModel().setValue(FTNAME, (Object)node.getText(), index);
            } else {
                ArrayList<String> childrenNodeIds = new ArrayList<String>();
                ArrayList<TreeNode> childrenNodes = new ArrayList<TreeNode>();
                this.getChildrenNodeIds(childrenNodeIds, childrenNodes, node);
                ArrayList<Integer> deleteFieldIndexs = new ArrayList<Integer>();
                DynamicObjectCollection fields = this.getModel().getEntryEntity(FTARGETPROPS);
                for (int i = 0; i < fields.size(); ++i) {
                    DynamicObject field = (DynamicObject)fields.get(i);
                    if (field == null || !childrenNodeIds.contains(field.get(FTID))) continue;
                    deleteFieldIndexs.add(i);
                }
                int[] delFieldIndexs = new int[deleteFieldIndexs.size()];
                for (int i = 0; i < deleteFieldIndexs.size(); ++i) {
                    delFieldIndexs[i] = (Integer)deleteFieldIndexs.get(i);
                }
                this.getModel().deleteEntryRows(FTARGETPROPS, delFieldIndexs);
                for (TreeNode childNode : childrenNodes) {
                    int index = this.getModel().createNewEntryRow(FTARGETPROPS);
                    this.getModel().setValue(FTID, (Object)childNode.getId(), index);
                    this.getModel().setValue(FTNAME, (Object)childNode.getText(), index);
                }
            }
            this.setCheckRefPropField(node, root);
        } else {
            TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(TREEROOTNODE), TreeNode.class);
            TreeNode node = root.getTreeNode(fieldId, 16);
            ArrayList<String> childrenNodeIds = new ArrayList<String>();
            if (node.getChildren() == null) {
                childrenNodeIds.add(fieldId);
            } else {
                List childrenNodes = node.getChildren();
                for (TreeNode childNode : childrenNodes) {
                    if (null == childNode) continue;
                    List childrenNodez = childNode.getChildren();
                    if (null != childrenNodez && !childrenNodez.isEmpty()) {
                        for (TreeNode childrenNode : childrenNodez) {
                            if (null == childNode || childNode.isDisabled()) continue;
                            childrenNodeIds.add(childrenNode.getId());
                        }
                        continue;
                    }
                    childrenNodeIds.add(childNode.getId());
                }
            }
            ArrayList<Integer> deleteFieldIndexs = new ArrayList<Integer>();
            DynamicObjectCollection fields = this.getModel().getEntryEntity(FTARGETPROPS);
            for (int i = 0; i < fields.size(); ++i) {
                DynamicObject field = (DynamicObject)fields.get(i);
                if (field == null || !childrenNodeIds.contains(field.get(FTID))) continue;
                deleteFieldIndexs.add(i);
            }
            int[] delFieldIndexs = new int[deleteFieldIndexs.size()];
            for (int i = 0; i < deleteFieldIndexs.size(); ++i) {
                delFieldIndexs[i] = (Integer)deleteFieldIndexs.get(i);
            }
            this.getModel().deleteEntryRows(FTARGETPROPS, delFieldIndexs);
            this.setUnCheckRefPropField(fieldId, fields, root.getId());
        }
    }

    private void getChildrenNodeIds(List<String> childrenNodeIds, List<TreeNode> nodes, TreeNode node) {
        List childrenNodes = node.getChildren();
        if (null == childrenNodes || childrenNodes.isEmpty()) {
            return;
        }
        for (TreeNode childNode : childrenNodes) {
            if (null == childNode || childNode.isDisabled()) continue;
            if (childNode.getChildren() != null && !childNode.getChildren().isEmpty()) {
                this.getChildrenNodeIds(childrenNodeIds, nodes, childNode);
                continue;
            }
            childrenNodeIds.add(childNode.getId());
            nodes.add(childNode);
        }
    }

    private void setTreeNodeInfo(TreeNode parentNode, EntityItem<?> entryItemField, EntryEntity entryEntityField, Map<String, String> cacheMap, String scene) {
        String refPropFieldId;
        if (null == parentNode || null == entryItemField) {
            return;
        }
        if (StringUtils.equals((CharSequence)BillSummaryType.mobileSummary.name(), (CharSequence)scene) ? entryItemField instanceof RefBillField || entryItemField instanceof UserAvatarField || entryItemField instanceof BillTypeField || entryItemField instanceof FlexField || entryItemField instanceof GeoPointField || entryItemField instanceof LargeTextField && "largeText".equals(((LargeTextField)entryItemField).getEditingMode()) : entryItemField instanceof DateRangeField || entryItemField instanceof TimeRangeField || entryItemField instanceof UserAvatarField || entryItemField instanceof BillTypeField || entryItemField instanceof GeoPointField || entryItemField instanceof LargeTextField && "largeText".equals(((LargeTextField)entryItemField).getEditingMode())) {
            return;
        }
        TreeNode treeNode = new TreeNode();
        treeNode.setParentid(parentNode.getId());
        treeNode.setId(entryItemField.getId());
        treeNode.setText(entryItemField.getName().getLocaleValue());
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(FIELDKEY, entryItemField.getKey());
        data.put(FIELDTYPE, entryItemField.getClass().getSimpleName());
        data.put(FIELDFULLNAME, this.changeLocaleStringToString(entryItemField.getName()));
        Boolean isEntryTreeNode = null == entryEntityField ? Boolean.FALSE : Boolean.TRUE;
        data.put(ISHEADFIELD, isEntryTreeNode == false);
        data.put(ISDEFAULTSHOW, isEntryTreeNode);
        if (isEntryTreeNode.booleanValue()) {
            treeNode.setLongNumber(entryItemField.getName().getLocaleValue());
            data.put(ENTRYLOCATION, entryEntityField.getKey());
            data.put(ENTRYLOCATIONID, entryEntityField.getId());
            data.put(ENTRYLOCATIONNAME, this.changeLocaleStringToString(entryEntityField.getName()));
        }
        if (WfUtils.isNotEmpty((String)(refPropFieldId = WFBillSummaryUtil.getRefPropFieldId(entryItemField)))) {
            data.put(REF_PARENT_PROP_FIELD_ID, refPropFieldId);
            String refPropFieldIdCaCheValue = cacheMap.get(refPropFieldId);
            refPropFieldIdCaCheValue = WfUtils.isEmpty((String)refPropFieldIdCaCheValue) ? entryItemField.getId() : refPropFieldIdCaCheValue + "," + entryItemField.getId();
            cacheMap.put(refPropFieldId, refPropFieldIdCaCheValue);
            cacheMap.put(entryItemField.getId() + "compatible", refPropFieldId);
        }
        treeNode.setData(data);
        parentNode.addChild(treeNode);
    }

    private void setCheckRefPropField(TreeNode node, TreeNode root) {
        if (this.isStackedCardTpl()) {
            return;
        }
        Object nodeDataObj = node.getData();
        if (!(nodeDataObj instanceof Map)) {
            return;
        }
        Object refPropFieldId = ((Map)nodeDataObj).get(REF_PARENT_PROP_FIELD_ID);
        if (null == refPropFieldId) {
            return;
        }
        DynamicObjectCollection fields = this.getModel().getEntryEntity(FTARGETPROPS);
        for (int i = 0; i < fields.size(); ++i) {
            DynamicObject field = (DynamicObject)fields.get(i);
            if (field == null || !refPropFieldId.equals(field.get(FTID))) continue;
            return;
        }
        TreeNode refPropFieldNode = root.getTreeNode(refPropFieldId.toString(), 16);
        if (null == refPropFieldNode) {
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl(FIELDTREE);
        tree.checkNode(refPropFieldNode);
        tree.treeNodeCheck(root.getId(), refPropFieldId.toString(), Boolean.TRUE);
    }

    private void setUnCheckRefPropField(String parentFieldId, DynamicObjectCollection targetPropFields, String rootId) {
        if (this.isStackedCardTpl()) {
            return;
        }
        String refPropFieldIdCaCheValue = this.getPageCache().get(parentFieldId);
        if (null == refPropFieldIdCaCheValue || refPropFieldIdCaCheValue.isEmpty()) {
            return;
        }
        TreeView tree = (TreeView)this.getView().getControl(FIELDTREE);
        String[] refPropFieldIdCaCheValues = refPropFieldIdCaCheValue.split(",");
        ArrayList<String> refPropFieldIdCaCheValueL = new ArrayList<String>(refPropFieldIdCaCheValues.length);
        for (String refPropFieldId : refPropFieldIdCaCheValues) {
            for (int i = 0; i < targetPropFields.size(); ++i) {
                DynamicObject field = (DynamicObject)targetPropFields.get(i);
                if (null == field || !refPropFieldId.equals(field.get(FTID))) continue;
                refPropFieldIdCaCheValueL.add(refPropFieldId);
                tree.treeNodeCheck(rootId, refPropFieldId, Boolean.FALSE);
            }
        }
        if (refPropFieldIdCaCheValueL.isEmpty()) {
            return;
        }
        tree.uncheckNodes(refPropFieldIdCaCheValueL);
    }

    private void setCheckedField(String fieldId, TreeNode root, List<TreeNode> checkNodes, Object fieldName) {
        String configFieldsCache = this.getPageCache().get(CONFIG_FIELDS);
        if (null == fieldId || null != configFieldsCache && configFieldsCache.contains(fieldId)) {
            return;
        }
        TreeNode node = root.getTreeNode(fieldId, 16);
        if (null == node) {
            return;
        }
        configFieldsCache = configFieldsCache + "," + fieldId;
        this.getPageCache().put(CONFIG_FIELDS, configFieldsCache);
        checkNodes.add(node);
        int rowindex = this.getModel().createNewEntryRow(FTARGETPROPS);
        Object fieldNameText = null;
        fieldNameText = fieldName instanceof JSONObject ? ((JSONObject)fieldName).get((Object)Lang.get().toString()) : node.getText();
        this.getModel().setValue(FTNAME, fieldNameText, rowindex);
        this.getModel().setValue(FTID, (Object)node.getId(), rowindex);
    }

    private boolean isStackedCardTpl() {
        String scene = (String)this.getView().getFormShowParameter().getCustomParam("scene");
        return BillSummaryUtil.isBillRelationStackedCardSummary((String)scene);
    }
}

