/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.management.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.Pair;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicObjectJsonSerializer;
import kd.bos.workflow.management.plugin.WFBillSummaryUtil;

public class WfBillSummaryCommonTpl
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private static Log log = LogFactory.getLog(WfBillSummaryCommonTpl.class);
    private static final String CONFIGFIELDS = "configfields";
    private static final String BUTTONPRE = "button_";
    private static final String FLEXPRE = "flex_";
    private static final String BILLID = "billid";
    private static final String BILLTYPE = "billtype";
    private static final String ENTRYHIDEKEYS = "entryhidekeys";
    private static final String DEFAULTROWS = "defaultrows";
    private static final String HIDEKEYS = "hidekeys";
    private static final String HASATTACHMENT = "hasattachment";
    private static final String FLEXHIDE = "flexhide";
    private static final String FLEXSHOW = "flexshow";
    private static final String FLEXPANALAPATTACHMENT = "tpl_attachmentpanelap";
    private static final String FIELDKEY = "fieldkey";
    private static final String FIELDTYPE = "fieldtype";
    private static final String DYNAMICOBJECTINFO = "dynamicObjectInfo";
    private static final String WFBILLSUMMARYCOMMONTPL5 = "WfBillSummaryCommonTpl_5";
    private static final String TPLATTACHMENTPANELAP = "tpl_attachmentpanelap";

    public void initialize() {
        Image showIcon = (Image)this.getControl("showicon");
        showIcon.addClickListener((ClickListener)this);
        Image hideIcon = (Image)this.getControl("hideicon");
        hideIcon.addClickListener((ClickListener)this);
        List<String> jsonArray = this.getDetailButtonKeys();
        if (!jsonArray.isEmpty()) {
            for (String buttonKey : jsonArray) {
                this.addClickListeners(new String[]{buttonKey});
            }
        }
    }

    private List<String> getDetailButtonKeys() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        JSONArray configfields = (JSONArray)formShowParameter.getCustomParam(CONFIGFIELDS);
        if (null == configfields || configfields.isEmpty()) {
            return new ArrayList<String>(1);
        }
        ArrayList<String> entryKeys = new ArrayList<String>();
        for (int i = 0; i < configfields.size(); ++i) {
            String entryKey;
            JSONObject configField = configfields.getJSONObject(i);
            if (configField.getBoolean("isheadfield").booleanValue() || entryKeys.contains(entryKey = configField.getString("entrylocation"))) continue;
            entryKeys.add(entryKey);
        }
        ArrayList<String> jsonArray = new ArrayList<String>(entryKeys.size());
        for (String entryKey : entryKeys) {
            jsonArray.add(BUTTONPRE + entryKey);
            jsonArray.add(FLEXPRE + entryKey);
        }
        return jsonArray;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"show", "hide"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("show".equals(key) || "showicon".equals(key)) {
            this.showOrHideSomeControl(true);
        } else if ("hide".equals(key) || "hideicon".equals(key)) {
            this.showOrHideSomeControl(false);
        } else if (key != null && (key.startsWith(BUTTONPRE) || key.startsWith(FLEXPRE))) {
            this.showBillDetail(key);
        }
    }

    private void showBillDetail(String buttonKey) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if (parameter.getCustomParam(BILLID) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u5206\u5f55\u6570\u636e\u3002", (String)"WfBillSummaryCommonTpl_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        MobileFormShowParameter showParameter = new MobileFormShowParameter();
        showParameter.setFormId("wf_entrydetail");
        String entryKey = (String)buttonKey.subSequence(buttonKey.indexOf(95) + 1, buttonKey.length());
        showParameter.setCustomParam("entrykey", (Object)entryKey);
        showParameter.setCustomParam(CONFIGFIELDS, parameter.getCustomParam(CONFIGFIELDS));
        showParameter.setCustomParam(BILLID, parameter.getCustomParam(BILLID));
        showParameter.setCustomParam(BILLTYPE, parameter.getCustomParam(BILLTYPE));
        showParameter.setCustomParam("billsummaryid", parameter.getCustomParam("billsummaryid"));
        showParameter.setCustomParam("billsummarynumber", parameter.getCustomParam("billsummarynumber"));
        showParameter.setCustomParam("type", parameter.getCustomParam("type"));
        showParameter.setCustomParam("SOURCE", (Object)"WF");
        Map entryHideKeys = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(ENTRYHIDEKEYS), Map.class);
        showParameter.setCustomParam("disvisblenumber", entryHideKeys.get(entryKey) == null ? new ArrayList() : entryHideKeys.get(entryKey));
        if (this.getPageCache().get(DYNAMICOBJECTINFO) != null) {
            showParameter.setCustomParam(DYNAMICOBJECTINFO, (Object)this.getPageCache().get(DYNAMICOBJECTINFO));
        } else {
            showParameter.setCustomParam(DYNAMICOBJECTINFO, parameter.getCustomParam(DYNAMICOBJECTINFO));
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DYNAMICOBJECTINFO));
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Floating);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String callBackID = event.getActionId();
        if (DYNAMICOBJECTINFO.equals(callBackID) && event.getReturnData() != null) {
            this.getPageCache().put(DYNAMICOBJECTINFO, (String)event.getReturnData());
        }
    }

    private void showOrHideSomeControl(boolean flag) {
        int defaultRows = 6;
        if (this.getView().getFormShowParameter().getCustomParam(DEFAULTROWS) != null) {
            defaultRows = (Integer)this.getView().getFormShowParameter().getCustomParam(DEFAULTROWS);
        }
        int showCount = 0;
        List<String> hideKeys = Arrays.asList(this.getPageCache().get(HIDEKEYS).split(","));
        Container billHead = (Container)this.getView().getControl("bill_head");
        List items = billHead.getItems();
        for (int i = 0; i < items.size(); ++i) {
            String key = ((Control)items.get(i)).getKey();
            if (hideKeys.contains(key)) continue;
            if (showCount < defaultRows) {
                ++showCount;
                continue;
            }
            this.getView().setVisible(Boolean.valueOf(flag), new String[]{key});
            ++showCount;
        }
        if (this.getPageCache().get(HASATTACHMENT) != null && showCount >= defaultRows) {
            this.getView().setVisible(Boolean.valueOf(flag), new String[]{"tpl_attachmentpanelap"});
            ++showCount;
        }
        if (flag) {
            if (showCount > defaultRows) {
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEXHIDE});
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXSHOW});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXSHOW});
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXHIDE});
            }
        } else if (showCount > defaultRows) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXHIDE});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXSHOW});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXSHOW});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXHIDE});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
    }

    public void afterBindData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billId = (String)formShowParameter.getCustomParam(BILLID);
        String billType = (String)formShowParameter.getCustomParam(BILLTYPE);
        if (formShowParameter.getCustomParam("applier") == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXHIDE});
            this.showOrHideSomeControl(false);
            return;
        }
        this.initAttachmentInfo(billId, billType);
        this.hideSomeControls();
    }

    private void hideSomeControls() {
        int defaultRows = 6;
        if (this.getView().getFormShowParameter().getCustomParam(DEFAULTROWS) != null) {
            defaultRows = (Integer)this.getView().getFormShowParameter().getCustomParam(DEFAULTROWS);
        }
        List<Object> hideKeys = new ArrayList();
        if (this.getPageCache().get(HIDEKEYS) != null) {
            hideKeys = Arrays.asList(this.getPageCache().get(HIDEKEYS).split(","));
        }
        int showCount = 0;
        Container bilHead = (Container)this.getView().getControl("bill_head");
        List items = bilHead.getItems();
        for (int i = 0; i < items.size(); ++i) {
            String key = ((Control)items.get(i)).getKey();
            if (hideKeys.contains(key)) continue;
            if (showCount < defaultRows) {
                ++showCount;
                continue;
            }
            Control control = (Control)items.get(i);
            this.getView().setVisible(Boolean.FALSE, new String[]{control.getKey()});
            ++showCount;
        }
        if (this.getPageCache().get(HASATTACHMENT) != null && showCount >= defaultRows) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tpl_attachmentpanelap"});
            ++showCount;
        }
        if (showCount > defaultRows) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXSHOW});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXSHOW});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{FLEXHIDE});
    }

    private void initAttachmentInfo(String billId, String billType) {
        try {
            List<Map<String, Object>> attachments = WfBillSummaryCommonTpl.getAttachments(billType, billId);
            if (CollectionUtil.isNotEmpty(attachments)) {
                AttachmentPanel tplAttachmentpanel = (AttachmentPanel)this.getControl("tpl_attachmentpanelap");
                tplAttachmentpanel.bindData(attachments);
                this.getPageCache().put(HASATTACHMENT, "true");
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"tpl_attachmentpanelap"});
            }
        }
        catch (Exception e) {
            log.info("get attachments error:" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    public static List<Map<String, Object>> getAttachments(String formId, Object pkId) {
        QFilter aFilter2;
        QFilter qFilter1;
        Map dynColl;
        ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
        if (pkId != null) {
            Object object = pkId = pkId instanceof String ? pkId : "" + pkId;
        }
        if (!(StringUtils.isBlank((Object)pkId) || pkId instanceof Long && (Long)pkId == 0L || (dynColl = BusinessDataServiceHelper.loadFromCache((String)"bos_attachment", (QFilter[])new QFilter[]{qFilter1 = new QFilter("FBillType", "=", (Object)formId), aFilter2 = new QFilter("FInterID", "=", pkId)})) == null || dynColl.isEmpty())) {
            for (DynamicObject obj : dynColl.values()) {
                DynamicObject creator;
                HashMap<String, Object> map = new HashMap<String, Object>();
                String name = (String)obj.get("FAttachmentName");
                String url = null;
                try {
                    url = URLEncoder.encode(AttachmentServiceHelper.removeUrlVersion((String)String.valueOf(obj.get("FFileId"))), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    log.info("encode attachment url error:" + WfUtils.getExceptionStacktrace((Throwable)e));
                }
                String attUrl = UrlService.getAttachmentFullUrl((String)url);
                attUrl = AttachmentServiceHelper.getEncreptURL((String)attUrl);
                map.put("lastModified", obj.get("FModifyTime"));
                map.put("name", name);
                map.put("size", Long.parseLong((String)obj.get("FATTACHMENTSIZE")));
                map.put("uid", obj.get("FNUMBER"));
                map.put("url", attUrl);
                map.put("attPkId", obj.getPkValue());
                map.put("entityNum", obj.get("FBILLTYPE"));
                map.put("billPkId", pkId);
                String type = (String)obj.get("FEXTNAME");
                if (AttachmentServiceHelper.ablePreView((String)type)) {
                    map.put("previewurl", attUrl.replace("download.do", "preview.do"));
                }
                map.put("type", obj.get("FEXTNAME"));
                map.put("description", obj.get("fdescription"));
                map.put("status", "success");
                map.put("fattachmentpanel", "tpl_attachmentpanelap");
                Date createdate = obj.getDate("fcreatetime");
                if (createdate != null) {
                    map.put("createdate", createdate.getTime());
                }
                if ((creator = (DynamicObject)obj.get("FCREATEMEN")) != null) {
                    map.put("creator", creator.get(((BasedataEntityType)creator.getDataEntityType()).getNameProperty()));
                }
                data.add(map);
            }
        }
        return data;
    }

    public void afterCreateNewData(EventObject e) {
        ArrayList<Object> hideKeys = new ArrayList<Object>();
        HashMap entryHideKeys = new HashMap();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billId = (String)formShowParameter.getCustomParam(BILLID);
        if (billId == null) {
            this.getPageCache().put(HIDEKEYS, StringUtils.join((Object[])hideKeys.toArray(), (String)","));
            this.getPageCache().put(ENTRYHIDEKEYS, SerializationUtils.toJsonString(entryHideKeys));
            return;
        }
        ArrayList<String> headHideKeys = new ArrayList<String>();
        List disVisbleNumber = (List)formShowParameter.getCustomParam("disvisblenumber");
        for (String number : disVisbleNumber) {
            String[] splits = number.split("\\.");
            if (splits.length == 1) {
                if (headHideKeys.contains(number)) continue;
                headHideKeys.add(number);
                continue;
            }
            if (splits.length != 2) continue;
            ArrayList<String> list = (ArrayList<String>)entryHideKeys.get(splits[0]);
            if (list == null) {
                list = new ArrayList<String>();
                list.add(splits[1]);
                entryHideKeys.put(splits[0], list);
                continue;
            }
            if (list.contains(splits[0])) continue;
            list.add(splits[1]);
            entryHideKeys.put(splits[0], list);
        }
        this.getPageCache().put(ENTRYHIDEKEYS, SerializationUtils.toJsonString(entryHideKeys));
        String billType = (String)formShowParameter.getCustomParam(BILLTYPE);
        JSONArray configfields = (JSONArray)formShowParameter.getCustomParam(CONFIGFIELDS);
        String dynamicObjectInfo = (String)formShowParameter.getCustomParam(DYNAMICOBJECTINFO);
        DynamicObject bill = null;
        try {
            bill = DynamicObjectJsonSerializer.parseDynamicObjectJson((String)dynamicObjectInfo, (String)billType);
        }
        catch (Exception exception) {
            log.error(WfUtils.getExceptionStacktrace((Throwable)exception));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636eDynamicObject\u5bf9\u8c61\u53cd\u5e8f\u5217\u5316\u51fa\u9519\uff1a\u8bf7\u5148\u68c0\u6d4b\u5355\u636e\u662f\u5426\u6709\u591a\u57fa\u7840\u8d44\u6599\u7c7b\u522b\uff0c\u5982\u6709\u5fc5\u987b\u7ed9\u5b9a\u7f3a\u7701\u503c\u3002", (String)"WfBillSummaryCommonTpl_4", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            return;
        }
        MetadataReader reader = new MetadataReader();
        String fid = reader.loadIdByNumber(billType, MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        Map<String, EntityItem<?>> mapItems = WFBillSummaryUtil.getItems(entityMetadata);
        ArrayList<String> entryKeys = new ArrayList<String>();
        HashMap<String, ArrayList<JSONObject>> entryColumns = new HashMap<String, ArrayList<JSONObject>>();
        StringBuilder notExistKeys = new StringBuilder();
        for (int i = 0; i < configfields.size(); ++i) {
            JSONObject configField = configfields.getJSONObject(i);
            String fieldKey = configField.getString(FIELDKEY);
            String fieldType = configField.getString(FIELDTYPE);
            if (!configField.getBoolean("isheadfield").booleanValue()) {
                ArrayList<JSONObject> list;
                String entryKey = configField.getString("entrylocation");
                if (!entryKeys.contains(entryKey)) {
                    entryKeys.add(entryKey);
                }
                if ((list = (ArrayList<JSONObject>)entryColumns.get(entryKey)) == null) {
                    list = new ArrayList<JSONObject>();
                    list.add(configField);
                } else {
                    list.add(configField);
                }
                entryColumns.put(entryKey, list);
                continue;
            }
            if ("BasedataPropField".equals(fieldType) || "ItemClassTypeField".equals(fieldType)) continue;
            WFBillSummaryUtil.setRefParentPropFieldValue(fieldType, fieldKey, null, bill, this.getModel(), log, null);
            Object value = null;
            if (StringUtils.equals((CharSequence)fieldType, (CharSequence)"DateRangeField") || StringUtils.equals((CharSequence)fieldType, (CharSequence)"TimeRangeField")) {
                boolean ifNotBlankValue = this.handleRangeFieldSuccess(mapItems, fieldKey, fieldType, bill, notExistKeys, this.getModel());
                if (!headHideKeys.contains(fieldKey) && ifNotBlankValue) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{fieldKey});
                hideKeys.add(fieldKey);
                continue;
            }
            try {
                value = bill.get(fieldKey);
            }
            catch (Exception e2) {
                notExistKeys.append(fieldKey).append(',');
                continue;
            }
            if (headHideKeys.contains(fieldKey) || this.isBlackValue(value, fieldType)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{fieldKey});
                hideKeys.add(fieldKey);
            }
            try {
                if ("AttachmentField".equals(configField.getString(FIELDTYPE))) {
                    Object[] attIds = WFBillSummaryUtil.getAttachementValue((DynamicObjectCollection)value);
                    this.getModel().setValue(fieldKey, (Object)attIds, 0);
                    continue;
                }
                this.getModel().setValue(fieldKey, value);
                continue;
            }
            catch (Exception exception) {
                log.warn(String.format("billSummary setValue error\uff1afield\uff1a%1$s\uff0cvalue:%2$s,errorMsg: %3$s", fieldKey, bill.get(fieldKey), exception.getMessage()));
            }
        }
        for (String entryKey : entryKeys) {
            Object columnKey;
            List columns;
            DynamicObjectCollection datas = null;
            try {
                datas = (DynamicObjectCollection)bill.get(entryKey);
            }
            catch (Exception e3) {
                notExistKeys.append(entryKey).append(',');
                continue;
            }
            if (datas.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPRE + entryKey});
                columns = (List)entryColumns.get(entryKey);
                for (JSONObject column : columns) {
                    columnKey = column.getString(FIELDKEY);
                    this.getView().setVisible(Boolean.FALSE, new String[]{columnKey});
                    hideKeys.add(columnKey);
                }
                continue;
            }
            if (datas.size() == 1) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPRE + entryKey});
                List list = (List)entryHideKeys.get(entryKey);
                for (int i = 0; i < datas.size(); ++i) {
                    List columns2 = (List)entryColumns.get(entryKey);
                    for (JSONObject column : columns2) {
                        String columnKey2 = column.getString(FIELDKEY);
                        String columnType = column.getString(FIELDTYPE);
                        if ("ItemClassTypeField".equals(column.getString(columnType))) continue;
                        WFBillSummaryUtil.setRefParentPropFieldValue(columnType, columnKey2, null, (DynamicObject)datas.get(i), this.getModel(), log, null);
                        Object value = null;
                        if (StringUtils.equals((CharSequence)columnType, (CharSequence)"DateRangeField") || StringUtils.equalsIgnoreCase((CharSequence)columnType, (CharSequence)"TimeRangeField")) {
                            boolean ifNotBlankValue = this.handleRangeFieldSuccess(mapItems, columnKey2, columnType, (DynamicObject)datas.get(i), notExistKeys, this.getModel());
                            if (column.getBooleanValue("isdefaultshow") && (list == null || !list.contains(columnKey2)) && ifNotBlankValue) continue;
                            this.getView().setVisible(Boolean.FALSE, new String[]{columnKey2});
                            hideKeys.add(columnKey2);
                            continue;
                        }
                        try {
                            value = ((DynamicObject)datas.get(i)).get(columnKey2);
                        }
                        catch (Exception e1) {
                            Control control = this.getView().getControl(columnKey2);
                            if (control instanceof BasedataPropEdit) {
                                BasedataPropEdit basedataPropEdit = (BasedataPropEdit)control;
                                Object object = null;
                                try {
                                    String refBasedataProp = basedataPropEdit.getRefBasedataProp();
                                    object = ((DynamicObject)datas.get(i)).get(refBasedataProp);
                                }
                                catch (Exception e4) {
                                    notExistKeys.append(columnKey2).append(',');
                                    continue;
                                }
                                if (object != null) {
                                    String refDisplayProp = basedataPropEdit.getRefDisplayProp();
                                    if (WfUtils.isEmpty((String)refDisplayProp)) {
                                        log.warn("refDisplayProp is null." + columnKey2);
                                        continue;
                                    }
                                    value = ((DynamicObject)object).get(refDisplayProp);
                                }
                                if (this.isBlackValue(value, columnType)) {
                                    this.getView().setVisible(Boolean.FALSE, new String[]{columnKey2});
                                    hideKeys.add(columnKey2);
                                }
                                if (value == null) continue;
                                String showValue = "";
                                showValue = value instanceof ILocaleString ? ((ILocaleString)value).getLocaleValue() : value.toString();
                                basedataPropEdit.setText(showValue);
                                continue;
                            }
                            log.warn(String.format("billSummary setValue error\uff1afieldKey\uff1a%1$s,errorMsg: %2$s.", columnKey2, e1.getMessage()));
                        }
                        if (StringUtils.equals((CharSequence)columnType, (CharSequence)"DateRangeField") || StringUtils.equalsIgnoreCase((CharSequence)columnType, (CharSequence)"TimeRangeField")) continue;
                        if (!column.getBooleanValue("isdefaultshow") || list != null && list.contains(columnKey2) || this.isBlackValue(value, columnType)) {
                            this.getView().setVisible(Boolean.FALSE, new String[]{columnKey2});
                            hideKeys.add(columnKey2);
                            continue;
                        }
                        try {
                            if ("AttachmentField".equals(column.getString(FIELDTYPE))) {
                                Object[] attIds = WFBillSummaryUtil.getAttachementValue((DynamicObjectCollection)value);
                                this.getModel().setValue(columnKey2, (Object)attIds, 0);
                                continue;
                            }
                            this.getModel().setValue(columnKey2, value);
                        }
                        catch (Exception exception) {
                            log.warn(String.format("billsummary setValue error\uff1afield\uff1a%1$s\uff0cvalue:%2$s,errorMgs: %3$s", columnKey2, value, exception.getMessage()));
                        }
                    }
                }
                continue;
            }
            if (datas.size() <= 1) continue;
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPRE + entryKey});
            columns = (List)entryColumns.get(entryKey);
            for (JSONObject column : columns) {
                columnKey = column.getString(FIELDKEY);
                this.getView().setVisible(Boolean.FALSE, new String[]{columnKey});
                hideKeys.add(columnKey);
            }
            this.addClickListeners(new String[]{BUTTONPRE + entryKey});
        }
        this.getPageCache().put(HIDEKEYS, StringUtils.join((Object[])hideKeys.toArray(), (String)","));
        if (WfUtils.isNotEmpty((String)notExistKeys.toString())) {
            String info = ResManager.loadKDString((String)"\u7f3a\u5c11\u4e1a\u52a1\u5b57\u6bb5\u201c%s\u201d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WfBillSummaryCommonTpl_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            String notExistKeyStr = notExistKeys.toString();
            if (notExistKeyStr.endsWith(",")) {
                notExistKeyStr = notExistKeyStr.substring(0, notExistKeyStr.length() - 1);
            }
            String format = String.format(info, notExistKeyStr);
            this.getView().showTipNotification(format);
        }
        try {
            this.getView().updateView();
        }
        catch (Exception e1) {
            log.error("WfBillSummaryCommonTpl_afterCreateNewData_\u52a0\u8f7d\u79fb\u52a8\u5355\u636e\u6458\u8981\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff01 e1 = ", (Throwable)e1);
            throw new KDBizException(ResManager.loadKDString((String)"\u79fb\u52a8\u7aef\u5355\u636e\u6458\u8981\u9875\u9762\u52a0\u8f7d\u9519\u8bef\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5\u6216\u5230\u79fb\u52a8\u7aef\u5355\u636e\u6458\u8981\u914d\u7f6e\u9875\u9762\u5904\u7406\u3002", (String)"WfBillSummaryCommonTpl_7", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isBlackValue(Object object, String fieldType) {
        boolean result = object instanceof DynamicObjectCollection && ((DynamicObjectCollection)object).isEmpty() || StringUtils.isBlank((Object)object);
        try {
            if (StringUtils.equals((CharSequence)fieldType, (CharSequence)"TimeField") && Objects.nonNull(object) && object instanceof Integer && (Integer)object == -1) {
                result = true;
            }
        }
        catch (Exception e) {
            log.error("WfBillSummaryCommonTpl_isBlackValue\u7279\u6b8a\u5b57\u6bb5\u5224\u63a7\u903b\u8f91\u53d1\u751f\u5f02\u5e38, e = ", (Throwable)e);
        }
        return result;
    }

    private Boolean handleRangeFieldSuccess(Map<String, EntityItem<?>> mapItems, String fieldKey, String fieldType, DynamicObject bill, StringBuilder notExistKeys, IDataModel model) {
        try {
            EntityItem<?> entity = mapItems.get(fieldKey);
            if (null == entity) {
                return false;
            }
            Pair<String, String> pair = WFBillSummaryUtil.getStartAndEndKey(entity);
            if (StringUtils.isBlank((CharSequence)((CharSequence)pair.getKey())) || StringUtils.isBlank((CharSequence)((CharSequence)pair.getValue()))) {
                return false;
            }
            Object startValue = bill.get((String)pair.getKey());
            Object endValue = bill.get((String)pair.getValue());
            if (this.isBlackValue(startValue, fieldType) || this.isBlackValue(endValue, fieldType)) {
                return false;
            }
            model.setValue((String)pair.getKey(), startValue);
            model.setValue((String)pair.getValue(), endValue);
            if (StringUtils.equals((CharSequence)fieldType, (CharSequence)"TimeRangeField") && ((Integer)startValue == -1 || (Integer)endValue == -1)) {
                return false;
            }
            return true;
        }
        catch (Exception e1) {
            log.warn("handleDateRangeField_error, \u79fb\u52a8\u5355\u636e\u6458\u8981\u5904\u7406\u65e5\u671f\u8303\u56f4\u6216\u65f6\u95f4\u8303\u56f4\u53d1\u751f\u5f02\u5e38\uff0c columnKey = %1$s", (Object)fieldKey);
            notExistKeys.append(fieldKey).append(',');
            return false;
        }
    }
}

