/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.bpmn.graph.codec.GraphCodecUtils;
import kd.bos.workflow.design.plugin.record.AddressProcedureVo;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkflowDeadLetterJobListPlugin
extends AbstractListPlugin {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String OPERATION = "operation";
    private static final String WF_DEAD_LETTER_JOB = "wf_deadletterjob";
    private static final String BAR_ACTIVATE = "baractivate";
    private static final String BAR_REFRESH = "barrefresh";
    public static final String BAR_CONDPARSEPROCEDURE = "condparseprocedure";
    private static final String HANDLE = "handle";
    private static final String TRANSFERLOG = "transferlog";
    public static final String ELEMENT_ID = "elementid";
    private static final String BTNBILL = "btnbill";
    public static final String BAR_ADDRESS_PROCEDURE = "addressprocedure";
    public static final String BILLNO_OR_BUSINESSKEY = "billnoorbusinesskey";
    public static final String ENTITY_NUMBER = "entitynumber";
    private static final String PARTICIPANT_PARSELOG = "participantparselog";

    public void listRowClick(ListRowClickEvent evt) {
        this.hideHandle();
    }

    private void hideHandle() {
        ListSelectedRowCollection selectedRows = ((IListView)this.getView()).getSelectedRows();
        if (selectedRows.size() == 1) {
            WorkflowService wfService;
            DeadLetterJobEntity entity;
            Object obj = selectedRows.get(0).getPrimaryKeyValue();
            if (obj instanceof Long && (entity = (DeadLetterJobEntity)(wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class)).getRepositoryService().findEntityById((Long)obj, WF_DEAD_LETTER_JOB)) != null) {
                String exceptionType = entity.getErrorType();
                if (!("nullParticipant".equalsIgnoreCase(exceptionType) || "conditionParse".equalsIgnoreCase(exceptionType) || "modelDefine".equalsIgnoreCase(exceptionType))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{HANDLE});
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{HANDLE});
                }
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{HANDLE});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("hiddenDeadLetterJobFilter") != null && ((Boolean)customParams.get("hiddenDeadLetterJobFilter")).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"filtercontainerap"});
        }
        if (!Lang.zh_CN.name().equals(RequestContext.get().getLang().name()) && !WfConfigurationUtil.isEnableShowMutiLangLog()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap"});
        }
        PluginUtil.setControlInvisible(this.getView(), "exit");
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (WfAdminUtil.needFilterData()) {
            WfAdminUtil.addWfOrgFilter((SetFilterEvent)e, (String)WF_DEAD_LETTER_JOB);
        }
        List qFilters = e.getQFilters();
        FormShowParameter parameter = this.getView().getFormShowParameter();
        if ("wf".equals(parameter.getAppId())) {
            qFilters.add(new QFilter("processtype", "=", (Object)ModelType.AuditFlow.name()));
        } else {
            qFilters.add(new QFilter("processtype", "!=", (Object)ModelType.NoCodeFlow.name()));
        }
        e.setCustomQFilters(qFilters);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        if (!DesignerPluginUtil.checkWorkflowInService((IFormView)this.getView())) {
            return;
        }
        switch (key = evt.getItemKey()) {
            case "barrefresh": {
                this.refresh();
                break;
            }
            case "baractivate": {
                this.activateDeadJob();
                break;
            }
            case "handle": {
                this.showHandle();
                break;
            }
            case "transferlog": {
                this.showTransferLog();
                break;
            }
            case "btnbill": {
                this.showViewBill();
                break;
            }
            case "addressprocedure": {
                this.showAddressProcedure();
                break;
            }
            case "condparseprocedure": {
                this.showCondParseLog();
                break;
            }
            case "participantparselog": {
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                if (rows.size() != 1) {
                    StandardTips.view((IFormView)this.getView()).selectMultiRow(rows.size());
                    return;
                }
                WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                Long pkId = (Long)((ListView)this.getView()).getFocusRowPkId();
                DeadLetterJobEntity entity = (DeadLetterJobEntity)wfService.getRepositoryService().findEntityById(pkId, WF_DEAD_LETTER_JOB);
                if (entity == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"WorkflowDeadLetterJobListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    return;
                }
                String entityNumber = entity.getEntityNumber();
                String businessKey = entity.getBusinessKey();
                DynamicObject businessModel = WfUtils.findBusinessObject((String)businessKey, (String)entityNumber);
                String billNo = "";
                if (businessModel != null) {
                    billNo = TaskBehaviorUtil.getTaskBillNo((String)entityNumber, (DynamicObject)businessModel);
                }
                ProcessInstancePluginUtil.viewParticipantparseLogList((IFormView)this.getView(), (String)entityNumber, (String)businessKey, (String)billNo);
                break;
            }
        }
    }

    public void showViewBill() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_DEAD_LETTER_JOB, (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = this.getSelectedRow();
        if (rows != null) {
            Long deadLetterJobId = (Long)rows.get(0).getPrimaryKeyValue();
            DeadLetterJobEntity deadLetterJobEntity = this.getRuntimeService().getDeadLetterJob(deadLetterJobId);
            if (deadLetterJobEntity == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"WorkflowDeadLetterJobListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            String entityNumber = deadLetterJobEntity.getEntityNumber();
            String businessKey = deadLetterJobEntity.getBusinessKey();
            if (this.hasCurrentPageTab(deadLetterJobId, "showViewBill")) {
                return;
            }
            String formkey = null;
            String formkeyview = null;
            formkey = !WfUtils.isEmptyString(formkeyview) ? formkeyview : entityNumber;
            if (WfUtils.isEmpty((String)formkey) || WfUtils.isEmpty((String)businessKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\u3002", (String)"WorkflowDeadLetterJobListPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                this.refresh();
                return;
            }
            boolean isBillExist = WfUtils.exist((String)entityNumber, (Object)businessKey);
            if (!isBillExist) {
                this.getView().showTipNotification(WFMultiLangConstants.getBillNotExistTip(), Integer.valueOf(3000));
                return;
            }
            String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
            FormShowParameter paraBase = new FormShowParameter();
            paraBase.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewBill"));
            paraBase.getCustomParams().put("pkId", Long.valueOf(businessKey));
            paraBase.getCustomParams().put("rowId", deadLetterJobId);
            paraBase.getCustomParams().put("procInstId", deadLetterJobEntity.getProcessInstanceId());
            paraBase.getCustomParams().put("BillFormId", billFormId);
            String name = WfUtils.getEntityName((String)formkey, (String)businessKey).getLocaleValue();
            paraBase.setCaption(name);
            String appId = WfUtils.getAppIdForEntity((String)entityNumber);
            if (WfUtils.isNotEmptyString((Object)appId)) {
                paraBase.getCustomParams().put("ServiceAppId", appId);
            }
            paraBase.setCustomParam("isIgnoreLicense", (Object)Boolean.TRUE);
            paraBase.getCustomParams().put("formId", formkey);
            paraBase.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            paraBase.getOpenStyle().setTargetKey("_submaintab_");
            paraBase.setFormId("wf_openbills");
            paraBase.setCustomParam("listView", (Object)this.getView().getPageId());
            this.getView().showForm(paraBase);
            this.clearSelectData();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("viewBill".equals(closedCallBackEvent.getActionId())) {
            IListView listView = (IListView)this.getView();
            listView.refresh();
        }
    }

    private void showAddressProcedure() {
        List addressParseLog;
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        if (selectedRows.size() > 1) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(selectedRows.size());
            return;
        }
        RuntimeService runtimeService = this.getRuntimeService();
        ListSelectedRow row = selectedRows.get(0);
        Long primaryKeyValue = (Long)row.getPrimaryKeyValue();
        DeadLetterJobEntity deadLetterJob = this.getRuntimeService().getDeadLetterJob(primaryKeyValue);
        if (deadLetterJob == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"WorkflowDeadLetterJobListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String entityNumber = deadLetterJob.getEntityNumber();
        String businessKey = deadLetterJob.getBusinessKey();
        DynamicObject businessModel = WfUtils.findBusinessObject((String)businessKey, (String)entityNumber);
        String billNoOrBusinessKey = "";
        String billNo = TaskBehaviorUtil.getTaskBillNo((String)entityNumber, (DynamicObject)businessModel);
        billNoOrBusinessKey = StringUtils.isNotEmpty((CharSequence)billNo) ? billNo : businessKey;
        Long instanceId = deadLetterJob.getProcessInstanceId();
        List<Object> vos = new ArrayList<AddressProcedureVo>();
        if (StringUtils.isNotBlank((CharSequence)entityNumber) && StringUtils.isNotBlank((CharSequence)billNoOrBusinessKey)) {
            addressParseLog = runtimeService.findAddressParseLog(entityNumber, billNoOrBusinessKey);
            vos = addressParseLog.stream().map(AddressProcedureVo::fromEntity).collect(Collectors.toList());
        }
        if (vos.isEmpty() && instanceId != null && instanceId != 0L) {
            addressParseLog = runtimeService.findAddressParseLog(instanceId);
            vos = addressParseLog.stream().map(AddressProcedureVo::fromEntity).collect(Collectors.toList());
        }
        this.toAddressProcedureView(vos, entityNumber, billNoOrBusinessKey);
    }

    private void toAddressProcedureView(List<AddressProcedureVo> collect, String entityNumber, String billNoOrBusinessKey) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_log_addressprocedure");
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("vo", (Object)SerializationUtils.toJsonString(collect));
        param.setCustomParam(ENTITY_NUMBER, (Object)entityNumber);
        param.setCustomParam("billno", (Object)billNoOrBusinessKey);
        String caption = ResManager.loadKDString((String)"\u6d41\u7a0b\u5bfb\u5740\u8fc7\u7a0b", (String)"WorkflowProcessInstancePlugin_60", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        param.setCaption(caption);
        this.getView().showForm(param);
    }

    private void showCondParseLog() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        if (selectedRows.size() > 1) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(selectedRows.size());
            return;
        }
        ListSelectedRow row = selectedRows.get(0);
        Long primaryKeyValue = (Long)row.getPrimaryKeyValue();
        DeadLetterJobEntity deadLetterJob = this.getRuntimeService().getDeadLetterJob(primaryKeyValue);
        if (deadLetterJob == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"WorkflowDeadLetterJobListPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String entityNumber = deadLetterJob.getEntityNumber();
        String businessKey = deadLetterJob.getBusinessKey();
        DynamicObject businessModel = WfUtils.findBusinessObject((String)businessKey, (String)entityNumber);
        String billNo = "";
        if (businessModel != null) {
            billNo = TaskBehaviorUtil.getTaskBillNo((String)entityNumber, (DynamicObject)businessModel);
        }
        String billNoOrBusinessKey = StringUtils.isEmpty((CharSequence)billNo) ? businessKey : billNo;
        this.toConditionParseProcedureView(entityNumber, billNoOrBusinessKey);
    }

    public void toConditionParseProcedureView(String entityNumber, String billNoOrBusinessKey) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_condparseprocedure");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.setCustomParam(ENTITY_NUMBER, (Object)entityNumber);
        param.setCustomParam(BILLNO_OR_BUSINESSKEY, (Object)billNoOrBusinessKey);
        this.getView().showForm(param);
    }

    private void showTransferLog() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)WF_DEAD_LETTER_JOB, (String)"47150e89000000ac")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u8f6c\u65e5\u5fd7\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\u3002", (String)"WorkflowDeadLetterJobListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection list = ((IListView)this.getView()).getSelectedRows();
        if (WfUtils.isNotEmptyForCollection((Collection)list) && list.size() == 1) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setParentPageId(this.getView().getPageId());
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.setCaption(ResManager.loadKDString((String)"\u6d41\u8f6c\u65e5\u5fd7", (String)"WorkflowDeadLetterJobListPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            parameter.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            Long deadLetterJobId = (Long)list.get(0).getPrimaryKeyValue();
            DeadLetterJobEntity deadLetterJobEntity = wfService.getRuntimeService().getDeadLetterJob(deadLetterJobId);
            Long processInstanceId = null;
            if (deadLetterJobEntity != null) {
                processInstanceId = deadLetterJobEntity.getProcessInstanceId();
            }
            if (WfUtils.isEmpty(processInstanceId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u201c\u5f02\u5e38\u6d41\u7a0b\u201d\u3002", (String)"WorkflowDeadLetterJobListPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            QFilter qFilter = new QFilter("processinstanceid", "=", (Object)processInstanceId);
            String openBillFormId = "wf_eventlogentryes";
            if (QueryServiceHelper.exists((String)"wf_eventlogentry", (QFilter[])new QFilter[]{qFilter})) {
                openBillFormId = "wf_eventlogentry";
            }
            parameter.setBillFormId(openBillFormId);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setFilter(qFilter);
            parameter.setListFilterParameter(listFilterParameter);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            Integer integer = Optional.ofNullable(list).map(ArrayList::size).orElseGet(() -> 0);
            StandardTips.view((IFormView)this.getView()).selectMultiRow(integer.intValue());
        }
    }

    private void showHandle() {
        String appId = this.getPermissionAppId();
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)WF_DEAD_LETTER_JOB, (String)"018JWO8RKN3U")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f02\u5e38\u6d41\u7a0b\u201d\u7684\u201c\u5904\u7406\u201d\u6743\u9650\u3002", (String)"WorkflowDeadLetterJobListPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)appId, (String)WF_DEAD_LETTER_JOB, (String)HANDLE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5904\u7406", "WorkflowDeadLetterJobListPlugin_20", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8d8a\u6743\u8bbf\u95ee:\u65e0\u201c\u5f02\u5e38\u6d41\u7a0b\u201d\u7684\u201c\u5904\u7406\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", "WorkflowDeadLetterJobListPlugin_21", "bos-wf-formplugin"), (Object[])new Object[0]);
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (1 != rows.size()) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(rows.size());
            return;
        }
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        Long pkId = (Long)((ListView)this.getView()).getFocusRowPkId();
        DeadLetterJobEntity entity = (DeadLetterJobEntity)wfService.getRepositoryService().findEntityById(pkId, WF_DEAD_LETTER_JOB);
        if (entity != null) {
            String exceptionType = entity.getErrorType();
            Long procDefId = entity.getProcessDefinitionId();
            if ("nullParticipant".equalsIgnoreCase(exceptionType)) {
                this.openModifyForm(entity, procDefId);
            } else if ("modelDefine".equalsIgnoreCase(exceptionType)) {
                this.openDesignWindow(procDefId);
            } else if ("conditionParse".equalsIgnoreCase(exceptionType)) {
                if ("address-process-event".equals(entity.getJobHandlerType())) {
                    this.toProcessDefinitionList(Lists.newArrayList((Object[])new Long[]{procDefId}));
                } else {
                    this.openModifyForm(entity, procDefId);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"WorkflowDeadLetterJobListPlugin_8", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
        }
    }

    private void openDesignWindow(Long procDefId) {
        try {
            RuntimeService service = this.getRuntimeService();
            Long modelId = service.getModelIdByProcDefId(procDefId);
            DesignerModelUtil.openAuditFlowDesigner((Long)modelId, (IFormView)this.getView());
        }
        catch (Exception e) {
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u6253\u5f00\u8bbe\u8ba1\u5668\u9519\u8bef\uff1a%s\u3002", (String)"WorkflowDeadLetterJobListPlugin_9", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage());
        }
    }

    private void openModifyForm(DeadLetterJobEntity entity, Long procDefId) {
        WorkflowService wfService;
        HistoricProcessInstanceEntity processInstance;
        String itemId = null;
        if (WfUtils.isNotEmpty((String)entity.getElementId())) {
            itemId = entity.getElementId();
        }
        if ((processInstance = (wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class)).getHistoryService().getHistoricProcessInstance(entity.getProcessInstanceId())) != null) {
            String modelType = GraphCodecUtils.getModelTypeByProcessType((String)processInstance.getProcessType());
            DesignerModelUtil.openDynamicConfigScheme((String)modelType, (IFormView)this.getView(), (Long)procDefId, (Long)processInstance.getSchemeId(), (String)itemId);
        }
    }

    private void toProcessDefinitionList(List<Long> processDefinitionIds) {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("wf_processtreelist");
        param.setBillFormId("bpm_processmanage");
        param.setCustomParam("defaultFilter", (Object)"false");
        ListFilterParameter filter = new ListFilterParameter();
        filter.setFilter(new QFilter("id", "in", processDefinitionIds));
        param.setListFilterParameter(filter);
        param.setSelectedRows(processDefinitionIds.toArray());
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        this.getView().showForm((FormShowParameter)param);
    }

    private RuntimeService getRuntimeService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRuntimeService();
    }

    private HistoryService getHistoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getHistoryService();
    }

    private void activateDeadJob() {
        String appId = this.getPermissionAppId();
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)WF_DEAD_LETTER_JOB, (String)"/8M3MNJNJZE5")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6fc0\u6d3b\u6d41\u7a0b\u7684\u6743\u9650\u3002", (String)"WorkflowDeadLetterJobListPlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)appId, (String)WF_DEAD_LETTER_JOB, (String)BAR_ACTIVATE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u91cd\u65b0\u6fc0\u6d3b", "WorkflowDeadLetterJobListPlugin_18", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u91cd\u65b0\u6fc0\u6d3b\u201d\u7684\u6743\u9650\u3002", "WorkflowDeadLetterJobListPlugin_19", "bos-wf-formplugin"), (Object[])new Object[0]);
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        StringBuilder deadLetterJobIds = new StringBuilder();
        ArrayList<Long> successJobIds = new ArrayList<Long>(10);
        ArrayList<String> failJobsTips = new ArrayList<String>(10);
        if (rows != null && !rows.isEmpty()) {
            try {
                WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                for (ListSelectedRow row : rows) {
                    Long deadLetterJobId = (Long)row.getPrimaryKeyValue();
                    deadLetterJobIds.append(deadLetterJobId).append(',');
                    try {
                        wfService.getManagementService().revokeSuspendProcessInstancesByIds(deadLetterJobId, null);
                        successJobIds.add(deadLetterJobId);
                    }
                    catch (Exception e) {
                        failJobsTips.add(deadLetterJobId + ":" + e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                String message = String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5f15\u64ce\u5f02\u5e38\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowDeadLetterJobListPlugin_13", (String)"bos-wf-formplugin", (Object[])new Object[0]), e.getMessage());
                this.getView().showErrorNotification(message);
                WfUtils.addOpLogByAppId((String)appId, (String)WF_DEAD_LETTER_JOB, (String)"activate", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6fc0\u6d3b\u6d41\u7a0b\u3002", "WorkflowDeadLetterJobListPlugin_15", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5c06\u5f02\u5e38\u6d41\u7a0bId[%s]\u6fc0\u6d3b\u3002", "WorkflowDeadLetterJobListPlugin_16", "bos-wf-formplugin"), (Object[])new Object[]{deadLetterJobIds.substring(0, deadLetterJobIds.length() - 1)});
                this.refresh();
            }
            if (failJobsTips.size() > 0) {
                String handleName = ResManager.loadKDString((String)"\u6fc0\u6d3b\u6d41\u7a0b", (String)"WorkflowDeadLetterJobListPlugin_15_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                StandardTips.view((IFormView)this.getView()).batchOptionMsg(handleName, successJobIds, failJobsTips);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6fc0\u6d3b\u6210\u529f\u3002", (String)"WorkflowDeadLetterJobListPlugin_14", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            }
            WfUtils.addOpLogByAppId((String)appId, (String)WF_DEAD_LETTER_JOB, (String)"activate", (MultiLangEnumBridge)new MultiLangEnumBridge("\u6fc0\u6d3b\u6d41\u7a0b\u3002", "WorkflowDeadLetterJobListPlugin_15", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5c06\u5f02\u5e38\u6d41\u7a0bId[%s]\u6fc0\u6d3b\u3002", "WorkflowDeadLetterJobListPlugin_16", "bos-wf-formplugin"), (Object[])new Object[]{deadLetterJobIds.substring(0, deadLetterJobIds.length() - 1)});
            this.refresh();
        } else {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (!DesignerPluginUtil.checkWorkflowInService((IFormView)this.getView())) {
            return;
        }
        super.billListHyperLinkClick(args);
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setShowTitle(false);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setFormId(WF_DEAD_LETTER_JOB);
        parameter.setPkId((Object)((Long)((ListView)this.getView()).getFocusRowPkId()));
        parameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)parameter);
        args.setCancel(true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        if (!DesignerPluginUtil.checkWorkflowInService((IFormView)this.getView())) {
            return;
        }
        super.listRowDoubleClick(evt);
        BillList billList = (BillList)evt.getSource();
        String focusField = billList.getEntryState().getFocusField();
        if (OPERATION.equalsIgnoreCase(focusField)) {
            evt.setCancel(true);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        SessionManager.getCurrent().remove(WF_DEAD_LETTER_JOB);
    }

    private void refresh() {
        ListView listView = (ListView)this.getView();
        listView.clearSelection();
        listView.refresh();
    }

    private String getTargetTab() {
        return "_submaintab_";
    }

    private String getPageId(long deadLetterJobId, String type) {
        String pageId = UUID.randomUUID().toString();
        IPageCache parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        parentPageCache.put(type + deadLetterJobId + RequestContext.get().getUserId() + this.getView().getFormShowParameter().getRootPageId(), pageId);
        return pageId;
    }

    private boolean hasCurrentPageTab(long deadLetterJobId, String type) {
        IFormView formView;
        if (this.getView().getParentView() == null) {
            return false;
        }
        String pageIdkey = type + deadLetterJobId + RequestContext.get().getUserId() + this.getView().getFormShowParameter().getRootPageId();
        IPageCache parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String pageId = parentPageCache.get(pageIdkey);
        if (WfUtils.isNotEmpty((String)pageId) && (formView = this.getView().getViewNoPlugin(pageId)) != null) {
            formView.activate();
            this.clearSelectData();
            this.getView().sendFormAction(formView);
            return true;
        }
        return false;
    }

    private void clearSelectData() {
        if (this.getView() instanceof IListView) {
            IListView view = (IListView)this.getView();
            view.clearSelection();
        }
    }

    public ListSelectedRowCollection getSelectedRow() {
        ListSelectedRowCollection rows = this.getSelectedRows();
        if (null != rows && 1 < rows.size()) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(rows.size());
            rows = null;
        }
        return rows;
    }

    public ListSelectedRowCollection getSelectedRows() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.isEmpty()) {
            this.getView().showTipNotification(WFMultiLangConstants.getNoDataSelectedTip());
            rows = null;
        }
        return rows;
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId((IFormView)this.getView());
    }
}

