/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.monitor.plugin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.api.constants.ProcessType;
import kd.bos.workflow.design.plugin.record.AddressProcedureVo;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ViewFlowchartUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.monitor.plugin.vo.ErrorAbandonVo;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.data.WorkflowTCDataPlugin;
import kd.bos.workflow.taskcenter.plugin.util.WorkflowTCDataPluginUtil;

public class WorkflowProcessInstancePlugin
extends WorkflowTCDataPlugin {
    public static final String HIDDEN_DEAD_LETTER_JOB_FILTER = "hiddenDeadLetterJobFilter";
    private static final String BTN_TRANSFER = "transfer";
    private String CURRENT_PROCESSINSTANCE_ID = "current_processInstance_id";
    private static final String BAR_ERROR_MESSAGE = "barerrormessage";
    private static final String BAR_REVOKE_SUSPEND = "barrevokesuspend";
    private static final String BAR_SUSPEND = "suspend";
    private static final String BARREFRESH = "barrefresh";
    private static final String REACTIVATION = "reactivation";
    private static final String BAR_SKIP = "skip";
    private static final String BAR_FORCETERMINATE = "feiqi";
    private static final String TRANSFERLOG = "transferlog";
    private static final String BTNBILL = "btnbill";
    private static final String CURTASK = "curtask";
    private static final String BAR_PROCESS_SALUTION = "barprocesssalution";
    private static final String JUMPSUSPEND = "jumpSuspend";
    private static final String CURSELPROCESSINSTANCEID = "CURSELPROCESSINSTANCEID";
    private static final String DESTNODEID = "DESTNODEID";
    private static final String SRCID = "SRCID";
    private static final String DYNAMIC_UPDATE_PROCINST = "updateprocinst";
    private static final String BAR_OPERATELOG = "baroperatelog";
    private static final String PARTICIPANT_PARSELOG = "participantparselog";
    private static final String BAR_ADDRESS_PROCEDURE = "addressprocedure";
    private static final String CALLBACK_TASK = "taskcloseback";
    public static final String BAR_CONDPARSEPROCEDURE = "condparseprocedure";
    public static final String BILLNO_OR_BUSINESSKEY = "billnoorbusinesskey";
    public static final String ENTITY_NUMBER = "entitynumber";
    public static final String BILL_NO = "billno";
    private static final String REASON = "reason";

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getView().getControl("billlistap");
        QFilter filter = new QFilter("scope", "=", (Object)"1").and("processtype", "=", (Object)ModelType.AuditFlow.name());
        list.setFilter(filter);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        if (WfAdminUtil.needFilterData()) {
            WfAdminUtil.addWfOrgFilter((SetFilterEvent)e, (String)"wf_execution");
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        if (!DesignerPluginUtil.checkWorkflowInService((IFormView)this.getView())) {
            return;
        }
        String key = evt.getItemKey();
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        switch (key) {
            case "barrefresh": {
                this.refresh();
                break;
            }
            case "barerrormessage": {
                this.openErrorMSGList(rows);
                break;
            }
            case "suspend": {
                this.suspend(rows);
                break;
            }
            case "barrevokesuspend": {
                this.revokeSuspend(rows);
                break;
            }
            case "transfer": {
                this.transfer();
                break;
            }
            case "skip": {
                this.skip(rows);
                break;
            }
            case "feiqi": {
                this.abandon();
                break;
            }
            case "transferlog": {
                this.showTransferLog(rows);
                break;
            }
            case "btnbill": {
                if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"47150e89000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u67e5\u8be2\u7684\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_30", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.showBill("toApply");
                break;
            }
            case "updateprocinst": {
                this.updateProcInst(rows);
                break;
            }
            case "curtask": {
                this.viewCurrentTask(rows);
                break;
            }
            case "barprocesssalution": {
                this.showProcessConfiguration(rows);
                break;
            }
            case "baroperatelog": {
                if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"47150e89000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u64cd\u4f5c\u65e5\u5fd7\u201d\u7684\u67e5\u8be2\u6743\u9650\u3002", (String)"WorkflowTCDataPlugin_31", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getView().getPageCache().put("openFormId", "wf_operationlog");
                this.queryAllApprovalRecord(rows);
                break;
            }
            case "participantparselog": {
                if (rows.size() != 1) {
                    StandardTips.view((IFormView)this.getView()).selectMultiRow(rows.size());
                    return;
                }
                Long primaryKeyValue = (Long)rows.get(0).getPrimaryKeyValue();
                ProcessInstancePluginUtil.viewParticipantparseLogList((IFormView)this.getView(), Collections.singletonList(primaryKeyValue));
                break;
            }
            case "addressprocedure": {
                this.showAddressProcedureLog(rows);
                break;
            }
            case "condparseprocedure": {
                this.showCondParseLog(rows);
                break;
            }
        }
    }

    private void showProcessConfiguration(ListSelectedRowCollection rows) {
        String entityNumber = this.getPermissionEntity();
        String appId = this.getPermissionAppId();
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)"wf_processdefinition", (String)"/8M2NEU9PFQV")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u914d\u7f6e\u201d\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"WorkflowProcessInstancePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)appId, (String)entityNumber, (String)BAR_PROCESS_SALUTION, (MultiLangEnumBridge)new MultiLangEnumBridge("\u67e5\u770b\u6d41\u7a0b\u914d\u7f6e", "WorkflowProcessInstancePlugin_57", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u7ba1\u7406\u201d\u7684\u201c\u6d41\u7a0b\u52a8\u6001\u65b9\u6848\u914d\u7f6e\u201d\u6743\u9650\u3002", "ProcessInstancePluginUtil_40", "bos-wf-formplugin"), (Object[])new Object[0]);
            return;
        }
        if (1 != rows.size()) {
            StandardTips.view((IFormView)this.getView()).selectMultiRow(rows.size());
            return;
        }
        Long pkId = (Long)((ListView)this.getView()).getFocusRowPkId();
        ProcessInstancePluginUtil.showProcessConfiguration((IFormView)this.getView(), (Long)pkId);
    }

    private void viewCurrentTask(ListSelectedRowCollection list) {
        ArrayList<Long> procInstIds = new ArrayList<Long>();
        if (list != null && list.size() > 0) {
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            for (ListSelectedRow listSelectedRow : list) {
                Long excutionId = (Long)listSelectedRow.getPrimaryKeyValue();
                ExecutionEntity excutionEntity = wfService.getRuntimeService().getProcessInstance(excutionId);
                if (excutionEntity == null) continue;
                procInstIds.add(excutionEntity.getProcessInstanceId());
            }
            if (WfUtils.isEmptyForCollection(procInstIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\u3002", (String)"WorkflowProcessInstancePlugin_70", (String)"bos-wf-engine", (Object[])new Object[0]));
                return;
            }
        }
        ProcessInstancePluginUtil.viewCurrentTask((IFormView)((FormView)this.getView()), procInstIds);
    }

    private void updateProcInst(ListSelectedRowCollection rows) {
        ArrayList<Long> procInstIds = new ArrayList<Long>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            procInstIds.add((Long)rows.get(i).getPrimaryKeyValue());
        }
        ProcessInstancePluginUtil.updateProcInst((IFormView)((FormView)this.getView()), procInstIds);
    }

    private void showTransferLog(ListSelectedRowCollection rows) {
        ArrayList<Long> list = new ArrayList<Long>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            list.add((Long)rows.get(i).getPrimaryKeyValue());
        }
        ProcessInstancePluginUtil.showTransferLog((IFormView)((FormView)this.getView()), list);
    }

    private void showAddressProcedureLog(ListSelectedRowCollection rows) {
        StandardTips view = StandardTips.view((IFormView)this.getView());
        if (rows == null || rows.isEmpty()) {
            view.notSelectRow();
            return;
        }
        if (rows.size() > 1) {
            view.selectMultiRow(rows.size());
            return;
        }
        Long id = (Long)rows.get(0).getPrimaryKeyValue();
        ExecutionEntity processInstance = this.getRuntimeService().getProcessInstance(id);
        String billNoOrBussinessKey = "";
        String entityNumber = "";
        if (processInstance == null) {
            HistoricProcessInstanceEntity historicProcessInstance = this.getHistoryService().getHistoricProcessInstance(id);
            if (historicProcessInstance != null) {
                billNoOrBussinessKey = StringUtils.isNotEmpty((CharSequence)historicProcessInstance.getBillNo()) ? historicProcessInstance.getBillNo() : historicProcessInstance.getBusinessKey();
                entityNumber = historicProcessInstance.getEntitynumber();
            }
        } else {
            billNoOrBussinessKey = StringUtils.isNotEmpty((CharSequence)processInstance.getBillNo()) ? processInstance.getBillNo() : processInstance.getBusinessKey();
            entityNumber = processInstance.getEntityNumber();
        }
        List result = this.getRuntimeService().findAddressParseLog(entityNumber, billNoOrBussinessKey);
        List<AddressProcedureVo> collect = result.stream().map(AddressProcedureVo::fromEntity).collect(Collectors.toList());
        this.toAddressProcedureView(collect, entityNumber, billNoOrBussinessKey);
    }

    private void toAddressProcedureView(List<AddressProcedureVo> vos, String entityNumber, String billNo) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_log_addressprocedure");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("vo", (Object)SerializationUtils.toJsonString(vos));
        param.setCustomParam(ENTITY_NUMBER, (Object)entityNumber);
        param.setCustomParam(BILL_NO, (Object)billNo);
        String caption = ResManager.loadKDString((String)"\u6d41\u7a0b\u5bfb\u5740\u8fc7\u7a0b", (String)"WorkflowProcessInstancePlugin_60", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        param.setCaption(caption);
        this.getView().showForm(param);
    }

    public void showCondParseLog(ListSelectedRowCollection rows) {
        StandardTips tips = StandardTips.view((IFormView)this.getView());
        if (rows == null || rows.isEmpty()) {
            tips.notSelectRow();
            return;
        }
        if (rows.size() > 1) {
            tips.selectMultiRow(rows.size());
            return;
        }
        Long id = (Long)rows.get(0).getPrimaryKeyValue();
        String businessKey = "";
        String entityNumber = "";
        String billNo = "";
        ExecutionEntity processInstance = this.getRuntimeService().getProcessInstance(id);
        if (processInstance == null) {
            HistoricProcessInstanceEntity historicProcessInstance = this.getHistoryService().getHistoricProcessInstance(id);
            if (historicProcessInstance != null) {
                businessKey = historicProcessInstance.getBusinessKey();
                entityNumber = historicProcessInstance.getEntitynumber();
                billNo = historicProcessInstance.getBillNo();
            }
        } else {
            businessKey = processInstance.getBusinessKey();
            entityNumber = processInstance.getEntityNumber();
            billNo = processInstance.getBillNo();
        }
        String billNoOrBusinessKey = StringUtils.isEmpty((CharSequence)billNo) ? businessKey : billNo;
        this.toConditionParseProcedureView(entityNumber, billNoOrBusinessKey);
    }

    public void toConditionParseProcedureView(String entityNumber, String billNoOrBusinessKey) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_condparseprocedure");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam(ENTITY_NUMBER, (Object)entityNumber);
        param.setCustomParam(BILLNO_OR_BUSINESSKEY, (Object)billNoOrBusinessKey);
        this.getView().showForm(param);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            switch (callBackId) {
                case "feiqi": {
                    if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"/8M3RG6213GO")) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u5f3a\u5236\u7ec8\u6b62\u6d41\u7a0b\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowProcessInstancePlugin_10", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                    this.batchAbandon(rows);
                    if (rows.size() != 1) break;
                    this.refresh();
                    break;
                }
                case "jumpSuspend": {
                    this.skipSuspend();
                    break;
                }
                case "suspend": {
                    this.confirmSuspend();
                    break;
                }
            }
        }
    }

    private void abandonConfirm() {
        String id = this.getPageCache().get(this.CURRENT_PROCESSINSTANCE_ID);
        ProcessInstancePluginUtil.realAbandon((IFormView)this.getView(), (String)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void skipSuspend() {
        try {
            Long pk = Long.valueOf(this.getPageCache().get(CURSELPROCESSINSTANCEID));
            String destId = this.getPageCache().get(DESTNODEID);
            String srcId = this.getPageCache().get(SRCID);
            String reason = this.getPageCache().get(REASON);
            Map reasonMap = (Map)SerializationUtils.fromJsonString((String)reason, Map.class);
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            wfService.getManagementService().jumpToNode(pk.longValue(), destId, true, srcId, (ILocaleString)LocaleString.fromMap((Map)reasonMap));
            WfUtils.addOpLogByAppId((String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)BAR_SKIP, (MultiLangEnumBridge)new MultiLangEnumBridge("\u8df3\u8f6c", "JumpToNodeCmd_4", "bos-wf-engine"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u5b9e\u4f8bId[%1$s]%2$s", "JumpToNodeCmd_5", "bos-wf-engine"), (Object[])new Object[]{pk, destId});
            ((IListView)this.getView()).clearSelection();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8df3\u8f6c\u6210\u529f\u3002", (String)"WorkflowProcessInstancePlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            this.refresh();
        }
        finally {
            this.getPageCache().remove(CURSELPROCESSINSTANCEID);
            this.getPageCache().remove(DESTNODEID);
        }
    }

    private void confirmSuspend() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"0YS1GTBP53D6")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6302\u8d77\u201d\u7684\u6743\u9650\u3002", (String)"WorkflowProcessInstancePlugin_46", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        ArrayList<Long> pkValues = new ArrayList<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            pkValues.add((Long)row.getPrimaryKeyValue());
        }
        ProcessInstancePluginUtil.confirmSuspend((IFormView)this.getView(), pkValues, (boolean)true, (IFormPlugin)this);
    }

    private void skip(ListSelectedRowCollection rows) {
        ArrayList<Long> procInstIds = new ArrayList<Long>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            procInstIds.add((Long)rows.get(i).getPrimaryKeyValue());
        }
        ProcessInstancePluginUtil.skip((IFormView)((FormView)this.getView()), procInstIds, (IFormPlugin)this);
    }

    private void openErrorMSGList(ListSelectedRowCollection rows) {
        ArrayList<Long> list = new ArrayList<Long>(rows.size());
        for (int i = 0; i < rows.size(); ++i) {
            list.add((Long)rows.get(i).getPrimaryKeyValue());
        }
        ProcessInstancePluginUtil.openErrorMSGList(list, (IFormView)this.getView());
    }

    private void suspend(ListSelectedRowCollection rows) {
        ArrayList<Long> pkValues = new ArrayList<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            pkValues.add((Long)row.getPrimaryKeyValue());
        }
        ProcessInstancePluginUtil.suspend((IFormView)this.getView(), pkValues);
    }

    private void revokeSuspend(ListSelectedRowCollection rows) {
        String entityNumber = this.getPermissionEntity();
        String appId = this.getPermissionAppId();
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)appId, (String)entityNumber, (String)"/8M3MNJNJZE5")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u6fc0\u6d3b\u6d41\u7a0b\u7684\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_54", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)appId, (String)entityNumber, (String)BAR_REVOKE_SUSPEND, (MultiLangEnumBridge)new MultiLangEnumBridge("\u64a4\u9500\u6302\u8d77", "WorkflowProcessInstancePlugin_36", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u60a8\u6ca1\u6709\u201c\u64a4\u9500\u6302\u8d77\u201d\u7684\u6743\u9650\u3002", "ProcessInstancePluginUtil_36", "bos-wf-formplugin"), (Object[])new Object[0]);
            return;
        }
        if (rows != null && !rows.isEmpty()) {
            ArrayList<Long> pkValue = new ArrayList<Long>(rows.size());
            for (ListSelectedRow row : rows) {
                pkValue.add((Long)row.getPrimaryKeyValue());
            }
            ProcessInstancePluginUtil.revokeSuspend((IFormView)this.getView(), pkValue);
        } else {
            this.getView().showTipNotification(WFMultiLangConstants.getNoDataSelectedTip());
        }
    }

    private void transfer() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)"/AGOO46A0IE8")) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u4efb\u52a1\u7684\u6743\u9650\u3002", (String)"WorkflowProcessInstancePlugin_39", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getTransferName()));
            return;
        }
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        if (rows == null || rows.size() != 1) {
            Integer integer = Optional.ofNullable(rows).map(ArrayList::size).orElseGet(() -> 0);
            StandardTips.view((IFormView)this.getView()).selectMultiRow(integer.intValue());
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_transfertask");
        parameter.setCustomParam("processInstanceId", rows.get(0).getPrimaryKeyValue());
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, parameter.getFormId()));
        this.getView().showForm(parameter);
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        if (!DesignerPluginUtil.checkWorkflowInService((IFormView)this.getView())) {
            return;
        }
        super.listRowDoubleClick(evt);
        this.respondListRowClick();
        evt.setCancel(true);
    }

    public void listRowClick(ListRowClickEvent evt) {
        if (!DesignerPluginUtil.checkWorkflowInService((IFormView)this.getView())) {
            return;
        }
        this.respondListRowClick();
    }

    private void respondListRowClick() {
        ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
        Long pkid = this.getFocusRowPKID();
        FormView formView = (FormView)this.getView();
        ArrayList<Long> executionIds = new ArrayList<Long>();
        for (ListSelectedRow s : rows) {
            executionIds.add((Long)s.getPrimaryKeyValue());
        }
        ProcessInstancePluginUtil.buttonAvailable(executionIds, (Object)pkid, (IFormView)formView, (int)rows.size());
        this.controlEnableAbanBtns(executionIds);
    }

    private void controlEnableAbanBtns(List<Long> executionIds) {
        if (executionIds.size() == 1) {
            String workFlowType = ViewFlowchartUtil.getWorkFlowType((Long)executionIds.get(0));
            if (ProcessType.BizFlow.name().equals(workFlowType)) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"abandonbill"});
                this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SKIP});
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{"abandonbill"});
                this.getView().setEnable(Boolean.TRUE, new String[]{BAR_SKIP});
            }
        } else if (executionIds.size() >= 2) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"abandonbill"});
            this.getView().setEnable(Boolean.FALSE, new String[]{BAR_SKIP});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"abandonbill"});
            this.getView().setEnable(Boolean.TRUE, new String[]{BAR_SKIP});
        }
    }

    private Long getFocusRowPKID() {
        Long pkValue;
        block2: {
            ListSelectedRowCollection selectedRows;
            block1: {
                pkValue = 0L;
                selectedRows = ((IListView)this.getView()).getSelectedRows();
                if (selectedRows.size() != 1) break block1;
                Object obj = selectedRows.get(0).getPrimaryKeyValue();
                if (!(obj instanceof Long)) break block2;
                pkValue = (Long)obj;
                break block2;
            }
            int rowInd = ((ListView)this.getView()).getFocusRow();
            for (ListSelectedRow row : selectedRows) {
                if (rowInd != row.getRowKey()) continue;
                pkValue = (Long)row.getPrimaryKeyValue();
                break;
            }
        }
        return pkValue;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        block18: {
            super.closedCallBack(e);
            Object returnData = e.getReturnData();
            if ("wf_transfertask".equalsIgnoreCase(e.getActionId()) && returnData instanceof String) {
                this.getView().showTipNotification((String)returnData);
            } else if ("wf_skipnode".equalsIgnoreCase(e.getActionId()) && returnData instanceof Map) {
                Map ret = (Map)returnData;
                if (ret != null && !ret.isEmpty()) {
                    ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                    if (rows == null || rows.size() != 1) {
                        return;
                    }
                    Long pk = (Long)rows.get(0).getPrimaryKeyValue();
                    Map obj = ret;
                    String destId = (String)obj.get("id");
                    String srcId = (String)obj.get("srcId");
                    Map reason = (Map)obj.get(REASON);
                    WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
                    try {
                        this.getPageCache().put(CURSELPROCESSINSTANCEID, String.valueOf(pk));
                        this.getPageCache().put(DESTNODEID, destId);
                        this.getPageCache().put(SRCID, srcId);
                        this.getPageCache().put(REASON, SerializationUtils.toJsonString((Object)reason));
                        wfService.getManagementService().jumpToNode(pk.longValue(), destId, false, srcId, (ILocaleString)LocaleString.fromMap((Map)reason));
                        WfUtils.addOpLogByAppId((String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)BAR_SKIP, (MultiLangEnumBridge)new MultiLangEnumBridge("\u8df3\u8f6c", "JumpToNodeCmd_4", "bos-wf-engine"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u6d41\u7a0b\u5b9e\u4f8bId[%1$s]%2$s", "JumpToNodeCmd_5", "bos-wf-engine"), (Object[])new Object[]{pk, destId});
                        ((IListView)this.getView()).clearSelection();
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8df3\u8f6c\u6210\u529f\u3002", (String)"WorkflowProcessInstancePlugin_18", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                        this.refresh();
                        this.getPageCache().remove(CURSELPROCESSINSTANCEID);
                        this.getPageCache().remove(DESTNODEID);
                        this.getPageCache().remove(SRCID);
                    }
                    catch (Exception e1) {
                        if (e1 instanceof KDException) {
                            ErrorCode code = ((KDException)((Object)e1)).getErrorCode();
                            if (code != null) {
                                if (WFErrorCode.processSuspendSimple().equals((Object)code) || WFErrorCode.processSuspend().equals((Object)code)) {
                                    this.getView().showConfirm(e1.getMessage(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(JUMPSUSPEND));
                                } else {
                                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8df3\u8f6c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowProcessInstancePlugin_40", (String)"bos-wf-formplugin", (Object[])new Object[0]), e1.getMessage()));
                                    this.getPageCache().remove(CURSELPROCESSINSTANCEID);
                                    this.getPageCache().remove(DESTNODEID);
                                }
                            }
                            break block18;
                        }
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8df3\u8f6c\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s\u3002", (String)"WorkflowProcessInstancePlugin_40", (String)"bos-wf-formplugin", (Object[])new Object[0]), e1.getMessage()));
                        this.getPageCache().remove(CURSELPROCESSINSTANCEID);
                        this.getPageCache().remove(DESTNODEID);
                    }
                }
            } else if ("wf_abandon".equalsIgnoreCase(e.getActionId()) && returnData != null) {
                this.getView().showSuccessNotification(WFMultiLangConstants.getAbandonCauseSuccess());
                this.refresh();
            } else if ("wf_adminabandon_option".equals(e.getActionId())) {
                ListSelectedRowCollection rows = ((IListView)this.getView()).getSelectedRows();
                this.batchAbandon(returnData, rows);
                if (rows.size() == 1) {
                    this.refresh();
                }
            } else if (CALLBACK_TASK.equals(e.getActionId())) {
                this.taskCallBack(returnData);
                this.refresh();
            }
        }
    }

    public void batchAbandon(Object returnData, ListSelectedRowCollection rows) {
        if (rows.size() == 1) {
            String id = this.getPageCache().get(this.CURRENT_PROCESSINSTANCE_ID);
            ProcessInstancePluginUtil.adminAbandonOpionCallback((IFormView)this.getView(), (String)id, (Object)returnData);
            this.getPageCache().remove(this.CURRENT_PROCESSINSTANCE_ID);
            this.refresh();
        } else {
            if (returnData == null) {
                return;
            }
            if (!(returnData instanceof Map)) {
                return;
            }
            List<Long> ids = rows.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
            Map dataMap = (Map)returnData;
            LocaleString msg = null;
            if (dataMap.get("abandonMessage") instanceof Map) {
                msg = new LocaleString();
                msg.putAll((Map)dataMap.get("abandonMessage"));
            }
            boolean abandonMainProcess = Boolean.TRUE.equals(dataMap.get("abandonMainProcess"));
            this.dispatch(ids, (ILocaleString)msg, abandonMainProcess);
            WfUtils.addOpLogByAppId((String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)BAR_FORCETERMINATE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f3a\u5236\u7ec8\u6b62\u6d41\u7a0b", "AbandonProcessCmd_4", "bos-wf-engine"), null, (Object[])new Object[]{String.format("proInstanceId:[%s]", ids.toString())});
            this.getView().getPageCache().remove("processInstanceIds");
            this.getView().getPageCache().remove("procInstIdsWithSubProcTag");
        }
    }

    public void batchAbandon(ListSelectedRowCollection rows) {
        if (rows.size() == 1) {
            String id = this.getPageCache().get(this.CURRENT_PROCESSINSTANCE_ID);
            ProcessInstancePluginUtil.realAbandon((IFormView)this.getView(), (String)id);
            this.getPageCache().remove(this.CURRENT_PROCESSINSTANCE_ID);
        } else {
            List<Long> ids = rows.stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
            this.dispatch(ids, (ILocaleString)new LocaleString(), Boolean.FALSE);
            WfUtils.addOpLogByAppId((String)this.getPermissionAppId(), (String)this.getPermissionEntity(), (String)BAR_FORCETERMINATE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f3a\u5236\u7ec8\u6b62\u6d41\u7a0b", "AbandonProcessCmd_4", "bos-wf-engine"), null, (Object[])new Object[]{String.format("proInstanceId:[%s]", ids.toString())});
        }
    }

    private void draw(ErrorAbandonVo res) {
        List errorAbandonProcesses = res.getErrorAbandonProcesses();
        if (errorAbandonProcesses == null || errorAbandonProcesses.isEmpty()) {
            String sussess = ResManager.loadKDString((String)"\u5f3a\u5236\u7ec8\u6b62\u6210\u529f\u3002", (String)"WorkflowTCDataPlugin_50", (String)"bos-wf-formplugin", (Object[])new Object[0]);
            this.getView().showSuccessNotification(sussess);
        } else {
            FormShowParameter param = new FormShowParameter();
            param.setFormId("wf_errorabondontips");
            param.setCustomParam("errorAbandonVo", (Object)SerializationUtils.toJsonString((Object)res));
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(param);
        }
    }

    private void taskCallBack(Object returnData) {
        ErrorAbandonVo res;
        if (returnData == null) {
            return;
        }
        if (!(returnData instanceof Map)) {
            return;
        }
        Map map = (Map)returnData;
        if (!map.containsKey("taskinfo")) {
            return;
        }
        String taskInfoStr = (String)map.get("taskinfo");
        if (StringUtils.isBlank((CharSequence)taskInfoStr)) {
            return;
        }
        TaskInfo taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class);
        String data = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)data)) {
            return;
        }
        ObjectMapper JSON2 = new ObjectMapper();
        try {
            res = (ErrorAbandonVo)JSON2.readValue(data, ErrorAbandonVo.class);
        }
        catch (JsonProcessingException e) {
            this.logger.warn("ErrorAbandonVo\u53cd\u5e8f\u5217\u5316\u5931\u8d25\uff1a" + (Object)((Object)e));
            return;
        }
        if (res == null) {
            return;
        }
        this.draw(res);
    }

    private void dispatch(List<Long> proInstanceIds, ILocaleString msg, boolean abandonMainProcess) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("wf");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        String s = ResManager.loadKDString((String)"\u5f3a\u5236\u7ec8\u6b62\u6d41\u7a0b", (String)"WorkflowProcessInstancePlugin_55", (String)"bos-wf-formplugin", (Object[])new Object[0]);
        jobInfo.setName(s);
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.bos.workflow.monitor.plugin.task.BatchAbandonTask");
        jobInfo.setRunByLang(RequestContext.get().getLang());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("proInstanceIds", proInstanceIds);
        params.put("msg", msg);
        params.put("abandonMainProcess", abandonMainProcess);
        String subProcInstIdsStr = this.getView().getPageCache().get("procInstIdsWithSubProcTag");
        if (StringUtils.isNotEmpty((CharSequence)subProcInstIdsStr)) {
            params.put("procInstIdsWithSubProcTag", subProcInstIdsStr);
        }
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, CALLBACK_TASK);
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(s);
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(true);
        jobFormInfo.setClickClassName("kd.bos.workflow.monitor.plugin.task.BatchAbandonTaskClick");
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private void refresh() {
        WorkflowTCDataPluginUtil.clearSelectData((IFormView)this.getView());
        IListView listView = (IListView)this.getView();
        listView.refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (!DesignerPluginUtil.checkWorkflowInService((IFormView)this.getView())) {
            args.setCancel(true);
            return;
        }
    }

    @Override
    public void filterContainerInit(FilterContainerInitArgs args) {
        String state = (String)this.getView().getFormShowParameter().getCustomParam("state");
        if (state != null) {
            for (FilterColumn filter : args.getCommonFilterColumns()) {
                if (!"suspensionstate".equals(filter.getFieldName())) continue;
                filter.setDefaultValue(state);
                break;
            }
        }
        super.filterContainerInit(args);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        PluginUtil.setControlInvisible(this.getView(), "exit");
        if (!Lang.zh_CN.name().equals(RequestContext.get().getLang().name()) && !WfConfigurationUtil.isEnableShowMutiLangLog()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"more"});
            this.getView().setVisible(Boolean.FALSE, new String[]{BAR_ERROR_MESSAGE});
            this.getView().setVisible(Boolean.FALSE, new String[]{TRANSFERLOG});
        }
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId((IFormView)this.getView());
    }

    private String getPermissionEntity() {
        return ProcessInstancePluginUtil.getPermissionEntity((IFormView)this.getView());
    }
}

