/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.operation;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.workflow.component.approvalrecord.ApprovalAttachmentInfo;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordGroup;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordGroup;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.ApprovalRecordHtmlAdapter;
import kd.bos.workflow.engine.impl.util.SignatureUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class ViewApprovalRecordPlugin
extends AbstractWorkflowPlugin
implements HyperLinkClickListener {
    private static final String PAGECACHE_SHOWALLRECORD = "showallrecord";
    public static final String PAGECACHE_BUSINESSKEY = "businessKey";
    public static final String PAGECACHE_ENTITYNUMBER = "entityNumber";
    private static final String CONTROLLER_ENTRYENTITY = "entryentity";
    private static final String CONTROLLER_TOOLBARAP = "toolbarap";
    public static final String PROCESSINSTANCECOUNT = "processInstanceCount";
    public static final String APPROVALRECORDGROUPS = "approvalRecordGroups";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{CONTROLLER_TOOLBARAP});
        EntryGrid approvalRecordEntryGrid = (EntryGrid)this.getControl(CONTROLLER_ENTRYENTITY);
        approvalRecordEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        String businessKey = (String)this.getView().getFormShowParameter().getCustomParam(PAGECACHE_BUSINESSKEY);
        if (WfUtils.isEmpty((String)businessKey)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u5355\u636eID\u201d\u5b57\u6bb5\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002", (String)"ViewApprovalRecordOp_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(PAGECACHE_ENTITYNUMBER);
        this.getPageCache().put(PAGECACHE_BUSINESSKEY, businessKey);
        this.getPageCache().put(PAGECACHE_ENTITYNUMBER, entityNumber);
        this.getPageCache().put(PAGECACHE_SHOWALLRECORD, "false");
        this.showApprovalRecord(false, null);
    }

    public void itemClick(ItemClickEvent evt) {
        String id;
        if (null == evt) {
            return;
        }
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        switch (id = evt.getItemKey()) {
            case "baritem_showallrecord": {
                if ("true".equals(this.getPageCache().get(PAGECACHE_SHOWALLRECORD))) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u663e\u793a\u5168\u90e8\u5ba1\u6279\u8bb0\u5f55\u3002", (String)"ViewApprovalRecordPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                TaskService taskService = super.getTaskService();
                List entities = taskService.getParentProcessInstanceInfo(this.getPageCache().get(PAGECACHE_BUSINESSKEY), this.getPageCache().get(PAGECACHE_ENTITYNUMBER), "processinstanceid,processdefinitionid,createdate,endtype", "createdate", false);
                if (null != entities && this.getView().getFormShowParameter().getCustomParam(PROCESSINSTANCECOUNT).equals(entities.size())) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u663e\u793a\u5168\u90e8\u5ba1\u6279\u8bb0\u5f55\u3002", (String)"ViewApprovalRecordPlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.getPageCache().put(PAGECACHE_SHOWALLRECORD, "true");
                this.showApprovalRecord(true, entities);
                break;
            }
            case "baritem_refresh": {
                this.getView().getFormShowParameter().getCustomParams().remove(APPROVALRECORDGROUPS);
                this.showApprovalRecord(Boolean.parseBoolean(this.getPageCache().get(PAGECACHE_SHOWALLRECORD)), null);
                break;
            }
        }
    }

    private void showApprovalRecord(boolean allRecord, List<HistoricProcessInstanceEntity> entities) {
        List<Map<String, Object>> approvalRecords = this.getApprovalRecord(allRecord, entities);
        if (null == approvalRecords || approvalRecords.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6ca1\u6709\u6d41\u7a0b\u5ba1\u6279\u8bb0\u5f55\u3002", (String)"ViewApprovalRecordPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        this.setEntryEntity(approvalRecords);
    }

    private List<Map<String, Object>> getApprovalRecord(boolean allRecord, List<HistoricProcessInstanceEntity> entities) {
        FormShowParameter parameter;
        Object approvalRecordGroupsObj;
        List approvalRecordGroups = null;
        if (!allRecord && null != (approvalRecordGroupsObj = (parameter = this.getView().getFormShowParameter()).getCustomParam(APPROVALRECORDGROUPS))) {
            approvalRecordGroups = this.transformRecordFromParameter(approvalRecordGroupsObj);
        }
        if (null == approvalRecordGroups || approvalRecordGroups.isEmpty()) {
            approvalRecordGroups = this.getTaskService().queryApprovalRecord(this.getPageCache().get(PAGECACHE_BUSINESSKEY), this.getPageCache().get(PAGECACHE_ENTITYNUMBER), allRecord, entities);
        }
        return this.getApprovalRecordForFormat(approvalRecordGroups);
    }

    private List<IApprovalRecordGroup> transformRecordFromParameter(Object approvalRecordGroupsObj) {
        if (!(approvalRecordGroupsObj instanceof JSONArray)) {
            return null;
        }
        JSONArray jsonArrayGroup = (JSONArray)approvalRecordGroupsObj;
        JSONObject jsonObjGroup = null;
        JSONArray jsonArrayItem = null;
        JSONObject jsonObjItem = null;
        JSONArray jsonArrayItemAttachments = null;
        JSONObject jsonObjItemAttachments = null;
        ArrayList<IApprovalRecordGroup> groups = new ArrayList<IApprovalRecordGroup>(jsonArrayGroup.size());
        ApprovalRecordGroup group = null;
        ArrayList<ApprovalRecordItem> items = null;
        ApprovalRecordItem item = null;
        ArrayList<ApprovalAttachmentInfo> attachmentInfos = null;
        ApprovalAttachmentInfo attachmentInfo = null;
        for (Object jObj : jsonArrayGroup) {
            if (null == jObj || !(jObj instanceof JSONObject)) continue;
            jsonObjGroup = (JSONObject)jObj;
            group = new ApprovalRecordGroup();
            group.setActivityName(jsonObjGroup.getString("activityName"));
            group.setThroughRule(jsonObjGroup.getString("throughRule"));
            group.setShowAutoCoordinate(jsonObjGroup.getBoolean("showAutoCoordinate"));
            group.setGroupDecisionType(jsonObjGroup.getString("groupDecisionType"));
            jsonArrayItem = jsonObjGroup.getJSONArray("children");
            if (null != jsonArrayItem && !jsonArrayItem.isEmpty()) {
                items = new ArrayList<ApprovalRecordItem>(jsonArrayItem.size());
                for (Object jObjItem : jsonArrayItem) {
                    if (null == jObjItem || !(jObjItem instanceof JSONObject)) continue;
                    item = new ApprovalRecordItem();
                    jsonObjItem = (JSONObject)jObjItem;
                    item.setActivityName(jsonObjItem.getString("activityName"));
                    item.setSubactivityname(jsonObjItem.getString("subactivityname"));
                    item.setAssignee(jsonObjItem.getString("assignee"));
                    item.setResult(jsonObjItem.getString("result"));
                    item.setMessage(jsonObjItem.getString("message"));
                    item.setAddSignMsg(jsonObjItem.getString("addSignMsg"));
                    String signature = jsonObjItem.getString("signature");
                    SignatureUtils.handleApprovalRecordSignatureUrl((IApprovalRecordItem)item, (String)signature);
                    item.setTime(jsonObjItem.getString("time"));
                    item.setNodeType(jsonObjItem.getString("nodeType"));
                    item.setDelegate(jsonObjItem.getBoolean("delegate").booleanValue());
                    item.setShowTransferRecord(jsonObjItem.getBoolean("showTransferRecord").booleanValue());
                    item.setCoordinate(jsonObjItem.getBoolean("coordinate").booleanValue());
                    item.setTaskId(jsonObjItem.getString("taskId"));
                    item.setUserId(jsonObjItem.getLong("userId"));
                    item.setCallActivity(jsonObjItem.getBoolean("callActivity").booleanValue());
                    item.setProcInstId(jsonObjItem.getString("procInstId"));
                    item.setHandleState(jsonObjItem.getString("handleState"));
                    item.setProcDefId(jsonObjItem.getString("procDefId"));
                    jsonArrayItemAttachments = jsonObjItem.getJSONArray("attachments");
                    if (null != jsonArrayItemAttachments && !jsonArrayItemAttachments.isEmpty()) {
                        attachmentInfos = new ArrayList<ApprovalAttachmentInfo>(jsonArrayItemAttachments.size());
                        for (Object attachmentObj : jsonArrayItemAttachments) {
                            if (null == attachmentObj || !(attachmentObj instanceof JSONObject)) continue;
                            jsonObjItemAttachments = (JSONObject)attachmentObj;
                            attachmentInfo = new ApprovalAttachmentInfo();
                            attachmentInfo.setId(jsonObjItemAttachments.getString("id"));
                            attachmentInfos.add(attachmentInfo);
                        }
                        item.setAttachments(attachmentInfos);
                    }
                    items.add(item);
                }
                group.setChildren(items);
            }
            groups.add((IApprovalRecordGroup)group);
        }
        return groups;
    }

    private List<Map<String, Object>> getApprovalRecordForFormat(List<IApprovalRecordGroup> approvalRecordGroups) {
        if (null == approvalRecordGroups || approvalRecordGroups.isEmpty()) {
            return null;
        }
        HashSet<Long> procDefIds = new HashSet<Long>(approvalRecordGroups.size());
        for (IApprovalRecordGroup approvalRecordGroup : approvalRecordGroups) {
            List childrens = approvalRecordGroup.getChildren();
            if (childrens == null || childrens.isEmpty()) continue;
            for (Object children : childrens) {
                String procDefId = children.getProcDefId();
                if (!WfUtils.isNotEmpty((String)procDefId)) continue;
                procDefIds.add(Long.valueOf(procDefId));
            }
        }
        WorkflowService service = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        RepositoryService repositoryService = service.getRepositoryService();
        List procDefIdEntitys = repositoryService.findProcDefByIds(new ArrayList(procDefIds));
        HashMap<String, Boolean> procDefIdAndSubProcessMap = new HashMap<String, Boolean>(procDefIdEntitys.size());
        for (ProcessDefinitionEntity procDefIdEntity : procDefIdEntitys) {
            if (!"sub".equals(procDefIdEntity.getPrimarySubprocess())) continue;
            procDefIdAndSubProcessMap.put(String.valueOf(procDefIdEntity.getId()), Boolean.TRUE);
        }
        ArrayList<Map<String, Object>> approvalRecordList = new ArrayList<Map<String, Object>>(approvalRecordGroups.size() * 2);
        HashMap<String, Object> approvalRecordMap = null;
        List items = null;
        StringBuilder taskAttribute = null;
        String viewhistorytransfer = null;
        String viewhistorycoordinate = null;
        String activityName = null;
        List approvalRecordItemsForCallActivities = null;
        List<Map<String, Object>> approvalRecordItemsForCallActivityList = null;
        String message = null;
        String messageForAddSign = null;
        Tips tips = new Tips();
        String nodeType = null;
        ApprovalRecordItem recordItem = null;
        for (IApprovalRecordGroup group : approvalRecordGroups) {
            if (null == group || null == (items = group.getChildren()) || items.isEmpty() || null == items || items.isEmpty()) continue;
            for (IApprovalRecordItem item : items) {
                if (null == item) continue;
                recordItem = (ApprovalRecordItem)item;
                if (recordItem.isCallActivity()) {
                    approvalRecordItemsForCallActivities = this.getTaskService().queryApprovalRecord(Long.valueOf(recordItem.getProcInstId()), null);
                    approvalRecordItemsForCallActivityList = this.getApprovalRecordForFormat(approvalRecordItemsForCallActivities);
                    if (null == approvalRecordItemsForCallActivityList || approvalRecordItemsForCallActivityList.isEmpty()) continue;
                    approvalRecordList.addAll(approvalRecordItemsForCallActivityList);
                    continue;
                }
                approvalRecordMap = new HashMap<String, Object>(9);
                activityName = item.getSubactivityname();
                if (WfUtils.isEmpty((String)activityName)) {
                    activityName = item.getActivityName();
                }
                if (WfUtils.isEmpty((String)activityName)) {
                    activityName = group.getActivityName();
                }
                approvalRecordMap.put("activityname", activityName);
                approvalRecordMap.put("assignee", item.getAssignee());
                approvalRecordMap.put("result", item.getResult());
                message = item.getMessage();
                messageForAddSign = item.getAddSignMsg();
                if (WfUtils.isNotEmpty((String)messageForAddSign)) {
                    message = WfUtils.isEmpty((String)message) ? messageForAddSign : message + "\r\n" + messageForAddSign;
                }
                approvalRecordMap.put("message", null == message ? "" : ApprovalRecordHtmlAdapter.filterHtml((String)message));
                approvalRecordMap.put("formatstrtime", WfUtils.isEmpty((String)group.getGroupDecisionType()) || "wait".equals(group.getGroupDecisionType()) ? "" : item.getTime());
                nodeType = item.getNodeType();
                if (null != nodeType && nodeType.contains("YunzhijiaTask")) {
                    approvalRecordMap.put("throughrule", group.getThroughRule());
                }
                taskAttribute = new StringBuilder();
                if (item.isDelegate()) {
                    taskAttribute.append(ResManager.loadKDString((String)"\u59d4\u6258", (String)"ViewApprovalRecordPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                }
                approvalRecordMap.put("attachments", ApprovalPluginUtil.getAttachment(item.getAttachments()));
                if (item.isShowTransferRecord()) {
                    if (!taskAttribute.toString().isEmpty()) {
                        taskAttribute.append(" ");
                    }
                    taskAttribute.append(ResManager.loadKDString((String)"\u8f6c\u4ea4", (String)"ViewApprovalRecordPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                    viewhistorytransfer = ResManager.loadKDString((String)"\u67e5\u770b\u8f6c\u4ea4\u8bb0\u5f55", (String)"ViewApprovalRecordPlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                    approvalRecordMap.put("viewhistorytransfer", viewhistorytransfer);
                }
                if (item.isCoordinate() || ((ApprovalRecordGroup)group).getShowAutoCoordinate().booleanValue()) {
                    viewhistorycoordinate = ResManager.loadKDString((String)"\u67e5\u770b\u534f\u529e\u8bb0\u5f55", (String)"ViewApprovalRecordPlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]);
                    approvalRecordMap.put("viewhistorycoordinate", viewhistorycoordinate);
                }
                approvalRecordMap.put("taskattribute", taskAttribute.toString());
                approvalRecordMap.put("coordinate", item.isCoordinate());
                approvalRecordMap.put("taskid", item.getTaskId());
                approvalRecordMap.put("userid", item.getUserId());
                String signature = item.getSignature();
                if (WfUtils.isNotEmpty((String)signature)) {
                    approvalRecordMap.put("signature", signature);
                }
                String procDefId = item.getProcDefId();
                approvalRecordMap.put("issubprocess", procDefIdAndSubProcessMap.get(procDefId));
                approvalRecordMap.put("showautocoordinate", ((ApprovalRecordGroup)group).getShowAutoCoordinate());
                approvalRecordList.add(approvalRecordMap);
            }
        }
        return approvalRecordList;
    }

    private void setEntryEntity(List<Map<String, Object>> entryEntityDatas) {
        ApprovalPluginUtil.setEntryEntity(this.getView(), CONTROLLER_ENTRYENTITY, entryEntityDatas);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if (null == hyperLinkClickEvent) {
            return;
        }
        if (null == this.getView()) {
            return;
        }
        IDataModel model = this.getView().getModel();
        if (null == model) {
            return;
        }
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        String fieldName = hyperLinkClickEvent.getFieldName();
        int currentRowIndex = hyperLinkClickEvent.getRowIndex();
        String taskId = (String)model.getValue("taskid", currentRowIndex);
        String userId = (String)model.getValue("userid", currentRowIndex);
        switch (fieldName) {
            case "viewhistorytransfer": {
                ApprovalPluginUtil.showTransferRecord(this.getView(), taskId, userId, false);
                break;
            }
            case "viewhistorycoordinate": {
                this.showCoordinateRecord(taskId, (Boolean)model.getValue("showautocoordinate", currentRowIndex));
                break;
            }
        }
    }

    private void showCoordinateRecord(String taskId, boolean containAutoCoordinate) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_viewcoordinaterrecord");
        parameter.setCustomParam("taskid", (Object)taskId);
        parameter.setCustomParam("containAutoCoordinate", (Object)containAutoCoordinate);
        ArchiveFormService.create().setArchiveRouteInfo(this.getView(), parameter);
        this.getView().showForm(parameter);
    }
}

