/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.workflow.component.WfCondition;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.design.util.BaseChangeLogsUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ConditionalRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterOperationMetaEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskCenterRuleEntityImpl;
import kd.bos.workflow.taskcenter.plugin.rule.ConditionRegister;
import kd.bos.workflow.taskcenter.plugin.rule.util.ConditionConvertUtils;

public class WfTaskCenterRulePlugin
extends AbstractWorkflowPlugin {
    private static final String EXPRESSION = "expression";
    private static final String OP_PARAMS = "opParams";
    private static final String OP_KEY = "opKey";
    private static final String RULE_ID = "ruleId";
    private static final String OPERATION = "operation";
    private static final String CONDITION = "condition";

    public void initialize() {
        super.initialize();
        Button btn = (Button)this.getControl("btnexit");
        btn.addClickListener((ClickListener)this);
        Button btn1 = (Button)this.getControl("btncancel");
        btn1.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        WfCondition conditionap = (WfCondition)this.getControl(CONDITION);
        WfCondition operationap = (WfCondition)this.getControl(OPERATION);
        operationap.setFilterColumns(this.getTaskService().getTaskCenterOperations());
        Long ruleId = (Long)this.getView().getFormShowParameter().getCustomParam(RULE_ID);
        if (WfUtils.isNotEmpty((Long)ruleId)) {
            this.getPageCache().put(RULE_ID, ruleId + "");
            TaskCenterRuleEntity centerEntity = (TaskCenterRuleEntity)this.getRepositoryService().findEntityById(ruleId, "wf_taskattributerule");
            IDataModel model = this.getModel();
            ILocaleString ruleName = centerEntity.getName();
            if (ruleName != null && WfUtils.isEmpty((String)ruleName.getLocaleValue())) {
                ruleName.setLocaleValue(ruleName.toString());
            }
            model.setValue("rulename", (Object)ruleName);
            model.setValue("rulenumber", (Object)centerEntity.getNumber());
            List conditionals = centerEntity.getConditionalRuleModel().getEntryentity();
            String taskEntityNumber = "";
            for (ConditionalEntity entity : conditionals) {
                Map valMap;
                Object obj;
                if (!"task.entityNumber".equalsIgnoreCase(entity.getParamnumber())) continue;
                String taskEntityNumberValue = entity.getValue();
                if (WfUtils.isEmpty((String)taskEntityNumberValue) || !((obj = (valMap = (Map)SerializationUtils.fromJsonString((String)taskEntityNumberValue, Map.class)).get("task.entityNumber")) instanceof List) || ((List)obj).size() <= 0) break;
                Map tmp = (Map)((List)obj).get(0);
                taskEntityNumber = (String)tmp.get("number");
                break;
            }
            conditionap.setEntityIdAndFilters(taskEntityNumber, true, null);
            List conditionItms = ConditionConvertUtils.getConditionItems((List)conditionals);
            conditionap.SetValue(conditionItms);
            List operationMetas = centerEntity.getOperationMetas();
            operationap.SetValue(ConditionConvertUtils.getOperationItems((List)operationMetas));
        } else {
            conditionap.setFilterColumns(ConditionRegister.getGeneralConditions((boolean)true));
        }
        this.getPageCache().put("entry", this.putBaseModelCache().toJSONString());
    }

    private JSONObject putBaseModelCache() {
        WfCondition conditionap = (WfCondition)this.getControl(CONDITION);
        WfCondition operationap = (WfCondition)this.getControl(OPERATION);
        List conditionItems = conditionap.getValue();
        String mapExpression = ConditionConvertUtils.getExpressionFromMap((List)conditionItems);
        List operationItems = operationap.getValue();
        List TaskCenterOperationMetaEntitys = ConditionConvertUtils.getTaskCenterOperationMetas((List)operationItems);
        JSONArray arr = new JSONArray();
        for (TaskCenterOperationMetaEntity operationMeta : TaskCenterOperationMetaEntitys) {
            JSONObject entity = new JSONObject();
            entity.put("id", (Object)operationMeta.getId());
            entity.put(OP_KEY, (Object)operationMeta.getOperationkey());
            entity.put(OP_PARAMS, (Object)operationMeta.getOperateparams());
            arr.add((Object)entity);
        }
        JSONObject obj = new JSONObject();
        obj.put(EXPRESSION, (Object)mapExpression);
        obj.put(OPERATION, (Object)arr);
        return obj;
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey().toLowerCase()) {
            case "btnexit": {
                this.saveOrUpdateRule();
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
        }
    }

    private void saveOrUpdateRule() {
        ILocaleString title;
        boolean isapplyexisttasks = (Boolean)this.getModel().getValue("applyexisttasks");
        ILocaleString rulename = (ILocaleString)this.getModel().getValue("rulename");
        if (WfUtils.isEmpty((ILocaleString)rulename)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WfTaskCenterRulePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String ruleIdStr = this.getPageCache().get(RULE_ID);
        TaskCenterRuleEntityImpl taskCenterEntity = null;
        if (WfUtils.isNotEmpty((String)ruleIdStr)) {
            Long ruleId = Long.valueOf(ruleIdStr);
            taskCenterEntity = (TaskCenterRuleEntity)this.getRepositoryService().findEntityById(ruleId, "wf_taskattributerule");
        } else {
            taskCenterEntity = new TaskCenterRuleEntityImpl();
        }
        String rulenumber = taskCenterEntity.getNumber();
        if (WfUtils.isEmpty((String)rulenumber)) {
            rulenumber = UUID.randomUUID().toString();
        }
        WfCondition conditionap = (WfCondition)this.getControl(CONDITION);
        WfCondition operationap = (WfCondition)this.getControl(OPERATION);
        List conditionItems = conditionap.getValue();
        List operationItems = operationap.getValue();
        if (conditionItems == null || conditionItems.size() < 1 || operationItems == null || operationItems.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6761\u4ef6\u201d\u548c\u201c\u64cd\u4f5c\u201d\u3002", (String)"WfTaskCenterRulePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        int i = 1;
        for (Object conditionItem : conditionItems) {
            Object value = conditionItem.get("value");
            if (value instanceof Map) {
                Map map = (Map)value;
                String compareType = conditionItem.get("compareType").toString();
                long count = map.values().stream().filter(o -> WfUtils.isNullObject((Object)o) || WfUtils.isEmptyString((Object)o)).count();
                if (count != 0L && !compareType.contains("empty")) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6dfb\u52a0\u503c\u3002", (String)"WfTaskCenterRulePlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]), i), Integer.valueOf(3000));
                    return;
                }
            }
            ++i;
        }
        int j = 1;
        for (Map operationItem : operationItems) {
            Object value = operationItem.get("value");
            if (value instanceof Map) {
                Map map = (Map)value;
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.equals("transferMsg") || key.equals("message") || !WfUtils.isNullObject(entry.getValue()) && !WfUtils.isEmptyString(entry.getValue())) continue;
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7684\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6dfb\u52a0\u503c\u3002", (String)"WfTaskCenterRulePlugin_5", (String)"bos-wf-formplugin", (Object[])new Object[0]), j), Integer.valueOf(3000));
                    return;
                }
            }
            ++j;
        }
        String mapExpression = ConditionConvertUtils.getExpressionFromMap((List)conditionItems);
        if (mapExpression.length() > 2000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002\u6761\u4ef6\u89c4\u5219\u5185\u5bb9\u5b57\u7b26\u603b\u957f\u5ea6\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u7b80\u5316\u6761\u4ef6\u89c4\u5219\u5185\u5bb9\u3002", (String)"WfTaskCenterRulePlugin_21", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        ConditionalRuleEntity conditionRuleModel = ConditionConvertUtils.getConditionalRule((List)conditionItems, (ConditionalRuleEntity)taskCenterEntity.getConditionalRuleModel());
        List TaskCenterOperationMetaEntitys = ConditionConvertUtils.getTaskCenterOperationMetas((List)operationItems);
        taskCenterEntity.setConditionalRuleModel(conditionRuleModel);
        taskCenterEntity.setOperationMetas(TaskCenterOperationMetaEntitys);
        if (rulename != null && WfUtils.isNotEmpty((String)rulename.toString())) {
            taskCenterEntity.setName(rulename);
        }
        taskCenterEntity.setNumber(rulenumber);
        taskCenterEntity.setUserid(userId);
        taskCenterEntity.setExpression(mapExpression);
        String active = taskCenterEntity.getActivitstate();
        active = WfUtils.isEmpty((String)active) ? "enable" : active;
        taskCenterEntity.setActivitstate(active);
        this.getRepositoryService().saveOrUpdateTaskCenterRule((TaskCenterRuleEntity)taskCenterEntity);
        if (WfUtils.isNotEmpty((String)ruleIdStr)) {
            title = WfUtils.getPromptWordLocaleString((String)"\u4fee\u6539\u81ea\u52a8\u89c4\u5219", (String)"WfTaskCenterRulePlugin_6", (String)"bos-wf-formplugin");
            title = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)title, (String)String.format(":%s(%s)", taskCenterEntity.getName(), taskCenterEntity.getNumber()));
            this.addLog(taskCenterEntity.getId(), "modify", title);
            WfUtils.addOpLog((String)"wf_taskattributerule", (String)"modifyRule", (MultiLangEnumBridge)new MultiLangEnumBridge("\u4fee\u6539\u81ea\u52a8\u89c4\u5219", "WfTaskCenterRulePlugin_6", "bos-wf-formplugin"), null, (Object[])new Object[]{String.format("Id:[%s]%s", taskCenterEntity.getId(), taskCenterEntity.getName())});
        } else {
            title = WfUtils.getPromptWordLocaleString((String)"\u589e\u52a0\u81ea\u52a8\u89c4\u5219", (String)"WfTaskCenterRulePlugin_7", (String)"bos-wf-formplugin");
            title = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)title, (String)String.format(":%s(%s)", taskCenterEntity.getName(), taskCenterEntity.getNumber()));
            this.addLog(taskCenterEntity.getId(), "insert", title);
            WfUtils.addOpLog((String)"wf_taskattributerule", (String)"insertRule", (MultiLangEnumBridge)new MultiLangEnumBridge("\u589e\u52a0\u81ea\u52a8\u89c4\u5219", "WfTaskCenterRulePlugin_7", "bos-wf-formplugin"), null, (Object[])new Object[]{String.format("Id:[%s]%s", taskCenterEntity.getId(), taskCenterEntity.getName())});
        }
        if (isapplyexisttasks) {
            Long taskCount = this.getTaskService().getTaskCenterDataCount(RequestContext.get().getUserId(), "toHandle", "", "", new ArrayList());
            if (taskCount > 10L) {
                HashMap<String, Long> params = new HashMap<String, Long>();
                params.put("userId", userId);
                params.put(RULE_ID, taskCenterEntity.getId());
                this.showForm("applyexisttasks", "wf_operationconfirm", params);
            } else {
                this.getTaskService().executeTaskRule(userId, taskCenterEntity.getId(), false);
                this.getView().returnDataToParent((Object)"ok");
                this.getView().close();
            }
        } else {
            this.getView().returnDataToParent((Object)"ok");
            this.getView().close();
        }
    }

    private void addLog(Long id, String op, ILocaleString title) {
        ILocaleString detail = this.setDetail();
        BaseChangeLogsUtil.addLog((Long)id, (String)"taskrule", (String)op, (ILocaleString)title, (ILocaleString)detail, (String)RequestContext.get().getUserId());
    }

    private ILocaleString setDetail() {
        JSONObject op;
        int i;
        String entry = this.getPageCache().get("entry");
        JSONObject obj = JSONObject.parseObject((String)entry);
        JSONArray opArr = (JSONArray)obj.get((Object)OPERATION);
        String exp = String.valueOf(obj.get((Object)EXPRESSION));
        JSONObject newObj = this.putBaseModelCache();
        JSONArray newArr = (JSONArray)newObj.get((Object)OPERATION);
        String newExp = String.valueOf(newObj.get((Object)EXPRESSION));
        HashSet<String> oldSet = new HashSet<String>(opArr.size());
        HashSet<String> newSet = new HashSet<String>(newArr.size());
        ArrayList<JSONObject> addList = new ArrayList<JSONObject>();
        HashMap<String, JSONObject> oldMap = new HashMap<String, JSONObject>(opArr.size());
        HashMap<String, JSONObject> newMap = new HashMap<String, JSONObject>(newArr.size());
        for (i = 0; i < opArr.size(); ++i) {
            op = opArr.getJSONObject(i);
            oldSet.add(op.getString("id"));
            oldMap.put(op.getString("id"), op);
        }
        for (i = 0; i < newArr.size(); ++i) {
            op = newArr.getJSONObject(i);
            String id = op.getString("id");
            if (WfUtils.isEmpty((String)id)) {
                addList.add(op);
                continue;
            }
            newSet.add(op.getString("id"));
            newMap.put(op.getString("id"), op);
        }
        HashSet<String> delSet = new HashSet<String>();
        delSet.addAll(oldSet);
        delSet.removeAll(newSet);
        HashSet<String> changeSet = new HashSet<String>();
        changeSet.addAll(oldSet);
        changeSet.retainAll(newSet);
        LocaleString expDetail = new LocaleString();
        if (!exp.equals(newExp)) {
            expDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)expDetail, (ILocaleString)WfUtils.getPromptWordLocaleString((String)"\u8868\u8fbe\u5f0f:", (String)"WfTaskCenterRulePlugin_8", (String)"bos-wf-formplugin"));
            expDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)expDetail, (String)(newExp + ";"));
        }
        LocaleString opDetail = new LocaleString();
        if (!changeSet.isEmpty()) {
            opDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)opDetail, (ILocaleString)WfUtils.getPromptWordLocaleString((String)"\u4fee\u6539\u6267\u884c\u64cd\u4f5c\uff1a", (String)"WfTaskCenterRulePlugin_9", (String)"bos-wf-formplugin"));
            boolean flag = false;
            for (String o : changeSet) {
                JSONObject oldOp = (JSONObject)oldMap.get(o);
                JSONObject newOp = (JSONObject)newMap.get(o);
                if (oldOp.getString(OP_KEY).equals(newOp.getString(OP_KEY)) && oldOp.getString(OP_PARAMS).equals(newOp.getString(OP_PARAMS))) continue;
                flag = true;
                opDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)opDetail, (String)("id:" + o));
                opDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)opDetail, (ILocaleString)WfUtils.getPromptWordLocaleString((String)"\uff1b\u64cd\u4f5c\u6807\u8bc6\uff1a", (String)"WfTaskCenterRulePlugin_10", (String)"bos-wf-formplugin"));
                opDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)opDetail, (String)newOp.getString(OP_KEY));
                opDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)opDetail, (ILocaleString)WfUtils.getPromptWordLocaleString((String)"\uff1b\u64cd\u4f5c\u53c2\u6570\uff1a", (String)"WfTaskCenterRulePlugin_11", (String)"bos-wf-formplugin"));
                opDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)opDetail, (String)(newOp.getString(OP_PARAMS) + ";"));
            }
            if (!flag) {
                opDetail = new LocaleString();
            }
        }
        if (!addList.isEmpty()) {
            opDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)opDetail, (ILocaleString)WfUtils.getPromptWordLocaleString((String)"\u589e\u52a0\u6267\u884c\u64cd\u4f5c\uff1a", (String)"WfTaskCenterRulePlugin_12", (String)"bos-wf-formplugin"));
            for (JSONObject jSONObject : addList) {
                opDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)opDetail, (ILocaleString)WfUtils.getPromptWordLocaleString((String)"\u64cd\u4f5c\u6807\u8bc6\uff1a", (String)"WfTaskCenterRulePlugin_13", (String)"bos-wf-formplugin"));
                opDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)opDetail, (String)jSONObject.getString(OP_KEY));
                opDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)opDetail, (ILocaleString)WfUtils.getPromptWordLocaleString((String)"\uff1b\u64cd\u4f5c\u53c2\u6570\uff1a", (String)"WfTaskCenterRulePlugin_11", (String)"bos-wf-formplugin"));
                opDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)opDetail, (String)(jSONObject.getString(OP_PARAMS) + ";"));
            }
        }
        if (!delSet.isEmpty()) {
            opDetail = BaseChangeLogsUtil.mulitLangAppend((ILocaleString)opDetail, (ILocaleString)WfUtils.getPromptWordLocaleString((String)"\u5220\u9664\u6267\u884c\u64cd\u4f5c\uff1a", (String)"WfTaskCenterRulePlugin_14", (String)"bos-wf-formplugin"));
            for (String string : delSet) {
                opDetail = BaseChangeLogsUtil.mulitLangAppendString((ILocaleString)opDetail, (String)("id:" + string + ";"));
            }
        }
        return BaseChangeLogsUtil.mulitLangAppend((ILocaleString)expDetail, (ILocaleString)opDetail);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().close();
    }
}

