/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.component.approvalrecord.IApprovalRecordItem;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.task.component.ApprovalRecordItem;
import kd.bos.workflow.engine.impl.util.CoordinateRecordUtil;
import kd.bos.workflow.engine.impl.util.SignatureUtils;
import kd.bos.workflow.service.archive.ArchiveFormService;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;

public class WorkflowViewCoordinateRecordsPlugin
extends AbstractWorkflowPlugin
implements HyperLinkClickListener {
    private static final String ENTRYENTITY = "entryentity";
    public static final String CUSTOMPARAM_TASKID = "taskid";
    public static final String CUSTOMPARAM_CONTAINAUTOCOORDINATE = "containAutoCoordinate";

    public void registerListener(EventObject e) {
        EntryGrid approvalRecordEntryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        approvalRecordEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        ArchiveFormService.create().injectArchiveRouteInfo(this.getView());
        this.showCoordinateRecords();
    }

    private void showCoordinateRecords() {
        List<Map<String, Object>> coordinateRecords = this.getCoordinateRecord();
        if (null == coordinateRecords || coordinateRecords.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5%s\u4efb\u52a1\u53ef\u80fd\u5df2\u7ecf\u88ab\u64a4\u56de\u6216\u4e0d\u652f\u6301\u67e5\u770b\u3002", (String)"WorkflowViewCoordinateRecordsPlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]), WfConfigurationUtil.getCoordinateName()));
            return;
        }
        this.setEntryEntity(coordinateRecords);
    }

    private List<Map<String, Object>> getCoordinateRecord() {
        boolean containAutoCoordinate;
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOMPARAM_TASKID);
        List coordinateRecords = CoordinateRecordUtil.getCoordinateRecordsWithoutTag((String)taskId, (boolean)(containAutoCoordinate = ((Boolean)this.getView().getFormShowParameter().getCustomParam(CUSTOMPARAM_CONTAINAUTOCOORDINATE)).booleanValue()));
        if (null == coordinateRecords || coordinateRecords.isEmpty()) {
            return null;
        }
        ArrayList<Map<String, Object>> coordinateRecordList = new ArrayList<Map<String, Object>>(coordinateRecords.size() * 2);
        HashMap<String, Object> coordinateRecordMap = null;
        String assignee = null;
        String coordInviteOpinion = null;
        Object message = null;
        for (IApprovalRecordItem item : coordinateRecords) {
            ILocaleString coordInviteOpinionLocal;
            QFilter[] filters;
            DynamicObject coordInviteOpinionObj;
            if (null == item) continue;
            coordinateRecordMap = new HashMap<String, Object>(7);
            assignee = item.getAssignee();
            if (assignee.contains(ResManager.loadKDString((String)" \u6b63\u5728\u534f\u529e", (String)"GetCoordinatorRecordCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]))) {
                assignee = assignee.split(ResManager.loadKDString((String)" \u6b63\u5728\u534f\u529e", (String)"GetCoordinatorRecordCmd_3", (String)"bos-wf-engine", (Object[])new Object[0]))[0];
            }
            coordinateRecordMap.put("ownername", item.getOwnerName());
            coordinateRecordMap.put("assignee", assignee);
            coordInviteOpinion = ((ApprovalRecordItem)item).getCoordInviteOpinion();
            if (WfUtils.isEmpty((String)coordInviteOpinion) && null != (coordInviteOpinionObj = BusinessDataServiceHelper.loadSingleFromCache((String)"wf_participant", (String)"transferopinion", (QFilter[])(filters = new QFilter[]{new QFilter(CUSTOMPARAM_TASKID, "=", (Object)Long.valueOf(taskId)), new QFilter("userid", "=", (Object)item.getUserId()), new QFilter("type", "=", (Object)"coordinate")}))) && null != (coordInviteOpinionLocal = coordInviteOpinionObj.getLocaleString("transferopinion"))) {
                coordInviteOpinion = coordInviteOpinionLocal.toString();
            }
            coordinateRecordMap.put("coordinviteopinion", coordInviteOpinion);
            coordinateRecordMap.put("message", item.getMessage());
            String signature = item.getSignature();
            SignatureUtils.handleApprovalRecordSignatureUrl(coordinateRecordMap, (String)signature);
            coordinateRecordMap.put("time", item.getTime());
            coordinateRecordMap.put("attachments", ApprovalPluginUtil.getAttachment(item.getAttachments()));
            if (item.isShowTransferRecord()) {
                coordinateRecordMap.put("viewhistorytransfer", ResManager.loadKDString((String)"\u67e5\u770b\u8f6c\u4ea4\u5386\u53f2", (String)"ViewApprovalRecordPlugin_6", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            }
            coordinateRecordMap.put("userid", item.getUserId());
            coordinateRecordList.add(coordinateRecordMap);
        }
        return coordinateRecordList;
    }

    private void setEntryEntity(List<Map<String, Object>> entryEntityDatas) {
        ApprovalPluginUtil.setEntryEntity(this.getView(), ENTRYENTITY, entryEntityDatas);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String taskId = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOMPARAM_TASKID);
        int currentRowIndex = hyperLinkClickEvent.getRowIndex();
        String userId = (String)this.getView().getModel().getValue("userid", currentRowIndex);
        ApprovalPluginUtil.showTransferRecord(this.getView(), taskId, userId, true);
    }
}

