/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.data;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintWork;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WfUtils;

public class BatchPrintDataTask
extends AbstractTask {
    private static ObjectMapper objectMapper = new ObjectMapper();
    public static final String OLDPRINTTYPE = "A";
    public static final String NEWPRINTTYPE = "B";
    private static final Log log = LogFactory.getLog(BatchPrintDataTask.class);

    public void execute(RequestContext ctx, Map<String, Object> params) throws KDException {
        try {
            this.executeTask(params);
        }
        catch (Exception e) {
            HashMap<String, Object> customData = new HashMap<String, Object>();
            customData.put("success", false);
            customData.put("errormsg", e.getMessage());
            this.feedbackCustomdata(customData);
            log.error(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    public void executeTask(Map<String, Object> params) {
        if (params != null) {
            String printLang = (String)params.get("printLang");
            HashMap<String, Object> customData = new HashMap<String, Object>();
            if (params.get("printWork") != null) {
                PrintWork work = (PrintWork)objectMapper.convertValue(params.get("printWork"), PrintWork.class);
                String printUrl = PluginUtil.openPrintNewUrl(work, printLang);
                customData.put("newPrintUrl", printUrl);
            }
            if (WfUtils.isNotEmptyString((Object)params.get("printJobs"))) {
                List list = (List)params.get("printJobs");
                ArrayList<PrintJob> jobs = new ArrayList<PrintJob>(list.size());
                for (Object object : list) {
                    PrintJob job = (PrintJob)objectMapper.convertValue(object, PrintJob.class);
                    jobs.add(job);
                }
                if (WfUtils.isNotEmptyForCollection(jobs)) {
                    String printUrl = PluginUtil.openPrintOldUrl(jobs, printLang);
                    customData.put("oldPrintUrl", printUrl);
                }
            }
            customData.put("success", true);
            this.feedbackCustomdata(customData);
        }
    }
}

