/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.taskcenter.plugin.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.MobileBillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.print.OldPrintOperationHelper;
import kd.bos.form.plugin.print.PrintOperationHelper;
import kd.bos.list.IListView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mservice.print.BosPrintBusinessService;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.PrintJob;
import kd.bos.print.api.PrintParam;
import kd.bos.print.api.PrintTask;
import kd.bos.print.api.facade.param.PrintLogParam;
import kd.bos.print.business.utils.PrintOpLogUtils;
import kd.bos.print.service.BosPrintServiceHelper;
import kd.bos.print.service.util.PrintClientUtil;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.svc.util.print.PrtTaskResult;
import kd.bos.svc.util.print.PrtTaskResultServiceHelper;
import kd.bos.template.orgctrl.model.PrintTemplateInfo;
import kd.bos.template.orgctrl.model.TemplateInfo;
import kd.bos.template.orgctrl.service.PrintTemplateServiceFactory;
import kd.bos.url.UrlService;

public class WorkflowPrintSelectTemplatePlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String SELECT_TEMPLATE = "selecttemplate";
    private static final String SELECT_TEMPLATE_FLEX = "flexpanelap2";
    private static final String FORMID = "formid";
    private static final Log log = LogFactory.getLog(WorkflowPrintSelectTemplatePlugin.class);
    private static final String SELECT_PRINTER = "selectprinter";
    private static final String CLOUD_PRINTER = "cloudPrinter";
    private PrintClientUtil.CloudPrinter cloudPrinter;
    private boolean existNewTpl = false;
    private boolean existOldTpl = false;
    private List<Object> ids = new ArrayList<Object>(10);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnconfilm", "btncancel"});
    }

    public void afterCreateNewData(EventObject e) {
        PrintClientUtil.CloudPrinter cloudPrinter;
        super.afterCreateNewData(e);
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        String text = (String)this.getView().getFormShowParameter().getCustomParam("text");
        if (StringUtils.isBlank((CharSequence)formId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6\u4e3a\u7a7a\u3002", (String)"WorkflowPrintSelectTemplatePlugin_0", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        Label label = (Label)this.getControl("labelap");
        label.setText(text);
        if (text != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"imageap"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"imageap"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap"});
        }
        boolean isShowPrintType = this.isShowPrintType();
        if (!isShowPrintType) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"printtypepanelap"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{SELECT_TEMPLATE_FLEX});
        }
        this.initDefaultCombo();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        String printLang = BosPrintServiceHelper.getPrintLang((Long)userId, (String)formId);
        if (printLang == null) {
            printLang = RequestContext.get().getLang().toString();
        }
        this.getPageCache().put("CACHE_LANG", printLang);
        Long printerId = BosPrintServiceHelper.getPrinterId((Long)userId, (String)formId);
        this.getModel().setValue(SELECT_PRINTER, (Object)printerId);
        if (printerId != null && (cloudPrinter = PrintClientUtil.getCloudPrinter((long)Long.parseLong(printerId.toString()))) != null) {
            this.getPageCache().put(CLOUD_PRINTER, SerializationUtils.toJsonString((Object)cloudPrinter));
        }
    }

    public PrintClientUtil.CloudPrinter getCloudPrinter() {
        if (this.cloudPrinter != null) {
            return this.cloudPrinter;
        }
        String str = this.getPageCache().get(CLOUD_PRINTER);
        if (StringUtils.isNotBlank((CharSequence)str)) {
            this.cloudPrinter = (PrintClientUtil.CloudPrinter)SerializationUtils.fromJsonString((String)str, PrintClientUtil.CloudPrinter.class);
        }
        if (this.cloudPrinter == null) {
            this.cloudPrinter = new PrintClientUtil.CloudPrinter();
        }
        return this.cloudPrinter;
    }

    private boolean isShowPrintType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        boolean isShowPrintType = false;
        if (customParams.containsKey("isShowPrintType")) {
            isShowPrintType = Boolean.parseBoolean(String.valueOf(customParams.get("isShowPrintType")));
        }
        return isShowPrintType;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Button btn = (Button)evt.getSource();
        if ("btnconfilm".equals(btn.getKey())) {
            boolean isShowPrintType = this.isShowPrintType();
            if (isShowPrintType) {
                Object printType = this.getView().getModel().getValue("radiogroupfield");
                if (StringUtils.equals((CharSequence)String.valueOf(printType), (CharSequence)"1")) {
                    this.doPrint(null);
                } else {
                    String templateId = (String)this.getModel().getValue(SELECT_TEMPLATE);
                    if (StringUtils.isBlank((CharSequence)templateId)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"PrintSelectTemplatePlugin_3", (String)"bos-noteprint", (Object[])new Object[0]));
                        return;
                    }
                    this.setParamJob(templateId, "newPrintJobs");
                    this.setParamJob(templateId, "oldPrintJobs");
                    this.doPrint(null);
                }
                return;
            }
            String templateId = (String)this.getModel().getValue(SELECT_TEMPLATE);
            if (StringUtils.isBlank((CharSequence)templateId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"WorkflowPrintSelectTemplatePlugin_1", (String)"bos-wf-formplugin", (Object[])new Object[0]));
                return;
            }
            this.doPrint(templateId);
        } else {
            this.getView().close();
        }
    }

    private void log() {
        AppLogInfo appLogInfo = this.getBean("appLogInfo", AppLogInfo.class);
        PrintLogParam logParam = this.getBean("printLogParam", PrintLogParam.class);
        PrintOpLogUtils.addOpLog((PrintLogParam)logParam, (AppLogInfo)appLogInfo);
    }

    private <T> T getBean(String key, Class<T> t) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object appLogInfoJson = parameter.getCustomParam(key);
        if (StringUtils.isBlank((Object)appLogInfoJson)) {
            return null;
        }
        Object appLogInfo = SerializationUtils.fromJsonString((String)((String)appLogInfoJson), t);
        return (T)appLogInfo;
    }

    private IFormView getParentView() {
        try {
            IFormView parentView = this.getView().getParentView();
            if (parentView == null) {
                parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            }
            return parentView;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        }
    }

    private void setParamJob(String templateId, String jobKey) {
        List<PrintJob> jobs = this.getPrintJobs(jobKey);
        ArrayList<PrintJob> newJobs = new ArrayList<PrintJob>(1);
        for (PrintJob job : jobs) {
            if (!StringUtils.equals((CharSequence)String.valueOf(job.getTemplateId()), (CharSequence)templateId)) continue;
            newJobs.add(job);
        }
        this.getView().getFormShowParameter().setCustomParam(jobKey, (Object)SerializationUtils.toJsonString(newJobs));
    }

    private List<PrintJob> getPrintJobs(String jobKey) {
        Object printJobs = this.getView().getFormShowParameter().getCustomParam(jobKey);
        List<Object> jobs = new ArrayList<PrintJob>(0);
        if (StringUtils.isNotBlank((Object)printJobs)) {
            jobs = SerializationUtils.fromJsonStringToList((String)((String)printJobs), PrintJob.class);
        }
        return jobs;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        if (StringUtils.equals((CharSequence)property.getName(), (CharSequence)"radiogroupfield")) {
            ChangeData[] changeSet = e.getChangeSet();
            if (changeSet == null || changeSet[0] == null) {
                return;
            }
            String newValue = String.valueOf(changeSet[0].getNewValue());
            if (StringUtils.equals((CharSequence)newValue, (CharSequence)"1")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{SELECT_TEMPLATE_FLEX});
            }
            if (StringUtils.equals((CharSequence)newValue, (CharSequence)"2")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SELECT_TEMPLATE_FLEX});
            }
        }
    }

    private void initDefaultCombo() {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        String invisibleFilterTemplateId = (String)this.getView().getFormShowParameter().getCustomParam("invisibleFilterTemplateId");
        String matchFilterTemplateIdJson = (String)this.getView().getFormShowParameter().getCustomParam("matchFilterTemplateId");
        Set matchFilterTemplateId = new LinkedHashSet();
        if (StringUtils.isNotBlank((CharSequence)matchFilterTemplateIdJson)) {
            matchFilterTemplateId = (Set)SerializationUtils.fromJsonString((String)matchFilterTemplateIdJson, LinkedHashSet.class);
        }
        List invisibleFilterTemplateIdList = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)invisibleFilterTemplateId)) {
            invisibleFilterTemplateIdList = SerializationUtils.fromJsonStringToList((String)invisibleFilterTemplateId, String.class);
        }
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        PrintTemplateInfo tpl = PrintTemplateServiceFactory.getService().getPrintTemplate(userId, formId);
        List tplList = tpl.getTplList();
        if (tplList != null && !tplList.isEmpty()) {
            boolean isShowPrintType = this.isShowPrintType();
            ComboEdit defaultCombo = (ComboEdit)this.getView().getControl(SELECT_TEMPLATE);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
            if (isShowPrintType) {
                block0: for (String matchId : matchFilterTemplateId) {
                    for (TemplateInfo info : tplList) {
                        if (!info.getId().equals(matchId)) continue;
                        ComboItem item = new ComboItem();
                        item.setValue(matchId);
                        item.setCaption(new LocaleString(info.getName()));
                        comboItems.add(item);
                        continue block0;
                    }
                }
            } else {
                for (TemplateInfo info : tplList) {
                    if (invisibleFilterTemplateIdList.contains(info.getId())) continue;
                    ComboItem item = new ComboItem();
                    item.setValue(info.getId());
                    item.setCaption(new LocaleString(info.getName()));
                    comboItems.add(item);
                }
            }
            defaultCombo.setComboItems(comboItems);
        }
    }

    private void doPrint(String tplId) {
        boolean isNewTpl = this.isNewTpl(tplId);
        String taskId = String.valueOf(DB.genLongId((String)"t_svc_printresult"));
        try {
            this.doNewPreview(taskId, isNewTpl ? tplId : null);
            log.debug("\u65b0\u6a21\u7248\u6253\u5370\u6210\u529f\u3002");
            if (!this.doOldPreview(taskId, isNewTpl ? null : tplId)) {
                return;
            }
            log.debug("\u65e7\u6a21\u7248\u6253\u5370\u6210\u529f\u3002");
            PrtTaskResult taskResult = PrtTaskResultServiceHelper.getPrtResult((String)taskId);
            List attachList = taskResult.getAttach();
            IFormView parentView = this.getParentView();
            this.printPreview(taskId, attachList, parentView);
            List distinctIds = this.ids.stream().distinct().collect(Collectors.toList());
            PrintOperationHelper.updatePrintCountField((String)((String)this.getView().getFormShowParameter().getCustomParam(FORMID)), distinctIds);
            this.getView().close();
        }
        catch (Exception e) {
            if (e instanceof KDBizException) {
                IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                parentView.showTipNotification(e.getMessage());
                this.getView().sendFormAction(parentView);
                this.getView().close();
            }
            throw e;
        }
    }

    private void printPreview(String taskId, List<PrtTaskResult.Attach> attachList, IFormView parentView) {
        if (attachList.size() <= 3) {
            for (PrtTaskResult.Attach attach : attachList) {
                String downloadUrl = UrlService.getDomainContextUrl() + "/api/print/download.do?taskId=%s&attachId=%s";
                downloadUrl = downloadUrl + "&isMobile=true";
                downloadUrl = String.format(downloadUrl, taskId, attach.getAttachId());
                FormShowParameter para = new FormShowParameter();
                para.setFormId("bos_printpreview");
                para.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                HashMap<String, String> reservedSpace = new HashMap<String, String>();
                reservedSpace.put("reservedSpace", "true");
                para.getOpenStyle().setCustParam(reservedSpace);
                para.setCustomParam("src", (Object)downloadUrl);
                parentView.showForm(para);
                this.getView().sendFormAction(parentView);
            }
            return;
        }
        FormShowParameter para = new FormShowParameter();
        para.setCaption(ResManager.loadKDString((String)"\u6253\u5370\u7ed3\u679c", (String)"WorkflowPrintSelectTemplatePlugin_2", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        para.setFormId("bos_print_resultview");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("taskId", (Object)taskId);
        parentView.showForm(para);
        this.getView().sendFormAction(parentView);
    }

    private List<PrintJob> buildOldPrintJobs(String tplId) {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        Object pkids = this.getView().getFormShowParameter().getCustomParam("pkids");
        Object sortPkids = this.getView().getFormShowParameter().getCustomParam("sortPkids");
        Object type = this.getView().getFormShowParameter().getCustomParam("type");
        Object printJobs = this.getView().getFormShowParameter().getCustomParam("oldPrintJobs");
        String jobName = (String)this.getView().getFormShowParameter().getCustomParam("jobname");
        List<PrintJob> jobs = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)printJobs)) {
            jobs = SerializationUtils.fromJsonStringToList((String)((String)printJobs), PrintJob.class);
        }
        if (pkids != null && tplId != null) {
            String templateFormId = MetadataDao.getNumberById((String)tplId);
            if (StringUtils.isBlank((Object)templateFormId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6253\u5370\u6a21\u677f\u3002", (String)"PrintSelectTemplatePlugin_1", (String)"bos-noteprint", (Object[])new Object[0]));
            }
            PrintJob jb = new PrintJob(this.getView().getPageId(), formId);
            jb.setBillIds((List)pkids);
            jb.setName(jobName);
            jb.setTemplateId((Object)tplId);
            jobs.add(jb);
        }
        if (sortPkids instanceof List && !CollectionUtils.isEmpty((Collection)((List)sortPkids))) {
            jobs = PrintOperationHelper.sortAndMergeJobs((List)((List)sortPkids), jobs);
        }
        return jobs;
    }

    private boolean doOldPreview(String taskId, String tplId) {
        List<PrintJob> jobs = this.buildOldPrintJobs(tplId);
        if (jobs == null || jobs.isEmpty()) {
            return true;
        }
        this.existOldTpl = true;
        Map<String, Object> extParam = this.getExtParam();
        for (PrintJob job : jobs) {
            if (job.getBillIds() == null || job.getBillIds().isEmpty()) continue;
            this.ids.addAll(job.getBillIds());
        }
        OldPrintOperationHelper.doPrint((String)taskId, (String)"pdf", jobs, extParam);
        return true;
    }

    private Map<String, Object> getExtParam() {
        Object extParamJson = this.getView().getFormShowParameter().getCustomParam("extParam");
        if (StringUtils.isNotBlank((Object)extParamJson)) {
            return (Map)SerializationUtils.fromJsonString((String)((String)extParamJson), Map.class);
        }
        return new HashMap<String, Object>(0);
    }

    private PrintParam buildNewPrintJobs(String taskId, String tplId) {
        String formId = (String)this.getView().getFormShowParameter().getCustomParam(FORMID);
        Object pkids = this.getView().getFormShowParameter().getCustomParam("pkids");
        Object sortPkids = this.getView().getFormShowParameter().getCustomParam("sortPkids");
        Object printJobs = this.getView().getFormShowParameter().getCustomParam("newPrintJobs");
        ArrayList<PrintTask> taskList = new ArrayList<PrintTask>(10);
        List<PrintJob> jobs = new ArrayList(10);
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        if (pkids != null && tplId != null) {
            PrintJob job = new PrintJob();
            job.setBillIds((List)pkids);
            job.setFormId(formId);
            job.setPageId(parentPageId);
            job.setTemplateId((Object)tplId);
            jobs.add(job);
        }
        if (!ObjectUtils.isEmpty((Object)printJobs)) {
            List selectJobs = SerializationUtils.fromJsonStringToList((String)((String)printJobs), PrintJob.class);
            jobs.addAll(selectJobs);
        }
        if (sortPkids instanceof List && !CollectionUtils.isEmpty((Collection)((List)sortPkids))) {
            jobs = PrintOperationHelper.sortAndMergeJobs((List)((List)sortPkids), jobs);
        }
        for (PrintJob job : jobs) {
            PrintTask task = new PrintTask();
            task.setPkIds(job.getBillIds());
            task.setFormId(job.getFormId());
            task.setPageId(job.getPageId());
            task.setTplId(String.valueOf(job.getTemplateId()));
            task.setPrintType("billForm");
            taskList.add(task);
        }
        ArrayList<PrintTask> sortTaskList = new ArrayList<PrintTask>(10);
        if (taskList.isEmpty()) {
            return null;
        }
        sortTaskList.addAll(taskList);
        PrintParam param = new PrintParam();
        param.setPageId(((PrintTask)sortTaskList.get(0)).getPageId());
        param.setPrintLang(this.getPageCache().get("CACHE_LANG"));
        param.setPrinterName(this.getCloudPrinter().getPrinterName());
        param.setServiceN(this.getCloudPrinter().getServiceN());
        param.setAppNumber("wftask");
        param.setExpType("pdf");
        param.setTaskList(sortTaskList);
        IFormView parentView = this.getView().getViewNoPlugin(parentPageId);
        String billFormId = parentView.getFormShowParameter().getFormId();
        if (parentView instanceof IMobileView) {
            MobileBillShowParameter mo = (MobileBillShowParameter)parentView.getFormShowParameter();
            billFormId = mo.getFormConfig().getEntityTypeId();
        } else if (parentView instanceof IListView) {
            billFormId = ((ListView)parentView).getBillFormId();
        }
        param.setBillFormId(billFormId);
        Map<String, Object> extParam = this.getExtParam();
        param.setExtParam(extParam);
        return param;
    }

    private void doNewPreview(String taskId, String tplId) {
        PrintParam param = this.buildNewPrintJobs(taskId, tplId);
        if (param == null) {
            return;
        }
        List taskList = param.getTaskList();
        if (taskList.isEmpty()) {
            return;
        }
        this.existNewTpl = true;
        for (PrintTask task : taskList) {
            this.ids.addAll(task.getPkIds());
        }
        BosPrintBusinessService service = (BosPrintBusinessService)ServiceFactory.getService(BosPrintBusinessService.class);
        service.doPrint(taskId, (Object)param);
    }

    private boolean isNewTpl(String tplId) {
        if (tplId == null) {
            return false;
        }
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_manageprinttpl", (String)"id,type,printtplid_id", (QFilter[])new QFilter[]{new QFilter("PRINTTPLID", "=", (Object)tplId)});
        if (dynamicObject == null) {
            return false;
        }
        String type = dynamicObject.getString("type");
        return "B".equals(type);
    }
}

