/** 发票类型(发票云)基础资料表 **/
IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_ER_INVOICETYPE')
CREATE TABLE T_ER_INVOICETYPE (
                                  FID BIGINT DEFAULT 0 NOT NULL,
                                  FNUMBER NVARCHAR(80) DEFAULT ' ' NOT NULL,
                                  FSTATUS VARCHAR(36) DEFAULT ' ' NOT NULL,
                                  FCREATORID BIGINT DEFAULT 0 NOT NULL,
                                  FCREATETIME DATETIME,
                                  FMODIFIERID BIGINT DEFAULT 0 NOT NULL,
                                  FMODIFYTIME DATETIME,
                                  FENABLE CHAR(1) DEFAULT '0' NOT NULL,
                                  FMASTERID BIGINT DEFAULT 0 NOT NULL,
                                  FISDEFAULT CHAR(1) DEFAULT '0' NOT NULL,
                                  FREMARK NVARCHAR(255) DEFAULT ' ',
                                  FISEINVOICE CHAR(1) DEFAULT '0' NOT NULL,
                                  FISTRANSPORTINVOICE CHAR(1) DEFAULT '0' NOT NULL,
                                  FISVATINVOICE CHAR(1) DEFAULT '0' NOT NULL,
                                  FISSPECIALINVOICE CHAR(1) DEFAULT '0' NOT NULL,
                                  FISOFFSET CHAR(1) DEFAULT '0' NOT NULL,
                                  FUDRDISPLAY VARCHAR(2000) DEFAULT ' ' NOT NULL,
                                  FUSERDEFINERULE VARCHAR(2000) DEFAULT ' ' NOT NULL,
                                  FJS VARCHAR(2000) DEFAULT ' ' NOT NULL,
                                  FISPROFORMA CHAR(1) DEFAULT '0' NOT NULL,
                                  FUNIQUECONDITION VARCHAR(100) DEFAULT ' ' NOT NULL
);

/** 发票类型(发票云)基础资料多语言表 **/
IF NOT EXISTS (SELECT 1 FROM KSQL_USERTABLES WHERE KSQL_TABNAME = 'T_ER_INVOICETYPE_L')
CREATE TABLE T_ER_INVOICETYPE_L (
                                    FPKID VARCHAR(36) DEFAULT ' ' NOT NULL,
                                    FID BIGINT DEFAULT 0 NOT NULL,
                                    FNAME NVARCHAR(100) DEFAULT ' ' NOT NULL,
                                    FLOCALEID VARCHAR(10) DEFAULT ' ' NOT NULL
);

EXEC P_ALTERPK 'PK_ER_INVOICETYPE', 'T_ER_INVOICETYPE', 'FID', '1';

IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_ER_INVOICETYPE_FNUMBER') CREATE INDEX IDX_ER_INVOICETYPE_FNUMBER ON T_ER_INVOICETYPE ( FNUMBER );


EXEC P_ALTERPK 'PK_T_ER_INVOICETYPE_L', 'T_ER_INVOICETYPE_L', 'FPKID', '1';

IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = 'IDX_ER_INVOICETYPE_L_FID') CREATE INDEX IDX_ER_INVOICETYPE_L_FID ON T_ER_INVOICETYPE_L ( FID ,FLOCALEID );