/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.calformula;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.operate.Save;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;

public class CalculateFormulaEditPlugin
extends AbstractFormPlugin {
    private static final String FORMULA = "formula";
    private static final String BILL = "bill";
    private static final String SAVE_FORMULA = "saveformula";
    private static final String FORM_FORMULA_SET_SIGN = "bastax_formula_set";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{FORMULA});
    }

    public void click(EventObject evt) {
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId(FORM_FORMULA_SET_SIGN);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "formulaSet");
        formshowParameter.setCloseCallBack(closeCallBack);
        DynamicObject bill = (DynamicObject)this.getModel().getValue(BILL);
        if (null != bill) {
            formshowParameter.setCustomParam("treenodes", (Object)SerializationUtils.toJsonString((Object)this.buildDigitFieldsTree(bill.getString("number"), bill.getString("number"), bill.getString("name"), true, "")));
        }
        formshowParameter.setCustomParam(FORMULA, this.getModel().getValue(SAVE_FORMULA));
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    private TreeNode buildDigitFieldsTree(String rootEntityNumber, String entityNumber, String entityName, boolean isRoot, String prefix) {
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        if (null == entityType) {
            return null;
        }
        Map entityTypeMap = entityType.getAllFields();
        TreeNode root = new TreeNode(null, prefix + entityNumber, entityName);
        root.setIsOpened(isRoot);
        ArrayList<TreeNode> childrens = new ArrayList<TreeNode>();
        for (Map.Entry entry : entityTypeMap.entrySet()) {
            TreeNode child;
            String parentNumber;
            IDataEntityProperty property = (IDataEntityProperty)entry.getValue();
            String string = parentNumber = rootEntityNumber.equals(property.getParent().getExtendName()) ? "" : property.getParent().getExtendName() + ".";
            if (property instanceof DecimalProp) {
                childrens.add(new TreeNode(entityNumber, parentNumber + prefix + property.getName(), property.getDisplayName().getLocaleValue()));
                continue;
            }
            if (!isRoot || !(property instanceof BasedataProp) || null == (child = this.buildDigitFieldsTree("", ((BasedataProp)property).getBaseEntityId(), property.getDisplayName().getLocaleValue(), false, parentNumber + (String)entry.getKey() + "."))) continue;
            childrens.add(child);
        }
        root.setChildren(childrens);
        return root;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String formulaJson = (String)closedCallBackEvent.getReturnData();
        CRFormula formulaObj = this.deserialize(formulaJson);
        if (null != formulaJson && formulaObj != null && "formulaSet".equals(closedCallBackEvent.getActionId())) {
            this.getModel().setValue(SAVE_FORMULA, (Object)formulaJson);
            this.getModel().setValue(FORMULA, (Object)formulaObj.getExprTran());
        }
    }

    private CRFormula deserialize(String json) {
        CRFormula formulaObj = null;
        formulaObj = StringUtils.isBlank((CharSequence)json) ? new CRFormula() : (CRFormula)SerializationUtils.fromJsonString((String)json, CRFormula.class);
        return formulaObj;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            this.getModel().setValue("status", (Object)"C");
        }
    }
}

