/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.taxcode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bamp.bastax.business.taxtype.TaxTypeBusiness;
import kd.bamp.bastax.common.util.EmptyCheckUtils;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bamp.bastax.formplugin.common.AbstractTaxPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TaxcodePlugin
extends AbstractTaxPlugin
implements BeforeF7SelectListener {
    private static final String BASE_FIELD_TAXATION_SYS_SIGN = "taxationsys";
    private static final String BASE_FIELD_TAX_TYPE_SIGN = "taxtype";
    private static final String BASE_FIELD_TAX_AREA_GROUP_SIGN = "taxareagroup";
    private static final String FIELD_DEDUCTION_RATE_SIGN = "deductionrate";
    private static final String FIELD_DEFERRED_TAX_SIGN = "deferredtax";
    private static final String FIELD_WITH_HOLDING_TAX_SIGN = "withholdingtax";
    private static final String BASTAX_VALUE_DIALOG = "bastax_value_dialog";
    private static final String CHANGE = "change";

    public void registerListener(EventObject e) {
        BasedataEdit taxType = (BasedataEdit)this.getView().getControl(BASE_FIELD_TAX_TYPE_SIGN);
        taxType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxAreaGroup = (BasedataEdit)this.getView().getControl(BASE_FIELD_TAX_AREA_GROUP_SIGN);
        taxAreaGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"valuenumber"});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)BASE_FIELD_TAX_TYPE_SIGN)) {
            DynamicObject taxationSys = (DynamicObject)this.getModel().getValue(BASE_FIELD_TAXATION_SYS_SIGN);
            if (taxationSys == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"TaxcodePlugin_5", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter filter = new QFilter("taxationsysid", "=", taxationSys.get("id"));
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getListFilterParameter().setFilter(filter);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)BASE_FIELD_TAX_AREA_GROUP_SIGN)) {
            DynamicObject taxTypeObject = this.getModel().getDataEntity().getDynamicObject(BASE_FIELD_TAX_TYPE_SIGN);
            if (taxTypeObject == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u79cd\u3002", (String)"TaxcodePlugin_12", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            List<Long> areaGroupIds = this.getTaxAreaGroupIds();
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            if (!CollectionUtils.isEmpty(areaGroupIds)) {
                QFilter idQFilter = new QFilter("id", "in", areaGroupIds);
                listShowParameter.getListFilterParameter().setFilter(idQFilter);
            } else {
                listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)-1));
            }
        }
    }

    private List<Long> getTaxAreaGroupIds() {
        long taxTypeId = this.getModel().getDataEntity().getDynamicObject(BASE_FIELD_TAX_TYPE_SIGN).getLong("id");
        DynamicObject taxType = TaxTypeBusiness.getDataById((Long)taxTypeId, (String)"taxarea");
        return taxType.getDynamicObjectCollection("taxarea").stream().map(p -> p.getLong("fbasedataid.id")).collect(Collectors.toList());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (Stream.of(BASE_FIELD_TAXATION_SYS_SIGN, BASE_FIELD_TAX_TYPE_SIGN, BASE_FIELD_TAX_AREA_GROUP_SIGN).anyMatch(p -> p.equalsIgnoreCase(fieldKey))) {
            if ("true".equalsIgnoreCase(this.getPageCache().get(CHANGE))) {
                this.getPageCache().remove(CHANGE);
                return;
            }
            DynamicObjectCollection taxCodeDetails = this.getModel().getEntryEntity("entryentity1");
            if (!CollectionUtils.isEmpty((Collection)taxCodeDetails)) {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u7a0e\u6536\u5236\u5ea6\u3001\u7a0e\u79cd\u6216\u7a0e\u6536\u8f96\u533a\u5c06\u5bfc\u81f4\u7a0e\u7801\u660e\u7ec6\u548c\u76f8\u5173\u7ef4\u62a4\u6570\u636e\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"TaxcodePlugin_6", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmCallBackListener);
                DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
                this.getPageCache().put(fieldKey, ObjectUtils.isEmpty((Object)oldValue) ? "" : oldValue.getString("id"));
            } else {
                if (BASE_FIELD_TAXATION_SYS_SIGN.equalsIgnoreCase(fieldKey)) {
                    this.changeTaxationSysValue();
                } else if (BASE_FIELD_TAX_TYPE_SIGN.equalsIgnoreCase(fieldKey)) {
                    this.changeTaxTypeValue();
                }
                this.setInitValue();
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"result", (CharSequence)fieldKey)) {
            ChangeData[] changedData;
            for (ChangeData changedDatum : changedData = e.getChangeSet()) {
                DynamicObject newValue = (DynamicObject)changedDatum.getNewValue();
                if (!EmptyCheckUtils.isNotEmpty((Object)newValue)) continue;
                Long smmxjgid = 0L;
                int row = changedDatum.getRowIndex();
                if (ObjectUtils.isEmpty((Object)newValue)) continue;
                smmxjgid = newValue.getLong("id");
                if (1652818108961927168L == smmxjgid) {
                    this.getPageCache().put("isflag", "1");
                    this.getModel().setValue("valuetype", (Object)0, row);
                    this.getModel().setValue("valuesource", (Object)"bd_taxrate", row);
                } else if (1652818532024594432L == smmxjgid) {
                    this.getPageCache().put("isflag", "1");
                    this.getModel().setValue("valuetype", (Object)0, row);
                    this.getModel().setValue("valuesource", (Object)"bd_minimumtax", row);
                } else {
                    this.getPageCache().put("isflag", "0");
                    this.getModel().setValue("valuetype", null, row);
                    this.getModel().setValue("valuesource", null, row);
                }
                this.getModel().setValue("valuenumber", (Object)"", row);
                this.getModel().setValue("valueId", (Object)"", row);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"valuetype", (CharSequence)fieldKey)) {
            int row = this.getModel().getEntryCurrentRowIndex("entryentity1");
            String valuetype = (String)this.getView().getModel().getValue("valuetype", row);
            String isflag = this.getPageCache().get("isflag");
            if (StringUtil.isNotEmpty((CharSequence)valuetype) && !"1".equals(isflag)) {
                this.getModel().setValue("valuesource", null, row);
                this.getModel().setValue("valuenumber", (Object)"", row);
            }
        } else if ("deductible".equalsIgnoreCase(fieldKey)) {
            Boolean deductAble = (Boolean)this.getModel().getValue("deductible");
            if (!deductAble.booleanValue()) {
                this.getModel().setValue(FIELD_DEDUCTION_RATE_SIGN, (Object)0);
            } else {
                this.getModel().setValue(FIELD_DEDUCTION_RATE_SIGN, (Object)1);
            }
        }
    }

    private void changeTaxationSysValue() {
        this.getModel().setValue(BASE_FIELD_TAX_TYPE_SIGN, null);
    }

    private void changeTaxTypeValue() {
        DynamicObject taxTypeObject = (DynamicObject)this.getModel().getValue(BASE_FIELD_TAX_TYPE_SIGN);
        if (taxTypeObject == null) {
            this.getModel().setValue(BASE_FIELD_TAX_AREA_GROUP_SIGN, null);
        } else {
            List<Long> taxAreaGroupIds = this.getTaxAreaGroupIds();
            if (CollectionUtils.isEmpty(taxAreaGroupIds)) {
                this.getModel().setValue(BASE_FIELD_TAX_AREA_GROUP_SIGN, null);
            } else {
                this.getModel().setValue(BASE_FIELD_TAX_AREA_GROUP_SIGN, (Object)taxAreaGroupIds.get(0));
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (Stream.of(BASE_FIELD_TAXATION_SYS_SIGN, BASE_FIELD_TAX_TYPE_SIGN, BASE_FIELD_TAX_AREA_GROUP_SIGN).anyMatch(p -> p.equalsIgnoreCase(fieldKey))) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getModel().deleteEntryData("entryentity1");
                if (BASE_FIELD_TAXATION_SYS_SIGN.equalsIgnoreCase(fieldKey)) {
                    this.changeTaxationSysValue();
                } else if (BASE_FIELD_TAX_TYPE_SIGN.equalsIgnoreCase(fieldKey)) {
                    this.changeTaxTypeValue();
                }
                this.setInitValue();
            } else {
                this.getPageCache().put(CHANGE, "true");
                this.getModel().setValue(fieldKey, (Object)this.getPageCache().get(fieldKey));
            }
        }
    }

    private void setInitValue() {
        this.getModel().setValue("offsetlogo", (Object)false);
        this.getModel().setValue("deductible", (Object)false);
        this.getModel().setValue("impactcost", (Object)false);
        this.getModel().setValue(FIELD_DEFERRED_TAX_SIGN, (Object)false);
        this.getModel().setValue(FIELD_WITH_HOLDING_TAX_SIGN, (Object)false);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("valuenumber".equals(key)) {
            int row = this.getModel().getEntryCurrentRowIndex("entryentity1");
            String valuetype = (String)this.getView().getModel().getValue("valuetype", row);
            DynamicObject result = (DynamicObject)this.getView().getModel().getValue("result", row);
            String valuenumber = (String)this.getView().getModel().getValue("valuenumber", row);
            if (StringUtil.isEmpty((CharSequence)valuetype) || EmptyCheckUtils.isEmpty((Object)result)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ed3\u679c\u548c\u503c\u7c7b\u578b\u3002", (String)"TaxcodePlugin_7", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                return;
            }
            if ("0".equals(valuetype)) {
                DynamicObject dynamicObject = (DynamicObject)this.getView().getModel().getValue("valuesource", row);
                if (dynamicObject == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u503c\u6765\u6e90\u3002", (String)"TaxcodePlugin_8", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                    return;
                }
                String entity = dynamicObject.getString("id");
                this.openPage(row, entity, valuenumber);
            } else {
                this.getPageCache().put("currentrow", String.valueOf(row));
                this.openPage(row, BASTAX_VALUE_DIALOG, valuenumber);
                return;
            }
        }
    }

    private void openPage(int row, String entity, String value) {
        if (BASTAX_VALUE_DIALOG.equals(entity)) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId(entity);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BASTAX_VALUE_DIALOG));
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("valuenumber", value);
            this.getPageCache().put("currentrow", String.valueOf(row));
            parameter.setCustomParams(params);
            this.getView().showForm(parameter);
        } else {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setBillFormId(entity);
            FormConfig formConfig = FormMetadataCache.getListFormConfig((String)entity);
            if (ObjectUtils.isEmpty((Object)formConfig)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u6253\u5f00\u5f02\u5e38\u3002", (String)"TaxcodePlugin_9", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                return;
            }
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
            if (ObjectUtils.isEmpty((Object)entityType.getAlias())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u9009\u62e9\u57fa\u7840\u8d44\u6599\u7c7b\u578b\u7684\u8868\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaxcodePlugin_10", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtil.isNotEmpty((CharSequence)entity) && ("bd_taxrate".equals(entity) || "bd_minimumtax".equals(entity))) {
                DynamicObject taxationsys = (DynamicObject)this.getModel().getValue(BASE_FIELD_TAXATION_SYS_SIGN);
                DynamicObject taxtype = (DynamicObject)this.getModel().getValue(BASE_FIELD_TAX_TYPE_SIGN);
                DynamicObject taxareagroup = (DynamicObject)this.getModel().getValue(BASE_FIELD_TAX_AREA_GROUP_SIGN);
                if (EmptyCheckUtils.isEmpty((Object)taxationsys) || EmptyCheckUtils.isEmpty((Object)taxtype)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u540c\u65f6\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u548c\u7a0e\u79cd\u3002", (String)"TaxcodePlugin_11", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                    return;
                }
                List<Long> validIds = this.getValidDataId(taxationsys.getLong("id"), taxtype.getLong("id"), "1", taxareagroup, entity);
                QFilter idsFilter = new QFilter("id", "in", validIds);
                showParameter.getListFilterParameter().setFilter(idsFilter);
            }
            showParameter.setFormId(formConfig.getF7ListFormId());
            StyleCss css = new StyleCss();
            css.setWidth("960px");
            css.setHeight("580px");
            showParameter.getOpenStyle().setInlineStyleCss(css);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setShowTitle(false);
            showParameter.setMultiSelect(false);
            showParameter.setLookUp(true);
            showParameter.setCustomParam("selectaction", (Object)"doOpenParent");
            showParameter.setCustomParam("modeltype", (Object)"BaseFormModel");
            showParameter.setCustomParam("isShowAllNoOrg", (Object)"true");
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "valuenumber");
            showParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public List<Long> getValidDataId(Long taxationsysid, Long taxtypeid, String enanble, DynamicObject taxareagroup, String entity) {
        DynamicObject[] bd_taxationsys;
        ArrayList<Long> bids = new ArrayList<Long>(10);
        QFilter taxationsysFilter = new QFilter(BASE_FIELD_TAXATION_SYS_SIGN, "=", (Object)taxationsysid);
        QFilter taxtypeFilter = new QFilter("taxcategoryid", "=", (Object)taxtypeid);
        QFilter enableFilter = new QFilter("enable", "=", (Object)enanble);
        QFilter totalFilter = taxationsysFilter.and(taxtypeFilter).and(enableFilter);
        if (EmptyCheckUtils.isNotEmpty((Object)taxareagroup)) {
            QFilter taxareagroupFilter = new QFilter("taxarea", "=", taxareagroup.get("id"));
            totalFilter.and(taxareagroupFilter);
        }
        for (DynamicObject bd : bd_taxationsys = BusinessDataServiceHelper.load((String)entity, (String)"id,number,expdate", (QFilter[])new QFilter[]{totalFilter})) {
            bids.add(bd.getLong("id"));
        }
        return bids;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"valuenumber", (CharSequence)closedCallBackEvent.getActionId())) {
            ListSelectedRowCollection listDatas = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            if (!ObjectUtils.isEmpty((Object)listDatas) && listDatas.size() > 0) {
                EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity1");
                int[] indexs = entryGrid.getSelectRows();
                ListSelectedRow selectedRow = listDatas.get(0);
                this.getModel().setValue("valuenumber", (Object)selectedRow.getName(), indexs[0]);
                this.getModel().setValue("valueId", selectedRow.getPrimaryKeyValue(), indexs[0]);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)BASTAX_VALUE_DIALOG, (CharSequence)closedCallBackEvent.getActionId())) {
            Map result = (Map)closedCallBackEvent.getReturnData();
            if (result == null) {
                return;
            }
            String valuenumber = (String)result.get("valuenumber");
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity1");
            int[] indexs = entryGrid.getSelectRows();
            this.getModel().setValue("valuenumber", (Object)valuenumber, indexs[0]);
            this.getModel().setValue("valueId", (Object)valuenumber, indexs[0]);
        }
    }
}

