/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.taxorg;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bamp.bastax.common.constant.OrgConstant;
import kd.bamp.bastax.common.util.OrgUtils;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bamp.bastax.common.util.param.SystemParamUtil;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPools;
import org.apache.commons.lang3.ObjectUtils;

public class TaxOrgListPlugin
extends AbstractListPlugin {
    private static final String FILTERCONTAINERAP = "filtercontainerap";

    public void initialize() {
        super.initialize();
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl(FILTERCONTAINERAP);
        filterContainer.addFilterContainerInitListener(event -> this.filterContainerInit(event));
    }

    private void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
        if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
            List<String> visibleList = Arrays.asList("taxpayer", "istaxpayer", "unifiedsocialcode", "isvirtual", "status", "taxpayerdetail");
            filterContainerInitEvent.getSchemeFilterColumns().removeIf(column -> visibleList.contains(column.getFieldName()));
        } else {
            List<String> visibleList = Arrays.asList("entry_taxationsys.name", "entry_taxpayer", "entry_taxarea.fbasedataid.name", "entry_istaxpayer", "entry_unifiedsocialcode", "entry_applytaxtype.fbasedataid.name", "entry_status", "entry_taxpayerdetail");
            filterContainerInitEvent.getSchemeFilterColumns().removeIf(column -> visibleList.contains(column.getFieldName()));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String appid = (String)customParams.get("appid");
        List listColumns = args.getListColumns();
        if ("bastax".equals(appid)) {
            listColumns.removeIf(column -> "taxpayerdetail".equalsIgnoreCase(column.getListFieldKey()));
            listColumns.removeIf(column -> "entry_taxpayerdetail".equalsIgnoreCase(column.getListFieldKey()));
            args.setListColumns(listColumns);
        }
        if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
            List<String> visibleList = Arrays.asList("taxpayer", "istaxpayer", "unifiedsocialcode", "isvirtual", "status", "taxpayerdetail");
            listColumns.removeIf(column -> visibleList.contains(column.getListFieldKey()));
        } else {
            List<String> visibleList = Arrays.asList("entry_taxationsys.name", "entry_taxpayer", "entry_taxarea.name", "entry_istaxpayer", "entry_unifiedsocialcode", "entry_applytaxtype.name", "entry_status", "entry_taxpayerdetail");
            listColumns.removeIf(column -> visibleList.contains(column.getListFieldKey()));
        }
    }

    public void setFilter(SetFilterEvent e) {
        List list = OrgUnitServiceHelper.getAllOrgByViewNumber((String)"40", (boolean)false);
        List allQFilterList = e.getQFilters();
        if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
            Object status = null;
            for (QFilter qFilter2 : allQFilterList) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)qFilter2.getProperty(), (CharSequence)"status")) continue;
                status = qFilter2.getValue();
            }
            allQFilterList.removeIf(qFilter -> StringUtil.equalsIgnoreCase((CharSequence)qFilter.getProperty(), (CharSequence)"status"));
            if (null != status) {
                e.getQFilters().add(new QFilter("entryentity.entry_status", "=", status));
            }
        }
        QFilter viewOrgsQ = new QFilter("org", "in", (Object)list);
        e.getQFilters().add(viewOrgsQ);
    }

    public void afterCreateNewData(EventObject evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String appid = (String)customParams.get("appid");
        if (customParams.containsKey("nonematch") && Boolean.FALSE.equals(customParams.get("nonematch"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u201c\u540c\u6b65\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"TaxOrgListPlugin_8", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
        }
        if ("bastax".equals(appid)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblmaintaintaxinfo", "taxpayerdetail"});
        }
    }

    public void beforeBindData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        BillList billList = (BillList)this.getControl("billlistap");
        List filedList = billList.getShowListColumns().stream().map(row -> row.getListFieldKey()).collect(Collectors.toList());
        billList.addPackageDataListener(pkgEvt -> {
            String entryTaxpayerdetail;
            String taxpayerdetail;
            DynamicObject rowData = pkgEvt.getRowData();
            if (filedList.contains("taxpayerdetail") && "1".equals(taxpayerdetail = rowData.getString("taxpayerdetail"))) {
                rowData.set("taxpayerdetail", (Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"TaxOrgListPlugin_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            }
            if (filedList.contains("entry_taxpayerdetail") && "1".equals(entryTaxpayerdetail = rowData.getString("entryentity.entry_taxpayerdetail"))) {
                rowData.set("entryentity.entry_taxpayerdetail", (Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"TaxOrgListPlugin_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            }
        });
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"tblnew")) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("tctb_org_view_main");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowTitle(true);
            this.getView().showForm(showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"entry_enable")) {
            this.disAndEnableStatus(args, "1", ResManager.loadKDString((String)"\u6570\u636e\u5df2\u53ef\u7528\u3002", (String)"TaxOrgListPlugin_3", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"entry_disable")) {
            this.disAndEnableStatus(args, "0", ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7981\u7528\u3002", (String)"TaxOrgListPlugin_4", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"exportlist")) {
            if (SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u6a21\u677f\u201c\u7a0e\u52a1\u7ec4\u7ec7\u5217\u8868\u5bfc\u5165\u6a21\u677f\uff08\u542f\u7528\u6d77\u5916\u7a0e\uff09\u201d\u5bfc\u51fa\u3002", (String)"TaxOrgListPlugin_11", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), Integer.valueOf(6000));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u6a21\u677f\u201c\u7a0e\u52a1\u7ec4\u7ec7\u5217\u8868\u5bfc\u5165\u6a21\u677f\u201d\u5bfc\u51fa\u3002", (String)"TaxOrgListPlugin_12", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), Integer.valueOf(6000));
            }
        }
    }

    private void disAndEnableStatus(BeforeDoOperationEventArgs args, String status, String info) {
        FormOperate formOperate = (FormOperate)args.getSource();
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List entryPkIdList = selectedRows.stream().filter(row -> ObjectUtils.isNotEmpty((Object)row.getEntryPrimaryKeyValue())).map(row -> row.getEntryPrimaryKeyValue()).collect(Collectors.toList());
        ArrayList<Long> successEntryPkIdList = new ArrayList<Long>();
        ArrayList<Long> successPkIdList = new ArrayList<Long>();
        if (ObjectUtils.isNotEmpty(entryPkIdList)) {
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bastax_taxorg", (String)"entryentity.id as id ,entryentity.entry_status as status", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", entryPkIdList)});
            for (Object row2 : collection) {
                if (StringUtil.equalsIgnoreCase((CharSequence)row2.getString("status"), (CharSequence)status)) continue;
                successEntryPkIdList.add(row2.getLong("id"));
            }
        } else {
            List pkIdList = selectedRows.stream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toList());
            DynamicObjectCollection collection = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id,status", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIdList)});
            for (DynamicObject row3 : collection) {
                if (StringUtil.equalsIgnoreCase((CharSequence)row3.getString("status"), (CharSequence)status)) continue;
                successEntryPkIdList.add(row3.getLong("id"));
                successPkIdList.add(row3.getLong("id"));
            }
        }
        JSONObject extendJsonObject = new JSONObject();
        extendJsonObject.put("status", (Object)status);
        extendJsonObject.put("entryId", successEntryPkIdList);
        extendJsonObject.put("pkId", successPkIdList);
        extendJsonObject.put("selectedRows", (Object)selectedRows.size());
        formOperate.getOption().setVariableValue("extendParam", JSONObject.toJSONString((Object)extendJsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName}));
        if (selectedRows.size() == 1 && successEntryPkIdList.size() == 0) {
            this.getView().showTipNotification(info);
        } else if (selectedRows.size() - successEntryPkIdList.size() >= 1 && selectedRows.size() > 1) {
            ArrayList<String> errorInfos = new ArrayList<String>(16);
            OperationResult result = new OperationResult();
            result.setBillCount(selectedRows.size());
            result.setSuccessPkIds(new ArrayList(successEntryPkIdList));
            result.setSuccess(false);
            ArrayList<OperateErrorInfo> errorInfoes = new ArrayList<OperateErrorInfo>(8);
            result.setAllErrorInfo(errorInfoes);
            for (int i = 0; i < selectedRows.size() - successEntryPkIdList.size(); ++i) {
                errorInfos.add(info);
            }
            for (String msg : errorInfos) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setErrorLevel(ErrorLevel.Error.name());
                errorInfo.setMessage(msg);
                errorInfoes.add(errorInfo);
            }
            this.getView().showOperationResult(result);
        } else {
            this.getView().showSuccessNotification(StringUtil.equalsIgnoreCase((CharSequence)status, (CharSequence)"1") ? ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"TaxOrgListPlugin_5", (String)"bamp-bastax-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"TaxOrgListPlugin_6", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)"synctaxcorg", (CharSequence)key)) {
            this.syncTaxOrg();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"tblmaintaintaxinfo")) {
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TaxOrgListPlugin_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                return;
            }
            if (list.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u3002", (String)"TaxOrgListPlugin_2", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                return;
            }
            Long pkId = (Long)list.get(0).getPrimaryKeyValue();
            this.showTaxOrgInfo(pkId, key);
        } else if (StringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)"entry_enable") || StringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)"entry_disable")) {
            afterDoOperationEventArgs.getOperationResult();
            ((ListView)this.getView()).refresh();
        } else if (StringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)"refresh")) {
            // empty if block
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("taxpayerdetail".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Long pkv = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
            this.showTaxOrgInfo(pkv, fieldName);
        } else if ("org_number".equals(fieldName)) {
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Long pkv = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
            boolean exists = QueryServiceHelper.exists((String)"bastax_taxorg", (Object)pkv);
            if (!exists) {
                args.setCancel(true);
                BaseShowParameter param = new BaseShowParameter();
                HashMap<String, String> customParams = new HashMap<String, String>(4);
                String orgId = String.valueOf(pkv);
                customParams.put("listOrgId", orgId);
                customParams.put("cmborttypeId", this.getPageCache().get("cmborgtype_" + orgId));
                param.setFormId("bastax_taxorg");
                param.setCustomParams(customParams);
                param.getOpenStyle().setShowType(ShowType.NonModal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bastax_taxorg");
                param.setCloseCallBack(closeCallBack);
                this.getView().showForm((FormShowParameter)param);
            }
        } else if ("entry_taxpayerdetail".equals(fieldName)) {
            args.setCancel(true);
            BillList list = (BillList)this.getControl("billlistap");
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            Long pkv = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
            this.showTaxOrgInfo(pkv, fieldName);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        BillList list = (BillList)this.getControl("billlistap");
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        Long pkv = (Long)currentSelectedRowInfo.getPrimaryKeyValue();
        e.getParameter().getCustomParams().put("isOverseasTaxOrg", SystemParamUtil.isOverseasTaxOrg((Long)OrgUnitServiceHelper.getRootOrgId()));
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("taxOrgInfo".equals(actionId)) {
            DynamicObject[] dynamicObjects;
            Long returnData = (Long)evt.getReturnData();
            if (returnData != null && returnData > 0L && (dynamicObjects = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"id,taxpayerdetail", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)returnData)})) != null && dynamicObjects.length > 0) {
                DynamicObject dynamicObject = dynamicObjects[0];
                dynamicObject.set("taxpayerdetail", (Object)"1");
                SaveServiceHelper.update((DynamicObject)dynamicObject);
            }
        } else if ("bastax_taxorg".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showTaxOrgInfo(Long pkv, String operateKey) {
        DynamicObject dyo;
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRow selectedRowInfo = billlist.getCurrentSelectedRowInfo();
        Object entryPrimaryKeyValue = selectedRowInfo.getEntryPrimaryKeyValue();
        String taxationSys = String.valueOf(OrgConstant.CHN_TAXATIONSYS);
        if (ObjectUtils.isNotEmpty((Object)entryPrimaryKeyValue)) {
            dyo = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org.number,entryentity.entry_taxationsys.name,entryentity.entry_status,entryentity.entry_taxationsys.id", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "=", entryPrimaryKeyValue)});
            if ("tblmaintaintaxinfo".equals(operateKey) && StringUtil.equalsIgnoreCase((CharSequence)"0", (CharSequence)dyo.getString("entryentity.entry_status"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u5bf9\u5e94\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u672a\u542f\u7528\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"TaxOrgListPlugin_10", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), dyo.getString("org.number"), dyo.getString("entryentity.entry_taxationsys.name")));
                return;
            }
            taxationSys = dyo.getString("entryentity.entry_taxationsys.id");
        } else {
            dyo = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org.number,status", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)pkv)});
            if ("tblmaintaintaxinfo".equals(operateKey) && StringUtil.equalsIgnoreCase((CharSequence)"0", (CharSequence)dyo.getString("status"))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f\u672a\u542f\u7528\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"TaxOrgListPlugin_7", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), dyo.getString("org.number")));
                return;
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowTitle(true);
        showParameter.setCustomParam("listOrgId", (Object)pkv.toString());
        showParameter.setCustomParam("taxationsys", (Object)taxationSys);
        showParameter.setCustomParam("listFlag", (Object)true);
        showParameter.setFormId("tctb_tax_info_home");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taxOrgInfo");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void syncTaxOrg() {
        DispatchServiceHelper.invokeBizService((String)"bamp", (String)"bastax", (String)"TaxOrgLoadTaxviewService", (String)"saveData", (Object[])new Object[0]);
        this.getView().invokeOperation("refresh");
        if (OrgUtils.isSyncOldTaxView((String)"syncoldview")) {
            ThreadPools.executeOnce((String)"synOldTaxOrgViewOrg", this::synOldTaxOrgViewOrg);
        }
    }

    private void synOldTaxOrgViewOrg() {
        Map fromTreeMap = OrgUtils.getAllOrgByViewId((Long)OrgUtils.getDefaultViewSchemaInfoId());
        Map toTreeMap = OrgUtils.getAllOrgByViewId((Long)947076820862300160L);
        Set fromOrgIds = fromTreeMap.keySet();
        Set toOrgIds = toTreeMap.keySet();
        Map<String, String> fromOrgAndParentOrgMap = fromTreeMap.entrySet().stream().collect(Collectors.toMap(o -> (String)o.getKey(), o -> (String)((Map)o.getValue()).get("parentid"), (k1, k2) -> k1));
        Map<String, String> toOrgAndParentOrgMap = toTreeMap.entrySet().stream().collect(Collectors.toMap(o -> (String)o.getKey(), o -> (String)((Map)o.getValue()).get("parentid"), (k1, k2) -> k1));
        List deleteOrgIds = toOrgIds.stream().filter(orgId -> !fromOrgIds.contains(orgId)).collect(Collectors.toList());
        List addOrgIds = fromOrgIds.stream().filter(id -> !toOrgIds.contains(id)).collect(Collectors.toList());
        List editOrgIds = fromOrgAndParentOrgMap.entrySet().stream().filter(o -> !StringUtil.equals((CharSequence)((CharSequence)toOrgAndParentOrgMap.get(o.getKey())), (CharSequence)((CharSequence)o.getValue()))).map(o -> (String)o.getKey()).collect(Collectors.toList());
        ArrayList<OrgParam> delParamList = new ArrayList<OrgParam>(deleteOrgIds.size());
        deleteOrgIds.stream().forEach(id -> {
            long orgId = Long.parseLong(id);
            OrgParam orgParam = new OrgParam();
            orgParam.setDuty("10_taxc");
            orgParam.setId(orgId);
            delParamList.add(orgParam);
        });
        ArrayList<OrgParam> addAndEditList = new ArrayList<OrgParam>();
        addOrgIds.stream().forEach(id -> {
            long orgId = Long.parseLong(id);
            long parentId = Long.parseLong((String)fromOrgAndParentOrgMap.get(id));
            OrgParam orgParam = new OrgParam();
            TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
            OrgDutyView dutyView = new OrgDutyView();
            dutyView.setParentId(parentId);
            multiViewMap.put("10_taxc", dutyView);
            orgParam.setMultiViewMap(multiViewMap);
            orgParam.setId(orgId);
            orgParam.setParentId(parentId);
            addAndEditList.add(orgParam);
        });
        editOrgIds.stream().forEach(id -> {
            long orgId = Long.parseLong(id);
            long parentId = Long.parseLong((String)fromOrgAndParentOrgMap.get(id));
            OrgParam orgParam = new OrgParam();
            TreeMap<String, OrgDutyView> multiViewMap = new TreeMap<String, OrgDutyView>();
            OrgDutyView dutyView = new OrgDutyView();
            dutyView.setParentId(parentId);
            multiViewMap.put("10_taxc", dutyView);
            orgParam.setMultiViewMap(multiViewMap);
            orgParam.setId(orgId);
            orgParam.setParentId(parentId);
            addAndEditList.add(orgParam);
        });
        OrgUnitServiceHelper.deleteDuty(delParamList);
        OrgUnitServiceHelper.addOrUpdate(addAndEditList);
        this.showSaveResult(delParamList);
        this.showSaveResult(addAndEditList);
    }

    private void showSaveResult(List<OrgParam> paramList) {
        for (OrgParam orgParam : paramList) {
            if (orgParam.isSuccess()) continue;
            throw new KDBizException(orgParam.getMsg());
        }
    }
}

