/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.business.taxcorg;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import kd.bamp.bastax.business.taxcorg.TaxcOrgDao;
import kd.bamp.bastax.business.taxcorg.TaxcOrgService;
import kd.bamp.bastax.common.util.DyoToDtoUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;

public class TaxcOrgBusiness {
    private static final Log LOGGER = LogFactory.getLog(TaxcOrgBusiness.class);

    public static Boolean isTaxcOrgExistByOrgId(Long orgid, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(Collections.singletonList(orgid), (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.isExsitOrg(TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId));
    }

    public static Boolean isTaxcOrgExistByOrgIdAndIsTaxpayer(Long orgid, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(Collections.singletonList(orgid), (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.isExsitOrg(TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId));
    }

    public static Long queryTaxcOrgIdByOrgNum(String orgNum, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgNums(Collections.singletonList(orgNum), (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        DynamicObject result = TaxcOrgService.queryTaxcOrg(TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId));
        return DyoToDtoUtils.dyoToLong((DynamicObject)result, (String)"org.id");
    }

    public static DynamicObject queryTaxcOrgByOrgIdIsTaxpayer(Long orgId, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(Collections.singletonList(orgId), (Long)taxationsysId);
        DynamicObject[] taxpayerObjs = TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos = TaxcOrgService.filterOrgViewEnbale(dyos), taxationsysId);
        if (taxpayerObjs != null && taxpayerObjs.length > 0) {
            return taxpayerObjs[0];
        }
        return null;
    }

    public static DynamicObject queryTaxcOrgByOrgId(Long orgId, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(Collections.singletonList(orgId), (Long)taxationsysId);
        DynamicObject[] taxpayerObjs = TaxcOrgService.filterBillStatusAndStatus(dyos = TaxcOrgService.filterOrgViewEnbale(dyos), taxationsysId);
        if (taxpayerObjs != null && taxpayerObjs.length > 0) {
            return taxpayerObjs[0];
        }
        return null;
    }

    public static List<String> queryAllTaxcUnifiedsocialcode(Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgByQfilter(null, (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToStr((DynamicObject[])TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId), (String)"entryentity.entry_unifiedsocialcode");
    }

    public static List<String> queryTaxcUnifiedsocialcodeByOrgId(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(orgIds, (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToStr((DynamicObject[])TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId), (String)"entryentity.entry_unifiedsocialcode");
    }

    public static DynamicObject[] queryTaxcOrgByOrgIdAndIsTaxpayer(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(orgIds, (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId);
    }

    public static List<Long> queryTaxcOrgIdByOrgId(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(orgIds, (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId), (String)"org.id");
    }

    public static DynamicObject[] queryTaxcOrgByOrgId(List<Long> orgIds, Long taxationsysId, boolean isIncludeDisable) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(orgIds, (Long)taxationsysId);
        if (isIncludeDisable) {
            return dyos;
        }
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId);
    }

    public static List<Long> queryTaxcOrgIdByIsTaxpayer(Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgByQfilter(null, (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId), (String)"org.id");
    }

    public static List<Long> queryTaxOrgIdsByStatusAndIsvirtual(Boolean isEnable, Boolean isVirtual, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgByQfilter(null, (Long)taxationsysId);
        if (isEnable != null) {
            dyos = TaxcOrgService.filterBillStatusAndStatus(dyos, isEnable, taxationsysId);
        }
        if (isVirtual != null) {
            dyos = TaxcOrgService.filterIsVirtual(dyos, isVirtual);
        }
        return DyoToDtoUtils.dyoToLong((DynamicObject[])dyos, (String)"org.id");
    }

    public static List<Long> queryTaxcOrgIdByIsTaxpayer(Long taxationsysId, boolean isIncludeTaxationsys) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgByQfilter(null, (Long)taxationsysId, (boolean)isIncludeTaxationsys);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId, isIncludeTaxationsys), (String)"org.id");
    }

    public static DynamicObject[] queryTaxcOrgByOrgIdsAndIsTaxpayer(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(orgIds, (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId);
    }

    public static List<Long> queryTaxcOrgIdsByOrgIdsAndIsTaxpayer(List<Long> orgIds, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgIds(orgIds, (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcOrgService.filterIsTaxPayer(dyos, taxationsysId), (String)"org.id");
    }

    public static List<Long> queryTaxcOrgIdByUnifiedsocialcode(List<String> unifiedsocialcodes, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByUnifiedsocialcodes(unifiedsocialcodes, (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId), (String)"org.id");
    }

    public static DynamicObject[] queryTaxcOrgByUnifiedsocialcode(List<String> unifiedsocialcodes, Long taxationsysId) {
        DynamicObject[] docs = TaxcOrgDao.queryTaxcOrgFromDbByUnifiedsocialcodes(unifiedsocialcodes, (Long)taxationsysId);
        docs = TaxcOrgService.filterOrgViewEnbale(docs);
        return TaxcOrgService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static List<Long> queryAllTaxcOrgId(Long taxationsysId) {
        DynamicObject[] docs = TaxcOrgDao.queryTaxcOrgByQfilter(null, (Long)taxationsysId);
        docs = TaxcOrgService.filterOrgViewEnbale(docs);
        return DyoToDtoUtils.dyoToLong((DynamicObject[])TaxcOrgService.filterBillStatusAndStatus(docs, taxationsysId), (String)"org.id");
    }

    public static DynamicObject[] queryAllTaxcOrg(Long taxationsysId) {
        DynamicObject[] docs = TaxcOrgDao.queryTaxcOrgByQfilter(null, (Long)taxationsysId);
        docs = TaxcOrgService.filterOrgViewEnbale(docs);
        return TaxcOrgService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static DynamicObject[] queryTaxcOrgByOrgNum(List<String> orgNums, Long taxationsysId) {
        DynamicObject[] docs = TaxcOrgDao.queryTaxcOrgFromDbByOrgNums(orgNums, (Long)taxationsysId);
        docs = TaxcOrgService.filterOrgViewEnbale(docs);
        return TaxcOrgService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static Boolean isTaxcOrgExistByOrgNum(String orgNum, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByOrgNums(Collections.singletonList(orgNum), (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.isExsitOrg(TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId));
    }

    public static Long queryTaxcOrgIdByTaxpayer(String taxpayer, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByTaxpayers(Collections.singletonList(taxpayer), (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        DynamicObject result = TaxcOrgService.queryTaxcOrg(TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId));
        return DyoToDtoUtils.dyoToLong((DynamicObject)result, (String)"org.id");
    }

    public static DynamicObject queryTaxcOrgByTaxpayer(String taxpayer, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByTaxpayers(Collections.singletonList(taxpayer), (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.queryTaxcOrg(TaxcOrgService.filterBillStatusAndStatusAndIsTaxPayer(dyos, taxationsysId));
    }

    public static DynamicObject queryTaxcOrgByNsrmc(String taxpayer, Long taxationsysId) {
        DynamicObject[] dyos = TaxcOrgDao.queryTaxcOrgFromDbByTaxpayers(Collections.singletonList(taxpayer), (Long)taxationsysId);
        dyos = TaxcOrgService.filterOrgViewEnbale(dyos);
        return TaxcOrgService.queryTaxcOrg(TaxcOrgService.filterBillStatusAndStatus(dyos, taxationsysId));
    }

    public static DynamicObject[] queryTaxcOrgByIds(List<Long> ids, Long taxationsysId) {
        DynamicObject[] docs = TaxcOrgDao.queryTaxcOrgFromDbByIds(ids, (Long)taxationsysId);
        docs = TaxcOrgService.filterOrgViewEnbale(docs);
        return TaxcOrgService.filterBillStatusAndStatus(docs, taxationsysId);
    }

    public static DynamicObject[] queryTaxcOrgByIds(List<Long> ids) {
        DynamicObject[] docs = TaxcOrgDao.queryTaxcOrgFromDbByIds(ids, null);
        return docs;
    }

    public static boolean saveData(List<DynamicObject> saveTaxOrgList, Set<Long> orgIds) {
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            SaveServiceHelper.save((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"bastax_taxorg"), (Object[])saveTaxOrgList.toArray());
            TaxcOrgService.fireTaxOrgSyncEvent(orgIds);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            txHandle.markRollback();
            LOGGER.error("=======kd.bamp.bastax.business.taxcorg.TaxcOrgBusiness#saveData===error:{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            boolean bl = false;
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }
}

