/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.business.taxcorgan;

import java.util.List;
import kd.bamp.bastax.business.taxcorgan.TaxcOrganDao;
import kd.bamp.bastax.business.taxcorgan.TaxcOrganService;
import kd.bamp.bastax.common.constant.TaxcOrganConstant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TaxcOrganBusiness {
    public static DynamicObject[] queryFirstLevelTaxcOrganIds() {
        return TaxcOrganService.filterOneLevelOffice((DynamicObject[])TaxcOrganDao.queryTaxcOrganFromDB((String)TaxcOrganConstant.TAXC_BASE_QUERY_FIELDS));
    }

    public static DynamicObject getOneLevelTaxcOrganIdById(Long taxcOrganId) {
        DynamicObject obj = TaxcOrganDao.queryOneTaxcOrganFromDBById((String)TaxcOrganConstant.TAXC_BASE_QUERY_FIELDS, (Long)taxcOrganId);
        if (obj != null) {
            String longnumber = obj.getString(TaxcOrganConstant.LONGNUMBER);
            return TaxcOrganDao.queryOneTaxcOrganFromDBByNumber((String)TaxcOrganConstant.TAXC_BASE_QUERY_FIELDS, (String)longnumber.split("\\.")[0]);
        }
        return null;
    }

    public static DynamicObject[] getChildTaxcOrganIdsById(Long taxcOrganId) {
        DynamicObject obj = TaxcOrganDao.queryOneTaxcOrganFromDBById((String)TaxcOrganConstant.TAXC_BASE_QUERY_FIELDS, (Long)taxcOrganId);
        if (obj != null) {
            String number = obj.getString(TaxcOrganConstant.NUMBER);
            DynamicObject[] objs = TaxcOrganDao.queryTaxcOrganFromDB((String)TaxcOrganConstant.TAXC_BASE_QUERY_FIELDS);
            return TaxcOrganService.filterTaxcOfficeByNumber((DynamicObject[])objs, (String)number);
        }
        return null;
    }

    public static DynamicObject[] getChildTaxcOrganIdsByName(String name) {
        DynamicObject obj = TaxcOrganDao.queryOneTaxcOrganFromDBByName((String)TaxcOrganConstant.TAXC_BASE_QUERY_FIELDS, (String)name);
        if (obj != null) {
            String number = obj.getString(TaxcOrganConstant.NUMBER);
            DynamicObject[] objs = TaxcOrganDao.queryTaxcOrganFromDB((String)TaxcOrganConstant.TAXC_BASE_QUERY_FIELDS);
            return TaxcOrganService.filterTaxcOfficeByNumber((DynamicObject[])objs, (String)number);
        }
        return null;
    }

    public static DynamicObject[] getTaxcOrganByIds(List<Long> ids) {
        QFilter q = new QFilter(TaxcOrganConstant.ID, "in", ids);
        return BusinessDataServiceHelper.load((String)TaxcOrganConstant.ENTITYNAME, (String)TaxcOrganConstant.TAXC_BASE_QUERY_FIELDS, (QFilter[])new QFilter[]{q});
    }
}

