/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.core.bizrule.validate.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bd.gbs.core.bizrule.reposity.ValidateBizRuleService;
import kd.bd.gbs.core.bizrule.validate.validator.AbstractBizRuleBaseValidator;
import kd.bd.gbs.core.bizrule.validate.validator.BizValidateContext;
import kd.bd.gbs.core.bizrule.validate.validator.BizValidateFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class CommonValidatorOperationAction
extends AbstractOpBizRuleAction {
    private static final Log LOG = LogFactory.getLog(CommonValidatorOperationAction.class);
    private String entityNumber;
    private String operateKey;
    private String operateType;
    private BizValidateContext bizValidateContext;

    public void onAddValidators(AddValidatorsEventArgs event) {
        this.entityNumber = this.billEntityType.getName();
        this.operateKey = (String)this.operateMeta.get("key");
        this.operateType = (String)this.operateMeta.get("type");
        this.bizValidateContext = new BizValidateContext();
        this.getBizRuleList().forEach(bizruleBaseValidator -> event.addValidator((AbstractValidator)bizruleBaseValidator));
        LOG.info("entityNumber={} and applyOperation={}, validators is ={}", new Object[]{this.entityNumber, this.operateKey, event.getValidators()});
    }

    private List<AbstractBizRuleBaseValidator> getBizRuleList() {
        ArrayList<AbstractBizRuleBaseValidator> bizValidateList = new ArrayList<AbstractBizRuleBaseValidator>();
        Map<Object, DynamicObject> bizRuleMap = ValidateBizRuleService.getBizRuleList(this.entityNumber);
        bizRuleMap.forEach((pkId, bizRuleDy) -> {
            String applyOperation = bizRuleDy.getString("applyoperation");
            if (StringUtils.isEmpty((CharSequence)applyOperation)) {
                return;
            }
            if (StringUtils.isNotEmpty((CharSequence)this.operateKey) && !this.operateKey.equals(applyOperation)) {
                return;
            }
            DynamicObject bizRuleLibrary = bizRuleDy.getDynamicObject("bizrulelibrary");
            if (bizRuleLibrary == null) {
                LOG.warn("bizRuleLibrary is empty, bizRule number is{}", (Object)bizRuleDy.getString("number"));
                return;
            }
            if (!this.entityNumber.equals(bizRuleLibrary.getString("entity.id"))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5b9e\u4f53\u4e0e\u7ed1\u5b9a\u7684\u201c%2$s\u201d\u7684\u5b9e\u4f53\u4e0d\u4e00\u81f4\uff0c\u6821\u9a8c\u4e0d\u751f\u6548\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CommonValidatorOperationAction_0", (String)"bd-gbs-core", (Object[])new Object[0]), bizRuleDy.getString("name"), bizRuleLibrary.getString("name")));
            }
            bizValidateList.add(BizValidateFactory.getBizValidate(this.bizValidateContext, bizRuleLibrary, bizRuleDy.getInt("validateindex")));
        });
        return bizValidateList;
    }
}

