/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.core.bizrule.validate.validator;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bd.gbs.core.bizrule.validate.validator.AbstractBizRuleBaseValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BatchFieldFormatValidate
extends AbstractBizRuleBaseValidator {
    private static final Log LOG = LogFactory.getLog(BatchFieldFormatValidate.class);
    private static final String BD_GBS_CORE = "bd-gbs-core";
    private DynamicProperty property;
    private String fieldKey;
    private Pattern pattern;
    private String validatemsg;
    private boolean checknull;

    @Override
    public Set<String> preparePropertys() {
        Set<String> fields = super.preparePropertys();
        fields.add(this.bizRuleLibrary.getString("field"));
        return fields;
    }

    public void validate() {
        try {
            ExtendedDataEntity[] dataEntities;
            this.initData();
            for (ExtendedDataEntity extendedDataEntity : dataEntities = this.getDataEntities()) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                IDataEntityType entryentity = this.property.getParent();
                if (entryentity instanceof EntryType) {
                    DynamicObject entryDy;
                    int index;
                    if (entryentity instanceof SubEntryType) {
                        DynamicObjectCollection entryentityCol = dataEntity.getDynamicObjectCollection(entryentity.getParent().getName());
                        for (index = 0; index < entryentityCol.size(); ++index) {
                            entryDy = (DynamicObject)entryentityCol.get(index);
                            DynamicObjectCollection subEntryentityCol = entryDy.getDynamicObjectCollection(entryentity.getName());
                            int subIndex = 0;
                            for (DynamicObject subDy : subEntryentityCol) {
                                this.handleFieldPropFormat(subDy, extendedDataEntity, index, subIndex);
                                ++subIndex;
                            }
                        }
                        continue;
                    }
                    DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(entryentity.getName());
                    for (index = 0; index < dynamicObjectCollection.size(); ++index) {
                        entryDy = (DynamicObject)dynamicObjectCollection.get(index);
                        this.handleFieldPropFormat(entryDy, extendedDataEntity, index, -1);
                    }
                    continue;
                }
                this.handleFieldPropFormat(dataEntity, extendedDataEntity, -1, -1);
            }
        }
        catch (Exception e) {
            LOG.error("BatchFieldFormatValidate.error", (Throwable)e);
        }
    }

    private void initData() {
        EntityType entityType;
        this.fieldKey = this.bizRuleLibrary.getString("field");
        String level = this.bizRuleLibrary.getString("level");
        this.errorLevel = ErrorLevel.valueOf((int)Integer.parseInt(level));
        String expression = this.bizRuleLibrary.getString("expression");
        this.validatemsg = this.bizRuleLibrary.getString("validatemsg");
        EntityType mainEntityType = entityType = (EntityType)this.dataEntities[0].getDataEntity().getDataEntityType();
        while (mainEntityType.getParent() != null) {
            mainEntityType = (EntityType)mainEntityType.getParent();
        }
        this.property = (DynamicProperty)mainEntityType.findProperty(this.fieldKey);
        if (!(this.property instanceof TextProp)) {
            return;
        }
        this.checknull = this.bizRuleLibrary.getBoolean("checknull");
        if (StringUtils.isEmpty((CharSequence)this.validatemsg)) {
            this.validatemsg = String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BatchFieldFormatValidate_1", (String)BD_GBS_CORE, (Object[])new Object[0]), mainEntityType.findProperty(this.fieldKey).getDisplayName());
        }
        this.pattern = Pattern.compile(expression);
    }

    private void handleFieldPropFormat(DynamicObject subDy, ExtendedDataEntity extendedDataEntity, int entryEntityIndex, int subEntryIndex) {
        String fieldValue;
        Object value = this.property.getValue((Object)subDy);
        if (value instanceof ILocaleString) {
            fieldValue = value.toString();
        } else if (value instanceof String) {
            fieldValue = (String)value;
        } else {
            LOG.info("BatchFieldFormatValidate.value={}", value);
            fieldValue = null;
        }
        if (this.checkFieldFormat(fieldValue)) {
            return;
        }
        String errorMsg = this.validatemsg;
        if (this.property.getParent() instanceof EntryType) {
            EntryType entryType = (EntryType)this.property.getParent();
            if (entryType instanceof SubEntryType) {
                String entryName = entryType.getParent().getDisplayName().toString();
                String subEntryName = entryType.getDisplayName().toString();
                errorMsg = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u201c%2$s\u201d\u7b2c%3$s\u884c\uff0c\u201c%4$s\u201d\u7b2c%5$s\u884c\u3002", (String)"BatchFieldFormatValidate_0", (String)BD_GBS_CORE, (Object[])new Object[0]), this.validatemsg, entryName, entryEntityIndex + 1, subEntryName, subEntryIndex + 1);
            } else {
                errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7b2c%2$s\u884c\uff1a%3$s\u3002", (String)"BatchFieldFormatValidate_2", (String)BD_GBS_CORE, (Object[])new Object[0]), entryType.getDisplayName().toString(), entryEntityIndex + 1, this.validatemsg);
            }
        }
        this.addMessage(extendedDataEntity, errorMsg, this.errorLevel);
    }

    private boolean checkFieldFormat(String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            Matcher matcher = this.pattern.matcher(value);
            return matcher.matches();
        }
        return this.checknull;
    }
}

