/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.core.bizrule.validate.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bd.gbs.core.bizrule.validate.validator.AbstractBizRuleBaseValidator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.GeoPointProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.FieldPos;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.entity.validate.IValueComparator;
import kd.bos.entity.validate.ValidPromtType;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections4.CollectionUtils;

public class BatchFieldMustInputValidate
extends AbstractBizRuleBaseValidator {
    private static final Log LOG = LogFactory.getLog(BatchFieldMustInputValidate.class);
    private static final String BD_GBS_CORE = "bd-gbs-core";
    private DynamicProperty property;
    private String fieldKey;
    private String fieldName;
    private IValueComparator valueComparator;

    @Override
    public Set<String> preparePropertys() {
        Set<String> fields = super.preparePropertys();
        fields.add(this.bizRuleLibrary.getString("field"));
        return fields;
    }

    public void validate() {
        try {
            this.initData();
            for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                IDataEntityType entryentity = this.property.getParent();
                if (entryentity instanceof EntryType) {
                    DynamicObject entryDy;
                    int index;
                    if (entryentity instanceof SubEntryType) {
                        DynamicObjectCollection entryentityCol = dataEntity.getDynamicObjectCollection(entryentity.getParent().getName());
                        for (index = 0; index < entryentityCol.size(); ++index) {
                            entryDy = (DynamicObject)entryentityCol.get(index);
                            DynamicObjectCollection subEntryentityCol = entryDy.getDynamicObjectCollection(entryentity.getName());
                            int subIndex = 0;
                            for (DynamicObject subDy : subEntryentityCol) {
                                this.handleFieldProp(subDy, extendedDataEntity, index, subIndex);
                                ++subIndex;
                            }
                        }
                        continue;
                    }
                    DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection(entryentity.getName());
                    for (index = 0; index < dynamicObjectCollection.size(); ++index) {
                        entryDy = (DynamicObject)dynamicObjectCollection.get(index);
                        this.handleFieldProp(entryDy, extendedDataEntity, index, -1);
                    }
                    continue;
                }
                this.handleFieldProp(dataEntity, extendedDataEntity, -1, -1);
            }
        }
        catch (Exception e) {
            LOG.error("BatchFieldMustInputValidate.error", (Throwable)e);
        }
    }

    private void initData() {
        EntityType entityType;
        this.fieldKey = this.bizRuleLibrary.getString("field");
        String level = this.bizRuleLibrary.getString("level");
        this.errorLevel = ErrorLevel.valueOf((int)Integer.parseInt(level));
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        EntityType mainEntityType = entityType = (EntityType)dataEntities[0].getDataEntity().getDataEntityType();
        while (mainEntityType.getParent() != null) {
            mainEntityType = (EntityType)mainEntityType.getParent();
        }
        this.property = (DynamicProperty)mainEntityType.findProperty(this.fieldKey);
        this.fieldName = this.property.getDisplayName().toString();
        if (this.property instanceof IValidatorHanlder) {
            this.valueComparator = ((IValidatorHanlder)this.property).getValueComparator();
        }
    }

    private void handleFieldProp(DynamicObject dataEntity, ExtendedDataEntity extendedDataEntity, int entryEntityIndex, int subEntryIndex) {
        if (this.property instanceof BasedataProp) {
            this.property = ((BasedataProp)this.property).getCompareProp();
        }
        Object value = this.property.getValue((Object)dataEntity);
        boolean enableNull = this.property.isEnableNull();
        if (this.property instanceof GeoPointProp) {
            this.geoPointValidator(this.property.isEnableNull(), extendedDataEntity, entryEntityIndex, subEntryIndex);
            return;
        }
        if (this.property instanceof MuliLangTextProp) {
            this.handleMuliLangTextProp(extendedDataEntity, this.valueComparator, enableNull, value, entryEntityIndex, subEntryIndex);
        } else if (!(this.property instanceof MuliLangTextProp) && (!enableNull && this.valueComparator != null && this.valueComparator.compareValue(value) || enableNull && value == null)) {
            String content = this.buildErrMessage(entryEntityIndex, subEntryIndex);
            this.addMessage(extendedDataEntity, content, this.getErrorLevl());
        }
    }

    private void handleMuliLangTextProp(ExtendedDataEntity extDataEntity, IValueComparator valueComparator, boolean enableNull, Object value, int entryEntityIndex, int subEntryIndex) {
        List mustInputLang = this.validateContext.getMustInputLang();
        ArrayList<String> mustInputLan = new ArrayList<String>(5);
        if (CollectionUtils.isNotEmpty((Collection)mustInputLang)) {
            for (String lan : mustInputLang) {
                String valuelan;
                if (StringUtils.isBlank((Object)value)) {
                    this.addMessage(extDataEntity, this.buildErrMessage(entryEntityIndex, subEntryIndex), this.getErrorLevl());
                    continue;
                }
                if (value == null || !StringUtils.isBlank((CharSequence)(valuelan = (String)((ILocaleString)value).get((Object)lan))) || mustInputLan.contains(lan)) continue;
                mustInputLan.add(lan);
            }
            if (!mustInputLan.isEmpty()) {
                this.addMessage(extDataEntity, this.buildErrMessage(entryEntityIndex, subEntryIndex, mustInputLan), this.getErrorLevl());
            }
        } else if (!enableNull && valueComparator != null && valueComparator.compareValue(value) || enableNull && value == null) {
            this.addMessage(extDataEntity, this.buildErrMessage(entryEntityIndex, subEntryIndex), this.getErrorLevl());
        }
    }

    private void geoPointValidator(boolean enableNull, ExtendedDataEntity extDataEntity, int entryEntityIndex, int subEntryIndex) {
        GeoPointProp geoPointProp = (GeoPointProp)this.property;
        DecimalProp longitudeProp = geoPointProp.getLongitudeProp();
        Object longitudeValue = longitudeProp.getValue((Object)extDataEntity.getDataEntity());
        if (!enableNull && longitudeProp.getValueComparator().compareValue(longitudeValue) || enableNull && longitudeValue == null) {
            String content = this.buildErrMessage(entryEntityIndex, subEntryIndex);
            this.addMessage(extDataEntity, content, this.getErrorLevl());
        }
        DecimalProp latitudeProp = geoPointProp.getLatitudeProp();
        Object latitudeValue = latitudeProp.getValue((Object)extDataEntity.getDataEntity());
        if (!enableNull && latitudeProp.getValueComparator().compareValue(latitudeValue) || enableNull && latitudeValue == null) {
            String content = this.buildErrMessage(entryEntityIndex, subEntryIndex);
            this.addMessage(extDataEntity, content, this.getErrorLevl());
        }
        TextProp addressProp = geoPointProp.getAddressProp();
        Object addressValue = addressProp.getValue((Object)extDataEntity.getDataEntity());
        if (!enableNull && addressProp.getValueComparator().compareValue(addressValue) || enableNull && addressValue == null) {
            String content = this.buildErrMessage(entryEntityIndex, subEntryIndex);
            this.addMessage(extDataEntity, content, this.getErrorLevl());
        }
    }

    protected String buildErrMessage(int entryEntityIndex, int subEntryIndex) {
        String errorMsg;
        if (this.property.getParent() instanceof EntryType) {
            EntryType entryType = (EntryType)this.property.getParent();
            if (entryType instanceof SubEntryType) {
                String entryName = entryType.getParent().getDisplayName().toString();
                String subEntryName = entryType.getDisplayName().toString();
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\uff1a\u201c%2$s\u201d\u7b2c%3$s\u884c\uff0c\u201c%4$s\u201d\u7b2c%5$s\u884c\u3002", (String)"BatchFieldMustInputValidate_0", (String)BD_GBS_CORE, (Object[])new Object[0]), this.fieldName, entryName, entryEntityIndex + 1, subEntryName, subEntryIndex + 1);
            } else {
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\uff1a\u201c%3$s\u201d\u3002", (String)"BatchFieldMustInputValidate_1", (String)BD_GBS_CORE, (Object[])new Object[0]), entryType.getDisplayName().toString(), entryEntityIndex + 1, this.fieldName);
                String fieldTips = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"BatchFieldMustInputValidate_3", (String)BD_GBS_CORE, (Object[])new Object[0]), this.fieldName);
                FieldPos fieldPos = new FieldPos(entryType.getName(), entryEntityIndex, this.fieldKey, fieldTips, ValidPromtType.NOT_NULL.getType(), this.getValidatorId());
                fieldPos.setFullMsg(errorMsg);
                this.addPromptInfo(fieldPos);
            }
        } else {
            errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"BatchFieldMustInputValidate_3", (String)BD_GBS_CORE, (Object[])new Object[0]), this.fieldName);
            this.addPromptInfo(new FieldPos(this.fieldKey, errorMsg, ValidPromtType.NOT_NULL.getType(), this.getValidatorId()));
        }
        return errorMsg;
    }

    private String buildErrMessage(int entryEntityIndex, int subEntryIndex, List<String> langBillParams) {
        String errorMsg;
        String promptLang = ValidateContext.switchLang(langBillParams);
        if (this.property.getParent() instanceof EntryType) {
            EntryType entryType = (EntryType)this.property.getParent();
            if (entryType instanceof SubEntryType) {
                String entryName = entryType.getParent().getDisplayName().toString();
                String subEntryName = entryType.getDisplayName().toString();
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\uff1a\u201c%2$s\u201d\u7b2c%3$s\u884c\uff0c\u201c%4$s\u201d\u7b2c%5$s\u884c\u7684\u201c%6$s\u201d\u503c\u3002", (String)"BatchFieldMustInputValidate_5", (String)BD_GBS_CORE, (Object[])new Object[0]), this.fieldName, entryName, entryEntityIndex + 1, subEntryName, subEntryIndex + 1, promptLang);
            } else {
                errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7b2c%2$s\u884c\uff1a\u201c%3$s\u201d\u7684\u201c%4$s\u201d\u503c\u3002", (String)"BatchFieldMustInputValidate_4", (String)BD_GBS_CORE, (Object[])new Object[0]), entryType.getDisplayName().toString(), entryEntityIndex + 1, this.fieldName, promptLang);
                String fieldTips = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u503c\u3002", (String)"BatchFieldMustInputValidate_6", (String)BD_GBS_CORE, (Object[])new Object[0]), this.fieldName, promptLang);
                FieldPos fieldPos = new FieldPos(entryType.getName(), entryEntityIndex, this.fieldKey, fieldTips, ValidPromtType.NOT_NULL.getType(), this.getValidatorId());
                fieldPos.setFullMsg(errorMsg);
                this.addPromptInfo(fieldPos);
            }
        } else {
            errorMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%1$s\u201d\u7684\u201c%2$s\u201d\u503c\u3002", (String)"BatchFieldMustInputValidate_6", (String)BD_GBS_CORE, (Object[])new Object[0]), this.fieldName, promptLang);
            this.addPromptInfo(new FieldPos(this.fieldKey, errorMsg, ValidPromtType.NOT_NULL.getType(), this.getValidatorId()));
        }
        return errorMsg;
    }
}

