/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.core.bizrule.validate.validator;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import kd.bd.gbs.core.bizrule.validate.validator.AbstractBizRuleBaseValidator;
import kd.bd.gbs.core.bizrule.validate.validator.BatchFieldFormatValidate;
import kd.bd.gbs.core.bizrule.validate.validator.BatchFieldMustInputValidate;
import kd.bd.gbs.core.bizrule.validate.validator.BizValidateContext;
import kd.bd.gbs.core.common.constants.ValidateTypeEnum;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;

public class BizValidateFactory {
    private static final Map<String, String> serviceMap = ImmutableMap.builder().put((Object)ValidateTypeEnum.FORMAT_VALIDATE.getCode(), (Object)BatchFieldFormatValidate.class.getName()).put((Object)ValidateTypeEnum.MUST_INPUT_VALIDATE.getCode(), (Object)BatchFieldMustInputValidate.class.getName()).build();

    public static AbstractBizRuleBaseValidator getBizValidate(BizValidateContext bizValidateContext, DynamicObject bizRuleLibrary, int validateindex) {
        String validateType = Optional.ofNullable(bizRuleLibrary).map(it -> it.getString("validatetype")).orElse("");
        String serviceClass = serviceMap.get(validateType);
        if (StringUtils.isEmpty((CharSequence)serviceClass)) {
            serviceClass = bizRuleLibrary.getString("serviceclass");
        }
        AbstractBizRuleBaseValidator bizValidator = BizValidateFactory.getBizValidate(serviceClass);
        bizValidator.setBizValidateContext(bizValidateContext);
        bizValidator.setBizRuleLibrary(bizRuleLibrary);
        bizValidator.setSeq(validateindex);
        return bizValidator;
    }

    private static AbstractBizRuleBaseValidator getBizValidate(String serviceClass) {
        if (StringUtils.isEmpty((CharSequence)serviceClass)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u5339\u914d\u5230\u4e1a\u52a1\u6821\u9a8c\u89c4\u5219", (String)"BizValidateFactory_0", (String)"bd-gbs-core", (Object[])new Object[0]));
        }
        return (AbstractBizRuleBaseValidator)((Object)TypesContainer.createInstance((String)serviceClass));
    }
}

