/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.core.flow.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ZipTools {
    private static final Log logger = LogFactory.getLog(ZipTools.class);
    private static final String CHARSET_UTF8 = "UTF-8";

    private ZipTools() {
    }

    public static void zipStreams(List<ZipParam> lstParam, File zipFile) throws IOException {
        if (lstParam != null) {
            if (zipFile.exists()) {
                for (ZipParam param : lstParam) {
                    ZipTools.zip(zipFile, param);
                }
            } else {
                try (FileOutputStream fileOutputStream = new FileOutputStream(zipFile);
                     ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)fileOutputStream, Charset.forName(CHARSET_UTF8));
                     BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);){
                    for (ZipParam param : lstParam) {
                        ZipTools.zipStream(param, zipOutStream, bufferOutStream);
                    }
                    bufferOutStream.close();
                    zipOutStream.close();
                }
            }
        }
    }

    private static void zipStream(ZipParam param, ZipOutputStream zipOutStream, BufferedOutputStream bufferOutStream) throws IOException {
        String direct = param.direct;
        String path = StringUtils.isNotBlank((CharSequence)direct) ? direct + File.separator + param.name : param.name;
        ZipEntry entry = new ZipEntry(path);
        zipOutStream.putNextEntry(entry);
        BufferedInputStream bufferInputStream = new BufferedInputStream(param.stream);
        ZipTools.write(bufferInputStream, bufferOutStream);
        zipOutStream.closeEntry();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void zip(File zipFile, ZipParam sourceParam) throws IOException {
        if (zipFile.exists()) {
            File tempFile = new File(zipFile.getCanonicalPath() + ".tmp");
            try (FileOutputStream zipOutFileStream = new FileOutputStream(tempFile);
                 ZipFile zipOutFile = new ZipFile(zipFile);){
                boolean bRet;
                ZipEntry entry;
                ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)zipOutFileStream, StandardCharsets.UTF_8);
                BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);
                Enumeration<? extends ZipEntry> entries = zipOutFile.entries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    zipOutStream.putNextEntry(entry);
                    if (!entry.isDirectory()) {
                        ZipTools.write(zipOutFile.getInputStream(entry), bufferOutStream);
                    }
                    zipOutStream.closeEntry();
                }
                entry = new ZipEntry(sourceParam.name);
                zipOutStream.putNextEntry(entry);
                BufferedInputStream bufferInputStream = new BufferedInputStream(sourceParam.stream);
                ZipTools.write(bufferInputStream, bufferOutStream);
                bufferOutStream.close();
                zipOutStream.close();
                boolean flag = zipFile.delete();
                if (!flag || (bRet = tempFile.renameTo(zipFile))) return;
                logger.error("zip\u91cd\u547d\u540d\u5931\u8d25");
                return;
            }
        }
        try (FileOutputStream zipOutFileStream = new FileOutputStream(zipFile);){
            ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)zipOutFileStream, Charset.forName(CHARSET_UTF8));
            BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);
            ZipEntry entry = new ZipEntry(sourceParam.name);
            zipOutStream.putNextEntry(entry);
            BufferedInputStream bufferInputStream = new BufferedInputStream(sourceParam.stream);
            ZipTools.write(bufferInputStream, bufferOutStream);
            bufferOutStream.close();
            zipOutStream.close();
            return;
        }
    }

    public static void zip(File zipFile, File sourceFile) throws IOException {
        block64: {
            if (zipFile.exists()) {
                File tempFile = new File(zipFile.getCanonicalPath() + ".tmp");
                try (FileOutputStream outZipFile = new FileOutputStream(tempFile);
                     ZipFile zipOutFile = new ZipFile(zipFile);
                     FileInputStream inSourceFile = new FileInputStream(sourceFile);){
                    boolean bRet;
                    ZipEntry entry;
                    ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)outZipFile, Charset.forName(CHARSET_UTF8));
                    BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);
                    Enumeration<? extends ZipEntry> entries = zipOutFile.entries();
                    while (entries.hasMoreElements()) {
                        entry = entries.nextElement();
                        zipOutStream.putNextEntry(entry);
                        if (!entry.isDirectory()) {
                            ZipTools.write(zipOutFile.getInputStream(entry), bufferOutStream);
                        }
                        zipOutStream.closeEntry();
                    }
                    zipOutFile.close();
                    entry = new ZipEntry(sourceFile.getName());
                    zipOutStream.putNextEntry(entry);
                    BufferedInputStream bufferInputStream = new BufferedInputStream(inSourceFile);
                    ZipTools.write(bufferInputStream, bufferOutStream);
                    bufferOutStream.close();
                    zipOutStream.close();
                    boolean flag = zipFile.delete();
                    if (flag && !(bRet = tempFile.renameTo(zipFile))) {
                        logger.error("zip\u91cd\u547d\u540d\u5931\u8d25");
                    }
                    break block64;
                }
            }
            try (FileOutputStream outZipFile = new FileOutputStream(zipFile);
                 FileInputStream inSourceFile = new FileInputStream(sourceFile);){
                ZipOutputStream zipOutStream = new ZipOutputStream((OutputStream)outZipFile, Charset.forName(CHARSET_UTF8));
                BufferedOutputStream bufferOutStream = new BufferedOutputStream(zipOutStream);
                ZipEntry entry = new ZipEntry(sourceFile.getName());
                zipOutStream.putNextEntry(entry);
                BufferedInputStream bufferInputStream = new BufferedInputStream(inSourceFile);
                ZipTools.write(bufferInputStream, bufferOutStream);
                bufferOutStream.close();
                zipOutStream.close();
            }
        }
    }

    private static void write(InputStream inputStream, OutputStream outStream) throws IOException {
        byte[] data = new byte[4096];
        int length = 0;
        while ((length = inputStream.read(data)) != -1) {
            outStream.write(data, 0, length);
        }
        outStream.flush();
        inputStream.close();
    }

    public static class ZipParam {
        public String name;
        public boolean isfile;
        public InputStream stream;
        public String direct;
    }
}

