/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.core.kit.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.gbs.core.kit.util.HttpUtil;
import kd.bd.gbs.core.kit.util.KitConfigSingleton;
import kd.bos.context.RequestContext;
import kd.bos.crypto.impl.SM4GCMEncryptor;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;

public class SoftwareUsageTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SoftwareUsageTask.class);
    private static final String TOKENURL = "https://iam.cn-north-4.myhuaweicloud.com/v3/auth/tokens";
    private static final String USAGEURL = "https://mkt.myhuaweicloud.com/api/mkp-openapi-public/global/v2/license/software-usage-info";
    private static final String TOKENPARAM = "X-Auth-Token";
    private String NAME = "";
    private String P_WORD = "";

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        Object testLicense = paramMap.get("testLicense");
        String softwareUsageParam = "";
        if (StringUtils.isBlank((Object)testLicense)) {
            int act_num = 0;
            try {
                act_num = (Integer)DispatchServiceHelper.invokeBOSService((String)"ILoginUserService", (String)"getYdayOnlineUserNum", (Object[])new Object[0]);
            }
            catch (Exception e) {
                logger.error("Kit not found getYdayOnlineUserNum" + e.getMessage(), (Throwable)e);
                return;
            }
            logger.info("Kit act_num:{}", (Object)act_num);
            ArrayList<String> licenseList = new ArrayList(8);
            try {
                licenseList = (List)DispatchServiceHelper.invokeBOSService((String)"ILicenseService", (String)"getHuaWeiCodes", (Object[])new Object[0]);
            }
            catch (Exception e) {
                logger.error("Kit not found getHuaWeiCodes" + e.getMessage(), (Throwable)e);
                return;
            }
            logger.info("Kit licenselist:{}", licenseList);
            if (CollectionUtils.isEmpty(licenseList)) {
                return;
            }
            softwareUsageParam = this.buildSoftwareUsageParam(act_num, licenseList);
        } else {
            softwareUsageParam = JSON.toJSONString((Object)testLicense);
        }
        logger.info("Kit requestBody:{}", (Object)softwareUsageParam);
        String tokenParam = "";
        try {
            tokenParam = this.buildTokenParam();
        }
        catch (Exception e1) {
            logger.error("Kit buildTokenParam error" + e1.getMessage(), (Throwable)e1);
            return;
        }
        try {
            String tokenVal = HttpUtil.httpsRequestPost(TOKENURL, null, tokenParam, true);
            if (StringUtil.isEmpty((String)tokenVal)) {
                logger.info("Kit token is null tokenParam:" + tokenParam);
                return;
            }
            HashMap<String, String> usageTokenHeader = new HashMap<String, String>(2);
            usageTokenHeader.put(TOKENPARAM, tokenVal);
            HttpUtil.httpsRequestPost(USAGEURL, usageTokenHeader, softwareUsageParam, false);
        }
        catch (Exception e) {
            logger.error("Kit httpsRequestPost error" + e.getMessage(), (Throwable)e);
            return;
        }
    }

    private String buildSoftwareUsageParam(int act_num, List<String> licenseList) {
        JSONObject paramdata = new JSONObject();
        JSONArray usage_info = new JSONArray();
        JSONArray software_usage_Info = new JSONArray();
        JSONObject active_num = new JSONObject();
        active_num.put("active_num", (Object)act_num);
        software_usage_Info.add((Object)active_num);
        JSONObject license = new JSONObject();
        license.put("license", (Object)licenseList.get(0));
        license.put("software_usage_Info", (Object)software_usage_Info);
        usage_info.add((Object)license);
        paramdata.put("usage_info", (Object)usage_info);
        return paramdata.toJSONString();
    }

    private String buildTokenParam() throws Exception {
        if (StringUtil.isEmpty((String)this.NAME) || StringUtil.isEmpty((String)this.P_WORD)) {
            String xhsecretStart = "VGtWTk1VMUZXbEp";
            KitConfigSingleton kitConfig = KitConfigSingleton.getInstance();
            String xhsecretEnd = kitConfig.getXhsecret();
            String encString = kitConfig.getKitsecret();
            if (StringUtil.isEmpty((String)xhsecretEnd)) {
                throw new Exception("Kit xhsecretEnd is null!");
            }
            String encuuid = xhsecretStart + xhsecretEnd;
            String decUuidKey = new String(Base64.getDecoder().decode(encuuid.getBytes(StandardCharsets.UTF_8)));
            if (StringUtil.isEmpty((String)encString)) {
                throw new Exception("Kit Kitsecret is null!");
            }
            SM4GCMEncryptor encryptor = new SM4GCMEncryptor();
            String oriString = encryptor.decrypt(encString, decUuidKey, 128);
            String[] nameAndPassword = oriString.split(",");
            if (nameAndPassword != null && nameAndPassword.length > 1) {
                this.NAME = nameAndPassword[0];
                this.P_WORD = nameAndPassword[1];
            } else {
                throw new Exception("Kit nameAndPassword is error value:" + oriString);
            }
        }
        JSONObject authObj = new JSONObject();
        JSONObject identity = new JSONObject();
        JSONObject password = new JSONObject();
        JSONObject user = new JSONObject();
        JSONObject domain = new JSONObject();
        JSONObject scope = new JSONObject();
        JSONObject project = new JSONObject();
        project.put("name", (Object)"cn-north-4");
        scope.put("project", (Object)project);
        domain.put("name", (Object)this.NAME);
        user.put("name", (Object)this.NAME);
        user.put("domain", (Object)domain);
        user.put("password", (Object)this.P_WORD);
        password.put("user", (Object)user);
        JSONArray methods = new JSONArray();
        methods.add((Object)"password");
        identity.put("methods", (Object)methods);
        identity.put("password", (Object)password);
        authObj.put("identity", (Object)identity);
        authObj.put("scope", (Object)scope);
        JSONObject paramdata = new JSONObject();
        paramdata.put("auth", (Object)authObj);
        return paramdata.toJSONString();
    }
}

