/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gbs.core.kit.util;

import java.net.SocketTimeoutException;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    private static final Log logger = LogFactory.getLog(HttpUtil.class);
    public static final int READTIMEOUT = 30000;
    public static final int TIMEOUT = 15000;
    public static final String HEADERPARAM = "X-Subject-Token";
    public static final String UTF_8 = "utf-8";
    public static final String CONTENTTYPE = "application/json";

    public static String httpsRequestPost(String url, Map<String, String> header, String body, boolean isReqToken) throws Exception {
        CloseableHttpClient httpClient = null;
        HttpPost httpPost = null;
        String result = null;
        try {
            HttpEntity resEntity;
            httpClient = HttpClientBuilder.create().build();
            httpPost = new HttpPost(url);
            if (!"".equals(body) && body != null) {
                StringEntity se = new StringEntity(body, UTF_8);
                se.setContentType(CONTENTTYPE);
                httpPost.setEntity((HttpEntity)se);
            }
            if (header != null) {
                for (Map.Entry entry : header.entrySet()) {
                    httpPost.addHeader((String)entry.getKey(), (String)entry.getValue());
                    httpPost.addHeader("Content-Type", CONTENTTYPE);
                }
            }
            RequestConfig config = RequestConfig.custom().setConnectTimeout(15000).setConnectionRequestTimeout(15000).setSocketTimeout(30000).build();
            httpPost.setConfig(config);
            CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)httpPost);
            if (isReqToken) {
                Header headertoken = closeableHttpResponse.getFirstHeader(HEADERPARAM);
                return headertoken.getValue();
            }
            if (closeableHttpResponse != null && (resEntity = closeableHttpResponse.getEntity()) != null) {
                result = EntityUtils.toString((HttpEntity)resEntity, (String)UTF_8);
                logger.info("Kit API result:" + result);
            }
        }
        catch (SocketTimeoutException e) {
            logger.error("Kit API SocketTimeout:" + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
        catch (Exception ex) {
            logger.error("Kit API error: " + ex.getMessage(), (Throwable)ex);
            throw new Exception(ex);
        }
        return result;
    }
}

