/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.opplugin.pdm.mftbom;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bd.sbd.business.pdm.helper.MaterialHelper;
import kd.bd.sbd.utils.pdm.mftbom.DynamicObjDataUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class BOMSubmitValidator
extends AbstractValidator {
    private static final String MATERIAL = "material";
    private static final String MASTERID = "masterid";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final BigDecimal BIGDECIMAL_ONE = new BigDecimal("1");

    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (objs == null || objs.length <= 0) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if ("submit".equalsIgnoreCase(operate)) {
            for (ExtendedDataEntity obj : objs) {
                DynamicObject bom = obj.getDataEntity();
                if (bom == null) continue;
                String number = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)bom, (String)NUMBER);
                if (StringUtils.isBlank((CharSequence)number)) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201cBOM\u7f16\u7801\u201d\u3002", (String)"BOMSubmitValidator_25", (String)"bd-mpdm-opplugin", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject material = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)MATERIAL);
                if (bom.getDataEntityType().getProperties().containsKey((Object)"materialid")) {
                    material = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"materialid");
                }
                if (material == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u3002", (String)"BOMSubmitValidator_26", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                DynamicObject version = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"version");
                DynamicObject type = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)bom, (String)"type");
                if (type == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201cBOM\u7c7b\u578b\u201d\u3002", (String)"BOMSubmitValidator_27", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                Boolean isenablematerialversion = MaterialHelper.isEnableMaterialVersion((DynamicObject)material);
                Boolean isVersion = DynamicObjDataUtil.getDynamicObjectBooleanData((DynamicObject)type, (String)"isversion");
                if ((isenablematerialversion.booleanValue() || isVersion.booleanValue()) && version == null) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7248\u672c\u53f7\u201d\u3002", (String)"BOMSubmitValidator_28", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                DynamicObject versionMaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)version, (String)MATERIAL);
                Object materialMaster = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)material, (String)MASTERID);
                materialMaster = materialMaster instanceof DynamicObject ? ((DynamicObject)materialMaster).getPkValue() : material.getPkValue();
                if (!(versionMaterial == null || materialMaster != null && materialMaster.equals(versionMaterial.getPkValue()))) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ea7\u54c1\u7f16\u7801\u201c%1$s\u201d\u4e0d\u5b58\u5728\u7248\u672c\u53f7\u201c%2$s\u201d\u3002", (String)"BOMSubmitValidator_46", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)material, (String)NUMBER), DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)version, (String)NAME)));
                    continue;
                }
                boolean iscoproduct = DynamicObjDataUtil.getDynamicObjectBooleanData((DynamicObject)bom, (String)"iscoproduct");
                Object copentryObj = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)bom, (String)"copentry");
                DynamicObjectCollection copentrys = null;
                if (copentryObj instanceof DynamicObjectCollection) {
                    copentrys = (DynamicObjectCollection)copentryObj;
                }
                if ((copentrys == null || copentrys.isEmpty()) && iscoproduct) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u5df2\u52fe\u9009\u8054\u526f\u4ea7\u54c1\uff0c\u4ea7\u8054\u5173\u7cfb\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BOMSubmitValidator_30", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
                    continue;
                }
                if (copentrys != null) {
                    for (int i = 0; iscoproduct && i < copentrys.size(); ++i) {
                        DynamicObject entryversionMaterial;
                        DynamicObject copentry = (DynamicObject)copentrys.get(i);
                        Date copentryvaliddate = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)copentry, (String)"copentryvaliddate");
                        Date copentryinvaliddate = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)copentry, (String)"copentryinvaliddate");
                        if (copentryvaliddate != null && copentryinvaliddate != null && copentryvaliddate.after(copentryinvaliddate)) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ea7\u8054\u5173\u7cfb\u5206\u5f55\u7b2c%1$s\u884c,\u751f\u6548\u65e5\u671f\u201c%2$s\u201d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5931\u6548\u65e5\u671f\u201c%3$s\u201d\u3002", (String)"BOMSubmitValidator_47", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1, sdf.format(copentryinvaliddate), sdf.format(copentryvaliddate)));
                            continue;
                        }
                        String copentrytype = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copentry, (String)"copentrytype");
                        if (copentrytype == null) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ea7\u8054\u5173\u7cfb\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u4ea7\u54c1\u7c7b\u578b\u201d\u3002", (String)"BOMSubmitValidator_48", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                            continue;
                        }
                        DynamicObject copentrymaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copentry, (String)"copentrymaterial");
                        if (copentrymaterial == null) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ea7\u8054\u5173\u7cfb\u5206\u5f55\u7b2c%1$s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u7269\u6599\u7f16\u7801\u201d\u3002", (String)"BOMSubmitValidator_49", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                            continue;
                        }
                        if (copentrymaterial.getPkValue().equals(material.getPkValue()) && !"10740".equals(copentrytype)) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ea7\u8054\u5173\u7cfb\u5206\u5f55\u7b2c%1$s\u884c,\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u4e0e\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u91cd\u590d\u3002", (String)"BOMSubmitValidator_50", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1, DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copentrymaterial, (String)NUMBER)));
                            continue;
                        }
                        Object copentrymaterialMaster = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)copentrymaterial, (String)MASTERID);
                        DynamicObject copentrymaterialObj = copentrymaterial;
                        if (copentrymaterialMaster instanceof DynamicObject) {
                            copentrymaterialObj = (DynamicObject)copentrymaterialMaster;
                        }
                        DynamicObject copunit = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copentry, (String)"copentryunit");
                        DynamicObject baseunit = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copentrymaterialObj, (String)"baseunit");
                        if (copunit == null) {
                            copunit = baseunit;
                            copentry.set("copentryunit", (Object)copunit);
                        }
                        if (!copunit.getPkValue().equals(baseunit.getPkValue())) {
                            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ea7\u8054\u5173\u7cfb\u5206\u5f55\u7b2c%1$s\u884c,\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u4e0d\u5b58\u5728\u8ba1\u91cf\u5355\u4f4d\u201c%3$s\u201d\u3002", (String)"BOMSubmitValidator_51", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1, DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copentrymaterial, (String)NUMBER), DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copunit, (String)NAME)));
                            continue;
                        }
                        DynamicObject copentryversion = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copentry, (String)"copentryversion");
                        if (copentryversion == null || (entryversionMaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)copentryversion, (String)MATERIAL)) == null || (copentrymaterialMaster = copentrymaterialMaster instanceof DynamicObject ? ((DynamicObject)copentrymaterialMaster).getPkValue() : copentrymaterial.getPkValue()) != null && copentrymaterialMaster.equals(entryversionMaterial.getPkValue())) continue;
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u4ea7\u8054\u5173\u7cfb\u5206\u5f55\u7b2c%1$s\u884c,\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u4e0d\u5b58\u5728\u7248\u672c\u53f7\u201c%3$s\u201d\u3002", (String)"BOMSubmitValidator_52", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1, DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copentrymaterial, (String)NUMBER), DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)copentryversion, (String)NAME)));
                    }
                }
                this.entryValidate(bom, obj, material, sdf);
            }
        }
    }

    public void entryValidate(DynamicObject bom, ExtendedDataEntity obj, DynamicObject material, SimpleDateFormat sdf) {
        Object entryObj = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)bom, (String)"entry");
        DynamicObjectCollection entrys = null;
        if (entryObj instanceof DynamicObjectCollection) {
            entrys = (DynamicObjectCollection)entryObj;
        }
        if (entrys == null || entrys.isEmpty()) {
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BOMSubmitValidator_38", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), new Object[0]));
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            DynamicObject unit;
            DynamicObject entry = (DynamicObject)entrys.get(i);
            Date entryvaliddate = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)entry, (String)"entryvaliddate");
            Date entryinvaliddate = DynamicObjDataUtil.getDynamicObjectDateData((DynamicObject)entry, (String)"entryinvaliddate");
            if (entryvaliddate != null && entryinvaliddate != null && entryvaliddate.after(entryinvaliddate)) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u751f\u6548\u65e5\u671f\u201c%2$s\u201d\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u5931\u6548\u65e5\u671f\u201c%3$s\u201d\u3002", (String)"BOMSubmitValidator_54", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1, sdf.format(entryinvaliddate), sdf.format(entryvaliddate)));
                continue;
            }
            DynamicObject entrymaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrymaterial");
            if (entry.getDataEntityType().getProperties().containsKey((Object)"entrymaterialid")) {
                entrymaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entrymaterialid");
            }
            String entryType = entry.getString("entrytype");
            if (entrymaterial == null && "A".equals(entryType)) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u8bf7\u586b\u5199\u201c\u7ec4\u4ef6\u7f16\u7801\u201d\u3002", (String)"BOMSubmitValidator_55", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            if (entrymaterial != null && !this.bomVerValidate(obj, material, entrymaterial, entrymaterial, i, entryType)) continue;
            DynamicObjectCollection qtyentry = entry.getDynamicObjectCollection("qtyentry");
            DynamicObjectCollection setupentry = entry.getDynamicObjectCollection("setupentry");
            String entryqtytype = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entry, (String)"entryqtytype");
            BigDecimal entryqtydenominator = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entry, (String)"entryqtydenominator");
            BigDecimal entryqtynumerator = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entry, (String)"entryqtynumerator");
            BigDecimal entryscraprate = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)entry, (String)"entryscraprate");
            if (entryqtydenominator == null) {
                entryqtydenominator = BIGDECIMAL_ONE;
                entry.set("entryqtydenominator", (Object)entryqtydenominator);
            }
            if (entryqtynumerator == null) {
                entryqtynumerator = BIGDECIMAL_ONE;
                entry.set("entryqtynumerator", (Object)entryqtynumerator);
            }
            if ((unit = (DynamicObject)entry.get("entryunit")) == null) {
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u201c\u8ba1\u91cf\u5355\u4f4d\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BOMSubmitValidator_62", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                continue;
            }
            String precisionaccount = unit.getString("precisionaccount");
            int precision = unit.getInt("precision");
            RoundingMode mode = RoundingMode.UP;
            if ("1".equals(precisionaccount)) {
                mode = RoundingMode.HALF_UP;
            }
            if ("2".equals(precisionaccount)) {
                mode = RoundingMode.DOWN;
            }
            BigDecimal entryqty = entryqtynumerator.divide(entryqtydenominator, precision, mode);
            entry.set("entryqty", (Object)entryqty);
            if (StringUtils.isNotBlank((CharSequence)entryqtytype) && !"B".equalsIgnoreCase(entryqtytype) && "C".equalsIgnoreCase(entryqtytype)) {
                if (qtyentry == null || qtyentry.size() <= 0) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u7528\u91cf\u7c7b\u578b\u4e3a\u9636\u68af\u65f6,\u9636\u68af\u7528\u91cf\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BOMSubmitValidator_58", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (setupentry != null && setupentry.size() > 0) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u7528\u91cf\u7c7b\u578b\u4e3a\u9636\u68af\u65f6,\u5b89\u88c5\u4f4d\u7f6e\u5206\u5f55\u4e0d\u80fd\u5f55\u5165\u3002", (String)"BOMSubmitValidator_59", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
            }
            if (setupentry == null || setupentry.isEmpty()) continue;
            BigDecimal entrySumQty = BigDecimal.ZERO;
            for (DynamicObject setup : setupentry) {
                BigDecimal qty = DynamicObjDataUtil.getDynamicObjectBigDecimalData((DynamicObject)setup, (String)"setupentryqty");
                entrySumQty = entrySumQty.add(qty);
            }
            if (entrySumQty.compareTo(entryqty) <= 0) continue;
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u5b89\u88c5\u4f4d\u7f6e\u6570\u91cf\u4e4b\u548c\u5927\u4e8e\u603b\u6570\u91cf\u3002", (String)"BOMSubmitValidator_60", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1));
        }
    }

    private boolean bomVerValidate(ExtendedDataEntity obj, DynamicObject material, DynamicObject entrymaterial, DynamicObject entry, int i, String entryType) {
        DynamicObject entryversionMaterial;
        if ("B".equals(entryType)) {
            return true;
        }
        Object entrymaterialMaster = DynamicObjDataUtil.getDynamicObjectData((DynamicObject)entrymaterial, (String)MASTERID);
        entrymaterialMaster = entrymaterialMaster instanceof DynamicObject ? ((DynamicObject)entrymaterialMaster).getPkValue() : entrymaterial.getPkValue();
        if (entrymaterial != null && entrymaterial.getPkValue().equals(material.getPkValue())) {
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d\u4e0e\u201c\u4ea7\u54c1\u7f16\u7801\u201d\u91cd\u590d\u3002", (String)"BOMSubmitValidator_56", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1, DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entrymaterial, (String)NUMBER)));
            return false;
        }
        DynamicObject entryversion = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entry, (String)"entryversion");
        if (!(entryversion == null || (entryversionMaterial = DynamicObjDataUtil.getDynamicObjectDynamicObjectData((DynamicObject)entryversion, (String)MATERIAL)) == null || entrymaterialMaster != null && entrymaterialMaster.equals(entryversionMaterial.getPkValue()))) {
            this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7ec4\u4ef6\u5206\u5f55\u7b2c%1$s\u884c,\u7ec4\u4ef6\u7f16\u7801\u201c%2$s\u201d\u4e0d\u5b58\u5728\u7248\u672c\u53f7\u201c%3$s\u201d\u3002", (String)"BOMSubmitValidator_57", (String)"bd-mpdm-opplugin", (Object[])new Object[0]), i + 1, DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entrymaterial, (String)NUMBER), DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entryversion, (String)NAME)));
            return false;
        }
        return true;
    }
}

