/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class AuxPropUniqueValidator
extends AbstractValidator {
    public void validate() {
        try (TraceSpan span = Tracer.create((String)"AuxPropUnAuditValidator", (String)"checkReferences");){
            this.checkNumberAndNameUnique(this.dataEntities);
        }
    }

    private void checkNumberAndNameUnique(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String errMsg;
            DynamicObject auxProp = dataEntity.getDataEntity();
            String number = auxProp.getString("number");
            String name = auxProp.getString("name");
            Object pkValue = auxProp.getPkValue();
            QFilter qNumber = new QFilter("number", "=", (Object)number);
            QFilter qName = new QFilter("name", "=", (Object)name);
            QFilter qPkValue = new QFilter("id", "!=", pkValue);
            boolean existsNumber = QueryServiceHelper.exists((String)"bd_auxproperty", (QFilter[])new QFilter[]{qNumber, qPkValue});
            boolean existsName = QueryServiceHelper.exists((String)"bd_auxproperty", (QFilter[])new QFilter[]{qName, qPkValue});
            if (existsNumber) {
                errMsg = ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AuxPropUniqueValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errMsg);
            }
            if (!existsName) continue;
            errMsg = ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"AuxPropUniqueValidator_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errMsg);
        }
    }
}

