/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;

public class BizTypeSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.dataEntities) {
            boolean isPerset = entity.getDataEntity().getBoolean("ispreset");
            if (!isPerset) {
                DynamicObject billObj = entity.getDataEntity();
                DynamicObjectCollection entrys = billObj.getDynamicObjectCollection("billentity");
                this.checkSameBiztype(entrys, entity);
            }
            this.defLineTypeUniquenessChecking(entity);
        }
    }

    private void checkSameBiztype(DynamicObjectCollection col, ExtendedDataEntity entity) {
        if (null == col || col.size() == 0) {
            return;
        }
        TreeSet<Integer> indexs = new TreeSet<Integer>();
        boolean[] flag = new boolean[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject curUserEntity = ((DynamicObject)col.get(i)).getDynamicObject("billform");
            for (int j = i + 1; j < col.size(); ++j) {
                Object rowValue;
                Object curValue;
                DynamicObject rowEntity = ((DynamicObject)col.get(j)).getDynamicObject("billform");
                if (null == rowEntity || null == curUserEntity || flag[j] || !(curValue = curUserEntity.getPkValue()).equals(rowValue = rowEntity.getPkValue())) continue;
                indexs.add(j + 1);
                flag[j] = true;
            }
            if (indexs.size() <= 0) continue;
            indexs.add(i + 1);
            this.addMessage(entity, String.format(ResManager.loadKDString((String)"\u5173\u8054\u5355\u636e\u5217\u8868\uff1a\u7b2c %1$s \u884c\u5355\u636e\u91cd\u590d\u3002", (String)"BizTypeSaveValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]), indexs), ErrorLevel.Error);
            indexs.clear();
        }
    }

    private void defLineTypeUniquenessChecking(ExtendedDataEntity entity) {
        DynamicObjectCollection lineTypeEntrys = entity.getDataEntity().getDynamicObjectCollection("linetypeentry");
        int isDefaultCount = 0;
        for (DynamicObject lineTypeEntry : lineTypeEntrys) {
            boolean isDefault = lineTypeEntry.getBoolean("isdefault");
            if (!isDefault) continue;
            ++isDefaultCount;
        }
        if (lineTypeEntrys.size() > 0 && isDefaultCount == 0) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5173\u8054\u884c\u7c7b\u578b\u4e2d\u5fc5\u987b\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u7684\u5206\u5f55\u3002", (String)"BizTypeSaveValidator_2", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        } else if (lineTypeEntrys.size() > 0 && isDefaultCount > 1) {
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5173\u8054\u884c\u7c7b\u578b\u4e2d\u5fc5\u987b\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u7684\u5206\u5f55\u3002", (String)"BizTypeSaveValidator_3", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
    }
}

